<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    
    <!--  FILENAME: winMaxPasswordPolicy_SCAP.xsl   DATE: 16th Jan, 2013   AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winMaxPasswordPolicy_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED to verify Maximum Passoerd Policy - settings -->
    
    <!-- FOLLOWING ARE SOME OF THE TEST CASES FOR THE LIBRARY 
        Title - Account Lockout Policy: Account Lockout Threshold
    
    Pass:
    =====
    
    1. Password Age is set as expected. Password Age is currently set to value greater than the expected value.
        
    Fail:
    ===
    
    1. Password Age is currently set to 0. Password Age expected value is 0.
    2. Password Age is currently set to 0. Password Age expected value is greater than 0.
    3. Password Age is currently set to value greater than 0. Password Age expected value is 0.
    4. Password Age is currently set to value less than the expected value.
       
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="OvalResult"
    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="getPasswordParameterPrintableValue">
        <xsl:param name="numaricValue"/>
             <xsl:variable name="calculateValue">                            
                 <xsl:value-of select="number($numaricValue) div  number( 60 * 60 * 24 )"/>
             </xsl:variable>
             <xsl:value-of select="round($numaricValue)"/><xsl:text> seconds</xsl:text><xsl:text> (</xsl:text><xsl:value-of select="round($calculateValue)"/><xsl:text> days)</xsl:text>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
       
     <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
          </xsl:call-template>
    </xsl:template>
    

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion[1]">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:passwordpolicy_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:object/@object_ref"/>
                  
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>passwordpolicy_test</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
           </xsl:for-each>

        </xsl:variable>
        
        <xsl:if test="$def_result = 'false' or $def_result = 'true' ">

            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='passwordpolicy_test' ]">
                    <xsl:variable name="test" select="@id"/>
                    
                    <xsl:if test="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable != ''">
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">

                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="externalVarValue">
                                    <xsl:call-template name="getPasswordParameterPrintableValue">
                                        <xsl:with-param name="numaricValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable"/>
                                    </xsl:call-template>
                            </xsl:variable>
                            <xsl:variable name="inputValue">
                                <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable"/>
                            </xsl:variable>
                            <xsl:variable name="lockoutThresValue">
                                <xsl:call-template name="getPasswordParameterPrintableValue">
                                    <xsl:with-param name="numaricValue" select="$SystemData/win-sc:passwordpolicy_item[@id=$itemRef]/win-sc:max_passwd_age"/>
                                </xsl:call-template>
                            </xsl:variable>
                            
                            <xsl:variable name="isViolationValue">
                                <xsl:if test="$def_result = 'false' ">
                                    <xsl:text>true</xsl:text>
                                </xsl:if>
                                <xsl:if test="$def_result = 'true' ">
                                    <xsl:text>false</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                            <xsl:variable name="configName">
                                <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
                            </xsl:variable>
                            
                            <xsl:variable name="sysValue">
                                <xsl:value-of select="$lockoutThresValue"/>
                            </xsl:variable>
                            
                            <xsl:variable name="result1"
                                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
                            <xsl:variable name="result2"
                                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
                            
                            
                       <xsl:variable name="message_Id">
                           <xsl:choose>
                               <!-- When final result is Pass -->
                               <xsl:when test="$def_result = 'true'">
                                   <xsl:text>com.mcafee.pa.msg.winmaxpasswdagelessthansetting</xsl:text>
                               </xsl:when>

                               <!-- When final result is Fail -->
                               <xsl:when test="$def_result = 'false' and $result2='false' and $inputValue!=0">
                                   <xsl:text>com.mcafee.pa.msg.SysPassAgeZero_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2='false' and $inputValue=0">
                                   <xsl:text>com.mcafee.pa.msg.SysInputPassAgeZero_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2='true' and $result1='false' and $inputValue=0">
                                   <xsl:text>com.mcafee.pa.msg.InputPassAgeZero_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2='true' and $result1='false' and $inputValue!=0">
                                   <xsl:text>com.mcafee.pa.msg.winmaxpasswdagelessthansetting</xsl:text>
                               </xsl:when>
                           </xsl:choose>
                       </xsl:variable> 
                            
                            <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                                <instanceValue key="inputValue">
                                    <xsl:value-of select="$externalVarValue"/>
                                </instanceValue>
                                <instanceValue key="config">
                                    <xsl:value-of select="$configName"/>
                                </instanceValue>
                                <actualValue key="actualValue">
                                    <xsl:value-of select="$sysValue"/>
                                </actualValue>
                        </finding>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each>
            </findings>
         </xsl:if>     
    </xsl:template>
</xsl:stylesheet>