<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
       
        Criteria (and)
            Criteria ( or ) :  optional 
                Criterion : Registry test              ( Check Software is installed )
                ...one or more
                
                It will get the software name from the title so title should end with "is installed" or "installed" ..like
                
                <Software Name> is installed or  <Software Name> installed or <Software Name> Installed 
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
         <xsl:variable name="software">
             <xsl:if test="contains($title, ' is ' )">
                <xsl:value-of select="substring-before($title, ' is ' )"/>
             </xsl:if>
             <xsl:if test="contains($title, ' installed' )">
                 <xsl:value-of select="substring-before($title, ' installed' )"/>
             </xsl:if>
             <xsl:if test="contains($title, ' Installed' )">
                 <xsl:value-of select="substring-before($title, ' Installed' )"/>
             </xsl:if>
         </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' ">
            <xsl:call-template name="winSoftwareInstallationCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winSoftwareInstallationCheck">
        <xsl:param name="definitionId"/>       
        
         <xsl:variable name="title">
	             <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
                
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>                   
                                        
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>                                       
                    </xsl:element>
                </xsl:if>
        
            </xsl:for-each>                        
        </xsl:variable>
        
        
        
        
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">       
            
                       
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>                   
                    
                                                          
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>                               
                        <xsl:variable name="installedVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                        <xsl:variable name="installedVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$installedVersionStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionnotexist</xsl:text>                                    
                                </xsl:when>                                                                
                                <xsl:otherwise>                                
                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionreaderror</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue>
                            <instanceValue key="registry">
                                <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                            </instanceValue>
                        </finding>
                    </xsl:for-each>
                </xsl:for-each>
            
        </findings>
        
    </xsl:template>
</xsl:stylesheet>