<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        For which definition is this XSLT appilcable ?
        
        This is a modified version of  winSystemConfigurationCheck02_SCAP.xsl.
        
        Expected value is gathered from tested_variable of registry test and when the expected registry is not
        present, the value is set as Not Configured/Disabled and message is given as required configuration is
        not configured on the machine.
        
        This works for the logic  below:
        
        <criteria operator='AND'>
        <criterion negate='false' comment='Registry key HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Policies\System\MaxDevicePasswordFailedAttempts = External Variable' test_ref='oval:com.mcafee.oval:tst:228484' />
        <criterion comment='Account lockout threshold is not 0' test_ref='oval:com.mcafee.oval:tst:235065' /> - This is a lockoutpolicy_test
        </criteria>
        
        Corresponding txt is winSystemConfigurationCheck03_SCAP_xsl.txt
        
        One  of the supported def id's is :
        oval:com.mcafee.oval:def:229985
        
        Library has simple logic of getting title, expected value and system value from the check result.
     
    -->
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="expectedValue">
        <xsl:for-each
            select="xalan:nodeset($tests)/descendant::test">
            <xsl:variable name="test" select="@id"/>
            <xsl:for-each
                select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                <xsl:variable name="externalVarId" select="@variable_id"/>
                <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
            </xsl:for-each>
        </xsl:for-each>

        </xsl:variable>   
        <xsl:variable name="actualValue">
            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
            <xsl:choose>
                <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                    <xsl:value-of select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Not Configured/Disabled</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$expectedValue= '0'">
                    <xsl:text>com.mcafee.pa.msg.input_lckthsldsethshlzero_SCAP</xsl:text>                    
                </xsl:when>
                <xsl:when test="$expectedValue!= '' and $actualValue= '0' ">
                    <xsl:text>com.mcafee.pa.msg.output_lckthsldsethshlzero_SCAP</xsl:text>                    
                </xsl:when>
                <xsl:when test="$expectedValue!= '' and $actualValue!= '0'">
                    <xsl:text>com.mcafee.pa.msg.winconfiguration_SCAP</xsl:text>                    
                </xsl:when>
                    <xsl:when test="$expectedValue='' or $actualValue = '' ">
                        <xsl:text>com.mcafee.pa.msg.winnoconfiguration_SCAP</xsl:text>                 
                    </xsl:when>
            </xsl:choose>
        </xsl:variable>    
            
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <inputValue key="expectedValue">
                      <xsl:value-of select="$expectedValue"/>
                </inputValue>
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">                                                            
                   <instanceValue key="config">
                         <xsl:value-of select="$title"/>
                   </instanceValue>                                      
                <actualValue key="actualValue">
                          <xsl:value-of select="$actualValue"/>
                 </actualValue>
           </finding>
        </findings>
</xsl:template>
</xsl:stylesheet>