<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
    
    	This XSLT is used to verify the certain audit  setting against user input.
    	
        Criterio (and)
    	        citerion family test or extend def
    	        criterion  auditeventpolicysubcategories_test
        
    -->
    
        <xsl:variable name="Definitions"
           select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="Tests"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
        <xsl:variable name="TestedItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="CollectedObjects"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
        <xsl:variable name="SystemData"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:variable name="States"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
        <xsl:variable name="Objects"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
        <xsl:variable name="Variables"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
        <xsl:variable name="OvalResult"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    
    <xsl:template name="removeUnderScore">
        <xsl:param name="string"/>
        <xsl:param name="count"/>
        <xsl:param name="length"/>
        
        <xsl:if test="$count  &lt;= $length">
            
            <xsl:variable name="char">
                <xsl:value-of select="substring($string,$count,1)"/>
            </xsl:variable>
            
            <xsl:choose>
                <xsl:when test="$char != '_' ">
                    <xsl:value-of select="$char"/>
                    <xsl:call-template name="removeUnderScore">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>                  
                    <xsl:call-template name="removeUnderScore">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>          
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="getSuffixFormEventName">
        <xsl:param name="eventName"/>      
        
        <xsl:variable name="suffix1">
            <xsl:call-template name="removeUnderScore">
                <xsl:with-param name="string" select="$eventName"/>
                <xsl:with-param name="length" select="string-length($eventName)"/>
                <xsl:with-param name="count" select="1 + 0"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$suffix1"/>
    </xsl:template>
    
    <xsl:template name="getMessageId">
        <xsl:param name="eventName"/>
        
        <xsl:variable name="suffiex">
            <xsl:call-template name="getSuffixFormEventName">
                <xsl:with-param name="eventName" select="$eventName"/>                
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:if test="$suffiex != '' ">
            <xsl:value-of select="concat('com.mcafee.pa.msg.audit',$suffiex)"/>       
        </xsl:if>
    </xsl:template>
    
    <!--<possible_value hint="Failure only">AUDIT_FAILURE</possible_value>
    <possible_value hint="Success only">AUDIT_SUCCESS</possible_value>
    <possible_value hint="Success and Failure">AUDIT_SUCCESS_FAILURE</possible_value>
    <possible_value hint="None">AUDIT_NONE</possible_value>
    -->
    
  <xsl:template name="auditString">
      <xsl:param name="auditType"/>
          <xsl:choose>
              <xsl:when test="$auditType = '' ">
                  <xsl:text>Not Configured</xsl:text>
              </xsl:when>              
              <xsl:when test="$auditType = 'AUDIT_FAILURE' ">
                  <xsl:text>Failure (AUDIT_FAILURE)</xsl:text>
              </xsl:when>
              <xsl:when test="$auditType = 'AUDIT_SUCCESS' ">
                  <xsl:text>Success (AUDIT_SUCCESS)</xsl:text>
              </xsl:when>
              <xsl:when test="$auditType = 'AUDIT_SUCCESS_FAILURE' ">
                  <xsl:text>Failure, Success (AUDIT_SUCCESS_FAILURE)</xsl:text>
              </xsl:when>
              <xsl:when test="$auditType = 'AUDIT_NONE' ">
                  <xsl:text>None (AUDIT_NONE)</xsl:text>
              </xsl:when>                  
              <xsl:otherwise>
                  <xsl:text>unknown</xsl:text>
              </xsl:otherwise>
          </xsl:choose>    
  </xsl:template>
    

    
     <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:if test="$result='false' or $result='true'">
            <xsl:call-template name="winAuditEventCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template name="winAuditEventCheck">
        <xsl:param name="definitionId"/>       
        
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
            
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:auditeventpolicysubcategories_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:auditeventpolicysubcategories_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:auditeventpolicysubcategories_test[@id=$test]/win-def:state/@state_ref"/>
                
                    <xsl:variable name="auditpolicy_parameter">
                        <xsl:for-each select="$States/win-def:auditeventpolicysubcategories_state[@id=$state]/*">
                            <xsl:if test="position()=1">
                                <xsl:value-of select="name(.)"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    
                    <xsl:variable name="externalVar" select="$States/win-def:auditeventpolicysubcategories_state[@id=$state]/child::node()/@var_ref"/>
                    <xsl:variable name="operation" select="$States/win-def:auditeventpolicysubcategories_state[@id=$state]/child::node()/@operation"/>
                    <xsl:variable name="datatype" select="$States/win-def:auditeventpolicysubcategories_state[@id=$state]/child::node()/@datatype"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="auditpolicy_parameter">
                            <xsl:value-of select="$auditpolicy_parameter"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>auditevent</xsl:text>
                        </xsl:attribute>          
                </xsl:element>
               </xsl:if>
                
                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>            
            
        </xsl:variable>
  
  
        <xsl:variable name="exDefinitionId">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[@result = 'false'] ">
                <xsl:if test="./parent::node()/@result = 'false' ">
                    <xsl:element name="extend_definition">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@definition_ref"/>
                        </xsl:attribute>
                        <xsl:attribute name="result">
                            <xsl:value-of select="@result"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="rs_exDefinition">
            <xsl:value-of
                select="xalan:nodeset($exDefinitionId)/descendant::extend_definition/@result"/>
        </xsl:variable>
        
        <xsl:variable name="preCoditionStatus">
            <xsl:choose>
                <xsl:when test="$rs_exDefinition != '' ">
                    <xsl:value-of select="$rs_exDefinition"/>
                </xsl:when>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @testtype ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @testtype ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
    
         
            <xsl:if test=" $preCoditionStatus = 'true'">
                <!-- Added code to handle when test result is Pass  -->
                <xsl:variable name="fin_result"
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
                
                <xsl:choose>
                    <xsl:when test="$fin_result = 'true'">
                        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">         
                            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='auditevent' ]">
                                <xsl:variable name="test" select="@id"/>
                                <xsl:variable name="auditpolicy_parameter" select="@auditpolicy_parameter"/>
                                <xsl:variable name="externalVarId" select="@externalVar"/>
                                
                                <xsl:variable name="externalVarValue" 
                                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                
                                <inputValue key="inputAuditType">
                                    <xsl:call-template name="auditString">
                                        <xsl:with-param name="auditType"  select="$externalVarValue"/>
                                    </xsl:call-template>
                                </inputValue>
                                
                                <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                                    
                                    <xsl:variable name="itemRef" select="@item_id"/>
                                    <xsl:variable name="result" select="@result"/>
                                    
                                    
                                    <xsl:variable name="actualParameterValue">
                                        <xsl:for-each select="$SystemData/win-sc:auditeventpolicysubcategories_item[@id=$itemRef]/*">
                                            <xsl:if test="name() = $auditpolicy_parameter">
                                                <xsl:value-of select="text()"/>
                                            </xsl:if>    
                                        </xsl:for-each>
                                    </xsl:variable> 
                                    
                                    <xsl:variable name="actualParameterStatus">
                                        <xsl:if test="$actualParameterValue = '' ">
                                            <xsl:text>does not exist</xsl:text>
                                        </xsl:if>    
                                    </xsl:variable> 
                                    
                                    <xsl:variable name="message_id">
                                        <xsl:call-template name="getMessageId">
                                            <xsl:with-param name="eventName" select="$auditpolicy_parameter"/>
                                        </xsl:call-template>                               
                                    </xsl:variable>
                                    
                                    <finding messageId="{$message_id}" isViolation="false">                                                        
                                        <actualValue key="actualAuditType">
                                            <xsl:call-template name="auditString">
                                                <xsl:with-param name="auditType"  select="$actualParameterValue"/>
                                            </xsl:call-template>                                                                                                      
                                        </actualValue>                            
                                    </finding>
                                    
                                </xsl:for-each>
                            </xsl:for-each>
                        </findings>
                    </xsl:when>
                    
                    <!-- ================================================================================================  -->
                    
                    <xsl:otherwise>
                        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">         
                            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='auditevent' ]">
                                <xsl:variable name="test" select="@id"/>
                                <xsl:variable name="auditpolicy_parameter" select="@auditpolicy_parameter"/>
                                <xsl:variable name="externalVarId" select="@externalVar"/>
                                
                                <xsl:variable name="externalVarValue" 
                                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                
                                <inputValue key="inputAuditType">
                                    <xsl:call-template name="auditString">
                                        <xsl:with-param name="auditType"  select="$externalVarValue"/>
                                    </xsl:call-template>
                                </inputValue>
                                
                                <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                                    
                                    <xsl:variable name="itemRef" select="@item_id"/>
                                    <xsl:variable name="result" select="@result"/>
                                    
                                    
                                    <xsl:variable name="actualParameterValue">
                                        <xsl:for-each select="$SystemData/win-sc:auditeventpolicysubcategories_item[@id=$itemRef]/*">
                                            <xsl:if test="name() = $auditpolicy_parameter">
                                                <xsl:value-of select="text()"/>
                                            </xsl:if>    
                                        </xsl:for-each>
                                    </xsl:variable> 
                                    
                                    <xsl:variable name="actualParameterStatus">
                                        <xsl:if test="$actualParameterValue = '' ">
                                            <xsl:text>does not exist</xsl:text>
                                        </xsl:if>    
                                    </xsl:variable> 
                                    
                                    <xsl:variable name="message_id">
                                        <xsl:call-template name="getMessageId">
                                            <xsl:with-param name="eventName" select="$auditpolicy_parameter"/>
                                        </xsl:call-template>                               
                                    </xsl:variable>
                                    
                                    <finding messageId="{$message_id}" isViolation="true">                                                        
                                        <actualValue key="actualAuditType">
                                            <xsl:call-template name="auditString">
                                                <xsl:with-param name="auditType"  select="$actualParameterValue"/>
                                            </xsl:call-template>                                                                                                      
                                        </actualValue>                            
                                    </finding>
                                    
                                </xsl:for-each>
                            </xsl:for-each>
                        </findings>
                    </xsl:otherwise>
                </xsl:choose>
                <!-- ================================================================================================  -->
           </xsl:if>
        
    </xsl:template>
</xsl:stylesheet>