<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        For which definition is this XSLT appilcable ?
        
        This is a modified version of  winSystemConfigurationCheck02_SCAP.xsl.
        
        Here expected and actual values of 0 is same as other numeric values of Enable.
        
        This works for the logic  below:
        
        <criteria operator="AND">
        <criteria operator="OR">
        <criteria operator="AND">
        <criterion comment="External Variable = Disabled / Not Configured" negate="false" test_ref="oval:com.mcafee.oval:tst:232547"/>
        <criterion comment="Registry key HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\PeerDist\Retrieval\SegmentTTL does not exist" negate="true" test_ref="oval:com.mcafee.oval:tst:232548"/>
        </criteria>
        <criteria operator="AND">
        <criterion comment="Registry key HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\PeerDist\Retrieval\SegmentTTL = variable" negate="false" test_ref="oval:com.mcafee.oval:tst:232549"/>
        </criteria>
        </criteria>
        </criteria>
        
        Corresponding txt is winSystemConfigurationCheck02_SCAP_xsl.txt
        
        One  of the supported def id's is :
        oval:com.mcafee.oval:def:229992
        
        Library has simple logic of getting title, expected value and system value from the check.
     
    -->
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    
    <xsl:template name="getExternalVariablePrintableValue">
        <xsl:param name="id"/>
        <xsl:param name="numaricValue"/>
        
        <xsl:variable name="value">
            <xsl:value-of select="normalize-space($numaricValue)"/>    
        </xsl:variable>
        
        <xsl:variable name="printableValue">
            <xsl:for-each
                select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_value">
                <xsl:if test="text() = $numaricValue">
                    <xsl:value-of select="@hint"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="printableValueRange">
            <xsl:for-each
                select="$Variables/oval-def:external_variable[@id = $id]/descendant::oval-def:possible_restriction">
                <xsl:value-of select=" substring-before(@hint,'. Range')"/>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="formattedNumaricValue">
            <xsl:choose> 
                <xsl:when test="$value = ''  ">
                    <xsl:text>Not Configured/Disabled</xsl:text>                    
                </xsl:when>
                <xsl:when test="$printableValue != '' ">
                    <xsl:value-of select="concat($printableValue, '(' , $value , ')' )"/>
                </xsl:when>
                <xsl:when test="$printableValueRange != '' ">
                    <xsl:value-of select="concat($printableValueRange, '(' , $value , ')' )"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$value"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <xsl:value-of select="$formattedNumaricValue"/>
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="message_id">
               <xsl:text>com.mcafee.pa.msg.winconfig_SCAP</xsl:text>
        </xsl:variable>
        
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                 <xsl:variable name="expectedValue">
                    <xsl:call-template name="getExternalVariablePrintableValue">
                         <xsl:with-param name="id" select="$SystemData/ind-sc:variable_item/ind-sc:var_ref/text()"  />
                         <xsl:with-param name="numaricValue" select="$SystemData/ind-sc:variable_item/ind-sc:value"/>
                     </xsl:call-template>
                </xsl:variable>
                        
                <inputValue key="expectedValue">
                      <xsl:value-of select="$expectedValue"/>
                </inputValue>
                <xsl:variable name="actualValue">
                      <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
                      <xsl:choose>
                           <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                               <xsl:call-template name="getExternalVariablePrintableValue">
                                   <xsl:with-param name="id" select="$SystemData/ind-sc:variable_item/ind-sc:var_ref/text()"  />
                                   <xsl:with-param name="numaricValue" select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value"/>
                               </xsl:call-template>
                           </xsl:when>
                          <xsl:otherwise>
                              <xsl:text>Not Configured/Disabled</xsl:text>
                          </xsl:otherwise>
                          </xsl:choose>
               </xsl:variable>

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">                                                            
                   <instanceValue key="config">
                         <xsl:value-of select="$title"/>
                   </instanceValue>                                      
                <actualValue key="actualValue">
                          <xsl:value-of select="$actualValue"/>
                 </actualValue>
           </finding>
        </findings>
</xsl:template>
</xsl:stylesheet>