#!/bin/bash
# 
# This script is executed by cron to check to see if naimas32 is running
# If naimas32 isn't running, this script will restart it

PROGROOT=/opt/NETAepoagt
PIDOF=`pidof naimas32`
export LD_LIBRARY_PATH=/opt/NETAepoagt/lib

if [ -f /etc/rc.d/init.d/functions ]
then
    . /etc/rc.d/init.d/functions
else
    echo "Functions not available for this script! Exiting!"
    exit 1
fi

if [ -z "${PIDOF}" ]
then
    initlog --string="Linux Agent was dead. Linux Agent has been restarted by cron. naimas32 startup" --name=(ale) --event=1
    daemon ${PROGROOT}/bin/naimas32
fi
