#!/bin/bash

if [ -d /opt/NETAepoagt ]
then 
	echo "detected previous install... (removing)..."
	/bin/rpm -e --allmatches ALE >/dev/null 2>&1
fi

if ( /usr/sbin/userdel ALEusr >/dev/null 2>&1 )
then 
		/usr/sbin/adduser -c"EPO Agent user" -M -r -n -g root -s /bin/false ALEusr
else
		/usr/sbin/adduser -c"EPO Agent user" -M -r -n -g root -s /bin/false ALEusr
fi

echo "Preparing to Install ALE";
if [ ! -f ./ALE/ale.rpm ]
then
	mv ./ALE/ale* ./ALE/ale.rpm
fi

/bin/rpm -i --force ./ALE/ale.rpm

if [ -f ./ALE/siteinfo.ini ]
then
	cp ./ALE/siteinfo.ini /opt/NETAepoagt/
	echo "Siteinfo.ini has been copied"
		
	if [ -f ./ALE/Uninst.sh ]
	then
		cp ./ALE/Uninst.sh /opt/NETAepoagt/
	fi
		
	if [ ! -d /opt/NETAepoagt/AgentDB/Event ]
	then
		ln -s /logs/events /opt/NETAepoagt/AgentDB/Event
	fi
	
#	echo "Generate the Registry keys"
#	/opt/NETAepoagt/bin/keys

####################################################
#
#   This is restarted in the UDSlog script
#   system("kill -SIGHUP "cat /var/run/syslogd.pid");	

	echo "Update /etc/syslog.conf"
	/opt/NETAepoagt/bin/UDSlog -i

	echo "Copy our init script to /etc/rc.d/init.d"
	cp -p /opt/NETAepoagt/bin/ale /etc/rc.d/init.d

####################################################
#
# We'll now depend upon crond seeing the mtime change
# and add our cron task to the cron file
# I've added the touch command so that when crond
# looks at the /etc/cron.d directory, it will then
# check all mtimes of files that exist in this dir
# and load any file that has an mtime that has changed
# SLI 02/25/02

	cp -p /opt/NETAepoagt/bin/aled /etc/cron.d
	touch /etc/cron.d
	
	echo "Set it's run level"
	/sbin/chkconfig --level 35 ale on
	
	echo "/etc/rc.d/init.d/ale start"
	/etc/rc.d/init.d/ale start

#####################################################
#
#  This is a part of hotfix 1 
#  As per Graham Clarke we've taken out the cron
#  stuff. I'll talk to Swade and see if we need
#  the aled in the /etc/cron.d and just let
#  cron start it when the machine starts.
#  SLI - 02/21/02
#	/etc/rc.d/init.d/crond restart
	
else
	echo "siteinfo.ini not found, you must create one manually"	
fi



