
-- AutoClose property of ePO databases should always be cleared.
exec sp_dboption N'SERVERNAME_ePO', N'autoclose', N'false'
GO

-- Patch 6 modifies AVISP_FilterVAlertGroupsSubreport stored procedure.
-- BZ159930
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- Custom Group Data subreports


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreport]
GO

-----------------------------------------------------------------------------
-- Patch 6 modifies software table to remove bogus PATCH___1000 version that was never released.
-- BZ202698
-- This script was written by the SCP team (Damon Gallaty)
-----------------------------------------------------------------------------
IF EXISTS (SELECT * FROM Software WHERE ProductCode = 'PATCH___1000' AND (SoftwareName = '' OR SoftwareName IS NULL))
BEGIN
DELETE Software WHERE ProductCode = 'PATCH___1000'
END
GO

-----------------------------------------------------------------------------

CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
 ,@szNameSpaceName  VARCHAR(100)
 ,@szNameSpaceNode  VARCHAR(500)
 ,@szOptionalReportParms  VARCHAR(500) = ''
 ,@szGroup1 varchar(100) = ''
 ,@szGroupValue1 varchar(100) = ''
 ,@szGroup2 varchar(100) = ''
 ,@szGroupValue2 varchar(100) = ''
 ,@szGroup3 varchar(100) = ''
 ,@szGroupValue3 varchar(100) = ''
 ,@szGroup4 varchar(100) = ''
 ,@szGroupValue4 varchar(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @EventType varchar(50) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@EventType) != 'all'
	and lower(@EventType) != 'notinfection'
	and lower(@EventType) != 'infection'
	and lower(@EventType) != 'Infection-Res'
	and lower(@EventType) != 'Infection-Unr'
	and lower(@EventType) != 'Infection-Cle'
	and lower(@EventType) != 'Infection-Del'
	and lower(@EventType) != 'Infection-Mov'
		 Set @Inputlegal = 0

 -- translate webshield groupnames into actual event fieldname
 Declare @Webshield int
 Set @Webshield = 0
 if lower(@EventType) = 'contentfilter'
	or lower(@EventType) = 'contentscanning'
	or lower(@EventType) = 'spam'
	or lower(@EventType) = 'urlblocked'
	or lower(@EventType) = 'virus'
 Begin
	Set @Webshield = 1
	if @szGroup1 = 'RuleName'
		Set @szGroup1 = 'VirusName'
	if @szGroup2 = 'RuleName'
		Set @szGroup2 = 'VirusName'
	if @szGroup3 = 'RuleName'
		Set @szGroup3 = 'VirusName'
	if @szGroup4 = 'RuleName'
		Set @szGroup4 = 'VirusName'
	if @szGroup1 = 'Server'
		Set @szGroup1 = 'HostName'
	if @szGroup2 = 'Server'
		Set @szGroup2 = 'HostName'
	if @szGroup3 = 'Server'
		Set @szGroup3 = 'HostName'
	if @szGroup4 = 'Server'
		Set @szGroup4 = 'HostName'
	if @szGroup1 = 'Spammer'
		Set @szGroup1 = 'UserName'
 End


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node (done in main routine)
 --select distinct AgentGUID
 --into #LostLinksEvents
 --from Events
 --	where AgentGUID not in (select AgentGUID from leafnode)
  

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- strip top10 suffix if present
	if substring(@EventType, 1, 5) = 'T10Vr' 
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	else if substring(@EventType, 1, 5) = 'T10Fl' 
		Set @EventType = Replace( @EventType, 'T10Fl', '')
	else if substring(@EventType, 1, 5) = 'T10Ur' 
		Set @EventType = Replace( @EventType, 'T10Ur', '')
	else if substring(@EventType, 1, 5) = 'T10Cp' 
		Set @EventType = Replace( @EventType, 'T10Cp', '')

   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  -- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)  	
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50) 
	Declare @szAgentType	varchar(50) 
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(255) 
	Declare	@szVirusSubType varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = ''  
	Set @szVirusSubType = ''

   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					@szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		-- coverage data 
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion output
						,@szLicensed output
						,@szConnectStatus output 
						,@szAgentType	output
						,@szOSType output
						,@szOSPlatform output
						,@szVirusType output
						,@szFullProductName output
						,@szEngineDat output
						,@szDatExtraDat output
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubType OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	



---------------------------------------------------------------
-- Do not use outer joins here
-- if the group is on a field partiipating in an outer join not only will the fields matching value be returned but all outerjoin rows (null values) as well
-- too much data gets sent.

-- avoid outer join on eventdesc table: if no match then row wont be returned - too little data returned
-- keep outer join in actiodesc & virustype ion events are caught
-- note: missing entries in EventFilterDescFast will result in rows not being returned



--select @szGroupActionTaken


-- warning:  dont do outer join on a group field: it breaks in these subreports returning to many rows
 
 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(Events.UserName AS varchar(32)) AS UserName
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  cast(BranchNode.Nodename as varchar(255))
			ELSE @Unlinked
			END 


    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype

    		,cast( TVDEventID as varchar(10)) as TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		ScanTime 
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
		-- epo3.5 post3.0.2. If severity match note found in eventfilterdesc, translate numbers to text
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity

    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
    		,CAST(ProductID as int) As ProductID

		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc

		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(@EventType in ('All', 'NotInfection') 
		and events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND ( TVDEventID not in (1202, 1203, 4650, 4651 ) )
	and ( @YYYYMMDD is null or Events.EventDateTime >=  @YYYYMMDD)
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionUr' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionCp' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or ( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or ( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or ( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or ( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	)

        AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime) = @szGroupYear
	) 
        AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth
		)
	) 
        AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Quarter, EventDateTime)) = @szGroupQuarter
		)
	) 
        AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek
		)
	) 
        AND 		-- day of month
	(	 @szGroupDay = ''
		OR 
		convert(varchar(20), DateName(Day, EventDateTime)) = @szGroupDay
	) 
        AND 		-- hour of day
	(	 @szGroupHour = ''
		OR 
		convert(varchar(20), DateName(Hour, EventDateTime)) = @szGroupHour
	) 
        AND 
	(	 @szGroupVirusName = ''
		OR Events.VirusName = @szGroupVirusName
	) 
        AND 
	(	 @szGroupActionTaken = ''
		OR (@szGroupActionTaken = ReportActionDesc.ActionName )
		OR (@szGroupActionTaken > '' and convert(varchar(25),ActionTaken) = @szGroupActionTaken )
	) 
        AND 
	(	 @szTVDSeverity = ''
		or ( @szTVDSeverity = EventFilterDescFast.Severity )
		OR ( @szTVDSeverity = @Informational and Events.TVDSeverity = 0 )
		OR ( @szTVDSeverity = @Warning and Events.TVDSeverity = 1 )
		OR ( @szTVDSeverity = @Minor and Events.TVDSeverity = 2 )
		OR ( @szTVDSeverity = @Major and Events.TVDSeverity = 3 )
		OR ( @szTVDSeverity = @Critical and Events.TVDSeverity = 4 )
		OR ( @szTVDSeverity = '---' and (Events.TVDSeverity > 4  or Events.TVDSeverity < 0) )
	) 
        AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
		or ( @szGroupNodeName = '---' and (BranchNode.NodeName is NULL) )
	) 
        AND 
	(	 @szGroupProductName = ''
		OR ProductName = @szGroupProductName
	) 
        AND 
	(	 @szGroupProductVersion = ''
		OR ProductVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (ProductVersion is NULL or ProductVersion = '') )
	) 
        AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVersion = @szGroupEngineVersion
	) 
        AND 
	(	 @szGroupDATVersion = ''
		OR DATVersion = @szGroupDATVersion
	) 
        AND 	-- make this a like operator since the filename is cropped
	(	 @szGroupFileName = ''
		-- epo3.x patch6 Sometimes filename can have _[] chars in it which will break the like operator
		OR right(Events.FileName,15) = @szGroupFileName 
		OR Events.FileName = @szGroupFileName
		OR FileName like ('%' + @szGroupFileName)
	) 
        AND 
	(	 @szGroupHostName = ''
		OR Events.HostName = @szGroupHostName
	) 
        AND 
	(	 @szGroupUserName = ''
		OR Events.UserName = @szGroupUserName
	) 
        AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName = '' or Domainname is null) )
		or ( @szGroupDomainName = '---' and (DomainName = '' or Domainname is null) )
	) 
        AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType = '' or OSType is null) )
		or ( @szOSType = '---' and (OSType = '' or OSType is null) )
	) 
        AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform = '' or OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '' or OSPlatform is NULL) )
	) 
        AND 
	(	 @szVirusType = ''
		OR VirusType.VirusTypeTranslated = @szVirusType 
		or Events.VirusType = @szVirusType 
		or (@szVirusType = '---' and (Events.VirusType = '' or Events.VirusType is NULL))
	) 
        AND 
	(	 @szVirusSubtype = ''
		OR VirusType.VirusFileType = @szVirusSubtype 
		or (@szVirusSubtype = '---' and (VirusType.VirusFileType = '' or VirusType.VirusFileType is NULL))
	) 
        AND 
	(	 @szFullProductName = ''
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		or (@szFullProductName = '---' and ((ProductName + ' ' + ProductVersion) = ' ' or (ProductName + ' ' + ProductVersion) is NULL))
	) 
        AND 
	(	 @szEngineDat = ''
		OR (EngineVersion + ' ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion + ' \ ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion)  = @szEngineDat 
		OR (DATVersion)  = @szEngineDat 
		or (@szEngineDat = '---' and ((EngineVersion + ' ' + DATVersion) = ' ' or (EngineVersion + ' ' + DATVersion) is NULL))
	) 
        AND 
	(	 @szTVDTaskName = ''
		OR TVDTaskName = @szTVDTaskName 
	) 
        AND 
	(	 
		@szEventDesc = ''
		or EventFilterDescFast.Name = @szEventDesc
		or cast(Events.TVDEventID as varchar(128)) = @szEventDesc
		or (@szEventDesc = '---' and (Events.TVDEventID = '' or Events.TVDEventID is NULL))
	) 


	set @ret = @@rowcount

--	Drop Table #LostLinksEvents

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO


--- Always end scripts with a comment (Last GO must have a CR after it)