/* epo3.0 */

-- temp changes - schema file checked out

-------------------------------------------
--
Begin
Declare @dbname varchar(100)
Select @dbname=db_name()
Exec sp_dboption @dbname,'select into/bulkcopy','TRUE'
End
GO


-- fix big software name bug
ALTER TABLE [dbo].[ReportComputerSummary]
	ALTER COLUMN ProductName nvarchar (128) 
GO

ALTER TABLE [dbo].[ReportComputerSummaryPrevious]
	ALTER COLUMN ProductName nvarchar (128) 
GO

---------------------------------------


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetConsistentProductName]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetConsistentProductName]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetConsistentProductName
 @szProductName  VARCHAR(100),
 @szConsistentName VARCHAR(100) OUTPUT
AS
BEGIN
 /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 /* Default to the provided one*/
 SET @szConsistentName=@szProductName
 IF @szProductName LIKE 'NetShield'
  SET @szConsistentName = 'NetShield'
 IF @szProductName LIKE 'VirusScan'
  SET @szConsistentName = 'VirusScan'

 RETURN
END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_VerifyNameSpaceRights]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_VerifyNameSpaceRights]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_VerifyNameSpaceRights
(
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500),
 @szEpoUserName   VARCHAR(100)
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 RETURN 1
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Add_To_dbo_events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Add_To_dbo_events]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Add_To_dbo_events

 (
 @EventDateTime datetime ,
 @ProductID int,
      @ProductName nvarchar (64) ,
 @ProductVersion nvarchar(16),
 @HostName nvarchar(512) ,
 @HostIPAddress nvarchar(16),
 @UserName nvarchar(32) ,
 @VirusName nvarchar(128) ,
 @FileName nvarchar(512) ,
 @EngineVersion nvarchar(16) ,
 @DATVersion nvarchar(16) ,
 @ScanTime nchar (16) ,
 @ActionTaken int,
 @TVDEventID int,
 @TVDSeverity int,
 @VirusType nvarchar(128) ,
 @TVDTaskName nvarchar(128),
 @AgentGUID uniqueidentifier
 )

AS  

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

BEGIN

 /* Map the name to a consistent name */
 DECLARE @CProductName VARCHAR(100)
 EXECUTE AVISP_GetConsistentProductName @ProductName, @CProductName OUTPUT

  INSERT INTO Events ( 
      EventDateTime,
      ProductID,
      ProductName,
      ProductVersion,
      HostName,
      HostIPAddress,
      UserName,
      VirusName,
      FileName,
      EngineVersion,
      DATVersion,
      ScanTime,
      ActionTaken,
      TVDEventID,
      TVDSeverity,
      VirusType,
      TVDTaskName,
      AgentGUID
      )
     VALUES
      ( 
      @EventDateTime,
      @ProductID,
      @ProductName,
      @ProductVersion,
      @HostName,
      @HostIPAddress,
      @UserName,
      @VirusName,
      @FileName,
      @EngineVersion,
      @DATVersion,
      @ScanTime,
      @ActionTaken,
      @TVDEventID,
      @TVDSeverity,
      @VirusType,
      @TVDTaskName,
      @AgentGUID
      )
 RETURN 1
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodeIDFilter]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodeIDFilter]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/* Used by all report procs to check if a filter node and the enum */
/*  table is needed */
CREATE PROCEDURE dbo.AVIDALSP_GetNodeIDFilter
(
 @iNameSpaceName  int,
 @iNameSpaceNode  int,
 @FilterID   int   OUTPUT
)
AS
BEGIN

      Declare @iFilterNode int
      Declare @iFilterNodeType int
      Declare @iTopNode int
      Declare @iTopNodeType int
      Declare @szFilterNode varchar(100)

 

      Set @iFilterNode =0
      Set @iFilterNodeType =0
      Set @iTopNode =0
      Set @iTopNodeType =0

     select @iTopNode = AutoID, @iTopNodeType = Type  from BranchNode where AutoID = @iNameSpaceName

     IF @iNameSpaceNode > 0
           select @iFilterNode = AutoID,  @iFilterNodeType = Type from BranchNode where AutoID = @iNameSpaceNode 
  and AutoID in 
   (Select EndAutoID from BranchNodeEnum where StartAutoID = @iTopNode)

/*     select @iTopNode, @iTopNodeType, @iFilterNode */

    /* return either the top node, the users selected filter node, or zero if either equals the root node (no filtering needed) */
    IF @iFilterNode > 0 and  @iFilterNodeType != 4 and @iFilterNodeType != 7
 set @FilterID=@iFilterNode
    ELSE IF @iTopNode > 0 and  @iTopNodeType != 4 and @iTopNodeType != 7
 set @FilterID=@iTopNode
    ELSE
 set @FilterID=0 

END


SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetReportParms]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetReportParms]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/* Used by all report procs to check if a filter node and the enum */
/*  table is needed */
CREATE PROCEDURE dbo.AVISP_GetReportParms
(
  @szOptionalReportParms VARCHAR(500),
  @szLang VARCHAR(3) OUTPUT,
  @szTime VARCHAR(10) OUTPUT,
  @szFilter VARCHAR(50) OUTPUT
)
AS
BEGIN

	Declare @pstart int
	Declare @pend int


	/* Get TIME parm */
	Set @pstart = CHARINDEX( '|TIME', @szOptionalReportParms) + 5
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 5 )
		Set @szTime = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szTime = 'GMT'


	/* Get LANG parm */
	Set @pstart = CHARINDEX( '|LANG', @szOptionalReportParms) + 5
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 5 )	
		Set @szLang = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szLang = '09'


	/* Get FILTER parm */
	Set @pstart = CHARINDEX( '|FILTER', @szOptionalReportParms) + 7
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)
	
	if( @pstart > 7 )
		Set @szFilter = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szFilter = ''


/*
select @szLang, @szTime, @szFilter
*/


END
GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetReportParms2]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetReportParms2]
GO


/* Used by all report procs to check if a filter node and the enum */
/*  table is needed */
CREATE PROCEDURE dbo.AVISP_GetReportParms2
(
  @szOptionalReportParms VARCHAR(500),
  @szLang VARCHAR(3) OUTPUT,
  @szFullLang VARCHAR(5) OUTPUT,
  @szTime VARCHAR(10) OUTPUT,
  @szFilter VARCHAR(50) OUTPUT,
  @szReportID VARCHAR(50) OUTPUT,
  @szRptGroup VARCHAR(50) OUTPUT
)
AS
BEGIN

	Declare @pstart int
	Declare @pend int
  	Declare @szDefLang VARCHAR(5)


	/* Get TIME parm */
	Set @pstart = CHARINDEX( '|TIME', @szOptionalReportParms) + 5
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 5 )
		Set @szTime = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szTime = 'GMT'


	/* Get LANG parm */
	Set @pstart = CHARINDEX( '|LANG', @szOptionalReportParms) + 5
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 5 )	
		Set @szLang = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szLang = '09'

	/* Get FULLLANG parm */
	Set @pstart = CHARINDEX( '|FULLLANG', @szOptionalReportParms) + 9
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 9 )	
		Set @szFullLang = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szFullLang = '0'


	/* Get DEFLANG parm */
	Set @pstart = CHARINDEX( '|DEFLANG', @szOptionalReportParms) + 8
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)

	if( @pstart > 8 )	
		Set @szDefLang = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szDefLang = '0'


	/* Get FILTER parm */
	Set @pstart = CHARINDEX( '|FILTER', @szOptionalReportParms) + 7
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)
	
	if( @pstart > 7 )
		Set @szFilter = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szFilter = ''


	/* Get ReportID parm */
	Set @pstart = CHARINDEX( '|REPORT', @szOptionalReportParms) + 7
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)
	
	if( @pstart > 7 )
		Set @szReportID = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szReportID = ''


	/* Get RptGroup parm */
	Set @pstart = CHARINDEX( '|RPTGRP', @szOptionalReportParms) + 7
	Set @pend   = CHARINDEX( '|', @szOptionalReportParms, @pstart)
	
	if( @pstart > 7 )
		Set @szRptGroup = SUBSTRING( @szOptionalReportParms, @pstart, (@pend - @pstart) )
	else
		Set @szRptGroup = ''

	-- if fulllang is not in localization lookup tables try default lang
	Declare @cntlang int
	Select @cntlang=count(*) from ReportActionDesc where LanguageID = @szFullLang

	if @cntlang = 0
	begin
		Select @cntlang=count(*) from ReportActionDesc where LanguageID = @szDefLang
		if @cntlang > 0
			Set @szFullLang = @szDefLang
		else
			Set @szFullLang = '0409'	-- default = english
	end
	
/*
select @szLang, @szTime, @szFilter
*/


END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodeIDFilterQueries]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodeIDFilterQueries]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/*  Performs filter node checks for queries */
/*    calls: AVIDALSP_GetNodeIDFilter */
CREATE PROCEDURE dbo.AVIDALSP_GetNodeIDFilterQueries
(
 @iNameSpaceName  int,
 @iNameSpaceNode  int
)
AS
BEGIN

      Declare @iFilterNode int

      EXECUTE dbo.AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @iFilterNode OUTPUT

      SELECT @iFilterNode
 
END
GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetAllSubNodeIDs]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetAllSubNodeIDs]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetAllSubNodeIDs
(
 @iFilterNode  int
)
 AS
 BEGIN
  /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 /* check the user has enough rights to see this data */
      /* old avi code: reuse if we ever want to check rights based on top namespace */
 /*
      DECLARE @iRightsCheckResult   INTEGER
 EXECUTE @iRightsCheckResult=AVISP_VerifyNameSpaceRights @szNameSpaceName, @szNameSpaceNode, @szEpoUserName
 IF(@iRightsCheckResult=1)
      BEGIN
      */

  /* All sub nodes */
  SELECT EndAutoID as AutoID 
                 FROM BranchNodeEnum 
    WHERE StartAutoID =  @iFilterNode
  UNION 
  /* and the node it's self */
       SELECT @iFilterNode

 /*END*/
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetUserNodeAccessList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetUserNodeAccessList]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

IF EXISTS (select * from sysobjects where name = '##UserNodeAccessList' 
   and xtype = 'U')
 DROP TABLE ##UserNodeAccessList
GO


/* used by AVISP_CalculateAllSubNodes (report filtering) */
/*   Creates a temp table of nodes below a top node input */
CREATE PROCEDURE dbo.AVIDALSP_GetUserNodeAccessList
(
 @iNameSpaceName  int,
 @iNameSpaceNode  int,
 @szEpoUserName  VARCHAR(100)
)
AS
BEGIN
      /* Try to generate code which only recreates the temp table when a node has changed
         Can compare a datetime stamp in the temp table with a touch table storing the last
          change datetime stamp for the enum table. Touch table could be trigger based off
          the enum table. 
      */ 
      Declare @iFilterNode int
      Declare @szFilterNode varchar(255)
 
      /*IF EXISTS (select * from sysobjects where name = 'UserNodeAccessList' 
   and xtype = 'U')*/
      IF EXISTS (select * from tempdb..sysobjects where name = '##UserNodeAccessList' 
   and xtype = 'U')
  DROP TABLE ##UserNodeAccessList

 /* @szNameSpaceName  is the top node of the users account*/
 /* @szNameSpaceNode  is a node within the users account that they may filter from*/

     IF @iNameSpaceNode > 0
           select @iFilterNode = @iNameSpaceNode
      ELSE
           select @iFilterNode = @iNameSpaceName

    
     select @szFilterNode = NodeName from BranchNode where AutoID = @iFilterNode


 CREATE TABLE ##UserNodeAccessList (AutoID Integer, NodeName nvarchar(255))
 INSERT ##UserNodeAccessList 
  SELECT EndAutoID as AutoID,  NodeName 
                   FROM BranchNodeEnum, BranchNode 
    WHERE 
     StartAutoID =  @iFilterNode
     AND EndAutoID = BranchNode.AutoID
  UNION 
    SELECT @iFilterNode, @szFilterNode   /* and the node it's self */

/* UPDATE ##UserNodeAccessList 
  SET NodeName = (SELECT NodeName from BranchNode where BranchNode.AutoID = ##UserNodeAccessLst.AutoID)
*/
/* EXECUTE AVIDALSP_GetAllSubNodeIDs @iFilterNode */

END


GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/* v3.0: this routine is needed by avibatch to fill in nodeids */
/*    given the full path nodenames as inputs */
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetLowestNodeIDfromPath]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetLowestNodeIDfromPath]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO
CREATE PROCEDURE dbo.AVIDALSP_GetLowestNodeIDfromPath
 @szRootPath varchar(1024),  
 @szFilterPath varchar(1024),
 @iRootID int OUTPUT,
 @iFilterID int OUTPUT
AS 
BEGIN

SET NOCOUNT ON

 DECLARE @TopNodeID int


	SELECT @TopNodeID = AutoID
	FROM BranchNode
	WHERE Type = 4

	CREATE TABLE #Tree 
	(
		FullPathName varchar(1024),
		LowestNodeID	int		
	)

	INSERT #Tree	
		EXECUTE AVISP_CalculateAllSubNodes @TopNodeID, @TopNodeID, ''


	SELECT @iRootID = LowestNodeID
	FROM #Tree
	WHERE FullPathName = @szRootPath 

	SELECT @iFilterID = LowestNodeID
	FROM #Tree
	WHERE FullPathName = @szFilterPath 

/*	select @iRootID, @iFilterID
*/

	DROP Table #Tree

END
GO


/**/
/* xxxxx Start of Report routines xxxxx */
/**/


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterASCI]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterASCI]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterASCI
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



 SELECT 
   ComputerName, 
   DomainName, 
   IPAddress, 
   CONVERT(datetime,
   (SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
   SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
   SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
   SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
   SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
   SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
   ), 120 )   as LastUpdate, 
/*CAST(LeafNode.LastUpdate As datetime) As LastUpdate, */
   BranchNode.NodeName AS NodeName 
   ,  ComputerProperties.UserName,
     cast((ComputerProperties.OSType  + ' ' 
         + ComputerProperties.OSServicePackVer + ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion,
   ProductVersion =
    	CASE ProductProperties.ProductVersion
     	WHEN '' THEN '---' 
     	ELSE ProductProperties.ProductVersion
     	END
	

 FROM ComputerProperties, ProductProperties,
             LeafNode, BranchNode

 WHERE   
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
          AND ComputerProperties.ParentID = LeafNode.AutoID
           AND LeafNode.LastUpdate > ''
   AND LeafNode.ParentID = BranchNode.AutoID
   AND ProductProperties.ParentID = LeafNode.AutoID
   AND ProductProperties.ProductCode LIKE '%Agent%'
   AND LeafNode.Type !=24      /* Uninstalled */ 

 UNION ALL

 SELECT 
    LeafNode.NodeName  as ComputerName, 
    '<UnConnected>'  as DomainName, 
    '<UnConnected>'  asIPAddress, 
   '01/01/1900' As LastUpdate, 
   BranchNode.NodeName AS NodeName ,
     '<UnConnected>'  as UserName,
     '<UnConnected>'  as OSVersion,
     '<UnConnected>'  as ProductVersion

 FROM 
             LeafNode, BranchNode
 WHERE   
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
           AND ( LeafNode.LastUpdate IS NULL OR LeafNode.LastUpdate = '' )
   AND LeafNode.ParentID = BranchNode.AutoID
   AND LeafNode.Type !=24      /* Uninstalled */ 

 RETURN
END
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterNoAVMachines]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterNoAVMachines]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterNoAVMachines 
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



 
 SELECT distinct
  ComputerName, 
   DomainName, 
   IPAddress,
   BranchNode.NodeName AS NodeName, 
   ComputerProperties.UserName,
   cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion,
   UnmanagedProtection = 
    CASE      WHEN  Events.ProductName > '' THEN (ProductName + ' ' + ProductVersion)
     WHEN  Events.ProductName = '' THEN '---'
     ELSE  '---'
     END

 FROM ComputerProperties,
             LeafNode, BranchNode,
	Events
 WHERE
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND LeafNode.AVInstalls = 0
   AND LeafNode.Type !=24      /* Uninstalled */ 
   AND LeafNode.AutoID = ComputerProperties.ParentID 
   AND LeafNode.ParentID = BranchNode.AutoID
   AND LeafNode.AutoID *= Events.NodeID			/* outer join gets all */
   AND
   (
      Events.ProductName like '%GroupShield%'
      OR Events.ProductName like '%WebShield%'
   )



 RETURN
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterNoAgentMachines]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterNoAgentMachines]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterNoAgentMachines
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




 SELECT 
   LeafNode.NodeName as ComputerName, 
   '---' as DomainName, 
   '---' as IPAddress, 
   BranchNode.NodeName AS NodeName

 FROM  
             LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND  ( LeafNode.LastUpdate = '' OR LeafNode.LastUpdate is NULL )
   AND LeafNode.ParentID = BranchNode.AutoID
   AND LeafNode.Type !=24      /* Uninstalled */ 
 
 RETURN
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterAVInstalls]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterAVInstalls]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


/* 2x add ostype, username remove domainname , language (rename fields) */
/* 2x take product version from PP */
CREATE PROCEDURE dbo.AVISP_FilterAVInstalls
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 /* If Nodeid inputs not supplied, generate them from fullpath node names */
 if  @iNameSpaceName  = '' OR @iNameSpaceNode = '' OR 
	(@UsersTopNodeID = 0  AND @FilterNodeID = 0)  
 BEGIN
 	EXECUTE AVIDALSP_GetLowestNodeIDfromPath
 		@szNameSpaceName,	@szNameSpaceNode,
 		@UsersTopNodeID OUTPUT,	
		@FilterNodeID OUTPUT
 END

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




SELECT 
   ComputerProperties.ComputerName, 
    ComputerProperties.DomainName, 
    ComputerProperties.IPAddress, 
   AVIView_Software.SoftwareName as ProductCode, 
   ProductVersion =
    	CASE ProductProperties.ProductVersion
     	WHEN '' THEN '---' 
     	ELSE ProductProperties.ProductVersion
     	END,
/*   ProductProperties.ProductVersion, */ 
   EngineVer =
    	CASE ProductProperties.EngineVer 
     	WHEN '' THEN '---' 
     	WHEN 'N/A' THEN '---' 
     	ELSE ProductProperties.EngineVer 
     	END,
   DATVer =
    	CASE ProductProperties.DATVer 
     	WHEN '' THEN '---' 
     	WHEN 'N/A' THEN '---' 
     	ELSE ProductProperties.DATVer 
     	END,
   ExtraDATNames =
    	CASE ProductProperties.ExtraDATNames 
     	WHEN 'N/A' THEN '' 
     	ELSE ProductProperties.ExtraDATNames 
     	END,
   Language =
    CASE 
     WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     WHEN  ProductProperties.Language = '' THEN '---'
     ELSE  ProductProperties.Language
     END,
   BranchNode.NodeName AS NodeName
   ,  ComputerProperties.UserName,
     cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion,
   ProductFamily =
    CASE 
     WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     ELSE  AVIView_Software.ProductFamily 
     END
   ,  LeafNode.AutoID as NodeID
   , Servicepack
   , Hotfix
   , LeafNode.LastUpdate as LastContact

 
 FROM ComputerProperties,  
   ProductProperties, AVIView_Software,
             LeafNode, BranchNode, LanguageDesc
 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND LeafNode.AutoID = ComputerProperties.ParentID
                  AND ProductProperties.ParentID = LeafNode.AutoID 
   and ProductProperties.ProductCode = AVIView_Software.ProductCode
   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
	or AVIView_Software.ProductFamily like 'TVD_NC_%' )
   AND LeafNode.ParentID = BranchNode.AutoID
   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
   AND LanguageDesc.epoServerLanguageID = @szFullLang
   AND LeafNode.Type !=24      /* Uninstalled */ 

UNION ALL      
/* Fetch Nodes with no products */

 SELECT distinct
   ComputerProperties.ComputerName, 
  ComputerProperties.DomainName, 
   ComputerProperties.IPAddress, 
   ProductCode = 
     CASE
     WHEN  Events.ProductName > '' THEN 'Unmanaged Protection' + ' - ' + Events.ProductName
     WHEN  Events.ProductName = '' THEN 'Unprotected'
     ELSE  'Unprotected'
     END , 
   ProductVersion = 
      CASE
          WHEN Max( ProductVersion )  > '' THEN Max( ProductVersion )
          WHEN Max( ProductVersion )  = '' THEN '---'
          ELSE  '---'
          END,
   EngineVer = 
     CASE
          WHEN Max(Events.EngineVersion)  > '' THEN Max(Events.EngineVersion)
          WHEN Max(Events.EngineVersion)  = '' THEN '---'
          ELSE  '---'
          END,	
   DATVer = 
     CASE
          WHEN Max(Events.DATVersion)  > '' THEN Max(Events.DATVersion)
          WHEN Max(Events.DATVersion)  = '' THEN '---'
          ELSE  '---'
          END,
   '',
   '---',
   BranchNode.NodeName AS NodeName,
   ComputerProperties.UserName,
      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion,
    '---'
   ,  LeafNode.AutoID as NodeID
   , '' as Servicepack
   , '' as Hotfix
   , LeafNode.LastUpdate as LastContact


 FROM ComputerProperties,
             LeafNode, BranchNode,
	Events
 WHERE
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND LeafNode.AVInstalls = 0
   AND LeafNode.Type !=24      /* Uninstalled */ 
   AND LeafNode.AutoID = ComputerProperties.ParentID 
   AND LeafNode.ParentID = BranchNode.AutoID
   AND LeafNode.AutoID *= Events.NodeID			/* outer join gets all */
   AND
   (
      Events.ProductName like '%GroupShield%'
      OR (Events.ProductName like '%NetShield%' and ProductVersion < '4.5')
      OR (Events.ProductName like '%VirusScan%' and ProductVersion < '4.5')
      OR Events.ProductName like '%WebShield%'
   )
   GROUP BY
   	BranchNode.NodeName,
   	ComputerProperties.ComputerName, 
  	ComputerProperties.DomainName, 
   	ComputerProperties.IPAddress, 
   	ComputerProperties.UserName,
	ComputerProperties.OSType,
--	ComputerProperties.OSVersion,
	ComputerProperties.OSServicePackVer,
	ComputerProperties.OSPlatform,
      	Events.ProductName
	,  LeafNode.AutoID 
	, LeafNode.LastUpdate

/* use group by to remove duplicates and return latest version, engine, dats */

 RETURN
END
GO



SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO




SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterLanguages]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterLanguages]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

/* 2.x fetch language names from language desc table  */
CREATE PROCEDURE dbo.AVISP_FilterLanguages
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




 SELECT 
   ComputerProperties.ComputerName, 
   ComputerProperties.DomainName, 
   ComputerProperties.IPAddress,
   AVIView_Software.SoftwareName as ProductCode, 
   ProductVersion =
    	CASE ProductProperties.ProductVersion
     	WHEN '' THEN '---' 
     	ELSE ProductProperties.ProductVersion
     	END,
/*   ProductProperties.ProductVersion, */
   EngineVer =
    	CASE ProductProperties.EngineVer 
     	WHEN '' THEN '---' 
     	WHEN 'N/A' THEN '---' 
     	ELSE ProductProperties.EngineVer 
     	END,
   DATVer =
    	CASE ProductProperties.DATVer 
     	WHEN '' THEN '---' 
     	WHEN 'N/A' THEN '---' 
     	ELSE ProductProperties.DATVer 
     	END,
   ExtraDATNames =
    	CASE ProductProperties.ExtraDATNames 
     	WHEN 'N/A' THEN '' 
     	ELSE ProductProperties.ExtraDATNames 
     	END,
   Language =
    CASE 
     WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     WHEN  ProductProperties.Language = '' THEN '---'
     ELSE  ProductProperties.Language
     END,
/*   ProductProperties.Language, */
   BranchNode.NodeName AS NodeName, 
   ComputerProperties.UserName,
   cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion

 FROM ComputerProperties,  
   ProductProperties, AVIView_Software,
             LeafNode, BranchNode, LanguageDesc
 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND LeafNode.AutoID = ComputerProperties.ParentID
                   AND ProductProperties.ParentID = LeafNode.AutoID 
   and ProductProperties.ProductCode = AVIView_Software.ProductCode
   and AVIView_Software.ProductFamily in ( 'TVD', 'TVD_NC' )
   AND LeafNode.ParentID = BranchNode.AutoID
   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
   AND LanguageDesc.epoServerLanguageID = @szFullLang
   AND LeafNode.Type !=24      /* Uninstalled */ 
 
 RETURN
END
GO




SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterEPOAgentInstalls]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterEPOAgentInstalls]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterEPOAgentInstalls
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 SELECT 
   ComputerProperties.ComputerName, 
   ComputerProperties.DomainName, 
   ComputerProperties.IPAddress, 
   ProductProperties.ProductCode, 
   ProductVersion =
    AVIView_Software.SoftwareName + '/ ' +
    (CASE ProductProperties.ProductVersion
     WHEN '' THEN '---' 
     ELSE ProductProperties.ProductVersion
     END),
/*   ProductProperties.ProductVersion, */
   BranchNode.NodeName AS NodeName, 
   ComputerProperties.UserName,
   cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion,
   (case
   when LeafNode.LastUpdate > '' then CONVERT(datetime,
   (SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
   SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
   SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
   SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
   SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
   SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
   ), 120 )   
   else convert(datetime, '01/01/1900') 
   end ) as ASCIdatetime			-- mhilandepo3: bugfix - handle empty values

 FROM ComputerProperties,  AVIView_Software,
   ProductProperties, 
             LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND ProductProperties.ParentID = LeafNode.AutoID
   AND LeafNode.AutoID = ComputerProperties.ParentID
   AND ProductProperties.ProductCode = AVIView_Software.ProductCode
   AND ProductProperties.ProductCode LIKE '%Agent%'
   AND LeafNode.ParentID = BranchNode.AutoID
   AND LeafNode.Type !=24      /* Uninstalled */ 

 RETURN
END



GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_Computer_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_Computer_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_Computer_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS 
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




 SELECT LeafNode.AutoID 
          FROM LeafNode
     WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )

 RETURN
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_All_Comp_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_All_Comp_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_All_Comp_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 /* select statement*/
 SELECT *
 FROM ComputerProperties, LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
  AND ComputerProperties.ParentID = LeafNode.AutoID
  AND LeafNode.ParentID = BranchNode.AutoID 

END

GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_All_Prod_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_All_Prod_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_All_Prod_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 /* select statement*/
 SELECT *
 FROM ProductProperties, LeafNode, BranchNode, AVIView_Software
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
  AND ProductProperties.ParentID = LeafNode.AutoID
  AND LeafNode.ParentID = BranchNode.AutoID 
  AND ProductProperties.ProductCode = AVIView_Software.ProductCode

END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_All_CompProd_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_All_CompProd_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_All_CompProd_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




 /* select statement*/
 SELECT *
 FROM ComputerProperties, ProductProperties, LeafNode, BranchNode, AVIView_Software
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
  AND ComputerProperties.ParentID = LeafNode.AutoID
  AND ProductProperties.ParentID = LeafNode.AutoID
  AND LeafNode.ParentID = BranchNode.AutoID 
  AND ProductProperties.ProductCode = AVIView_Software.ProductCode

END

GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_All_EventComp_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_All_EventComp_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_All_EventComp_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 /* select statement*/
 SELECT *
 FROM Events, ComputerProperties, LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
  AND ComputerProperties.ParentID = LeafNode.AutoID
  AND LeafNode.ParentID = BranchNode.AutoID 
  AND Events.NodeID = LeafNode.AutoID

END

GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Filter_All_EventNode_Info]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Filter_All_EventNode_Info]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Filter_All_EventNode_Info
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN 
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 /* select statement*/
 SELECT *
 FROM Events, LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
  AND Events.NodeID = LeafNode.AutoID
  AND LeafNode.ParentID = BranchNode.AutoID 

END

GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterInstalls]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterInstalls]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterInstalls
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





 /* select statement*/
 SELECT   
   ComputerProperties.ComputerName, 
   ComputerProperties.DomainName, 
   ComputerProperties.IPAddress, 
   AVIView_Software.SoftwareName as ProductCode, 
   ProductProperties.ProductVersion,
   BranchNode.NodeName AS NodeName 
   ,  ComputerProperties.UserName,
     cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
	+ ' ' + ComputerProperties.OSPlatform) 
        as varchar(50)) as OSVersion
	FROM
	ComputerProperties,
   ProductProperties, 
   AVIView_Software,
             LeafNode, BranchNode
 WHERE 
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
   AND ProductProperties.ProductCode = AVIView_Software.ProductCode 
   AND ProductProperties.ParentID = LeafNode.AutoID
                  AND LeafNode.AutoID = ComputerProperties.ParentID
   AND LeafNode.ParentID = BranchNode.AutoID

 RETURN
END

GO

/**/
/*** xxxxxx  infection report rotuines xxxxxxxxx */
/**/




SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


/************************** 
	AVISP_FilterVAlertsByAction  sane as AVISP_FilterVAlerts except:
   /* Create temp table to filter results by ActionID if needed */
   CREATE TABLE #ActionIDs 
   	( ActionID	int )

   if @szFilter > ''
	INSERT #ActionIDs	
		SELECT ActionID FROM ReportActionDesc 
			WHERE 	LanguageSuffix = '09'
				AND ActionName = @szFilter	
   ELSE
	INSERT #ActionIDs	
		SELECT Distinct ActionID FROM ReportActionDesc 
  	AND Events.ActionTaken in (select ActionID from #ActionIDs)
   DROP TABLE #ActionIDs 
*/
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertsByAction]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertsByAction]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlertsByAction
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



   /* Create temp table to filter results by ActionID if needed */
   CREATE TABLE #ActionIDs 
   	( ActionID	int )

   if @szFilter > ''
	INSERT #ActionIDs	
		SELECT ActionID FROM ReportActionDesc 
			WHERE 	LanguageSuffix = '09'
				AND ActionName = @szFilter	
   ELSE
	INSERT #ActionIDs	
		SELECT Distinct ActionID FROM ReportActionDesc 


IF @FilterID = 0			/* admin user, must see all events  - uses an outer join */
BEGIN

 	/* select statement*/


	SELECT 

		(CASE @szTime
		WHEN 'GMT' THEN EventDateTime
		ELSE 		EventLocalDateTime
		END) as EventDateTime,
 
  		CAST(ProductName As varchar(64)) AS ProductName,
  		ProductVersion =
		  	CASE ProductVersion
		   	WHEN '' THEN '---' 
		   	ELSE ProductVersion
		   	END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		/*
    		CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    		ActionTaken,
		*/
    		TVDSeverity, 
		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		CAST('' as varchar(100)) AS NodeName 	/* outer join doesnt allow branchnode name */


  	FROM 
	Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
        AND Events.ProductName != 'ePO Agent' 
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
  	AND Events.ActionTaken in (select ActionID from #ActionIDs)

END
ELSE
BEGIN			/* non admin users sees only events tied to their nodes */



 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE ProductVersion
	   		WHEN '' THEN '---' 
	   		ELSE ProductVersion
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		BranchNode.NodeName AS NodeName
 
 	FROM Events, 
             LeafNode, BranchNode, ReportActionDesc 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
   	AND LeafNode.ParentID = BranchNode.AutoID 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
        AND Events.ProductName != 'ePO Agent' 
  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
   	AND ReportActionDesc.LanguageID = @szFullLang
  	AND Events.ActionTaken in (select ActionID from #ActionIDs)
   	AND LeafNode.Type !=24      /* Uninstalled */ 

END

/* Cleanup */
DROP TABLE #ActionIDs 		


RETURN
END
GO





SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



/**************** 
	AVISP_FilterVAlertsByDate  sane as AVISP_FilterVAlerts except:
   /* If filter set date parameters */
   Declare @Difference int
   Declare @dayofyear int
   Declare @dayofmonth int
   Declare @dayofweek int
   Declare @month int
   Set @dayofyear = DatePart( dayofyear, GetDate())
   Set @dayofmonth = DatePart(day,GetDate()) 
   Set @dayofweek = DatePart(weekday,GetDate()) 
   Set @month = DatePart(month ,GetDate()) 
   if @szFilter = 'QUARTER' 
   Begin
	if @month < 4
		Set @Difference = @dayofyear
	else if @month < 7
		Set @Difference = @dayofyear - 89
	else if @month < 10
		Set @Difference = @dayofyear - 179
	else 
		Set @Difference = @dayofyear - 270	
   End
   else if @szFilter = 'MONTH' 
	Set @Difference = @dayofmonth
   else if @szFilter = 'YEAR' 
	Set @Difference = @dayofyear
   else if @szFilter = 'WEEK' 
	Set @Difference = DatePart(weekday,GetDate()) 
   else if @szFilter = 'DAY' 
	Set @Difference = 1
   else if @szFilter = '4WEEK'
   	Set @Difference = 28
   else 
	Set @Difference = 50000
	
	AND DateDiff(day, Events.EventDateTime, GetDate()) < @Difference
*/
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertsByDate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertsByDate]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlertsByDate
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   /* If filter set date parameters */
   Declare @Difference int
   Declare @dayofyear int
   Declare @dayofmonth int
   Declare @dayofweek int
   Declare @month int
   Set @dayofyear = DatePart( dayofyear, GetDate())
   Set @dayofmonth = DatePart(day,GetDate()) 
   Set @dayofweek = DatePart(weekday,GetDate()) 
   Set @month = DatePart(month ,GetDate()) 
   if @szFilter = 'QUARTER' 
   Begin
	if @month < 4
		Set @Difference = @dayofyear
	else if @month < 7
		Set @Difference = @dayofyear - 89
	else if @month < 10
		Set @Difference = @dayofyear - 179
	else 
		Set @Difference = @dayofyear - 270	
   End
   else if @szFilter = 'MONTH' 
	Set @Difference = @dayofmonth
   else if @szFilter = 'YEAR' 
	Set @Difference = @dayofyear
   else if @szFilter = 'WEEK' 
	Set @Difference = DatePart(weekday,GetDate()) 
   else if @szFilter = 'DAY' 
	Set @Difference = 1
   else if @szFilter = '4WEEK'
   	Set @Difference = 28
   else 
	Set @Difference = 50000
	
	



IF @FilterID = 0			/* admin user, must see all events  - uses an outer join */
BEGIN

 	/* select statement*/


	SELECT 

		(CASE @szTime
		WHEN 'GMT' THEN EventDateTime
		ELSE 		EventLocalDateTime
		END) as EventDateTime,
 
  		CAST(ProductName As varchar(64)) AS ProductName,
  		ProductVersion =
		  	CASE ProductVersion
		   	WHEN '' THEN '---' 
		   	ELSE ProductVersion
		   	END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		/*
    		CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    		ActionTaken,
		*/
    		TVDSeverity, 
		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		CAST('' as varchar(100)) AS NodeName

  	FROM Events, ReportActionDesc
  	WHERE 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
        AND Events.ProductName != 'ePO Agent' 
   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
   	AND ReportActionDesc.LanguageID = @szFullLang
	AND DateDiff(day, Events.EventDateTime, GetDate()) < @Difference

END
ELSE
BEGIN			/* non admin users sees only events tied to their nodes */




 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE ProductVersion
	   		WHEN '' THEN '---' 
	   		ELSE ProductVersion
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		BranchNode.NodeName AS NodeName
 
 	FROM Events, 
             LeafNode, BranchNode, ReportActionDesc 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
   	AND LeafNode.ParentID = BranchNode.AutoID 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
        AND Events.ProductName != 'ePO Agent' 
  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
   	AND ReportActionDesc.LanguageID = @szFullLang
	AND DateDiff(day, Events.EventDateTime, GetDate()) < @Difference
   	AND LeafNode.Type !=24      /* Uninstalled */ 

END

RETURN
END
GO



SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

-- mhilandepo3 - End of legacy routines section
-- These are saved so that if users created custom reports based on them they will still work. 



/**/
/* xxxxx misc routines (rept filter, event filter, getuseraccessdata)  xxxxx */
/**/



/**/
/* v2.0 procedure: Used by reportfilter to return all fullpath nodenames and the leaf nodeid */
/* ePO3 - mhiland 1/13/2k2  Added option to generate ReportFullPathNode output table for use in new CoverageGroupSummary report */
/*  */
/**/

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_CalculateAllSubNodes]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_CalculateAllSubNodes]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_CalculateAllSubNodes
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @GenerateOutputTable nvarchar(5) = '' 
)
AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
      Declare @iFilterNode int
 Declare @szFilterName nvarchar(255)
 Declare @cnt int

/*  Always start with users topnode
      IF @szNameSpaceNode is not NULL  AND  @szNameSpaceNode != ''
 BEGIN
            SELECT @iFilterNode = AutoID from BranchNode where NodeName = @szNameSpaceNode
  SET @szFilterName = @szNameSpaceNode
 END
      ELSE
*/

 /* mhiland 1/13/2k2  - add default case of NameSpaceName = 0 */
 if @iNameSpaceName = 0
 BEGIN

	-- 149960 mhilandepo3.5: remove orphaned branchnode records if they exist
	Select @cnt=count(*) from BranchNode where Nodename = 'directory'
	if @cnt > 1
	begin	-- run three times to remove orphan site, root and global root
		delete branchnode where type in (4,7,5) and autoid not in (select parentid from branchnode)
		delete branchnode where type in (4,7,5) and autoid not in (select parentid from branchnode)
		delete branchnode where type in (4,7,5) and autoid not in (select parentid from branchnode)
	end

        select @szFilterName = NodeName,  @iFilterNode = AutoID
		from BranchNode where NodeName in ( 'directory', 'MergedDB' )	-- mhilandepo3: add MergedDB for dbmerge
	SET @iNameSpaceName = @iFilterNode
 END
 ELSE
 BEGIN
            select @szFilterName = NodeName from BranchNode where AutoID = @iNameSpaceName
  SET @iFilterNode = @iNameSpaceName
 END


      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
/* Declare @FilterID int */
/* EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT */

      /* refresh ##UserNodeAccessList */
      EXECUTE AVIDALSP_GetUserNodeAccessList @iNameSpaceName, @iNameSpaceNode, @szEpoUserName

 /* step 0 */
      /* create UserNodeAccessList table with node names */
/*
 CREATE TABLE #UserNodeList(NodeID int, NodeName varchar(255))
      INSERT #UserNodeList
  SELECT BranchNode.AutoID, NodeName
  FROM ##UserNodeAccessList, BranchNode 
  WHERE ##UserNodeAccessList.AutoID = BranchNode.AutoID
*/

 /* step 1 */
      /* create subset of enum table the user has access to with branch node names in it */
 CREATE TABLE #UserEnum(ParentID int, ChildID int, PathLength int)

 INSERT #UserEnum 
    SELECT StartAutoID, EndAutoID, PathLength     /*, NULL, NULL*/
           FROM BranchNodeEnum
            WHERE StartAutoID in (SELECT AutoID FROM ##UserNodeAccessList)


 /* step 2 */
 /* create full name path work table: will first expand out the nodeids until we have the full path */

 CREATE TABLE #FullPath(CID int, PID int,
     GPID int, GPID1 int,  
     PathLength int,
     FullPathName varchar(500),
     LowestNodeID int )

 /* create the initial parent child hierarchy */
      /* Load all enum entries with pathlength=1 so they can be traversed backwards */
 /* Each of these entries represents a node that must be traversed back to fill the pathname */
 /* Also add the LowestNodeID at this step - this is the FilterNodeID sent to the reports */
 INSERT #FullPath 
    SELECT ChildID, ParentID, 0,0,0,NULL, ChildID
           FROM #UserEnum
            WHERE PathLength = 1
  
 /* top node */
       INSERT #FullPath
  VALUES ( @iFilterNode, 0, 0,0,0,NULL, @iFilterNode )
 

 /* add pathlength from filternode to childnode */
 UPDATE #FullPath
  SET PathLength = 
   (SELECT PathLength
    FROM #UserEnum
    WHERE 
     ParentID = @iFilterNode
     and ChildID = CID)

     
 /* add new path levels until complete */
 /* add lowest child level */
 UPDATE #FullPath  SET FullPathName = (SELECT NodeName from ##UserNodeAccessList where AutoID = CID) 

 /* add parent, bumping child to the right on the pathlist */
 UPDATE #FullPath  
  SET FullPathName = (SELECT NodeName from ##UserNodeAccessList where AutoID = PID)
    + ',' +FullPathName
  WHERE PID != 0
 UPDATE #FullPath  SET GPID = PID, GPID1 = NULL

 SET @cnt = 2

 /* loop through looking for lower nodes */
 WHILE EXISTS (SELECT PathLength from #FullPath WHERE PathLength = @cnt)
 BEGIN
  /* look for another round of parents */
  UPDATE #FullPath SET GPID1 = (SELECT ParentID FROM #UserEnum 
       WHERE ChildID = GPID and PathLength = 1) 
  /* if another level exists add it to the path, bumping the existing path to the right */
  UPDATE #FullPath  
   SET FullPathName = (SELECT NodeName from ##UserNodeAccessList where AutoID = GPID1)
    + ',' +FullPathName
   WHERE GPID1 is not NULL 
  UPDATE #FullPath  SET GPID = GPID1, GPID1 = NULL
  SET @cnt = @cnt + 1
 END




 /* mhilandepo3 1/13/2k2 - Generate fullpatnnode table for use in reports */
 /* Generate the output table if it is asked for */
 if @GenerateOutputTable > ''
 BEGIN
	Truncate Table ReportFullPathNode
        INSERT ReportFullPathNode
 	SELECT 
		PathLength
		, FullPathName
		, LowestNodeID  
	FROM #FullPath
	 where FullPathName is not NULL
  	ORDER by FullPathName 	
 END
 ELSE
 BEGIN
 	/* present the results */
 	SELECT FullPathName, LowestNodeID  FROM #FullPath
	 where FullPathName is not NULL
  	ORDER by FullPathName 
 END


  /* cleauup */
	DROP TABLE #UserEnum
	DROP TABLE #FullPath

END

GO


SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


/* Used by epo to get users topnode, pswd, & rootnode */
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetUserAccessData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetUserAccessData]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetUserAccessData
(
 @szEpoUserName  VARCHAR(100)
)
AS
BEGIN
 Declare @szRootNodeName VARCHAR(255)
 Declare @szUserTopNodeName VARCHAR(255)
 Declare @szUserPswd VARCHAR(255)
 Declare @iUserTopNodeID int
       Declare @iUserAccessMask int


 /* default settings for sql server login,  user root = root node. */
 SELECT @szRootNodeName = NodeName, @iUserTopNodeID = AutoID, @iUserAccessMask = 1, @szUserPswd = 0
  FROM BranchNode 
  WHERE Type=4;

 SELECT @iUserTopNodeID = RootNodeID, @iUserAccessMask = WriteAccess, @szUserPswd = Password
  FROM UserTable
  WHERE UserName = @szEpoUserName

 SELECT @szUserTopNodeName = NodeName
  FROM BranchNode 
  WHERE AutoID = @iUserTopNodeID;

 SELECT @szUserTopNodeName, @iUserTopNodeID, @iUserAccessMask, @szUserPswd, @szRootNodeName

END



GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetEventFilter]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetEventFilter]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetEventFilter
(
 @szLanguage VARCHAR(50)
)
AS
BEGIN

 SELECT f.EventID, Flag, Name, Description
  FROM EventFilter f, EventFilterDesc d
  WHERE f.EventID = d.EventID
   and Language = @szLanguage;
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_SetEventFilter]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_SetEventFilter]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_SetEventFilter
(
 @iEventID int,
 @iFlag int
)
AS
BEGIN

 UPDATE EventFilter
  SET Flag = @iFlag
  WHERE EventID = @iEventID;

 /* Update the change timestamp */
 UPDATE EventFilterControl
  SET TheTimestamp = @@dbts;

 /* must return some data so ODBS cursor is happy, sets error otherwise */
 SELECT Flag FROM EventFilter WHERE EventID = @iEventID;

END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetEventFilterControl]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetEventFilterControl]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetEventFilterControl
AS
BEGIN

 SELECT EnableAllEvents, TheTimestamp
  FROM EventFilterControl;

END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_SetEventFilterControl]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_SetEventFilterControl]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_SetEventFilterControl
(
 @iEnableAllEvents int
)
AS
BEGIN

 UPDATE EventFilterControl
  SET EnableAllEvents = @iEnableAllEvents,
   TheTimestamp = @@dbts;

 /* must return some data so ODBS cursor is happy, sets error otherwise */
 SELECT EnableAllEvents from EventFilterControl; 

END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetAllSubNodeIDs]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetAllSubNodeIDs]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetAllSubNodeIDs
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
)

 AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 /* check the user has enough rights to see this data */
 DECLARE @iRightsCheckResult   INTEGER
 DECLARE @iFilterNode int
      
 /* @szNameSpaceName  is the top node of the users account*/
 /* @szNameSpaceNode  is a node within the users account that they may filter on */

 IF @iNameSpaceNode > 0
             select @iFilterNode = @iNameSpaceNode
       ELSE
            select @iFilterNode = @iNameSpaceName


/* EXECUTE @iRightsCheckResult=AVISP_VerifyNameSpaceRights @iNameSpaceName, @iNameSpaceNode, @szEpoUserName

 IF(@iRightsCheckResult=1)
*/
 BEGIN
  /* All sub nodes */
  SELECT EndAutoID as AutoID 
                   FROM BranchNodeEnum 
    WHERE StartAutoID =  @iFilterNode
  UNION 
  /* and the node it's self */
       SELECT @iFilterNode
 END
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Prepare_Query]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Prepare_Query]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_Prepare_Query
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
)
AS
BEGIN
 /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 INSERT INTO #AVI_Query_NameSpace_Object_ID EXECUTE AVISP_GetAllSubNodeIDs @iNameSpaceName, @iNameSpaceNode, @szEpoUserName

 RETURN
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetSQLServerTime]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetSQLServerTime]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetSQLServerTime
(
  @time DATETIME  OUTPUT
)
AS
BEGIN
 set @time = CURRENT_TIMESTAMP
 return 
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


/**** xxxxxxx  webshield report procs xxxxxxx ****/

/*********** webshield reports stored procedures *********** */


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterWebshieldGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterWebshieldGroups]
GO


-- epo3 similar to filtervalertgroups but has differences in where clause and fast summary
--  groups returns hostname which is the e500servername

CREATE PROCEDURE dbo.AVISP_FilterWebshieldGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)=''	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @ret int

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node
-- select distinct AgentGUID
-- into #LostLinksEvents
-- from Events
--	where AgentGUID not in (select AgentGUID from leafnode)
--
-- Update VirusType table with any new viruses (avoids outer join - Prob in drilldown subreport)
-- select distinct VirusName, VirusType
-- into #VirusNameList
-- from Events
--	where VirusName > ''
-- 
-- insert VirusType
--	(VirusName, VirusType)
--	select VirusName, VirusType
--	from #VirusNameList
--	where VirusName not in (Select VirusName from VirusType)

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')

	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output



   -------------------------------------------------------------------------------------
   -- If Drilldown is set to fast, then fetch group summaries (subreport fetches detailed rows)
   -- this first option will return filename, hostname & username fields as well (needed for spam reports)
   if lower(@szDrilldown1) = 'fast' 
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, ''  as 'Day'
		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
--   		,EngineVer =
--    			CASE 
--     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
--     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
--     			ELSE '---' 
--     			END
--   		,DATVer =
--    			CASE 
--     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
--     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
--     			ELSE '---' 
--     			END
--   		, ExtraDATNames =
--    			CASE ProductProperties.ExtraDATNames 
--     			WHEN 'N/A' THEN '' 
--     			ELSE ProductProperties.ExtraDATNames 
--     			END
		, cast( '' as varchar(10)) as Language
--   		, Language =
--    			CASE 
--     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
--     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
--     			ELSE  '---'
--     			END
	        ,  '' as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- agent fields
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, '' as OSType
		, '' as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '1/1/1980' as EventDateTime
		, '' as LastContact

--		,  Events.HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, cast( '' as varchar(32)) as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( '' as varchar(32)) as  ProductCode
		, '' as NodeID
--		, NodeID
		,'' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusType > ''  then VirusType.VirusType
			else case  when Events.VirusType > '' then Events.VirusType else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, '' as TVDTaskName
--		,'' as TVDTaskName
    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		, '' as RuleName

		-- Product Update Fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or
		( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or
		( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or
		( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or
		( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 4650, 4651 )  )	-- skip webshield events
--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		-- postepo3 - optimize group order
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,Events.HostName
		,Events.UserName
		,Events.FileName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusType
		, Events.VirusType
		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform



   end

   else	if lower(@szDrilldown1) = 'drilldown' or  lower(@szDrilldown1) = 'printable'		-- fetch detailed computer rows: epo2.5 and below behavior (slow)
		or (lower(@szDrilldown1) = 'fast' and @EventType = 'WSVirusHour')		-- needed for VirusHour report
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		,cast('' as varchar(16)) as 'Day'
		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,cast('' as varchar(10)) as ProductFamily
		,cast('' as varchar(10)) as ServicePack
		,cast('' as varchar(10)) as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '' as varchar(10)) as Language
	        ,  '' as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- Agent info fields
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- Computer Info fields
  		, '' as NodeName 
		, '' as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, '' as OSType
		, '' as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
--		, '' as NodeID
		, NodeID
		, NodeID as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusType > ''  then VirusType.VirusType
			else case  when Events.VirusType > '' then Events.VirusType else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		-- postepo3 bugfix 33760: convert int events.tvdseverity to varchar - crashed webhield layout=drilldown
    		,  case 
			when EventFilterDescFast.Severity > '' then EventFilterDescFast.Severity
			else cast(Events.TVDSeverity as varchar(30))
			end  as TVDSeverity
--		,'' as TVDSeverity
		, '' as TVDTaskName
--		,'' as TVDTaskName
    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		, '' as RuleName

		-- Product update fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or
		( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or
		( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or
		( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or
		( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 4650, 4651 )
--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end





	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		



RETURN @ret
END
GO



SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


/* 2.x add a new parameter to allow local time display */
/* 2.x show null for nodename not (---) */
/* Procedure retained for epo3 - used in infection history and removable media report */
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlerts]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlerts]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlerts
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT






IF @FilterID = 0			/* admin user, must see all events  - uses an outer join */
BEGIN

 	/* select statement*/


	SELECT 

		(CASE @szTime
		WHEN 'GMT' THEN EventDateTime
		ELSE 		EventLocalDateTime
		END) as EventDateTime,
 
  		CAST(ProductName As varchar(64)) AS ProductName,
  		ProductVersion =
		  	CASE ProductVersion
		   	WHEN '' THEN '---' 
		   	ELSE ProductVersion
		   	END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		/*
    		CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    		ActionTaken,
		*/
    		TVDSeverity, 
		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		CAST('' as varchar(100)) AS NodeName  /* outer join doesnt allow branchnode name */

  	FROM 
	Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        AND Events.ProductName != 'ePO Agent' 
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang

END
ELSE
BEGIN			/* non admin users sees only events tied to their nodes */



 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE ProductVersion
	   		WHEN '' THEN '---' 
	   		ELSE ProductVersion
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE VirusName
	   		WHEN '' THEN '---' 
	   		ELSE VirusName
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE VirusType
	   		WHEN '' THEN '---' 
	   		ELSE VirusType
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		BranchNode.NodeName AS NodeName
 
 	FROM 
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Join Events on (Events.NodeID = LeafNode.AutoID)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   	AND ReportActionDesc.LanguageID = @szFullLang)
--		Events, LeafNode, BranchNode, ReportActionDesc 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        AND Events.ProductName != 'ePO Agent' 
--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
   	AND LeafNode.Type !=24      /* Uninstalled */ 

END

RETURN
END
GO



-- epo3: new removeable media routine: just returns removable media events (much fast)
-- fast group summary option removed - drilldown only format

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertRemovableMedia]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertRemovableMedia]
GO


CREATE PROCEDURE dbo.AVISP_FilterVAlertRemovableMedia
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)='Drilldown'	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved
 , @RemovableMedia      varchar(10)='A:'	--removable media drive letter
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @ret int

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

   Declare @MediaTest1 varchar(10)
   Declare @MediaTest2 varchar(10)
   Set @MediaTest1 = @RemovableMedia + '%'
   Set @MediaTest2 = '%' + @RemovableMedia + '%'

	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')

	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- not a group summary fetch, gets every row matching removable media
 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		,cast('' as varchar(16)) as 'Day'
		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,cast('' as varchar(10)) as ProductFamily
		,cast('' as varchar(10)) as ServicePack
		,cast('' as varchar(10)) as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- Agent info fields
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- Computer Info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
--		, '' as NodeID
		, NodeID
		, NodeID as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusType > ''  then VirusType.VirusType
			else case  when Events.VirusType > '' then Events.VirusType else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,'' as EventDesc
		
		, '' as RuleName

		-- Product update fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 
	and 
	(
		Events.Filename = @RemovableMedia
		or
		Events.Filename like @MediaTest1
		or
		Events.Filename like @MediaTest2
	)




	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		



RETURN @ret
END
GO


/**/
/* xxxxxxx ePO v2.5 8/15/2001     Addon Reports - Virus Type Report xxxxxxxxxxxxxx */
/* epo 2.5.0 hf3 & 2.5.1 */
-- epo3.0 changed to give top reiority ti events.virustype field (best recognition of trojans)
-- Changed to used same inputs and outputs as custom data report, so that the custom data rpt (template) can be used to display it
/**/

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVirusType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVirusType]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO




CREATE PROCEDURE dbo.AVISP_FilterVirusType
(
	@iNameSpaceName		VARCHAR(20),
	@iNameSpaceNode		VARCHAR(20),
    	@szEpoUserName          VARCHAR(100),
	@szNameSpaceName		VARCHAR(100),
	@szNameSpaceNode		VARCHAR(500),
 	@szOptionalReportParms  VARCHAR(500) = ''
 -- these inputs are needed in order for the infections by custom daat report to call this procedure
 , @szGroupName1  VARCHAR(100) = 'VirusType'
 , @szGroupName2  VARCHAR(100) = 'VirusSubtype'
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)='Drilldown'	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved

/*	 , @dtStartDate			DateTime */
)
AS
BEGIN
 	/* Copyright + 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	Declare @maxid int
	Declare @ret int

/* Fetch Top Nodeid to filter data on if report filter or users TopNode indicated filtering */
	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int	select @UsersTopNodeID = convert(int, @iNameSpaceName)
	select @FilterNodeID = convert(int, @iNameSpaceNode)

	Declare @FilterID int
	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



----------------
-- Make sure tmp tables are cleaned up
-- postepo3 collation between epo db and tempdb can be different, therefore dont use tempdb anymore, cleanup myself

	IF EXISTS (select * from sysobjects where name = 'tmpVirusname' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusname

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileType' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileType

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtype' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtype


/* Fetch all unique VirusNames, with the latest VirusType entry */
SELECT
	VirusName
	, max( DATVersion + 'VT:' + VirusType) as 'LatestVirusType'
	, 'Blank virus type' as VirusType
into dbo.tmpVirusname
FROM Events
where virusname > ''
Group by
	VirusName

/* Strip the virustype data out of the latestvirustype field */
update
dbo.tmpVirusname
set VirusType = 
substring( LatestVirusType 
	, charindex('VT:',LatestVirusType)+3 
	, Len(LatestVirusType)-charindex('VT:',LatestVirusType)+3)




/* match virusname with cross product of all matching virus file platform type prefixes */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusFiletypeCrossProduct
FROM
	dbo.tmpVirusname, VirusFilePlatformTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusFilePlatformTypeDesc.VirusPrefix, dbo.tmpVirusname.VirusName), 
		len(VirusFilePlatformTypeDesc.VirusPrefix) ) = VirusFilePlatformTypeDesc.VirusPrefix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from VirusFilePlatformTypeDesc
	INSERT dbo.tmpVirusFiletypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusFiletypePriority
	FROM
		dbo.tmpVirusFiletypeCrossProduct
	GROUP BY
		VirusName


	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusFileType,
	 	VirusPlatformType,
		VirusType
	INTO
		dbo.tmpVirusFiletype
	FROM
		dbo.tmpVirusFiletypePriority, VirusFilePlatformTypeDesc
	WHERE
		dbo.tmpVirusFiletypePriority.Priority = VirusFilePlatformTypeDesc.AutoID

	

/* match virusname with cross product of all matching virus file platform type */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusSubtypeCrossProduct
FROM
	dbo.tmpVirusname, VirusTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusTypeDesc.VirusSuffix, dbo.tmpVirusname.VirusName), 
		len(VirusTypeDesc.VirusSuffix) ) = VirusTypeDesc.VirusSuffix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from  VirusTypeDesc
	INSERT dbo.tmpVirusSubtypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusSubtypePriority
	FROM
		dbo.tmpVirusSubtypeCrossProduct
	GROUP BY
		VirusName
		

	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusType
	INTO
		dbo.tmpVirusSubtype
	FROM
		dbo.tmpVirusSubtypePriority, VirusTypeDesc
	WHERE
		dbo.tmpVirusSubtypePriority.Priority = VirusTypeDesc.AutoID



/* Generate final VirusType Table from subtables */
DELETE VirusType 

INSERT 
	VirusType
(VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID)
	SELECT
		 dbo.tmpVirusname.VirusName,
  		 VirusFileType,
 		 VirusPlatformType,
 		 VirusType = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
--		 NULL, NULL,
 		 VirusTypeTranslated = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
		 '0409' as LanguageID
	FROM
		dbo.tmpVirusname, dbo.tmpVirusFiletype, dbo.tmpVirusSubtype
	WHERE
		dbo.tmpVirusname.VirusName = dbo.tmpVirusFiletype.VirusName 
		AND	dbo.tmpVirusFiletype.VirusName = dbo.tmpVirusSubtype.VirusName 

Set @ret = @@rowcount

-- mhilandepo3 postepo3 fix: 1) make sure VirusTypeTranslated is overridden as well 2) dont overwrite if VT < 'a'
-- mhilandepo3 subtitute events.virustype where suffix prefix rules fail
/* Override VirusType derived from VirusName with certain fields from the events.virustype field */
UPDATE
	VirusType
	SET	
		VirusFileType = 
			CASE VirusType.VirusType
				WHEN 'Mass Mailer' then 'Mass Mailer'
				else VirusType.VirusFileType
			END
		,VirusType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'APP' then 'Application'
--				WHEN 'Program' then 'Program'
				WHEN 'Trojan' then 'Trojan'
				WHEN 'Joke' then 'Joke'
				WHEN 'Test' then 'Test'
				else VirusType.VirusType
			END
		,VirusTypeTranslated = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'APP' then 'Application'
				WHEN 'Trojan' then 'Trojan'
				WHEN 'Joke' then 'Joke'
				WHEN 'Test' then 'Test'
				WHEN 'Program' then 'Program'
				else VirusType.VirusType
			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND dbo.tmpVirusname.VirusType in ('APP','Trojan','Joke','Test'
			 ,'Program' )

/* Replace uncategorized viruses with data in events.virustype field */
UPDATE
	VirusType
	SET
		VirusType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
--		VirusTypeTranslated = 
--			CASE dbo.tmpVirusname.VirusType
--				WHEN 'Known Virus' then 'Virus'
--				WHEN 'Virus' then 'Virus'
--				WHEN '' then 'UnCategorized'
--				WHEN NULL then 'UnCategorized'
--				else dbo.tmpVirusname.VirusType
--			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


UPDATE
	VirusType
	SET
		VirusFileType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusFileType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


-- Translate it everytime
-- Translate VirusType name
--if @szFullLang <> '0409'
--begin
UPDATE
	VirusType
	SET
		VirusTypeTranslated =  
			CASE 
				WHEN ReportTranslations.TranslatedValue > '' then ReportTranslations.TranslatedValue
				else VirusType.VirusType
			END
	FROM	ReportTranslations
	WHERE	ReportTranslations.TextID = VirusType.VirusType
		AND ReportTranslations.Subject = 'Virustype'
		AND ReportTranslations.LanguageID = @szFullLang

Update VirusType
	Set LanguageID = @szFullLang
--end


/*select * from virustype*/


-- Output results if not set to batch mode (otherwise it only updates the virustype table
IF @szOptionalReportParms <> 'BatchModeUpdateTableOnly'
Begin

	
/* Final Selection getting all Event data for report */
-- virus type report works in fast group summary fetch mode only


 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		,cast('' as varchar(16)) as 'Day'
		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,cast('' as varchar(10)) as ProductFamily
		,cast('' as varchar(10)) as ServicePack
		,cast('' as varchar(10)) as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- Agent info fields
--		, LeafNode.AgentVersion
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- Computer Info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows
--    		, (CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, LeafNode.LastUpdate as LastContact
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
		, '' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusType > ''  then VirusType.VirusType
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
--		,'' as VirusType
		, VirusType.VirusTypeTranslated as VirusType
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then 'Informational'
			when 1 then 'Warning'
			when 2 then 'Minor'
			when 3 then 'Major'
			when 4 then 'Critical'
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, ScanTime 
		,'' as ScanTime
		,'' as EventDesc
		
		, '' as RuleName

		-- Product update fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
   	(
	BranchNode Join LeafNode on (LeafNode.ParentID = BranchNode.AutoID) 
	Join ComputerProperties on (ComputerProperties.ParentID = LeafNode.AutoID)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
	) on (Events.NodeID = LeafNode.AutoID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR

  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		Events.VirusName > '' 
    		OR
		Events.VirusType > ''
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
--	AND Events.VirusName = VirusType.VirusName
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' ) 
		or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	)
        AND Events.ProductName != 'ePO Agent' 
        AND Events.ProductName != 'ePO Agent' 
--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
/*   	AND LeafNode.Type =1 */

	-- fast group summary group by clause
	Group By
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		DateName(Year, EventDateTime)
--		,Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month'
--		,Datename(Week, EventDateTime)
--		,Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform


--END	-- FilterID

Set @ret = @@rowcount

END	-- BatchModeUpdateTableOnly


/* cleanup */
	DROP TABLE dbo.tmpVirusname
	DROP TABLE dbo.tmpVirusFiletypeCrossProduct
	DROP TABLE dbo.tmpVirusSubtypeCrossProduct
	DROP TABLE dbo.tmpVirusFiletypePriority
	DROP TABLE dbo.tmpVirusSubtypePriority
	DROP TABLE dbo.tmpVirusFiletype
	DROP TABLE dbo.tmpVirusSubtype


RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_TranslateVirusType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_TranslateVirusType]
GO

CREATE PROCEDURE dbo.AVISP_TranslateVirusType
(
	@szFullLang		VARCHAR(10)
)
as
BEGIN
-- Translate VirusType name

Declare @CurrentLanguage varchar(10)

select top 1 @CurrentLanguage=LanguageID 
from VirusType

-- retranslate virustype table if it differs
if @CurrentLanguage <> @szFullLang
begin
UPDATE
	VirusType
	SET
		VirusTypeTranslated =  
			CASE 
				WHEN ReportTranslations.TranslatedValue > '' then ReportTranslations.TranslatedValue
				else VirusType.VirusType
			END
	FROM	ReportTranslations
	WHERE	ReportTranslations.TextID = VirusType.VirusType
		AND ReportTranslations.Subject = 'Virustype'
		AND ReportTranslations.LanguageID = @szFullLang

Update VirusType
	Set LanguageID = @szFullLang
end

end
GO

/**** xxxxxxx  outbreak report procs xxxxxxx ****/


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_CalculateOutbreaks]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_CalculateOutbreaks]
GO

/* mhilandepo3 - The above stored procedure has been retired */
/* Original old outbreak report */

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO





/**/
/* xxxxxxx ePO v2.5 8/15/2001     Addon Reports - Outbreak History Report xxxxxxxxxxxxxx */
/* epo 2.5.0 hf3 & 2.5.1 */
/**/


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVirusAttacks]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVirusAttacks]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_FilterVirusAttacks
(
	@iNameSpaceName		VARCHAR(20)
	,@iNameSpaceNode		VARCHAR(20)
    	,@szEpoUserName          VARCHAR(100)
	,@szNameSpaceName		VARCHAR(100)
	,@szNameSpaceNode		VARCHAR(500)
	, @szMinMachineCount		VARCHAR(20)= '5'
	, @szMinFilenameCount		VARCHAR(20)= '5'
--	@iMinMachineCount		int, 
--	@iMinFilenameCount		int
 , @szOptionalReportParms  VARCHAR(500) = ''
/*	 , @dtStartDate			DateTime */
)
AS
BEGIN
 	/* Copyright + 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
	Declare @UsersTopNodeID int
	Declare @FilterNodeID int
	Declare @DayofWeek int



	select @UsersTopNodeID = convert(int, @iNameSpaceName)
	select @FilterNodeID = convert(int, @iNameSpaceNode)

	Declare @FilterID int
	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  

	Declare @iMinMachineCount int		
	Declare @iMinFilenameCount int		
	select @iMinMachineCount = convert(int, @szMinMachineCount)
	select @iMinFilenameCount = convert(int, @szMinFilenameCount)


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


------------------------
-- temp table cleanup

	IF EXISTS (select * from sysobjects where name = 'tmpOutbreakGroup' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOutbreakGroup

	IF EXISTS (select * from sysobjects where name = 'tmpOutbreakGroupLocal' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOutbreakGroupLocal




IF @szTime = 'GMT'			
BEGIN

	select 
		Events.Virusname,
   		case VirusType.VirusType
			when '' then	case Events.VirusType when '' then '---' else Events.VirusType end
			when null then	case Events.VirusType when '' then '---' else Events.VirusType end
			else VirusType.VirusType
			end as VirusType,
		datepart(year, eventdatetime) as dtyear,
		datepart(week, eventdatetime) as dtweek,
		count(*) as 'Total Events',
		count(distinct (hostname + filename)) as 'MachineFileCnt',
		count(distinct hostname) as 'MachinesCnt',
		count(distinct filename) as 'FilesCnt',
		min(Eventdatetime) as 'OutbreakStart',
		max(eventdatetime) as 'OutbreakEnd'

	into dbo.tmpOutbreakGroup 
	from 		-- use english entry
		Events Left Outer Join VirusType on (events.VirusName = VirusType.VirusName)
	where
 
		events.virusname > '' and HostName > ''
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
	group by
		events.virusname,
		datepart(year, eventdatetime),
		datepart(week, eventdatetime),
		events.virustype,
		virustype.virustype
	having 
		count(distinct filename) > @iMinFilenameCount
		or
		count(distinct hostname) > @iMinMachineCount
	order by 
		events.virusname, 
		dtweek

/*
select * from dbo.tmpOutbreakGroup order by  outbreakname
*/


/*
 Output select listing details of each occurrence 
*/
/*
*/


IF @FilterID = 0			/* admin user, must see all events, dont join to nodename   */
BEGIN


	select 
		Events.Virusname as 'OutbreakVirus'
		,dbo.tmpOutbreakGroup.VirusType as 'VirusType'
		,dbo.tmpOutbreakGroup.OutbreakStart as 'OutbreakStart'
		,dbo.tmpOutbreakGroup.OutbreakEnd as 'OutbreakEnd'
		,min(Events.Eventdatetime) as 'WeekStarting'
		,'' as NumberofOutbreakPeriods
		,min(Events.Eventdatetime) as FirstOutbreakEvent 
		,'' as LastOutbreakEvent
		,dbo.tmpOutbreakGroup.MachineFileCnt as 'TotalEvents'
		,dbo.tmpOutbreakGroup.MachinesCnt as 'MachinesCnt'
		,dbo.tmpOutbreakGroup.FilesCnt as 'FilesCnt'
		,dbo.tmpOutbreakGroup.MachineFileCnt as 'MachineFileCnt'
		,CAST('' as varchar(100)) AS NodeName
		,min(Events.Eventdatetime) as EventDateTime
		,cast(Events.HostName as varchar(50)) As HostName
		,Events.HostIPAddress
		,Events.VirusName
		,cast(Events.FileName as varchar(200)) As FileName
		,Events.EngineVersion
		,Events.DATVersion
   		,ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END
		,Events.username
		,Events.productname
		,Events.productversion
		,datepart(year, Events.eventdatetime) as evdtyear
		,datepart(week, Events.eventdatetime) as evdtweek
		,(convert( varchar(5), datepart(year, Events.eventdatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventdatetime)) + 'Q')
			as evdtquarter

	from 
		Events Join dbo.tmpOutbreakGroup on (Events.Virusname = dbo.tmpOutbreakGroup.Virusname)
	  	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
	   		AND ReportActionDesc.LanguageID = @szFullLang)
--		Events, dbo.tmpOutbreakGroup, ReportActionDesc
	where

		Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
--		AND Events.Virusname = dbo.tmpOutbreakGroup.Virusname
		AND datepart(year, Events.eventdatetime) = dbo.tmpOutbreakGroup.dtyear
		AND datepart(week, Events.eventdatetime) = dbo.tmpOutbreakGroup.dtweek
--	  	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--	   	AND ReportActionDesc.LanguageSuffix = @szLang
	group by
		Events.virusname,
		dbo.tmpOutbreakGroup.VirusType,
		dbo.tmpOutbreakGroup.OutbreakStart,
		dbo.tmpOutbreakGroup.OutbreakEnd,
		datepart(year, Events.eventdatetime),
		convert( varchar(5), datepart(year, Events.eventdatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventdatetime)) + 'Q',
		datepart(week, Events.eventdatetime),
		Events.hostname,
		Events.hostipaddress,
		Events.username,
		Events.productname,
		Events.productversion,
		Events.engineversion,
		Events.datversion,
		Events.filename,
		Events.actiontaken,
		ReportActionDesc.ActionName,
		dbo.tmpOutbreakGroup.MachineFileCnt,
		dbo.tmpOutbreakGroup.MachinesCnt,
		dbo.tmpOutbreakGroup.FilesCnt

/*	
Dont include this order by clause in production - test only

		ORDER BY OutbreakName, EventTime 

*/

END
ELSE
BEGIN



	select 
		Events.Virusname as 'OutbreakVirus'
		,dbo.tmpOutbreakGroup.VirusType as 'VirusType'
		,dbo.tmpOutbreakGroup.OutbreakStart as 'OutbreakStart'
		,dbo.tmpOutbreakGroup.OutbreakEnd as 'OutbreakEnd'
		,min(Events.Eventdatetime) as 'WeekStarting'
		,'' as NumberofOutbreakPeriods
		,min(Events.Eventdatetime) as FirstOutbreakEvent 
		,'' as LastOutbreakEvent
		,dbo.tmpOutbreakGroup.MachineFileCnt as 'TotalEvents'
		,dbo.tmpOutbreakGroup.MachinesCnt as 'MachinesCnt'
		,dbo.tmpOutbreakGroup.FilesCnt as 'FilesCnt'
		,dbo.tmpOutbreakGroup.MachineFileCnt as 'MachineFileCnt'
		,CAST('' as varchar(100)) AS NodeName
		,min(Events.Eventdatetime) as EventDateTime
		,cast(Events.HostName as varchar(50)) As HostName
		,Events.HostIPAddress
		,Events.VirusName
		,cast(Events.FileName as varchar(200)) As FileName
		,Events.EngineVersion
		,Events.DATVersion
   		,ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END
		,Events.username
		,Events.productname
		,Events.productversion
		,datepart(year, Events.eventdatetime) as evdtyear
		,datepart(week, Events.eventdatetime) as evdtweek
		,(convert( varchar(5), datepart(year, Events.eventdatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventdatetime)) + 'Q')
			as evdtquarter
	from 
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Join dbo.tmpOutbreakGroup on (Events.Virusname = dbo.tmpOutbreakGroup.Virusname)
	  	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
	   		AND ReportActionDesc.LanguageID = @szFullLang)
		-- Events, dbo.tmpOutbreakGroup, LeafNode, BranchNode, ReportActionDesc
	where
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)	
		AND Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
--		AND Events.Virusname = dbo.tmpOutbreakGroup.Virusname
		AND datepart(year, Events.eventdatetime) = dbo.tmpOutbreakGroup.dtyear
		AND datepart(week, Events.eventdatetime) = dbo.tmpOutbreakGroup.dtweek
--		AND Events.NodeID = LeafNode.AutoID
--		AND LeafNode.ParentID = BranchNode.AutoID
--	  	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--	   	AND ReportActionDesc.LanguageSuffix = @szLang
	group by
		Events.virusname,
		dbo.tmpOutbreakGroup.VirusType,
		dbo.tmpOutbreakGroup.OutbreakStart,
		dbo.tmpOutbreakGroup.OutbreakEnd,
		datepart(year, Events.eventdatetime),
		convert( varchar(5), datepart(year, Events.eventdatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventdatetime)) + 'Q',
		datepart(week, Events.eventdatetime),
		Events.hostname,
		Events.hostipaddress,
		Events.username,
		Events.productname,
		Events.productversion,
		Events.engineversion,
		Events.datversion,
		Events.filename,
		Events.actiontaken,
		ReportActionDesc.ActionName,
		dbo.tmpOutbreakGroup.MachineFileCnt,
		dbo.tmpOutbreakGroup.MachinesCnt,
		dbo.tmpOutbreakGroup.FilesCnt,
		BranchNode.NodeName



END







END		/* IF @szTime = 'GMT' */
ELSE
BEGIN		/* use EventLocalDateTime */

	select 
		Virusname,
		datepart(year, eventlocaldatetime) as dtyear,
		datepart(week, eventlocaldatetime) as dtweek,
		count(*) as 'Total Events',
		count(distinct (hostname + filename)) as 'MachineFileCnt',
		count(distinct hostname) as 'MachinesCnt',
		count(distinct filename) as 'FilesCnt',
		min(Eventlocaldatetime) as 'OutbreakStart',
		max(eventlocaldatetime) as 'OutbreakEnd'

	into dbo.tmpOutbreakGroupLocal 
	from Events
	where
 
		virusname > '' and HostName > ''
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 	
	group by
		virusname,
		datepart(year, eventlocaldatetime),
		datepart(week, eventlocaldatetime)
	having 
		count(distinct filename) > @iMinFilenameCount
		or
		count(distinct hostname) > @iMinMachineCount
	order by 
		virusname, dtweek


IF @FilterID = 0			/* admin user, must see all events, dont join to nodename   */
BEGIN




	select 
		Events.Virusname as OutbreakVirus,
		'' as VirusType,
		dbo.tmpOutbreakGroupLocal.OutbreakStart,
		dbo.tmpOutbreakGroupLocal.OutbreakEnd,
		min(Events.Eventlocaldatetime) as 'WeekStarting',
		'' as NumberofOutbreakPeriods,
		'' as FirstOutbreakEvent, 
		'' as LastOutbreakEvent,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt as 'TotalEvents',
		dbo.tmpOutbreakGroupLocal.MachinesCnt,
		dbo.tmpOutbreakGroupLocal.FilesCnt,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt as 'MachineFileCnt',
		CAST('' as varchar(100)) AS NodeName,
		min(Events.Eventlocaldatetime) as 'EventDateTime',
		   		cast(Events.HostName as varchar(50)) As HostName, 
		Events.HostIPAddress,
		Events.VirusName,
		   		cast(Events.FileName as varchar(200)) As FileName, 
		Events.EngineVersion,
		Events.DATVersion,
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		Events.username,
		Events.productname,
		Events.productversion,
		datepart(year, Events.eventlocaldatetime) as evdtyear,
		datepart(week, Events.eventlocaldatetime) as evdtweek,
		(convert( varchar(5), datepart(year, Events.eventlocaldatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventlocaldatetime)) + 'Q')
		as evdtquarter
	from 
		Events Join dbo.tmpOutbreakGroupLocal on (Events.Virusname = dbo.tmpOutbreakGroupLocal.Virusname)
	  	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
	   		AND ReportActionDesc.LanguageID = @szFullLang)
		-- Events, dbo.tmpOutbreakGroupLocal, ReportActionDesc
	where

		Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
--		AND Events.Virusname = dbo.tmpOutbreakGroupLocal.Virusname
		AND datepart(year, Events.eventlocaldatetime) = dbo.tmpOutbreakGroupLocal.dtyear
		AND datepart(week, Events.eventlocaldatetime) = dbo.tmpOutbreakGroupLocal.dtweek
--	  	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--	   	AND ReportActionDesc.LanguageSuffix = @szLang
	group by
		Events.virusname,
		dbo.tmpOutbreakGroupLocal.OutbreakStart,
		dbo.tmpOutbreakGroupLocal.OutbreakEnd,
		datepart(year, Events.eventlocaldatetime),
		convert( varchar(5), datepart(year, Events.eventlocaldatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventlocaldatetime)) + 'Q',
		datepart(week, Events.eventlocaldatetime),
		Events.hostname,
		Events.hostipaddress,
		Events.username,
		Events.productname,
		Events.productversion,
		Events.engineversion,
		Events.datversion,
		Events.filename,
		Events.actiontaken,
		ReportActionDesc.ActionName,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt,
		dbo.tmpOutbreakGroupLocal.MachinesCnt,
		dbo.tmpOutbreakGroupLocal.FilesCnt

/*	
Dont include this order by clause in production - test only

		ORDER BY OutbreakName, EventTime 

*/

END
ELSE
BEGIN



	select 
		Events.Virusname as OutbreakVirus,
		'' as VirusType,
		dbo.tmpOutbreakGroupLocal.OutbreakStart,
		dbo.tmpOutbreakGroupLocal.OutbreakEnd,
		min(Events.Eventlocaldatetime) as 'WeekStarting',
		'' as NumberofOutbreakPeriods,
		'' as FirstOutbreakEvent, 
		'' as LastOutbreakEvent,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt as 'TotalEvents',
		dbo.tmpOutbreakGroupLocal.MachinesCnt,
		dbo.tmpOutbreakGroupLocal.FilesCnt,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt as 'MachineFileCnt',
		CAST('' as varchar(100)) AS NodeName,
		min(Events.Eventlocaldatetime) as 'EventDateTime',
		   		cast(Events.HostName as varchar(50)) As HostName, 
		Events.HostIPAddress,
		Events.VirusName,
		   		cast(Events.FileName as varchar(200)) As FileName, 
		Events.EngineVersion,
		Events.DATVersion,
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		Events.username,
		Events.productname,
		Events.productversion,
		datepart(year, Events.eventlocaldatetime) as evdtyear,
		datepart(week, Events.eventlocaldatetime) as evdtweek,
		(convert( varchar(5), datepart(year, Events.eventlocaldatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventlocaldatetime)) + 'Q')
		as evdtquarter

/*		Events.Virusname as OutbreakName,
		dbo.tmpOutbreakGroupLocal.OutbreakStart,
		dbo.tmpOutbreakGroupLocal.OutbreakEnd,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt as 'OutbreakCount',
		min(Events.Eventlocaldatetime) as 'WeekStarting',
   		BranchNode.NodeName AS NodeName, 
		min(Events.Eventlocaldatetime) as 'EventDateTime',
	   		cast(Events.HostName as varchar(50)) As HostName, 
		Events.HostIPAddress,
		Events.VirusName,
	   		cast(Events.FileName as varchar(200)) As FileName, 
		Events.EngineVersion,
		Events.DATVersion,
   		ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END,
		datepart(year, Events.eventlocaldatetime) as evdtyear,
		datepart(week, Events.eventlocaldatetime) as evdtweek,
		dbo.tmpOutbreakGroupLocal.MachinesCnt,
		dbo.tmpOutbreakGroupLocal.FilesCnt,
		Events.username,
		Events.productname,
		Events.productversion,
		(convert( varchar(5), datepart(year, Events.eventlocaldatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventlocaldatetime)) + 'Q')
		as evdtquarter
*/
	from
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Join dbo.tmpOutbreakGroupLocal on (Events.Virusname = dbo.tmpOutbreakGroupLocal.Virusname)
	  	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
	   		AND ReportActionDesc.LanguageID = @szFullLang)
			--Events, dbo.tmpOutbreakGroupLocal, LeafNode, BranchNode, ReportActionDesc
	where
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)	
		AND Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
--		AND Events.Virusname = dbo.tmpOutbreakGroupLocal.Virusname
		AND datepart(year, Events.eventlocaldatetime) = dbo.tmpOutbreakGroupLocal.dtyear
		AND datepart(week, Events.eventlocaldatetime) = dbo.tmpOutbreakGroupLocal.dtweek
--		AND Events.NodeID = LeafNode.AutoID
--		AND LeafNode.ParentID = BranchNode.AutoID
--	  	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--	   	AND ReportActionDesc.LanguageSuffix = @szLang
	group by
		Events.virusname,
		dbo.tmpOutbreakGroupLocal.OutbreakStart,
		dbo.tmpOutbreakGroupLocal.OutbreakEnd,
		datepart(year, Events.eventlocaldatetime),
		convert( varchar(5), datepart(year, Events.eventlocaldatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventlocaldatetime)) + 'Q',
		datepart(week, Events.eventlocaldatetime),
		Events.hostname,
		Events.hostipaddress,
		Events.username,
		Events.productname,
		Events.productversion,
		Events.engineversion,
		Events.datversion,
		Events.filename,
		Events.actiontaken,
		ReportActionDesc.ActionName,
		dbo.tmpOutbreakGroupLocal.MachineFileCnt,
		dbo.tmpOutbreakGroupLocal.MachinesCnt,
		dbo.tmpOutbreakGroupLocal.FilesCnt,
		BranchNode.NodeName



END






END		/* GMT/LOCAL time */



/* cleanup */

IF @szTime = 'GMT'			/* admin user, must see all events, dont join to nodename   */
BEGIN
	DROP TABLE dbo.tmpOutbreakGroup
END
ELSE
BEGIN
	DROP TABLE dbo.tmpOutbreakGroupLocal
END

/*
*/

END
GO








/***************************************************************/
/* xxxxxxx epo3.0 reports - 5/14/2k2 xxxxxxx */



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetDateConversion]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetDateConversion]
GO

CREATE PROCEDURE dbo.AVISP_GetDateConversion
(
 @InfectAfterYYYYMMDD nvarchar(30) 
 , @InfectAfterRule nvarchar(30) 
 , @YYYYMMDD datetime output

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	Declare @ret int
	Set @ret = 1

	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
	Declare @year nchar(4)
	set @year = convert(nchar(4),DatePart(year,GetDate())) 
	if @InfectAfterYYYYMMDD > ''
		set @YYYYMMDD = convert( datetime, @InfectAfterYYYYMMDD, 120)
	else
	begin
		if lower(@InfectAfterRule) = 'all'
			set @YYYYMMDD = DateAdd(year, -100, GetDate());
		else if lower(@InfectAfterRule) = 'day1'
			set @YYYYMMDD = DateAdd(day, -1, GetDate());
		else if lower(@InfectAfterRule) = 'day2'
			set @YYYYMMDD = DateAdd(day, -2, GetDate());
		else if lower(@InfectAfterRule) = 'day3'
			set @YYYYMMDD = DateAdd(day, -3, GetDate());
		else if lower(@InfectAfterRule) = 'day4'
			set @YYYYMMDD = DateAdd(day, -4, GetDate());
		else if lower(@InfectAfterRule) = 'day5'
			set @YYYYMMDD = DateAdd(day, -5, GetDate());
		else if lower(@InfectAfterRule) = 'day6'
			set @YYYYMMDD = DateAdd(day, -6, GetDate());
		else if lower(@InfectAfterRule) = 'week1'
			set @YYYYMMDD = DateAdd(week, -1, GetDate());
		else if lower(@InfectAfterRule) = 'week2'
			set @YYYYMMDD = DateAdd(week, -2, GetDate());
		else if lower(@InfectAfterRule) = 'week3'
			set @YYYYMMDD = DateAdd(week, -3, GetDate());
		else if lower(@InfectAfterRule) = 'week4'
			set @YYYYMMDD = DateAdd(week, -4, GetDate());
		else if lower(@InfectAfterRule) = 'month1'
			set @YYYYMMDD = DateAdd(month, -1, GetDate());
		else if lower(@InfectAfterRule) = 'month2'
			set @YYYYMMDD = DateAdd(month, -2, GetDate());
		else if lower(@InfectAfterRule) = 'month3'
			set @YYYYMMDD = DateAdd(month, -3, GetDate());
		else if lower(@InfectAfterRule) = 'year1'
			set @YYYYMMDD = DateAdd(year, -1, GetDate());
		else if lower(@InfectAfterRule) = 'CurrentDay'
			set @YYYYMMDD = DateAdd(hour, -(DatePart(hour,GetDate())), DateAdd(minute, -(DatePart(minute,GetDate())), GetDate()) );
		else if lower(@InfectAfterRule) = 'CurrentWeek'
			set @YYYYMMDD = DateAdd(day, -(DatePart(weekday,GetDate())-1), GetDate());
		else if lower(@InfectAfterRule) = 'CurrentMonth'
			set @YYYYMMDD = DateAdd(day, -(DatePart(day,GetDate())-1), GetDate());
		else if lower(@InfectAfterRule) = 'CurrentQuarter'
		begin
			if DatePart(quarter,GetDate()) =1
				 set @YYYYMMDD = convert( datetime, (@Year+'0101'), 112)	
			else if DatePart(quarter,GetDate()) =2
				 set @YYYYMMDD = convert( datetime, (@Year+'0401'), 112)		
			else if DatePart(quarter,GetDate()) =3
				 set @YYYYMMDD = convert( datetime, (@Year+'0701'), 112)		
			else if DatePart(quarter,GetDate()) =4
				 set @YYYYMMDD = convert( datetime, (@Year+'1001'), 112)			
		end			
		else if lower(@InfectAfterRule) = 'CurrentYear'
			set @YYYYMMDD = convert( datetime, (@Year+'0101'), 112)	
		else if lower(@InfectAfterRule) > ''	-- rule not found
			set @ret = 0
	end

RETURN @ret
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetInfectionGroup]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetInfectionGroup]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetInfectionGroup
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt = TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


 --------------------------------------------
 -- Select field values
 -- First column must be called: Value
 -- second column must be called: Prompt

 IF @szFilter = 'ChartType'
 BEGIN 
	
	-- Fetch Localized names
	-- Trick - combine localized value with textid and send to report, the report will key off the textid
	-- Original idea
/*
	SELECT Distinct TextValue + '(' + TextID + ')'as Value 
	FROM	
		ReportTextPromptStrings
	WHERE
		TextID in ( 'Bar', 'Pie', 'SBar', 'PieBar', '3D Bar', 'CrossTab'  )
		AND	LanguageID = @szLanguageID
		AND	
			(ReportTextPromptStrings.ReportID = @szReportID
			OR
			ReportTextPromptStrings.RptGroupID = @szRptGroup)
*/

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = 'ChartType'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)


 END
 ELSE IF @szFilter = 'NumGroupsOnMainPage'
 BEGIN
	SELECT '2' as Value, '2' as Prompt
 END
 ELSE IF @szFilter = '@szDrilldown'
 BEGIN
	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = '@szDrilldown'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

 END
 ELSE IF @szFilter = '@szGroupName1'
 BEGIN

	-- Fetch Localized names
	-- Trick - combine localized value with textid and send to report, the report will key off the textid
--	SELECT Distinct TextValue + '(' + TextID + ')'as '@szGroupName1'
--	FROM	
--		ReportTextPromptStrings
--	WHERE
--		TextID in ( 'Year', 'Quarter', 'Month', 'Week', 'Virusname', 'Action', 'Filename', 'Hostname', 'Nodename', 'Productnameversion', 'Enginedat'  )
--		AND	LanguageID = @szLanguageID
--		AND	
--			(ReportTextPromptStrings.ReportID = @szReportID
--			OR
--			ReportTextPromptStrings.RptGroupID = @szRptGroup)
	

	SELECT Distinct ParmValue as Value, Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = '@szGroupName_'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)


 END
 ELSE IF @szFilter = '@szGroupName2'
 BEGIN

	-- Fetch Localized names

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = '@szGroupName_'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

	
 END
 ELSE IF @szFilter = '@szGroupName3'
 BEGIN

	-- Fetch Localized names

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = '@szGroupName_'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

	
 END
 ELSE IF @szFilter = '@szGroupName4'
 BEGIN

	-- Fetch Localized names

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = '@szGroupName_'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

	
 END
 ELSE
 BEGIN

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = @szFilter
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

 END


 Set @ret = @@rowcount
 if @ret = 0
		SELECT '---' as Value , '---' as Prompt

 RETURN @ret 

END
GO


----------------------------------------------------------------



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutInfectionGroup]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutInfectionGroup]
GO



CREATE PROCEDURE dbo.AVISP_FieldPutInfectionGroup
(
    @iNameSpaceName  int
    ,@iNameSpaceNode         int
    ,@szEpoUserName           VARCHAR(100)
    ,@szOptionalReportParms 	 VARCHAR(500) = ''
    ,@szFieldName		VARCHAR(64) = ''
    ,@szFieldValue		VARCHAR(256) = ''
    ,@szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @rec int
 Set @rec = 0

 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang     VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID  VARCHAR(5)
   Declare @szTime     VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


 ----------------------------------------------------------------
 -- Make sure both values are input otherwise use one to set the other
	if @szFieldValue > '' and ( @szFieldValuePrompt = '' or @szFieldValuePrompt is NULL)
		set @szFieldValuePrompt = @szFieldValue

	if @szFieldValuePrompt > '' and ( @szFieldValue = '' or @szFieldValue is NULL)
		set @szFieldValue = @szFieldValuePrompt




 -- These updates are all the same, but this is how the code would look if the field needed to be handled differently

 IF @szFieldName = 'ChartType'
 BEGIN 
	
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue = @szFieldValue
		, ReportInputParameters.ParmValuePrompt = @szFieldValuePrompt
	WHERE
		ReportInputParameters.ParmName = @szFieldName
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)
	
	Set @rec = @@rowcount
 END 
 ELSE
 BEGIN
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue = @szFieldValue
		, ReportInputParameters.ParmValuePrompt = @szFieldValuePrompt
	WHERE
		ReportInputParameters.ParmName = @szFieldName
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)
	Set @rec = @@rowcount

	-- check for error
	if @rec = 0
	begin
		Select @szResult = TranslatedValue
			from ReportTranslations
			where Subject = 'General' and TextID = 'Parameter not saved to Database'
				and LanguageID = @szFullLang
		if @@rowcount = 0    Set @szResult = 'Parameter not saved to Database'
		SELECT @szResult + ': ' + @szReportID + ': ' + @szRptGroup + ': ' + @szFieldValue + ': ' + @szFieldValue
	end 
END

 -- Return Result String
 SELECT @szResult as szResult

 RETURN @rec

END

GO


------------------------------------------------------------------------------
------------------------------------------------------------------------------
--  AVISP_FieldGetDATEng

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetDATEng]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetDATEng]
GO

CREATE PROCEDURE dbo.AVISP_FieldGetDATEng
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

 
-- check for product based on @szFilter=software name 
 Declare @prodcnt int
 Declare @datcnt int
 Declare @engcnt int
 Declare @Filter nvarchar(50)

-- set @Filter = substring


 select @datcnt=count(*)
	from AVIView_Software
	where 
	@szFilter like (ProductFamily + 'DAT%')

 select @engcnt=count(*)
	from AVIView_Software
	where 
	@szFilter like (ProductFamily + 'Engine%')


-- check for DAT version based on @szFilter=ProductFamily + '_dats' 

 IF @datcnt > 0  -- fetch DAT versions
 BEGIN 

    -- postepo3: exclude ver = N/A
    SELECT DISTINCT 
	   Value =
    			(CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer
     			ELSE '---'
     			END)
		, '' as Prompt
       FROM ProductProperties, AVIView_Software
       WHERE 
	    ProductProperties.ProductCode = AVIView_Software.ProductCode
	and DATVer not in ('5000', 'N/A')
	and @szFilter like (ProductFamily + 'DAT%')
--    UNION
--	select '1st Most Recent Version' as value , '' as Prompt
--    UNION
--	select '2nd Most Recent Version' as value , '' as Prompt
--    UNION
--	select '3rd Most Recent Version' as value, '' as Prompt
    ORDER BY Value desc	

 END


-- check for Engine version based on @szFilter=ProductFamily + '_Engines' 


 else
 IF @engcnt > 0  -- fetch Engine versions
 BEGIN 
	
    SELECT DISTINCT 
	   Value =
    			(CASE 
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
     			ELSE '---'
     			END)
		, '' as Prompt
       FROM ProductProperties, AVIView_Software
       WHERE 
	    ProductProperties.ProductCode = AVIView_Software.ProductCode
--	and EngineVer != 'N/A'
	and EngineVer not in ('5000', 'N/A')
	and @szFilter like (ProductFamily + 'Engine%')
--    UNION
--	select '1st Most Recent Version' as value , '' as Prompt
--    UNION
--	select '2nd Most Recent Version' as value , '' as Prompt
--    UNION
--	select '3rd Most Recent Version' as value, '' as Prompt
    ORDER BY Value desc	

 END

----------------------------
	
 ELSE
 BEGIN

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = @szFilter
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

	
 END

 Set @ret = @@rowcount
 if @ret = 0
		SELECT '---' as Value , '---' as Prompt

 RETURN @ret 

END
GO



------------------------------------------------------------------------------
------------------------------------------------------------------------------


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetComplianceIssues]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetComplianceIssues
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

 
-- check for product based on @szFilter=software name 
 Declare @prodcnt int
 Declare @datcnt int
 Declare @engcnt int

 select @prodcnt=count(*)
	from AVIView_Software
	where 
	( ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
		or (ProductFamily = 'EPO' and ProductCode Like 'EPOAGENT%') 
		or ProductFamily like ('TVD_NC_%'))
	and SoftwareName = @szFilter


 select @datcnt=count(*)
	from AVIView_Software
	where 
	 (ProductFamily in ('TVD', 'TVD_NC')
		or ProductFamily like ('TVD_NC_%'))
	and (ProductFamily + '_DATs') = @szFilter

 select @engcnt=count(*)
	from AVIView_Software
	where 
	 (ProductFamily in ('TVD', 'TVD_NC')
		or ProductFamily like ('TVD_NC_%'))
	and (ProductFamily + '_Engines') = @szFilter



 IF @prodcnt > 0  -- fetch product versions
 BEGIN 
	
	-- Fetch Localized names

    SELECT DISTINCT 
	   Value =
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
--		, '' as Prompt
	INTO #TmpProdVer	
       FROM ProductProperties, AVIView_Software
       WHERE 
	    ProductProperties.ProductCode = AVIView_Software.ProductCode
          AND AVIView_Software.SoftwareName = @szFilter
	and ProductProperties.ProductVersion not in ('5000', 'N/A')

	ORDER BY Value desc	

	-- special case processing, remove virusscan wrk and svr suffix from product version)
	update  #TmpProdVer Set Value = Replace(Value, '.wrk', '') 
	update  #TmpProdVer Set Value = Replace(Value, '.srv', '') 

	Select distinct Value, '' as Prompt from #TmpProdVer
	ORDER BY Value desc	

	Drop Table #TmpProdVer

 END


-- check for DAT version based on @szFilter=ProductFamily + '_dats' 


 else
 IF @datcnt > 0  -- fetch DAT versions
 BEGIN 

    SELECT DISTINCT 
	   Value =
    			(CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer
     			ELSE '---' 
     			END)
		, '' as Prompt
       FROM ProductProperties, AVIView_Software
       WHERE 
	    ProductProperties.ProductCode = AVIView_Software.ProductCode
	and ProductProperties.DATVer not in ('5000', 'N/A')
          AND (AVIView_Software.ProductFamily + '_DATs') = @szFilter
--    UNION
--	select '1st Most Recent Version' as value , '' as Prompt
--    UNION
--	select '2nd Most Recent Version' as value , '' as Prompt
--    UNION
--	select '3rd Most Recent Version' as value, '' as Prompt
    ORDER BY Value desc	

 END


-- check for Engine version based on @szFilter=ProductFamily + '_Engines' 


 else
 IF @engcnt > 0  -- fetch Engine versions
 BEGIN 
	
    SELECT DISTINCT 
	   Value =
    			(CASE 
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     			ELSE '---'
     			END)
		, '' as Prompt
       FROM ProductProperties, AVIView_Software
       WHERE 
	    ProductProperties.ProductCode = AVIView_Software.ProductCode
--	  AND ProductProperties.EngineVer != 'N/A'
	and ProductProperties.EngineVer not in ('5000', 'N/A')
          AND (AVIView_Software.ProductFamily + '_Engines') = @szFilter
--    UNION
--	select '1st Most Recent Version' as value , '' as Prompt
--    UNION
--	select '2nd Most Recent Version' as value , '' as Prompt
--    UNION
--	select '3rd Most Recent Version' as value, '' as Prompt
    ORDER BY Value desc	

 END

----------------------------
	
 ELSE
 BEGIN

	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = @szFilter
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

 END

 Set @ret = @@rowcount
 if @ret = 0
		SELECT '---' as Value , '---' as Prompt

 RETURN @ret 


END
GO


----------------------------------------------------------------_
------------------------------------------------------------------

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutComplianceIssues]
GO




CREATE PROCEDURE dbo.AVISP_FieldPutComplianceIssues
(
    @iNameSpaceName  int
    ,@iNameSpaceNode         int
    ,@szEpoUserName           VARCHAR(100)
    ,@szOptionalReportParms 	 VARCHAR(500) = ''
    ,@szFieldName		VARCHAR(64) = ''
    ,@szFieldValue		VARCHAR(256) = ''
    ,@szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''
   Declare @ret int

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Make sure both values are input otherwise use one to set the other
	if @szFieldValue > '' and ( @szFieldValuePrompt = '' or @szFieldValuePrompt is NULL)
		set @szFieldValuePrompt = @szFieldValue

	if @szFieldValuePrompt > '' and ( @szFieldValue = '' or @szFieldValue is NULL)
		set @szFieldValue = @szFieldValuePrompt



 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- second column must to be called: Prompt


 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue = @szFieldValue
		, ReportInputParameters.ParmValuePrompt = @szFieldValuePrompt
	WHERE
		ReportInputParameters.ParmName = @szFieldName
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)
	
	set @ret = @@rowcount

	if @ret = 0
	begin
		Select @szResult = TranslatedValue
			from ReportTranslations
			where Subject = 'General' and TextID = 'Parameter not saved to Database'
				and LanguageID = @szFullLang
		if @@rowcount = 0    Set @szResult = 'Parameter not saved to Database'
		SELECT @szResult + ': ' + @szReportID + ': ' + @szRptGroup + ': ' + @szFieldValue + ': ' + @szFieldValue
	end

 -- Return Result String
 SELECT @szResult as szResult


 RETURN @ret

END
GO



----------------------------------------------------------------
----------------------------------------------------------------
-- AVISP_FieldGetProductSettingIssues

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetProductSettingIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetProductSettingIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FieldGetProductSettingIssues
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
-- Currently all fields look the same (bools)

 IF @szFilter like 'VirusScan%'
 BEGIN 
	
	-- Fetch Localized names

	SELECT 
		ParmValue as Value
		, Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName like '%'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)


 END
 ELSE
 IF @szFilter like 'NetShield%'
 BEGIN 
	
	-- Fetch Localized names

	SELECT 
		ParmValue as Value
		, Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName like '%'
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)


 END
 ELSE
 IF @szFilter like '%'
 BEGIN 
	
	-- Fetch Localized names

	Declare @cnt int
	SELECT 
		@cnt=count(*) 
	FROM ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName like @szFilter
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

	-- Are parameter values defined in ReportInputParameterValues?
	IF @cnt > 0
	BEGIN 
		SELECT 
			ParmValue as Value
			, Prompt as Prompt
		FROM	
			ReportInputParameterValues
		WHERE
			ReportInputParameterValues.ParmName like @szFilter
			AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)
	END
	ELSE
	BEGIN
		
		-- Split up filter (format= Product:Section:Setting, find values in ProductSetting table using Product Section Setting
		Declare @pstart int
		Declare @pend int
		Declare @product varchar(50)
		Declare @section varchar(50)
		Declare @setting varchar(50)

		/* Get TIME parm */
		Set @pstart = CHARINDEX( ':', @szFilter) + 1
		Set @pend   = CHARINDEX( ':', @szFilter, @pstart)

		Set @product = SUBSTRING( @szFilter, 0, @pstart )
		Set @section = SUBSTRING( @szFilter, @pstart, (@pend - @pstart) )	
		Set @setting = SUBSTRING( @szFilter, (@pend+1), (len(@szFilter - @pend) ) )

		SELECT 
			distinct Value as Value
			, Value as Prompt
		FROM	
			ProductSettings, ProductProperties, AVIView_Software
		WHERE
			ProductSettings.ParentID = ProductProperties.AutoID
			and ProductProperties.ProductCode = AVIView_Software.ProductCode
			and AVIView_Software.SoftwareName = @product
			and ProductSettings.SectionName = @section
			and ProductSettings.SettingName = @setting

	END

 END
 ELSE
 BEGIN
	SELECT '---' as Value , '---' as Prompt
 END

 RETURN @@rowcount

END
GO


-----------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutProductSettingIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutProductSettingIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



CREATE PROCEDURE dbo.AVISP_FieldPutProductSettingIssues
(
    @iNameSpaceName  int
    ,@iNameSpaceNode         int
    ,@szEpoUserName           VARCHAR(100)
    ,@szOptionalReportParms 	 VARCHAR(500) = ''
    ,@szFieldName		VARCHAR(64) = ''
    ,@szFieldValue		VARCHAR(256) = ''
    ,@szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Make sure both values are input otherwise use one to set the other
	if @szFieldValue > '' and ( @szFieldValuePrompt = '' or @szFieldValuePrompt is NULL)
		set @szFieldValuePrompt = @szFieldValue

	if @szFieldValuePrompt > '' and ( @szFieldValue = '' or @szFieldValue is NULL)
		set @szFieldValue = @szFieldValuePrompt



 ----------------------------------------------------------------
 -- write out Parameter values (all are the same)


 IF @szFieldName like '%'
 BEGIN 
	
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue = @szFieldValue
		, ReportInputParameters.ParmValuePrompt = @szFieldValuePrompt
	WHERE
		ReportInputParameters.ParmName = @szFieldName
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)


 END


 -- Return Result String
 SELECT @szResult as szResult


 RETURN

END
GO


------------------------------------------------------------------------------


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetOutbreak]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetOutbreak]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetOutbreak
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt


 IF @szFilter = '@iMinMachineCount'
 BEGIN 
    SELECT 
	   Value = '10'
		, '' as Prompt
 END
 ELSE IF @szFilter = '@iMinFilenameCount'
 BEGIN
    SELECT 
	   Value = '20'
		, '' as Prompt
 END
 ELSE IF @szFilter = 'Minimum Users Affected'
 BEGIN
    SELECT 
	   Value = '10'
		, '' as Prompt
 END
 ELSE IF @szFilter = 'Minimum Files Affected'
 BEGIN
    SELECT 
	   Value = '20'
		, '' as Prompt
 END
 ELSE IF @szFilter = '@iHourRange'
 BEGIN
    SELECT 
	   Value = '1'
		, '' as Prompt
 END
 ELSE
 BEGIN
	SELECT Distinct ParmValue as Value , Prompt as Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportInputParameterValues.ParmName = @szFilter
		AND	
			(ReportInputParameterValues.ReportID = @szReportID
			OR
			ReportInputParameterValues.RptGroupID = @szRptGroup)

 END

 Set @ret = @@rowcount
 if @ret = 0
		SELECT '---' as Value , '---' as Prompt

 RETURN @ret 

END
GO

-----------------------------------------------------------------


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutOutbreak]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutOutbreak]
GO



CREATE PROCEDURE dbo.AVISP_FieldPutOutbreak
(
    @iNameSpaceName  int
    ,@iNameSpaceNode         int
    ,@szEpoUserName           VARCHAR(100)
    ,@szOptionalReportParms 	 VARCHAR(500) = ''
    ,@szFieldName		VARCHAR(64) = ''
    ,@szFieldValue		VARCHAR(256) = ''
    ,@szFieldValuePrompt		VARCHAR(256) = ''

)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @rec int
 Set @rec = 0

 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @cnt int

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Make sure both values are input otherwise use one to set the other
	if @szFieldValue > '' and ( @szFieldValuePrompt = '' or @szFieldValuePrompt is NULL)
		set @szFieldValuePrompt = @szFieldValue

	if @szFieldValuePrompt > '' and ( @szFieldValue = '' or @szFieldValue is NULL)
		set @szFieldValue = @szFieldValuePrompt


 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- second column must to be called: Prompt


	select @cnt=Count(*) from 
		ReportInputParameters
	WHERE
		ReportInputParameters.ParmName = @szFieldName
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)


	IF @@rowcount > 0
	BEGIN	
 		UPDATE
			ReportInputParameters
		SET
			ReportInputParameters.ParmValue = @szFieldValue
			, ReportInputParameters.ParmValuePrompt = @szFieldValuePrompt
		WHERE
			ReportInputParameters.ParmName = @szFieldName
			AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
			)
		Set @rec = @@rowcount	
	END
 	ELSE
 	BEGIN
		Select @szResult = TranslatedValue
			from ReportTranslations
			where Subject = 'General' and TextID = 'Parameter not saved to Database'
				and LanguageID = @szFullLang
		if @@rowcount = 0    Set @szResult = 'Parameter not saved to Database'
		SELECT @szResult + ': ' + @szReportID + ': ' + @szRptGroup + ': ' + @szFieldValue + ': ' + @szFieldValue
 	END

 -- Return Result String
 SELECT @szResult as szResult


 RETURN @rec

END
GO


/**/
/* xxxxxxx ePO v2.5 8/15/2001     Report Text Strings routines xxxxxxxxxxxxxx */
/* reads translated text string for crystal reports from database - no more hardcoded lang specific rpt files */
/* mhilandepo3 - return rows of textid & translated values, rather than a flat table of fixed textids */
/**/


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportSetMetadataLocalizedText]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportSetMetadataLocalizedText]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


-- localized prompt text for all report metadata tables 
-- localized prompt text for all report metadata tables 
CREATE PROCEDURE dbo.AVISP_ReportSetMetadataLocalizedText
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved. */

   Declare @ret int
   Declare @doit int
   Declare @szLang 		VARCHAR(3)
   Declare @szFullLang 		VARCHAR(5)
   Declare @szDefaultLang 	VARCHAR(5)
   Declare @szLanguageID 	VARCHAR(5)
   Declare @szTime 		VARCHAR(10)
   Declare @szFilter 		VARCHAR(50)
   Declare @szReportID 		VARCHAR(50)
   Declare @szRptGroup 		VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Set @ret=0
   Set @doit=0

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang

--select @szLanguageID
	-----------------------------------------------------
	-- set localized values if the langids differ for all metadata tables

	-------------------------------------
	-- set ReportInputParamaters
	-- localized ParmValuePrompt from ReportTextPromptStrings table

	-- check if translation needs to be done on ReportInputParameters
	Select @doit = count(*) from ReportInputParameters where ReportInputParameters.LangID <> @szLanguageID
				and ReportInputParameters.LangID > ''
		AND	
			(
				ReportInputParameters.ReportID = @szReportID
				OR
				ReportInputParameters.RptGroupID = @szRptGroup
				OR
				(ReportInputParameters.ReportID = ''
				AND	ReportInputParameters.RptGroupID = '')
				OR ReportInputParameters.RptGroupID = 'CustGroup'	
			)


	if @doit > 0
	begin

 	UPDATE
		ReportInputParameters
	SET
		ParmValuePrompt = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParameters.LangID <> @szLanguageID		-- do all of them
		AND	ReportInputParameters.ParmValue = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount



	-- Set Parameter Name Prompt text
	-- Substitute localized Parm Prompt value
	-- These are read from the ReportTextPromptStrings table
 	UPDATE
		ReportInputParameters
	SET
		Prompt = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParameters.LangID <> @szLanguageID
		AND	ReportInputParameters.Parmname = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

	-- Substitute localized Parm PDesc value
 	UPDATE
		ReportInputParameters
	SET
		PDesc = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParameters.LangID <> @szLanguageID
		AND	ReportInputParameters.Parmname+'PDesc' = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount


	end

	-- default: Translate dynamic version field descriptions
	-- These fields are dynamically added by compliance issues and dat/engine
	-- This just translates the field to a generic descirption: Enter minimum Compliant Version
	-- Do this every time just to be safe

	-- If extra product found for compliance issue, make sure its desc gets translated
 	UPDATE
		ReportInputParameters
	SET
		PDesc = ( Select TextValue
				FROM	
				ReportTextPromptStrings
				WHERE
				ReportTextPromptStrings.LanguageID = @szLanguageID
				and ReportTextPromptStrings.ReportID = 'COMPLIANCEISSUES'
				and ReportTextPromptStrings.TextID = 'ParmPDesc'
			)
	Where	
		ReportInputParameters.Langid = '' or ReportInputParameters.Langid is null 

 	UPDATE
		ReportInputParameters
	SET
		PDesc = ( Select TextValue
				FROM	
				ReportTextPromptStrings
				WHERE
				ReportTextPromptStrings.LanguageID = @szLanguageID
				and ReportTextPromptStrings.RptGroupID = 'DATENG'
				and ReportTextPromptStrings.TextID = 'ParmPDesc'
			)
	Where	
		ReportInputParameters.ReportID in ('DAT','ENG','DATENG')
		and ParmName like 'TVD%'



	-------------------------------------------------------------
	-- check if translation needs to be done on ReportInputParameterValues
	Select @doit = count(*) from ReportInputParameterValues where ReportInputParameterValues.LangID <> @szLanguageID
				and ReportInputParameterValues.LangID > ''
		AND	
			(
				ReportInputParameterValues.ReportID = @szReportID
				OR
				ReportInputParameterValues.RptGroupID = @szRptGroup
				OR
				(ReportInputParameterValues.ReportID = ''
				AND	ReportInputParameterValues.RptGroupID = '')
				OR ReportInputParameterValues.RptGroupID = 'CustGroup'	
			)


	if @doit > 0
	begin

--select * from ReportInputParameters where ReportID = @szReportID
	-------------------------------------
	-- set ReportInputParamaterValues
	-- localized ParmValuePrompt from ReportTextPromptStrings table
 	UPDATE
		ReportInputParameterValues
	SET
		Prompt = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParameterValues.LangID <> @szLanguageID
		AND	ReportInputParameterValues.ParmValue = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

--select * from ReportInputParameterValues where ReportID = @szReportID
	end


	-------------------------------------------------------------
	-- check if translation needs to be done on ReportInputParametersSaved
	Select @doit = count(*) from ReportInputParametersSaved where ReportInputParametersSaved.LangID <> @szLanguageID
		AND	
			(
				ReportInputParametersSaved.ReportID = @szReportID
				OR
				ReportInputParametersSaved.RptGroupID = @szRptGroup
				OR
				(ReportInputParametersSaved.ReportID = ''
				AND	ReportInputParametersSaved.RptGroupID = '')
				OR ReportInputParametersSaved.RptGroupID = 'CustGroup'	
			)


	if @doit > 0
	begin

	-------------------------------------
	-- set ReportInputParamatersSaved
	-- localized ParmValuePrompt from ReportTextPromptStrings table
 	UPDATE
		ReportInputParametersSaved
	SET
		ParmValuePrompt = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParametersSaved.LangID <> @szLanguageID
		AND	ReportInputParametersSaved.ParmValue = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

	-- localize name of saved report setting
 	UPDATE
		ReportInputParametersSaved
	SET
		PDesc = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportInputParametersSaved.LangID <> @szLanguageID
		AND	ReportInputParametersSaved.ReportSavedSettingsName = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

	-- default name to english if no translated value available
	Update 
		ReportInputParametersSaved
	Set
		PDesc = ReportSavedSettingsName
	Where
		Pdesc = '' or Pdesc is null

	Set @ret = @ret + @@RowCount

--select * from ReportInputParametersSaved where ReportID = @szReportID

	end



	-------------------------------------------------------------
	-- check if translation needs to be done on ReportUICustPages
	Select @doit = count(*) from ReportUICustPages where ReportUICustPages.LangID <> @szLanguageID
				and ReportUICustPages.LangID > ''
		AND	
			(
				ReportUICustPages.ReportID = @szReportID
				OR
				ReportUICustPages.RptGroupID = @szRptGroup
				OR
				(ReportUICustPages.ReportID = ''
				AND	ReportUICustPages.RptGroupID = '')
				OR ReportUICustPages.RptGroupID = 'CustGroup'	
			)


	if @doit > 0
	begin

	---------------------------
	-- set ReportUICustPages
	-- Substitute localized Cust Prompt value
 	UPDATE
		ReportUICustPages
	SET
		Prompt = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportUICustPages.LangID <> @szLanguageID
		AND	ReportUICustPages.Name = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

	-- Substitute localized Cust PDesc value
 	UPDATE
		ReportUICustPages
	SET
		PDesc = TextValue, LangID = @szLanguageID
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
--		AND ReportUICustPages.LangID <> @szLanguageID
		AND	ReportUICustPages.Name+'PDesc' = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(
					ReportTextPromptStrings.ReportID <> @szReportID
					and
					ReportTextPromptStrings.RptGroupID <> @szRptGroup	
					and
					ReportTextPromptStrings.RptGroupID = 'CustGroup'				
				)
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)
	Set @ret = @ret + @@RowCount

--select * from ReportUICustPages where ReportID = @szReportID

	end

	-- special code to translate Dat/Engine tab descriptions when a new product is recognized 
 	UPDATE
		ReportUICustPages
	SET
		PDesc = ( Select TextValue
				FROM	
				ReportTextPromptStrings
				WHERE
				ReportTextPromptStrings.LanguageID = @szLanguageID
				and ReportTextPromptStrings.ReportID = 'DAT'
				and ReportTextPromptStrings.TextID = 'TVDPDesc'
			)
	Where	
		ReportUICustPages.ReportID = 'DAT'

	-- special code to translate Dat/Engine tab descriptions when a new product is recognized 
 	UPDATE
		ReportUICustPages
	SET
		PDesc = ( Select TextValue
				FROM	
				ReportTextPromptStrings
				WHERE
				ReportTextPromptStrings.LanguageID = @szLanguageID
				and ReportTextPromptStrings.ReportID = 'ENG'
				and ReportTextPromptStrings.TextID = 'TVDPDesc'
			)
	Where	
		ReportUICustPages.ReportID = 'ENG'

	-- special code to translate Dat/Engine tab descriptions when a new product is recognized 
 	UPDATE
		ReportUICustPages
	SET
		PDesc = ( Select TextValue
				FROM	
				ReportTextPromptStrings
				WHERE
				ReportTextPromptStrings.LanguageID = @szLanguageID
				and ReportTextPromptStrings.ReportID = 'DATENG'
				and ReportTextPromptStrings.TextID = 'TVDPDesc'
			)
	Where	
		ReportUICustPages.ReportID = 'DATENG'


	-- done translating

Return @ret
end
GO





if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_TranslateReportText]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_TranslateReportText]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_TranslateReportText
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved. */

   Declare @ret int
   Declare @szLang 		VARCHAR(3)
   Declare @szFullLang 		VARCHAR(5)
   Declare @szDefaultLang 	VARCHAR(5)
   Declare @szLanguageID 	VARCHAR(5)
   Declare @szTime 		VARCHAR(10)
   Declare @szFilter 		VARCHAR(50)
   Declare @szReportID 		VARCHAR(50)
   Declare @szRptGroup 		VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



	-- Check if this is a report which does dynamic report parm loading (Property Setting Monitor)
	 EXECUTE AVISP_ReportParmLoading @szOptionalReportParms


	-- postepo3: Must clear open and savesetting values when ever a new report is fun
	-- Set name of open settings in open and save fields
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ''
	WHERE	
		ReportInputParameters.ParmName in ('RestoreSettings', 'SaveSettingsVar')


   	Truncate Table ReportTextWorkTable

	-- mhilandepo3 - changed to return rows of parameter value pairs instead of a flat table with fixed parameter names
	-- Maintain backward compatibility by reading in old and new data formats and selecting highest priority for duplicate matches

	-- old format: read constant header, priority 0 
	INSERT INTO
		ReportTextWorkTable
		(ReportID, ParmName, ParmValue,  iCrystalParm, Priority)
	    SELECT	@szReportID as ReportID, TextID as ParmName, TextValue as ParmValue, 1, 0
	    FROM	ReportTextStrings
	    WHERE
		LanguageID = @szLanguageID
		AND 
		(
			TextID = 'HEADER'
			OR TextID = 'NODATAMSG'
			OR (RptGroupID = 'xxxx'
				AND ReportID = 'xxxx')
		)


	-- old format, read data from report group, priority 2 
	   INSERT INTO
		ReportTextWorkTable
		(ReportID, ParmName, ParmValue,  iCrystalParm, Priority)
	    SELECT	@szReportID as ReportID,  TextID as ParmName, TextValue as ParmValue, 1, 2
	    FROM	ReportTextStrings
	    WHERE
		LanguageID = @szLanguageID
                	AND RptGroupID = @szRptGroup

	-- old format, read data from reportID, priority 3 (allows report specific overrides for same parms names used in separate reports but having different values) 
	INSERT INTO
		ReportTextWorkTable
		(ReportID, ParmName, ParmValue, iCrystalParm, Priority)
	    SELECT	@szReportID as ReportID,  TextID as ParmName, TextValue as ParmValue, 1, 3
	    FROM	ReportTextStrings
	    WHERE
		LanguageID = @szLanguageID
		AND	ReportID = @szReportID



	-------------------------------------------------------------------------------
	-- New format
	-- set localized text fields in metadata tables
	EXECUTE dbo.AVISP_ReportSetMetadataLocalizedText  @szOptionalReportParms 


	--------------------------------------------------------------------------------
	-- New format, get parms report needs by merging with ReportInputParameters
	--		& ReportUICustPages table, priority 4
	-- load all values for this report, fetch update with localized text further down
	INSERT INTO
		ReportTextWorkTable


	    SELECT	
			@szReportID as ReportID
			, ReportInputParameters.RptGroupID
			, 4 as Priority
			, ReportInputParameters.ParmName 
			, ReportInputParameters.DBFldName  as DBFldName
			, ReportInputParameters.ParmValue  as ParmValue
--			, ReportInputParameters.ParmValue  as ParmValuePrompt
			, ReportInputParameters.ParmValuePrompt  as ParmValuePrompt
			, ReportInputParameters.Prompt  as Prompt
			, ReportInputParameters.PDesc  as PDesc
			, ReportInputParameters.iType  as iType
			, ReportInputParameters.iSaveUserEntry  as iSaveUserEntry
			, ReportInputParameters.iDefaultFlag  as iDefaultFlag
			, ReportInputParameters.iUseDefault  as iUseDefault
--			, ReportInputParameters.iCrystalParm  as iCrystalParm
			, 1 as iCrystalParm
			, ReportInputParameters.iCrystalFieldCust  as iCrystalFieldCust
			, ReportInputParameters.iLocalizedField  as iLocalizedField
			, ReportInputParameters.iDBField  as iDBField
			, ReportUICustPages.Name  as CustPageName
			, ReportUICustPages.Type  as CustType
			, ReportUICustPages.Prompt  as CustPrompt
			, ReportUICustPages.PDesc  as CustDesc
			, ReportUICustPages.Storedproc  as CustStoredproc
			, ReportUICustPages.WritebackStoredproc  as CustWritebackStoredproc
			, ReportUICustPages.Dll  as CustDll
			, ReportUICustPages.iOptionalPage  as CustiOptionalPage
	
	    FROM	
		ReportInputParameters Left Outer Join ReportUICustPages on
		(ReportInputParameters.CustPageName = ReportUICustPages.Name)	
--		AND	
--			( ReportInputParameters.ReportID = @szReportID
--			OR
--			 ReportInputParameters.RptGroupID = @szRptGroup
--			)
--		AND	
--			( ReportUICustPages.ReportID = @szReportID
--			OR
--			 ReportUICustPages.RptGroupID = @szRptGroup
--			)
--		)
--		ReportInputParameters, ReportUICustPages
	    WHERE
--		ReportInputParameters.CustPageName *= ReportUICustPages.Name	-- left join
--		AND	
			( ReportInputParameters.ReportID = @szReportID
			OR
			 ReportInputParameters.RptGroupID = @szRptGroup
			)
		AND	
			( ReportUICustPages.ReportID = @szReportID
			OR
			 ReportUICustPages.RptGroupID = @szRptGroup
			)
	ORDER BY
		ReportUICustPages.AutoID, ReportInputParameters.AutoID


--select @szReportID, @szRptGroup
--select * from ReportTextWorkTable

	-- Remove Prompt% and Desc% entries, these are label text and not report parms
	-- These fields should have ReportTextStrings.TextID = 'Prompt%' or 'Desc%' so they can be removed here
	-- These fields were moved to reporttextpromptstrings table
--	DELETE FROM ReportTextWorkTable
--		WHERE ReportID = @szReportID
--			AND ParmName like 'Prompt%'

--	DELETE FROM ReportTextWorkTable
--		WHERE ReportID = @szReportID
--			AND ParmName like 'Desc%'




	-- select highest priority values 
	SELECT
		ParmName
		, max( Priority ) as Priority
	INTO #TempTextStringPriority
	FROM ReportTextWorkTable
	Group BY
		 ParmName



	-- New format - run updates to set localized text fields into ParmValue, Prompt, PDesc, CustPrompt, CustDesc fields fields
	-- Text fields can be found by TextID, TextID & RptGroup, TextID & ReportID
 	UPDATE
		ReportTextWorkTable
	SET
		ParmValue = TextValue
	FROM	
		ReportTextStrings
	WHERE
		LanguageID = @szLanguageID
		AND	ReportTextWorkTable.ParmName = ReportTextStrings.TextID
		AND	
			(
				ReportTextStrings.ReportID = @szReportID
				OR
				ReportTextStrings.RptGroupID = @szRptGroup
				OR
				(ReportTextStrings.ReportID = ''
				AND	ReportTextStrings.RptGroupID = '')
			)



	-- Try setting value from ReportTextPromptStrings table as well
 	UPDATE
		ReportTextWorkTable
	SET
		ParmValue = TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	ReportTextWorkTable.Prompt = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)


	-- Check if any parameters need to have default values loaded using a special report specific algortithm
	 EXECUTE AVISP_ReportParmDefaults @szOptionalReportParms

	-- Set ParmValuePrompt default from from ReportInputParameter table - the above defaults routine may have changed things
 	UPDATE
		ReportTextWorkTable
	SET
			ParmValue = ReportInputParameters.ParmValue
			, ParmValuePrompt = ReportInputParameters.ParmValuePrompt

	FROM	
		ReportInputParameters
	WHERE
		ReportTextWorkTable.ParmName = ReportInputParameters.ParmName
		AND	
			(
				ReportTextWorkTable.ReportID = ReportInputParameters.ReportID
				OR
				ReportTextWorkTable.RptGroupID = ReportInputParameters.RptGroupID
			)
		AND	
			( ReportInputParameters.ReportID = @szReportID
			OR
			 ReportInputParameters.RptGroupID = @szRptGroup
			)

--select * from ReportTextWorkTable

	-- Set ParmValuePrompt default from from ReportInputParameterValues table - must redo lookups
 	UPDATE
		ReportTextWorkTable
	SET
		ParmValuePrompt = ReportInputParameterValues.Prompt
	FROM	
		ReportInputParameterValues
	WHERE
		ReportTextWorkTable.ParmValue = ReportInputParameterValues.ParmValue
		AND	
			(
				ReportTextWorkTable.ReportID = ReportInputParameterValues.ReportID
				OR
				ReportTextWorkTable.RptGroupID = ReportInputParameterValues.RptGroupID
			)
		AND	
			( ReportInputParameterValues.ReportID = @szReportID
			OR
			 ReportInputParameterValues.RptGroupID = @szRptGroup
			)

	-- localized ParmValuePrompt from ReportTextPromptStrings table
 	UPDATE
		ReportTextWorkTable
	SET
		ParmValuePrompt = TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	ReportTextWorkTable.ParmValue = ReportTextPromptStrings.TextID
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
				OR
				(ReportTextPromptStrings.ReportID = ''
				AND	ReportTextPromptStrings.RptGroupID = '')
			)








	-- Final select (uses highest priority matches)
	SELECT
		@szReportID as ReportID
		, @szRptGroup as RptGroupID
		, @szLanguageID as LanguageID
			, ReportTextWorkTable.ParmName as TextID
			, ReportTextWorkTable.ParmValue  as TextValue
			, ReportTextWorkTable.ParmValuePrompt  as TextValuePrompt
			, ReportTextWorkTable.DBFldName  as DBFldName
			, ReportTextWorkTable.Prompt  as Prompt
			, ReportTextWorkTable.PDesc  as PDesc
			, ReportTextWorkTable.iType  as iType
			, ReportTextWorkTable.iSaveUserEntry  as iSaveUserEntry
			, ReportTextWorkTable.iDefaultFlag  as iDefaultFlag
			, ReportTextWorkTable.iUseDefault  as iUseDefault
			, ReportTextWorkTable.iCrystalParm  as iCrystalParm
			, ReportTextWorkTable.iCrystalFieldCust  as iCrystalFieldCust
			, ReportTextWorkTable.iLocalizedField  as iLocalizedField
			, ReportTextWorkTable.iDBField  as iDBField
			, ReportTextWorkTable.CustPageName  as CustPageName
			, ReportTextWorkTable.CustType  as CustType
			, ReportTextWorkTable.CustPrompt  as CustPrompt
			, ReportTextWorkTable.CustDesc  as CustDesc
			, ReportTextWorkTable.CustStoredproc  as CustStoredproc
			, ReportTextWorkTable.CustWritebackStoredproc  as CustWritebackStoredproc
			, ReportTextWorkTable.CustDll  as CustDll
			, ReportTextWorkTable.CustiOptionalPage  as CustiOptionalPage
--			, ReportTextWorkTable.Priority				-- comment out for production
--		, ReportTextWorkTable.ParmName
--		, ParmValue
	FROM ReportTextWorkTable, #TempTextStringPriority
	WHERE
		ReportTextWorkTable.ParmName =  #TempTextStringPriority.ParmName
		AND ReportTextWorkTable.Priority =  #TempTextStringPriority.Priority

	set @ret = @@rowcount

	DROP TABLE #TempTextStringPriority


--   	DELETE ReportTextWorkTable
--			WHERE ReportID = @szReportID


RETURN @ret
END
GO



--------------------------------------------------------------------------------
-- Loads default values (used by dat engine reports)

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmDefaults]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmDefaults]
GO

CREATE PROCEDURE dbo.AVISP_ReportParmDefaults
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


 
	IF @szRptGroup = 'DATEng'
	BEGIN

		Execute AVISP_ReportParmDefaultDATEngine @szOptionalReportParms

	END

/*
	ELSE	-- dynamic sql to call any newly added reports using dynamic parameter generation
		-- Must follow the naming convention below in order to get your new routine called
	BEGIN
		Declare @routine nvarchar(255)
		Set @routine = 'AVISP_ReportParmDefaults' + @szReportID 

		Declare @ifexists nvarchar(512)
		-- the following format works for both sql7 and sql2000
		Set @ifexists = 'select * from sysobjects where id = object_id(N''' + @routine + ''') and OBJECTPROPERTY(id, N''IsProcedure'')=1'

		EXECUTE(@ifexists) 

		if @@rowcount > 0	-- if exists run it
		begin
			Set @routine =  @routine + ' ' + '''' + @szOptionalReportParms + ''''
			execute(@routine)
		end

	END
*/

END
GO



----------------------------------------------------------------------------------
----------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmDefaultDATEngine]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmDefaultDATEngine]
GO


CREATE PROCEDURE dbo.AVISP_ReportParmDefaultDATEngine
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


 
IF @szRptGroup = 'DATEng'
BEGIN

--	Close ProdFams
--	Deallocate ProdFams

	IF EXISTS (select * from sysobjects where name = 'tmpVer' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVer

	CREATE TABLE [dbo].[tmpVer] (
	 [AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	 [Version] [nvarchar] (100) NULL
	) 

	IF EXISTS (select * from sysobjects where name = 'dbo.tmpProdFamVer' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpProdFamVer

	CREATE TABLE [dbo].[tmpProdFamVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	,ParmName nvarchar(128)
	) 

	Declare @ProdFam nvarchar(50)

	Declare ProdFams Cursor Forward_only static for
	select ProductFamily 
	from ProductProperties, AVIView_Software
	where 
	ProductProperties.ProductCode =  AVIView_Software.ProductCode
	and (ProductFamily in ('TVD', 'TVD_NC')
	or ProductFamily like 'TVD_NC%')
	Group By
	AVIView_Software.ProductFamily

	Open ProdFams

	Fetch Next from ProdFams into @ProdFam

	-- create table with all top dat/engine versions for each product family
	While @@Fetch_Status = 0
	begin
		truncate table dbo.tmpVer

		-- postepo3: exclude datver & engver = N/A in here and avisp_fieldget* routines
		-- get top dats
		insert dbo.tmpVer
		(Version)
		select top 5 DATVer as Version
		from ProductProperties, AVIView_Software
		where 
		ProductProperties.ProductCode =  AVIView_Software.ProductCode
		and ProductFamily = @ProdFam
		and DATVer not in ('5000', 'N/A')
		group by ProductFamily, DATVer
		order by DATVer Desc

		-- Top 5 DATs
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, autoid
			, Version
			, @ProdFam + 'DAT' + convert(nvarchar(10),autoid) as ParmName
			from dbo.tmpVer

		-- DATEng top DAT
		insert dbo.tmpProdFamVer
		select top 1
			@ProdFam as ProductFamily
			, 1 as autoid
			, max(Version) as Version
			, @ProdFam + 'DAT1DE' as ParmName
			from dbo.tmpVer

		-- get top engines
		truncate table dbo.tmpVer

		insert dbo.tmpVer
		(Version)
		select top 3 EngineVer as Version
		from ProductProperties, AVIView_Software
		where 
		ProductProperties.ProductCode =  AVIView_Software.ProductCode
		and ProductFamily = @ProdFam
		and EngineVer not in ('5000', 'N/A')
--		and EngineVer != 'N/A'
		group by ProductFamily, EngineVer
		order by EngineVer Desc

		-- Top 3 engines
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, autoid
			, Version 
			, @ProdFam + 'Engine' + convert(nvarchar(10),autoid)  as ParmName
			from dbo.tmpVer

		-- DATEng top engine
		insert dbo.tmpProdFamVer
		select top 1
			@ProdFam as ProductFamily
			, 1 as autoid
			, max(Version) as Version
			, @ProdFam + 'Engine1DE' as ParmName
			from dbo.tmpVer

		-- get next product family
		Fetch Next from ProdFams into @ProdFam

	end

	Close ProdFams
	Deallocate ProdFams
 
	-- update all dateng defaults

	update ReportInputParameters 
	set ParmValue = Version, ParmValuePrompt = Version
	from dbo.tmpProdFamVer
	where 
		ReportInputParameters.CustPageName = dbo.tmpProdFamVer.ProductFamily
		and ReportInputParameters.ParmName = dbo.tmpProdFamVer.ParmName

	drop table dbo.tmpProdFamVer
	drop table dbo.tmpVer
END



END
GO


------------------------------------------------------------------------------
------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmLoading]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmLoading]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_ReportParmLoading
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


	Declare @ret int
	set @ret = 0
 
	IF @szReportID = 'PROPERTYSETTINGISSUES'
	BEGIN

		Execute @ret= AVISP_ReportParmLoadProductSettingMonitor @szOptionalReportParms

	END


	ELSE IF @szRptGroup = 'DATENG'
	BEGIN

		Execute @ret= AVISP_ReportParmLoadDATEngine @szOptionalReportParms

	END

	ELSE IF @szReportID = 'COMPLIANCEISSUES'
	BEGIN

		Execute @ret= AVISP_ReportParmLoadComplianceIssues @szOptionalReportParms

	END

/*
	ELSE	-- dynamic sql to call any newly added reports using dynamic parameter generation
		-- Must follow the naming convention below in order to get your new routine called
	BEGIN
		Declare @routine nvarchar(255)
		Set @routine = 'AVISP_ReportParmLoad' + @szReportID 

		Declare @ifexists nvarchar(512)
		-- the following format works for both sql7 and sql2000
		Set @ifexists = 'select * from sysobjects where id = object_id(N''' + @routine + ''') and OBJECTPROPERTY(id, N''IsProcedure'')=1'

		EXECUTE(@ifexists) 

		if @@rowcount > 0	-- if exists run it
		begin
			Set @routine =  @routine + ' ' + '''' + @szOptionalReportParms + ''''
			execute(@routine)
		end

	END
*/


Return @ret
END
GO


---------------------------------------------------------------------------
---------------------------------------------------------------------------
--  AVISP_ReportParmLoadComplianceIssues

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmLoadComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmLoadComplianceIssues]
GO

CREATE PROCEDURE dbo.AVISP_ReportParmLoadComplianceIssues
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

/*AVISP_ReportParmLoadProductSettingMonitor*/
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


-----------------------------------------
-- Dynamically check DB for any new products that needs to be added to the compliance list

 
IF @szReportID = 'COMPLIANCEISSUES'
BEGIN

-- Check for any new products that need to have their settings loaded in the report metadata tables

------------------------------
-- ReportInputParameters table
-- Create any new inputs dynamically for now

--truncate table ReportPropertySettings 
--GO


Declare @cnt int
Declare @ret int
set @ret=0

------------------------------------------------------------------------------------------
-- get product version list, assume everything is new

IF EXISTS (select * from sysobjects where name = 'tmpProdVerList' 
   and xtype = 'U')
  DROP TABLE dbo.tmpProdVerList

select distinct SoftwareName, max(ProductProperties.ProductVersion) as ProductVersion, 1 as new
into dbo.tmpProdVerList
from ProductProperties, AVIView_Software
where 
ProductProperties.ProductCode =  AVIView_Software.ProductCode
and 				-- (ProductFamily in ('TVD', 'TVD_NC', 'SECURE', 'EPO')
	( ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
		or (ProductFamily = 'EPO' and AVIView_Software.ProductCode Like 'EPOAGENT%') 
		or ProductFamily like ('TVD_NC_%') )
	and ProductProperties.ProductVersion != '5000'
Group By
SoftwareName


-- special code: remove virusscan7 .wrk & .srv suffix
Update dbo.tmpProdVerList
	Set ProductVersion = Replace(Replace(ProductVersion,'.wrk',''),'.srv','')


-- check if any products are not in the compliance report product list
-- set all matches back to zero (not new)

update dbo.tmpProdVerList
set new = 0
from ReportInputParameters
where 
ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
and ReportInputParameters.CustPageName  = 'ProductVersions'
and ReportInputParameters.ParmName = dbo.tmpProdVerList.SoftwareName

-- eposp2 
-- Update existing products whose versions have changed
update ReportInputParameters
set ReportInputParameters.ParmValue = dbo.tmpProdVerList.ProductVersion,
ReportInputParameters.ParmValuePrompt = dbo.tmpProdVerList.ProductVersion
from dbo.tmpProdVerList
where 
ReportInputParameters.ParmName = dbo.tmpProdVerList.SoftwareName
--and #tmpProdVerList.ProductVersion > ReportInputParameters.ParmValue


-- add any new products

INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'COMPLIANCEISSUES', '' 
, dbo.tmpProdVerList.SoftwareName as ParmName, '', dbo.tmpProdVerList.ProductVersion as ParmValue
, dbo.tmpProdVerList.SoftwareName as Prompt, 'Enter Minimum Compliant Version' as PDesc
, 'ProductVersions'
, 0, 1, 0, 0
, 0, 0, 0, 0
from dbo.tmpProdVerList
where 
	new = 1

set @ret = @ret + @@rowcount

-- cleanup

drop table dbo.tmpProdVerList



---------------------------------------------------------------------------------------------------
-- get DAT version list, assume everything is new
-- Gets version for each productfamily, not each product
-- load any future dat/engines with productfamily = 'TVD_NC%' naming convention

IF EXISTS (select * from sysobjects where name = 'tmpDATVerList' 
   and xtype = 'U')
  DROP TABLE dbo.tmpDATVerList

select distinct AVIView_Software.ProductFamily as ProductFamily
	, min(AVIView_Software.SoftwareName) as SoftwareName
	, max(ProductProperties.DATVer) as DATVer, 1 as new
into dbo.tmpDATVerList
from ProductProperties, AVIView_Software
where 
ProductProperties.ProductCode =  AVIView_Software.ProductCode
and ProductProperties.DATVer not in ('5000', 'N/A')
and 
(ProductFamily in ('TVD', 'TVD_NC')
or ProductFamily like 'TVD_NC%')

Group By
AVIView_Software.ProductFamily


-- check if any products are not in the compliance report product list
-- set all matches back to zero (not new)

update dbo.tmpDATVerList
set new = 0
from ReportInputParameters
where 
ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
and ReportInputParameters.CustPageName  = 'EngineDATs'
and
ReportInputParameters.ParmName = dbo.tmpDATVerList.ProductFamily + '_DATs'

-- eposp2 
-- Update existing products whose versions have changed
update ReportInputParameters
set ReportInputParameters.ParmValue = dbo.tmpDATVerList.DATVer,
ReportInputParameters.ParmValuePrompt = dbo.tmpDATVerList.DATVer
from dbo.tmpDATVerList
where 
ReportInputParameters.ParmName = dbo.tmpDATVerList.ProductFamily + '_DATs'


-- add any new products

INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'COMPLIANCEISSUES', '' 
, dbo.tmpDATVerList.ProductFamily + '_DATs' as ParmName, '', dbo.tmpDATVerList.DATVer as ParmValue
, dbo.tmpDATVerList.SoftwareName + '_DATs'  as Prompt, 'Enter Minimum Compliant Version' as PDesc
, 'EngineDATs'
, 0, 1, 0, 0
, 0, 0, 0, 0
from dbo.tmpDATVerList
where 
	new = 1

set @ret = @ret + @@rowcount

-- cleanup

drop table dbo.tmpDATVerList





---------------------------------------------------------------------------------------------------
-- get Engine version list, assume everything is new
-- Gets version for each productfamily, not each product

IF EXISTS (select * from sysobjects where name = 'tmpEngineVerList' 
   and xtype = 'U')
  DROP TABLE dbo.tmpEngineVerList

select distinct AVIView_Software.ProductFamily as ProductFamily
	, min(AVIView_Software.SoftwareName) as SoftwareName
	, max(ProductProperties.EngineVer) as EngineVer, 1 as new
into dbo.tmpEngineVerList
from ProductProperties, AVIView_Software
where 
ProductProperties.ProductCode =  AVIView_Software.ProductCode
--and ProductProperties.EngineVer != 'N/A'
and ProductProperties.EngineVer not in ('5000', 'N/A')
and (ProductFamily in ('TVD', 'TVD_NC')
or ProductFamily like 'TVD_NC%')
Group By
AVIView_Software.ProductFamily


-- check if any products are not in the compliance report product list
-- set all matches back to zero (not new)

update dbo.tmpEngineVerList
set new = 0
from ReportInputParameters
where 
ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
and ReportInputParameters.CustPageName  = 'EngineDATs'
and ReportInputParameters.ParmName = dbo.tmpEngineVerList.ProductFamily + '_Engines'

-- eposp2 
-- Update existing products whose versions have changed
update ReportInputParameters
set ReportInputParameters.ParmValue = dbo.tmpEngineVerList.EngineVer,
ReportInputParameters.ParmValuePrompt = dbo.tmpEngineVerList.EngineVer 
from dbo.tmpEngineVerList
where 
ReportInputParameters.ParmName = dbo.tmpEngineVerList.ProductFamily + '_Engines'


-- add any new products

INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'COMPLIANCEISSUES', '' 
, dbo.tmpEngineVerList.ProductFamily  + '_Engines' as ParmName, '', dbo.tmpEngineVerList.EngineVer as ParmValue
, dbo.tmpEngineVerList.SoftwareName  + '_Engines'  as Prompt, 'Enter Minimum Compliant Version' as PDesc
, 'EngineDATs'
, 0, 1, 0, 0
, 0, 0, 0, 0
from dbo.tmpEngineVerList
where 
	new = 1

set @ret = @ret + @@rowcount

-- cleanup

drop table dbo.tmpEngineVerList



-- need to create ProductFamilyDesc table, until then update the product family descriptions manually

update ReportInputParameters
set Prompt = 'McAfee (DAT)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName = 'TVD_DATs' 

update ReportInputParameters
set Prompt = 'McAfee (ENG)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName = 'TVD_Engines' 

update ReportInputParameters
set Prompt = substring(ParmName, 8, len(ParmName)-12) + ' (DAT)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName like ('TVD_NC_%DATs') 
and ParmName <> 'TVD_NC_DATs'

update ReportInputParameters
set Prompt = substring(ParmName, 8, len(ParmName)-15) + ' (ENG)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName like ('TVD_NC_%Engines') 
and ParmName <> 'TVD_NC_Engines'

update ReportInputParameters
set Prompt = 'Symantec (DAT)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName = 'TVD_NC_DATs' 

update ReportInputParameters
set Prompt = 'Symantec (ENG)'
where 
ReportID = 'COMPLIANCEISSUES'
and ParmName = 'TVD_NC_Engines' 



-- test

--select * 
--from ReportInputParameters
--where 
--    ReportInputParameters.ReportID =  'COMPLIANCEISSUES'



END

--return @ret

END
GO


----------------------------------------------------------------------------
-- dbo.AVISP_ReportParmLoadDATEngine

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmLoadDATEngine]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmLoadDATEngine]
GO

CREATE PROCEDURE dbo.AVISP_ReportParmLoadDATEngine
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

/*AVISP_ReportParmLoadProductSettingMonitor*/
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


 
IF @szRptGroup = 'DATEng'
BEGIN

-- Check for any new products that need to have their settings loaded in the report metadata tables

------------------------------
-- ReportInputParameters table
-- Create any new inputs dynamically for now


Declare @cnt int
Declare @SymantecCnt int
Declare @ret int
set @ret=0

------------------------------------------------------------------------------------------
-- Check if any products have a product family of TVD_NC - symantec 

----------------------------------------------------------------------------
-- Look for other competitor products: ProductFamily of TVD_NC_%

IF EXISTS (select * from sysobjects where name = 'tmpVerList' 
   and xtype = 'U')
  DROP TABLE dbo.tmpVerList

select distinct AVIView_Software.ProductFamily as ProductFamily
	, min(AVIView_Software.SoftwareName) as SoftwareName
	, max(ProductProperties.EngineVer) as EngineVer
	, 1 as new
into dbo.tmpVerList
from ProductProperties, AVIView_Software
where 
ProductProperties.ProductCode =  AVIView_Software.ProductCode
and ProductProperties.EngineVer not in ('N/A', '5000')
and (ProductFamily in ('TVD_NC')
or ProductFamily like 'TVD_NC%')
Group By
AVIView_Software.ProductFamily


-- check if any products are not in the compliance report product list
-- set all matches back to zero (not new)

update dbo.tmpVerList
set new = 0
from ReportUICustPages
where 
ReportUICustPages.ReportID in ('DAT', 'ENG', 'DATENG')
and ReportUICustPages.Name  = dbo.tmpVerList.ProductFamily


select @cnt=count(*)
from dbo.tmpVerList
where new =1

-- check if new products found
if @cnt > 0 
Begin

	set @ret=1
	
	-- add symantec input tab
	
	INSERT ReportUICustPages
	( 	ReportID, RptGroupID
		, Name, Type
		, Prompt, PDesc 
		, Storedproc, dll 
		, WritebackStoredproc, iOptionalPage
	)
	Select
		'DAT' as ReportID, '' as RptGroupID
		, ProductFamily as Name, 'Parameters' as Type
		, Prompt = case ProductFamily		-- take suffix characters as product family name
			when 'TVD_NC'  then 'Symantec'
			else substring( ProductFamily, 8, len(ProductFamily)-7 )
			end
		, 'Enter Top 5 DAT/Definition (DAT) versions, by default the most recent values are loaded' 
		, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?)}', ''
		, '', 0 
	from dbo.tmpVerList
	where new = 1

	INSERT ReportUICustPages
	( 	ReportID, RptGroupID
		, Name, Type
		, Prompt, PDesc 
		, Storedproc, dll 
		, WritebackStoredproc, iOptionalPage
	)
	Select
		'ENG' as ReportID, '' as RptGroupID
		, ProductFamily as Name, 'Parameters' as Type
		, Prompt = case ProductFamily		-- take suffix characters as product family name
			when 'TVD_NC'  then 'Symantec'
			else substring( ProductFamily, 8, len(ProductFamily)-7 )
			end
		, 'Enter Top 3 Engine (ENG) versions, by default the most recent values are loaded' 
		, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?)}', ''
		, '', 0 
	from dbo.tmpVerList
	where new = 1

	INSERT ReportUICustPages
	( 	ReportID, RptGroupID
		, Name, Type
		, Prompt, PDesc 
		, Storedproc, dll 
		, WritebackStoredproc, iOptionalPage
	)
	Select
		'DATENG' as ReportID, '' as RptGroupID
		, ProductFamily as Name, 'Parameters' as Type
		, Prompt = case ProductFamily		-- take suffix characters as product family name
			when 'TVD_NC'  then 'Symantec'
			else substring( ProductFamily, 8, len(ProductFamily)-7 )
			end
		, 'Enter compliant DAT/Definition (DAT) and Engine (ENG) versions, by default the most recent values are loaded' 
		, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?)}', ''
		, '', 0 
	from dbo.tmpVerList
	where new = 1
	
	-- add individual parm entries
	
	
	--DAT
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DAT', '', ''
		, ProductFamily + 'DAT1' as Name, '', ''
		, '(DAT) - 1', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DAT', '', ''
		, ProductFamily + 'DAT2' as Name, '', ''
		, '(DAT) - 2', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DAT', '', ''
		, ProductFamily + 'DAT3' as Name, '', ''
		, '(DAT) - 3', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DAT', '', ''
		, ProductFamily + 'DAT4' as Name, '', ''
		, '(DAT) - 4', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DAT', '', ''
		, ProductFamily + 'DAT5' as Name, '', ''
		, '(DAT) - 5', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	-- ENG
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'ENG', '', ''
		, ProductFamily + 'Engine1' as Name, '', ''
		, '(ENG) - 1', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'ENG', '', ''
		, ProductFamily + 'Engine2' as Name, '', ''
		, '(ENG) - 2', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'ENG', '', ''
		, ProductFamily + 'Engine3' as Name, '', ''
		, '(ENG) - 3', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	-- DATENG
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DATENG', '', ''
		, ProductFamily + 'DAT1DE' as Name, '', ''
		, '(DAT)', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID, ReportSavedSettingsName
		, ParmName, DBFldName, ParmValue
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select
		'DATENG', '', ''
		, ProductFamily + 'Engine1DE' as Name, '', ''
		, '(ENG)', 'Enter minimum compliant version'
		, ProductFamily as CustPageName
		, 0 ,1 ,0 ,1
		, 0 ,0 ,0 ,0
	from dbo.tmpVerList
	where new = 1



----------------------------------------------------
-- Readd within tab to assure this tab appears at the end


--	Delete ReportUICustPages where RptGrp = 'DatEng' and Name = 'Within'

--	INSERT ReportUICustPages
--	( 	ReportID, RptGroupID
--		, Name, Type
--		, Prompt, PDesc 
--		, Storedproc, dll 
--		, WritebackStoredproc, iOptionalPage
--	)
--	VALUES(
--		@Reportid, 'DatEng'
--		, 'Within', 'Parameters'
--		, 'Within', ''
--		, '{CALL dbo.AVISP_FieldGetDATEng (?,?,?,?)}', ''
--		, '', 0
--	)
	
	


-- within tab added
--------------------------------------------------

end
-- new product tab added


drop table dbo.tmpVerList

end

return @ret
END
GO




--------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_ReportParmLoadProductSettingMonitor]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_ReportParmLoadProductSettingMonitor]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_ReportParmLoadProductSettingMonitor
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

/*AVISP_ReportParmLoadProductSettingMonitor*/
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


 
IF @szReportID = 'PROPERTYSETTINGISSUES'
BEGIN

-- Check for any new products that need to have their settings loaded in the report metadata tables

------------------------------
-- Property Settings Issues Report
-- ReportInputParameters table
-- Create these inputs dynamically for now

--truncate table ReportPropertySettings 
--GO


-- Does Groupshield and webshield pass product settings over to epo?


Declare @cnt int

--------------------------------------------------------------------
-- Check for Netshield - load only once

select @cnt=count(*)
from ReportPropertySettings
where Product = 'NetShield'

IF @cnt = 0
BEGIN

INSERT ReportPropertySettings 
select 'NetShield' as product
, productcode
, 'NetShield' + ':' + sectionname + ':' + settingname as ParmName
, sectionname
, settingname
from productsettings, productproperties
where productproperties.autoid = productsettings.parentid
and (productcode like 'NETSHLD%')
group by productcode, sectionname, settingname
having max(value) = '1' or max(value) = '0'
order by productcode, sectionname, settingname


INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'PROPERTYSETTINGISSUES', '' 
, 'NetShield' + ':' + sectionname + ':' + settingname as ParmName, '', ''
, sectionname + ':' + settingname as Prompt, 'Setting for NetShield: ' + sectionname + ', ' + settingname as PDesc
, 'NetShield'
, 0, 1, 0, 0
, 0, 0, 1, 0
from ReportPropertySettings
where 
	product = 'NetShield'
group by product, sectionname, settingname

END

------------------------------------------------------------------------------------
-- Check for VirusScan - Load only once

select @cnt=count(*)
from ReportPropertySettings
where Product = 'VirusScan'

IF @cnt = 0
BEGIN

INSERT ReportPropertySettings 
select 
'VirusScan' as product
, productcode
, 'VirusScan' + ':' + sectionname + ':' + settingname as ParmName
, sectionname
, settingname
from productsettings, productproperties
where productproperties.autoid = productsettings.parentid
and (productcode like 'VIRUSCAN%')
and productcode != 'VIRUSCAN4000WNTW'
group by productcode, sectionname, settingname
having max(value) = '1' or max(value) = '0'
order by productcode, sectionname, settingname


INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'PROPERTYSETTINGISSUES' as ReportID, '' as RptGroupID 
, 'VirusScan' + ':' + sectionname + ':' + settingname as ParmName, '' as DBFldName, '' as ParmValue
, sectionname + ':' + settingname as Prompt, 'Setting for VirusScan: ' + sectionname + ', ' + settingname as PDesc
, 'VirusScan'
, 0, 1, 0, 0
, 0, 0, 1, 0
from ReportPropertySettings
where 
	product = 'VirusScan'
group by product, sectionname, settingname


-- Divide Virusscan parms into groups by scan type


UPDATE ReportInputParameters 
SET CustPageName = 'VirusScanEmail'
WHERE 
	CustPageName = 'VirusScan'
	AND Prompt like 'Email%'


UPDATE ReportInputParameters 
SET CustPageName = 'VirusScanDownload'
WHERE 
	CustPageName = 'VirusScan'
	AND Prompt like 'Download%'



UPDATE ReportInputParameters 
SET CustPageName = 'VirusScanInet'
WHERE 
	CustPageName = 'VirusScan'
	AND Prompt like 'Inet%'

END

----------------------------------------------------------------------------
-- Check for Norton - load only once

select @cnt=count(*)
from ReportPropertySettings
where Product = 'NortonAV'

IF @cnt = 0
BEGIN

INSERT ReportPropertySettings 
select 
'NortonAV' as product
, productcode
, 'NortonAV' + ':' + sectionname + ':' + settingname as ParmName
, sectionname
, settingname
from productsettings, productproperties
where productproperties.autoid = productsettings.parentid
and (productcode like 'NORTONAV%')
group by productcode, sectionname, settingname
having max(value) = '1' or max(value) = '0'
order by productcode, sectionname, settingname



INSERT ReportInputParameters 
( 	ReportID, RptGroupID
	, ParmName, DBFldName, ParmValue
	, Prompt, PDesc 
	, CustPageName 
	, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
	, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
)
select 'PROPERTYSETTINGISSUES', '' 
, 'NortonAV' + ':' + sectionname + ':' + settingname as ParmName, '', ''
, sectionname + ':' + settingname as Prompt, 'Setting for NortonAV: ' + sectionname + ', ' + settingname as PDesc
, 'NetShield'
, 0, 1, 0, 0
, 0, 0, 1, 0
from ReportPropertySettings
where 
	product = 'NortonAV'
group by product, sectionname, settingname

END


END

return 0

END
GO



----------------------------------------------------------------
----------------------------------------------------------------
--  AVISP_GetRuleDATEngine

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetRuleDATEngine]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetRuleDATEngine]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetRuleDATEngine
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
 /* Shows AV installs and computers having no AV */

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 Declare @ret int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
     

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

 -------------------------------------------------------------
 -- fetch dat engine rules

 IF EXISTS (select * from sysobjects where name = 'tmpProductFamily' 
   and xtype = 'U')
  DROP TABLE dbo.tmpProductFamily

 select distinct ProductFamily into dbo.tmpProductFamily from AVIView_Software 


 IF EXISTS (select * from sysobjects where name = 'tmpDATEngRules' 
   and xtype = 'U')
  DROP TABLE dbo.tmpDATEngRules

 -- dat rules
 select
	cast('DAT' as nvarchar(20)) as Rulename
	, cast(ProductFamily as nvarchar(20)) as ProductFamily
	, cast(ParmValue as nvarchar(20))  as DAT1
	, cast(ParmValue as nvarchar(20))  as DAT2
	, cast(ParmValue as nvarchar(20))  as DAT3
	, cast(ParmValue as nvarchar(20))  as DAT4
	, cast(ParmValue as nvarchar(20))  as DAT5
	, cast('' as nvarchar(30)) as Eng1
	, cast('' as nvarchar(30)) as Eng2
	, cast('' as nvarchar(30)) as Eng3
	, cast('' as nvarchar(30)) as DAT1DE
	, cast('' as nvarchar(30)) as Eng1DE
 into dbo.tmpDATEngRules
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DAT'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT1'


 update dbo.tmpDATEngRules
 set DAT2 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DAT'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT2'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'DAT'

 update dbo.tmpDATEngRules
 set DAT3 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DAT'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT3'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'DAT'

 update dbo.tmpDATEngRules
 set DAT4 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DAT'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT4'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'DAT'

 update dbo.tmpDATEngRules
 set DAT5 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DAT'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT5'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'DAT'



 -- eng rules
 insert dbo.tmpDATEngRules
 select
	'ENG' as Rulename
	, ProductFamily
	, cast('' as nvarchar(30)) as DAT1
	, cast('' as nvarchar(30)) as DAT2
	, cast('' as nvarchar(30)) as DAT3
	, cast('' as nvarchar(30)) as DAT4
	, cast('' as nvarchar(30)) as DAT5
	, ParmValue as Eng1
	, ParmValue as Eng2
	, ParmValue as Eng3
	, cast('' as nvarchar(30)) as DAT1DE
	, cast('' as nvarchar(30)) as Eng1DE
-- into #tmpEngRules
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'ENG'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'Engine1'


 update dbo.tmpDATEngRules
 set Eng2 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'ENG'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'Engine2'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'ENG'

 update dbo.tmpDATEngRules
 set Eng3 = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'ENG'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'Engine3'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'ENG'



 -- dateng rules
 insert dbo.tmpDATEngRules
 select
	'DATENG' as Rulename
	, ProductFamily
	, cast('' as nvarchar(30)) as DAT1
	, cast('' as nvarchar(30)) as DAT2
	, cast('' as nvarchar(30)) as DAT3
	, cast('' as nvarchar(30)) as DAT4
	, cast('' as nvarchar(30)) as DAT5
	, cast('' as nvarchar(30)) as Eng1
	, cast('' as nvarchar(30)) as Eng2
	, cast('' as nvarchar(30)) as Eng3
	, ParmValue as DAT1DE
	, ParmValue as Eng1DE
-- into dbo.tmpDATEngRules
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DATENG'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'DAT1DE'


 update dbo.tmpDATEngRules
 set Eng1DE = ParmValue
 from 	ReportInputParameters, dbo.tmpProductFamily 
 where
	ReportInputParameters.ReportID = 'DATENG'
  	and ReportInputParameters.ParmName = dbo.tmpProductFamily.ProductFamily + 'Engine1DE'
	and dbo.tmpProductFamily.ProductFamily = dbo.tmpDATEngRules.productFamily
	and dbo.tmpDATEngRules.Rulename = 'DATENG'




 -- dump output
 select * from dbo.tmpDATEngRules
 set @ret = @@rowcount

 -- cleanup
 Drop Table dbo.tmpProductFamily
 Drop Table dbo.tmpDATEngRules

-- debug only
--select * from dbo.tmpDATEngRules
--select @szReportID

Return @ret
end
GO


---------------------------------------------------------------------------------
---------------------------------------------------------------------------------
-- epo3.0 added nodeid for subreport drilldown (filteravinstalls got this too)
-- epo3.0 added dynamic recognition of new scanning products dat & engines: TVD_NC_%

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterDATEngine]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterDATEngine]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterDATEngine
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = 'All'
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
 /* Shows AV installs and computers having no AV */

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 Declare @ret int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
     

	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')


	-- If no data exists in ReportComplianceComparison table then run routine to fill it
	-- Do this so that there is data in the compliance subreports
	Declare @dtInfectionCheckPoint DateTime
	Set @dtInfectionCheckPoint = DateAdd( day, -1, GetDate())
	if not exists ( select * from ReportComplianceComparison )
		Execute dbo.AVISP_SetComplianceComparison
			 @iNameSpaceName  
			 , @iNameSpaceNode  
			 , @szEpoUserName  
--			 , @szNameSpaceName 
--			 , @szNameSpaceNode  
			 , @szOptionalReportParms  
			 , @dtInfectionCheckPoint 



	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent = 'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	

	

 -------------------------------------------------------------
 -- fetch dat engine rules

IF EXISTS (select * from sysobjects where name = 'tmpDERules' 
   and xtype = 'U')
 DROP TABLE dbo.tmpDERules

create table dbo.tmpDERules
(
RuleName nvarchar(50) null
,ProductFamily nvarchar(50) null
,DAT1 nvarchar(100) null
,DAT2 nvarchar(100) null
,DAT3 nvarchar(100) null
,DAT4 nvarchar(100) null
,DAT5 nvarchar(100) null
,Eng1 nvarchar(100) null
,Eng2 nvarchar(100) null
,Eng3 nvarchar(100) null
,DAT1DE nvarchar(100) null
,Eng1DE nvarchar(100) null
)
insert dbo.tmpDERules
exec @ret= dbo.AVISP_GetRuleDATEngine
 @iNameSpaceName  = ''
 ,@iNameSpaceNode = ''
 ,@szEpoUserName  = ''
 ,@szNameSpaceName  = ''
 ,@szNameSpaceNode  = ''
 ,@szOptionalReportParms  = ''


-- debug only
--select * from dbo.tmpDERules
--select @szReportID

 --------------------------------------------------------------
 -- Start main queries

--select * from dbo.tmpDERules

 -- DAT report 
 SELECT

   	RuleName = 
	CASE 
	when DATVer >=  dbo.tmpDERules.DAT1 then 'Current or Newer'
	when DATVer >=  dbo.tmpDERules.DAT2 then 'Out of Date 1 Version'
	when DATVer >=  dbo.tmpDERules.DAT3 then 'Out of Date 2 Versions'
	when DATVer >=  dbo.tmpDERules.DAT4 then 'Out of Date 3 Versions'
	when DATVer >=  dbo.tmpDERules.DAT5 then 'Out of Date 4 Versions'
	when DATVer <  dbo.tmpDERules.DAT5   then 'Out of Date 5 or More Versions'
     	when DATVer = 'N/A' then '---'
 	else Case
			When LeafNode.AgentVersion > '' Then 'Unprotected'
			Else 'Uninstalled Agent'
			End 
	end	
	, '' as RuleDescription
   	, BranchNode.NodeName AS NodeName
	, cast(ReportFullPathNode.FullPathName as varchar(255)) as FullNodePath
   	, LeafNode.AgentVersion
   	, Case
		When AVIView_Software.SoftwareName > '' then AVIView_Software.SoftwareName
		else	Case
			When LeafNode.AgentVersion > '' Then @Unprotected 
			Else @NoAgent
			End 
		End as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion 
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE  
     		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer
     		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ProductProperties.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ProductProperties.ExtraDATNames 
     		END
	,    ProductFamily =
    		CASE 
     		WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     		WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     		ELSE  AVIView_Software.ProductFamily 
     		END
	, ComputerProperties.DomainName
--	postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as ComputerName
--	, ComputerProperties.ComputerName  -- Use leafnode nodename for noagent since they usually dont have computer props
	, ComputerProperties.IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, ComputerProperties.UserName
--    	, CAST('' As varchar(255)) As FileName
  	, '' as FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
   	, RuleNumber = 
		CASE 
		when DATVer >=  dbo.tmpDERules.DAT1 then 0
		when DATVer >=  dbo.tmpDERules.DAT2 then 1
		when DATVer >=  dbo.tmpDERules.DAT3 then 2
		when DATVer >=  dbo.tmpDERules.DAT4 then 3
		when DATVer >=  dbo.tmpDERules.DAT5 then 4
		when DATVer <  dbo.tmpDERules.DAT5   then 5
  	   	when DATVer = 'N/A' then 6
 		else Case
			When LeafNode.AgentVersion > '' Then 7
			Else 8
			End 
		end	
--	, 1 as RuleNumber
	, LeafNode.LastUpdate as LastContact
     	, cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
        	as varchar(50)) as OSVersion
   	,  LeafNode.AutoID as NodeID
	, Servicepack
	, Hotfix
    	, AVIView_Software.ProductCode
	, '' as Language
--	,  Language =
--    		CASE 
--     		WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
--     		WHEN  ProductProperties.Language = '' THEN '---'
--     		ELSE  ProductProperties.Language
--     		END
	, ComputerProperties.OSPlatform
	, ComputerProperties.OSType



 FROM 
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		  and (LeafNode.LastUpdate  >=  @YYYYMMDD or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null)
		   AND LeafNode.Type !=24  )    /* Uninstalled */ 
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		   AND DATVer != '5000')
		Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
			  AND dbo.tmpDERules.Rulename = @szReportID  
				and dbo.tmpDERules.DAT1 > '')
	)
	on( @szReportID = 'DAT'  and  leafnode.autoid = productproperties.parentid )  -- run only for dat report

--	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
--	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
--	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
--	Join ProductProperties on (ProductProperties.ParentID = LeafNode.AutoID)
--	Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode)
--	Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily)
 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
and @szReportID = 'DAT'
--   AND LeafNode.AutoID = ComputerProperties.ParentID
--                  AND ProductProperties.ParentID = LeafNode.AutoID 
--   AND ProductProperties.ProductCode = AVIView_Software.ProductCode
--   AND LeafNode.ParentID = BranchNode.AutoID
--   AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   AND LanguageDesc.epoServerLanguageSuffix = @szLang


--  AND dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
--   and @szReportID = 'DAT'	-- run only for dat report



  
 UNION ALL

 -- Eng report 
 SELECT
   	RuleName = 
	CASE 
	when EngineVer >=  dbo.tmpDERules.Eng1 then 'Current or Newer'
	when EngineVer >=  dbo.tmpDERules.Eng2 then 'Out of Date 1 Version'
	when EngineVer >=  dbo.tmpDERules.Eng3 then 'Out of Date 2 Versions'
	when EngineVer <  dbo.tmpDERules.Eng3   then 'Out of Date 3 or More Versions'
     	when EngineVer = 'N/A' then '---'
 	else Case
			When LeafNode.AgentVersion > '' Then 'Unprotected'
			Else 'Uninstalled Agent'
			End 
	end	
	, '' as RuleDescription
   	, BranchNode.NodeName AS NodeName
	, cast(ReportFullPathNode.FullPathName as varchar(255)) as FullNodePath
   	, LeafNode.AgentVersion
   	, Case
		When AVIView_Software.SoftwareName > '' then AVIView_Software.SoftwareName
		else	Case
			When LeafNode.AgentVersion > '' Then @Unprotected 
			Else @NoAgent
			End 
		End as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion 
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE  
     		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer
     		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ProductProperties.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ProductProperties.ExtraDATNames 
     		END
	,    ProductFamily =
    		CASE 
     		WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     		WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     		ELSE  AVIView_Software.ProductFamily 
     		END
	, ComputerProperties.DomainName
--	postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as ComputerName
--	, ComputerProperties.ComputerName  -- Use leafnode nodename for noagent since they usually dont have computer props
	, ComputerProperties.IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, ComputerProperties.UserName
--    	, CAST('' As varchar(255)) As FileName
  	, '' as FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
   	, RuleNumber = 
		CASE 
		when EngineVer >=  dbo.tmpDERules.Eng1 then 0
		when EngineVer >=  dbo.tmpDERules.Eng2 then 1
		when EngineVer >=  dbo.tmpDERules.Eng3 then 2
		when EngineVer <  dbo.tmpDERules.Eng3   then 13
   	  	when EngineVer = 'N/A' then 6
 		else Case
			When LeafNode.AgentVersion > '' Then 7
			Else 8
			End 
		end	
--	, 1 as RuleNumber
	, LeafNode.LastUpdate as LastContact
     	, cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
        	as varchar(50)) as OSVersion
   	,  LeafNode.AutoID as NodeID
	, Servicepack
	, Hotfix
    	, AVIView_Software.ProductCode
	, '' as Language
--	,  Language =
--    		CASE 
--     		WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
--     		WHEN  ProductProperties.Language = '' THEN '---'
--     		ELSE  ProductProperties.Language
--     		END
	, ComputerProperties.OSPlatform
	, ComputerProperties.OSType


 FROM
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		  and (LeafNode.LastUpdate  >=  @YYYYMMDD or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null)
		   AND LeafNode.Type !=24  )    /* Uninstalled */ 
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		   AND DATVer != '5000')
		Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
			  AND dbo.tmpDERules.Rulename = @szReportID  and dbo.tmpDERules.Eng1 > '')
	)
	on( @szReportID = 'ENG'  and  leafnode.autoid = productproperties.parentid )  -- run only for dat report

--	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
--	)
--  	left outer Join
--   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode)
--		Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
--			  AND dbo.tmpDERules.Rulename = @szReportID   and dbo.tmpDERules.Eng1 > '')
--	)
--	on( @szReportID = 'ENG'  and  leafnode.autoid = productproperties.parentid )  -- run only for eng report
 
 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
and @szReportID = 'ENG'
--   AND LeafNode.AutoID = ComputerProperties.ParentID
--                  AND ProductProperties.ParentID = LeafNode.AutoID 
--   AND ProductProperties.ProductCode = AVIView_Software.ProductCode
--   AND LeafNode.ParentID = BranchNode.AutoID
--   AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   AND LanguageDesc.epoServerLanguageSuffix = @szLang
--   AND LeafNode.Type !=24      /* Uninstalled */ 
--   and @szReportID = 'ENG'	-- run only for eng report
--  and dbo.tmpDERules.Eng1 > ''
--  and LeafNode.LastUpdate  >=  @YYYYMMDD


 UNION ALL

 -- DATEng report 

  SELECT
   	RuleName = 
	CASE 
	when (EngineVer >=  dbo.tmpDERules.Eng1DE and DATVer >=  dbo.tmpDERules.DAT1DE) then 'Current or Newer'
	when (EngineVer <  dbo.tmpDERules.Eng1DE and DATVer >=  dbo.tmpDERules.DAT1DE) then 'Out of Date Engine'
	when (EngineVer >=  dbo.tmpDERules.Eng1DE and DATVer <  dbo.tmpDERules.DAT1DE) then 'Out of Date DAT'
	when (EngineVer <  dbo.tmpDERules.Eng1DE and DATVer <  dbo.tmpDERules.DAT1DE) then 'Out of Date Engine and DAT'
	else Case
		When LeafNode.AgentVersion > '' Then 'Unprotected' 
		Else 'UninstalledAgent'
		End 
	end	--as RuleName
	, '' as RuleDescription
   	, BranchNode.NodeName AS NodeName
	, cast(ReportFullPathNode.FullPathName as varchar(255)) as FullNodePath
   	, LeafNode.AgentVersion
   	, Case
		When AVIView_Software.SoftwareName > '' then AVIView_Software.SoftwareName
		else	Case
			When LeafNode.AgentVersion > '' Then @Unprotected 
			Else @NoAgent
			End 
		End as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion 
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE  
     		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer
     		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ProductProperties.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ProductProperties.ExtraDATNames 
     		END
	,    ProductFamily =
    		CASE 
     		WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     		WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     		ELSE  AVIView_Software.ProductFamily 
     		END
	, ComputerProperties.DomainName
--	postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as ComputerName
--	, ComputerProperties.ComputerName  -- Use leafnode nodename for noagent since they usually dont have computer props
	, ComputerProperties.IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, ComputerProperties.UserName
--    	, CAST('' As varchar(255)) As FileName
  	, '' as FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
   	, RuleNumber = 
		CASE 
		when (EngineVer >=  dbo.tmpDERules.Eng1DE and DATVer >=  dbo.tmpDERules.DAT1DE) then 0
		when (EngineVer <  dbo.tmpDERules.Eng1DE and DATVer >=  dbo.tmpDERules.DAT1DE) then 21
		when (EngineVer >=  dbo.tmpDERules.Eng1DE and DATVer <  dbo.tmpDERules.DAT1DE) then 22
		when (EngineVer <  dbo.tmpDERules.Eng1DE and DATVer <  dbo.tmpDERules.DAT1DE) then 23
 		else Case
			When LeafNode.AgentVersion > '' Then 7
			Else 8
			End 
		end	
--	, 1 as RuleNumber
	, LeafNode.LastUpdate as LastContact
     	, cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
        	as varchar(50)) as OSVersion
   	,  LeafNode.AutoID as NodeID
	, Servicepack
	, Hotfix
    	, AVIView_Software.ProductCode
	, '' as Language
--	,  Language =
--    		CASE 
--     		WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
--     		WHEN  ProductProperties.Language = '' THEN '---'
--     		ELSE  ProductProperties.Language
--     		END
	, ComputerProperties.OSPlatform
	, ComputerProperties.OSType

 FROM 
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		  and (LeafNode.LastUpdate  >=  @YYYYMMDD or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null)
		   AND LeafNode.Type !=24  )    /* Uninstalled */ 
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		   AND DATVer != '5000')
		Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
			  AND dbo.tmpDERules.Rulename = @szReportID  and dbo.tmpDERules.DAT1DE > '')
	)
	on( @szReportID = 'DATENG'  and  leafnode.autoid = productproperties.parentid )  -- run only for dat report

--	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
--	)
--  	left outer Join
--   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode)
--		Join dbo.tmpDERules on (dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
--			  AND dbo.tmpDERules.Rulename = @szReportID)
--	)
--	on( @szReportID = 'DATENG'  and  leafnode.autoid = productproperties.parentid )  -- run only for dat report

 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where BranchNodeEnum.StartAutoID = @FilterID)
   )
and @szReportID = 'DATENG'
--   AND LeafNode.AutoID = ComputerProperties.ParentID
--                  AND ProductProperties.ParentID = LeafNode.AutoID 
--   AND ProductProperties.ProductCode = AVIView_Software.ProductCode
--   AND LeafNode.ParentID = BranchNode.AutoID
--   AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   AND LanguageDesc.epoServerLanguageSuffix = @szLang
--   AND LeafNode.Type !=24      /* Uninstalled */ 
--   AND DATVer != '5000'

--  AND dbo.tmpDERules.ProductFamily = AVIView_Software.ProductFamily
--   and @szReportID = 'DATENG'	-- run only for dateng report
--  and dbo.tmpDERules.DAT1DE > ''
--  and LeafNode.LastUpdate  >=  @YYYYMMDD




  set @ret = @@rowcount

--  Drop Table #tmpDATRules
--  Drop Table #tmpEngRules
  Drop Table dbo.tmpDERules


 RETURN @ret
END

GO





/**********  epo3.0 new outbreak recognition procedure *********/

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterOutbreakEvents]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterOutbreakEvents]
GO


CREATE PROCEDURE dbo.AVISP_FilterOutbreakEvents
(
	@iNameSpaceName		VARCHAR(20)
	, @iNameSpaceNode		VARCHAR(20)
    	, @szEpoUserName          	VARCHAR(100)
	, @szNameSpaceName		VARCHAR(100)
	, @szNameSpaceNode		VARCHAR(500)
	, @szMinMachineCount		VARCHAR(20)= '5'
	, @szMinFilenameCount		VARCHAR(20)= '5'
	, @dtStartDate			VARCHAR(50)
	, @szHourRange		VARCHAR(20)='1'
	, @szOptionalReportParms 	 VARCHAR(500) = ''
	, @InfectAfterRule 		varchar(30) = ''

--	, @SaveOutbreakDefn		int=0
--	, @EnableBatchJob		int=0	-- 1 = enable, 2 = disable
--	, @RunasBatchJob		int=0
--	, @UpdateEmailNotification	varchar(100)=''
)
AS
BEGIN
 	/* Copyright + 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	/* This procedure can run as a report or as a batch job in looking for outbreaks */

 	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
	Declare @UsersTopNodeID int
	Declare @FilterNodeID int
	Declare @DayofWeek int
	Declare @iMinMachineCount int		
	Declare @iMinFilenameCount int		
	Declare @iHourRange int	

	-- dont use this as an input parm for now
	Declare @RunasBatchJob int
	IF @szOptionalReportParms = 'BatchModeUpdateTableOnly'
		Set @RunasBatchJob =1
	else
		Set @RunasBatchJob =0

	select @UsersTopNodeID = convert(int, @iNameSpaceName)
	select @FilterNodeID = convert(int, @iNameSpaceNode)
	select @iMinMachineCount = convert(int, @szMinMachineCount)
	select @iMinFilenameCount = convert(int, @szMinFilenameCount)
	select @iHourRange = convert(int, @szHourRange)

	Declare @FilterID int
	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT
  
	Declare @ret int

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @dtStartDate, @InfectAfterRule, @YYYYMMDD output

-----------------
-- postepo3 cleanup temp dbs
	IF EXISTS (select * from sysobjects where name = 'tmpOutbreakGroup' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOutbreakGroup

	IF EXISTS (select * from sysobjects where name = 'tmpOutbreakVirus' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOutbreakVirus

	IF EXISTS (select * from sysobjects where name = 'tmpOutbreakStats' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOutbreakStats



	/*************************************************************************************************/
	-- Report Mode - save outbreak definition for Batch Mode processing -- canceled for epo3
/*
	if @SaveOutbreakDefn = 1
	begin
		if exists (select ParmName from ReportInputParametersSaved where ReportID = 'REPORTOUTBREAK' and ParmName = '@iMinMachineCount')
			update ReportInputParametersSaved set ParmValue = @iMinMachineCount where  ReportID = 'REPORTOUTBREAK' and ParmName = '@iMinMachineCount'
		else
			insert ReportInputParametersSaved values( 'REPORTOUTBREAK', '@iMinMachineCount', @iMinMachineCount)

		if exists (select ParmName from ReportInputParametersSaved where ReportID = 'REPORTOUTBREAK' and ParmName = '@iMinFilenameCount')
			update ReportInputParametersSaved set ParmValue = @iMinFilenameCount where  ReportID = 'REPORTOUTBREAK' and ParmName = '@iMinFilenameCount'
		else
			insert ReportInputParametersSaved values( 'REPORTOUTBREAK', '@iMinFilenameCount', @iMinFilenameCount)

		if exists (select ParmName from ReportInputParametersSaved where ReportID = 'REPORTOUTBREAK' and ParmName = '@iHourRange')
			update ReportInputParametersSaved set ParmValue = @iHourRange where  ReportID = 'REPORTOUTBREAK' and ParmName = '@iHourRange'
		else
			insert ReportInputParametersSaved values( 'REPORTOUTBREAK', '@iHourRange', @iHourRange)
	end

	-- Update epo outbreak operator's email address, cancelled for epo3
	if @UpdateEmailNotification > ''
		execute msdb..sp_update_operator
			@name = 'epo_outbreak'
			--,@enabled = 1
			,@email_address = @UpdateEmailNotification
*/
	
	/* Batch Mode - Read input parms from database, override stored procedure inputs */
	if @RunasBatchJob = 1
	begin
		if exists (select ParmName from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szMinMachineCount')
			select @iMinMachineCount=ParmValue from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szMinMachineCount'

		if exists (select ParmName from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szMinFilenameCount')
			select @iMinFilenameCount=ParmValue from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szMinFilenameCount'

		if exists (select ParmName from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szHourRange')
			select @iHourRange=ParmValue from ReportInputParameters where ReportID = 'REPORTOUTBREAK' and ParmName = '@szHourRange'


		-- Set @dtStartDate = detdate - 2* @iHourRange
--		declare @interval int
--		set @interval = ( -1 * @iHourRange * 2 )
--		select @YYYYMMDD = dateadd(hour,  @interval, getdate() ) 

	end

-- debug
--select @iHourRange, @iMinFilenameCount, @iMinMachineCount, @szLang, @YYYYMMDD

	/*********************************************************************************************/
	/* recognize outbreaks by searching for min events over the hour range */

	select 
		Virusname,
		Virustype,
		datepart(year, eventdatetime) as dtyear,
		( (24*(datepart(dayofyear, eventdatetime)-1)) + (datepart(hour, eventdatetime)+1)  ) / @iHourRange as HourRangeNumber,
		count(*) as 'TotalEvents',
		count(distinct (hostname + filename)) as 'MachineFileCnt',
		count(distinct hostname) as 'MachinesCnt',
		count(distinct filename) as 'FilesCnt',
		cast(min(convert(char(19),eventdatetime,120)+ ' ' + HostName + ' ' + ProductName) as varchar(100)) as 'OutbreakStart',
		cast(max(convert(char(19),eventdatetime,120)+ ' ' + HostName + ' ' + ProductName) as varchar(100)) as 'OutbreakEnd'

	into dbo.tmpOutbreakGroup 
	from Events
	where
 
		virusname > '' and HostName > ''
		AND Virusname not like 'Eicar%'
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

/* todo: setup some action code condiditons */
		AND eventdatetime > @YYYYMMDD
        		AND Events.ProductName != 'ePO Agent' 
--		AND ActionTaken in ('51','53','55','58','62','64','66')
	group by
		virusname
		,Virustype
		,datepart(year, eventdatetime)
		,( (24*(datepart(dayofyear, eventdatetime)-1)) + (datepart(hour, eventdatetime)+1)  ) / @iHourRange
	having 
		count(distinct filename) > @iMinFilenameCount
		or
		count(distinct hostname) > @iMinMachineCount
	order by 
		virusname, HourRangeNumber


/* debug */
--select * from dbo.tmpOutbreakGroup order by  virusname


	/* get outbreak viruses and summary stats */

	select 
		virusname
		,count(*) NumberofOutbreakPeriods
		,min( dbo.tmpOutbreakGroup.OutbreakStart ) as FirstOutbreakEvent 
		,max( dbo.tmpOutbreakGroup.OutbreakEnd ) as LastOutbreakEvent
		,sum(dbo.tmpOutbreakGroup.TotalEvents) as 'TotalEvents'
		,sum(dbo.tmpOutbreakGroup.MachineFileCnt) as 'MachineFileCnt'
		,sum(dbo.tmpOutbreakGroup.MachinesCnt) as 'MachinesCnt'
		,sum(dbo.tmpOutbreakGroup.FilesCnt) as 'FilesCnt'
	into dbo.tmpOutbreakVirus 
	from dbo.tmpOutbreakGroup
	Group by
		virusname

/* 
--select * from dbo.tmpOutbreakVirus
*/

	/* get outbreak stats starting from the starting scan date */ 

	select 
		Events.Virusname as 'OutbreakVirus'
   		, case VirusType.VirusType
			when '' then	case Events.VirusType when '' then '---' else Events.VirusType end
			when null then	case Events.VirusType when '' then '---' else Events.VirusType end
			else VirusType.VirusType
			end as VirusType
		,cast(min(convert(char(19),eventdatetime,120)+ ' ' + HostName + ' ' + ProductName) as varchar(100)) as 'OutbreakStart'
		,cast(max(convert(char(19),eventdatetime,120)+ ' ' + HostName + ' ' + ProductName) as varchar(100)) as 'OutbreakEnd'
		,dbo.tmpOutbreakVirus.NumberofOutbreakPeriods as NumberofOutbreakPeriods
		,dbo.tmpOutbreakVirus.FirstOutbreakEvent as FirstOutbreakEvent 
		,dbo.tmpOutbreakVirus.LastOutbreakEvent as LastOutbreakEvent
		,count(*) as 'TotalEvents'
		,count(distinct hostname) as 'MachinesCnt'
		,count(distinct filename) as 'FilesCnt'
		,count(distinct (hostname + filename)) as 'MachineFileCnt'

	into dbo.tmpOutbreakStats
	from 
	Events Join dbo.tmpOutbreakVirus on (Events.Virusname = dbo.tmpOutbreakVirus.Virusname)
	Left Outer Join VirusType on (events.VirusName = VirusType.VirusName)
	where

		Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--		AND Events.Virusname = dbo.tmpOutbreakVirus.Virusname
		and eventdatetime > @YYYYMMDD
        		AND Events.ProductName != 'ePO Agent' 
--		AND ActionTaken in ('51','53','55','58','62','64','66')
--		and events.VirusName *= VirusType.VirusName				-- outer join 

	group by
		Events.virusname
		,dbo.tmpOutbreakVirus.NumberofOutbreakPeriods
		,dbo.tmpOutbreakVirus.FirstOutbreakEvent 
		,dbo.tmpOutbreakVirus.LastOutbreakEvent
		,events.VirusType
		,VirusType.VirusType

/*
--select * from dbo.tmpOutbreakStats
*/

/*
 Output select listing details of each occurrence 
*/
/*
*/
	/* Batch Mode - call RAISERROR if an outbreaks exists */
	if @RunasBatchJob = 1
	begin
		declare @numOutbreaks int
		declare @Virus varchar(64)
		declare @numMachines int
		declare @numFiles int
		declare @datetime varchar(64)


		-- Report Outbreak events in summary table
--		Truncate Table ReportOutbreakEvents
--		output the outbreak summary not the details
		INSERT INTO ReportOutbreakEvents
   	              SELECT
		 dbo.tmpOutbreakStats.OutbreakVirus as 'OutbreakVirus'
		, dbo.tmpOutbreakStats.VirusType as 'VirusType'
		,dbo.tmpOutbreakStats.OutbreakStart as 'OutbreakStart'
		,dbo.tmpOutbreakStats.OutbreakEnd as 'OutbreakEnd'
		,dbo.tmpOutbreakStats.NumberofOutbreakPeriods as NumberofOutbreakPeriods
		,dbo.tmpOutbreakStats.FirstOutbreakEvent as FirstOutbreakEvent 
		,dbo.tmpOutbreakStats.LastOutbreakEvent as LastOutbreakEvent
		,dbo.tmpOutbreakStats.TotalEvents as 'TotalEvents'
		,dbo.tmpOutbreakStats.MachinesCnt as 'MachinesCnt'
		,dbo.tmpOutbreakStats.FilesCnt as 'FilesCnt'
		,dbo.tmpOutbreakStats.MachineFileCnt as 'MachineFileCnt'
		,CAST('' as varchar(100)) AS NodeName
		,CAST('' as varchar(100)) As HostName
		,CAST('' as varchar(100)) AS HostIPAddress
		,dbo.tmpOutbreakStats.OutbreakVirus as VirusName
		,CAST('' as varchar(100)) As FileName
		,CAST('' as varchar(100)) as EngineVersion
		,CAST('' as varchar(100)) as DATVersion
   		,CAST('' as varchar(100)) as ActionTaken
		,CAST('' as varchar(100)) as username
		,CAST('' as varchar(100)) as productname
		,CAST('' as varchar(100)) as productversion
		,CAST('' as varchar(100)) as EventDateTime
		,CAST('' as varchar(100)) as NodeID
		, @iMinMachineCount as RuleMachineCnt
		, @iMinFilenameCount as RuleFileCnt
		, @iHourRange as RuleHourCnt
	     	FROM dbo.tmpOutbreakStats
--select @iHourRange, @iMinFilenameCount, @iMinMachineCount, @szLang, @YYYYMMDD

/*
		INSERT INTO ReportOutbreakEvents
   	              SELECT
		 Events.Virusname as 'OutbreakVirus'
		,Events.VirusType as 'VirusType'
		,dbo.tmpOutbreakStats.OutbreakStart as 'OutbreakStart'
		,dbo.tmpOutbreakStats.OutbreakEnd as 'OutbreakEnd'
		,dbo.tmpOutbreakStats.NumberofOutbreakPeriods as NumberofOutbreakPeriods
		,dbo.tmpOutbreakStats.FirstOutbreakEvent as FirstOutbreakEvent 
		,dbo.tmpOutbreakStats.LastOutbreakEvent as LastOutbreakEvent
		,dbo.tmpOutbreakStats.TotalEvents as 'TotalEvents'
		,dbo.tmpOutbreakStats.MachinesCnt as 'MachinesCnt'
		,dbo.tmpOutbreakStats.FilesCnt as 'FilesCnt'
		,dbo.tmpOutbreakStats.MachineFileCnt as 'MachineFileCnt'
		,CAST('' as varchar(100)) AS NodeName
		,cast(Events.HostName as varchar(50)) As HostName
		,Events.HostIPAddress
		,Events.VirusName
		,cast(Events.FileName as varchar(200)) As FileName
		,Events.EngineVersion
		,Events.DATVersion
   		,ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END
		,Events.username
		,Events.productname
		,Events.productversion
		,Events.EventDateTime
		,Events.NodeID
	     	FROM Events, dbo.tmpOutbreakStats, ReportActionDesc
	     	WHERE
	 		Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
			AND Events.Virusname = dbo.tmpOutbreakStats.OutbreakVirus
	  		AND Events.ActionTaken = ReportActionDesc.ActionIntID
		   	AND ReportActionDesc.LanguageSuffix = @szLang
			and eventdatetime > @YYYYMMDD
        			AND Events.ProductName != 'ePO Agent' 
--			AND ActionTaken in ('51','53','55','58','62','64','66')		-- all virus events
*/

	 	-- summarize result and raise an error - removed for now
/*
		select
			@numOutbreaks = count(*)	
			, @Virus = max(OutbreakVirus)	
			, @numMachines = sum(MachinesCnt)
			, @numFiles = sum(FilesCnt)
		from dbo.tmpOutbreakStats

		select @dateTime = convert(char, GetDate(), 120)

		if @numOutbreaks > 0
			RAISERROR ( 58376, 16, 1
				, @numOutbreaks
				, @dateTime
				, @Virus
				, @numMachines
				, @numFiles )
				 with LOG 
*/
	end 
	else
	begin
	       /* Report Mode - fetch all events from the outbreaks */
	       select 
		Events.Virusname as 'OutbreakVirus'
		,dbo.tmpOutbreakStats.VirusType as 'VirusType'
		,dbo.tmpOutbreakStats.OutbreakStart as 'OutbreakStart'
		,dbo.tmpOutbreakStats.OutbreakEnd as 'OutbreakEnd'
		,dbo.tmpOutbreakStats.NumberofOutbreakPeriods as NumberofOutbreakPeriods
		,dbo.tmpOutbreakStats.FirstOutbreakEvent as FirstOutbreakEvent 
		,dbo.tmpOutbreakStats.LastOutbreakEvent as LastOutbreakEvent
		,dbo.tmpOutbreakStats.TotalEvents as 'TotalEvents'
		,dbo.tmpOutbreakStats.MachinesCnt as 'MachinesCnt'
		,dbo.tmpOutbreakStats.FilesCnt as 'FilesCnt'
		,dbo.tmpOutbreakStats.MachineFileCnt as 'MachineFileCnt'
		,CAST('' as varchar(100)) AS NodeName
		,cast(Events.HostName as varchar(50)) As HostName
		,Events.HostIPAddress
		,Events.VirusName
		,cast(Events.FileName as varchar(200)) As FileName
		,Events.EngineVersion
		,Events.DATVersion
   		,ActionTaken =
	    		CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     		END
		,Events.username
		,Events.productname
		,Events.productversion
		,Events.EventDateTime
		,datepart(year, Events.eventdatetime) as evdtyear
		,datepart(week, Events.eventdatetime) as evdtweek
		,(convert( varchar(5), datepart(year, Events.eventdatetime) )
			+ ' ' +  convert( varchar(5), datepart(quarter, Events.eventdatetime)) + 'Q')
			as evdtquarter

	     from 
		Events Join dbo.tmpOutbreakStats on (Events.Virusname = dbo.tmpOutbreakStats.OutbreakVirus)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
	   		AND ReportActionDesc.LanguageID = @szFullLang)
	     where
  		(	-- check for directory filter
   			@FilterID = 0 OR
    			Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        			from BranchNodeEnum 
        			where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
		and
		Events.virusname > '' and Events.HostName > '' and Events.filename > '' and Events.actiontaken > ''
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--		AND Events.Virusname = dbo.tmpOutbreakStats.OutbreakVirus
--	  	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--	   	AND ReportActionDesc.LanguageSuffix = @szLang
		and eventdatetime > @YYYYMMDD
        		AND Events.ProductName != 'ePO Agent' 
--		AND ActionTaken in ('51','53','55','58','62','64','66')

	end


/*	group by
		Events.virusname
		,Events.virustype
		,dbo.tmpOutbreakStats.OutbreakStart
		,dbo.tmpOutbreakStats.OutbreakEnd
		,dbo.tmpOutbreakStats.NumberofOutbreakPeriods
		,dbo.tmpOutbreakStats.FirstOutbreakEvent 
		,dbo.tmpOutbreakStats.LastOutbreakEvent
		,dbo.tmpOutbreakStats.TotalEvents
		,dbo.tmpOutbreakStats.MachinesCnt
		,dbo.tmpOutbreakStats.FilesCnt
		,dbo.tmpOutbreakStats.MachineFileCnt
		,Events.hostname
		,Events.hostipaddress
		,Events.username
		,Events.productname
		,Events.productversion
		,Events.engineversion
		,Events.datversion
		,Events.filename
		,Events.actiontaken
		,ReportActionDesc.ActionName
		,Events.EventDateTime
*/

/*	
Dont include this order by clause in production - test only

		ORDER BY OutbreakName, EventTime 

*/

	set @ret = @@rowcount


/* cleanup */


	DROP TABLE dbo.tmpOutbreakGroup

	DROP TABLE dbo.tmpOutbreakVirus

	DROP TABLE dbo.tmpOutbreakStats


	/***********************************************************************************/
	/* Update Batch Mode Job and Alert Parameters */

	/* Report Mode - enable Batch Mode job */
	-- canceled for epo3.0
/*
	if @EnableBatchJob = 1
	begin

		execute msdb..sp_update_job
			@job_name = 'epo_outbreak_search'
			,@enabled = 1

		execute msdb..sp_update_jobschedule
			@job_name = 'epo_outbreak_search'
			,@name = 'epo_outbreak'
			,@enabled=1
			--,@freq_type=4 -- daily
			--,@freq_interval=1 -- everyday
			--,@freq_subday_type=8 -- hours
			--,@freq_subday_interval=1 -- 1 hour

		execute msdb..sp_update_operator
			@name = 'epo_outbreak'
			,@enabled = 1
			--,@email_address = ''
	end

	if @EnableBatchJob = 2
	begin

		execute msdb..sp_update_job
			@job_name = 'epo_outbreak_search'
			,@enabled = 0

		execute msdb..sp_update_jobschedule
			@job_name = 'epo_outbreak_search'
			,@name = 'epo_outbreak'
			,@enabled=0
			--,@freq_type=4 -- daily
			--,@freq_interval=1 -- everyday
			--,@freq_subday_type=8 -- hours
			--,@freq_subday_interval=1 -- 1 hour

		execute msdb..sp_update_operator
			@name = 'epo_outbreak'
			,@enabled = 0
			--,@email_address = ''

	end
*/

	/* Set Batch Mode schedule interval */
/*	if @SaveOutbreakDefn = 1
		execute msdb..sp_update_jobschedule
			@job_name = 'epo_outbreak_search'
			,@name = 'epo_outbreak'
			,@freq_type=4 -- daily
			,@freq_interval=1 -- everyday
			,@freq_subday_type=8 -- hours
			,@freq_subday_interval= @iHourRange -- 1 hour
*/


/*
*/

Return @ret
END
GO




-----------------------------------------------------------------
-- Computer and compliance summary routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_SetComputerSummary]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_SetComputerSummary]
GO


CREATE PROCEDURE dbo.AVISP_SetComputerSummary
( 
@dtInfectionCheckPoint DateTime
, @dtAsciCheckpoint	DateTime
, @szRuleName varchar(50) = 'default'
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'

-----------------------------
-- postepo3  cleanup temp tables (cant use tempdb anymore)

	IF EXISTS (select * from sysobjects where name = 'tmpUnmanagedProtection' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpUnmanagedProtection

	IF EXISTS (select * from sysobjects where name = 'tmpScanners' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpScanners


---------------------------
	/* Fetch Computer Summary - 1 row for each computer (get all computer related data needed for this report - display and cust data */
	Truncate Table ReportComputerSummary 

	Declare @ret int

	/* Get Computer Properties */
 	INSERT ReportComputerSummary
	  SELECT
		LeafNode.ParentID as BranchNodeID
		, LeafNode.AutoID as NodeID
		, LeafNode.NodeName as NodeNameLeaf
		, BranchNode.NodeName as NodeNameBranch
		, ReportFullPathNode.FullPathName as FullNodePath
		, '(NoAgent)' as AgentVersion
		, '' as LastAsci
		, 1 as NoAgent
		, NULL as AsciSinceCheckPoint
		, '(Unprotected)' as  ProductName
 		, ' ' as  ProductCode  -- want to default this to a space (when drilldown on policy a null value will make crystal pop a dialog
		, NULL as  ProductFamily
 		, '(Unprotected)' as  ProductVersion
 		, '(Unprotected)' as  EngineVer
 		, '(Unprotected)' as  DATVer
		, NULL as  ExtraDATNames
		, 1 as NoAV
 		, 0 as MultipleScanner
		, NULL as  ScannerLanguage
		, NULL as  ComputerLanguage
		, ComputerProperties.DomainName
--		, NULL as OSVersion
		,    cast((ComputerProperties.OSType 
			+ ' ' + ComputerProperties.OSServicePackVer 
			+ ' ' + ComputerProperties.OSPlatform)
       			as varchar(50)) as OSVersion
		, ComputerProperties.ComputerName
		, ComputerProperties.IPAddress as IPAdress
		-- ComplianceComparison Changes
		, GetDate() as DateTimeOfRun
		, 0 as VirusCount
		, 0 as UnresolvedVirusCount
		, cast(NULL as varchar(50)) as VirusnameMax
		, cast(NULL as varchar(50)) as UnresolvedVirusnameMax
		, 0 as VirusnameMaxCount
		, 0 as UnresolvedVirusnameMaxCount
		, 0 as DuplicateComputer
		, 0 as DuplicateScannerID
		, 1 as Compliant
        	, '' as Servicepack
		, '' as Hotfix
        	, '' as LicenseStatus
		, '' as ExpirationDate
		, ComputerProperties.OSPlatform as OSPlatform
		, ComputerProperties.OSType as OSType
		
	FROM 
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	Left Outer Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	WHERE 
		LeafNode.Type=1   
--		AND LeafNode.AutoID *= ComputerProperties.ParentID	-- outer join: finds all leafnodes, event those w/o agents and computer properties
--		AND LeafNode.ParentID = BranchNode.AutoID
--		AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
/*	Group By 
		BranchNode.AutoID
		, LeafNode.AutoID
*/

	set @ret = @@rowcount

if @szRuleName = 'test'
begin
select 'ReportComputerSummary', * from ReportComputerSummary
select 'ReportFullPathNode', * from ReportFullPathNode
end

	/* Find Duplicate Computers */
	UPDATE	ReportComputerSummary
		SET DuplicateComputer = 1
	FROM
		LeafNode a, LeafNode b, ReportComputerSummary
	WHERE
		a.NodeName = b.NodeName
		and a.AutoID != b.AutoID
		and a.LastUpdate < b.LastUpdate
		and a.LastUpdate is not NULL
		and ReportComputerSummary.NodeID = a.AutoID

if @szRuleName = 'test'
select 'DuplicateComputer', @@rowcount


	/* Get Agent Data */

	UPDATE	ReportComputerSummary
		SET AgentVersion = ProductProperties.ProductVersion
		    , NoAgent = 0
		    , LastAsci = LeafNode.LastUpdate
  		    , AsciSinceCheckPoint = 
				case
				when LeafNode.LastUpdate = '' THEN 0
				when LeafNode.LastUpdate = NULL THEN 0 
				when CONVERT(datetime,
  					(SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
  					SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
					SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
   					SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
   					SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
   					SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
   					), 120 )   
						 > @dtAsciCheckPoint  THEN 1 
				else 0 
			   	end 
			       
		From ProductProperties, LeafNode
		WHERE
			LeafNode.AutoID = ReportComputerSummary.NodeID
			AND ReportComputerSummary.NodeID = ProductProperties.ParentID
   			AND ProductProperties.ProductCode LIKE '%Agent%'

if @szRuleName = 'test'
select 'Find agents', @@rowcount

	----------------------------------------------------------------------------------------------
	/* Fetch scanning product data - handles single scanner, multiple scanner, and unmanaged protection cases */

	UPDATE	ReportComputerSummary
		SET 
			ProductName =  AVIView_Software.SoftwareName
			, ProductCode =  ProductProperties.ProductCode
			, ProductVersion = ProductProperties.ProductVersion
			, EngineVer = ProductProperties.EngineVer
			, DATVer = ProductProperties.DATVer
			, ExtraDATNames = 
			    	CASE ProductProperties.ExtraDATNames
			     	WHEN '' THEN '' 
			     	WHEN 'N/A' THEN '' 
			     	ELSE ProductProperties.ExtraDATNames     	
			     	END
			, ScannerLanguage = ProductProperties.Language
			, ProductFamily = AVIView_Software.ProductFamily
			, NoAV = 0
--			, MultipleScanner = count(*)
--			, DuplicateScannerID = MIN( ProductProperties.AutoID )
        		, Servicepack = ProductProperties.Servicepack
			, Hotfix = ProductProperties.Hotfix
        		, LicenseStatus = productproperties.licensestatus
			, ExpirationDate = productproperties.expirationdate
		FROM 	ProductProperties, AVIView_Software
		WHERE
			ReportComputerSummary.NodeID = ProductProperties.ParentID
			and ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )


if @szRuleName = 'test'
select 'Find AV data', @@rowcount

	/* Look for duplicate scanner and makesure data for latest and previous is recorded */
	SELECT
			NodeID = LeafNode.AutoID
			, MainScanner = Max( ProductProperties.AutoID )
			, MultipleScanner = count(*)
			, DuplicateScannerID = Min( ProductProperties.AutoID )
	INTO 	dbo.tmpScanners
		FROM 	LeafNode, ProductProperties, AVIView_Software
		WHERE
			LeafNode.AutoID = ProductProperties.ParentID
			and ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
 
		GROUP BY 
			LeafNode.AutoID
			, ProductProperties.AutoID
		HAVING count(*) > 1

	-- Record main scanner in multiple scanner situation
	UPDATE	ReportComputerSummary
		SET 
			ProductName =  AVIView_Software.SoftwareName
			, ProductCode =  ProductProperties.ProductCode
			, ProductVersion = ProductProperties.ProductVersion
			, EngineVer = ProductProperties.EngineVer
			, DATVer = ProductProperties.DATVer
			, ExtraDATNames = 
			    	CASE ProductProperties.ExtraDATNames
			     	WHEN '' THEN '' 
			     	WHEN 'N/A' THEN '' 
			     	ELSE ProductProperties.ExtraDATNames     	
			     	END
			, ScannerLanguage = ProductProperties.Language
			, ProductFamily = AVIView_Software.ProductFamily
			, NoAV = 0
			, MultipleScanner = dbo.tmpScanners.MultipleScanner
        		, Servicepack = ProductProperties.Servicepack
			, Hotfix = ProductProperties.Hotfix
--			, DuplicateScannerID = MIN( ProductProperties.AutoID )
		FROM 	ProductProperties, AVIView_Software, dbo.tmpScanners
		WHERE
			ReportComputerSummary.NodeID = dbo.tmpScanners.NodeID
			and ReportComputerSummary.NodeID = ProductProperties.ParentID
			and ProductProperties.AutoID = dbo.tmpScanners.MainScanner
			and ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and dbo.tmpScanners.MultipleScanner > 1

if @szRuleName = 'test'
select 'DuplicateScanner-main', @@rowcount

	-- Record Duplicate scanner
	UPDATE	ReportComputerSummary
		SET 
			 DuplicateScannerID = dbo.tmpScanners.DuplicateScannerID
		FROM 	 dbo.tmpScanners
		WHERE
			ReportComputerSummary.NodeID = dbo.tmpScanners.NodeID
			and dbo.tmpScanners.MultipleScanner > 1

if @szRuleName = 'test'
select 'DuplicateScanner', @@rowcount			

	/* Fetch Nodes with no products: aviinstall=0, but with unmanaged protection (events but no props, groupshield */


	SELECT distinct
   		LeafNode.AutoID as NodeID
   		, ProductName
   		, ProductVersion = 
      			CASE
          			WHEN Max( ProductVersion )  > '' THEN Max( ProductVersion )
 		         	WHEN Max( ProductVersion )  = '' THEN '---'
 		         	ELSE  '---'
		        END
 		  , EngineVer = 
 		    	CASE
		          	WHEN Max(Events.EngineVersion)  > '' THEN Max(Events.EngineVersion)
		          	WHEN Max(Events.EngineVersion)  = '' THEN '---'
		          	ELSE  '---'
 		       END	
 		  , DATVer = 
 		    	CASE
 		         	WHEN Max(Events.DATVersion)  > '' THEN Max(Events.DATVersion)
 		       	  WHEN Max(Events.DATVersion)  = '' THEN '---'
 		         	ELSE  '---'
  		      END
		,ProductFamily = 'TVD'

	 INTO dbo.tmpUnmanagedProtection
	 FROM LeafNode, Events
	 WHERE
 	 	LeafNode.AVInstalls = 0
 		AND LeafNode.Type !=24      
		AND LeafNode.AutoID = Events.NodeID			
   		AND
   		(
      			Events.ProductName like '%GroupShield%'
      			OR (Events.ProductName like '%NetShield%' and ProductVersion < '4.5')
      			OR (Events.ProductName like '%VirusScan%' and ProductVersion < '4.5')
      			OR Events.ProductName like '%WebShield%'
   		)
   	GROUP BY
		LeafNode.AutoID
      		, Events.ProductName

		/* use group by to remove duplicates and return latest version, engine, dats */



/* Merge Unmanaged Protection fields into EventAgentSummary table */


	UPDATE	ReportComputerSummary
	SET
 		ProductName = dbo.tmpUnmanagedProtection.ProductName
 		, ProductVersion = dbo.tmpUnmanagedProtection.ProductVersion
 		, EngineVer = dbo.tmpUnmanagedProtection.EngineVer
 		, DATVer = dbo.tmpUnmanagedProtection.DATVer
		, NoAV = 0
	FROM	dbo.tmpUnmanagedProtection
	WHERE
		ReportComputerSummary.NodeID = dbo.tmpUnmanagedProtection.NodeID
		AND 	(ReportComputerSummary.ProductName = ''
			OR  ReportComputerSummary.ProductName is NULL
			OR  ReportComputerSummary.ProductName = '(Unprotected)')			

if @szRuleName = 'test'
select 'UnmanagedProtection', @@rowcount

drop table dbo.tmpUnmanagedProtection
drop table dbo.tmpScanners




--select * from ReportComputerSummary
--order by duplicatescannerid desc 
--order by duplicatecomputer desc


RETURN @ret
END
GO





---------------------------------------------------------
---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_SetComplianceComparison]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_SetComplianceComparison]
GO



-- Daily compliance comparison job 
-- fills ReportComplianceComparison and ReportUpdateEvents
-- by comparing ReportComputerSummaryPrevious to ReportComputerSummary
-- Daily compliance comparison job 
-- fills ReportComplianceComparison and ReportUpdateEvents
-- by comparing ReportComputerSummaryPrevious to ReportComputerSummary
CREATE PROCEDURE dbo.AVISP_SetComplianceComparison
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @dtInfectionCheckPoint DateTime

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

	Declare @ret int  
	set @ret = 0

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


-------------------
-- postepo3   clean up tempdbs

	IF EXISTS (select * from sysobjects where name = 'tmpPreviousNodeIDs' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpPreviousNodeIDs

	IF EXISTS (select * from sysobjects where name = 'tmpNewNodeIDs' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpNewNodeIDs

	IF EXISTS (select * from sysobjects where name = 'tmpOldNodeIDs' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpOldNodeIDs


	----------------------------------------------------------------------
	-- check if this routine was already run today - allow just one run per day 
	Declare @Tabcnt int
	Declare @LastDate char(20)
	select @Tabcnt = count(*), @LastDate = max(DateTimeEnd) from ReportComplianceComparison

	-- If there is already an entry for today, then stop and exit - just do one run a day
     	-- if its a new day then start the comparison

if @szOptionalReportParms = 'test'
select @LastDate, GetDate()

     	if DateDiff( day, @LastDate, GetDate() ) <= 0 and @Tabcnt > 0 and @szOptionalReportParms <> 'test'
     		return

if @szOptionalReportParms = 'test'
select @LastDate, GetDate()



	
	-- temporaray item: need to set this up properly in agent3 install
	-- set agent version correctly if it has not been loaded properly yet
	-- when 3.0 nap file is loaded the leafnode table is not yet updated
	update leafnode
	set agentversion = productproperties.productversion
	from productproperties, leafnode, aviview_software
	where 
	productproperties.parentid = leafnode.autoid
	and productproperties.productcode = aviview_software.productcode
	and aviview_software.productfamily = 'EPO'
	and aviview_software.productcode like 'ePOAgent%'
	and leafnode.agentversion is NULL


	-----------------------------------
	/* Stored procedure to create a table of nodeids, computers, agent versions, and summary event count data */
	/* This table persists and is recreated each time the report runs */
	-- If blank date entered then assume the cutoff should be one day back
	Declare @InfectionCutoff DateTime
	Set @InfectionCutoff = @dtInfectionCheckPoint
	if @InfectionCutoff = '' or @InfectionCutoff is NULL
		Set @InfectionCutoff = DateAdd(day,-1,GetDate());

	Execute AVISP_SetComputerSummary @InfectionCutoff, NULL, @szOptionalReportParms



--select 2, getdate()
	Declare @cnt int
	Declare @Firstrun int
	Set @Firstrun = 0
	-- Save This Computer summary table to ComputerSummaryPrevious if the table is empty (first time run)
	SELECT @cnt = count(*) from ReportComputerSummaryPrevious
	IF @cnt = 0 
	begin
		Set @FirstRun = 1
 		INSERT ReportComputerSummaryPrevious
	  		SELECT * FROM  ReportComputerSummary
--		update ReportComputerSummaryPrevious set LastAsci = ''
	end
	else	-- not first run
	begin
		-- postepo3 fix 34975: Dont run orphan fix if first run (online run)
		-- If have too many orphans it will lock system , wait for batch job to cleanup orphans
		-----------------------------------
		-- Special maintainance procedure to remove orphaned records
		Execute AVIDALSP_RemoveOrphans
	end

if @szOptionalReportParms = 'test'
begin
select * from ReportComputerSummary
select * from ReportComputerSummaryPrevious
end

--select 3, getdate()

	-- Fetch starting datetime	
	Declare @DateTimeStart DateTime
	select @DateTimeStart=max(DateTimeOfRun) from ReportComputerSummaryPrevious

if @szOptionalReportParms = 'test'
select @DateTimeStart, 'from ReportComputerSummaryPrevious'

	-------------------------------------------------------------------------------
	-- Compliance Comparison Changes
	-- 1. Compiles counts to load daily summary table
	-- 2. Writes changes out to update event table
	--	New Computers
	--	Removed Computers
	--	New Product Install
	--	Removed Product Install
	--	New Agent Version
	--	New Product Version
	--	New Engine Version
	--	New DAT Version
	--	New ExtraDAT Version
 	--	DuplicateComputer 
 	--	MultipleScanner 

	-- build temp tables (New, removed, unchanged nodes)
	select ReportComputerSummaryPrevious.NodeID 
		into dbo.tmpPreviousNodeIDs 
		from ReportComputerSummaryPrevious 

if @szOptionalReportParms = 'test'
select 'Prev Nodes', count(*), min(nodeid), max(nodeid) from dbo.tmpPreviousNodeIDs

	select distinct ReportComputerSummary.NodeID 
		into dbo.tmpNewNodeIDs
		from ReportComputerSummary
		where 	ReportComputerSummary.NodeID not in (select NodeID from ReportComputerSummaryPrevious)

if @szOptionalReportParms = 'test'
begin
select 'Prev Nodes',  count(*), min(nodeid), max(nodeid)  from dbo.tmpNewNodeIDs
select * from dbo.tmpNewNodeIDs
end
	select distinct ReportComputerSummaryPrevious.NodeID 
		into dbo.tmpOldNodeIDs
		from ReportComputerSummaryPrevious 
		where 	ReportComputerSummaryPrevious.NodeID not in (select NodeID from ReportComputerSummary)

if @szOptionalReportParms = 'test'
select 'Prev Nodes',  count(*), min(nodeid), max(nodeid)  from dbo.tmpOldNodeIDs

--select 4, getdate()

	-- new, removed computers stuff
	Declare @newcomputers int
	SELECT @newcomputers = count(*) FROM dbo.tmpNewNodeIDs

if @szOptionalReportParms = 'test'
select '@newcomputers',  @newcomputers

--	insert ReportUpdateEvents
--	select 'New Computers', ReportComputerSummary.* from  ReportComputerSummary, dbo.tmpNewNodeIDs where ReportComputerSummary.NodeID =  dbo.tmpNewNodeIDs.NodeID

--select 5, getdate()

	Declare @removedcomputers int
	SELECT @removedcomputers = count(*) FROM dbo.tmpOldNodeIDs

if @szOptionalReportParms = 'test'
select '@removedcomputers',  @removedcomputers

--	insert ReportUpdateEvents
--	select 'Removed Computers', ReportComputerSummaryPrevious.* from  ReportComputerSummaryPrevious, dbo.tmpOldNodeIDs where ReportComputerSummaryPrevious.NodeID =  dbo.tmpOldNodeIDs.NodeID

--select 6, getdate()

	Declare @unchangedcomputers int
	SELECT @unchangedcomputers = count(*) 
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID

if @szOptionalReportParms = 'test'
select '@unchangedcomputers',  @unchangedcomputers

--select 7, getdate()

	-- new, removed product installations
	Declare @newinstalls1 int
	SELECT @newinstalls1 = count(*) 
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID
		and ReportComputerSummary.ProductCode != ReportComputerSummaryPrevious.ProductCode

if @szOptionalReportParms = 'test'
select '@newinstalls1',  @newinstalls1

	Declare @newinstalls2 int
	SELECT @newinstalls2 = count(*) 
	FROM
		ReportComputerSummary
	WHERE
		ReportComputerSummary.NodeID in (select NodeID from dbo.tmpNewNodeIDs)
		and ReportComputerSummary.ProductCode > ''

if @szOptionalReportParms = 'test'
select '@newinstalls2',  @newinstalls2

	Declare @newinstalls int
	set @newinstalls = @newinstalls1 + @newinstalls2

if @szOptionalReportParms = 'test'
select '@newinstalls',  @newinstalls

--	insert ReportUpdateEvents
--	select 'New Product Install', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary, dbo.tmpNewNodeIDs
--	WHERE
--		(ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID
--		and ReportComputerSummary.ProductCode > ReportComputerSummaryPrevious.ProductCode)
		
--	insert ReportUpdateEvents
--	select 'New Product Install', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary, dbo.tmpNewNodeIDs
--	WHERE
--		(ReportComputerSummary.NodeID in (select NodeID from dbo.tmpNewNodeIDs)
--		and ReportComputerSummary.ProductCode > '')

--select 8, getdate()

	Declare @removedinstalls int
	SELECT @removedinstalls = count(*) 
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID
		and ReportComputerSummary.ProductCode < ReportComputerSummaryPrevious.ProductCode

if @szOptionalReportParms = 'test'
select '@removedinstalls',  @removedinstalls

--	insert ReportUpdateEvents
--	select 'Removed Product Install', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		(ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID
--		and ReportComputerSummary.ProductCode < ReportComputerSummaryPrevious.ProductCode)

--select 9, getdate()

	-- computers w/o scanner protection
	Declare @NoScanner int
	SELECT @NoScanner = count(*) FROM ReportComputerSummary WHERE ProductCode in ('', NULL, ' ')

if @szOptionalReportParms = 'test'
select '@NoScanner',  @NoScanner

	-- computers w extradat
	Declare @ExtraDAT int
	SELECT @ExtraDAT = count(*) FROM ReportComputerSummary WHERE ExtraDATNames not in ('', NULL, 'N/A')

if @szOptionalReportParms = 'test'
select '@ExtraDAT',  @ExtraDAT

	-- computers w NoAgents
	Declare @NoAgent int
	SELECT @NoAgent = count(*) FROM ReportComputerSummary WHERE NoAgent > 0

if @szOptionalReportParms = 'test'
select '@NoAgent',  @NoAgent

	-- computers w Unchanges Asci
	Declare @UnchangedAsci int
	Set @UnchangedAsci = 0
	if @Firstrun = 0
	SELECT @UnchangedAsci = count(*) 
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummary.NodeID = ReportComputerSummaryPrevious.NodeID
		and ReportComputerSummary.LastAsci = ReportComputerSummaryPrevious.LastAsci

if @szOptionalReportParms = 'test'
select '@UnchangedAsci',  @UnchangedAsci

	-- DuplicateComputer 
	Declare @DuplicateComputer  int
	SELECT @DuplicateComputer = count(*) FROM ReportComputerSummary WHERE DuplicateComputer > 0

if @szOptionalReportParms = 'test'
select '@DuplicateComputer',  @DuplicateComputer

	-- MultipleScanner 
	Declare @MultipleScanner  int
	SELECT @MultipleScanner = count(*) FROM ReportComputerSummary WHERE MultipleScanner > 1

if @szOptionalReportParms = 'test'
select '@MultipleScanner',  @MultipleScanner

--select 10, getdate()

	-- version changes
	Declare @newagentversion int
	SELECT
		@newagentversion = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.AgentVersion != ReportComputerSummaryPrevious.AgentVersion

if @szOptionalReportParms = 'test'
select '@newagentversion',  @newagentversion

--	insert ReportUpdateEvents
--	select 'New Agent Version', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.AgentVersion != ReportComputerSummaryPrevious.AgentVersion

--select 11, getdate()
		
	Declare @newscannerversion int
	SELECT
		@newscannerversion = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.ProductVersion != ReportComputerSummaryPrevious.ProductVersion

if @szOptionalReportParms = 'test'
select '@newscannerversion',  @newscannerversion

--	insert ReportUpdateEvents
--	select 'New Product Version', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.ProductVersion != ReportComputerSummaryPrevious.ProductVersion

--select 12, getdate()
		
	Declare @newengineversion int
	SELECT
		@newengineversion = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.EngineVer != ReportComputerSummaryPrevious.EngineVer

if @szOptionalReportParms = 'test'
select '@newengineversion',  @newengineversion

--	insert ReportUpdateEvents
--	select 'New Engine Version', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.EngineVer != ReportComputerSummaryPrevious.EngineVer


--select 13, getdate()
		
	Declare @newdatversion int
	SELECT
		@newdatversion = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.DATVer != ReportComputerSummaryPrevious.DATVer

if @szOptionalReportParms = 'test'
select '@newdatversion',  @newdatversion

--	insert ReportUpdateEvents
--	select 'New DAT Version', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.DATVer != ReportComputerSummaryPrevious.DATVer

--select 14, getdate()
		
	Declare @newextradatversion int
	SELECT
		@newextradatversion = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.ExtraDATNames != ReportComputerSummaryPrevious.ExtraDATNames

if @szOptionalReportParms = 'test'
select '@newextradatversion',  @newextradatversion

--	insert ReportUpdateEvents
--	select 'New ExtraDAT Version', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.ExtraDATNames != ReportComputerSummaryPrevious.ExtraDATNames
		
--select 141, getdate()
		
	Declare @newservicepack int
	SELECT
		@newservicepack = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.Servicepack != ReportComputerSummaryPrevious.Servicepack

if @szOptionalReportParms = 'test'
select '@newservicepack',  @newservicepack


--	insert ReportUpdateEvents
--	select 'New Servicepack', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.Servicepack != ReportComputerSummaryPrevious.Servicepack

--select 142, getdate()
		
	Declare @newhotfix int
	SELECT
		@newhotfix = count(*)
	FROM
		ReportComputerSummaryPrevious, ReportComputerSummary
	WHERE
		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
		and ReportComputerSummary.Hotfix != ReportComputerSummaryPrevious.Hotfix

if @szOptionalReportParms = 'test'
select '@newhotfix',  @newhotfix


--	insert ReportUpdateEvents
--	select 'New Hotfix', ReportComputerSummary.* 
--	FROM
--		ReportComputerSummaryPrevious, ReportComputerSummary
--	WHERE
--		ReportComputerSummaryPrevious.NodeID = ReportComputerSummary.NodeID
--		and ReportComputerSummary.Hotfix != ReportComputerSummaryPrevious.Hotfix


--select 15, getdate()


	-------------------------------------------------------------------------------------------------
	-- Load event summary stats

	Declare @VirusCount int
	Declare @UnresolvedVirusCount int
	Declare @MaxVirus varchar(50)
	Declare @MaxUnresolvedVirus varchar(50)
	Declare @MaxVirusCount int
	Declare @MaxUnresolvedVirusCount int
	Declare @MaxEventid int
	Declare @MaxEventidPrevious int
	Declare @ComputersWithVirus int

	-- set previous maxid
	SELECT
		@MaxEventidPrevious = Max(MaxEventid)
	FROM	ReportComplianceComparison
	-- If no previous entries then use current max as default - no events summary data the first time it runs
	if @MaxEventidPrevious is null or @MaxEventidPrevious = 0
	SELECT
		@MaxEventidPrevious = Max(AutoID)
	FROM	Events

	SELECT
		@MaxEventid = Max(AutoID)
	FROM	Events


if @szOptionalReportParms = 'test'
select '@MaxEventid',  @MaxEventid, @MaxEventidPrevious

	SELECT
 		@VirusCount = count(*)
		, @ComputersWithVirus = count( distinct NodeID)
	FROM	Events
	WHERE
--		EventDateTime > @dtInfectionCheckPoint
		Events.AutoID > @MaxEventidPrevious
		and VirusName > '' 
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        		AND Events.ProductName != 'ePO Agent' 

if @szOptionalReportParms = 'test'
select '@VirusCount',  @VirusCount

--select 16, getdate()

	SELECT
		@UnresolvedVirusCount = count(*)
	FROM	
		Events Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)

	WHERE
--		EventDateTime > @dtInfectionCheckPoint
		Events.AutoID > @MaxEventidPrevious
		and VirusName > '' 
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        		AND Events.ProductName != 'ePO Agent' 
		and ReportActionDesc.ResolutionID < 0
--		AND ActionTaken in 
--		('51','53','55','58','62','64','66','73','74','75','79','80','81','82','83','84','85','86','87','88','89','90','91','92','93')
		   -- unresolved action codes

if @szOptionalReportParms = 'test'
select '@UnresolvedVirusCount',  @UnresolvedVirusCount

--select 17, getdate()

	SELECT
		top 1 @MaxVirus = VirusName
 		,@MaxVirusCount = count(*)
	FROM	Events
	WHERE
--		EventDateTime > @dtInfectionCheckPoint
		Events.AutoID > @MaxEventidPrevious
		and VirusName > '' 
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        		AND Events.ProductName != 'ePO Agent' 
	GROUP BY
		VirusName
	ORDER BY Count(*) Desc

	if @MaxVirusCount is NULL
		Set @MaxVirusCount = 0
	if @MaxVirus is NULL
		Set @MaxVirus = '---'

if @szOptionalReportParms = 'test'
select '@MaxVirus',  @MaxVirus

--select 18, getdate()

	SELECT
		top 1 @MaxUnresolvedVirus = VirusName
		,@MaxUnresolvedVirusCount = count(*)
	FROM	
		Events Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	WHERE
--		EventDateTime > @dtInfectionCheckPoint
		Events.AutoID > @MaxEventidPrevious
		and VirusName > '' 
	   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        		AND Events.ProductName != 'ePO Agent' 
		and ReportActionDesc.ResolutionID < 0
--		AND ActionTaken in 
--		('51','53','55','58','62','64','66','73','74','75','79','80','81','82','83','84','85','86','87','88','89','90','91','92','93')
--		('51','53','55','58','62','64','66')   -- unresolved action codes
	GROUP BY
		VirusName
	ORDER BY Count(*) Desc

if @szOptionalReportParms = 'test'
select '@MaxUnresolvedVirus',  @MaxUnresolvedVirus

	------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	-- Fetch current compliance values (user defined compliance from compliance issues report and dat/engine order using in dat/engine reports
	-- Generate compliance problem counts (functionality of dat/engine and compliance issues reports)


	 -------------------------------------------------------------
	 -- fetch dat engine rules

	-- update top 5 dats and top 3 engines
	EXECUTE @ret= AVISP_ReportParmLoading 
	 @szOptionalReportParms  = '|REPORTDAT|RPTGRPDATENG|'


	IF EXISTS (select * from sysobjects where name = 'tmpDERules' 
   		and xtype = 'U')
 	DROP TABLE dbo.tmpDERules

	create table dbo.tmpDERules
	(
	RuleName nvarchar(50) null
	,ProductFamily nvarchar(50) null
	,DAT1 nvarchar(100) null
	,DAT2 nvarchar(100) null
	,DAT3 nvarchar(100) null
	,DAT4 nvarchar(100) null
	,DAT5 nvarchar(100) null
	,Eng1 nvarchar(100) null
	,Eng2 nvarchar(100) null
	,Eng3 nvarchar(100) null
	,DAT1DE nvarchar(100) null
	,Eng1DE nvarchar(100) null
	)


	-- fetch datengine rules
	insert dbo.tmpDERules
	exec @ret= dbo.AVISP_GetRuleDATEngine
	 @iNameSpaceName  = ''
	 ,@iNameSpaceNode = ''
	 ,@szEpoUserName  = ''
	 ,@szNameSpaceName  = ''
	 ,@szNameSpaceNode  = ''
	 ,@szOptionalReportParms  = ''

if @szOptionalReportParms = 'test'
select 'dbo.tmpDERules',  * from dbo.tmpDERules

	/*************************************************************************/
	-- Fetch compliance rules - Rule Value if given a Rule description (Most Recent, ...)

	Declare @MinAgentVersion nvarchar(50)

	select @MinAgentVersion=ParmValue from ReportInputParameters 
		where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES' 
			and ReportInputParameters.Parmname = 'ePO Agent' 

if @szOptionalReportParms = 'test'
select '@MinAgentVersion',  @MinAgentVersion


	IF EXISTS (select * from sysobjects where name = 'tmpPFVer' 
   		and xtype = 'U')
 	DROP TABLE dbo.tmpPFVer

	CREATE TABLE [dbo].[tmpPFVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	,ParmName nvarchar(100)
	) 

	-- fetch compliance rules
	Insert dbo.tmpPFVer
	Execute dbo.AVISP_GetRuleComplianceIssues
	 @iNameSpaceName  = ''	
	 , @iNameSpaceNode  = ''	
	 , @szEpoUserName  = ''	
	 , @szNameSpaceName  = ''	
	 , @szNameSpaceNode  = ''	
	 , @szOptionalReportParms  = ''	
	 , @Rulename = ''		-- will fetch a particular saved rule name TODO

if @szOptionalReportParms = 'test'
select 'dbo.tmpPFVer',  * from dbo.tmpPFVer

-- debug only
--select * from dbo.tmpDERules
--select @szReportID


	------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	-- determine compliance (assumes everything is compliant, any one of these exceptions means non compliance)
	-- non compliant if product version, dat, or engine not up to compliance rule standards

	Declare @NonComplianceDAT int
	Declare @NonComplianceEngine int
	Declare @NonComplianceProduct int
	Declare @NonComplianceComputer int
	Declare @NonComplianceAgentVersion int

	-- check for product version compliance
	update ReportComputerSummary set Compliant = 0
		from dbo.tmpPFVer
		where
			ReportComputerSummary.ProductName = dbo.tmpPFVer.ParmName
			and ReportComputerSummary.ProductFamily = dbo.tmpPFVer.ProductFamily
			and dbo.tmpPFVer.Rulename = 'ProductVersion'
			and ReportComputerSummary.ProductVersion < dbo.tmpPFVer.Version

	set    @NonComplianceProduct = @@rowcount

if @szOptionalReportParms = 'test'
select '@NonComplianceProduct',  @NonComplianceProduct

	-- check for product dat compliance
	update ReportComputerSummary set Compliant = 0
		from dbo.tmpPFVer
		where
			dbo.tmpPFVer.ParmName = ReportComputerSummary.ProductFamily + '_DATs'
			and dbo.tmpPFVer.Rulename = 'ParmValue'
			and ReportComputerSummary.DATVer < dbo.tmpPFVer.Version

	set    @NonComplianceDAT = @@rowcount

if @szOptionalReportParms = 'test'
select '@NonComplianceDAT',  @NonComplianceDAT


	-- check for product engine compliance
	update ReportComputerSummary set Compliant = 0
		from dbo.tmpPFVer
		where
			dbo.tmpPFVer.ParmName = ReportComputerSummary.ProductFamily + '_Engines'
			and dbo.tmpPFVer.Rulename = 'ParmValue'
			and ReportComputerSummary.EngineVer < dbo.tmpPFVer.Version

	set    @NonComplianceEngine = @@rowcount

if @szOptionalReportParms = 'test'
select '@NonComplianceEngine',  @NonComplianceEngine

	update ReportComputerSummary set Compliant = 0
		where NodeID in (select  NodeID  from ReportComputerSummary where AgentVersion <  @MinAgentVersion and ProductFamily = 'EPO')

	select    @NonComplianceAgentVersion =  @@rowcount

if @szOptionalReportParms = 'test'
select '@NonComplianceAgentVersion',  @NonComplianceAgentVersion

	update ReportComputerSummary set Compliant = 0
		where NodeID in (select  NodeID  from ReportComputerSummary where ProductVersion in ('(Unprotected)', '') )

	select    @NonComplianceComputer = count(*) from ReportComputerSummary where Compliant = 0
	set @ret = @NonComplianceComputer

if @szOptionalReportParms = 'test'
select '@NonComplianceComputer',  @NonComplianceComputer

	Declare @MaxDat varchar(20)
	Declare @MaxEngine varchar(20)
	select    @MaxDat = Max(DatVer) from ReportComputerSummary where DatVer <> '5000'
	select    @MaxEngine = Max(EngineVer) from ReportComputerSummary

if @szOptionalReportParms = 'test'
select '@MaxDat',  @MaxDat, @MaxEngine

	---------------------------------------------------------------------------
	-- determine top dat/engine stats 
	Declare @CountEngine3rdMostRecent int
	Declare @CountEngine2ndMostRecent int
	Declare @CountEngineMostRecent int
	Declare @CountEngineOutOfDate int
	Declare @CountDAT5thMostRecent int
	Declare @CountDAT4thMostRecent int
	Declare @CountDAT3rdMostRecent int
	Declare @CountDAT2ndMostRecent int
	Declare @CountDATMostRecent int
	Declare @CountDATOutOfDate int
	Declare @CountBothUpToDate int
	Declare @CountDATOutOfDateEngineOK int
	Declare @CountEngineOutOfDateDATOK int
	Declare @CountBothOutOfDate int


	select    @CountDATMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer >=  dbo.tmpDERules.DAT1

if @szOptionalReportParms = 'test'
select '@CountDATMostRecent',  @CountDATMostRecent

	select    @CountDAT2ndMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer >=  dbo.tmpDERules.DAT2

if @szOptionalReportParms = 'test'
select '@CountDAT2ndMostRecent',  @CountDAT2ndMostRecent

	select    @CountDAT3rdMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer >=  dbo.tmpDERules.DAT3

if @szOptionalReportParms = 'test'
select '@CountDAT3rdMostRecent',  @CountDAT3rdMostRecent

	select    @CountDAT4thMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer >=  dbo.tmpDERules.DAT4

if @szOptionalReportParms = 'test'
select '@CountDAT4thMostRecent',  @CountDAT4thMostRecent

	select    @CountDAT5thMostRecent = count(*) 
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer >=  dbo.tmpDERules.DAT5

if @szOptionalReportParms = 'test'
select '@CountDAT5thMostRecent',  @CountDAT5thMostRecent

	select    @CountDATOutOfDate = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DAT'
			and DATVer <  dbo.tmpDERules.DAT5

if @szOptionalReportParms = 'test'
select '@CountDATOutOfDate',  @CountDATOutOfDate

	select    @CountEngineMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'ENG'
			and EngineVer >=  dbo.tmpDERules.Eng1

if @szOptionalReportParms = 'test'
select '@CountEngineMostRecent',  @CountEngineMostRecent

	select    @CountEngine2ndMostRecent = count(*) 
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'ENG'
			and EngineVer >=  dbo.tmpDERules.Eng2

if @szOptionalReportParms = 'test'
select '@CountEngine2ndMostRecent',  @CountEngine2ndMostRecent

	select    @CountEngine3rdMostRecent = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'ENG'
			and EngineVer >=  dbo.tmpDERules.Eng3

if @szOptionalReportParms = 'test'
select '@CountEngine3rdMostRecent',  @CountEngine3rdMostRecent

	select    @CountEngineOutOfDate = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'ENG'
			and EngineVer <  dbo.tmpDERules.Eng3

if @szOptionalReportParms = 'test'
select '@CountEngineOutOfDate',  @CountEngineOutOfDate

	set @CountEngine3rdMostRecent = @CountEngine3rdMostRecent - @CountEngine2ndMostRecent
	set @CountEngine2ndMostRecent = @CountEngine2ndMostRecent - @CountEngineMostRecent
	set @CountDAT5thMostRecent = @CountDAT5thMostRecent - @CountDAT4thMostRecent
	set @CountDAT4thMostRecent = @CountDAT4thMostRecent - @CountDAT3rdMostRecent
	set @CountDAT3rdMostRecent = @CountDAT3rdMostRecent - @CountDAT2ndMostRecent
	set @CountDAT2ndMostRecent = @CountDAT2ndMostRecent - @CountDATMostRecent

	select    @CountBothUpToDate = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DATENG'
			and DATVer >=  dbo.tmpDERules.DAT1DE and EngineVer >=  dbo.tmpDERules.Eng1DE

if @szOptionalReportParms = 'test'
select '@CountBothUpToDate',  @CountBothUpToDate

	select    @CountDATOutOfDateEngineOK = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DATENG'
			and DATVer <  dbo.tmpDERules.DAT1DE and EngineVer >=  dbo.tmpDERules.Eng1DE

if @szOptionalReportParms = 'test'
select '@CountDATOutOfDateEngineOK',  @CountDATOutOfDateEngineOK

	select    @CountEngineOutOfDateDATOK = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DATENG'
			and DATVer >=  dbo.tmpDERules.DAT1DE and EngineVer <  dbo.tmpDERules.Eng1DE

if @szOptionalReportParms = 'test'
select '@CountEngineOutOfDateDATOK',  @CountEngineOutOfDateDATOK

	select    @CountBothOutOfDate = count(*)  
		from ReportComputerSummary, dbo.tmpDERules
		 where 	ReportComputerSummary.ProductFamily = dbo.tmpDERules.ProductFamily  and dbo.tmpDERules.RuleName = 'DATENG'
			and DATVer <  dbo.tmpDERules.DAT1DE and EngineVer <  dbo.tmpDERules.Eng1DE

if @szOptionalReportParms = 'test'
select '@CountBothOutOfDate',  @CountBothOutOfDate

	-----------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------
	-- Collect and output all the variables


     -- If there is already an entry for today, then stop and exit - just do one run a day
     -- if its a new day then record the change
     if (DateDiff( day, @LastDate, GetDate() ) > 0 or @Tabcnt = 0) or (@szOptionalReportParms = 'test')
     begin

	insert into ReportComplianceComparison 
	select
	  @newcomputers as NewComputers
	 ,@removedcomputers as  RemovedComputers
	 ,@unchangedcomputers  as UnchangedComputers
	 ,@newinstalls  as NewInstalls
	 ,@removedinstalls  as RemovedInstalls
	 ,@NoScanner  as NoScanner
	 ,@ExtraDAT  as ExtraDAT
	 ,@NoAgent  as NoAgent
	 ,@UnchangedAsci  as UnchangedAsci
	 ,@newagentversion  as NewAgentVersion
	 ,@newscannerversion  as NewScannerVersion
	 ,@newengineversion  as NewEngineVersion
	 ,@newdatversion  as NewDATVersion
	 ,@newextradatversion  as NewExtradatVersion
	 ,@VirusCount  as VirusCount
	 ,@UnresolvedVirusCount  as UnresolvedVirusCount
	 ,@MaxVirus  as MaxVirus
	 ,@MaxUnresolvedVirus  as MaxUnresolvedVirus
	 ,@MaxVirusCount  as MaxVirusCount
	 ,@MaxUnresolvedVirusCount  as MaxUnresolvedVirusCount
	 ,@MaxEventid  as MaxEventid
	 , GetDate() as DateTimeEnd
	, @DateTimeStart as DateTimeStart

	 , @NonComplianceAgentVersion  as NonComplianceAgentVersion
	,  @NonComplianceDAT as NonComplianceDAT
	,  @NonComplianceEngine as NonComplianceEngine
	,  @NonComplianceProduct as NonComplianceProduct
	,  @NonComplianceComputer as NonComplianceComputer

	, @CountDATMostRecent  as CountDATMostRecent
	, @CountDAT2ndMostRecent  as CountDAT2ndMostRecent
	, @CountDAT3rdMostRecent  as CountDAT3rdMostRecent
	, @CountDAT4thMostRecent  as CountDAT4thMostRecent
	, @CountDAT5thMostRecent  as CountDAT5thMostRecent
	, @CountDATOutOfDate as CountDATOutOfDate
	, @CountEngineMostRecent  as CountEngineMostRecent
	, @CountEngine2ndMostRecent  as CountEngine2ndMostRecent
	, @CountEngine3rdMostRecent  as CountEnginee3rdMostRecent
	, @CountEngineOutOfDate as CountEngineOutOfDate
	, @CountBothUpToDate as CountBothUpToDate
	, @CountDATOutOfDateEngineOK as CountDATOutOfDateEngineOK
	, @CountEngineOutOfDateDATOK as CountEngineOutOfDateDATOK
	, @CountBothOutOfDate as CountBothOutOfDate

	,  @MaxDat as MinVersionDAT		-- misnamed, these are actually the max versions
	,  @MaxEngine  as MinVersionEngine
	 , cast( '' as nvarchar(20)) 	  as MinVersionProductMcAfee
	 , cast( '' as nvarchar(20)) 	 	 as MinAgentVersion
	 , cast( '' as nvarchar(20)) 	  as MinVersionProductSymantec

	, cast( '' as nvarchar(20))    as MinVersionDATMostRecent
	, cast( '' as nvarchar(20))    as MinVersionDAT2ndMostRecent
	, cast( '' as nvarchar(20))    as MinVersionDAT3rdMostRecent
	, cast( '' as nvarchar(20))    as MinVersionDAT4thMostRecent
	, cast( '' as nvarchar(20))    as MinVersionDAT5thMostRecent
	, cast( '' as nvarchar(20))    as MinVersionEngineMostRecent
	, cast( '' as nvarchar(20))    as MinVersionEngine2ndMostRecent
	, cast( '' as nvarchar(20))    as MinVersionEngine3rdMostRecent

	, @ComputersWithVirus as ComputersWithVirus
 	, @DuplicateComputer as DuplicateComputer 
 	, @MultipleScanner as MultipleScanner 
 	, @newservicepack as NewServicePack 
 	, @newhotfix as NewHotfix




	----------------------------------------------------------------------------
	-- Save Thus Computer summary table to ComputerSummaryPrevious for the next comparison run.
	TRUNCATE TABLE ReportComputerSummaryPrevious

 	INSERT ReportComputerSummaryPrevious
	  SELECT * FROM  ReportComputerSummary


	---------------------------------------------------------------------------
	-- Daily update of virustype table (determines type from virusname suffix & prefix rules)
	execute dbo.AVISP_FilterVirusType
		@iNameSpaceName		= ''
		,@iNameSpaceNode		= ''
    		,@szEpoUserName          = ''
		,@szNameSpaceName	= ''
		,@szNameSpaceNode	= ''
 		,@szOptionalReportParms   = 'BatchModeUpdateTableOnly'

	---------------------------------------------------------------------------
	-- Daily update of outbreak history table 
	Declare @Outbreakcnt int
	Declare @DateRule varchar(20)
--	postepo3: comment the following out to prevent the whole event table from going through outbreak analysis
--	select @Outbreakcnt = count(*) from ReportOutbreakEvents
--	if @Outbreakcnt = 0 
--		Set @DateRule = 'all'
--	else
		Set @DateRule = 'day1'
		
	execute dbo.AVISP_FilterOutbreakEvents
		@iNameSpaceName		= ''
		, @iNameSpaceNode	= ''
	    	, @szEpoUserName        = ''
		, @szNameSpaceName	= ''
		, @szNameSpaceNode	= ''
		, @szMinMachineCount	= '5'
		, @szMinFilenameCount	= '5'
		, @dtStartDate		= ''
		, @szHourRange		= '1'
		, @szOptionalReportParms = 'BatchModeUpdateTableOnly'
		, @InfectAfterRule 	= @DateRule

     end
     -- new day data added


	---------------------------------------------------------------------------
	-- final cleanup

	drop table  dbo.tmpPreviousNodeIDs
 	drop table  dbo.tmpNewNodeIDs
 	drop table  dbo.tmpOldNodeIDs
 	drop table  dbo.tmpDERules
 	drop table  dbo.tmpPFVer
		
/*
*/


RETURN @ret
END
GO


---------------------------------------------------------------------
---------------------------------------------------------------------
--  AVISP_FilterComplianceSummary


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceSummary]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceSummary]
GO


CREATE PROCEDURE dbo.AVISP_FilterComplianceSummary
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @dtInfectionCheckPoint varchar(64) = ''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)
	Declare @ret int
	set @ret=0

 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT


     -- set default value
     if len(@dtInfectionCheckPoint) < 6
	Set @dtInfectionCheckPoint = '1/1/2000'
  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


----------------------------
-- postepo cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpCompliance' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpCompliance


	/* Stored procedure to create a table of nodeids, computers, agent versions, and summary event count data */
	/* This table persists and is recreated each time the report runs */

	-- No longer used in this routine in an effort to speed things up
--	Execute AVISP_SetComputerSummary @dtInfectionCheckPoint, NULL, NULL


	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @dtInfectionCheckPoint, '', @InfectYYYYMMDD output


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)		
   	Declare @Compliant varchar(30)	
   	Declare @Uncompliant varchar(30)	
   	Declare @Resolved varchar(30)	
   	Declare @Unresolved varchar(30)		

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Compliant = 'Compliant'	Set @Uncompliant = 'Uncompliant'
		Set @Resolved = 'Resolved'	Set @Unresolved = 'Unresolved'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Compliant = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Compliant'
		Select 	@Uncompliant = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Uncompliant'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
	End


	------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	-- Fetch current compliance values (user defined compliance from compliance issues report and dat/engine order using in dat/engine reports
	-- Generate compliance problem counts (functionality of dat/engine and compliance issues reports)


	/*************************************************************************/
	-- Fetch compliance rules - Rule Value if given a Rule description (Most Recent, ...)

	Declare @MinAgentVersion nvarchar(50)

	select @MinAgentVersion=ParmValue from ReportInputParameters 
		where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES' 
			and ReportInputParameters.Parmname = 'ePO Agent' 

	IF EXISTS (select * from sysobjects where name = 'tmpPFVer' 
   		and xtype = 'U')
 	DROP TABLE dbo.tmpPFVer

	CREATE TABLE [dbo].[tmpPFVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	,ParmName nvarchar(128)
	) 

	-- fetch compliance rules
	Insert dbo.tmpPFVer
	Execute dbo.AVISP_GetRuleComplianceIssues
	 @iNameSpaceName  = ''	
	 , @iNameSpaceNode  = ''	
	 , @szEpoUserName  = ''	
	 , @szNameSpaceName  = ''	
	 , @szNameSpaceNode  = ''	
	 , @szOptionalReportParms  = ''	
	 , @Rulename = ''		-- will fetch a particular saved rule name TODO


-- debug only
--select * from dbo.tmpPFVer
--select @MinAgentVersion

	------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	-- determine compliance (assumes everything is compliant, any one of these exceptions means non compliance)
	-- non compliant if product version, dat, or engine not up to compliance rule standards

-- Enter two entries with a nodename, productname grouping: one for a compliance count, one for a non compliance count


-- fetch all computers - assume all having products are compliant
SELECT
   BranchNode.NodeName
   , Leafnode.Nodename as LNNodename
   , case
	when aviview_software.SoftwareName > '' then  aviview_software.SoftwareName
	else	case
		when Leafnode.AgentVersion > '' then @Unprotected
		else @NoAgent
		end
	end
	as ProductCode
--   , count(*) as 'ComputerCnt'
   , 1 as 'ComputerCnt'
   , case
	when aviview_software.SoftwareName > '' then  cast(@Compliant  as varchar(100)) 
	else	cast(@Uncompliant  as varchar(100)) 
	end
	as Compliant
--   , 'NonCompliant' as Compliant
 INTO dbo.tmpCompliance
  From 
	( Leafnode join Branchnode on (leafnode.parentid = branchnode.autoid) )
	left outer join
	( ProductProperties
	  join aviview_software 
		on (
			ProductProperties.ProductCode = aviview_software.ProductCode
			and ( aviview_software.ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
			or aviview_software.ProductFamily like ('TVD_NC%') )
		)
	) on (ProductProperties.ParentID = LeafNode.AutoID)
 WHERE
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

-- test
--select * from dbo.tmpCompliance
 

Update dbo.tmpCompliance
Set Compliant = cast(@Uncompliant  as varchar(100))
From
dbo.tmpPFVer, ProductProperties, aviview_software, leafnode, branchnode
  where
	dbo.tmpCompliance.LNNodename = Leafnode.Nodename
	and leafnode.parentid = branchnode.autoid
	and ProductProperties.ParentID = LeafNode.AutoID
	and ProductProperties.ProductCode = aviview_software.ProductCode
	and ( aviview_software.ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
		or aviview_software.ProductFamily like ('TVD_NC%') )
	and 
	(
		(
			aviview_software.SoftwareName = dbo.tmpPFVer.ParmName
			and aviview_software.ProductFamily = dbo.tmpPFVer.ProductFamily
			and dbo.tmpPFVer.Rulename = 'ProductVersion'
			and ProductProperties.ProductVersion < dbo.tmpPFVer.Version
		)
		or
		(
			dbo.tmpPFVer.Parmname = aviview_software.ProductFamily + '_DATs'
			and dbo.tmpPFVer.Rulename = 'ParmValue'
			and ProductProperties.DATVer < dbo.tmpPFVer.Version
		)
		or
		(
			dbo.tmpPFVer.Parmname = aviview_software.ProductFamily + '_Engines'
			and dbo.tmpPFVer.Rulename = 'ParmValue'
			and ProductProperties.EngineVer < dbo.tmpPFVer.Version
		)
		or
		(
			LeafNode.AgentVersion < @MinAgentVersion or LeafNode.AgentVersion is NULL
		)	
		or
		(
			LeafNode.AVinstalls <= 0
		)	
	)
-- Group by
--   BranchNode.NodeName
--   , aviview_software.SoftwareName


-- test
--select * from dbo.tmpCompliance


	select    @ret = sum(ComputerCnt) from dbo.tmpCompliance where Compliant = 'NonCompliant'



/* fetch product groups */
-- returns product group summaries

SELECT
--   NodeNameBranch as NodeName
   NodeName
   , NULL as AgentVersion
   , ProductCode
   , NULL as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , count(*) as 'ComputerCnt'
--  , sum(ComputerCnt) as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
   -- postepo3 33749 Remove ... Putting a zero for virus count makes sure that this dosnt get counted
  , cast(@Unresolved as nvarchar(50)) as ActionTaken  -- empty data replaces '...'
--  , '...' as ActionTaken
  , 0 as VirusCount
  , cast(Compliant as varchar(50)) as Compliant

 FROM dbo.tmpCompliance
 Group by
   NodeName
--	, LNNodename
	, ProductCode
	, Compliant


UNION

/* now fetch event data */

SELECT
   BranchNode.NodeName as NodeName
   , NULL as AgentVersion
   -- postepo3 33749 Make event productnames match software table product names
   , ProductCode = 
		CASE 
	     		WHEN  Events.ProductName = 'Netshield 2000' THEN 'NetShield'
	     		WHEN  Events.ProductName = 'Netshield' THEN 'NetShield'
	     		WHEN  Events.ProductName = 'VirusScan Ent' THEN 'VirusScan Enterprise'
	     		WHEN  Events.ProductName = 'VirusScan Ent.' THEN 'VirusScan Enterprise'
	     		ELSE  Events.ProductName
 	    		END
   , NULL as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , 0 as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
   ,ActionTaken =
	 		CASE 
	     		WHEN  ReportActionDesc.Resolution > '' THEN ReportActionDesc.Resolution
	     		ELSE  ''
 	    		END
  , count(*) as VirusCount
   -- postepo3 33749 Remove ... Putting a zero for computer count makes sure that this dosnt get counted
  , cast(@Compliant as varchar(50)) as Compliant	-- fake data computer count=0
--  , '...' as Compliant
 
 FROM 
	Events Join LeafNode on( Events.NodeID = LeafNode.AutoID )
	Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
--  AND Events.NodeID = ReportComputerSummary.NodeID	
  AND VirusName > '' 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
	AND Events.EventDateTime > @InfectYYYYMMDD

Group by
   BranchNode.NodeName
--   NodeNameBranch
   , Events.ProductName
  , VirusName
  , ReportActionDesc.Resolution


	DROP TABLE dbo.tmpCompliance
	DROP TABLE dbo.tmpPFVer

-- return # cmptrs noncompliant
RETURN @ret
END

GO


--------------------------------------------------------
--------------------------------------------------------
--  AVISP_GetRuleComplianceIssues

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetRuleComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetRuleComplianceIssues]
GO

CREATE PROCEDURE dbo.AVISP_GetRuleComplianceIssues
(
 @iNameSpaceName  nVARCHAR(20)
 , @iNameSpaceNode  nVARCHAR(20)
 , @szEpoUserName  nVARCHAR(100)
 , @szNameSpaceName  nVARCHAR(100)
 , @szNameSpaceNode  nVARCHAR(500)
 , @szOptionalReportParms  nVARCHAR(500) = ''
 , @Rulename nvarchar(50) = ''		-- will fetch a particular saved rule name TODO
-- , @InfectionCheckPoint 		varchar(64)
-- , @AsciCheckPoint 		varchar(64)
--  , @AsciRule 			varchar(64) 
--  , @InfectAfterRule 		varchar(64)
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
	Declare @ret int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT





/*************************************************************************/
-- Fetch Rule Value if given a Rule description (Most Recent, ...)

--	Close ProdFams
--	Deallocate ProdFams


	IF EXISTS (select * from sysobjects where name = 'tmpVer' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVer

	CREATE TABLE [dbo].[tmpVer] (
	 [AutoID] [int] IDENTITY (1, 1) NOT NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	) 


	IF EXISTS (select * from sysobjects where name = 'tmpProdFamVer' 
   		and xtype = 'U')
	  	DROP TABLE dbo.tmpProdFamVer

	CREATE TABLE [dbo].[tmpProdFamVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	,ParmName nvarchar(100)
	) 

	Declare @ProdFam nvarchar(50)

	Declare ProdFams Cursor Forward_only static for
	select ProductFamily 
	from ProductProperties, AVIView_Software
	where 
	ProductProperties.ProductCode =  AVIView_Software.ProductCode
	and (ProductFamily in ('TVD', 'TVD_NC')
	or ProductFamily like 'TVD_NC%')
	Group By

	AVIView_Software.ProductFamily

	Open ProdFams

	Fetch Next from ProdFams into @ProdFam

	-- create table with all top dat/engine versions for each product family
	While @@Fetch_Status = 0
	begin
		truncate table dbo.tmpVer

		-- get top 3 dats
		insert dbo.tmpVer
		select top 3 DATVer as Version
		from ProductProperties, AVIView_Software
		where 
		ProductProperties.ProductCode =  AVIView_Software.ProductCode
		and ProductFamily = @ProdFam
		and DATVer != '5000'
		group by ProductFamily, DATVer
		order by DATVer Desc

-- remove functionality - not working and no time to fix
--		update dbo.tmpVer set Rulename = '1st Most Recent Version' where autoid = 1
--		update dbo.tmpVer set Rulename = '2nd Most Recent Version' where autoid = 2
--		update dbo.tmpVer set Rulename = '3rd Most Recent Version' where autoid = 3
 
		-- Insert version value for 1st, 2nd, 3rd most recent rulenames
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, dbo.tmpVer.autoid
			, dbo.tmpVer.Version
			, 'ParmValue'
			, @ProdFam + '_DATs'  as ParmName
			from dbo.tmpVer, ReportInputParameters
			where
				ReportInputParameters.ReportID = 'ComplianceIssues'
				and @ProdFam + '_DATs'  = ReportInputParameters.ParmName
				and ReportInputParameters.ParmValue = dbo.tmpVer.Rulename

		-- insert actual parmvalue if compliance setting is an actual dat version
		if @@rowcount = 0
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, 4
			, ParmValue
			, 'ParmValue'
			, @ProdFam + '_DATs'  as ParmName
			from ReportInputParameters 
			where
				ReportInputParameters.ReportID = 'ComplianceIssues'
				and @ProdFam + '_DATs'  = ReportInputParameters.ParmName

		-- get top engines
		truncate table dbo.tmpVer

		insert dbo.tmpVer
		select top 3 EngineVer as Version
		from ProductProperties, AVIView_Software
		where 
		ProductProperties.ProductCode =  AVIView_Software.ProductCode
		and ProductFamily = @ProdFam
		group by ProductFamily, EngineVer
		order by EngineVer Desc

--		update dbo.tmpVer set Rulename = '1st Most Recent Version' where autoid = 1
--		update dbo.tmpVer set Rulename = '2nd Most Recent Version' where autoid = 2
--		update dbo.tmpVer set Rulename = '3rd Most Recent Version' where autoid = 3

		-- Insert version value for 1st, 2nd, 3rd most recent rulenames
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, dbo.tmpVer.autoid
			, dbo.tmpVer.Version
			, 'ParmValue'
			, @ProdFam + '_Engines'  as ParmName
			from dbo.tmpVer, ReportInputParameters
			where
				ReportInputParameters.ReportID = 'ComplianceIssues'
				and @ProdFam + '_Engines'  = ReportInputParameters.ParmName
				and ReportInputParameters.ParmValue = dbo.tmpVer.Rulename

		-- insert actual parmvalue if compliance setting is an actual dat version
		if @@rowcount = 0
		insert dbo.tmpProdFamVer
		select 
			@ProdFam as ProductFamily
			, 4
			, ParmValue
			, 'ParmValue'
			, @ProdFam + '_Engines'  as ParmName
			from ReportInputParameters 
			where
				ReportInputParameters.ReportID = 'ComplianceIssues'
				and @ProdFam + '_Engines'  = ReportInputParameters.ParmName


		-- get next product family
		Fetch Next from ProdFams into @ProdFam

	end

	Close ProdFams
	Deallocate ProdFams


	---------------------------------------------------------------------------------------
	-- add product version rules

	insert dbo.tmpProdFamVer
	select
		ProductFamily
		,1
		,ReportInputParameters.ParmValue as Version
		,'ProductVersion' as Rulename
		, ReportInputParameters.ParmName as ParmName
 	FROM AVIView_Software, ReportInputParameters
	 WHERE  
	ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND  AVIView_Software.SoftwareName = ReportInputParameters.ParmName
	and ( ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
		or (ProductFamily = 'EPO' and ProductCode Like 'EPOAGENT%') 
--	and (ProductFamily in ('TVD', 'TVD_NC', 'SECURE', 'EPO')
	or ProductFamily like 'TVD_NC%')




	----------------------------------------------------
	-- dump results
	select * from dbo.tmpProdFamVer
	set @ret = @@rowcount

	-- cleanup
	Drop Table  dbo.tmpVer
	Drop Table  dbo.tmpProdFamVer


return @ret
end
GO


--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
/* compliance issues */
/* Compliance Issues Report */
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterComplianceIssues
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @InfectionCheckPoint 		varchar(64)
 , @AsciCheckPoint 		varchar(64)
  , @AsciRule 			varchar(64) 
  , @InfectAfterRule 		varchar(64)

-- , @iMinMachineCount		int =5		-- outbreak def'n
-- , @iMinFilenameCount		int =5		-- outbreak def'n
-- , @iHourRange			int =24		-- outbreak def'n
-- , @RuleCutoff		int=7

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
	Declare @ret int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

    /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	-- Fetch Infect After date variables
	Declare @ConnectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @AsciCheckPoint, @AsciRule, @ConnectYYYYMMDD output

	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @InfectionCheckPoint, @InfectAfterRule, @InfectYYYYMMDD output


	/* Stored procedure to create a table of nodeids, computers, agent versions, and summary event count data */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_SetComputerSummary @InfectYYYYMMDD, @ConnectYYYYMMDD, NULL



	-- If no data exists in ReportComplianceComparison table then run routine to fill it
	-- Do this so that there is data in the compliance subreports
	Declare @dtInfectionCheckPoint DateTime
	Set @dtInfectionCheckPoint = DateAdd( day, -1, GetDate())
	if not exists ( select * from ReportComplianceComparison )
		Execute dbo.AVISP_SetComplianceComparison
			 @iNameSpaceName  
			 , @iNameSpaceNode  
			 , @szEpoUserName  
--			 , @szNameSpaceName 
--			 , @szNameSpaceNode  
			 , @szOptionalReportParms  
			 , @dtInfectionCheckPoint 


/*************************************************************************/
-- Fetch compliance rules - Rule Value if given a Rule description (Most Recent, ...)

--	Close ProdFams
--	Deallocate ProdFams

	Declare @MinAgentVersion nvarchar(50)

	select @MinAgentVersion=ParmValue from ReportInputParameters 
		where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES' 
			and ReportInputParameters.Parmname = 'ePO Agent' 


	-- postepo3 Change table name here and in dateng report so it doesnt match the table name
	--	used within the getrule routine (make columns bigger)
	IF EXISTS (select * from sysobjects where name = 'tmpPFVer' 
   		and xtype = 'U')
 	DROP TABLE dbo.tmpPFVer

	CREATE TABLE [dbo].[tmpPFVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	,ParmName nvarchar(100)
	) 

	Insert dbo.tmpPFVer
	Execute dbo.AVISP_GetRuleComplianceIssues
	 @iNameSpaceName  = ''	
	 , @iNameSpaceNode  = ''	
	 , @szEpoUserName  = ''	
	 , @szNameSpaceName  = ''	
	 , @szNameSpaceNode  = ''	
	 , @szOptionalReportParms  = ''	
	 , @Rulename = ''		-- will fetch a particular saved rule name TODO




/**************************************************************************/
/* Implement each compliance rule with a union clause */
/* todo - localize rule name and description (get it from text strings table) */

-- Rules listed by priority - RuleCutoff value wont run any lower rules
-- Rule 1 - No Agents: fetch machines with NO Agent 
-- Rule 2 - No AV Protection: fetch machines with NO AV machines and an Agent 
-- Rule 3 - Unresolved Viruses: fetch machines with unresolved virus after InfectionCheckpoint date
-- Rule 4 - Old DAT/Engine: fetch machines with old dat/engines and recent Asci 
-- Rule 5 - Old Products: fetch machines with old Prod versions and recent Asci 
-- Rule 6 - Old Agent: fetch machines with old Agent versions and recent Asci 
-- Rule 7 - Late Asci: fetch machines with LastAsci < AsciCheckpoint date (recent Asci)



-- Rule 1 - fetch machines with NO Agent 
       SELECT
   	'No Agents' as RuleName
	, 'Machines without an ePO agent' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion 
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE  
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, NodeNameLeaf as ComputerName  -- Use leafnode nodename for noagent since they usually dont have computer props
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
--  	, '' as FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 1 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , '' as Servicepack
	, '' as Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)

  	 )
	AND ReportComputerSummary.NoAgent = 1
--	AND @RuleCutoff > 1

-- Rule 2 - fetch machines with NO AV machines and an Agent 
UNION

       SELECT
   	'No AV Protection' as RuleName
	, 'Machines without anti-virus protection' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 2 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , '' as Servicepack
	, '' as Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.NoAgent = 0
	AND ReportComputerSummary.NoAV = 1
--	AND @RuleCutoff > 2




-- Rule 4 - Old DAT/Engine: fetch machines with old dat/engines and recent Asci 
UNION

       SELECT
   	'Old DAT/Engine' as RuleName
	, 'Machines with outdated DATs or Engines' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	,  ComputerName  
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 4 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        	, Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ReportInputParameters, dbo.tmpPFVer 

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND 
	(
		(ReportInputParameters.ParmName = ReportComputerSummary.ProductFamily + '_DATs'
		and ReportInputParameters.ParmName = dbo.tmpPFVer.ParmName
		and  DATVer < dbo.tmpPFVer.Version	
		)		
		OR
		(ReportInputParameters.ParmName = ReportComputerSummary.ProductFamily + '_Engines'
		and ReportInputParameters.ParmName = dbo.tmpPFVer.ParmName
		and  EngineVer < dbo.tmpPFVer.Version
		)		
	)
--	AND @RuleCutoff > 4

-- Rule 5 - Old Products: fetch machines with old Prod versions and recent Asci 
UNION

       SELECT
   	'Old Products' as RuleName
	, 'Machines with outdated anti-virus scanning products' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 5 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ReportInputParameters

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND  ReportComputerSummary.ProductName = ReportInputParameters.ParmName
	and ReportComputerSummary.ProductVersion < ReportInputParameters.ParmValue

--	AND @RuleCutoff > 5


-- Rule 6 - Old Agent: fetch machines with old Agent versions and recent Asci 
UNION

       SELECT
   	'Old Agent' as RuleName
	, 'Machines with an outdated ePO agent' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 

     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount

	, 6 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	AND AgentVersion < @MinAgentVersion
--	AND @RuleCutoff > 6


-- Rule 7 - Late Asci: fetch machines with LastAsci < AsciCheckpoint date (recent Asci)
UNION

       SELECT
   	'Inactive Agents' as RuleName
	, 'Machines That have not checked-in since ASCI checkpoint cuttoff' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 7 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 0
--	AND @RuleCutoff > 7


-- Rule 8 - Duplicate Computers - Machines having duplicate entries in ePO (shows the outdated entry)
UNION

       SELECT
   	'Orphaned Computers' as RuleName
	, 'Machines having duplicate entries in ePO (shows the outdated entry)' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 8 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.DuplicateComputer > 0
--	AND @RuleCutoff > 7


-- Rule 9 - Duplicate Scanners - Machines having duplicate Scanning Products in ePO (shows the outdated entry)
UNION

       SELECT
   	'Orphaned Scanners' as RuleName
	, 'Machines having duplicate Scanning Products in ePO (shows the outdated entry)' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, AVIView_Software.SoftwareName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE 
     		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ProductProperties.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ProductProperties.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  AVIView_Software.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 9 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              

   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , ProductProperties.Servicepack
	, ProductProperties.Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ProductProperties, AVIView_Software

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.MultipleScanner > 1
	and ReportComputerSummary.DuplicateScannerID = ProductProperties.AutoID
	and ProductProperties.ProductCode =  AVIView_Software.ProductCode
--	AND @RuleCutoff > 7


/*
-- Rule 10 - Outbreak Infections: Machines affected by an Outbreak
UNION

       SELECT
   	'Outbreak Infections' as RuleName
	, 'Machines affected by an Outbreak' as RuleDescription
   	, ReportComputerSummary.NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ReportComputerSummary.ProductName as ProductName
   	, ProductVersion =
    		CASE ReportComputerSummary.ProductVersion
     		WHEN '' THEN '---' 
     		ELSE ReportComputerSummary.ProductVersion
     		END
   	, EngineVer =
    		CASE ReportComputerSummary.EngineVer 
     		WHEN '' THEN '---' 
     		WHEN 'N/A' THEN '---' 
     		ELSE ReportComputerSummary.EngineVer 
     		END
  	 , DATVer =
    		CASE ReportComputerSummary.DATVer 
     		WHEN '' THEN '---' 
     		WHEN 'N/A' THEN '---' 
     		ELSE ReportComputerSummary.DATVer 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
 	   	CASE 
 	    	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
  	   	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
   	  	ELSE  ReportComputerSummary.ProductFamily 
    	 	END
	, DomainName
	, ComputerName
	, IPAddress

--	   , count(*) as 'ComputerCnt'

	-- This portion is filled in by unions of event data 
  	, VirusName
  	, UserName
    	, CAST(FileName As varchar(255)) As FileName
  	, VirusType
  	, ActionTaken = ReportOutbreakEvents.ActionTaken
--	    	CASE 
-- 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
--	     	END
  	, EventDateTime  
--		= (CASE @szTime
--			WHEN 'GMT' THEN MAX(EventDateTime)
--			ELSE 		MAX(EventLocalDateTime)
--		END) 

 -- 	, count(*) as VirusCount
	, 10 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , ReportComputerSummary.Servicepack
	, ReportComputerSummary.Hotfix
	, ReportComputerSummary.ProductCode as ProductCode


 	FROM ReportComputerSummary, ReportOutbreakEvents

	 WHERE  
   	(
   	 @FilterID = 0 OR
	     ReportComputerSummary.BranchNodeID = @FilterID OR
	    ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
  	       from BranchNodeEnum 
  	       where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
  	AND ReportOutbreakEvents.NodeID = ReportComputerSummary.NodeID	
	AND VirusName > '' 
	AND ReportOutbreakEvents.EventDateTime > @InfectionCheckPoint
--	AND ActionTaken in ('51','53','55','58','62','64','66')
--	AND @RuleCutoff > 3
	Group by
--   		RuleName
--		, RuleDescription
--   		, 
		ReportComputerSummary.NodeNameBranch
		, FullNodePath
		   , AgentVersion
		   , ReportComputerSummary.ProductName
		   , ReportComputerSummary.ProductVersion
		   , EngineVer
		   , DATVer
		   , ExtraDATNames

		   , DomainName
		   , ProductFamily
		, DomainName
		, ComputerName
		, IPAddress
		, OSVersion
		, LastAsci
		  , VirusName
		  , UserName
		  , FileName
		  , VirusType
		  ,   ActionTaken
--			CASE 
--			WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--			WHEN  ReportActionDesc.ActionName = '' THEN '---'
--			ELSE  CAST(Events.ActionTaken AS varchar(16))
--		     	END
		, EventDateTime
		, LastAsci
		, ReportComputerSummary.NodeID
        , ReportComputerSummary.Servicepack
	, ReportComputerSummary.Hotfix
	, ReportComputerSummary.ProductCode 

*/

-- Rule 3 - Unresolved Viruses: fetch machines with unresolved virus after InfectionCheckpoint date
UNION

       SELECT
   	'Unresolved Viruses' as RuleName
	, 'Machines with an unresolved virus' as RuleDescription
   	, ReportComputerSummary.NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ReportComputerSummary.ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE 
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN ReportComputerSummary.EngineVer 
     		ELSE '---' 
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
 	   	CASE 
 	    	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
  	   	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
   	  	ELSE  ReportComputerSummary.ProductFamily 
    	 	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, VirusName
  	, UserName
    	, CAST(FileName As varchar(255)) As FileName
  	, VirusType
  	, ActionTaken =
	    	CASE 
 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
	     	END
  	, EventDateTime = 
		(CASE @szTime
			WHEN 'GMT' THEN MAX(EventDateTime)
			ELSE 		MAX(EventLocalDateTime)
		END) 

 -- 	, count(*) as VirusCount
	, 3 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

 	FROM 
		Events Join ReportComputerSummary on(Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
			and ReportActionDesc.LanguageID = @szFullLang)

	 WHERE  
   	(
   	 @FilterID = 0 OR
	     ReportComputerSummary.BranchNodeID = @FilterID OR
	    ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
  	       from BranchNodeEnum 
  	       where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
	AND VirusName > '' 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
        	AND Events.ProductName != 'ePO Agent' 
	AND Events.EventDateTime > @InfectYYYYMMDD
	and ReportActionDesc.ResolutionID < 0		-- unresolved viruses
--	AND ActionTaken in 
--	('51','53','55','58','62','64','66','73','74','75','79','80','81','82','83','84','85','86','87','88','89','90','91','92','93')
--	('51','53','55','58','62','64','66')
--	AND @RuleCutoff > 3



	Group by
--   		RuleName
--		, RuleDescription
--   		, 
		ReportComputerSummary.NodeNameBranch
		, FullNodePath
		   , AgentVersion
		   , ReportComputerSummary.ProductName
		   , ReportComputerSummary.ProductVersion
		   , EngineVer
		   , DATVer
		   , ExtraDATNames
		   , DomainName
		   , ProductFamily
		, DomainName
		, ComputerName
		, IPAddress
		, OSVersion
		, LastAsci
		  , VirusName
		  , UserName
		  , FileName
		  , VirusType
		  ,    CASE 
			WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
			WHEN  ReportActionDesc.ActionName = '' THEN '---'
			ELSE  CAST(Events.ActionTaken AS varchar(16))
		     	END
		, LastAsci
		, ReportComputerSummary.NodeID
        	, Servicepack
		, Hotfix
	, ReportComputerSummary.ProductCode
	, ReportComputerSummary.ScannerLanguage 
	, ReportComputerSummary.OSPlatform
	, ReportComputerSummary.OSType

	set @ret = @@rowcount

	Drop Table dbo.tmpPFVer

RETURN @ret
END
GO

------

-----------
-- split here for dbmerge files aviprocedures1 and aviprocedures 2


------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductSettingIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductSettingIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterProductSettingIssues
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @ReturnGroupSummaryOnly	int=0

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	
	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-----------------------------------------------------------------------------------------------------------
	-- Reset work table
	TRUNCATE TABLE ReportPropertySettingsWork

	INSERT 
		ReportPropertySettingsWork 
	SELECT 
		 ReportPropertySettings.product
		, ReportPropertySettings.productcode
		, ReportPropertySettings.ParmName
		, ReportInputParameters.Prompt
		, ReportInputParameters.PDesc
		, ReportInputParameters.ParmValue
		, ReportPropertySettings.sectionname
		, ReportPropertySettings.settingname
	FROM 
		ReportPropertySettings, ReportInputParameters
	WHERE 
		ReportPropertySettings.ParmName = ReportInputParameters.ParmName
		AND ReportInputParameters.ParmValue > ''


	if @ReturnGroupSummaryOnly > 0
	begin

		SELECT
			 ReportPropertySettingsWork.product
			,  cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			,  cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, count(*) as 'Count'
			, '' as  FullNodePath
			, '' as  ProductCode
		   	, '' as ProductVersion 
		   	, '' as EngineVer 
 		 	 , '' as DATVer 
 		  	, '' as ExtraDATNames 
			, '' as ProductFamily 
			,  '' as  OSVersion
			, '' as DomainName
			, '' as ComputerName
			, '' as IPAddress		
			, '' as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
		GROUP BY
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
			, ReportPropertySettingsWork.PDesc
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname	
			, ReportPropertySettingsWork.ParmValue	
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
	end
	else
	begin

		SELECT
			 ReportPropertySettingsWork.product
			, cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			, cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, 1 as 'Count'
--			, LeafNode.NodeName as NodeNameLeaf
--			, BranchNode.NodeName as NodeNameBranch
			, cast( ReportFullPathNode.FullPathName as varchar(255) ) as FullNodePath
			, AVIView_Software.SoftwareName as ProductCode
		   	, ProductVersion =
    				CASE 
		     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     				ELSE '---' 
		    		END
		   	, EngineVer =
		    		CASE 
		     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
		     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		 	 , DATVer =
 		   		CASE 
 		    		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
  		   		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		  	, ExtraDATNames =
  		  		CASE ProductProperties.ExtraDATNames 
 		    		WHEN 'N/A' THEN '' 
		     		ELSE ProductProperties.ExtraDATNames 
		     		END
			, ProductFamily = 
 			   	CASE 
 			    	WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
  			   	WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
  		 	  	ELSE  AVIView_Software.ProductFamily 
   		 	 	END
			,    cast((ComputerProperties.OSType 
			+ ' ' + ComputerProperties.OSServicePackVer 
			+ ' ' + ComputerProperties.OSPlatform) 
       			as varchar(50)) as OSVersion
			, DomainName
			, ComputerName
			, IPAddress
   			, CONVERT(datetime,
   				(SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
 				  SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
				   SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
				   SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
				   ), 120 )   as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
			, ProductProperties, AVIView_Software
			, LeafNode, ComputerProperties
			, ReportFullPathNode
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
			AND ProductSettings.ParentID = ProductProperties.AutoID
			AND ProductProperties.ProductCode = AVIView_Software.ProductCode
			AND ProductProperties.ParentID = LeafNode.AutoID
			AND LeafNode.ParentID = ReportFullPathNode.LowestNodeID
			AND LeafNode.AutoID = ComputerProperties.ParentID
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName

	end



RETURN @@rowcount
END
GO



--------------------------------------------------------------------------
-- subreport procedures




---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterVAlertsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
--, @szNameSpaceName  VARCHAR(100)
-- ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
--,@szGroup1 varchar(100) = ''
--,@szGroup2 varchar(100) = ''
--,@szGroup3 varchar(100) = ''
--,@szGroup4 varchar(100) = ''
,@NodeID int = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT






 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN ProductVersion
	   		ELSE '---'
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---'
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
  		BranchNode.NodeName AS NodeName 
 
 	FROM 
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
--		Events, 
--             LeafNode, BranchNode, ReportActionDesc 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageID = @szFullLang
   	AND LeafNode.Type !=  24      /* Uninstalled */
 
             AND 
	(	 @NodeID = ''
		OR NodeID = @NodeID
	) 

RETURN @@rowcount
END
GO





---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeErrorEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeErrorEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeErrorEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
--   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	-- for now error events only exist in events table
--	select *
--	from ReportUpdateEvents
--	where NodeID = @NodeID	


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(ProductEvents.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.ProductVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version
	   		ELSE ReportComputerSummary.EngineVer
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.DATVer
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
		,''  As ProductID
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,Type as Type
		,Version as Version
		,Sitename as Sitename
		,InitiatorID as InitiatorID
		,InitiatorType as InitiatorType
		,Error as ErrorID
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as nvarchar(128)) 
			else cast(ProductEvents.Error as nvarchar(128)) 
			end
	FROM 
		ProductEvents Join ReportComputerSummary on (ProductEvents.NodeID = ReportComputerSummary.NodeID
			and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 ) )		
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	--and events.tvdeventid = EventFilterDescFast.eventid
	--and EventFilterDescFast.language = @szLang
--  	and ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
--	and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 )


	UNION



 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(Events.ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType 
	   		ELSE '---'
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		cast( ReportComputerSummary.FullNodePath  AS varchar(256)) AS NodeName,
   		'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		cast( EventFilterDescFast.name AS varchar(128)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szFullLang) 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--  	AND Events.NodeID = ReportComputerSummary.NodeID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
--	and events.tvdeventid *= EventFilterDescFast.eventid		-- outer join, get even if no description
--	and EventFilterDescFast.language = @szLang



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(ReportComputerSummary.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.ProductVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.EngineVer
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.DATVer
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,Type as Type
		,Version as Version
		,Sitename as Sitename
		,InitiatorID as InitiatorID
		,InitiatorType as InitiatorType
		,Error as ErrorID

-- postepo3 33379 - join to ReportUpdateEventDesc and return error desc if its available 
--		,cast(Error as nvarchar(128)) as ErrorDesc
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM
		ProductEvents 
		Join ReportComputerSummary on (ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
			and ProductEvents.NodeID = @NodeID	)
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
--	FROM ProductEvents, ReportComputerSummary, ReportUpdateEventDesc
	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--  	and ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
--	and ProductEvents.NodeID = @NodeID	
--	and ProductEvents.Error = ReportUpdateEventDesc.ErrorID
--	and ReportUpdateEventDesc.LanguageID = @szFullLang


	UNION


 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
			as EventDateTime
    		,CAST(Events.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(UserName AS varchar(32)) AS UserName
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
    		,TVDEventID
    		,CAST(FileName As varchar(255)) As FileName 
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion 
    		,CAST(DATVersion as varchar(16)) As DATVersion 
    		,ScanTime
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END
    		,TVDSeverity
   		,VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END
    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
   		,'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		,cast(EventFilterDescFast.name as nvarchar(256)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szLang) 
		--	Events, ReportComputerSummary, ReportActionDesc, EventFilterDescFast 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID	-- action table lookup
--   	AND ReportActionDesc.LanguageSuffix = @szLang
--	and events.tvdeventid *= EventFilterDescFast.eventid				-- EventFilterDescFast table lookup, outer join to fetch it regardless
--	and EventFilterDescFast.language = @szLang
-- 	AND Events.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
	and Events.NodeID = @NodeID	



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceComparisonSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceComparisonSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterComplianceComparisonSubreport
--(
-- @iNameSpaceName  VARCHAR(20)
-- , @iNameSpaceNode  VARCHAR(20)
-- , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
-- , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime

--)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
/*
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  	-- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   	Declare @szLang VARCHAR(3)
   	Declare @szTime VARCHAR(10)
   	Declare @szFilter VARCHAR(50)
   	Set @szLang = '09'
   	Set @szTime = 'GMT'
	Declare @cnt int

   	if @szOptionalReportParms > ''
   		Execute AVISP_GetReportParms @szOptionalReportParms, @szLang OUTPUT, @szTime OUTPUT, @szFilter OUTPUT
*/



	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	select
	   NewComputers
	 ,   RemovedComputers
	 ,   UnchangedComputers
	 ,   NewInstalls
	 ,   RemovedInstalls
	 ,   NoScanner
	 ,   ExtraDAT
	 ,   NoAgent
	 ,   UnchangedAsci
	 ,   NewAgentVersion
	 ,   NewScannerVersion
	 ,   NewEngineVersion
	 ,   NewDATVersion
	 ,   NewExtradatVersion
	 ,   VirusCount
	 ,   UnresolvedVirusCount
	 ,   MaxVirus
	 ,   MaxUnresolvedVirus
	 ,   MaxVirusCount
	 ,   MaxUnresolvedVirusCount
	 ,   MaxEventid
	 ,  DateTimeEnd
	,   DateTimeStart

	 , NonComplianceAgentVersion 
	 , NonComplianceDAT 
	 , NonComplianceEngine 
	 , NonComplianceProduct
	 , NonComplianceComputer

	,    CountDATMostRecent
	,    CountDAT2ndMostRecent
	,    CountDAT3rdMostRecent
	,    CountDAT4thMostRecent
	,    CountDAT5thMostRecent
	,    CountDATOutOfDate
	,    CountEngineMostRecent
	,    CountEngine2ndMostRecent
	,    CountEngine3rdMostRecent
	,    CountEngineOutOfDate
	,    CountBothUpToDate 
	,    CountDATOutOfDateEngineOK 
	,    CountEngineOutOfDateDATOK 
	,    CountBothOutOfDate 

 	 , MinVersionDAT 
	 , MinVersionEngine 
	 , 	   MinVersionProductMcAfee
	 , 	 	  MinAgentVersion
	 , 	   MinVersionProductSymantec

	,     MinVersionDATMostRecent
	,     MinVersionDAT2ndMostRecent
	,     MinVersionDAT3rdMostRecent
	,     MinVersionDAT4thMostRecent
	,     MinVersionDAT5thMostRecent
	,     MinVersionEngineMostRecent
	,     MinVersionEngine2ndMostRecent
	,     MinVersionEngine3rdMostRecent
	,     ComputersWithVirus



	from
	ReportComplianceComparison

RETURN @@rowcount
END
GO



---------------------------------------------------------
----- Security Summary Report

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterSecuritySummary]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterSecuritySummary]
GO


CREATE PROCEDURE dbo.AVISP_FilterSecuritySummary
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @dtInfectionCheckPoint varchar(64) = ''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

	Declare @ret int  

     -- set default value
     if len(@dtInfectionCheckPoint) < 6
	Set @dtInfectionCheckPoint = '1/1/2000'


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpSecurity' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpSecurity


	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @dtInfectionCheckPoint, '', @InfectYYYYMMDD output

	-- Check if Firewall and Threatscan are installed
	Declare @Firewall int
	Declare @ThreatScan int
	Set @Firewall = 0
	Set @ThreatScan = 0



	-- Scan for Virus data
/*  fetch event data groupings */

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , Events.ProductName as ProductCode
   , cast(Events.ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , VirusName
  , UserName
  , NULL as FileName
  , NULL as VirusType
  , CAST(NULL AS varchar(16)) as ActionTaken
--  , ActionTaken =
--	    		CASE 
-- 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
--	     		END

    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
--  , EventDateTime = 
--		(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--		END) 
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate


 INTO dbo.tmpSecurity
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
		)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	AND Events.EventDateTime > @InfectYYYYMMDD
  		AND VirusName > '' 
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
       		AND Events.ProductName != 'ePO Agent' 

Group by

   Events.ProductName 
   , Events.ProductVersion 
   , VirusName
   , UserName





	if exists (select * from sysobjects where id = object_id(N'[dbo].[FireIDsEvents]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @Firewall = 1
		
insert 
into dbo.tmpSecurity

SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'Firewall' as ProductCode
   , ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
--  , FireIDsEvents.HostIPAddress
  , 'Firewall' as ProductType
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
--  , FireIDsEvents.AttackDescription
  , FireIDsEvents.HostName as AttackeeHostname
  , count(*) as AttackCount
  , NULL as NewComputers
  , NULL as EventDateTime
--  , EventTime as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate

 FROM FireIDsEvents
 WHERE
	EventTime > @InfectYYYYMMDD

Group by
   ProductVersion
--  , FireIDsEvents.HostIPAddress
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , FireIDsEvents.HostName 


	END



	if exists (select * from sysobjects where id = object_id(N'[dbo].[CCSAudit]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @ThreatScan = 1

insert 
into dbo.tmpSecurity
	SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'ThreatScan' as ProductCode
   , NULL as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'AutoDiscovery' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  ,count(*) as NewComputers
 , cast(max(EventDateTime) as DateTime) as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(max(EventDateTime) as DateTime) as ScanDate
  
	 FROM CCSAutoDiscovery

	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

	Declare @ScanDate DateTime
	select @ScanDate= cast(max(EventDateTime) as DateTime)
	 FROM CCSAutoDiscovery
	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

			
insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSAudit.ProductName as ProductCode
   , CCSAudit.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'Audit' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSAudit.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate

 
 FROM CCSAudit, VulnData

 WHERE
	CCSAudit.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from ccsaudit)
--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSAudit.ProductName
    , CCSAudit.ProductVersion
    , CCSAudit.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 



insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSVirusScan.ProductName as ProductCode
   , CCSVirusScan.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'VirusScan' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSVirusScan.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate
 
 FROM CCSVirusScan, VulnData

 WHERE
	CCSVirusScan.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from CCSVirusScan)

--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSVirusScan.ProductName
    , CCSVirusScan.ProductVersion
    , CCSVirusScan.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 


	END


	-- Returned combined data
	SELECT * from dbo.tmpSecurity

	set @ret = @@rowcount

	-- Cleanup
	DROP TABLE dbo.tmpSecurity


RETURN @ret
END
GO



--------------------------------------------------------------
-- actionable item routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeadAgentRemoval]
GO


CREATE PROCEDURE dbo.EPOSP_DeadAgentRemoval
(
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	SET ParentID=@DestID WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateComputerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateComputerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateComputerRemoval
(
@StrNumDays	NVARCHAR(50),	
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpDupComputers' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpDupComputers


	/* Find Duplicate Computers */

	SELECT 
		a.AutoID as AutoID
	INTO
		dbo.tmpDupComputers
	FROM
		LeafNode a, LeafNode b
	WHERE
		a.NodeName = b.NodeName
		and a.AutoID != b.AutoID
		and a.LastUpdate < b.LastUpdate
		and a.LastUpdate is not NULL
		and a.modifiedpropsdate<@TheDate


IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	
		SET ParentID=@DestID 
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END

	Drop Table dbo.tmpDupComputers

SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateScannerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateScannerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateScannerRemoval
(
@Action 	NVARCHAR(50)	-- Values: Delete, Move
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

/*
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)
*/

DECLARE @DestID INT
DECLARE @DirID INT


IF ('Delete'=@Action)
BEGIN
	-- Delete Duplicate Scanners
	delete from productproperties
	where autoid in
		(
		select min(productproperties.AutoID)
		from leafnode, productproperties,  aviview_software
		where leafnode.autoid = productproperties.parentid
		and productproperties.productcode = aviview_software.productcode
		and productfamily in ('tvd', 'tvd_nc')
		and DATVer != '5000'
		and productproperties.productcode != ''
		and aviview_software.productcode not like 'NMDASCAN%'
		and aviview_software.productcode not like 'GroupShield%'
		and aviview_software.productcode not like 'WebShield%'
		group by leafnode.nodename
		having count(*) > 1
		)

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_RemoveDeadInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_RemoveDeadInfo]
GO

CREATE PROCEDURE dbo.EPOSP_RemoveDeadInfo
(
@RuleName 	NVARCHAR(50),	-- Item to remove
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Inactive Agents'=@RuleName)
BEGIN
	EXECUTE EPOSP_DeadAgentRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Computers'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateComputerRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Scanners'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateScannerRemoval
		@Action 	
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END




SET NOCOUNT OFF
END
GO

----------------------------------------------------------------------
----------------------------------------------------------------------
-- Extended nap: Report version compare between server and client
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_CompareReportVersions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_CompareReportVersions]
GO


CREATE PROCEDURE [dbo].[AVISP_CompareReportVersions] 
(
@ProductFamily nvarchar(20)
)
AS
Begin

Declare @ret int

Truncate Table ReportVersions

Declare @cnt int, @maxfiles int
Set @cnt = 1

-- Policy, PolicySettings version
Select @maxFiles = max( convert(int, Value) ) 
	from Policy, PolicySettings, AVIView_Software
	where Policy.ProductCode = AVIView_Software.ProductCode
		and Policy.AutoID = PolicySettings.ParentID
		and ProductFamily = @ProductFamily
		and SettingName = 'NumFiles' 


if @maxFiles is null or @maxFiles < 1
	Set @maxfiles = 50 

While @cnt <= @MaxFiles
Begin

-- Policy, PolicySettings version
insert ReportVersions
select
Policy.ProductCode as ProductCode
, a.Sectionname as Path
, a.value as 'Filename'
, b.value as 'ServerVersion'
, '' as ClientVersion
, 0 as DownloadFile
from Policy, PolicySettings as a, PolicySettings as b, AVIView_Software
where 
Policy.ProductCode = AVIView_Software.ProductCode
and Policy.AutoID = a.ParentID
and Policy.AutoID = b.ParentID
and ProductFamily = @ProductFamily
and a.sectionname = b.sectionname
and a.settingname = 'Filename' + convert( char(2), @cnt) 
and b.settingname = 'Version' + convert( char(2), @cnt) 


Set @cnt = @cnt + 1

End

-- merge server and client versions

update reportversions
set Clientversion = 
(
--Selecting max here since some customer databases have had duplicate records
--in the ReportVersionsClient table and cause the select to return multiple entries 
--when only 1 was expected.
select max(clientversion) from ReportVersionsClient
where
ReportVersions.ProductCode = ReportVersionsClient.ProductCode
and ReportVersions.Path = ReportVersionsClient.Path
and ReportVersions.Filename = ReportVersionsClient.Filename
)

select 
ReportVersions.ProductCode,
Path,
Filename,
ServerVersion,
ClientVersion,
(
'insert ReportVersionsClient'
+ ' values( ''' + ReportVersions.ProductCode + ''''
+ ', ''' + Path + ''''
+ ', ''' + Filename + ''''
+ ', ''' + ServerVersion + ''')'

) as Script
from ReportVersions, AVIView_Software
where 
ReportVersions.ProductCode = AVIView_Software.ProductCode
and ProductFamily = 'EPO_REPORTS'
and path > '' and filename > ''
order by ReportVersions.ProductCode, path, filename

set @ret = @@rowcount

-- Must always truncate the client versions table after using it in this routine
Truncate Table ReportVersionsClient

return @ret
End
GO



--------------------------------------------------------------------
--------------------------------------------------------------------
-- 

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetSavedSettings]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szOptionFlag	nvarchar(64) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value prompt

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

--select @szOptionFlag as value, @szOptionFlag as prompt
 Set @ret = 0

 IF @szOptionFlag = 'FetchAllSettings'	-- fetch all setting values for a given name
 BEGIN
	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt= ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFilter
		and ReportInputParametersSaved.ReportID  = @szReportID 

--select * from ReportInputParameters where ReportInputParameters.ReportID  = @szReportID 

	-- Fetch translated text strings for localized parameter value prompt
	-- problem: need to get translation into reportinputparameter table

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


	-- fetch all parm values that get saved back to the DB and have settingname = @szFilter	
	Select  ParmValue as Value
		, Prompt as Prompt
		, ParmName as Name
		, ParmValuePrompt as ValuePrompt
	From ReportInputParameters 
	Where ReportID = @szReportID 
--		and ReportSavedSettingsName = @szFilter	
		and iSaveUserEntry = 1		

 	Set @ret = @@rowcount	
 END	
 ELSE
 BEGIN
	Declare @cnt int
	select @cnt=count(*) From ReportInputParametersSaved 
		Where ReportID = @szReportID 

	IF @@rowcount > 0
	BEGIN
		Select distinct(ReportSavedSettingsName) as Value
			, PDesc as Prompt
		From ReportInputParametersSaved 
		Where ReportID = @szReportID 
 		Set @ret = @@rowcount
	END
	ELSE
		SELECT '---' as Value , '---' as Prompt

END


 RETURN @ret 


END

GO



-----------------------------------------------------
-----------------------------------------------------
--

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutSavedSettings]
GO



CREATE PROCEDURE dbo.AVISP_FieldPutSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szFieldName		VARCHAR(64) = '',
    @szFieldValue		VARCHAR(256) = '',
    @szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''
   Declare @cnt int

   Declare @ret int
   set @ret=0

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- second column must to be called: Prompt

 IF @szFieldName = 'SaveSettingsVar' or @szFieldName = 'SaveSettingsAs'
 BEGIN 

 	Select @cnt = count(*)
	FROM	ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	-- save current settings into saved name

	IF @cnt > 0
	BEGIN	
	 	UPDATE
			ReportInputParametersSaved
		SET
			ReportInputParametersSaved.ParmValue = ReportInputParameters.ParmValue
			, ReportInputParametersSaved.ParmValuePrompt = ReportInputParameters.ParmValuePrompt
			, ReportInputParametersSaved.Prompt= ReportInputParameters.Prompt
		FROM	
			ReportInputParameters
		WHERE
			ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
			and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
			and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameterssaved.iSaveUserEntry = 1
			and ReportInputParametersSaved.ReportID  = @szReportID 
        END
	ELSE     -- do insert if not there
	BEGIN
		Update ReportInputParameters
		Set ReportInputParameters.ReportSavedSettingsName = @szFieldValue
		Where
			ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Insert  ReportInputParametersSaved
		( ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, PDesc)
		Select ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, ReportSavedSettingsName
			from ReportInputParameters
			WHERE
			ReportInputParameters.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Update ReportInputParameters
		Set ReportSavedSettingsName = ''
		Where
			ReportID  = @szReportID 
			and iSaveUserEntry = 1

		-- postepo3 change SaveSettings to SaveSettingsVar
		delete ReportInputParametersSaved
		where ParmName in ('SaveSettingsVar','SaveSettingsAs','RestoreSettings','DeleteSettings')


	END

	set @ret = @@rowcount	


 END
 ELSE IF @szFieldName = 'RestoreSettings'
 BEGIN

	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt = ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.iSaveUserEntry = 1
		and ReportInputParametersSaved.ReportID  = @szReportID 

	-- postepo3: fix save settings not saving issue
	-- Set name of open settings in open and save fields
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= @szFieldValue
	WHERE	
		ReportInputParameters.ReportID  = @szReportID 
		and ReportInputParameters.ParmName in ('RestoreSettings', 'SaveSettingsVar')

	set @ret = @@rowcount	

 END
 ELSE IF @szFieldName = 'DeleteSettings'
 BEGIN

 	DELETE
		ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	set @ret = @@rowcount	
 END


 -- Return Result String
 SELECT @szResult as szResult


 RETURN @ret

END
GO



-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-- mhilandepo3 - Customization lookup routines - one per cust screen not one per field


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Events]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Events
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			AND
				(ReportActionDesc.LanguageID = @szFullLang 
				or
				ReportActionDesc.LanguageID = @szFullLang )

   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
            and DomainName > ''
   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 

   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostIPAddress' OR @szFilter = 'HostAddr'
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND Events.NodeID = LeafNode.AutoID
	 and hostipaddress > ''
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
	 SELECT DISTINCT DATVersion as Value 
	 FROM Events
	 WHERE Events.DATVersion > ''
	 ORDER BY DATVersion desc
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
	 SELECT DISTINCT EngineVersion as Value 
	 FROM Events
	 WHERE Events.EngineVersion > ''
	 ORDER BY EngineVersion desc
   end

   else if @szFilter = 'EventID' or @szFilter = 'TVDEventID'
   begin
	 SELECT DISTINCT cast(TVDEventID as varchar(10)) as Value 
	 FROM Events
	 where tvdeventid > ''
   end

   else if @szFilter = 'TVDTaskName'
   begin
	 SELECT DISTINCT TVDTaskName as Value 
	 FROM Events
	 WHERE Events.TVDTaskName > ''
	 ORDER BY TVDTaskName desc
   end


   else if @szFilter = 'FileName'
   begin
	-- postepo3 Top 10 files report return the rightmost postion of the filename
	if @szReportID = 'T10FILE' or @szReportID = 'RESOLVED' or @szReportID = 'UNRESOLVED'
	begin
	 SELECT DISTINCT right(Events.FileName,15) as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and filename > ''
	end
	else
	begin
	 SELECT DISTINCT FileName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and filename > ''
	end
   end

   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and hostname > ''
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT ProductName as Value 
	 FROM Events
	 WHERE ProductName NOT LIKE '%Agent%'
	 and productname > ''
   end

   else if @szFilter = 'ProductVersion'
   begin
	 	SELECT DISTINCT ProductVersion as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and productversion > ''
   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (Events.ProductName + ' ' + Events.ProductVersion) > ''
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
 		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (EngineVersion + ' ' +  DATVersion) > ''
   end


   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and username > ''
   end

   else if @szFilter = 'VirusName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE Events.VirusName > ''
   end


   else if @szFilter = 'VirusSubtype'
   begin
	 SELECT DISTINCT 
		VirusType.VirusFileType as Value
	 FROM 
		VirusType
--		Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
--				and VirusType.VirusName > '')

   end

   else if @szFilter = 'VirusType'
   begin
	-- Check if VirusType table needs translating and redo it if language differs
	-- virustype table only stores one language at a time (it dynamically translates to the language you need)
	EXECUTE AVISP_TranslateVirusType @szFullLang

	 SELECT DISTINCT 
		case 
		when VirusType.VirusTypeTranslated > '' then VirusType.VirusTypeTranslated
		when Events.VirusType > '' then Events.VirusType
		else Events.VirusType
		end  as Value 
	 FROM 
		Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
				and VirusType.VirusName > '')
--	 WHERE 
--		Events.VirusName *= VirusType.VirusName
--		and VirusType.VirusName > ''
   end

   else if @szFilter = 'TVDSeverity'
   begin
	 SELECT DISTINCT EventFilterDescFast.Severity as Value 
	 FROM EventFilterDescFast
	 WHERE Language = @szFullLang
	 and name > ''
	 Order By EventFilterDescFast.Severity
   end

   else if @szFilter = 'EventDesc'
   begin
	 SELECT DISTINCT EventFilterDescFast.Name as Value 
	 FROM EventFilterDescFast
	 WHERE Language = @szFullLang
	 and name > ''
	 Order By EventFilterDescFast.Name
   end

   -- webshield entries
   else if @szFilter = 'RuleName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusName
   end

   else if @szFilter = 'RuleType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusType
   end

   else if @szFilter = 'Server'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By HostName
   end

   else if @szFilter = 'AffectedArea'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType not in ('spam', 'deny-spam')
	 Order By Filename
   end

   else if @szFilter = 'SpamSource'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @@rowcount
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Webshield]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Webshield]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Webshield
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			And TVDEventID in (1506, 4600)
			AND
				(ReportActionDesc.LanguageID = @szFullLang 
				or
				ReportActionDesc.LanguageID = @szFullLang )

   end

--   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
--   begin
--	 SELECT DISTINCT ActionTaken as Value 
--	 FROM Events
--	 WHERE TVDEventID in (1506, 4600)
--	 Order By ActionTaken
--   end


   -- webshield entries
   -- RuleName
   else if @szFilter = 'VirusName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusName
   end

   -- rule type
   else if @szFilter = 'VirusType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusType
   end

   -- server
   else if @szFilter = 'HostName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostName
   end

   -- affected area
--   else if @szFilter = 'Filename'
--   begin
--	 SELECT DISTINCT Filename as Value 
--	 FROM Events
--	 WHERE TVDEventID = 1506
--		and VirusType not in ('spam', 'deny-spam')
--	 Order By Filename
--   end

   -- SpamSource
   else if @szFilter = 'Filename'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   -- email source
   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
--		and VirusType in ('spam', 'deny-spam')
	 Order By UserName
   end

   -- IP Address
   else if @szFilter = 'IPAddress' or @szFilter = 'HostIPAddress' 
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostIPAddress
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @@rowcount
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_UpdateEvents]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_UpdateEvents]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_UpdateEvents
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From ProductEvents
--		Order by Value Desc		
	Set @ret = @@ROWCOUNT
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM ProductEvents, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ProductEvents.AgentGUID = LeafNode.AgentGUID
	 and hostname > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareName as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > ''  
   	Set @ret = @@ROWCOUNT
   end

   -- gets if from software view not productproperty table
   else if @szFilter = 'ProductVersion' 
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareVersion as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > ''  
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''	 
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		  as Value 
	       FROM AVIView_Software
	       WHERE 
		 (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and (AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Version'
   begin
	    	SELECT DISTINCT ProductEvents.Version as Value 
		       	FROM ProductEvents
			where version > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Type'
   begin
	    	SELECT DISTINCT ProductEvents.Type as Value 
		       	FROM ProductEvents
			where type > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorDesc'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Description) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorType'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Name) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Error'
   begin
	    	SELECT DISTINCT convert(varchar(50), ProductEvents.Error) as Value 
		       	FROM ProductEvents
			where ProductEvents.Error > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
	    	SELECT DISTINCT ProductEvents.Locale as Value 
		       	FROM ProductEvents
			where locale > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'SiteName'
   begin
	    	SELECT DISTINCT ProductEvents.SiteName as Value 
		       	FROM ProductEvents
			where sitename > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorID'
   begin
	    	SELECT DISTINCT ProductEvents.InitiatorID as Value 
		       	FROM ProductEvents
			where initiatorid > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorType'
   begin
	    	SELECT DISTINCT ProductEvents.InitiatorType as Value 
		       	FROM ProductEvents
			where initiatortype > ''

   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   	Set @ret = @@ROWCOUNT
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Properties]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Properties]
GO

CREATE PROCEDURE dbo.AVISP_GetCust_Properties
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT






   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   if @szFilter = 'Day' 
   begin
	-- postepo3 - for prop day cust append -000000 to the end
	SELECT DISTINCT
		substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) + '-000000'
		as Value
		From LeafNode
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end


   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
		and ProductProperties.ProductVersion != '5000'
    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
 	SELECT DISTINCT ProductProperties.DATVer as Value 
    	FROM ProductProperties, AVIView_Software
    	WHERE 
 		ProductProperties.ProductCode = AVIView_Software.ProductCode
 		and ProductProperties.DATVer > ''
 		and ProductProperties.DATVer != '5000'
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
    	SELECT DISTINCT ProductProperties.EngineVer as Value 
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
          	and ProductProperties.EngineVer > ''
          	and ProductProperties.EngineVer != '5000'
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'ComputerName' OR @szFilter = 'HostName'
   begin
	 SELECT DISTINCT ComputerProperties.ComputerName as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and computername > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
 	SELECT DISTINCT 
	   Value = 
		CASE
		   WHEN LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
		   ELSE ProductProperties.Language
		   END
	   FROM 
		ProductProperties Left Outer Join LanguageDesc on (
			RIGHT( ProductProperties.Language, 2 )  =  LanguageDesc.ClientLanguageSuffix)
--			AND LanguageDesc.epoServerLanguageSuffix = @szLang 
--			and productproperties.language > '')
   	   WHERE 
-- 		RIGHT( ProductProperties.Language, 2 )  *=  LanguageDesc.ClientLanguageSuffix
--		AND 
		LanguageDesc.epoServerLanguageID = @szFullLang 
		and productproperties.language > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'SoftwareName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT AVIView_Software.SoftwareName as Value 
	    FROM ProductProperties, AVIView_Software
	    WHERE 
		ProductProperties.ProductCode = AVIView_Software.ProductCode 
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and softwarename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductVersion'
   begin
	    SELECT DISTINCT ProductProperties.ProductVersion as Value 
		INTO #TmpProdVer	
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and productversion > ''
			and productversion != '5000'


	-- special case processing, remove virusscan wrk and svr suffix from product version)
	-- special case processing, remove virusscan wrk and svr suffix from product version)
	Insert #TmpProdVer select Value = Replace(Value, '.wrk', '') from #TmpProdVer
	Insert #TmpProdVer Select Value = Replace(Value, '.srv', '') from #TmpProdVer

	Select distinct Value from #TmpProdVer
	ORDER BY Value desc	

	Drop Table #TmpProdVer

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ServicePack'
   begin
	    SELECT DISTINCT ProductProperties.ServicePack as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and servicepack > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Hotfix'
   begin
	    SELECT DISTINCT ProductProperties.Hotfix as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and hotfix > ''

   	Set @ret = @@ROWCOUNT
   end

--   else if @szFilter = 'LicenseStatus'
--   begin
--	    SELECT DISTINCT ProductProperties.LicenseStatus as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

--   else if @szFilter = 'ExpirationDate'
--   begin
--	    SELECT DISTINCT SubString(ProductProperties.ExpirationDate,1,6) as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

   else if @szFilter = 'LastContact' or @szFilter = 'LastAsci'
   begin
	    SELECT DISTINCT SubString(LeafNode.LastUpdate,1,8) as Value 
	       FROM Leafnode
		where SubString(LeafNode.LastUpdate,1,8) > ''
		order by Value desc
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ExtraDATNames'
   begin
	    SELECT DISTINCT ProductProperties.ExtraDATNames as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		    and ProductProperties.ExtraDATNames != 'N/A'
			and extradatnames > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentType'
   begin
	IF Exists (select * from ReportTranslations where LanguageID = @szFullLang and Subject = 'AgentType')
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = @szFullLang
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End
	else
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = '0409'
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End


--	 SELECT  'Agent' as Value
--	 UNION SELECT 'Super Agent Broadcast' as Value
--	 UNION SELECT 'Super Agent Repository' as Value
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'FullProductName'
   begin

	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software, leafnode
	       WHERE 
	       (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	       ) and
		    leafnode.autoid = productproperties.parentid
		    and ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) > ''	
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DatExtraDat'
   begin
	    SELECT DISTINCT cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50))		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   end


Return @ret
END
GO



---------------------------------------------------------------------------
-- Report group procedures - allows users to select there own report groupings
--	Fetches group summaries initially, gets details within separate subreport procedure
--	3 reports:
--	InfectionsByUserGroups
--	ProductsByUserGroups
--	UpdateEventsByUserGroups



--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
------------------
-- Custom data group procedures: Product ProductEvent Infection


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductGroups]
GO






CREATE PROCEDURE dbo.AVISP_FilterProductGroups
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = ''
 , @ConnectType  varchar(20)='Current'		-- All, Current, Late
 , @ProductType  varchar(20)='AntiVirus'	-- AntiVirus, Security, Agent, All
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYY_MM_DD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')
	set @YYYY_MM_DD = convert(char(30), @YYYYMMDDdate,120)

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
--		Select 	@Agent = TranslatedValue from ReportTranslations 
--			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'Agent'
		Set @Agent = 'Agent'		-- last minute localization bug, too late to retranslate
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	
	

   

   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
	and lower(@szGroupName1) <> 'connectstatus' 
	and lower(@szGroupName2) <> 'connectstatus' 
	and lower(@szGroupName3) <> 'connectstatus' 
	and lower(@szGroupName4) <> 'connectstatus' 
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month' -- yyyy-mm
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
   			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,cast(@ConnectType as varchar(30)) as ConnectStatus

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields


--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--    		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM 	
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
	   	 )
	)
	left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID))
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	    	)   
	)
	left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	)
	on( leafnode.autoid = productproperties.parentid )

-- this join doesnt catch unprotected and noagents	
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--  	left outer Join ProductProperties on(leafnode.autoid = productproperties.parentid)
--   	Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode)
--	left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
--			and LanguageDesc.epoServerLanguageID = @szFullLang)	

 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
   	AND LeafNode.Type !=24      /* Uninstalled */ 
--	and  LeafNode.LastUpdate > @YYYYMMDD


	Group By
		BranchNode.NodeName
		,DATVer
		, substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName



 
   end

   -- This is used when you are doing a fast with grouping on connectstatus (late or current)
   else
   if lower(@szDrilldown) = 'fast' 
	and ( lower(@szGroupName1) = 'connectstatus' 
		or lower(@szGroupName2) = 'connectstatus' 
		or lower(@szGroupName3) = 'connectstatus' 
		or lower(@szGroupName4) = 'connectstatus' )
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		,cast('' as varchar(16)) as 'Day'
--		, '' as 'Hour'


   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Current
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields

--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType

 	FROM 		
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		and  LeafNode.LastUpdate  >=  @YYYYMMDD  
	   	AND LeafNode.Type !=24      /* Uninstalled */ 
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )
		) -- fetch only current computers
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	    )   
	)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid 	)
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

--	and  LeafNode.LastUpdate > ''


	Group By
		BranchNode.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName

   Union All

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		,cast('' as varchar(16)) as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
   			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Late
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields

--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM 		
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		AND LeafNode.Type !=24      /* Uninstalled */ 
		and  (LeafNode.LastUpdate  <  @YYYYMMDD  -- fetch only late computers
			or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null )  -- fecthes no agents
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )   
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

	Group By
		BranchNode.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName
 

   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin

 	SELECT   

		'' as 'Year'
		,'' as 'Month'	-- yrmo
		,'' as 'Week'
		,'' as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,''  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, ProductProperties.Language as Language
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		, case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			when LeafNode.LastUpdate  >=  @YYYYMMDD then @Current
			when LeafNode.LastUpdate  <  @YYYYMMDD  and LeafNode.LastUpdate  > '1/1/1980'  then @Late
			else @NoAgent
			end 	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

--		postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	   	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as HostName
--		, ComputerProperties.Computername as HostName

		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
--		, cast( '' as varchar(10)) as FullNodeName
   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, Productproperties.ProductCode as  ProductCode
		, LeafNode.autoid as NodeID
--		, NodeID
--		, LeafNode.autoid as LNAutoID
--		, LeafNode.parentid as LNParentID
--		, ProductProperties.autoid as PPAutoID

		-- End of Group summary difference fields


--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
	   	AND LeafNode.Type !=24      /* Uninstalled */ 
		and ( @YYYYMMDD is null  or @ConnectType = 'All' 
		or
		( 
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '' )
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '' )
		)	
	       )
	
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )   
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )

 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--             AND ProductProperties.ParentID = LeafNode.AutoID 
--   	and ProductProperties.ProductCode = AVIView_Software.ProductCode
--   	AND LeafNode.ParentID = BranchNode.AutoID
--	AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   	AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   	AND LanguageDesc.epoServerLanguageSuffix = @szLang




   end
	
RETURN @@rowcount
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductEventGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductEventGroups]
GO


CREATE PROCEDURE dbo.AVISP_FilterProductEventGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @AfterYYYYMMDD varchar(30) = ''
 , @AfterRule varchar(30) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 Declare @ret int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 -- determine what node tree filter this user has: either tied to their account or by the user setting a report filter
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node
-- Truncate Table ReportLostProductEventLinks
-- Insert ReportLostProductEventLinks (NodeID)
-- select distinct NodeID
-- from ProductEvents
--	where NodeID not in (select AutoID from leafnode)
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

   -- Fetch Infect After date variables
   Declare @YYYYMMDD datetime
   execute dbo.AVISP_GetDateConversion @AfterYYYYMMDD, @AfterRule, @YYYYMMDD output

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)	

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	

	


   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
   begin

 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
--      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
--			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
--			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, '' as NodeID
--		, NodeID
		,'' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)
--   		ProductEvents, AVIView_Software
--		,LeafNode, BranchNode, ComputerProperties 	--ProductProperties, LanguageDesc, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')	-- remove this, want to see all eents from all products 
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--   	AND LeafNode.Type !=24      -- remove this, want to see all events 
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)

	Group By
		-- postepo3 - optimize group by ordering
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		, substring(Leafnode.LastUpdate, 1, 4) 
--		, substring(Leafnode.LastUpdate, 5, 2) 
		, AVIView_Software.SoftwareVersion
   		, AVIView_Software.SoftwareName
--   		, AVIView_Software.SoftwareVersion 
  		,BranchNode.NodeName 
  		,ComputerProperties.DomainName
--		, ProductProperties.EngineVer
--		, ProductProperties.DATVer
 		, cast( ProductEvents.AgentVersion as nvarchar(50)) 
 		, cast( ProductName as nvarchar(50))
  		, cast( ProductEvents.ProductCode as nvarchar(50)) 
 		, cast( ProductEvents.Type as nvarchar(50)) 
 		, cast( Version as nvarchar(50)) 
 		, ProductEvents.Error
 		, cast( Locale as nvarchar(50)) 
 		, cast( SiteName as nvarchar(100)) 
 		, cast( InitiatorID as nvarchar(50)) 
 		, cast( InitiatorType as nvarchar(50)) 
		, ReportUpdateEventDesc.Description
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform




   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin


 	SELECT   


		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
--      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
--			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
--			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

    		,(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

		, case
			when ComputerProperties.Computername > '' then ComputerProperties.Computername
			when LeafNode.NodeName > '' then LeafNode.NodeName
			else @Unlinked
			end as HostName
		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
   		, cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, LeafNode.autoid as NodeID
--		, NodeID
		,LeafNode.autoid as LNAutoID
		,LeafNode.parentid as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)

--   		ProductEvents, AVIView_Software
--             		,LeafNode, BranchNode, ComputerProperties, ReportFullPathNode  -- LanguageDesc, ProductProperties, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  -- want to see all events
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--	AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   	AND LeafNode.Type !=24      -- want to see all events
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)




   end
	set @ret = @@rowcount
--	Drop Table #LostLinks	
RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroups]
GO



CREATE PROCEDURE dbo.AVISP_FilterVAlertGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)=''	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @ret int

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

--------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpTop10s' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10s

	IF EXISTS (select * from sysobjects where name = 'tmpTop10Virus' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10Virus


	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')

	if @InfectAfterRule = 'all' and ( @InfectAfterYYYYMMDD = '' or @InfectAfterYYYYMMDD is null )
	begin
		set @YYYYMMDDdate = null
		set @YYYYMMDD = ''
	end

--select @YYYYMMDDdate
	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- Check if VirusType table needs translating and redo it if language differs
	EXECUTE AVISP_TranslateVirusType @szFullLang


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)		
   	Declare @Uncategorized varchar(50)		
	Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)


	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Uncategorized = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'VirusType' and TextID = 'Uncategorized'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	

	


--------------------------------------------------------
--------------------------------------------------------
  -- lookup top 10 items if applicable
  -- look for top 10 (T10) suffix in eventtype
  -- Only do this if no data filter has been set

	Declare @Top10 varchar(20)
	Set @Top10 = ''
	Create table dbo.tmpTop10s 
	(
		Value varchar(255)
	)
	Create table dbo.tmpTop10Virus 
	(
		Virusname varchar(255)
		,Virustype varchar(255)
	)

	if substring(@EventType, 1, 5) = 'T10Vr'  
	begin
		Set @Top10 = 'T10Vr'
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	
		if @DataFilter = 'none'		-- Do only if no data filter
		begin
	
		Update VirusType Set Top10 = 0

		Insert dbo.tmpTop10Virus
		Select Top 10 VirusName, max(Virustype) as Virustype
		  From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
--			LeafNode Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--				and ReportActionDesc.LanguageID = @szFullLang)
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
				) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
				AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by VirusName
		order by count(*) desc		
		

		-- insert any missing virus
		insert virustype
 		( VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID, Top10 )
		Select
			dbo.tmpTop10Virus.VirusName, '', '', dbo.tmpTop10Virus.VirusType, dbo.tmpTop10Virus.VirusType, '0409', 1
		From 
			dbo.tmpTop10Virus
		Where
			 dbo.tmpTop10Virus.VirusName not in (select virusname from virustype )


		-- mark the top 10 viruses
		Update VirusType
		Set Top10 = 1
		Where VirusName in ( select virusname from dbo.tmpTop10Virus )
	
		end
	end
	else if substring(@EventType, 1, 5) = 'T10Fl'  
	begin
		Set @Top10 = 'T10Fl'
		Set @EventType = Replace( @EventType, 'T10Fl', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 right(FileName, 15)
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by right(FileName,15)
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Ur'  
	begin
		Set @Top10 = 'T10Ur'
		Set @EventType = Replace( @EventType, 'T10Ur', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 UserName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by UserName
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Cp'  
	begin
		Set @Top10 = 'T10Cp'
		Set @EventType = Replace( @EventType, 'T10Cp', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 HostName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang			)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by HostName
		order by count(*) desc		

		end
	end

-- test
--select * from ReportTop10Items

--------------------------------------------------------------------------------------------------
-- Read Data Filter and Group Selections to see which query option to pick for fastest performance
--	must group on fields that are part of the Group selections or Data filter 

	-- merge group fields into one to simplify processing
	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	-- Check for key fields that affect which query to run
	Declare @Nodename int
	Set @Nodename = CHARINDEX( 'NodeName', @GroupFields)	
	if @Nodename = 0 	Set @Nodename = CHARINDEX( 'NodeName', @DataFilter)	

	Declare @Domainname int
	Set @Domainname = CHARINDEX( 'Domainname', @GroupFields)	
	if @Domainname = 0 	Set @Domainname = CHARINDEX( 'Domainname', @DataFilter)	

	Declare @OSType int
	Set @OSType = CHARINDEX( 'OSType', @GroupFields)	
	if @OSType = 0 	Set @OSType = CHARINDEX( 'OSType', @DataFilter)	

	Declare @OSPlatform int
	Set @OSPlatform = CHARINDEX( 'OSPlatform', @GroupFields)	
	if @OSPlatform = 0 	Set @OSPlatform = CHARINDEX( 'OSPlatform', @DataFilter)	

	Declare @Virustype int
	Set @Virustype = CHARINDEX( 'Virustype', @GroupFields)	
	if @Virustype = 0 	Set @Virustype = CHARINDEX( 'Virustype', @DataFilter)	

	Declare @VirusSubtype int
	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @GroupFields)	
	if @VirusSubtype = 0 	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @DataFilter)	
        if @VirusSubtype > 0    Set @Virustype=1

	Declare @ActionTaken int
	Set @ActionTaken = CHARINDEX( 'Action', @GroupFields)	
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'ActionTaken', @DataFilter)	
	-- special case code: infection history reports do a chart on action, so make sure a query returning action
	--	is performed
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSVIRUSDETAIL', @szOptionalReportParms)
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSINFECTHIST', @szOptionalReportParms)


	Declare @TVDEventID int
	Set @TVDEventID = CHARINDEX( 'TVDEventID', @GroupFields)	
	if @TVDEventID = 0 	Set @TVDEventID = CHARINDEX( 'TVDEventID', @DataFilter)	

	Declare @TVDSeverity int
	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @GroupFields)	
	if @TVDSeverity = 0 	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @DataFilter)	

	Declare @EventDesc int
	Set @EventDesc = CHARINDEX( 'EventDesc', @GroupFields)	
	if @EventDesc = 0 	Set @EventDesc = CHARINDEX( 'EventDesc', @DataFilter)	

	Declare @Year int
	Set @Year = CHARINDEX( 'Year', @GroupFields)	
	if @Year = 0 	Set @Year = CHARINDEX( 'Year', @DataFilter)	

	Declare @Quarter int
	Set @Quarter = CHARINDEX( 'Quarter', @GroupFields)	
	if @Quarter = 0 	Set @Quarter = CHARINDEX( 'Quarter', @DataFilter)	

	Declare @Week int
	Set @Week = CHARINDEX( 'Week', @GroupFields)	
	if @Week = 0 	Set @Week = CHARINDEX( 'Week', @DataFilter)	

	Declare @Month int
	Set @Month = CHARINDEX( 'Month', @GroupFields)	
	if @Month = 0 	Set @Month = CHARINDEX( 'Month', @DataFilter)	

	Declare @DATVer int
	Set @DATVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @DATVer = 0 	Set @DATVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @ENGVer int
	Set @ENGVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @ENGVer = 0 	Set @ENGVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @TaskName int
	Set @TaskName = CHARINDEX( 'TVDTaskName', @GroupFields)	
	if @TaskName = 0 	Set @TaskName = CHARINDEX( 'TVDTaskName', @DataFilter)	

	-- sum these fields into categories
	Declare @Time int
	Set @Time = @Year + @Month + @Quarter + @Week

	Declare @EventInfo int
	Set @EventInfo = @EventDesc + @TVDEventID + @TVDSeverity

	Declare @VirustypeAction int
	Set @VirustypeAction = @Virustype + @ActionTaken + @VirusSubtype

	Declare @LeafInfo int
	Set @LeafInfo = @Nodename + @Domainname + @OSType + @OSPlatform + @TaskName + @DATVer + @ENGVer

-- test
--select @szDrilldown1 as Drilldown, @EventType as Eventtype
--	, @DataFilter as Datafilter, @GroupFields as Groupfields
--	, @Time as 'Timegroups', @EventInfo as Eventinfo, @VirustypeAction as VTaction, @Leafinfo as Leafinfo
--	, @Top10 as Top10



-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-- The actual query to run is selected based off the data filter, grouping fields, layout option and
--	Event type of this report. Trying to do the minimum work possible to improve performance.

   -------------------------------------------------------------------------------
   -- 1. Fast group summary fetch (subreport fetches detailed rows)
   -- No grouping on time fields (good performance boost)
   -- No joins, no grouping on time fields 
   -- Doesnt join: virustype, action, leafnode, EventFilterDescFast

   if lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' )
	and @DataFilter <> 'Inactive'
	and ( @Time = 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
   begin


 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' ExtraDATNames
		,'' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, '' as LastContact

		, '' as HostName
		, '' as UserName
--		,  Events.UserName
		, '' HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '1' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' 
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 1.5 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on 
   -- Joins action tables
   -- Doesnt join virustype or leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken > 0 and @Virustype = 0 
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '2' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 2. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields
   -- No joins
   -- Doesnt join: virustype, action, leafnode, EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' )
	-- postepo3 - these must be executed when data filter not set
	and @DataFilter <> 'Inactive'
	and ( @Time > 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
--		'' as Year
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,'' as Week
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		,'' as Quarter
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' as EngineVersion
    		,'' As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
--		, cast( '2' as varchar(10)) as Language
		,'' as ExtraDATNames
		,'2' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, cast('' as varchar(50)) as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '3' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
--		, TVDTaskName
--		,EngineVersion
		,ProductName
		,ProductVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields, actions
   -- Joins action tables
   -- Doesnt join virustype or leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 
		and @Virustype= 0 and @ActionTaken > 0 and @Virustype = 0 
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '4' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields, virustype, actions
   -- Joins virustype and action tables
   -- Doesnt join leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 and @Virustype > 0 and @ActionTaken >= 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
 --   		,CAST(DATVersion as varchar(16)) As DATVersion
    		,CAST('' as varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, CAST('' as varchar(50)) as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, ''  as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)

 	 	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--  	           AND Events.ProductName != 'ePO Agent' 

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3.6. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, coverage tables
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken = 0 and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.6' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5.3' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then @Informational
--			when 1 then @Warning
--			when 2 then @Minor
--			when 3 then @Major
--			when 4 then @Critical
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
--	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
--	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		
--		,ReportActionDesc.ActionName
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end

   -------------------------------------------------------------------------------
   -- 3.7. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, actions, coverage tables
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.7' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end


   -------------------------------------------------------------------------------
   -- 4. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, virustype, actions, coverage tables
   -- Joins virustype, action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo > 0 and @EventInfo = 0 )
-- postepo3 - if fast and data filter, then use this unless grouping by eventdesc
		or ( @DataFilter <> 'none' and @EventInfo = 0 ) -- if data filter do this
	)
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '6' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end


   -------------------------------------------------------------------------------
   -- 4.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	( 
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo > 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		,'' as NodeName
		,'' as Domainname
		,'' as OSType
		,'' as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '6.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		149968 epo3.5 - if event not found in eventfilterdescfast then convert event.tvdseverity code to its text desc
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 

	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
--	Left Outer Join (
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,BranchNode.NodeName
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity



   end

   -------------------------------------------------------------------------------
   -- 5. Fast group catchall (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	(
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo >= 0 and @EventInfo >= 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '5f' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '7' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		149968 epo3.5 - if event not found in eventfilterdescfast then convert event.tvdseverity code to its text desc
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				-- epo3.5: if ebentid not found use event.serverity code and translate it
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end			
			end  as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 

	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
	Left Outer Join (
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity



   end

   -- LAYOUT=DRILLDOWNSECTION
   --------------------------------------------------
   -- 6.0.0. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		( @Time = 0 and @VirusType = 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
--		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( '8fs' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,VirusType as VirusType
		, '' as VirusSubtype
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
--		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
--    		,  case 
--			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,TVDEventID as EventDesc
		
--		, '' as RuleName

		-- Product update fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   --------------------------------------------------
   -- 6. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable'
   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( '8' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--		,'' as VirusType
--		, '' as VirusSubtype
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			149968 epo3.5 - if event not found in eventfilterdescfast then convert event.tvdseverity code to its text desc
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,TVDEventID as EventDesc
		
--		, '' as RuleName

		-- Product update fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   -- top10section 
   ------------------------------------------------------------------------
   -- 7. Fast (group summary) Fetch, top 10 virus
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '9' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join VirusType on (Events.VirusName = VirusType.VirusName )
	--			and Top10 =1 
	--		)  -- dont do top 10 join
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
		Events.VirusName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- postepo3
   -- 7.5 Fast (group summary) Fetch, top 10 virus with no data filter
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7.5tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
--			= CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '9.1' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join VirusType on (Events.VirusName = VirusType.VirusName 
				and Top10 =1 
			)  -- do top 10 join
--	Join dbo.tmpTop10Virus on (Events.VirusName = dbo.tmpTop10Virus.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- 8. Fast (group summary) Fetch, top 10 files, with data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @DataFilter <> 'none' and 
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( '10' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
--	dont do top 10 join cause a data filter exists and it must be run first
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.Filename
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 8.5 Fast (group summary) Fetch, top 10 files, with no data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename

   else if lower(@szDrilldown1) = 'fast' and @DataFilter = 'none' and
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8.5tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( '10.1' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.Filename
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9. Fast (group summary) Fetch, top 10  Users, with data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first


   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '11' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	data filter exists, dont joinwith top 10 table because filter must be run first on client
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9.5 Fast (group summary) Fetch, top 10  Users, with no data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9.5tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '11.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10. Fast (group summary) Fetch, top 10 Computers, with data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'Atm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '12' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	data filter exists so dont join to top 10 table
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10.5 Fast (group summary) Fetch, top 10 Computers, with no data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'A.5tm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		,'' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '12.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end



	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		
	Drop Table dbo.tmpTop10s
	Drop Table dbo.tmpTop10Virus


RETURN @ret
END
GO



--------------------------------------------------
--------------------------------------------------
-- AVISP_GetReportGroups - Fetches groups for Custom Group FAST Drilldown Subreports 


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetReportGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetReportGroups]
GO


CREATE PROCEDURE dbo.AVISP_GetReportGroups
(
	@szOptionalReportParms varchar(500)
	,@szGroup1 VARCHAR(100) 
	, @szGroup2 VARCHAR(100) 
	, @szGroup3 VARCHAR(100) 
	, @szGroup4  VARCHAR(100) 
	, @szGroupValue1 VARCHAR(100) 
	, @szGroupValue2 VARCHAR(100) 
	, @szGroupValue3 VARCHAR(100) 
	, @szGroupValue4  VARCHAR(100) 
	,@szGroupYear   VARCHAR(100)  OUTPUT
	,@szGroupMonth     VARCHAR(100)  OUTPUT 
	,@szGroupQuarter     VARCHAR(100)  OUTPUT 
	,@szGroupWeek     VARCHAR(100)  OUTPUT 
	,@szGroupVirusName     VARCHAR(100)  OUTPUT
	,@szGroupActionTaken     VARCHAR(100)  OUTPUT
	,@szGroupNodeName     VARCHAR(100)  OUTPUT
	,@szGroupProductName     VARCHAR(100)  OUTPUT
	,@szGroupProductVersion     VARCHAR(100)  OUTPUT
	,@szGroupEngineVersion     VARCHAR(100)  OUTPUT
	,@szGroupDATVersion     VARCHAR(100)  OUTPUT
	,@szGroupFileName     VARCHAR(100)  OUTPUT
	,@szGroupHostName     VARCHAR(100)  OUTPUT
	,@szGroupUserName     VARCHAR(100)  OUTPUT
	,@szGroupExtraDATNames     VARCHAR(100)  OUTPUT		-- coverage data 
	,@szGroupDomainName     VARCHAR(100)  OUTPUT		-- coverage data 
	,@szGroupOSVersion     VARCHAR(100)  OUTPUT
	,@szGroupServicepack     VARCHAR(100)  OUTPUT
	,@szGroupHotfix     VARCHAR(100)  OUTPUT
	,@szGroupLicenseStatus     VARCHAR(100)  OUTPUT
	,@szGroupExpirationDate     VARCHAR(100)  OUTPUT
	,@szGroupAgentVersion     VARCHAR(100)  OUTPUT		-- update event data
	,@szGroupType     VARCHAR(100)  OUTPUT
	,@szGroupVersion     VARCHAR(100)  OUTPUT
	,@szGroupError     VARCHAR(100)  OUTPUT
	,@szGroupLanguage     VARCHAR(100)  OUTPUT
	,@szGroupSiteName     VARCHAR(100)  OUTPUT
	,@szGroupInitiatorID     VARCHAR(100)  OUTPUT
	,@szGroupInitiatorType     VARCHAR(100)  OUTPUT
	,@szGroupDay     VARCHAR(100)  OUTPUT
	,@szGroupHour     VARCHAR(100)  OUTPUT
	,@szAgentVersion varchar(50) output
	,@szLicensed varchar(50) output
	,@szConnectStatus varchar(50) output
	,@szAgentType varchar(50) output
	,@szOSType varchar(50) output
	,@szOSPlatform varchar(50) output
	,@szVirusType varchar(50) output
	,@szFullProductName varchar(50) output
	,@szEngineDat varchar(50) output
	,@szDatExtraDat varchar(50) output
    	,@szTVDSeverity varchar(50) output
    	,@szTVDTaskName varchar(50) output
	,@szEventDesc varchar(255) output
	,@szVirusSubType varchar(50) output
)
AS
BEGIN

Declare @GroupName varchar(100)
Declare @GroupValue varchar(100)
Declare @loop numeric
Declare @pstart int
Declare @pstart1 int
Declare @pstart2 int
Declare @pend int
Declare @ret int

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT
	


   Set @szGroupYear  = ''
   Set @szGroupMonth  = ''
   Set @szGroupQuarter  = ''
   Set @szGroupWeek  = ''
   Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''
   Set @szGroupProductName  = ''
   Set @szGroupProductVersion  = ''
   Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''
   Set @szGroupFileName  = ''
   Set @szGroupHostName  = ''
   Set @szGroupUserName = ''
	Set @szGroupExtraDATNames  = ''
	Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''
	Set @szGroupServicepack  = ''
	Set @szGroupHotfix   = ''
	Set @szGroupLicenseStatus   = ''
	Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''
	Set @szGroupType    = ''
	Set @szGroupVersion    = ''
	Set @szGroupError    = ''
	Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''
	Set @szGroupInitiatorID   = ''
	Set @szGroupInitiatorType    = ''
	Set @szGroupDay    = ''
	Set @szGroupHour    = ''
	Set @szAgentVersion   = ''
	Set @szLicensed   = ''
	Set @szConnectStatus   = ''
	Set @szAgentType   = ''
	Set @szOSType   = ''
	Set @szOSPlatform   = ''
	Set @szVirusType   = ''
	Set @szFullProductName   = ''
	Set @szEngineDat   = ''
	Set @szDatExtraDat   = ''
    	Set @szTVDSeverity   = ''
    	Set @szTVDTaskName   = ''
	Set @szEventDesc   = ''
	Set @szVirusSubType = ''

Set @GroupName= @szGroup1
Set @GroupValue = @szGroupValue1
Set @loop = 1


While @loop < 5
Begin
	/* search one of four group variables */
	if @loop = 1
	Begin
		Set @GroupName= @szGroup1
		Set @GroupValue = @szGroupValue1		
	End
	Else if @loop = 2
	Begin
		Set @GroupName= @szGroup2
		Set @GroupValue = @szGroupValue2
	End
	Else if @loop = 3
	Begin
		Set @GroupName= @szGroup3
		Set @GroupValue = @szGroupValue3
	End
	Else if @loop = 4
	Begin
		Set @GroupName= @szGroup4
		Set @GroupValue = @szGroupValue4
	End
	
	/* Find out which type of group it is */
	if lower(@GroupName) = 'year' and @GroupValue > ''
	Begin
		set @szGroupYear = @GroupValue
	End
	else if lower(@GroupName) = 'month' and @GroupValue > ''
	Begin
		set @szGroupMonth = @GroupValue
	End
	else if lower(@GroupName) = 'quarter' and @GroupValue > ''
	Begin
		set @szGroupQuarter = @GroupValue
	End
	else if lower(@GroupName) = 'week' and @GroupValue > ''
	Begin
		set @szGroupWeek = @GroupValue
	End
	else if lower(@GroupName) = 'day' and @GroupValue > ''
	Begin
		set @szGroupDay = @GroupValue
	End
	else if lower(@GroupName) = 'hour' and @GroupValue > ''
	Begin
		set @szGroupHour = @GroupValue
	End
	else if lower(@GroupName) = 'virusname' and @GroupValue > ''
	Begin
		set @szGroupVirusName = @GroupValue
	End
	else if (lower(@GroupName) = 'actiontaken' or lower(@GroupName) = 'action' ) and @GroupValue > ''
	Begin
		Set @szGroupActionTaken = @GroupValue
	End
	else if lower(@GroupName) = 'nodename' and @GroupValue > ''
	Begin
		set @szGroupNodeName = @GroupValue
	End
	else if lower(@GroupName) = 'groupname' and @GroupValue > ''
	Begin
		set @szGroupNodeName = @GroupValue
	End
	else if lower(@GroupName) = 'productnameversion' and @GroupValue > ''
	Begin
	
		/* Separate product name from product version: pn- pv */
		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
		if @pstart is null or @pstart = 0
			set @pstart=1	
		Set @szGroupProductName = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
		Set @szGroupProductVersion = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )
	End
	else if lower(@GroupName) = 'productname' and @GroupValue > ''
	Begin
		set @szGroupProductName = @GroupValue
	End
	else if lower(@GroupName) = 'productversion' and @GroupValue > ''
	Begin
		set @szGroupProductVersion = @GroupValue
	End
	else if lower(@GroupName) = 'servicepack' and @GroupValue > ''
	Begin
		set @szGroupServicepack = @GroupValue
	End
	else if lower(@GroupName) = 'hotfix' and @GroupValue > ''
	Begin
		set @szGroupHotfix = @GroupValue
	End
	else if lower(@GroupName) = 'servicepackhotfix' and @GroupValue > ''
	Begin
	
		/* Separate engine version from dat version: sp\ hf */
		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
		if @pstart is null or @pstart = 0
			set @pstart=1	
		Set @szGroupServicepack = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
		Set @szGroupHotfix = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )

	End

--	else if lower(@GroupName) = 'enginedat' and @GroupValue > ''
--	Begin
--	
--		/* Separate engine version from dat version: ev\ dv */
--		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
--	
--		Set @szGroupEngineVersion = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
--		Set @szGroupDATVersion = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )
--
--	End
	else if lower(@GroupName) = 'engineversion' and @GroupValue > ''
	Begin
		set @szGroupEngineVersion = @GroupValue
	End
	else if lower(@GroupName) = 'datversion' and @GroupValue > ''
	Begin
		set @szGroupDATVersion = @GroupValue
	End
	else if lower(@GroupName) = 'extradat' and @GroupValue > ''
	Begin
		set @szGroupExtraDATNames = @GroupValue
	End

	else if lower(@GroupName) = 'filename' and @GroupValue > ''
	Begin
		set @szGroupFileName = @GroupValue
	End
	else if lower(@GroupName) = 'hostname' and @GroupValue > ''
	Begin
		set @szGroupHostName = @GroupValue
	End
	else if lower(@GroupName) = 'username' and @GroupValue > ''
	Begin
		set @szGroupUserName = @GroupValue
	End

	-- coverage data
	else if lower(@GroupName) = 'domainname' and @GroupValue > ''
	Begin
		set @szGroupDomainName = @GroupValue
	End
	else if lower(@GroupName) = 'osversion' and @GroupValue > ''
	Begin
		set @szGroupOSVersion = @GroupValue
	End

	else if lower(@GroupName) = 'licensestatus' and @GroupValue > ''
	Begin
		set @szGroupLicenseStatus = @GroupValue
	End
	else if lower(@GroupName) = 'expirationdate' and @GroupValue > ''
	Begin
		set @szGroupExpirationDate = @GroupValue
	End
--	else if lower(@GroupName) = 'agentversion' and @GroupValue > ''
--	Begin
--		set @szGroupAgentVersion = @GroupValue
--	End
	else if lower(@GroupName) = 'type' and @GroupValue > ''
	Begin
		set @szGroupType = @GroupValue
	End
	else if lower(@GroupName) = 'version' and @GroupValue > ''
	Begin
		set @szGroupVersion = @GroupValue
	End
	else if lower(@GroupName) = 'error' and @GroupValue > ''
	Begin
		set @szGroupError = @GroupValue
	End
	else if lower(@GroupName) = 'language' and @GroupValue > ''
	Begin
		select 	@szGroupLanguage = epoServerLanguageID		
		from LanguageDesc
		where
   			LanguageDesc.epoServerLanguageID = @szFullLang
			and LanguageDesc.LanguageName = @GroupValue
		if @@rowcount = 0
			Set @szGroupLanguage = @GroupValue
	End
	else if lower(@GroupName) = 'sitename' and @GroupValue > ''
	Begin
		set @szGroupSiteName = @GroupValue
	End
	else if lower(@GroupName) = 'initiatorid' and @GroupValue > ''
	Begin
		set @szGroupInitiatorID = @GroupValue
	End
	else if lower(@GroupName) = 'initiatortype' and @GroupValue > ''
	Begin
		set @szGroupInitiatorType = @GroupValue
	End
	else if lower(@GroupName) = 'agentversion' and @GroupValue > ''
	Begin
		set @szAgentVersion = @GroupValue
	End
	else if lower(@GroupName) = 'licensed' and @GroupValue > ''
	Begin
		set @szLicensed = @GroupValue
	End
	else if lower(@GroupName) = 'connectstatus' and @GroupValue > ''
	Begin
		set @szConnectStatus = @GroupValue
	End
	else if lower(@GroupName) = 'agenttype' and @GroupValue > ''
	Begin
		set @szAgentType = @GroupValue
	End
	else if lower(@GroupName) = 'ostype' and @GroupValue > ''
	Begin
		set @szOSType = @GroupValue
	End
	else if lower(@GroupName) = 'osplatform' and @GroupValue > ''
	Begin
		set @szOSPlatform = @GroupValue
	End
	else if lower(@GroupName) = 'virustype' and @GroupValue > ''
	Begin
		set @szVirusType = @GroupValue
	End
	else if lower(@GroupName) = 'fullproductname' and @GroupValue > ''
	Begin
		set @szFullProductName   = @GroupValue
	End
	else if lower(@GroupName) = 'enginedat' and @GroupValue > ''
	Begin
		set @szEngineDat   = @GroupValue
	End
	else if lower(@GroupName) = 'datextradat' and @GroupValue > ''
	Begin
		set @szDatExtraDat   = @GroupValue
	End
	else if lower(@GroupName) = 'tvdseverity' and @GroupValue > ''
	Begin
		set @szTVDSeverity   = @GroupValue
	End
	else if lower(@GroupName) = 'tvdtaskname' and @GroupValue > ''
	Begin
		set @szTVDTaskName   = @GroupValue
	End
	else if lower(@GroupName) = 'eventdesc' and @GroupValue > ''
	Begin
		set @szEventDesc   = @GroupValue
	End
	else if lower(@GroupName) = 'virussubtype' and @GroupValue > ''
	Begin
		set @szVirusSubType   = @GroupValue
	End
	else if lower(@GroupName) > ''  -- group not found
	begin
		set @ret = @ret -1		-- group not found ret <= 0
	end

	set @loop = @loop + 1
End

RETURN @ret
END
GO


-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- Custom Group Data subreports


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreport]
GO



CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
, @szNameSpaceName  VARCHAR(100)
 ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @EventType varchar(50) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@EventType) != 'all'
	and lower(@EventType) != 'notinfection'
	and lower(@EventType) != 'infection'
	and lower(@EventType) != 'Infection-Res'
	and lower(@EventType) != 'Infection-Unr'
	and lower(@EventType) != 'Infection-Cle'
	and lower(@EventType) != 'Infection-Del'
	and lower(@EventType) != 'Infection-Mov'
		 Set @Inputlegal = 0

 -- translate webshield groupnames into actual event fieldname
 Declare @Webshield int
 Set @Webshield = 0
 if lower(@EventType) = 'contentfilter'
	or lower(@EventType) = 'contentscanning'
	or lower(@EventType) = 'spam'
	or lower(@EventType) = 'urlblocked'
	or lower(@EventType) = 'virus'
 Begin
	Set @Webshield = 1
	if @szGroup1 = 'RuleName'
		Set @szGroup1 = 'VirusName'
	if @szGroup2 = 'RuleName'
		Set @szGroup2 = 'VirusName'
	if @szGroup3 = 'RuleName'
		Set @szGroup3 = 'VirusName'
	if @szGroup4 = 'RuleName'
		Set @szGroup4 = 'VirusName'
	if @szGroup1 = 'Server'
		Set @szGroup1 = 'HostName'
	if @szGroup2 = 'Server'
		Set @szGroup2 = 'HostName'
	if @szGroup3 = 'Server'
		Set @szGroup3 = 'HostName'
	if @szGroup4 = 'Server'
		Set @szGroup4 = 'HostName'
	if @szGroup1 = 'Spammer'
		Set @szGroup1 = 'UserName'
 End


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node (done in main routine)
 --select distinct AgentGUID
 --into #LostLinksEvents
 --from Events
 --	where AgentGUID not in (select AgentGUID from leafnode)
  

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- strip top10 suffix if present
	if substring(@EventType, 1, 5) = 'T10Vr' 
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	else if substring(@EventType, 1, 5) = 'T10Fl' 
		Set @EventType = Replace( @EventType, 'T10Fl', '')
	else if substring(@EventType, 1, 5) = 'T10Ur' 
		Set @EventType = Replace( @EventType, 'T10Ur', '')
	else if substring(@EventType, 1, 5) = 'T10Cp' 
		Set @EventType = Replace( @EventType, 'T10Cp', '')

   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  -- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)  	
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50) 
	Declare @szAgentType	varchar(50) 
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(255) 
	Declare	@szVirusSubType varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = ''  
	Set @szVirusSubType = ''

   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					@szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		-- coverage data 
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion output
						,@szLicensed output
						,@szConnectStatus output 
						,@szAgentType	output
						,@szOSType output
						,@szOSPlatform output
						,@szVirusType output
						,@szFullProductName output
						,@szEngineDat output
						,@szDatExtraDat output
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubType OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	



---------------------------------------------------------------
-- Do not use outer joins here
-- if the group is on a field partiipating in an outer join not only will the fields matching value be returned but all outerjoin rows (null values) as well
-- too much data gets sent.

-- avoid outer join on eventdesc table: if no match then row wont be returned - too little data returned
-- keep outer join in actiodesc & virustype ion events are caught
-- note: missing entries in EventFilterDescFast will result in rows not being returned



--select @szGroupActionTaken


-- warning:  dont do outer join on a group field: it breaks in these subreports returning to many rows
 
 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */

    		,CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(Events.UserName AS varchar(32)) AS UserName
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  cast(BranchNode.Nodename as varchar(255))
			ELSE @Unlinked
			END 


    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype

    		,cast( TVDEventID as varchar(10)) as TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		ScanTime 
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
		-- epo3.5 post3.0.2. If severity match note found in eventfilterdesc, translate numbers to text
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity

    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
    		,CAST(ProductID as int) As ProductID
--  		cast(BranchNode.Nodename as varchar(255))    AS NodeName 
--  		cast(ReportFullPathNode.FullPathName as varchar(255))    AS NodeName 

--		, cast(EventFilterDescFast.Name as varchar(128)) as EventDesc
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc

		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(@EventType in ('All', 'NotInfection') 
		and events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND ( TVDEventID not in (1202, 1203, 4650, 4651 ) )
--   	AND LeafNode.Type !=  24      -- show all events including uninstalled
	and ( @YYYYMMDD is null or Events.EventDateTime >=  @YYYYMMDD)
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionUr' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionCp' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or ( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or ( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or ( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or ( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	)

             AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime) = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), Cast(DatePart(Month, EventDateTime) as char(5)) ) = @szGroupMonth
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
--
		)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Quarter, EventDateTime)) = @szGroupQuarter
--			AND
--		  Datediff(year, EventDateTime, Getdate() ) = 0
		)
	) 
             AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Week, EventDateTime)) = @szGroupWeek
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
		)
	) 
             AND 		-- day of month
	(	 @szGroupDay = ''
		OR 
		convert(varchar(20), DateName(Day, EventDateTime)) = @szGroupDay
	) 
             AND 		-- hour of day
	(	 @szGroupHour = ''
		OR 
		convert(varchar(20), DateName(Hour, EventDateTime)) = @szGroupHour
	) 
             AND 
	(	 @szGroupVirusName = ''
		OR Events.VirusName = @szGroupVirusName
	) 
             AND 
	(	 @szGroupActionTaken = ''
-- localized version OR (ReportActionDesc.ActionName = @szGroupActionTaken and ActionTaken in ('50','65') )
		OR (@szGroupActionTaken = ReportActionDesc.ActionName )
		OR (@szGroupActionTaken > '' and convert(varchar(25),ActionTaken) = @szGroupActionTaken )
	) 
             AND 
	(	 @szTVDSeverity = ''
-- localized version OR ( SeverityDesc.SeverityName = @szTVDSeverity and Events.TVDSeverity = 0 )  do join above to severitydesc or TranslateSeverity
		or ( @szTVDSeverity = EventFilterDescFast.Severity )
		OR ( @szTVDSeverity = @Informational and Events.TVDSeverity = 0 )
		OR ( @szTVDSeverity = @Warning and Events.TVDSeverity = 1 )
		OR ( @szTVDSeverity = @Minor and Events.TVDSeverity = 2 )
		OR ( @szTVDSeverity = @Major and Events.TVDSeverity = 3 )
		OR ( @szTVDSeverity = @Critical and Events.TVDSeverity = 4 )
		OR ( @szTVDSeverity = '---' and (Events.TVDSeverity > 4  or Events.TVDSeverity < 0) )
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
		or ( @szGroupNodeName = '---' and (BranchNode.NodeName is NULL) )
	) 
             AND 
	(	 @szGroupProductName = ''
		OR ProductName = @szGroupProductName
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR ProductVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (ProductVersion is NULL or ProductVersion = '') )
	) 
             AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVersion = @szGroupEngineVersion
	) 
             AND 
	(	 @szGroupDATVersion = ''
		OR DATVersion = @szGroupDATVersion
	) 
             AND 	-- make this a like operator since the filename is cropped
	(	 @szGroupFileName = ''
		OR FileName like ('%' + @szGroupFileName)
	) 
             AND 
	(	 @szGroupHostName = ''
		OR Events.HostName = @szGroupHostName
	) 
             AND 
	(	 @szGroupUserName = ''
		OR Events.UserName = @szGroupUserName
	) 
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName = '' or Domainname is null) )
		or ( @szGroupDomainName = '---' and (DomainName = '' or Domainname is null) )
	) 
             AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType = '' or OSType is null) )
		or ( @szOSType = '---' and (OSType = '' or OSType is null) )
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform = '' or OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '' or OSPlatform is NULL) )
	) 
             AND 
	(	 @szVirusType = ''
		OR VirusType.VirusTypeTranslated = @szVirusType 
		or Events.VirusType = @szVirusType 
		or (@szVirusType = '---' and (Events.VirusType = '' or Events.VirusType is NULL))
	) 
             AND 
	(	 @szVirusSubtype = ''
		OR VirusType.VirusFileType = @szVirusSubtype 
		or (@szVirusSubtype = '---' and (VirusType.VirusFileType = '' or VirusType.VirusFileType is NULL))
	) 
             AND 
	(	 @szFullProductName = ''
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		or (@szFullProductName = '---' and ((ProductName + ' ' + ProductVersion) = ' ' or (ProductName + ' ' + ProductVersion) is NULL))
	) 
             AND 
	(	 @szEngineDat = ''
		OR (EngineVersion + ' ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion + ' \ ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion)  = @szEngineDat 
		OR (DATVersion)  = @szEngineDat 
		or (@szEngineDat = '---' and ((EngineVersion + ' ' + DATVersion) = ' ' or (EngineVersion + ' ' + DATVersion) is NULL))
	) 
             AND 
	(	 @szTVDTaskName = ''
		OR TVDTaskName = @szTVDTaskName 
	) 
             AND 
	(	 
		@szEventDesc = ''
		or EventFilterDescFast.Name = @szEventDesc
		or cast(Events.TVDEventID as varchar(128)) = @szEventDesc
		or (@szEventDesc = '---' and (Events.TVDEventID = '' or Events.TVDEventID is NULL))
	) 






	set @ret = @@rowcount

--	Drop Table #LostLinksEvents

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductEventGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductEventGroupsSubreport]
GO

CREATE PROCEDURE dbo.AVISP_FilterProductEventGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
, @AfterYYYYMMDD varchar(30) = ''
, @AfterRule varchar(30) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1




 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 
 -- Build a list of ProductEvent Guids that are not tied to a leaf node (Done in main routine)
 --select distinct NodeID
 --into #LostLinks
 --from ProductEvents
 --	where NodeID not in (select AutoID from leafnode)
 

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @AfterYYYYMMDD, @AfterRule, @YYYYMMDD output


   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  	-- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)
 	Declare @szConnectStatus     VARCHAR(50)  
	Declare @szAgentType	varchar(50)
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(50) 
	Declare	@szVirusSubtype varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = '' 
	Set @szVirusSubtype = '' 


   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms, 
					 @szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion 	OUTPUT
						,@szLicensed  		OUTPUT
						,@szConnectStatus	OUTPUT 
						,@szAgentType		OUTPUT
						,@szOSType OUTPUT
						,@szOSPlatform OUTPUT
						,@szVirusType OUTPUT
						,@szFullProductName OUTPUT
						,@szEngineDat OUTPUT
						,@szDatExtraDat OUTPUT
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubtype OUTPUT

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent = 'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	


----------------------------------------------------
-- fetch the rows 

 	SELECT   
		
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q


   		,AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END
		, case
			when ComputerProperties.Computername > '' then ComputerProperties.Computername
			when LeafNode.NodeName > '' then LeafNode.NodeName
			else @Unlinked
			end as HostName
    		,CAST(ComputerProperties.IPAddress As varchar(15)) As HostIPAddress
    		,CAST(ComputerProperties.UserName AS varchar(32)) AS UserName
		,CAST('' As varchar(50)) AS VirusName
    		,CAST('' As varchar(50)) AS TVDEventID
    		,CAST('' As varchar(50)) As FileName
   		,CAST('' As varchar(50)) AS EngineVersion
   		,CAST('' As varchar(50)) AS DATVersion 
    		,CAST('' As varchar(50)) As ScanTime 
   		,CAST('' As varchar(50)) As ActionTaken
    		,CAST('' As varchar(50)) As TVDSeverity 
   		,CAST('' As varchar(50)) As VirusType 
    		,CAST('' AS varchar(50)) As TVDTaskName
    		,CAST('' as int) As ProductID
  		, case
			when BranchNode.NodeName > '' then cast(BranchNode.NodeName as varchar(255))
			else @Unlinked
		 	end AS NodeName 
--  		,cast(BranchNode.NodeName as varchar(255)) AS NodeName 

 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( Locale as nvarchar(50)) as Language
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType

  		, case
			when ComputerProperties.DomainName > '' then ComputerProperties.DomainName
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as DomainName
  		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
  		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
--    		,cast(ReportFullPathNode.FullPathName as varchar(255))  As FullNodeName
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as nvarchar(128)) 
			else cast(ProductEvents.Error as nvarchar(128)) 
			end

	FROM 
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)	
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)
	
--   		ProductEvents, AVIView_Software				--, ReportFullPathNode
--             		,LeafNode, BranchNode, ComputerProperties   --, ProductProperties LanguageDesc, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--   	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	AND LeafNode.ParentID = BranchNode.AutoID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')	-- need to see all events 
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  -- need to see all events 
--   	AND LeafNode.Type !=24      -- need to see all events 
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)


	-- filter by the drilldown groups selected by the user
             AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime)  = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth )
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), Cast(DatePart(Month, EventDateTime) as char(5)) )  = @szGroupMonth	)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + 
			Datename(Week, EventDateTime)   = @szGroupQuarter	)	-- quarter 1-4
	) 
             AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek)
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Week, EventDateTime)) = @szGroupWeek)
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
	) 
             AND 
	(	 @szGroupProductName = ''
		OR AVIView_Software.SoftwareName = @szGroupProductName
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR AVIView_Software.SoftwareVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (AVIView_Software.SoftwareVersion is NULL or AVIView_Software.SoftwareVersion = '') )
	) 
             AND 
	(	 @szGroupAgentVersion = ''
		OR ProductEvents.AgentVersion = @szGroupAgentVersion
	)
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName is NULL) )
		or ( @szGroupDomainName = '---' and (DomainName = '') )
	) 
             AND 
	(	 @szOSType = ''
		OR computerProperties.OSType = @szOSType 
		or ( @szOSType = @Unlinked and (computerProperties.OSType is NULL) )
		or ( @szOSType = '---' and (computerProperties.OSType = '') )
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '') )
	) 
             AND 
	(	 @szFullProductName = ''
		OR (AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) = @szFullProductName 
	) 
             AND 
	(	 @szGroupType = ''
		OR ProductEvents.Type = @szGroupType
	) 
             AND 
	(	 @szGroupError = ''
		OR ReportUpdateEventDesc.Description = @szGroupError
		OR convert(char(10),ProductEvents.Error) = @szGroupError
		or ( @szGroupError = '---' and (ProductEvents.Error is NULL) )
--		OR ProductEvents.Error = @szGroupError
	) 
             AND 
	(	 @szGroupLanguage = ''
		OR Locale = @szGroupLanguage
	) 
             AND 
	(	 @szGroupSiteName = ''
		OR SiteName = @szGroupSiteName
	) 
             AND 
	(	 @szGroupInitiatorID = ''
		OR InitiatorID = @szGroupInitiatorID
	) 
             AND 
	(	 @szGroupInitiatorType = ''
		OR Initiatortype = @szGroupInitiatorType
	) 
             AND 
	(	 @szGroupVersion = ''
		OR Version = @szGroupVersion
	) 

	


	set @ret = @@rowcount

--	Drop Table #LostLinks
	

-- check for illegal values
-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO





if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductGroupsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterProductGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = ''
 , @ConnectType varchar(30) = 'All'
 , @ProductType varchar(30) = 'AntiVirus' 
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@ConnectType) != 'current' 
	and lower(@ConnectType) != 'all' 
	and lower(@ConnectType) != 'late' 
		 Set @Inputlegal = 0

 if lower(@ProductType) != 'all'
	and lower(@ProductType) != 'antivirus'
	and lower(@ProductType) != 'security'
	and lower(@ProductType) != 'agent'
		 Set @Inputlegal = 0



 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

    /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output
	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')



   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupDay varchar(100) 
   Declare @szGroupHour varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  	-- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50)  
	Declare @szAgentType     VARCHAR(50)  
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(50) 
	Declare @szVirusSubtype varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = '' 
	Set @szVirusSubtype = '' 


   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					     @szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion  OUTPUT
						,@szLicensed    OUTPUT
						,@szConnectStatus    OUTPUT
						,@szAgentType    OUTPUT
						,@szOSType OUTPUT
						,@szOSPlatform OUTPUT
						,@szVirusType OUTPUT
						,@szFullProductName OUTPUT
						,@szEngineDat OUTPUT
						,@szDatExtraDat OUTPUT
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubtype OUTPUT

--select  @szAgentVersion 
--select @szConnectStatus 
--select @szAgentType 
--select @szGroupLanguage
--select @szGroupProductVersion

--if  @szGroupProductName not like 'Unmanaged Protection%' and  @szGroupProductName <> 'UnProtection'
--and  @szGroupProductName <> '(UnProtection)'
--begin

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
--		Select 	@Agent = TranslatedValue from ReportTranslations 
--			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'Agent'
		Set @Agent = 'Agent'		-- last minute localization bug, too late to retranslate
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	



-----------------------------------------
-- Fetch the rows

 	SELECT 
		cast( '' as varchar(10)) as EventDateTime
   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then 'Unprotected' 
				Else @NoAgent
				End
			End --as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---'
     			END
--		postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	   	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as HostName
--   		,ComputerProperties.ComputerName as HostName
    		,CAST(ComputerProperties.IPAddress As varchar(15)) As HostIPAddress
    		,CAST(ComputerProperties.UserName AS varchar(32)) AS UserName
		,CAST('' As varchar(10)) AS VirusName
    		,CAST('' As varchar(10)) AS TVDEventID
    		,CAST('' As varchar(10)) As FileName
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
    		,CAST('' As varchar(10)) As ScanTime 
   		,CAST('' As varchar(10)) As ActionTaken
    		,CAST('' As varchar(10)) As TVDSeverity 
   		,CAST('' As varchar(10)) As VirusType 
    		,CAST('' AS varchar(10))As TVDTaskName
    		,CAST('' as int) As ProductID
  		, cast(BranchNode.NodeName as varchar(255)) AS NodeName 
  		,ComputerProperties.DomainName
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) as OSVersion
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix

   		, LeafNode.LastUpdate as LastContact
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'

		, ProductProperties.LicenseStatus as LicenseStatus 
		, ProductProperties.ExpirationDate as ExpirationDate
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
--		, ProductProperties.Language as Language
		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE  '---' 
     			END
--   		, LeafNode.Licensed 
		, '' as Licensed

		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
--		, case convert(int, superagent) + (convert(int, superagentrepo) * 10) 
--			when 0 then @Agent
--			when 1 then @SuperAgentBroadcast
--			when 10 then @SuperAgentRepository
--			when 11 then @SuperAgentRepository
--			else @Agent
--			end	as AgentType
		, case
			when LeafNode.LastUpdate  >=  @YYYYMMDD then @Current
			when LeafNode.LastUpdate  <  @YYYYMMDD then @Late
			else '---'
			end 	as ConnectStatus
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
	        ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		   ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		   as FullProductName
	        ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 
	        ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
  		, cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName


 FROM 	
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
	   		AND LeafNode.Type !=24      /* Uninstalled */ 
			and ( @YYYYMMDD is null  or @ConnectType = 'All' 
				or
				( 
				(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
				or
				(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')
				or
				(@ConnectType = '(NoAgent)' and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null))
				)	
		       )
	
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )

 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
--   AND LeafNode.AutoID = ComputerProperties.ParentID
--                  AND ProductProperties.ParentID = LeafNode.AutoID 
--   and ProductProperties.ProductCode = AVIView_Software.ProductCode
--   AND LeafNode.ParentID = BranchNode.AutoID
--   AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   AND LanguageDesc.epoServerLanguageSuffix = @szLang


   
        AND 
	(	 @szGroupYear = ''
		OR substring(Leafnode.LastUpdate, 1, 4) = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) = @szGroupMonth	)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + 
			cast((((convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))  = @szGroupQuarter	)	-- quarter 1-4
	) 
             AND 
	(	 @szGroupDay = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
			= @szGroupDay )
	)


/*             AND 
	(	 @szGroupWeek = ''
		OR 
		( DatePart(Week, EventDateTime) = @szGroupWeek)
	)*/ 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		OR ( @szGroupNodeName = '---'  and (BranchNode.NodeName = '' or BranchNode.NodeName is null))
	) 
             AND 
	(	 @szGroupProductName = ''
		OR AVIView_Software.SoftwareName = @szGroupProductName
		OR (@szGroupProductName = @Unprotected and leafnode.agentversion > '' and leafnode.avinstalls = 0) 
		OR (@szGroupProductName = @NoAgent and (leafnode.agentversion = '' or leafnode.agentversion is null)) 
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR ProductProperties.ProductVersion = @szGroupProductVersion
		OR (@szGroupProductVersion = '---' and (ProductProperties.ProductVersion = '' or ProductProperties.ProductVersion is null))
	) 
             AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVer = @szGroupEngineVersion
		OR (@szGroupEngineVersion = '---' and (EngineVer = '' or EngineVer is null))
	) 
             AND 
	(	 @szGroupDATVersion = ''
		OR DATVer = @szGroupDATVersion
		OR (@szGroupDATVersion = '---' and (DATVer = '' or DATVer is null))
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		OR ( @szGroupNodeName = '---'  and (BranchNode.NodeName = '' or BranchNode.NodeName is null))
	) 
             AND 
	(	 @szGroupExtraDATNames = ''
		OR ExtraDATNames = @szGroupExtraDATNames
		OR ( @szGroupExtraDATNames = '---'  and (ExtraDATNames = '' or ExtraDATNames is null))
	) 
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		OR ( @szGroupDomainName = '---'  and (DomainName = '' or DomainName is null))
	) 
             AND 
	(	 @szGroupOSVersion = ''
		OR cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50))  = @szGroupOSVersion
	) 
             AND 
	(	 @szGroupServicepack = ''
		OR Servicepack = @szGroupServicepack
		OR ( @szGroupServicepack = '---'  and (Servicepack = '' or Servicepack is null))
	) 
             AND 
	(	 @szGroupHotfix = ''
		OR Hotfix = @szGroupHotfix
		OR ( @szGroupHotfix = '---'  and (Hotfix = '' or Hotfix is null))
	) 
             AND 
	(	 @szGroupLanguage = ''
		OR (Language = @szGroupLanguage )
		OR ( @szGroupLanguage = '---'  and (Language = '' or Language is null))
--		or (LanguageDesc.LanguageName = @szGroupLanguage and LanguageDesc.LanguageName > '' )
--		or ( @szGroupLanguage = 'English' and Language = '0409' )
	) 
             AND 
	(	 @szOSType = ''
		OR computerProperties.OSType = @szOSType 
		OR ( @szOSType = '---'  and (computerProperties.OSType = '' or computerProperties.OSType is null))
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		OR ( @szOSPlatform = '---'  and (OSPlatform = '' or OSPlatform is null))
	) 
             AND 
	(	 @szFullProductName = ''
		OR (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		   ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) = @szFullProductName 
	) 
             AND 
	(	 @szEngineDat = ''
		OR (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', ''))  = @szEngineDat 
		OR (EngineVer + ' \ ' +  DATVer )  = @szEngineDat 
	) 
             AND 
	(	 @szDatExtraDat = ''
		OR (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) = @szDatExtraDat 
	) 
             AND 
	(	 @szAgentVersion = ''
		OR AgentVersion = @szAgentVersion
		OR (@szAgentVersion = @NoAgent and (AgentVersion = '' or AgentVersion is null))

	) 
             AND 
	(	 @szConnectStatus = ''
		OR 	(@szConnectStatus= @Current and LeafNode.LastUpdate  >=  @YYYYMMDD)
		OR 	(@szConnectStatus= @Late and LeafNode.LastUpdate < @YYYYMMDD and LeafNode.LastUpdate > '')
		OR 	(@szConnectStatus= @NoAgent and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null)) 
		OR 	(@szConnectStatus= 'All') 
	) 
             AND 
	(	 @szAgentType = ''
		OR 	(@szAgentType= @NoAgent and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null)) 
		OR 	(@szAgentType= @Agent and LeafNode.SuperAgent = 0 and LeafNode.SuperAgentRepo = 0)
		OR 	(@szAgentType= @Agent and LeafNode.SuperAgent is null and LeafNode.SuperAgentRepo is null)
		OR 	(@szAgentType= @SuperAgentBroadcast and LeafNode.SuperAgent = 1 and LeafNode.SuperAgentRepo = 0)
		OR 	(@szAgentType= @SuperAgentRepository and LeafNode.SuperAgent = 0 and LeafNode.SuperAgentRepo = 1)
		OR 	(@szAgentType= @SuperAgentRepository and LeafNode.SuperAgent = 1 and LeafNode.SuperAgentRepo = 1)
		OR 	(@szAgentType= '---' )
	) 


--drop table  dbo.tmpUnmanagedProtection

Set @ret = @@rowcount

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3
--end

RETURN @ret
END
GO


----------------------------------------------------------------------
-- more subreports: policy and tasks


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterPolicySubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterPolicySubreport]
GO

CREATE PROCEDURE dbo.AVISP_FilterPolicySubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int
--  , @ParentID int
  , @ProductCode varchar(50)=''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

	Declare @ret int
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

------------
-- postepo3 - cleanup temp tables
  
	IF EXISTS (select * from sysobjects where name = 'tmpFinalPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpFinalPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpCompiledPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpCompiledPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpPolicy' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpPolicy

	IF EXISTS (select * from sysobjects where name = 'tmpPolicyNodeList' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpPolicyNodeList

	IF EXISTS (select * from sysobjects where name = 'tmpProducts' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpProducts



  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Find where properties are set for this product on this computer
	Declare @PolicyID int
	Declare @PolicyParentType int 
	Declare @PolicyParentID int 
	Declare @ParentID int

	-- get parentid
	Select @ParentID = parentid from leafnode where autoid = @NodeID

	-- get all productcodes applying to this node
	select ProductProperties.ProductCode
	into dbo.tmpProducts
	from leafnode, ProductProperties, aviview_software
	where
		leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC') 
				or (AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%') 
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and leafnode.autoid = @NodeID
		and 
		(
		@ProductCode is null or @ProductCode = '' or ProductProperties.ProductCode = @ProductCode
		or ProductProperties.ProductCode like 'EPOAGENT%'  -- fix always include agent
		)
		
--select * from dbo.tmpProducts

	-- get all branchnodes for the installed products in the inheritance tree storing policy values and inheritance level
	SELECT Policy.autoid, Policy.ParentID, Policy.ParentType, PathLength, Policy.ProductCode
			Into dbo.tmpPolicyNodeList
			FROM Policy, BranchNodeEnum
			Where Policy.parentid = Startautoid
				and Endautoid = @Parentid 
				and Policy.ProductCode in (select ProductCode from dbo.tmpProducts)

--select * from dbo.tmpPolicyNodeList

	-- write policies from inheritance path into temp table
	Select
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,(PathLength+1) as PathLength
		,SectionName
		,SettingName
		,Value
	into dbo.tmpPolicy
	From dbo.tmpPolicyNodeList, Policy, PolicySettings
	Where
		dbo.tmpPolicyNodeList.autoid = Policy.autoid
		and dbo.tmpPolicyNodeList.Productcode = Policy.Productcode
		and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- add any policies stored at the parent node
	insert into dbo.tmpPolicy
	select 
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,1  as PathLength	-- default 1 means parentnode,thesmaller the number the higher the priority
		,SectionName
		,SettingName
		,Value
		from Policy, PolicySettings
		Where 
			Policy.parentid = @ParentID
			and Policy.ParentType in (3, 6)
			and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- add any policies from the leafnode itself
	insert into dbo.tmpPolicy
	select 
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,0  as PathLength	-- default 0 means from the leafnode,the smaller the number the higher the priority
		,SectionName
		,SettingName
		,Value
		from Policy, PolicySettings
		Where 
			Policy.parentid = @NodeID
			and Policy.ParentType = 1
			and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- Get Top Priorities policy values
	Select
		ProductCode
		,SectionName
		,SettingName
		,min(PathLength) as PathLength
		into dbo.tmpCompiledPolicies
		from dbo.tmpPolicy
		group by
			ProductCode
			,SectionName
			,SettingName			

-- select * from dbo.tmpCompiledPolicies order by productcode, sectionname, settingname

	-- build final policy list
	select 
		@NodeID as NodeID
		,@ParentID as NodeParentID
		,dbo.tmpPolicy.ProductCode
		,dbo.tmpPolicy.autoid
		,dbo.tmpPolicy.ParentID as PolicyParentID
		,dbo.tmpPolicy.ParentType
		,dbo.tmpPolicy.SectionName
		,dbo.tmpPolicy.SettingName
		,dbo.tmpPolicy.Value
		into dbo.tmpFinalPolicies
		from dbo.tmpCompiledPolicies, dbo.tmpPolicy
		Where 
			dbo.tmpCompiledPolicies.SectionName =  dbo.tmpPolicy.SectionName
			and dbo.tmpCompiledPolicies.ProductCode =  dbo.tmpPolicy.ProductCode
			and dbo.tmpCompiledPolicies.SettingName =  dbo.tmpPolicy.SettingName			
			and dbo.tmpCompiledPolicies.PathLength = dbo.tmpPolicy.PathLength


--select * from dbo.tmpFinalPolicies order by productcode, sectionname, settingname

		

	-----------------------------------------------------------------------------------
	-- Collect Policy details

	SELECT

   		AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
     			ELSE '---'
     			END
    		,cast( '' as varchar(10)) as VirusName		-- null field, used so that same rpt file can be used
   		,EngineVer =
    			CASE 
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer  
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVer =
    			CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     			ELSE '---'
     			END
 		,BranchNode.NodeName AS NodeName 
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
  		,ComputerProperties.ComputerName
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix
   		, InheritedNode = 
			CASE dbo.tmpFinalPolicies.ParentType
			when 1 then leafnode.nodename    -- fix
			when 4 then 'Directory'
			when 7 then 'Global Root'
			else cast(  ReportFullPathNode.FullPathName as varchar(255))   
			end

		,dbo.tmpFinalPolicies.ProductCode
		,dbo.tmpFinalPolicies.autoid
		,dbo.tmpFinalPolicies.PolicyParentID
		,dbo.tmpFinalPolicies.ParentType
		,SectionName
		,SettingName
		,Value

	From dbo.tmpFinalPolicies
		,ReportFullPathNode
		,leafnode, BranchNode
		,ComputerProperties, ProductProperties, AVIView_Software
	Where
		dbo.tmpFinalPolicies.nodeid = leafnode.autoid
		and leafnode.autoid = @NodeID
		and leafnode.autoid = computerproperties.parentid
		and leafnode.autoid = productproperties.parentid
		and leafnode.parentid = branchnode.autoid
		and dbo.tmpFinalPolicies.productcode = productproperties.productcode
		and productproperties.productcode = aviview_software.productcode
--		and Policysettings.value > ''
		AND 
		(
			(
				dbo.tmpFinalPolicies.ParentType in (3, 5, 6)
				and
				ReportFullPathNode.LowestNodeID = dbo.tmpFinalPolicies.PolicyParentID  --fix
				and leafnode.autoid = @NodeID
				and dbo.tmpFinalPolicies.PolicyParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType in (4, 7)
				and
				ReportFullPathNode.LowestNodeID = @ParentID
--				and leafnode.autoid = @NodeID
--				and Policy.ParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType = 1
				and
				ReportFullPathNode.LowestNodeID = @ParentID
				and dbo.tmpFinalPolicies.PolicyParentID = Leafnode.autoid
			)

		)
order by dbo.tmpFinalPolicies.productcode, sectionname, settingname

set @ret = @@rowcount

Drop Table  dbo.tmpFinalPolicies
Drop Table  dbo.tmpCompiledPolicies
Drop Table  dbo.tmpPolicy
Drop Table  dbo.tmpPolicyNodeList
Drop Table  dbo.tmpProducts

RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterTaskSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterTaskSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterTaskSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int
--  , @ParentID int
--  , @ProductCode varchar(50)=''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

Declare @ret int

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


------------
-- postepo3 - cleanup temp tables
  
	IF EXISTS (select * from sysobjects where name = 'tmpFinalPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpFinalPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpCompiledPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpCompiledPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpPolicy' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTask

	IF EXISTS (select * from sysobjects where name = 'tmpPolicyNodeList' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTaskNodeList

	IF EXISTS (select * from sysobjects where name = 'tmpProducts' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpProducts

	IF EXISTS (select * from sysobjects where name = 'tmpGlobalTaskID' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpGlobalTaskID


/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Find where properties are set for this product on this computer
	Declare @TaskID int
	Declare @TaskParentType int 
	Declare @TaskParentID int 
	Declare @ParentID int

	-- get parentid
	Select @ParentID = parentid from leafnode where autoid = @NodeID

	-- get all productcodes applying to this node
	select ProductProperties.ProductCode
	into dbo.tmpProducts
	from leafnode, ProductProperties, aviview_software
	where
		leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC') 
				or (AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%') 
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and leafnode.autoid = @NodeID


	-- get all branchnodes in the inheritance tree storing Task values
	SELECT Task.autoid, Task.ParentID, Task.ParentType, PathLength, Task.ProductCode
			Into dbo.tmpTaskNodeList
			FROM Task, BranchNodeEnum
			Where Task.parentid = Startautoid
				and Endautoid = @Parentid 
				and ProductCode in (select ProductCode from dbo.tmpProducts)
	
	-- write Task from inheritance path into temp table
	-- postepo3 33636 - only show task that are set not both set task and available default task
	-- collect tasks from all levels except global root level
	Select
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,(PathLength+1) as PathLength
		,SectionName
		,SettingName
		,Value
	into dbo.tmpTask
	From dbo.tmpTaskNodeList, Task, TaskSettings
	Where
		dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType != 7

	-- find all global taskids
	Select Distinct GlobalTaskID
	into	dbo.tmpGlobalTaskID
	From 	dbo.tmpTask

--select * from dbo.tmpTask

	-- Add tasksettings from global root level (GlobalTaskID <> 0) where task is defined at dir level or below
	-- In other words get all tasksettings for tasks defined for a computer
	Insert dbo.tmpTask
		(ProductCode
		,autoid
		,ParentID
		,ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,PathLength
		,SectionName
		,SettingName
		,Value)
	Select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,Task.TaskName
		,Task.TaskType
		,Task.TaskStatus
		,Task.Priority
		,Task.PlatformsSupported
		,Task.GlobalTaskID
		,(dbo.tmpTaskNodeList.PathLength+1) as PathLength
		,TaskSettings.SectionName
		,TaskSettings.SettingName
		,TaskSettings.Value
	From dbo.tmpTaskNodeList, dbo.tmpGlobalTaskID, Task, TaskSettings
	Where
		dbo.tmpGlobalTaskID.GlobalTaskID = Task.autoid
		and dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType = 7
		and Task.GlobalTaskID != 0

	-- find all global taskids again
	Truncate Table dbo.tmpGlobalTaskID

	Insert dbo.tmpGlobalTaskID
	Select Distinct GlobalTaskID
--	into	dbo.tmpGlobalTaskID
	From 	dbo.tmpTask
	
--select * from dbo.tmpTask

	-- Add tasksettings from global root level (GlobalTaskID = 0) where task is defined at dir level or below
	-- In other words get all tasksettings for tasks defined for a computer
	Insert dbo.tmpTask
		(ProductCode
		,autoid
		,ParentID
		,ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,PathLength
		,SectionName
		,SettingName
		,Value)
	Select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,Task.TaskName
		,Task.TaskType
		,Task.TaskStatus
		,Task.Priority
		,Task.PlatformsSupported
		,Task.GlobalTaskID
		,(dbo.tmpTaskNodeList.PathLength+1) as PathLength
		,TaskSettings.SectionName
		,TaskSettings.SettingName
		,TaskSettings.Value
	From dbo.tmpTaskNodeList, dbo.tmpGlobalTaskID, Task, TaskSettings
	Where
		dbo.tmpGlobalTaskID.GlobalTaskID = Task.autoid
		and dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType = 7
		and Task.GlobalTaskID = 0


	Drop table dbo.tmpGlobalTaskID



--select * from dbo.tmpTask

	-- Update default task settings so that they have the highest value (lowest priority)
	-- Global tasks are a copy of the default task and there priority should be 1 lower
	update dbo.tmpTask
	set PathLength = PathLength+1
	Where GlobalTaskID = 0 and ParentType=7

	update dbo.tmpTask		-- fix
	set PathLength = PathLength+1   --fix


	-- add any Task stored at the parent node
	insert into dbo.tmpTask
	select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,1  as PathLength	-- default 1 means parentnode,the smaller the number the higher the priority - fix
		,SectionName
		,SettingName
		,Value
		from Task, TaskSettings
		Where 
			Task.parentid = @ParentID
			and Task.ParentType in (3, 6)
			and Task.autoid = TaskSettings.parentid

--select * from dbo.tmpTask

	-- add any policies from the leafnode itself
	insert into dbo.tmpTask
	select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,0  as PathLength	-- default 0 means from the leafnode, the smaller the number the higher the priority  - fix
		,SectionName
		,SettingName
		,Value
		from Task, TaskSettings
		Where 
			Task.parentid = @NodeID
			and Task.ParentType = 1
			and Task.autoid = TaskSettings.parentid

--select * from dbo.tmpTask

	-- Get Top Priorities Task values
	Select
		ProductCode
		,TaskType
		,TaskName
		,SectionName
		,SettingName
		,min(PathLength) as PathLength
		into dbo.tmpCompiledPolicies
		from dbo.tmpTask
		group by
			ProductCode
			,TaskType
			,TaskName
			,SectionName
			,SettingName			

--select * from dbo.tmpCompiledPolicies  order by ProductCode, tasktype, taskname, sectionname, settingname

	-- build final Task list
	select 
		@NodeID as NodeID
		,@ParentID as NodeParentID
		,dbo.tmpTask.ProductCode
		,dbo.tmpTask.autoid
		,dbo.tmpTask.ParentID as TaskParentID
		,dbo.tmpTask.GlobalTaskID
		,dbo.tmpTask.ParentType
		,dbo.tmpTask.TaskName
		,dbo.tmpTask.TaskType
		,dbo.tmpTask.TaskStatus
		,dbo.tmpTask.Priority
		,dbo.tmpTask.PlatformsSupported
		,dbo.tmpTask.SectionName
		,dbo.tmpTask.SettingName
		,dbo.tmpTask.Value
		into dbo.tmpFinalPolicies
		from dbo.tmpCompiledPolicies, dbo.tmpTask
		Where 
			dbo.tmpCompiledPolicies.ProductCode =  dbo.tmpTask.ProductCode
			and dbo.tmpCompiledPolicies.TaskType =  dbo.tmpTask.TaskType	
			and dbo.tmpCompiledPolicies.TaskName =  dbo.tmpTask.TaskName				
			and dbo.tmpCompiledPolicies.Sectionname =  dbo.tmpTask.Sectionname			
			and dbo.tmpCompiledPolicies.SettingName =  dbo.tmpTask.SettingName			
			and dbo.tmpCompiledPolicies.PathLength = dbo.tmpTask.PathLength


-- select * from dbo.tmpFinalPolicies order by ProductCode, tasktype, taskname, sectionname, settingname

		

	-----------------------------------------------------------------------------------
	-- Collect Task details

	SELECT

   		AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion 
     			ELSE '---' 
     			END
    		,cast( '' as varchar(10)) as VirusName		-- null field, used so that same rpt file can be used
   		,EngineVer =
    			CASE  
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVer =
    			CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
 		,BranchNode.NodeName AS NodeName 
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
  		,ComputerProperties.ComputerName
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix
   		, InheritedNode = 
			CASE dbo.tmpFinalPolicies.ParentType
			when 1 then leafnode.nodename		-- fix
			when 4 then 'Directory'
			when 7 then 'Global Root'
			else cast(  ReportFullPathNode.FullPathName as varchar(255))   
			end

		,dbo.tmpFinalPolicies.ProductCode
		,dbo.tmpFinalPolicies.autoid
		,dbo.tmpFinalPolicies.TaskParentID
		,dbo.tmpFinalPolicies.GlobalTaskID
		,dbo.tmpFinalPolicies.ParentType
		,dbo.tmpFinalPolicies.TaskName
		,dbo.tmpFinalPolicies.TaskType
		,dbo.tmpFinalPolicies.TaskStatus
		,dbo.tmpFinalPolicies.Priority
		,dbo.tmpFinalPolicies.PlatformsSupported
		,SectionName
		,SettingName
		,Value

	From dbo.tmpFinalPolicies
		,ReportFullPathNode
		,leafnode, BranchNode
		,ComputerProperties, ProductProperties, AVIView_Software
	Where
		dbo.tmpFinalPolicies.nodeid = leafnode.autoid
		and leafnode.autoid = @NodeID
		and leafnode.autoid = computerproperties.parentid
		and leafnode.autoid = productproperties.parentid
		and leafnode.parentid = branchnode.autoid
		and dbo.tmpFinalPolicies.productcode = productproperties.productcode
		and productproperties.productcode = aviview_software.productcode
--		and Tasksettings.value > ''
		AND 
		(
			(
				dbo.tmpFinalPolicies.ParentType in (3, 5, 6)
				and
				ReportFullPathNode.LowestNodeID = dbo.tmpFinalPolicies.TaskParentID  -- fix line
				and leafnode.autoid = @NodeID
				and dbo.tmpFinalPolicies.TaskParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType in (4, 7)
				and
				ReportFullPathNode.LowestNodeID = @ParentID
--				and leafnode.autoid = @NodeID
--				and Task.ParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType = 1
				and
				ReportFullPathNode.LowestNodeID = @ParentID
				and dbo.tmpFinalPolicies.TaskParentID = Leafnode.autoid
			)

		)
--		and dbo.tmpFinalPolicies.TaskName > ''
		order by dbo.tmpFinalPolicies.ProductCode, tasktype, taskname, sectionname, settingname

set @ret = @@rowcount

Drop Table  dbo.tmpFinalPolicies
Drop Table  dbo.tmpCompiledPolicies
Drop Table  dbo.tmpTask
Drop Table  dbo.tmpTaskNodeList
Drop Table  dbo.tmpProducts

RETURN @ret
END
GO

-- end

--------------------------------------------------------------------
-- special test procedure: finds saved settings and returns value
-- used in testreporting stored procedure script
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_TestGetSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_TestGetSavedSettings]
GO

CREATE PROCEDURE dbo.AVISP_TestGetSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szOptionFlag	nvarchar(64) = ''  -- PRODUCTGROUP, PRODUPDATEGROUP, INFECTGROUP
	-- outputs
 , @Group1 varchar(50) output
 , @Group2 varchar(50) output
 , @Group3 varchar(50) output
 , @Group4 varchar(50) output
 , @szDrilldown	varchar(20) output
 , @InfectAfterYYYYMMDD varchar(30) output
 , @InfectAfterRule varchar(30) output
 , @ConnectType  varchar(20) output		
 , @ProductType  varchar(20) output
 , @AfterYYYYMMDD varchar(30) output
 , @AfterRule varchar(30) output
 , @szDrilldown1 varchar(30)	output
 , @EventType	varchar(50)	output
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 Declare @legal int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value prompt

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

--select @szOptionFlag as value, @szOptionFlag as prompt
 Set @ret = 0
 Set @legal = 1

 IF @szOptionFlag > ''	-- fetch all setting values for a given name
 BEGIN
	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt= ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFilter
		and ReportInputParametersSaved.ReportID  = @szReportID 

	-- was saved setting found
	set @legal = @@rowcount
	
--select * from ReportInputParameters where ReportInputParameters.ReportID  = @szReportID 

	-- Fetch translated text strings for localized parameter value prompt
	-- problem: need to get translation into reportinputparameter table

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


	-- fetch all parm values that get saved back to the DB and have settingname = @szFilter
	-- read group parms into parmeters
	-- This is used in test script to run the stored procedure for each saved parameter
	select @Group1 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName1'

	select @Group2 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName2'

	select @Group3 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName3'

	select @Group4 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName4'

	if @szReportID = 'PRODUCTGROUP'
	begin
		select @szDrilldown = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown'

		select @InfectAfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterYYYYMMDD'

		select @InfectAfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterRule'

		select @ConnectType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@ConnectType'

		select @ProductType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@ProductType'

	end
	else if @szReportID = 'PRODUPDATEGROUP'
	begin
		select @szDrilldown = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown'

		select @AfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@AfterYYYYMMDD'

		select @AfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@AfterRule'

	end	
	else if @szReportID = 'INFECTGROUP'
	begin
		select @InfectAfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterYYYYMMDD'

		select @InfectAfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterRule'

		select @szDrilldown1 = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown1'

		select @EventType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@EventType'


	end				

 	Set @ret = @@rowcount	
 END	

if @legal = 0
	set @ret = -1

RETURN @ret 
END
GO



--------------------------------------------------------------------
-- special test procedure: finds saved settings and returns value
-- used in testreporting stored procedure script
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Count_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Count_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_Count_Orphaned_Events
AS
BEGIN

DECLARE @cnt int
Set @cnt = 0
DECLARE @cnt1 int
Set @cnt1 = 0

SELECT @cnt = count(Events.AutoID)
FROM dbo.Events
WHERE (dbo.Events.AgentGUID IS NULL) 
OR (dbo.Events.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

Update ProductEvents
Set NodeID = NULL
From Leafnode
WHERE 
 (dbo.ProductEvents.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

SELECT @cnt1 = count(*)
FROM dbo.ProductEvents
WHERE (dbo.ProductEvents.NodeID IS NULL) 

select @cnt + @cnt1 

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_FixUp_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_FixUp_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_FixUp_Orphaned_Events
--(
--	@blockstart int,
--	@blockend int
--)
AS
BEGIN

-- process the productevents table on the first time through
--if exists (select * from Events where %1 <= 1 or %1 = ( select min(autoid) from events ) )
UPDATE ProductEvents
SET ProductEvents.AgentGUID = LeafNode.AgentGUID,
	ProductEvents.NodeID = LeafNode.AutoID
FROM LeafNode, ComputerProperties
WHERE 
	LeafNode.AutoID = ComputerProperties.ParentID
	AND ProductEvents.HostName = ComputerProperties.ComputerName
     AND (ProductEvents.AgentGUID NOT IN 
		(SELECT AgentGUID FROM LeafNode) OR ProductEvents.AgentGUID IS NULL) 
--	 AND (ProductEvents.AutoID >= %1) AND (ProductEvents.AutoID <= %2)

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Remove_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Remove_Events]
GO


CREATE PROCEDURE dbo.AVISP_Util_Remove_Events
(
	@Startdate DateTime,
	@Enddate DateTime
)
AS
BEGIN

-- process the productevents table on the first time through
DELETE FROM ProductEvents WHERE  (EventDateTime >= @Startdate) AND (EventDateTime <= @Enddate)

END
go







-------------------






-- end