------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductSettingIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductSettingIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterProductSettingIssues
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @ReturnGroupSummaryOnly	int=0

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	
	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-----------------------------------------------------------------------------------------------------------
	-- Reset work table
	TRUNCATE TABLE ReportPropertySettingsWork

	INSERT 
		ReportPropertySettingsWork 
	SELECT 
		 ReportPropertySettings.product
		, ReportPropertySettings.productcode
		, ReportPropertySettings.ParmName
		, ReportInputParameters.Prompt
		, ReportInputParameters.PDesc
		, ReportInputParameters.ParmValue
		, ReportPropertySettings.sectionname
		, ReportPropertySettings.settingname
	FROM 
		ReportPropertySettings, ReportInputParameters
	WHERE 
		ReportPropertySettings.ParmName = ReportInputParameters.ParmName
		AND ReportInputParameters.ParmValue > ''


	if @ReturnGroupSummaryOnly > 0
	begin

		SELECT
			 ReportPropertySettingsWork.product
			,  cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			,  cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, count(*) as 'Count'
			, '' as  FullNodePath
			, '' as  ProductCode
		   	, '' as ProductVersion 
		   	, '' as EngineVer 
 		 	 , '' as DATVer 
 		  	, '' as ExtraDATNames 
			, '' as ProductFamily 
			,  '' as  OSVersion
			, '' as DomainName
			, '' as ComputerName
			, '' as IPAddress		
			, '' as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
		GROUP BY
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
			, ReportPropertySettingsWork.PDesc
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname	
			, ReportPropertySettingsWork.ParmValue	
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
	end
	else
	begin

		SELECT
			 ReportPropertySettingsWork.product
			, cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			, cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, 1 as 'Count'
--			, LeafNode.NodeName as NodeNameLeaf
--			, BranchNode.NodeName as NodeNameBranch
			, cast( ReportFullPathNode.FullPathName as varchar(255) ) as FullNodePath
			, AVIView_Software.SoftwareName as ProductCode
		   	, ProductVersion =
    				CASE 
		     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     				ELSE '---' 
		    		END
		   	, EngineVer =
		    		CASE 
		     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
		     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		 	 , DATVer =
 		   		CASE 
 		    		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
  		   		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		  	, ExtraDATNames =
  		  		CASE ProductProperties.ExtraDATNames 
 		    		WHEN 'N/A' THEN '' 
		     		ELSE ProductProperties.ExtraDATNames 
		     		END
			, ProductFamily = 
 			   	CASE 
 			    	WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
  			   	WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
  		 	  	ELSE  AVIView_Software.ProductFamily 
   		 	 	END
			,    cast((ComputerProperties.OSType 
			+ ' ' + ComputerProperties.OSServicePackVer 
			+ ' ' + ComputerProperties.OSPlatform) 
       			as varchar(50)) as OSVersion
			, DomainName
			, ComputerName
			, IPAddress
   			, CONVERT(datetime,
   				(SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
 				  SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
				   SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
				   SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
				   ), 120 )   as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
			, ProductProperties, AVIView_Software
			, LeafNode, ComputerProperties
			, ReportFullPathNode
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
			AND ProductSettings.ParentID = ProductProperties.AutoID
			AND ProductProperties.ProductCode = AVIView_Software.ProductCode
			AND ProductProperties.ParentID = LeafNode.AutoID
			AND LeafNode.ParentID = ReportFullPathNode.LowestNodeID
			AND LeafNode.AutoID = ComputerProperties.ParentID
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName

	end



RETURN @@rowcount
END
GO



--------------------------------------------------------------------------
-- subreport procedures




---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterVAlertsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
--, @szNameSpaceName  VARCHAR(100)
-- ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
--,@szGroup1 varchar(100) = ''
--,@szGroup2 varchar(100) = ''
--,@szGroup3 varchar(100) = ''
--,@szGroup4 varchar(100) = ''
,@NodeID int = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT






 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN ProductVersion
	   		ELSE '---'
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---'
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
  		BranchNode.NodeName AS NodeName 
 
 	FROM 
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
--		Events, 
--             LeafNode, BranchNode, ReportActionDesc 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
    		OR
   		( (VirusName IS NULL OR VirusName = '') 
    		AND (VirusType > '') )
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageID = @szFullLang
   	AND LeafNode.Type !=  24      /* Uninstalled */
 
             AND 
	(	 @NodeID = ''
		OR NodeID = @NodeID
	) 

RETURN @@rowcount
END
GO





---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeErrorEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeErrorEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeErrorEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
--   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	-- for now error events only exist in events table
--	select *
--	from ReportUpdateEvents
--	where NodeID = @NodeID	


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(ProductEvents.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.ProductVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version
	   		ELSE ReportComputerSummary.EngineVer
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.DATVer
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
		,''  As ProductID
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,Type as Type
		,Version as Version
		,Sitename as Sitename
		,InitiatorID as InitiatorID
		,InitiatorType as InitiatorType
		,Error as ErrorID
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as nvarchar(128)) 
			else cast(ProductEvents.Error as nvarchar(128)) 
			end
	FROM 
		ProductEvents Join ReportComputerSummary on (ProductEvents.NodeID = ReportComputerSummary.NodeID
			and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 ) )		
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	--and events.tvdeventid = EventFilterDescFast.eventid
	--and EventFilterDescFast.language = @szLang
--  	and ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
--	and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 )


	UNION



 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(Events.ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
		/*
    			CAST(ActionTaken AS varchar(16)) AS ActionTaken,
    			ActionTaken,
		*/
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType 
	   		ELSE '---'
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		cast( ReportComputerSummary.FullNodePath  AS varchar(256)) AS NodeName,
   		'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		cast( EventFilterDescFast.name AS varchar(128)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szFullLang) 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--  	AND Events.NodeID = ReportComputerSummary.NodeID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
--	and events.tvdeventid *= EventFilterDescFast.eventid		-- outer join, get even if no description
--	and EventFilterDescFast.language = @szLang



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(ReportComputerSummary.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.ProductVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.EngineVer
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.DATVer
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,Type as Type
		,Version as Version
		,Sitename as Sitename
		,InitiatorID as InitiatorID
		,InitiatorType as InitiatorType
		,Error as ErrorID

-- postepo3 33379 - join to ReportUpdateEventDesc and return error desc if its available 
--		,cast(Error as nvarchar(128)) as ErrorDesc
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM
		ProductEvents 
		Join ReportComputerSummary on (ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
			and ProductEvents.NodeID = @NodeID	)
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
--	FROM ProductEvents, ReportComputerSummary, ReportUpdateEventDesc
	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--  	and ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
--	and ProductEvents.NodeID = @NodeID	
--	and ProductEvents.Error = ReportUpdateEventDesc.ErrorID
--	and ReportUpdateEventDesc.LanguageID = @szFullLang


	UNION


 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
			as EventDateTime
    		,CAST(Events.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(UserName AS varchar(32)) AS UserName
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
    		,TVDEventID
    		,CAST(FileName As varchar(255)) As FileName 
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion 
    		,CAST(DATVersion as varchar(16)) As DATVersion 
    		,ScanTime
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END
    		,TVDSeverity
   		,VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END
    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
   		,'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		,cast(EventFilterDescFast.name as nvarchar(256)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szLang) 
		--	Events, ReportComputerSummary, ReportActionDesc, EventFilterDescFast 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
--   	AND Events.ActionTaken = ReportActionDesc.ActionIntID	-- action table lookup
--   	AND ReportActionDesc.LanguageSuffix = @szLang
--	and events.tvdeventid *= EventFilterDescFast.eventid				-- EventFilterDescFast table lookup, outer join to fetch it regardless
--	and EventFilterDescFast.language = @szLang
-- 	AND Events.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
	and Events.NodeID = @NodeID	



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceComparisonSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceComparisonSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterComplianceComparisonSubreport
--(
-- @iNameSpaceName  VARCHAR(20)
-- , @iNameSpaceNode  VARCHAR(20)
-- , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
-- , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime

--)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
/*
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  	-- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   	Declare @szLang VARCHAR(3)
   	Declare @szTime VARCHAR(10)
   	Declare @szFilter VARCHAR(50)
   	Set @szLang = '09'
   	Set @szTime = 'GMT'
	Declare @cnt int

   	if @szOptionalReportParms > ''
   		Execute AVISP_GetReportParms @szOptionalReportParms, @szLang OUTPUT, @szTime OUTPUT, @szFilter OUTPUT
*/



	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	select
	   NewComputers
	 ,   RemovedComputers
	 ,   UnchangedComputers
	 ,   NewInstalls
	 ,   RemovedInstalls
	 ,   NoScanner
	 ,   ExtraDAT
	 ,   NoAgent
	 ,   UnchangedAsci
	 ,   NewAgentVersion
	 ,   NewScannerVersion
	 ,   NewEngineVersion
	 ,   NewDATVersion
	 ,   NewExtradatVersion
	 ,   VirusCount
	 ,   UnresolvedVirusCount
	 ,   MaxVirus
	 ,   MaxUnresolvedVirus
	 ,   MaxVirusCount
	 ,   MaxUnresolvedVirusCount
	 ,   MaxEventid
	 ,  DateTimeEnd
	,   DateTimeStart

	 , NonComplianceAgentVersion 
	 , NonComplianceDAT 
	 , NonComplianceEngine 
	 , NonComplianceProduct
	 , NonComplianceComputer

	,    CountDATMostRecent
	,    CountDAT2ndMostRecent
	,    CountDAT3rdMostRecent
	,    CountDAT4thMostRecent
	,    CountDAT5thMostRecent
	,    CountDATOutOfDate
	,    CountEngineMostRecent
	,    CountEngine2ndMostRecent
	,    CountEngine3rdMostRecent
	,    CountEngineOutOfDate
	,    CountBothUpToDate 
	,    CountDATOutOfDateEngineOK 
	,    CountEngineOutOfDateDATOK 
	,    CountBothOutOfDate 

 	 , MinVersionDAT 
	 , MinVersionEngine 
	 , 	   MinVersionProductMcAfee
	 , 	 	  MinAgentVersion
	 , 	   MinVersionProductSymantec

	,     MinVersionDATMostRecent
	,     MinVersionDAT2ndMostRecent
	,     MinVersionDAT3rdMostRecent
	,     MinVersionDAT4thMostRecent
	,     MinVersionDAT5thMostRecent
	,     MinVersionEngineMostRecent
	,     MinVersionEngine2ndMostRecent
	,     MinVersionEngine3rdMostRecent
	,     ComputersWithVirus



	from
	ReportComplianceComparison

RETURN @@rowcount
END
GO



---------------------------------------------------------
----- Security Summary Report

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterSecuritySummary]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterSecuritySummary]
GO


CREATE PROCEDURE dbo.AVISP_FilterSecuritySummary
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @dtInfectionCheckPoint varchar(64) = ''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

	Declare @ret int  

     -- set default value
     if len(@dtInfectionCheckPoint) < 6
	Set @dtInfectionCheckPoint = '1/1/2000'


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpSecurity' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpSecurity


	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @dtInfectionCheckPoint, '', @InfectYYYYMMDD output

	-- Check if Firewall and Threatscan are installed
	Declare @Firewall int
	Declare @ThreatScan int
	Set @Firewall = 0
	Set @ThreatScan = 0



	-- Scan for Virus data
/*  fetch event data groupings */

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , Events.ProductName as ProductCode
   , cast(Events.ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , VirusName
  , UserName
  , NULL as FileName
  , NULL as VirusType
  , CAST(NULL AS varchar(16)) as ActionTaken
--  , ActionTaken =
--	    		CASE 
-- 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
--	     		END

    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
--  , EventDateTime = 
--		(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--		END) 
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate


 INTO dbo.tmpSecurity
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
		)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	AND Events.EventDateTime > @InfectYYYYMMDD
  		AND VirusName > '' 
   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
       		AND Events.ProductName != 'ePO Agent' 

Group by

   Events.ProductName 
   , Events.ProductVersion 
   , VirusName
   , UserName





	if exists (select * from sysobjects where id = object_id(N'[dbo].[FireIDsEvents]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @Firewall = 1
		
insert 
into dbo.tmpSecurity

SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'Firewall' as ProductCode
   , ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
--  , FireIDsEvents.HostIPAddress
  , 'Firewall' as ProductType
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
--  , FireIDsEvents.AttackDescription
  , FireIDsEvents.HostName as AttackeeHostname
  , count(*) as AttackCount
  , NULL as NewComputers
  , NULL as EventDateTime
--  , EventTime as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate

 FROM FireIDsEvents
 WHERE
	EventTime > @InfectYYYYMMDD

Group by
   ProductVersion
--  , FireIDsEvents.HostIPAddress
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , FireIDsEvents.HostName 


	END



	if exists (select * from sysobjects where id = object_id(N'[dbo].[CCSAudit]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @ThreatScan = 1

insert 
into dbo.tmpSecurity
	SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'ThreatScan' as ProductCode
   , NULL as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'AutoDiscovery' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  ,count(*) as NewComputers
 , cast(max(EventDateTime) as DateTime) as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(max(EventDateTime) as DateTime) as ScanDate
  
	 FROM CCSAutoDiscovery

	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

	Declare @ScanDate DateTime
	select @ScanDate= cast(max(EventDateTime) as DateTime)
	 FROM CCSAutoDiscovery
	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

			
insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSAudit.ProductName as ProductCode
   , CCSAudit.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'Audit' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSAudit.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate

 
 FROM CCSAudit, VulnData

 WHERE
	CCSAudit.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from ccsaudit)
--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSAudit.ProductName
    , CCSAudit.ProductVersion
    , CCSAudit.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 



insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSVirusScan.ProductName as ProductCode
   , CCSVirusScan.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , NULL as VirusName
  , NULL as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'VirusScan' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSVirusScan.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate
 
 FROM CCSVirusScan, VulnData

 WHERE
	CCSVirusScan.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from CCSVirusScan)

--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSVirusScan.ProductName
    , CCSVirusScan.ProductVersion
    , CCSVirusScan.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 


	END


	-- Returned combined data
	SELECT * from dbo.tmpSecurity

	set @ret = @@rowcount

	-- Cleanup
	DROP TABLE dbo.tmpSecurity


RETURN @ret
END
GO



--------------------------------------------------------------
-- actionable item routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeadAgentRemoval]
GO


CREATE PROCEDURE dbo.EPOSP_DeadAgentRemoval
(
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	SET ParentID=@DestID WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateComputerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateComputerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateComputerRemoval
(
@StrNumDays	NVARCHAR(50),	
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpDupComputers' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpDupComputers


	/* Find Duplicate Computers */

	SELECT 
		a.AutoID as AutoID
	INTO
		dbo.tmpDupComputers
	FROM
		LeafNode a, LeafNode b
	WHERE
		a.NodeName = b.NodeName
		and a.AutoID != b.AutoID
		and a.LastUpdate < b.LastUpdate
		and a.LastUpdate is not NULL
		and a.modifiedpropsdate<@TheDate


IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	
		SET ParentID=@DestID 
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END

	Drop Table dbo.tmpDupComputers

SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateScannerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateScannerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateScannerRemoval
(
@Action 	NVARCHAR(50)	-- Values: Delete, Move
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

/*
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)
*/

DECLARE @DestID INT
DECLARE @DirID INT


IF ('Delete'=@Action)
BEGIN
	-- Delete Duplicate Scanners
	delete from productproperties
	where autoid in
		(
		select min(productproperties.AutoID)
		from leafnode, productproperties,  aviview_software
		where leafnode.autoid = productproperties.parentid
		and productproperties.productcode = aviview_software.productcode
		and productfamily in ('tvd', 'tvd_nc')
		and DATVer != '5000'
		and productproperties.productcode != ''
		and aviview_software.productcode not like 'NMDASCAN%'
		and aviview_software.productcode not like 'GroupShield%'
		and aviview_software.productcode not like 'WebShield%'
		group by leafnode.nodename
		having count(*) > 1
		)

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_RemoveDeadInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_RemoveDeadInfo]
GO

CREATE PROCEDURE dbo.EPOSP_RemoveDeadInfo
(
@RuleName 	NVARCHAR(50),	-- Item to remove
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Inactive Agents'=@RuleName)
BEGIN
	EXECUTE EPOSP_DeadAgentRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Computers'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateComputerRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Scanners'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateScannerRemoval
		@Action 	
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END




SET NOCOUNT OFF
END
GO

----------------------------------------------------------------------
----------------------------------------------------------------------
-- Extended nap: Report version compare between server and client
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_CompareReportVersions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_CompareReportVersions]
GO


CREATE PROCEDURE [dbo].[AVISP_CompareReportVersions] 
(
@ProductFamily nvarchar(20)
)
AS
Begin

Declare @ret int

--IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportVersions')
--	drop table ReportVersions

--CREATE TABLE [dbo].[ReportVersions] (
-- [ProductCode] [nvarchar] (50) NOT NULL ,
-- [Path] [nvarchar] (255) NULL ,
-- [FileName] [nvarchar] (255) NOT NULL ,
-- [ServerVersion] [nvarchar] (100) NULL ,
-- [ClientVersion] [nvarchar] (100) NULL ,
-- [DownloadFile] int default(0)
--) ON [PRIMARY]

Truncate Table ReportVersions



Declare @cnt int, @maxfiles int
Set @cnt = 1

-- ServerPolicy version
--Select @maxFiles = max( convert(int, Value) ) 
--	from ServerPolicy, AVIView_Software
--	where ServerPolicy.ProductCode = AVIView_Software.ProductCode
--		and ProductFamily = @ProductFamily
--		and SettingName = 'NumFiles' 

-- Policy, PolicySettings version
Select @maxFiles = max( convert(int, Value) ) 
	from Policy, PolicySettings, AVIView_Software
	where Policy.ProductCode = AVIView_Software.ProductCode
		and Policy.AutoID = PolicySettings.ParentID
		and ProductFamily = @ProductFamily
		and SettingName = 'NumFiles' 


if @maxFiles is null or @maxFiles < 1
	Set @maxfiles = 50 


--select @maxfiles, @cnt

While @cnt <= @MaxFiles
Begin


-- ServerPolicy version
--insert ReportVersions
--select
--a.ProductCode as ProductCode
--, a.Sectionname as Path
--, a.value as 'Filename'
--, b.value as 'ServerVersion'
--, '' as ClientVersion
--, 0 as DownloadFile
--from ServerPolicy as a, ServerPolicy as b, AVIView_Software
--where 
--a.ProductCode = AVIView_Software.ProductCode
--and ProductFamily = @ProductFamily
--and a.sectionname = b.sectionname
--and a.productcode = b.productcode
--and a.autoid != b.autoid
--and a.settingname = 'Filename' + convert( char(2), @cnt) 
--and b.settingname = 'Version' + convert( char(2), @cnt) 


-- Policy, PolicySettings version
insert ReportVersions
select
Policy.ProductCode as ProductCode
, a.Sectionname as Path
, a.value as 'Filename'
, b.value as 'ServerVersion'
, '' as ClientVersion
, 0 as DownloadFile
from Policy, PolicySettings as a, PolicySettings as b, AVIView_Software
where 
Policy.ProductCode = AVIView_Software.ProductCode
and Policy.AutoID = a.ParentID
and Policy.AutoID = b.ParentID
and ProductFamily = @ProductFamily
and a.sectionname = b.sectionname
--and a.productcode = b.productcode
--and a.autoid != b.autoid
and a.settingname = 'Filename' + convert( char(2), @cnt) 
and b.settingname = 'Version' + convert( char(2), @cnt) 


Set @cnt = @cnt + 1

End

--select * from reportversions

-- merge server and client versions

update reportversions
set Clientversion = 
(
select clientversion from ReportVersionsClient
where
ReportVersions.ProductCode = ReportVersionsClient.ProductCode
and ReportVersions.Path = ReportVersionsClient.Path
and ReportVersions.Filename = ReportVersionsClient.Filename
)

/*
select * from reportversions
where serverversion != clientversion
or clientversion is null
*/

select 
ReportVersions.ProductCode,
Path,
Filename,
ServerVersion,
ClientVersion,
(
'insert ReportVersionsClient'
+ ' values( ''' + ReportVersions.ProductCode + ''''
+ ', ''' + Path + ''''
+ ', ''' + Filename + ''''
+ ', ''' + ServerVersion + ''')'

) as Script
from ReportVersions, AVIView_Software
where 
ReportVersions.ProductCode = AVIView_Software.ProductCode
and ProductFamily = 'EPO_REPORTS'
--productcode = 'reportsavi3000'
and path > '' and filename > ''
order by ReportVersions.ProductCode, path, filename

set @ret = @@rowcount

-- Must always truncate the client versions table after using it in this routine
Truncate Table ReportVersionsClient

return @ret
End
GO


--------------------------------------------------------------------
--------------------------------------------------------------------
-- 

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetSavedSettings]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szOptionFlag	nvarchar(64) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value prompt

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

--select @szOptionFlag as value, @szOptionFlag as prompt
 Set @ret = 0

 IF @szOptionFlag = 'FetchAllSettings'	-- fetch all setting values for a given name
 BEGIN
	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt= ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFilter
		and ReportInputParametersSaved.ReportID  = @szReportID 

--select * from ReportInputParameters where ReportInputParameters.ReportID  = @szReportID 

	-- Fetch translated text strings for localized parameter value prompt
	-- problem: need to get translation into reportinputparameter table

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


	-- fetch all parm values that get saved back to the DB and have settingname = @szFilter	
	Select  ParmValue as Value
		, Prompt as Prompt
		, ParmName as Name
		, ParmValuePrompt as ValuePrompt
	From ReportInputParameters 
	Where ReportID = @szReportID 
--		and ReportSavedSettingsName = @szFilter	
		and iSaveUserEntry = 1		

 	Set @ret = @@rowcount	
 END	
 ELSE
 BEGIN
	Declare @cnt int
	select @cnt=count(*) From ReportInputParametersSaved 
		Where ReportID = @szReportID 

	IF @@rowcount > 0
	BEGIN
		Select distinct(ReportSavedSettingsName) as Value
			, PDesc as Prompt
		From ReportInputParametersSaved 
		Where ReportID = @szReportID 
 		Set @ret = @@rowcount
	END
	ELSE
		SELECT '---' as Value , '---' as Prompt

END


 RETURN @ret 


END

GO



-----------------------------------------------------
-----------------------------------------------------
--

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutSavedSettings]
GO



CREATE PROCEDURE dbo.AVISP_FieldPutSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szFieldName		VARCHAR(64) = '',
    @szFieldValue		VARCHAR(256) = '',
    @szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''
   Declare @cnt int

   Declare @ret int
   set @ret=0

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- second column must to be called: Prompt

 IF @szFieldName = 'SaveSettingsVar' or @szFieldName = 'SaveSettingsAs'
 BEGIN 

 	Select @cnt = count(*)
	FROM	ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	-- save current settings into saved name

	IF @cnt > 0
	BEGIN	
	 	UPDATE
			ReportInputParametersSaved
		SET
			ReportInputParametersSaved.ParmValue = ReportInputParameters.ParmValue
			, ReportInputParametersSaved.ParmValuePrompt = ReportInputParameters.ParmValuePrompt
			, ReportInputParametersSaved.Prompt= ReportInputParameters.Prompt
		FROM	
			ReportInputParameters
		WHERE
			ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
			and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
			and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameterssaved.iSaveUserEntry = 1
			and ReportInputParametersSaved.ReportID  = @szReportID 
        END
	ELSE     -- do insert if not there
	BEGIN
		Update ReportInputParameters
		Set ReportInputParameters.ReportSavedSettingsName = @szFieldValue
		Where
			ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Insert  ReportInputParametersSaved
		( ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, PDesc)
		Select ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, ReportSavedSettingsName
			from ReportInputParameters
			WHERE
			ReportInputParameters.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Update ReportInputParameters
		Set ReportSavedSettingsName = ''
		Where
			ReportID  = @szReportID 
			and iSaveUserEntry = 1

		-- postepo3 change SaveSettings to SaveSettingsVar
		delete ReportInputParametersSaved
		where ParmName in ('SaveSettingsVar','SaveSettingsAs','RestoreSettings','DeleteSettings')


	END

	set @ret = @@rowcount	


 END
 ELSE IF @szFieldName = 'RestoreSettings'
 BEGIN

	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt = ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.iSaveUserEntry = 1
		and ReportInputParametersSaved.ReportID  = @szReportID 

	-- postepo3: fix save settings not saving issue
	-- Set name of open settings in open and save fields
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= @szFieldValue
	WHERE	
		ReportInputParameters.ReportID  = @szReportID 
		and ReportInputParameters.ParmName in ('RestoreSettings', 'SaveSettingsVar')

	set @ret = @@rowcount	

 END
 ELSE IF @szFieldName = 'DeleteSettings'
 BEGIN

 	DELETE
		ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	set @ret = @@rowcount	
 END


 -- Return Result String
 SELECT @szResult as szResult


 RETURN @ret

END
GO



-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-- mhilandepo3 - Customization lookup routines - one per cust screen not one per field


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Events]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Events
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
		where EventDateTime > ''
--		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			AND
				(ReportActionDesc.LanguageID = @szFullLang 
				or
				ReportActionDesc.LanguageID = @szFullLang )

   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
            and DomainName > ''
   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 

   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostIPAddress' OR @szFilter = 'HostAddr'
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND Events.NodeID = LeafNode.AutoID
	 and hostipaddress > ''
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
	 SELECT DISTINCT DATVersion as Value 
	 FROM Events
	 WHERE Events.DATVersion > ''
	 ORDER BY DATVersion desc
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
	 SELECT DISTINCT EngineVersion as Value 
	 FROM Events
	 WHERE Events.EngineVersion > ''
	 ORDER BY EngineVersion desc
   end

   else if @szFilter = 'EventID' or @szFilter = 'TVDEventID'
   begin
	 SELECT DISTINCT cast(TVDEventID as varchar(10)) as Value 
	 FROM Events
	 where tvdeventid > ''
   end

   else if @szFilter = 'TVDTaskName'
   begin
	 SELECT DISTINCT TVDTaskName as Value 
	 FROM Events
	 WHERE Events.TVDTaskName > ''
	 ORDER BY TVDTaskName desc
   end


   else if @szFilter = 'FileName'
   begin
	-- postepo3 Top 10 files report return the rightmost postion of the filename
	if @szReportID = 'T10FILE' or @szReportID = 'RESOLVED' or @szReportID = 'UNRESOLVED'
	begin
	 SELECT DISTINCT right(Events.FileName,15) as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and filename > ''
	end
	else
	begin
	 SELECT DISTINCT FileName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and filename > ''
	end
   end

   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and hostname > ''
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT ProductName as Value 
	 FROM Events
	 WHERE ProductName NOT LIKE '%Agent%'
	 and productname > ''
   end

   else if @szFilter = 'ProductVersion'
   begin
	 	SELECT DISTINCT ProductVersion as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and productversion > ''
   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (Events.ProductName + ' ' + Events.ProductVersion) > ''
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
 		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (EngineVersion + ' ' +  DATVersion) > ''
   end


   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and username > ''
   end

   else if @szFilter = 'VirusName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE Events.VirusName > ''
   end


   else if @szFilter = 'VirusSubtype'
   begin
	 SELECT DISTINCT 
		VirusType.VirusFileType as Value
	 FROM 
		VirusType
--		Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
--				and VirusType.VirusName > '')

   end

   else if @szFilter = 'VirusType'
   begin
	-- Check if VirusType table needs translating and redo it if language differs
	-- virustype table only stores one language at a time (it dynamically translates to the language you need)
	EXECUTE AVISP_TranslateVirusType @szFullLang

	 SELECT DISTINCT 
		case 
		when VirusType.VirusTypeTranslated > '' then VirusType.VirusTypeTranslated
		when Events.VirusType > '' then Events.VirusType
		else Events.VirusType
		end  as Value 
	 FROM 
		Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
				and VirusType.VirusName > '')
--	 WHERE 
--		Events.VirusName *= VirusType.VirusName
--		and VirusType.VirusName > ''
   end

   else if @szFilter = 'TVDSeverity'
   begin
	 SELECT DISTINCT EventFilterDescFast.Severity as Value 
	 FROM EventFilterDescFast
	 WHERE Language = @szFullLang
	 and name > ''
	 Order By EventFilterDescFast.Severity
   end

   else if @szFilter = 'EventDesc'
   begin
	 SELECT DISTINCT EventFilterDescFast.Name as Value 
	 FROM EventFilterDescFast
	 WHERE Language = @szFullLang
	 and name > ''
	 Order By EventFilterDescFast.Name
   end

   -- webshield entries
   else if @szFilter = 'RuleName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusName
   end

   else if @szFilter = 'RuleType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusType
   end

   else if @szFilter = 'Server'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By HostName
   end

   else if @szFilter = 'AffectedArea'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType not in ('spam', 'deny-spam')
	 Order By Filename
   end

   else if @szFilter = 'SpamSource'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @@rowcount
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Webshield]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Webshield]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Webshield
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
--		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			And TVDEventID in (1506, 4600)
			AND
				(ReportActionDesc.LanguageID = @szFullLang 
				or
				ReportActionDesc.LanguageID = @szFullLang )

   end

--   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
--   begin
--	 SELECT DISTINCT ActionTaken as Value 
--	 FROM Events
--	 WHERE TVDEventID in (1506, 4600)
--	 Order By ActionTaken
--   end


   -- webshield entries
   -- RuleName
   else if @szFilter = 'VirusName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusName
   end

   -- rule type
   else if @szFilter = 'VirusType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusType
   end

   -- server
   else if @szFilter = 'HostName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostName
   end

   -- affected area
--   else if @szFilter = 'Filename'
--   begin
--	 SELECT DISTINCT Filename as Value 
--	 FROM Events
--	 WHERE TVDEventID = 1506
--		and VirusType not in ('spam', 'deny-spam')
--	 Order By Filename
--   end

   -- SpamSource
   else if @szFilter = 'Filename'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   -- email source
   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
--		and VirusType in ('spam', 'deny-spam')
	 Order By UserName
   end

   -- IP Address
   else if @szFilter = 'IPAddress' or @szFilter = 'HostIPAddress' 
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostIPAddress
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @@rowcount
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_UpdateEvents]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_UpdateEvents]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_UpdateEvents
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From ProductEvents
--		Order by Value Desc		
	Set @ret = @@ROWCOUNT
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From ProductEvents
--		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM ProductEvents, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ProductEvents.AgentGUID = LeafNode.AgentGUID
	 and hostname > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareName as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > ''  
   	Set @ret = @@ROWCOUNT
   end

   -- gets if from software view not productproperty table
   else if @szFilter = 'ProductVersion' 
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareVersion as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > ''  
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''	 
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		  as Value 
	       FROM AVIView_Software
	       WHERE 
		 (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and (AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Version'
   begin
	    	SELECT DISTINCT ProductEvents.Version as Value 
		       	FROM ProductEvents
			where version > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Type'
   begin
	    	SELECT DISTINCT ProductEvents.Type as Value 
		       	FROM ProductEvents
			where type > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorDesc'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Description) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorType'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Name) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Error'
   begin
	    	SELECT DISTINCT convert(varchar(50), ProductEvents.Error) as Value 
		       	FROM ProductEvents
			where ProductEvents.Error > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
	    	SELECT DISTINCT ProductEvents.Locale as Value 
		       	FROM ProductEvents
			where locale > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'SiteName'
   begin
	    	SELECT DISTINCT ProductEvents.SiteName as Value 
		       	FROM ProductEvents
			where sitename > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorID'
   begin
	    	SELECT DISTINCT ProductEvents.InitiatorID as Value 
		       	FROM ProductEvents
			where initiatorid > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorType'
   begin
	    	SELECT DISTINCT ProductEvents.InitiatorType as Value 
		       	FROM ProductEvents
			where initiatortype > ''

   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   	Set @ret = @@ROWCOUNT
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Properties]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Properties]
GO

CREATE PROCEDURE dbo.AVISP_GetCust_Properties
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT






   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   if @szFilter = 'Day' 
   begin
	-- postepo3 - for prop day cust append -000000 to the end
	SELECT DISTINCT
		substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) + '-000000'
		as Value
		From LeafNode
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end


   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
		and ProductProperties.ProductVersion != '5000'
    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
 	SELECT DISTINCT ProductProperties.DATVer as Value 
    	FROM ProductProperties, AVIView_Software
    	WHERE 
 		ProductProperties.ProductCode = AVIView_Software.ProductCode
 		and ProductProperties.DATVer > ''
 		and ProductProperties.DATVer != '5000'
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
    	SELECT DISTINCT ProductProperties.EngineVer as Value 
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
          	and ProductProperties.EngineVer > ''
          	and ProductProperties.EngineVer != '5000'
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'ComputerName' OR @szFilter = 'HostName'
   begin
	 SELECT DISTINCT ComputerProperties.ComputerName as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and computername > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
 	SELECT DISTINCT 
	   Value = 
		CASE
		   WHEN LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
		   ELSE ProductProperties.Language
		   END
	   FROM 
		ProductProperties Left Outer Join LanguageDesc on (
			RIGHT( ProductProperties.Language, 2 )  =  LanguageDesc.ClientLanguageSuffix)
--			AND LanguageDesc.epoServerLanguageSuffix = @szLang 
--			and productproperties.language > '')
   	   WHERE 
-- 		RIGHT( ProductProperties.Language, 2 )  *=  LanguageDesc.ClientLanguageSuffix
--		AND 
		LanguageDesc.epoServerLanguageID = @szFullLang 
		and productproperties.language > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'SoftwareName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT AVIView_Software.SoftwareName as Value 
	    FROM ProductProperties, AVIView_Software
	    WHERE 
		ProductProperties.ProductCode = AVIView_Software.ProductCode 
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and softwarename > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductVersion'
   begin
	    SELECT DISTINCT ProductProperties.ProductVersion as Value 
		INTO #TmpProdVer	
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and productversion > ''
			and productversion != '5000'


	-- special case processing, remove virusscan wrk and svr suffix from product version)
	-- special case processing, remove virusscan wrk and svr suffix from product version)
	Insert #TmpProdVer select Value = Replace(Value, '.wrk', '') from #TmpProdVer
	Insert #TmpProdVer Select Value = Replace(Value, '.srv', '') from #TmpProdVer

	Select distinct Value from #TmpProdVer
	ORDER BY Value desc	

	Drop Table #TmpProdVer

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ServicePack'
   begin
	    SELECT DISTINCT ProductProperties.ServicePack as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and servicepack > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Hotfix'
   begin
	    SELECT DISTINCT ProductProperties.Hotfix as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and hotfix > ''

   	Set @ret = @@ROWCOUNT
   end

--   else if @szFilter = 'LicenseStatus'
--   begin
--	    SELECT DISTINCT ProductProperties.LicenseStatus as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

--   else if @szFilter = 'ExpirationDate'
--   begin
--	    SELECT DISTINCT SubString(ProductProperties.ExpirationDate,1,6) as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

   else if @szFilter = 'LastContact' or @szFilter = 'LastAsci'
   begin
	    SELECT DISTINCT SubString(LeafNode.LastUpdate,1,8) as Value 
	       FROM Leafnode
		where SubString(LeafNode.LastUpdate,1,8) > ''
		order by Value desc
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ExtraDATNames'
   begin
	    SELECT DISTINCT ProductProperties.ExtraDATNames as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		    and ProductProperties.ExtraDATNames != 'N/A'
			and extradatnames > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentType'
   begin
	IF Exists (select * from ReportTranslations where LanguageID = @szFullLang and Subject = 'AgentType')
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = @szFullLang
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End
	else
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = '0409'
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End


--	 SELECT  'Agent' as Value
--	 UNION SELECT 'Super Agent Broadcast' as Value
--	 UNION SELECT 'Super Agent Repository' as Value
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct OSPlatform as Value
	 from ComputerProperties
	 where osplatform > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'FullProductName'
   begin

	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software, leafnode
	       WHERE 
	       (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	       ) and
		    leafnode.autoid = productproperties.parentid
		    and ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) > ''	
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DatExtraDat'
   begin
	    SELECT DISTINCT cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50))		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   end


Return @ret
END
GO



---------------------------------------------------------------------------
-- Report group procedures - allows users to select there own report groupings
--	Fetches group summaries initially, gets details within separate subreport procedure
--	3 reports:
--	InfectionsByUserGroups
--	ProductsByUserGroups
--	UpdateEventsByUserGroups



--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
------------------
-- Custom data group procedures: Product ProductEvent Infection


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductGroups]
GO






CREATE PROCEDURE dbo.AVISP_FilterProductGroups
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = ''
 , @ConnectType  varchar(20)='Current'		-- All, Current, Late
 , @ProductType  varchar(20)='AntiVirus'	-- AntiVirus, Security, Agent, All
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYY_MM_DD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')
	set @YYYY_MM_DD = convert(char(30), @YYYYMMDDdate,120)

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
--		Select 	@Agent = TranslatedValue from ReportTranslations 
--			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'Agent'
		Set @Agent = 'Agent'		-- last minute localization bug, too late to retranslate
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	
	

   

   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
	and lower(@szGroupName1) <> 'connectstatus' 
	and lower(@szGroupName2) <> 'connectstatus' 
	and lower(@szGroupName3) <> 'connectstatus' 
	and lower(@szGroupName4) <> 'connectstatus' 
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month' -- yyyy-mm
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
   			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,cast(@ConnectType as varchar(30)) as ConnectStatus

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields


--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--    		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM 	
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
	   	 )
	)
	left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID))
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	    	)   
	)
	left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	)
	on( leafnode.autoid = productproperties.parentid )

-- this join doesnt catch unprotected and noagents	
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--  	left outer Join ProductProperties on(leafnode.autoid = productproperties.parentid)
--   	Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode)
--	left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
--			and LanguageDesc.epoServerLanguageID = @szFullLang)	

 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
   	AND LeafNode.Type !=24      /* Uninstalled */ 
--	and  LeafNode.LastUpdate > @YYYYMMDD


	Group By
		BranchNode.NodeName
		,DATVer
		, substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName



 
   end

   -- This is used when you are doing a fast with grouping on connectstatus (late or current)
   else
   if lower(@szDrilldown) = 'fast' 
	and ( lower(@szGroupName1) = 'connectstatus' 
		or lower(@szGroupName2) = 'connectstatus' 
		or lower(@szGroupName3) = 'connectstatus' 
		or lower(@szGroupName4) = 'connectstatus' )
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		,cast('' as varchar(16)) as 'Day'
--		, '' as 'Hour'


   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Current
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields

--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType

 	FROM 		
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		and  LeafNode.LastUpdate  >=  @YYYYMMDD  
	   	AND LeafNode.Type !=24      /* Uninstalled */ 
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )
		) -- fetch only current computers
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	    )   
	)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid 	)
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

--	and  LeafNode.LastUpdate > ''


	Group By
		BranchNode.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName

   Union All

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		,cast('' as varchar(16)) as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, '' as Language
--		, cast( ProductProperties.Language as varchar(10)) as Language
   		, Language =
   			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Late
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
--		,'' as LNAutoID
--		,'' as LNParentID
--		,'' as PPAutoID
		-- End of Group summary difference fields

--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM 		
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
		AND LeafNode.Type !=24      /* Uninstalled */ 
		and  (LeafNode.LastUpdate  <  @YYYYMMDD  -- fetch only late computers
			or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null )  -- fecthes no agents
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )   
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

	Group By
		BranchNode.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
		,LanguageDesc.LanguageName
 

   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin

 	SELECT   

		'' as 'Year'
		,'' as 'Month'	-- yrmo
		,'' as 'Week'
		,'' as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,''  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
--		, ProductProperties.Language as Language
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		 as FullProductName
	      ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		, case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			when LeafNode.LastUpdate  >=  @YYYYMMDD then @Current
			when LeafNode.LastUpdate  <  @YYYYMMDD  and LeafNode.LastUpdate  > '1/1/1980'  then @Late
			else @NoAgent
			end 	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

--		postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	   	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as HostName
--		, ComputerProperties.Computername as HostName

		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
--		, cast( '' as varchar(10)) as FullNodeName
   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, Productproperties.ProductCode as  ProductCode
		, LeafNode.autoid as NodeID
--		, NodeID
--		, LeafNode.autoid as LNAutoID
--		, LeafNode.parentid as LNParentID
--		, ProductProperties.autoid as PPAutoID

		-- End of Group summary difference fields


--		, '' as VirusName
--		, '' as VirusType
--		, '' as VirusSubtype
--		, '' as ActionTaken
--		, '' as TVDEventID
--		, '' as TVDSeverity
--		, '' as TVDTaskName
--   		, '' as ScanTime 
--		, '' as EventDesc
		
--		, '' as RuleName

--		, '' as Type 
--		, '' as Version
--		, '' as Error
--		, '' as SiteName
--		, '' as InitiatorID
--		, '' as InitiatorType


 	FROM
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
	   	AND LeafNode.Type !=24      /* Uninstalled */ 
		and ( @YYYYMMDD is null  or @ConnectType = 'All' 
		or
		( 
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '' )
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '' )
		)	
	       )
	
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )   
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )

 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--             AND ProductProperties.ParentID = LeafNode.AutoID 
--   	and ProductProperties.ProductCode = AVIView_Software.ProductCode
--   	AND LeafNode.ParentID = BranchNode.AutoID
--	AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   	AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   	AND LanguageDesc.epoServerLanguageSuffix = @szLang




   end
	
RETURN @@rowcount
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductEventGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductEventGroups]
GO


CREATE PROCEDURE dbo.AVISP_FilterProductEventGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @AfterYYYYMMDD varchar(30) = ''
 , @AfterRule varchar(30) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 Declare @ret int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 -- determine what node tree filter this user has: either tied to their account or by the user setting a report filter
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node
-- Truncate Table ReportLostProductEventLinks
-- Insert ReportLostProductEventLinks (NodeID)
-- select distinct NodeID
-- from ProductEvents
--	where NodeID not in (select AutoID from leafnode)
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

   -- Fetch Infect After date variables
   Declare @YYYYMMDD datetime
   execute dbo.AVISP_GetDateConversion @AfterYYYYMMDD, @AfterRule, @YYYYMMDD output

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)	

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	

	


   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
   begin

 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
--      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
--			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
--			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, '' as NodeID
--		, NodeID
		,'' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)
--   		ProductEvents, AVIView_Software
--		,LeafNode, BranchNode, ComputerProperties 	--ProductProperties, LanguageDesc, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')	-- remove this, want to see all eents from all products 
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--   	AND LeafNode.Type !=24      -- remove this, want to see all events 
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)

	Group By
		-- postepo3 - optimize group by ordering
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		, substring(Leafnode.LastUpdate, 1, 4) 
--		, substring(Leafnode.LastUpdate, 5, 2) 
		, AVIView_Software.SoftwareVersion
   		, AVIView_Software.SoftwareName
--   		, AVIView_Software.SoftwareVersion 
  		,BranchNode.NodeName 
  		,ComputerProperties.DomainName
--		, ProductProperties.EngineVer
--		, ProductProperties.DATVer
 		, cast( ProductEvents.AgentVersion as nvarchar(50)) 
 		, cast( ProductName as nvarchar(50))
  		, cast( ProductEvents.ProductCode as nvarchar(50)) 
 		, cast( ProductEvents.Type as nvarchar(50)) 
 		, cast( Version as nvarchar(50)) 
 		, ProductEvents.Error
 		, cast( Locale as nvarchar(50)) 
 		, cast( SiteName as nvarchar(100)) 
 		, cast( InitiatorID as nvarchar(50)) 
 		, cast( InitiatorType as nvarchar(50)) 
		, ReportUpdateEventDesc.Description
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform




   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin


 	SELECT   


		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
--      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
--			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
--			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

    		,(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

		, case
			when ComputerProperties.Computername > '' then ComputerProperties.Computername
			when LeafNode.NodeName > '' then LeafNode.NodeName
			else @Unlinked
			end as HostName
		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
   		, cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, LeafNode.autoid as NodeID
--		, NodeID
		,LeafNode.autoid as LNAutoID
		,LeafNode.parentid as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)

--   		ProductEvents, AVIView_Software
--             		,LeafNode, BranchNode, ComputerProperties, ReportFullPathNode  -- LanguageDesc, ProductProperties, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  -- want to see all events
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--	AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   	AND LeafNode.Type !=24      -- want to see all events
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)




   end
	set @ret = @@rowcount
--	Drop Table #LostLinks	
RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroups]
GO



CREATE PROCEDURE dbo.AVISP_FilterVAlertGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)=''	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @ret int

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

--------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpTop10s' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10s

	IF EXISTS (select * from sysobjects where name = 'tmpTop10Virus' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10Virus


	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')

	if @InfectAfterRule = 'all' and ( @InfectAfterYYYYMMDD = '' or @InfectAfterYYYYMMDD is null )
	begin
		set @YYYYMMDDdate = null
		set @YYYYMMDD = ''
	end

--select @YYYYMMDDdate
	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- Check if VirusType table needs translating and redo it if language differs
	EXECUTE AVISP_TranslateVirusType @szFullLang


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)		
   	Declare @Uncategorized varchar(50)		
	Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)


	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Uncategorized = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'VirusType' and TextID = 'Uncategorized'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	

	


--------------------------------------------------------
--------------------------------------------------------
  -- lookup top 10 items if applicable
  -- look for top 10 (T10) suffix in eventtype
  -- Only do this if no data filter has been set

	Declare @Top10 varchar(20)
	Set @Top10 = ''
	Create table dbo.tmpTop10s 
	(
		Value varchar(255)
	)
	Create table dbo.tmpTop10Virus 
	(
		Virusname varchar(255)
		,Virustype varchar(255)
	)

	if substring(@EventType, 1, 5) = 'T10Vr'  
	begin
		Set @Top10 = 'T10Vr'
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	
		if @DataFilter = 'none'		-- Do only if no data filter
		begin
	
		Update VirusType Set Top10 = 0

		Insert dbo.tmpTop10Virus
		Select Top 10 VirusName, max(Virustype) as Virustype
		  From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
--			LeafNode Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--				and ReportActionDesc.LanguageID = @szFullLang)
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
				) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
				AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by VirusName
		order by count(*) desc		
		

		-- insert any missing virus
		insert virustype
 		( VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID, Top10 )
		Select
			dbo.tmpTop10Virus.VirusName, '', '', dbo.tmpTop10Virus.VirusType, dbo.tmpTop10Virus.VirusType, '0409', 1
		From 
			dbo.tmpTop10Virus
		Where
			 dbo.tmpTop10Virus.VirusName not in (select virusname from virustype )


		-- mark the top 10 viruses
		Update VirusType
		Set Top10 = 1
		Where VirusName in ( select virusname from dbo.tmpTop10Virus )
	
		end
	end
	else if substring(@EventType, 1, 5) = 'T10Fl'  
	begin
		Set @Top10 = 'T10Fl'
		Set @EventType = Replace( @EventType, 'T10Fl', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 right(FileName, 15)
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by right(FileName,15)
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Ur'  
	begin
		Set @Top10 = 'T10Ur'
		Set @EventType = Replace( @EventType, 'T10Ur', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 UserName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by UserName
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Cp'  
	begin
		Set @Top10 = 'T10Cp'
		Set @EventType = Replace( @EventType, 'T10Cp', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 HostName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang			)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by HostName
		order by count(*) desc		

		end
	end

-- test
--select * from ReportTop10Items

--------------------------------------------------------------------------------------------------
-- Read Data Filter and Group Selections to see which query option to pick for fastest performance
--	must group on fields that are part of the Group selections or Data filter 

	-- merge group fields into one to simplify processing
	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	-- Check for key fields that affect which query to run
	Declare @Nodename int
	Set @Nodename = CHARINDEX( 'NodeName', @GroupFields)	
	if @Nodename = 0 	Set @Nodename = CHARINDEX( 'NodeName', @DataFilter)	

	Declare @Domainname int
	Set @Domainname = CHARINDEX( 'Domainname', @GroupFields)	
	if @Domainname = 0 	Set @Domainname = CHARINDEX( 'Domainname', @DataFilter)	

	Declare @OSType int
	Set @OSType = CHARINDEX( 'OSType', @GroupFields)	
	if @OSType = 0 	Set @OSType = CHARINDEX( 'OSType', @DataFilter)	

	Declare @OSPlatform int
	Set @OSPlatform = CHARINDEX( 'OSPlatform', @GroupFields)	
	if @OSPlatform = 0 	Set @OSPlatform = CHARINDEX( 'OSPlatform', @DataFilter)	

	Declare @Virustype int
	Set @Virustype = CHARINDEX( 'Virustype', @GroupFields)	
	if @Virustype = 0 	Set @Virustype = CHARINDEX( 'Virustype', @DataFilter)	

	Declare @VirusSubtype int
	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @GroupFields)	
	if @VirusSubtype = 0 	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @DataFilter)	
        if @VirusSubtype > 0    Set @Virustype=1

	Declare @ActionTaken int
	Set @ActionTaken = CHARINDEX( 'Action', @GroupFields)	
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'ActionTaken', @DataFilter)	
	-- special case code: infection history reports do a chart on action, so make sure a query returning action
	--	is performed
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSVIRUSDETAIL', @szOptionalReportParms)
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSINFECTHIST', @szOptionalReportParms)


	Declare @TVDEventID int
	Set @TVDEventID = CHARINDEX( 'TVDEventID', @GroupFields)	
	if @TVDEventID = 0 	Set @TVDEventID = CHARINDEX( 'TVDEventID', @DataFilter)	

	Declare @TVDSeverity int
	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @GroupFields)	
	if @TVDSeverity = 0 	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @DataFilter)	

	Declare @EventDesc int
	Set @EventDesc = CHARINDEX( 'EventDesc', @GroupFields)	
	if @EventDesc = 0 	Set @EventDesc = CHARINDEX( 'EventDesc', @DataFilter)	

	Declare @Year int
	Set @Year = CHARINDEX( 'Year', @GroupFields)	
	if @Year = 0 	Set @Year = CHARINDEX( 'Year', @DataFilter)	

	Declare @Quarter int
	Set @Quarter = CHARINDEX( 'Quarter', @GroupFields)	
	if @Quarter = 0 	Set @Quarter = CHARINDEX( 'Quarter', @DataFilter)	

	Declare @Week int
	Set @Week = CHARINDEX( 'Week', @GroupFields)	
	if @Week = 0 	Set @Week = CHARINDEX( 'Week', @DataFilter)	

	Declare @Month int
	Set @Month = CHARINDEX( 'Month', @GroupFields)	
	if @Month = 0 	Set @Month = CHARINDEX( 'Month', @DataFilter)	

	Declare @DATVer int
	Set @DATVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @DATVer = 0 	Set @DATVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @ENGVer int
	Set @ENGVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @ENGVer = 0 	Set @ENGVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @TaskName int
	Set @TaskName = CHARINDEX( 'TVDTaskName', @GroupFields)	
	if @TaskName = 0 	Set @TaskName = CHARINDEX( 'TVDTaskName', @DataFilter)	

	-- sum these fields into categories
	Declare @Time int
	Set @Time = @Year + @Month + @Quarter + @Week

	Declare @EventInfo int
	Set @EventInfo = @EventDesc + @TVDEventID + @TVDSeverity

	Declare @VirustypeAction int
	Set @VirustypeAction = @Virustype + @ActionTaken + @VirusSubtype

	Declare @LeafInfo int
	Set @LeafInfo = @Nodename + @Domainname + @OSType + @OSPlatform + @TaskName + @DATVer + @ENGVer

-- test
--select @szDrilldown1 as Drilldown, @EventType as Eventtype
--	, @DataFilter as Datafilter, @GroupFields as Groupfields
--	, @Time as 'Timegroups', @EventInfo as Eventinfo, @VirustypeAction as VTaction, @Leafinfo as Leafinfo
--	, @Top10 as Top10



-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-- The actual query to run is selected based off the data filter, grouping fields, layout option and
--	Event type of this report. Trying to do the minimum work possible to improve performance.

   -------------------------------------------------------------------------------
   -- 1. Fast group summary fetch (subreport fetches detailed rows)
   -- No grouping on time fields (good performance boost)
   -- No joins, no grouping on time fields 
   -- Doesnt join: virustype, action, leafnode, EventFilterDescFast

   if lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' )
	and @DataFilter <> 'Inactive'
	and ( @Time = 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
   begin


 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' ExtraDATNames
		,'' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, '' as LastContact

		, '' as HostName
		, '' as UserName
--		,  Events.UserName
		, '' HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '1' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' 
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 1.5 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on 
   -- Joins action tables
   -- Doesnt join virustype or leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken > 0 and @Virustype = 0 
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '2' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 2. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields
   -- No joins
   -- Doesnt join: virustype, action, leafnode, EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' )
	-- postepo3 - these must be executed when data filter not set
	and @DataFilter <> 'Inactive'
	and ( @Time > 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
--		'' as Year
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,'' as Week
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		,'' as Quarter
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' as EngineVersion
    		,'' As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
--		, cast( '2' as varchar(10)) as Language
		,'' as ExtraDATNames
		,'2' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, cast('' as varchar(50)) as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '3' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
--		, TVDTaskName
--		,EngineVersion
		,ProductName
		,ProductVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields, actions
   -- Joins action tables
   -- Doesnt join virustype or leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 
		and @Virustype= 0 and @ActionTaken > 0 and @Virustype = 0 
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '4' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time fields, virustype, actions
   -- Joins virustype and action tables
   -- Doesnt join leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 and @Virustype > 0 and @ActionTaken >= 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
 --   		,CAST(DATVersion as varchar(16)) As DATVersion
    		,CAST('' as varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, CAST('' as varchar(50)) as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, ''  as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--	ReportComputerJoinData
--	Right Outer Join Events on(ReportComputerJoinData.autoID = Events.NodeID)	
--	Events
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Events
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)

 	 	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--  	           AND Events.ProductName != 'ePO Agent' 

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end

   -------------------------------------------------------------------------------
   -- 3.6. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, coverage tables
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken = 0 and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.6' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5.3' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then @Informational
--			when 1 then @Warning
--			when 2 then @Minor
--			when 3 then @Major
--			when 4 then @Critical
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
--	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
--	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		
--		,ReportActionDesc.ActionName
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end

   -------------------------------------------------------------------------------
   -- 3.7. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, actions, coverage tables
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.7' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '5.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end


   -------------------------------------------------------------------------------
   -- 4. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on time fields, virustype, actions, coverage tables
   -- Joins virustype, action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo > 0 and @EventInfo = 0 )
-- postepo3 - if fast and data filter, then use this unless grouping by eventdesc
		or ( @DataFilter <> 'none' and @EventInfo = 0 ) -- if data filter do this
	)
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '6' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end


   -------------------------------------------------------------------------------
   -- 4.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	( 
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo > 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		,'' as NodeName
		,'' as Domainname
		,'' as OSType
		,'' as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '6.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else cast(Events.TVDSeverity as varchar(30))
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 

	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
--	Left Outer Join (
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,BranchNode.NodeName
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity



   end

   -------------------------------------------------------------------------------
   -- 5. Fast group catchall (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	(
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo >= 0 and @EventInfo >= 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '5f' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '7' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else cast(Events.TVDSeverity as varchar(30))
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 

	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
	Left Outer Join (
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity



   end

   -- LAYOUT=DRILLDOWNSECTION
   --------------------------------------------------
   -- 6.0.0. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		( @Time = 0 and @VirusType = 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
--		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( '8fs' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,VirusType as VirusType
		, '' as VirusSubtype
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
--		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
--    		,  case 
--			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,TVDEventID as EventDesc
		
--		, '' as RuleName

		-- Product update fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   --------------------------------------------------
   -- 6. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable'
   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( '8' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--		,'' as VirusType
--		, '' as VirusSubtype
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else cast(Events.TVDSeverity as varchar(30))
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,TVDEventID as EventDesc
		
--		, '' as RuleName

		-- Product update fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   -- top10section 
   ------------------------------------------------------------------------
   -- 7. Fast (group summary) Fetch, top 10 virus
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '9' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join VirusType on (Events.VirusName = VirusType.VirusName )
	--			and Top10 =1 
	--		)  -- dont do top 10 join
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
		Events.VirusName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- postepo3
   -- 7.5 Fast (group summary) Fetch, top 10 virus with no data filter
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7.5tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
--			= CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( '9.1' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join VirusType on (Events.VirusName = VirusType.VirusName 
				and Top10 =1 
			)  -- do top 10 join
--	Join dbo.tmpTop10Virus on (Events.VirusName = dbo.tmpTop10Virus.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- 8. Fast (group summary) Fetch, top 10 files, with data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @DataFilter <> 'none' and 
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( '10' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
--	dont do top 10 join cause a data filter exists and it must be run first
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.Filename
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 8.5 Fast (group summary) Fetch, top 10 files, with no data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename

   else if lower(@szDrilldown1) = 'fast' and @DataFilter = 'none' and
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8.5tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( '10.1' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.Filename
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9. Fast (group summary) Fetch, top 10  Users, with data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first


   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '11' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	data filter exists, dont joinwith top 10 table because filter must be run first on client
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9.5 Fast (group summary) Fetch, top 10  Users, with no data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9.5tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '11.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10. Fast (group summary) Fetch, top 10 Computers, with data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'Atm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '12' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	data filter exists so dont join to top 10 table
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10.5 Fast (group summary) Fetch, top 10 Computers, with no data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'A.5tm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		,'' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( '12.5' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
--		, '' as RuleName

		-- Product Update Fields
--		,'' as Type 
--		,'' as Version
--		,'' as Error
--		,'' as SiteName
--		,'' as InitiatorID
--		,'' as InitiatorType

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end



	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		
	Drop Table dbo.tmpTop10s
	Drop Table dbo.tmpTop10Virus


RETURN @ret
END
GO



--------------------------------------------------
--------------------------------------------------
-- AVISP_GetReportGroups - Fetches groups for Custom Group FAST Drilldown Subreports 


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetReportGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetReportGroups]
GO


CREATE PROCEDURE dbo.AVISP_GetReportGroups
(
	@szOptionalReportParms varchar(500)
	,@szGroup1 VARCHAR(100) 
	, @szGroup2 VARCHAR(100) 
	, @szGroup3 VARCHAR(100) 
	, @szGroup4  VARCHAR(100) 
	, @szGroupValue1 VARCHAR(100) 
	, @szGroupValue2 VARCHAR(100) 
	, @szGroupValue3 VARCHAR(100) 
	, @szGroupValue4  VARCHAR(100) 
	,@szGroupYear   VARCHAR(100)  OUTPUT
	,@szGroupMonth     VARCHAR(100)  OUTPUT 
	,@szGroupQuarter     VARCHAR(100)  OUTPUT 
	,@szGroupWeek     VARCHAR(100)  OUTPUT 
	,@szGroupVirusName     VARCHAR(100)  OUTPUT
	,@szGroupActionTaken     VARCHAR(100)  OUTPUT
	,@szGroupNodeName     VARCHAR(100)  OUTPUT
	,@szGroupProductName     VARCHAR(100)  OUTPUT
	,@szGroupProductVersion     VARCHAR(100)  OUTPUT
	,@szGroupEngineVersion     VARCHAR(100)  OUTPUT
	,@szGroupDATVersion     VARCHAR(100)  OUTPUT
	,@szGroupFileName     VARCHAR(100)  OUTPUT
	,@szGroupHostName     VARCHAR(100)  OUTPUT
	,@szGroupUserName     VARCHAR(100)  OUTPUT
	,@szGroupExtraDATNames     VARCHAR(100)  OUTPUT		-- coverage data 
	,@szGroupDomainName     VARCHAR(100)  OUTPUT		-- coverage data 
	,@szGroupOSVersion     VARCHAR(100)  OUTPUT
	,@szGroupServicepack     VARCHAR(100)  OUTPUT
	,@szGroupHotfix     VARCHAR(100)  OUTPUT
	,@szGroupLicenseStatus     VARCHAR(100)  OUTPUT
	,@szGroupExpirationDate     VARCHAR(100)  OUTPUT
	,@szGroupAgentVersion     VARCHAR(100)  OUTPUT		-- update event data
	,@szGroupType     VARCHAR(100)  OUTPUT
	,@szGroupVersion     VARCHAR(100)  OUTPUT
	,@szGroupError     VARCHAR(100)  OUTPUT
	,@szGroupLanguage     VARCHAR(100)  OUTPUT
	,@szGroupSiteName     VARCHAR(100)  OUTPUT
	,@szGroupInitiatorID     VARCHAR(100)  OUTPUT
	,@szGroupInitiatorType     VARCHAR(100)  OUTPUT
	,@szGroupDay     VARCHAR(100)  OUTPUT
	,@szGroupHour     VARCHAR(100)  OUTPUT
	,@szAgentVersion varchar(50) output
	,@szLicensed varchar(50) output
	,@szConnectStatus varchar(50) output
	,@szAgentType varchar(50) output
	,@szOSType varchar(50) output
	,@szOSPlatform varchar(50) output
	,@szVirusType varchar(50) output
	,@szFullProductName varchar(50) output
	,@szEngineDat varchar(50) output
	,@szDatExtraDat varchar(50) output
    	,@szTVDSeverity varchar(50) output
    	,@szTVDTaskName varchar(50) output
	,@szEventDesc varchar(255) output
	,@szVirusSubType varchar(50) output
)
AS
BEGIN

Declare @GroupName varchar(100)
Declare @GroupValue varchar(100)
Declare @loop numeric
Declare @pstart int
Declare @pstart1 int
Declare @pstart2 int
Declare @pend int
Declare @ret int

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT
	


   Set @szGroupYear  = ''
   Set @szGroupMonth  = ''
   Set @szGroupQuarter  = ''
   Set @szGroupWeek  = ''
   Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''
   Set @szGroupProductName  = ''
   Set @szGroupProductVersion  = ''
   Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''
   Set @szGroupFileName  = ''
   Set @szGroupHostName  = ''
   Set @szGroupUserName = ''
	Set @szGroupExtraDATNames  = ''
	Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''
	Set @szGroupServicepack  = ''
	Set @szGroupHotfix   = ''
	Set @szGroupLicenseStatus   = ''
	Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''
	Set @szGroupType    = ''
	Set @szGroupVersion    = ''
	Set @szGroupError    = ''
	Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''
	Set @szGroupInitiatorID   = ''
	Set @szGroupInitiatorType    = ''
	Set @szGroupDay    = ''
	Set @szGroupHour    = ''
	Set @szAgentVersion   = ''
	Set @szLicensed   = ''
	Set @szConnectStatus   = ''
	Set @szAgentType   = ''
	Set @szOSType   = ''
	Set @szOSPlatform   = ''
	Set @szVirusType   = ''
	Set @szFullProductName   = ''
	Set @szEngineDat   = ''
	Set @szDatExtraDat   = ''
    	Set @szTVDSeverity   = ''
    	Set @szTVDTaskName   = ''
	Set @szEventDesc   = ''
	Set @szVirusSubType = ''

Set @GroupName= @szGroup1
Set @GroupValue = @szGroupValue1
Set @loop = 1


While @loop < 5
Begin
	/* search one of four group variables */
	if @loop = 1
	Begin
		Set @GroupName= @szGroup1
		Set @GroupValue = @szGroupValue1		
	End
	Else if @loop = 2
	Begin
		Set @GroupName= @szGroup2
		Set @GroupValue = @szGroupValue2
	End
	Else if @loop = 3
	Begin
		Set @GroupName= @szGroup3
		Set @GroupValue = @szGroupValue3
	End
	Else if @loop = 4
	Begin
		Set @GroupName= @szGroup4
		Set @GroupValue = @szGroupValue4
	End
	
	/* Find out which type of group it is */
	if lower(@GroupName) = 'year' and @GroupValue > ''
	Begin
		set @szGroupYear = @GroupValue
	End
	else if lower(@GroupName) = 'month' and @GroupValue > ''
	Begin
		set @szGroupMonth = @GroupValue
	End
	else if lower(@GroupName) = 'quarter' and @GroupValue > ''
	Begin
		set @szGroupQuarter = @GroupValue
	End
	else if lower(@GroupName) = 'week' and @GroupValue > ''
	Begin
		set @szGroupWeek = @GroupValue
	End
	else if lower(@GroupName) = 'day' and @GroupValue > ''
	Begin
		set @szGroupDay = @GroupValue
	End
	else if lower(@GroupName) = 'hour' and @GroupValue > ''
	Begin
		set @szGroupHour = @GroupValue
	End
	else if lower(@GroupName) = 'virusname' and @GroupValue > ''
	Begin
		set @szGroupVirusName = @GroupValue
	End
	else if (lower(@GroupName) = 'actiontaken' or lower(@GroupName) = 'action' ) and @GroupValue > ''
	Begin
		Set @szGroupActionTaken = @GroupValue
	End
	else if lower(@GroupName) = 'nodename' and @GroupValue > ''
	Begin
		set @szGroupNodeName = @GroupValue
	End
	else if lower(@GroupName) = 'groupname' and @GroupValue > ''
	Begin
		set @szGroupNodeName = @GroupValue
	End
	else if lower(@GroupName) = 'productnameversion' and @GroupValue > ''
	Begin
	
		/* Separate product name from product version: pn- pv */
		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
		if @pstart is null or @pstart = 0
			set @pstart=1	
		Set @szGroupProductName = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
		Set @szGroupProductVersion = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )
	End
	else if lower(@GroupName) = 'productname' and @GroupValue > ''
	Begin
		set @szGroupProductName = @GroupValue
	End
	else if lower(@GroupName) = 'productversion' and @GroupValue > ''
	Begin
		set @szGroupProductVersion = @GroupValue
	End
	else if lower(@GroupName) = 'servicepack' and @GroupValue > ''
	Begin
		set @szGroupServicepack = @GroupValue
	End
	else if lower(@GroupName) = 'hotfix' and @GroupValue > ''
	Begin
		set @szGroupHotfix = @GroupValue
	End
	else if lower(@GroupName) = 'servicepackhotfix' and @GroupValue > ''
	Begin
	
		/* Separate engine version from dat version: sp\ hf */
		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
		if @pstart is null or @pstart = 0
			set @pstart=1	
		Set @szGroupServicepack = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
		Set @szGroupHotfix = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )

	End

--	else if lower(@GroupName) = 'enginedat' and @GroupValue > ''
--	Begin
--	
--		/* Separate engine version from dat version: ev\ dv */
--		Set @pstart = CHARINDEX( '\ ', @GroupValue) 
--	
--		Set @szGroupEngineVersion = SUBSTRING( @GroupValue, 1,  (@pstart-1) )
--		Set @szGroupDATVersion = SUBSTRING( @GroupValue, (@pstart+2), len(@GroupValue) )
--
--	End
	else if lower(@GroupName) = 'engineversion' and @GroupValue > ''
	Begin
		set @szGroupEngineVersion = @GroupValue
	End
	else if lower(@GroupName) = 'datversion' and @GroupValue > ''
	Begin
		set @szGroupDATVersion = @GroupValue
	End
	else if lower(@GroupName) = 'extradat' and @GroupValue > ''
	Begin
		set @szGroupExtraDATNames = @GroupValue
	End

	else if lower(@GroupName) = 'filename' and @GroupValue > ''
	Begin
		set @szGroupFileName = @GroupValue
	End
	else if lower(@GroupName) = 'hostname' and @GroupValue > ''
	Begin
		set @szGroupHostName = @GroupValue
	End
	else if lower(@GroupName) = 'username' and @GroupValue > ''
	Begin
		set @szGroupUserName = @GroupValue
	End

	-- coverage data
	else if lower(@GroupName) = 'domainname' and @GroupValue > ''
	Begin
		set @szGroupDomainName = @GroupValue
	End
	else if lower(@GroupName) = 'osversion' and @GroupValue > ''
	Begin
		set @szGroupOSVersion = @GroupValue
	End

	else if lower(@GroupName) = 'licensestatus' and @GroupValue > ''
	Begin
		set @szGroupLicenseStatus = @GroupValue
	End
	else if lower(@GroupName) = 'expirationdate' and @GroupValue > ''
	Begin
		set @szGroupExpirationDate = @GroupValue
	End
--	else if lower(@GroupName) = 'agentversion' and @GroupValue > ''
--	Begin
--		set @szGroupAgentVersion = @GroupValue
--	End
	else if lower(@GroupName) = 'type' and @GroupValue > ''
	Begin
		set @szGroupType = @GroupValue
	End
	else if lower(@GroupName) = 'version' and @GroupValue > ''
	Begin
		set @szGroupVersion = @GroupValue
	End
	else if lower(@GroupName) = 'error' and @GroupValue > ''
	Begin
		set @szGroupError = @GroupValue
	End
	else if lower(@GroupName) = 'language' and @GroupValue > ''
	Begin
		select 	@szGroupLanguage = epoServerLanguageID		
		from LanguageDesc
		where
   			LanguageDesc.epoServerLanguageID = @szFullLang
			and LanguageDesc.LanguageName = @GroupValue
		if @@rowcount = 0
			Set @szGroupLanguage = @GroupValue
	End
	else if lower(@GroupName) = 'sitename' and @GroupValue > ''
	Begin
		set @szGroupSiteName = @GroupValue
	End
	else if lower(@GroupName) = 'initiatorid' and @GroupValue > ''
	Begin
		set @szGroupInitiatorID = @GroupValue
	End
	else if lower(@GroupName) = 'initiatortype' and @GroupValue > ''
	Begin
		set @szGroupInitiatorType = @GroupValue
	End
	else if lower(@GroupName) = 'agentversion' and @GroupValue > ''
	Begin
		set @szAgentVersion = @GroupValue
	End
	else if lower(@GroupName) = 'licensed' and @GroupValue > ''
	Begin
		set @szLicensed = @GroupValue
	End
	else if lower(@GroupName) = 'connectstatus' and @GroupValue > ''
	Begin
		set @szConnectStatus = @GroupValue
	End
	else if lower(@GroupName) = 'agenttype' and @GroupValue > ''
	Begin
		set @szAgentType = @GroupValue
	End
	else if lower(@GroupName) = 'ostype' and @GroupValue > ''
	Begin
		set @szOSType = @GroupValue
	End
	else if lower(@GroupName) = 'osplatform' and @GroupValue > ''
	Begin
		set @szOSPlatform = @GroupValue
	End
	else if lower(@GroupName) = 'virustype' and @GroupValue > ''
	Begin
		set @szVirusType = @GroupValue
	End
	else if lower(@GroupName) = 'fullproductname' and @GroupValue > ''
	Begin
		set @szFullProductName   = @GroupValue
	End
	else if lower(@GroupName) = 'enginedat' and @GroupValue > ''
	Begin
		set @szEngineDat   = @GroupValue
	End
	else if lower(@GroupName) = 'datextradat' and @GroupValue > ''
	Begin
		set @szDatExtraDat   = @GroupValue
	End
	else if lower(@GroupName) = 'tvdseverity' and @GroupValue > ''
	Begin
		set @szTVDSeverity   = @GroupValue
	End
	else if lower(@GroupName) = 'tvdtaskname' and @GroupValue > ''
	Begin
		set @szTVDTaskName   = @GroupValue
	End
	else if lower(@GroupName) = 'eventdesc' and @GroupValue > ''
	Begin
		set @szEventDesc   = @GroupValue
	End
	else if lower(@GroupName) = 'virussubtype' and @GroupValue > ''
	Begin
		set @szVirusSubType   = @GroupValue
	End
	else if lower(@GroupName) > ''  -- group not found
	begin
		set @ret = @ret -1		-- group not found ret <= 0
	end

	set @loop = @loop + 1
End

RETURN @ret
END
GO


-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
-- Custom Group Data subreports


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreport]
GO



CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
, @szNameSpaceName  VARCHAR(100)
 ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @EventType varchar(50) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@EventType) != 'all'
	and lower(@EventType) != 'notinfection'
	and lower(@EventType) != 'infection'
	and lower(@EventType) != 'Infection-Res'
	and lower(@EventType) != 'Infection-Unr'
	and lower(@EventType) != 'Infection-Cle'
	and lower(@EventType) != 'Infection-Del'
	and lower(@EventType) != 'Infection-Mov'
		 Set @Inputlegal = 0

 -- translate webshield groupnames into actual event fieldname
 Declare @Webshield int
 Set @Webshield = 0
 if lower(@EventType) = 'contentfilter'
	or lower(@EventType) = 'contentscanning'
	or lower(@EventType) = 'spam'
	or lower(@EventType) = 'urlblocked'
	or lower(@EventType) = 'virus'
 Begin
	Set @Webshield = 1
	if @szGroup1 = 'RuleName'
		Set @szGroup1 = 'VirusName'
	if @szGroup2 = 'RuleName'
		Set @szGroup2 = 'VirusName'
	if @szGroup3 = 'RuleName'
		Set @szGroup3 = 'VirusName'
	if @szGroup4 = 'RuleName'
		Set @szGroup4 = 'VirusName'
	if @szGroup1 = 'Server'
		Set @szGroup1 = 'HostName'
	if @szGroup2 = 'Server'
		Set @szGroup2 = 'HostName'
	if @szGroup3 = 'Server'
		Set @szGroup3 = 'HostName'
	if @szGroup4 = 'Server'
		Set @szGroup4 = 'HostName'
	if @szGroup1 = 'Spammer'
		Set @szGroup1 = 'UserName'
 End


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node (done in main routine)
 --select distinct AgentGUID
 --into #LostLinksEvents
 --from Events
 --	where AgentGUID not in (select AgentGUID from leafnode)
  

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- strip top10 suffix if present
	if substring(@EventType, 1, 5) = 'T10Vr' 
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	else if substring(@EventType, 1, 5) = 'T10Fl' 
		Set @EventType = Replace( @EventType, 'T10Fl', '')
	else if substring(@EventType, 1, 5) = 'T10Ur' 
		Set @EventType = Replace( @EventType, 'T10Ur', '')
	else if substring(@EventType, 1, 5) = 'T10Cp' 
		Set @EventType = Replace( @EventType, 'T10Cp', '')

   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  -- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)  	
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50) 
	Declare @szAgentType	varchar(50) 
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(255) 
	Declare	@szVirusSubType varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = ''  
	Set @szVirusSubType = ''

   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					@szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		-- coverage data 
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion output
						,@szLicensed output
						,@szConnectStatus output 
						,@szAgentType	output
						,@szOSType output
						,@szOSPlatform output
						,@szVirusType output
						,@szFullProductName output
						,@szEngineDat output
						,@szDatExtraDat output
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubType OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	



---------------------------------------------------------------
-- Do not use outer joins here
-- if the group is on a field partiipating in an outer join not only will the fields matching value be returned but all outerjoin rows (null values) as well
-- too much data gets sent.

-- avoid outer join on eventdesc table: if no match then row wont be returned - too little data returned
-- keep outer join in actiodesc & virustype ion events are caught
-- note: missing entries in EventFilterDescFast will result in rows not being returned



--select @szGroupActionTaken


-- warning:  dont do outer join on a group field: it breaks in these subreports returning to many rows
 
 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */

    		,CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(Events.UserName AS varchar(32)) AS UserName
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  cast(BranchNode.Nodename as varchar(255))
			ELSE @Unlinked
			END 


    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype

    		,cast( TVDEventID as varchar(10)) as TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		ScanTime 
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else cast(Events.TVDSeverity as varchar(30))
			end  as TVDSeverity
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity

    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
    		,CAST(ProductID as int) As ProductID
--  		cast(BranchNode.Nodename as varchar(255))    AS NodeName 
--  		cast(ReportFullPathNode.FullPathName as varchar(255))    AS NodeName 

--		, cast(EventFilterDescFast.Name as varchar(128)) as EventDesc
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc

		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(@EventType in ('All', 'NotInfection') 
		and events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND ( TVDEventID not in (1202, 1203, 4650, 4651 ) )
--   	AND LeafNode.Type !=  24      -- show all events including uninstalled
	and ( @YYYYMMDD is null or Events.EventDateTime >=  @YYYYMMDD)
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionUr' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionCp' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or ( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or ( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or ( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or ( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	)

             AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime) = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), Cast(DatePart(Month, EventDateTime) as char(5)) ) = @szGroupMonth
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
--
		)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Quarter, EventDateTime)) = @szGroupQuarter
--			AND
--		  Datediff(year, EventDateTime, Getdate() ) = 0
		)
	) 
             AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Week, EventDateTime)) = @szGroupWeek
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
		)
	) 
             AND 		-- day of month
	(	 @szGroupDay = ''
		OR 
		convert(varchar(20), DateName(Day, EventDateTime)) = @szGroupDay
	) 
             AND 		-- hour of day
	(	 @szGroupHour = ''
		OR 
		convert(varchar(20), DateName(Hour, EventDateTime)) = @szGroupHour
	) 
             AND 
	(	 @szGroupVirusName = ''
		OR Events.VirusName = @szGroupVirusName
	) 
             AND 
	(	 @szGroupActionTaken = ''
-- localized version OR (ReportActionDesc.ActionName = @szGroupActionTaken and ActionTaken in ('50','65') )
		OR (@szGroupActionTaken = ReportActionDesc.ActionName )
		OR (@szGroupActionTaken > '' and convert(varchar(25),ActionTaken) = @szGroupActionTaken )
	) 
             AND 
	(	 @szTVDSeverity = ''
-- localized version OR ( SeverityDesc.SeverityName = @szTVDSeverity and Events.TVDSeverity = 0 )  do join above to severitydesc or TranslateSeverity
		or ( @szTVDSeverity = EventFilterDescFast.Severity )
		OR ( @szTVDSeverity = @Informational and Events.TVDSeverity = 0 )
		OR ( @szTVDSeverity = @Warning and Events.TVDSeverity = 1 )
		OR ( @szTVDSeverity = @Minor and Events.TVDSeverity = 2 )
		OR ( @szTVDSeverity = @Major and Events.TVDSeverity = 3 )
		OR ( @szTVDSeverity = @Critical and Events.TVDSeverity = 4 )
		OR ( @szTVDSeverity = '---' and (Events.TVDSeverity > 4  or Events.TVDSeverity < 0) )
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
		or ( @szGroupNodeName = '---' and (BranchNode.NodeName is NULL) )
	) 
             AND 
	(	 @szGroupProductName = ''
		OR ProductName = @szGroupProductName
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR ProductVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (ProductVersion is NULL or ProductVersion = '') )
	) 
             AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVersion = @szGroupEngineVersion
	) 
             AND 
	(	 @szGroupDATVersion = ''
		OR DATVersion = @szGroupDATVersion
	) 
             AND 	-- make this a like operator since the filename is cropped
	(	 @szGroupFileName = ''
		OR FileName like ('%' + @szGroupFileName)
	) 
             AND 
	(	 @szGroupHostName = ''
		OR Events.HostName = @szGroupHostName
	) 
             AND 
	(	 @szGroupUserName = ''
		OR Events.UserName = @szGroupUserName
	) 
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName = '' or Domainname is null) )
		or ( @szGroupDomainName = '---' and (DomainName = '' or Domainname is null) )
	) 
             AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType = '' or OSType is null) )
		or ( @szOSType = '---' and (OSType = '' or OSType is null) )
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform = '' or OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '' or OSPlatform is NULL) )
	) 
             AND 
	(	 @szVirusType = ''
		OR VirusType.VirusTypeTranslated = @szVirusType 
		or Events.VirusType = @szVirusType 
		or (@szVirusType = '---' and (Events.VirusType = '' or Events.VirusType is NULL))
	) 
             AND 
	(	 @szVirusSubtype = ''
		OR VirusType.VirusFileType = @szVirusSubtype 
		or (@szVirusSubtype = '---' and (VirusType.VirusFileType = '' or VirusType.VirusFileType is NULL))
	) 
             AND 
	(	 @szFullProductName = ''
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		or (@szFullProductName = '---' and ((ProductName + ' ' + ProductVersion) = ' ' or (ProductName + ' ' + ProductVersion) is NULL))
	) 
             AND 
	(	 @szEngineDat = ''
		OR (EngineVersion + ' ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion + ' \ ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion)  = @szEngineDat 
		OR (DATVersion)  = @szEngineDat 
		or (@szEngineDat = '---' and ((EngineVersion + ' ' + DATVersion) = ' ' or (EngineVersion + ' ' + DATVersion) is NULL))
	) 
             AND 
	(	 @szTVDTaskName = ''
		OR TVDTaskName = @szTVDTaskName 
	) 
             AND 
	(	 
		@szEventDesc = ''
		or EventFilterDescFast.Name = @szEventDesc
		or cast(Events.TVDEventID as varchar(128)) = @szEventDesc
		or (@szEventDesc = '---' and (Events.TVDEventID = '' or Events.TVDEventID is NULL))
	) 






	set @ret = @@rowcount

--	Drop Table #LostLinksEvents

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductEventGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductEventGroupsSubreport]
GO

CREATE PROCEDURE dbo.AVISP_FilterProductEventGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
, @AfterYYYYMMDD varchar(30) = ''
, @AfterRule varchar(30) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1




 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 
 -- Build a list of ProductEvent Guids that are not tied to a leaf node (Done in main routine)
 --select distinct NodeID
 --into #LostLinks
 --from ProductEvents
 --	where NodeID not in (select AutoID from leafnode)
 

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @AfterYYYYMMDD, @AfterRule, @YYYYMMDD output


   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  	-- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)
 	Declare @szConnectStatus     VARCHAR(50)  
	Declare @szAgentType	varchar(50)
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(50) 
	Declare	@szVirusSubtype varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = '' 
	Set @szVirusSubtype = '' 


   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms, 
					 @szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion 	OUTPUT
						,@szLicensed  		OUTPUT
						,@szConnectStatus	OUTPUT 
						,@szAgentType		OUTPUT
						,@szOSType OUTPUT
						,@szOSPlatform OUTPUT
						,@szVirusType OUTPUT
						,@szFullProductName OUTPUT
						,@szEngineDat OUTPUT
						,@szDatExtraDat OUTPUT
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubtype OUTPUT

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent = 'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	


----------------------------------------------------
-- fetch the rows 

 	SELECT   
		
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q


   		,AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END
		, case
			when ComputerProperties.Computername > '' then ComputerProperties.Computername
			when LeafNode.NodeName > '' then LeafNode.NodeName
			else @Unlinked
			end as HostName
    		,CAST(ComputerProperties.IPAddress As varchar(15)) As HostIPAddress
    		,CAST(ComputerProperties.UserName AS varchar(32)) AS UserName
		,CAST('' As varchar(50)) AS VirusName
    		,CAST('' As varchar(50)) AS TVDEventID
    		,CAST('' As varchar(50)) As FileName
   		,CAST('' As varchar(50)) AS EngineVersion
   		,CAST('' As varchar(50)) AS DATVersion 
    		,CAST('' As varchar(50)) As ScanTime 
   		,CAST('' As varchar(50)) As ActionTaken
    		,CAST('' As varchar(50)) As TVDSeverity 
   		,CAST('' As varchar(50)) As VirusType 
    		,CAST('' AS varchar(50)) As TVDTaskName
    		,CAST('' as int) As ProductID
  		, case
			when BranchNode.NodeName > '' then cast(BranchNode.NodeName as varchar(255))
			else @Unlinked
		 	end AS NodeName 
--  		,cast(BranchNode.NodeName as varchar(255)) AS NodeName 

 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( Locale as nvarchar(50)) as Language
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
 		, cast( InitiatorType as nvarchar(50)) as InitiatorType

  		, case
			when ComputerProperties.DomainName > '' then ComputerProperties.DomainName
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as DomainName
  		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
  		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
--    		,cast(ReportFullPathNode.FullPathName as varchar(255))  As FullNodeName
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as nvarchar(128)) 
			else cast(ProductEvents.Error as nvarchar(128)) 
			end

	FROM 
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)	
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)
	
--   		ProductEvents, AVIView_Software				--, ReportFullPathNode
--             		,LeafNode, BranchNode, ComputerProperties   --, ProductProperties LanguageDesc, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--   	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	AND LeafNode.ParentID = BranchNode.AutoID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')	-- need to see all events 
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  -- need to see all events 
--   	AND LeafNode.Type !=24      -- need to see all events 
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)


	-- filter by the drilldown groups selected by the user
             AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime)  = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth )
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), Cast(DatePart(Month, EventDateTime) as char(5)) )  = @szGroupMonth	)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + 
			Datename(Week, EventDateTime)   = @szGroupQuarter	)	-- quarter 1-4
	) 
             AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek)
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Week, EventDateTime)) = @szGroupWeek)
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
	) 
             AND 
	(	 @szGroupProductName = ''
		OR AVIView_Software.SoftwareName = @szGroupProductName
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR AVIView_Software.SoftwareVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (AVIView_Software.SoftwareVersion is NULL or AVIView_Software.SoftwareVersion = '') )
	) 
             AND 
	(	 @szGroupAgentVersion = ''
		OR ProductEvents.AgentVersion = @szGroupAgentVersion
	)
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName is NULL) )
		or ( @szGroupDomainName = '---' and (DomainName = '') )
	) 
             AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType is NULL) )
		or ( @szOSType = '---' and (OSType = '') )
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '') )
	) 
             AND 
	(	 @szFullProductName = ''
		OR (AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) = @szFullProductName 
	) 
             AND 
	(	 @szGroupType = ''
		OR ProductEvents.Type = @szGroupType
	) 
             AND 
	(	 @szGroupError = ''
		OR ReportUpdateEventDesc.Description = @szGroupError
		OR convert(char(10),ProductEvents.Error) = @szGroupError
		or ( @szGroupError = '---' and (ProductEvents.Error is NULL) )
--		OR ProductEvents.Error = @szGroupError
	) 
             AND 
	(	 @szGroupLanguage = ''
		OR Locale = @szGroupLanguage
	) 
             AND 
	(	 @szGroupSiteName = ''
		OR SiteName = @szGroupSiteName
	) 
             AND 
	(	 @szGroupInitiatorID = ''
		OR InitiatorID = @szGroupInitiatorID
	) 
             AND 
	(	 @szGroupInitiatorType = ''
		OR Initiatortype = @szGroupInitiatorType
	) 
             AND 
	(	 @szGroupVersion = ''
		OR Version = @szGroupVersion
	) 

	


	set @ret = @@rowcount

--	Drop Table #LostLinks
	

-- check for illegal values
-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO





if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductGroupsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterProductGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = ''
 , @ConnectType varchar(30) = 'All'
 , @ProductType varchar(30) = 'AntiVirus' 
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@ConnectType) != 'current' 
	and lower(@ConnectType) != 'all' 
	and lower(@ConnectType) != 'late' 
		 Set @Inputlegal = 0

 if lower(@ProductType) != 'all'
	and lower(@ProductType) != 'antivirus'
	and lower(@ProductType) != 'security'
	and lower(@ProductType) != 'agent'
		 Set @Inputlegal = 0



 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

    /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output
	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')



   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupDay varchar(100) 
   Declare @szGroupHour varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  	-- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50)  
	Declare @szAgentType     VARCHAR(50)  
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(50) 
	Declare @szVirusSubtype varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = '' 
	Set @szVirusSubtype = '' 


   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					     @szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion  OUTPUT
						,@szLicensed    OUTPUT
						,@szConnectStatus    OUTPUT
						,@szAgentType    OUTPUT
						,@szOSType OUTPUT
						,@szOSPlatform OUTPUT
						,@szVirusType OUTPUT
						,@szFullProductName OUTPUT
						,@szEngineDat OUTPUT
						,@szDatExtraDat OUTPUT
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubtype OUTPUT

--select  @szAgentVersion 
--select @szConnectStatus 
--select @szAgentType 
--select @szGroupLanguage
--select @szGroupProductVersion

--if  @szGroupProductName not like 'Unmanaged Protection%' and  @szGroupProductName <> 'UnProtection'
--and  @szGroupProductName <> '(UnProtection)'
--begin

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
--		Select 	@Agent = TranslatedValue from ReportTranslations 
--			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'Agent'
		Set @Agent = 'Agent'		-- last minute localization bug, too late to retranslate
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
	End
	



-----------------------------------------
-- Fetch the rows

 	SELECT 
		cast( '' as varchar(10)) as EventDateTime
   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then 'Unprotected' 
				Else @NoAgent
				End
			End --as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---'
     			END
--		postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
	   	, Case
		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
		else	LeafNode.NodeName
		End as HostName
--   		,ComputerProperties.ComputerName as HostName
    		,CAST(ComputerProperties.IPAddress As varchar(15)) As HostIPAddress
    		,CAST(ComputerProperties.UserName AS varchar(32)) AS UserName
		,CAST('' As varchar(10)) AS VirusName
    		,CAST('' As varchar(10)) AS TVDEventID
    		,CAST('' As varchar(10)) As FileName
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
    		,CAST('' As varchar(10)) As ScanTime 
   		,CAST('' As varchar(10)) As ActionTaken
    		,CAST('' As varchar(10)) As TVDSeverity 
   		,CAST('' As varchar(10)) As VirusType 
    		,CAST('' AS varchar(10))As TVDTaskName
    		,CAST('' as int) As ProductID
  		, cast(BranchNode.NodeName as varchar(255)) AS NodeName 
  		,ComputerProperties.DomainName
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) as OSVersion
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix

   		, LeafNode.LastUpdate as LastContact
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'

		, ProductProperties.LicenseStatus as LicenseStatus 
		, ProductProperties.ExpirationDate as ExpirationDate
   		, Language =
    			CASE 
     			WHEN  LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
     			WHEN  ProductProperties.Language > '' THEN ProductProperties.Language
     			ELSE  '---'
     			END
--		, ProductProperties.Language as Language
		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE  '---' 
     			END
--   		, LeafNode.Licensed 
		, '' as Licensed

		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
--		, case convert(int, superagent) + (convert(int, superagentrepo) * 10) 
--			when 0 then @Agent
--			when 1 then @SuperAgentBroadcast
--			when 10 then @SuperAgentRepository
--			when 11 then @SuperAgentRepository
--			else @Agent
--			end	as AgentType
		, case
			when LeafNode.LastUpdate  >=  @YYYYMMDD then @Current
			when LeafNode.LastUpdate  <  @YYYYMMDD then @Late
			else '---'
			end 	as ConnectStatus
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
	        ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		   ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		   as FullProductName
	        ,  cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 
	        ,  cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
  		, cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName


 FROM 	
	(LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID
	   		AND LeafNode.Type !=24      /* Uninstalled */ 
			and ( @YYYYMMDD is null  or @ConnectType = 'All' 
				or
				( 
				(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
				or
				(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')
				or
				(@ConnectType = '(NoAgent)' and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null))
				)	
		       )
	
		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
		and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )
		)
		left outer Join LanguageDesc on(RIGHT(ProductProperties.Language, 2) = LanguageDesc.ClientLanguageSuffix
			and LanguageDesc.epoServerLanguageID = @szFullLang)	
	)
	on( leafnode.autoid = productproperties.parentid )

 WHERE  
   (
    @FilterID = 0 OR
     LeafNode.ParentID = @FilterID OR
    LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         from BranchNodeEnum 
         where  BranchNodeEnum.StartAutoID = @FilterID)
   )
--   AND LeafNode.AutoID = ComputerProperties.ParentID
--                  AND ProductProperties.ParentID = LeafNode.AutoID 
--   and ProductProperties.ProductCode = AVIView_Software.ProductCode
--   AND LeafNode.ParentID = BranchNode.AutoID
--   AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   AND RIGHT(ProductProperties.Language, 2) *= LanguageDesc.ClientLanguageSuffix
--   AND LanguageDesc.epoServerLanguageSuffix = @szLang


   
        AND 
	(	 @szGroupYear = ''
		OR substring(Leafnode.LastUpdate, 1, 4) = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) = @szGroupMonth	)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + 
			cast((((convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))  = @szGroupQuarter	)	-- quarter 1-4
	) 
             AND 
	(	 @szGroupDay = ''
		OR 
		( substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
			= @szGroupDay )
	)


/*             AND 
	(	 @szGroupWeek = ''
		OR 
		( DatePart(Week, EventDateTime) = @szGroupWeek)
	)*/ 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		OR ( @szGroupNodeName = '---'  and (BranchNode.NodeName = '' or BranchNode.NodeName is null))
	) 
             AND 
	(	 @szGroupProductName = ''
		OR AVIView_Software.SoftwareName = @szGroupProductName
		OR (@szGroupProductName = @Unprotected and leafnode.agentversion > '' and leafnode.avinstalls = 0) 
		OR (@szGroupProductName = @NoAgent and (leafnode.agentversion = '' or leafnode.agentversion is null)) 
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR ProductProperties.ProductVersion = @szGroupProductVersion
		OR (@szGroupProductVersion = '---' and (ProductProperties.ProductVersion = '' or ProductProperties.ProductVersion is null))
	) 
             AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVer = @szGroupEngineVersion
		OR (@szGroupEngineVersion = '---' and (EngineVer = '' or EngineVer is null))
	) 
             AND 
	(	 @szGroupDATVersion = ''
		OR DATVer = @szGroupDATVersion
		OR (@szGroupDATVersion = '---' and (DATVer = '' or DATVer is null))
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		OR ( @szGroupNodeName = '---'  and (BranchNode.NodeName = '' or BranchNode.NodeName is null))
	) 
             AND 
	(	 @szGroupExtraDATNames = ''
		OR ExtraDATNames = @szGroupExtraDATNames
		OR ( @szGroupExtraDATNames = '---'  and (ExtraDATNames = '' or ExtraDATNames is null))
	) 
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		OR ( @szGroupDomainName = '---'  and (DomainName = '' or DomainName is null))
	) 
             AND 
	(	 @szGroupOSVersion = ''
		OR cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50))  = @szGroupOSVersion
	) 
             AND 
	(	 @szGroupServicepack = ''
		OR Servicepack = @szGroupServicepack
		OR ( @szGroupServicepack = '---'  and (Servicepack = '' or Servicepack is null))
	) 
             AND 
	(	 @szGroupHotfix = ''
		OR Hotfix = @szGroupHotfix
		OR ( @szGroupHotfix = '---'  and (Hotfix = '' or Hotfix is null))
	) 
             AND 
	(	 @szGroupLanguage = ''
		OR (Language = @szGroupLanguage )
		OR ( @szGroupLanguage = '---'  and (Language = '' or Language is null))
--		or (LanguageDesc.LanguageName = @szGroupLanguage and LanguageDesc.LanguageName > '' )
--		or ( @szGroupLanguage = 'English' and Language = '0409' )
	) 
             AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		OR ( @szOSType = '---'  and (OSType = '' or OSType is null))
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		OR ( @szOSPlatform = '---'  and (OSPlatform = '' or OSPlatform is null))
	) 
             AND 
	(	 @szFullProductName = ''
		OR (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		   ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) = @szFullProductName 
	) 
             AND 
	(	 @szEngineDat = ''
		OR (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', ''))  = @szEngineDat 
		OR (EngineVer + ' \ ' +  DATVer )  = @szEngineDat 
	) 
             AND 
	(	 @szDatExtraDat = ''
		OR (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) = @szDatExtraDat 
	) 
             AND 
	(	 @szAgentVersion = ''
		OR AgentVersion = @szAgentVersion
		OR (@szAgentVersion = @NoAgent and (AgentVersion = '' or AgentVersion is null))

	) 
             AND 
	(	 @szConnectStatus = ''
		OR 	(@szConnectStatus= @Current and LeafNode.LastUpdate  >=  @YYYYMMDD)
		OR 	(@szConnectStatus= @Late and LeafNode.LastUpdate < @YYYYMMDD and LeafNode.LastUpdate > '')
		OR 	(@szConnectStatus= @NoAgent and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null)) 
		OR 	(@szConnectStatus= 'All') 
	) 
             AND 
	(	 @szAgentType = ''
		OR 	(@szAgentType= @NoAgent and (LeafNode.AgentVersion = '' or LeafNode.AgentVersion is null)) 
		OR 	(@szAgentType= @Agent and LeafNode.SuperAgent = 0 and LeafNode.SuperAgentRepo = 0)
		OR 	(@szAgentType= @Agent and LeafNode.SuperAgent is null and LeafNode.SuperAgentRepo is null)
		OR 	(@szAgentType= @SuperAgentBroadcast and LeafNode.SuperAgent = 1 and LeafNode.SuperAgentRepo = 0)
		OR 	(@szAgentType= @SuperAgentRepository and LeafNode.SuperAgent = 0 and LeafNode.SuperAgentRepo = 1)
		OR 	(@szAgentType= @SuperAgentRepository and LeafNode.SuperAgent = 1 and LeafNode.SuperAgentRepo = 1)
		OR 	(@szAgentType= '---' )
	) 


--drop table  dbo.tmpUnmanagedProtection

Set @ret = @@rowcount

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3
--end

RETURN @ret
END
GO


----------------------------------------------------------------------
-- more subreports: policy and tasks


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterPolicySubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterPolicySubreport]
GO

CREATE PROCEDURE dbo.AVISP_FilterPolicySubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int
--  , @ParentID int
  , @ProductCode varchar(50)=''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

	Declare @ret int
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

------------
-- postepo3 - cleanup temp tables
  
	IF EXISTS (select * from sysobjects where name = 'tmpFinalPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpFinalPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpCompiledPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpCompiledPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpPolicy' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpPolicy

	IF EXISTS (select * from sysobjects where name = 'tmpPolicyNodeList' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpPolicyNodeList

	IF EXISTS (select * from sysobjects where name = 'tmpProducts' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpProducts



  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Find where properties are set for this product on this computer
	Declare @PolicyID int
	Declare @PolicyParentType int 
	Declare @PolicyParentID int 
	Declare @ParentID int

	-- get parentid
	Select @ParentID = parentid from leafnode where autoid = @NodeID

	-- get all productcodes applying to this node
	select ProductProperties.ProductCode
	into dbo.tmpProducts
	from leafnode, ProductProperties, aviview_software
	where
		leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC') 
				or (AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%') 
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and leafnode.autoid = @NodeID
		and 
		(
		@ProductCode is null or @ProductCode = '' or ProductProperties.ProductCode = @ProductCode
		or ProductProperties.ProductCode like 'EPOAGENT%'  -- fix always include agent
		)
		
--select * from dbo.tmpProducts

	-- get all branchnodes for the installed products in the inheritance tree storing policy values and inheritance level
	SELECT Policy.autoid, Policy.ParentID, Policy.ParentType, PathLength, Policy.ProductCode
			Into dbo.tmpPolicyNodeList
			FROM Policy, BranchNodeEnum
			Where Policy.parentid = Startautoid
				and Endautoid = @Parentid 
				and Policy.ProductCode in (select ProductCode from dbo.tmpProducts)

--select * from dbo.tmpPolicyNodeList

	-- write policies from inheritance path into temp table
	Select
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,(PathLength+1) as PathLength
		,SectionName
		,SettingName
		,Value
	into dbo.tmpPolicy
	From dbo.tmpPolicyNodeList, Policy, PolicySettings
	Where
		dbo.tmpPolicyNodeList.autoid = Policy.autoid
		and dbo.tmpPolicyNodeList.Productcode = Policy.Productcode
		and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- add any policies stored at the parent node
	insert into dbo.tmpPolicy
	select 
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,1  as PathLength	-- default 1 means parentnode,thesmaller the number the higher the priority
		,SectionName
		,SettingName
		,Value
		from Policy, PolicySettings
		Where 
			Policy.parentid = @ParentID
			and Policy.ParentType in (3, 6)
			and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- add any policies from the leafnode itself
	insert into dbo.tmpPolicy
	select 
		Policy.ProductCode
		,Policy.autoid
		,Policy.ParentID
		,Policy.ParentType
		,0  as PathLength	-- default 0 means from the leafnode,the smaller the number the higher the priority
		,SectionName
		,SettingName
		,Value
		from Policy, PolicySettings
		Where 
			Policy.parentid = @NodeID
			and Policy.ParentType = 1
			and Policy.autoid = PolicySettings.parentid

--select * from dbo.tmpPolicy order by productcode, sectionname, settingname

	-- Get Top Priorities policy values
	Select
		ProductCode
		,SectionName
		,SettingName
		,min(PathLength) as PathLength
		into dbo.tmpCompiledPolicies
		from dbo.tmpPolicy
		group by
			ProductCode
			,SectionName
			,SettingName			

-- select * from dbo.tmpCompiledPolicies order by productcode, sectionname, settingname

	-- build final policy list
	select 
		@NodeID as NodeID
		,@ParentID as NodeParentID
		,dbo.tmpPolicy.ProductCode
		,dbo.tmpPolicy.autoid
		,dbo.tmpPolicy.ParentID as PolicyParentID
		,dbo.tmpPolicy.ParentType
		,dbo.tmpPolicy.SectionName
		,dbo.tmpPolicy.SettingName
		,dbo.tmpPolicy.Value
		into dbo.tmpFinalPolicies
		from dbo.tmpCompiledPolicies, dbo.tmpPolicy
		Where 
			dbo.tmpCompiledPolicies.SectionName =  dbo.tmpPolicy.SectionName
			and dbo.tmpCompiledPolicies.ProductCode =  dbo.tmpPolicy.ProductCode
			and dbo.tmpCompiledPolicies.SettingName =  dbo.tmpPolicy.SettingName			
			and dbo.tmpCompiledPolicies.PathLength = dbo.tmpPolicy.PathLength


--select * from dbo.tmpFinalPolicies order by productcode, sectionname, settingname

		

	-----------------------------------------------------------------------------------
	-- Collect Policy details

	SELECT

   		AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN  ProductProperties.ProductVersion
     			ELSE '---'
     			END
    		,cast( '' as varchar(10)) as VirusName		-- null field, used so that same rpt file can be used
   		,EngineVer =
    			CASE 
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer  
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVer =
    			CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     			ELSE '---'
     			END
 		,BranchNode.NodeName AS NodeName 
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
  		,ComputerProperties.ComputerName
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix
   		, InheritedNode = 
			CASE dbo.tmpFinalPolicies.ParentType
			when 1 then leafnode.nodename    -- fix
			when 4 then 'Directory'
			when 7 then 'Global Root'
			else cast(  ReportFullPathNode.FullPathName as varchar(255))   
			end

		,dbo.tmpFinalPolicies.ProductCode
		,dbo.tmpFinalPolicies.autoid
		,dbo.tmpFinalPolicies.PolicyParentID
		,dbo.tmpFinalPolicies.ParentType
		,SectionName
		,SettingName
		,Value

	From dbo.tmpFinalPolicies
		,ReportFullPathNode
		,leafnode, BranchNode
		,ComputerProperties, ProductProperties, AVIView_Software
	Where
		dbo.tmpFinalPolicies.nodeid = leafnode.autoid
		and leafnode.autoid = @NodeID
		and leafnode.autoid = computerproperties.parentid
		and leafnode.autoid = productproperties.parentid
		and leafnode.parentid = branchnode.autoid
		and dbo.tmpFinalPolicies.productcode = productproperties.productcode
		and productproperties.productcode = aviview_software.productcode
--		and Policysettings.value > ''
		AND 
		(
			(
				dbo.tmpFinalPolicies.ParentType in (3, 5, 6)
				and
				ReportFullPathNode.LowestNodeID = dbo.tmpFinalPolicies.PolicyParentID  --fix
				and leafnode.autoid = @NodeID
				and dbo.tmpFinalPolicies.PolicyParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType in (4, 7)
				and
				ReportFullPathNode.LowestNodeID = @ParentID
--				and leafnode.autoid = @NodeID
--				and Policy.ParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType = 1
				and
				ReportFullPathNode.LowestNodeID = @ParentID
				and dbo.tmpFinalPolicies.PolicyParentID = Leafnode.autoid
			)

		)
order by dbo.tmpFinalPolicies.productcode, sectionname, settingname

set @ret = @@rowcount

Drop Table  dbo.tmpFinalPolicies
Drop Table  dbo.tmpCompiledPolicies
Drop Table  dbo.tmpPolicy
Drop Table  dbo.tmpPolicyNodeList
Drop Table  dbo.tmpProducts

RETURN @ret
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterTaskSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterTaskSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterTaskSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szOptionalReportParms  VARCHAR(500) = ''
   , @NodeID int
--  , @ParentID int
--  , @ProductCode varchar(50)=''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

Declare @ret int

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


------------
-- postepo3 - cleanup temp tables
  
	IF EXISTS (select * from sysobjects where name = 'tmpFinalPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpFinalPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpCompiledPolicies' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpCompiledPolicies

	IF EXISTS (select * from sysobjects where name = 'tmpPolicy' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTask

	IF EXISTS (select * from sysobjects where name = 'tmpPolicyNodeList' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTaskNodeList

	IF EXISTS (select * from sysobjects where name = 'tmpProducts' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpProducts

	IF EXISTS (select * from sysobjects where name = 'tmpGlobalTaskID' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpGlobalTaskID


/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Find where properties are set for this product on this computer
	Declare @TaskID int
	Declare @TaskParentType int 
	Declare @TaskParentID int 
	Declare @ParentID int

	-- get parentid
	Select @ParentID = parentid from leafnode where autoid = @NodeID

	-- get all productcodes applying to this node
	select ProductProperties.ProductCode
	into dbo.tmpProducts
	from leafnode, ProductProperties, aviview_software
	where
		leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC') 
				or (AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%') 
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and leafnode.autoid = @NodeID


	-- get all branchnodes in the inheritance tree storing Task values
	SELECT Task.autoid, Task.ParentID, Task.ParentType, PathLength, Task.ProductCode
			Into dbo.tmpTaskNodeList
			FROM Task, BranchNodeEnum
			Where Task.parentid = Startautoid
				and Endautoid = @Parentid 
				and ProductCode in (select ProductCode from dbo.tmpProducts)
	
	-- write Task from inheritance path into temp table
	-- postepo3 33636 - only show task that are set not both set task and available default task
	-- collect tasks from all levels except global root level
	Select
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,(PathLength+1) as PathLength
		,SectionName
		,SettingName
		,Value
	into dbo.tmpTask
	From dbo.tmpTaskNodeList, Task, TaskSettings
	Where
		dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType != 7

	-- find all global taskids
	Select Distinct GlobalTaskID
	into	dbo.tmpGlobalTaskID
	From 	dbo.tmpTask

--select * from dbo.tmpTask

	-- Add tasksettings from global root level (GlobalTaskID <> 0) where task is defined at dir level or below
	-- In other words get all tasksettings for tasks defined for a computer
	Insert dbo.tmpTask
		(ProductCode
		,autoid
		,ParentID
		,ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,PathLength
		,SectionName
		,SettingName
		,Value)
	Select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,Task.TaskName
		,Task.TaskType
		,Task.TaskStatus
		,Task.Priority
		,Task.PlatformsSupported
		,Task.GlobalTaskID
		,(dbo.tmpTaskNodeList.PathLength+1) as PathLength
		,TaskSettings.SectionName
		,TaskSettings.SettingName
		,TaskSettings.Value
	From dbo.tmpTaskNodeList, dbo.tmpGlobalTaskID, Task, TaskSettings
	Where
		dbo.tmpGlobalTaskID.GlobalTaskID = Task.autoid
		and dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType = 7
		and Task.GlobalTaskID != 0

	-- find all global taskids again
	Truncate Table dbo.tmpGlobalTaskID

	Insert dbo.tmpGlobalTaskID
	Select Distinct GlobalTaskID
--	into	dbo.tmpGlobalTaskID
	From 	dbo.tmpTask
	
--select * from dbo.tmpTask

	-- Add tasksettings from global root level (GlobalTaskID = 0) where task is defined at dir level or below
	-- In other words get all tasksettings for tasks defined for a computer
	Insert dbo.tmpTask
		(ProductCode
		,autoid
		,ParentID
		,ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,PathLength
		,SectionName
		,SettingName
		,Value)
	Select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,Task.TaskName
		,Task.TaskType
		,Task.TaskStatus
		,Task.Priority
		,Task.PlatformsSupported
		,Task.GlobalTaskID
		,(dbo.tmpTaskNodeList.PathLength+1) as PathLength
		,TaskSettings.SectionName
		,TaskSettings.SettingName
		,TaskSettings.Value
	From dbo.tmpTaskNodeList, dbo.tmpGlobalTaskID, Task, TaskSettings
	Where
		dbo.tmpGlobalTaskID.GlobalTaskID = Task.autoid
		and dbo.tmpTaskNodeList.autoid = Task.autoid
		and dbo.tmpTaskNodeList.ProductCode = Task.ProductCode
		and Task.autoid = TaskSettings.parentid
		and Task.ParentType = 7
		and Task.GlobalTaskID = 0


	Drop table dbo.tmpGlobalTaskID



--select * from dbo.tmpTask

	-- Update default task settings so that they have the highest value (lowest priority)
	-- Global tasks are a copy of the default task and there priority should be 1 lower
	update dbo.tmpTask
	set PathLength = PathLength+1
	Where GlobalTaskID = 0 and ParentType=7

	update dbo.tmpTask		-- fix
	set PathLength = PathLength+1   --fix


	-- add any Task stored at the parent node
	insert into dbo.tmpTask
	select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,1  as PathLength	-- default 1 means parentnode,the smaller the number the higher the priority - fix
		,SectionName
		,SettingName
		,Value
		from Task, TaskSettings
		Where 
			Task.parentid = @ParentID
			and Task.ParentType in (3, 6)
			and Task.autoid = TaskSettings.parentid

--select * from dbo.tmpTask

	-- add any policies from the leafnode itself
	insert into dbo.tmpTask
	select 
		Task.ProductCode
		,Task.autoid
		,Task.ParentID
		,Task.ParentType
		,TaskName
		,TaskType
		,TaskStatus
		,Priority
		,PlatformsSupported
		,GlobalTaskID
		,0  as PathLength	-- default 0 means from the leafnode, the smaller the number the higher the priority  - fix
		,SectionName
		,SettingName
		,Value
		from Task, TaskSettings
		Where 
			Task.parentid = @NodeID
			and Task.ParentType = 1
			and Task.autoid = TaskSettings.parentid

--select * from dbo.tmpTask

	-- Get Top Priorities Task values
	Select
		ProductCode
		,TaskType
		,TaskName
		,SectionName
		,SettingName
		,min(PathLength) as PathLength
		into dbo.tmpCompiledPolicies
		from dbo.tmpTask
		group by
			ProductCode
			,TaskType
			,TaskName
			,SectionName
			,SettingName			

--select * from dbo.tmpCompiledPolicies  order by ProductCode, tasktype, taskname, sectionname, settingname

	-- build final Task list
	select 
		@NodeID as NodeID
		,@ParentID as NodeParentID
		,dbo.tmpTask.ProductCode
		,dbo.tmpTask.autoid
		,dbo.tmpTask.ParentID as TaskParentID
		,dbo.tmpTask.GlobalTaskID
		,dbo.tmpTask.ParentType
		,dbo.tmpTask.TaskName
		,dbo.tmpTask.TaskType
		,dbo.tmpTask.TaskStatus
		,dbo.tmpTask.Priority
		,dbo.tmpTask.PlatformsSupported
		,dbo.tmpTask.SectionName
		,dbo.tmpTask.SettingName
		,dbo.tmpTask.Value
		into dbo.tmpFinalPolicies
		from dbo.tmpCompiledPolicies, dbo.tmpTask
		Where 
			dbo.tmpCompiledPolicies.ProductCode =  dbo.tmpTask.ProductCode
			and dbo.tmpCompiledPolicies.TaskType =  dbo.tmpTask.TaskType	
			and dbo.tmpCompiledPolicies.TaskName =  dbo.tmpTask.TaskName				
			and dbo.tmpCompiledPolicies.Sectionname =  dbo.tmpTask.Sectionname			
			and dbo.tmpCompiledPolicies.SettingName =  dbo.tmpTask.SettingName			
			and dbo.tmpCompiledPolicies.PathLength = dbo.tmpTask.PathLength


-- select * from dbo.tmpFinalPolicies order by ProductCode, tasktype, taskname, sectionname, settingname

		

	-----------------------------------------------------------------------------------
	-- Collect Task details

	SELECT

   		AVIView_Software.SoftwareName as ProductName
   		,ProductVersion =
    			CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion 
     			ELSE '---' 
     			END
    		,cast( '' as varchar(10)) as VirusName		-- null field, used so that same rpt file can be used
   		,EngineVer =
    			CASE  
     			WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVer =
    			CASE 
     			WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
 		,BranchNode.NodeName AS NodeName 
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
  		,ComputerProperties.ComputerName
		, ProductProperties.Servicepack as Servicepack
   		, ProductProperties.Hotfix as Hotfix
   		, InheritedNode = 
			CASE dbo.tmpFinalPolicies.ParentType
			when 1 then leafnode.nodename		-- fix
			when 4 then 'Directory'
			when 7 then 'Global Root'
			else cast(  ReportFullPathNode.FullPathName as varchar(255))   
			end

		,dbo.tmpFinalPolicies.ProductCode
		,dbo.tmpFinalPolicies.autoid
		,dbo.tmpFinalPolicies.TaskParentID
		,dbo.tmpFinalPolicies.GlobalTaskID
		,dbo.tmpFinalPolicies.ParentType
		,dbo.tmpFinalPolicies.TaskName
		,dbo.tmpFinalPolicies.TaskType
		,dbo.tmpFinalPolicies.TaskStatus
		,dbo.tmpFinalPolicies.Priority
		,dbo.tmpFinalPolicies.PlatformsSupported
		,SectionName
		,SettingName
		,Value

	From dbo.tmpFinalPolicies
		,ReportFullPathNode
		,leafnode, BranchNode
		,ComputerProperties, ProductProperties, AVIView_Software
	Where
		dbo.tmpFinalPolicies.nodeid = leafnode.autoid
		and leafnode.autoid = @NodeID
		and leafnode.autoid = computerproperties.parentid
		and leafnode.autoid = productproperties.parentid
		and leafnode.parentid = branchnode.autoid
		and dbo.tmpFinalPolicies.productcode = productproperties.productcode
		and productproperties.productcode = aviview_software.productcode
--		and Tasksettings.value > ''
		AND 
		(
			(
				dbo.tmpFinalPolicies.ParentType in (3, 5, 6)
				and
				ReportFullPathNode.LowestNodeID = dbo.tmpFinalPolicies.TaskParentID  -- fix line
				and leafnode.autoid = @NodeID
				and dbo.tmpFinalPolicies.TaskParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType in (4, 7)
				and
				ReportFullPathNode.LowestNodeID = @ParentID
--				and leafnode.autoid = @NodeID
--				and Task.ParentID = BranchNode.autoid
			)
			OR
			(
				dbo.tmpFinalPolicies.ParentType = 1
				and
				ReportFullPathNode.LowestNodeID = @ParentID
				and dbo.tmpFinalPolicies.TaskParentID = Leafnode.autoid
			)

		)
--		and dbo.tmpFinalPolicies.TaskName > ''
		order by dbo.tmpFinalPolicies.ProductCode, tasktype, taskname, sectionname, settingname

set @ret = @@rowcount

Drop Table  dbo.tmpFinalPolicies
Drop Table  dbo.tmpCompiledPolicies
Drop Table  dbo.tmpTask
Drop Table  dbo.tmpTaskNodeList
Drop Table  dbo.tmpProducts

RETURN @ret
END
GO

-- end

--------------------------------------------------------------------
-- special test procedure: finds saved settings and returns value
-- used in testreporting stored procedure script
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_TestGetSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_TestGetSavedSettings]
GO

CREATE PROCEDURE dbo.AVISP_TestGetSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szOptionFlag	nvarchar(64) = ''  -- PRODUCTGROUP, PRODUPDATEGROUP, INFECTGROUP
	-- outputs
 , @Group1 varchar(50) output
 , @Group2 varchar(50) output
 , @Group3 varchar(50) output
 , @Group4 varchar(50) output
 , @szDrilldown	varchar(20) output
 , @InfectAfterYYYYMMDD varchar(30) output
 , @InfectAfterRule varchar(30) output
 , @ConnectType  varchar(20) output		
 , @ProductType  varchar(20) output
 , @AfterYYYYMMDD varchar(30) output
 , @AfterRule varchar(30) output
 , @szDrilldown1 varchar(30)	output
 , @EventType	varchar(50)	output
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 Declare @legal int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value prompt

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

--select @szOptionFlag as value, @szOptionFlag as prompt
 Set @ret = 0
 Set @legal = 1

 IF @szOptionFlag > ''	-- fetch all setting values for a given name
 BEGIN
	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt= ReportInputParametersSaved.ParmValuePrompt
		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFilter
		and ReportInputParametersSaved.ReportID  = @szReportID 

	-- was saved setting found
	set @legal = @@rowcount
	
--select * from ReportInputParameters where ReportInputParameters.ReportID  = @szReportID 

	-- Fetch translated text strings for localized parameter value prompt
	-- problem: need to get translation into reportinputparameter table

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


	-- fetch all parm values that get saved back to the DB and have settingname = @szFilter
	-- read group parms into parmeters
	-- This is used in test script to run the stored procedure for each saved parameter
	select @Group1 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName1'

	select @Group2 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName2'

	select @Group3 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName3'

	select @Group4 = ParmValue from ReportInputParameters
	Where ReportID = @szReportID and iSaveUserEntry = 1	
		and ParmName = '@szGroupName4'

	if @szReportID = 'PRODUCTGROUP'
	begin
		select @szDrilldown = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown'

		select @InfectAfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterYYYYMMDD'

		select @InfectAfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterRule'

		select @ConnectType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@ConnectType'

		select @ProductType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@ProductType'

	end
	else if @szReportID = 'PRODUPDATEGROUP'
	begin
		select @szDrilldown = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown'

		select @AfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@AfterYYYYMMDD'

		select @AfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@AfterRule'

	end	
	else if @szReportID = 'INFECTGROUP'
	begin
		select @InfectAfterYYYYMMDD = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterYYYYMMDD'

		select @InfectAfterRule = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@InfectAfterRule'

		select @szDrilldown1 = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@szDrilldown1'

		select @EventType = ParmValue from ReportInputParameters
		Where ReportID = @szReportID and iSaveUserEntry = 1	
			and ParmName = '@EventType'


	end				

 	Set @ret = @@rowcount	
 END	

if @legal = 0
	set @ret = -1

RETURN @ret 
END
GO



--------------------------------------------------------------------
-- special test procedure: finds saved settings and returns value
-- used in testreporting stored procedure script
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Count_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Count_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_Count_Orphaned_Events
AS
BEGIN

DECLARE @cnt int
Set @cnt = 0
DECLARE @cnt1 int
Set @cnt1 = 0

SELECT @cnt = count(Events.AutoID)
FROM dbo.Events
WHERE (dbo.Events.AgentGUID IS NULL) 
OR (dbo.Events.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

Update ProductEvents
Set NodeID = NULL
From Leafnode
WHERE 
 (dbo.ProductEvents.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

SELECT @cnt1 = count(*)
FROM dbo.ProductEvents
WHERE (dbo.ProductEvents.NodeID IS NULL) 

select @cnt + @cnt1 

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_FixUp_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_FixUp_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_FixUp_Orphaned_Events
--(
--	@blockstart int,
--	@blockend int
--)
AS
BEGIN

-- process the productevents table on the first time through
--if exists (select * from Events where %1 <= 1 or %1 = ( select min(autoid) from events ) )
UPDATE ProductEvents
SET ProductEvents.AgentGUID = LeafNode.AgentGUID,
	ProductEvents.NodeID = LeafNode.AutoID
FROM LeafNode, ComputerProperties
WHERE 
	LeafNode.AutoID = ComputerProperties.ParentID
	AND ProductEvents.HostName = ComputerProperties.ComputerName
     AND (ProductEvents.AgentGUID NOT IN 
		(SELECT AgentGUID FROM LeafNode) OR ProductEvents.AgentGUID IS NULL) 
--	 AND (ProductEvents.AutoID >= %1) AND (ProductEvents.AutoID <= %2)

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Remove_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Remove_Events]
GO


CREATE PROCEDURE dbo.AVISP_Util_Remove_Events
(
	@Startdate DateTime,
	@Enddate DateTime
)
AS
BEGIN

-- process the productevents table on the first time through
DELETE FROM ProductEvents WHERE  (EventDateTime >= @Startdate) AND (EventDateTime <= @Enddate)

END
go







-------------------






-- end