
-- AutoClose property of ePO databases should always be cleared.
--exec sp_dboption N'SERVERNAME_ePO', N'autoclose', N'false'
GO

-----------------------------------------------------------------------------
-- Patch 6 modifies software table to remove bogus PATCH___1000 version that was never released.
-- BZ202698
-- This script was written by the SCP team (Damon Gallaty)
-----------------------------------------------------------------------------
IF EXISTS (SELECT * FROM Software WHERE ProductCode = 'PATCH___1000' AND (SoftwareName = '' OR SoftwareName IS NULL))
BEGIN
DELETE Software WHERE ProductCode = 'PATCH___1000'
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVirusType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVirusType]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



-- Patch 8 fix 207989: cast fixed length string so that it will hold larger text value on update
CREATE PROCEDURE dbo.AVISP_FilterVirusType
(
	@iNameSpaceName		VARCHAR(20),
	@iNameSpaceNode		VARCHAR(20),
    	@szEpoUserName          VARCHAR(100),
	@szNameSpaceName		VARCHAR(100),
	@szNameSpaceNode		VARCHAR(500),
 	@szOptionalReportParms  VARCHAR(500) = ''
 -- these inputs are needed in order for the infections by custom daat report to call this procedure
 , @szGroupName1  VARCHAR(100) = 'VirusType'
 , @szGroupName2  VARCHAR(100) = 'VirusSubtype'
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)='Drilldown'	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved

/*	 , @dtStartDate			DateTime */
)
AS
BEGIN
 	/* Copyright + 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	Declare @maxid int
	Declare @ret int

/* Fetch Top Nodeid to filter data on if report filter or users TopNode indicated filtering */
	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int	select @UsersTopNodeID = convert(int, @iNameSpaceName)
	select @FilterNodeID = convert(int, @iNameSpaceNode)

	Declare @FilterID int
	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



----------------
-- Make sure tmp tables are cleaned up
-- postepo3 collation between epo db and tempdb can be different, therefore dont use tempdb anymore, cleanup myself

	IF EXISTS (select * from sysobjects where name = 'tmpVirusname' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusname

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileType' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileType

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtype' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtype


/* Fetch all unique VirusNames, with the latest VirusType entry */
-- Patch 9 fix: cast fix length string so that it will hold larger text value on update
SELECT
	VirusName
	, cast(max( DATVersion + 'VT:' + VirusType) as varchar(128)) as 'LatestVirusType'
	, cast('Blank virus type' as varchar(128)) as VirusType
into dbo.tmpVirusname
FROM Events
where virusname > ''
Group by
	VirusName

/* Strip the virustype data out of the latestvirustype field */
update
dbo.tmpVirusname
set VirusType = 
substring( LatestVirusType 
	, charindex('VT:',LatestVirusType)+3 
	, Len(LatestVirusType)-charindex('VT:',LatestVirusType)+3)




/* match virusname with cross product of all matching virus file platform type prefixes */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusFiletypeCrossProduct
FROM
	dbo.tmpVirusname, VirusFilePlatformTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusFilePlatformTypeDesc.VirusPrefix, dbo.tmpVirusname.VirusName), 
		len(VirusFilePlatformTypeDesc.VirusPrefix) ) = VirusFilePlatformTypeDesc.VirusPrefix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from VirusFilePlatformTypeDesc
	INSERT dbo.tmpVirusFiletypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusFiletypePriority
	FROM
		dbo.tmpVirusFiletypeCrossProduct
	GROUP BY
		VirusName


	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusFileType,
	 	VirusPlatformType,
		VirusType
	INTO
		dbo.tmpVirusFiletype
	FROM
		dbo.tmpVirusFiletypePriority, VirusFilePlatformTypeDesc
	WHERE
		dbo.tmpVirusFiletypePriority.Priority = VirusFilePlatformTypeDesc.AutoID

	

/* match virusname with cross product of all matching virus file platform type */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusSubtypeCrossProduct
FROM
	dbo.tmpVirusname, VirusTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusTypeDesc.VirusSuffix, dbo.tmpVirusname.VirusName), 
		len(VirusTypeDesc.VirusSuffix) ) = VirusTypeDesc.VirusSuffix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from  VirusTypeDesc
	INSERT dbo.tmpVirusSubtypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusSubtypePriority
	FROM
		dbo.tmpVirusSubtypeCrossProduct
	GROUP BY
		VirusName
		

	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusType
	INTO
		dbo.tmpVirusSubtype
	FROM
		dbo.tmpVirusSubtypePriority, VirusTypeDesc
	WHERE
		dbo.tmpVirusSubtypePriority.Priority = VirusTypeDesc.AutoID



/* Generate final VirusType Table from subtables */
DELETE VirusType 

INSERT 
	VirusType
(VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID)
	SELECT
		 dbo.tmpVirusname.VirusName,
  		 VirusFileType,
 		 VirusPlatformType,
 		 VirusType = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
--		 NULL, NULL,
 		 VirusTypeTranslated = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
		 '0409' as LanguageID
	FROM
		dbo.tmpVirusname, dbo.tmpVirusFiletype, dbo.tmpVirusSubtype
	WHERE
		dbo.tmpVirusname.VirusName = dbo.tmpVirusFiletype.VirusName 
		AND	dbo.tmpVirusFiletype.VirusName = dbo.tmpVirusSubtype.VirusName 

Set @ret = @@rowcount

-- mhilandepo3 postepo3 fix: 1) make sure VirusTypeTranslated is overridden as well 2) dont overwrite if VT < 'a'
-- mhilandepo3 subtitute events.virustype where suffix prefix rules fail
/* Override VirusType derived from VirusName with certain fields from the events.virustype field */
UPDATE
	VirusType
	SET	
		VirusFileType = 
			CASE VirusType.VirusType
				WHEN 'Mass Mailer' then 'Mass Mailer'
				else VirusType.VirusFileType
			END
		,VirusType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'APP' then 'Application'
--				WHEN 'Program' then 'Program'
				WHEN 'Trojan' then 'Trojan'
				WHEN 'Joke' then 'Joke'
				WHEN 'Test' then 'Test'
				else VirusType.VirusType
			END
		,VirusTypeTranslated = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'APP' then 'Application'
				WHEN 'Trojan' then 'Trojan'
				WHEN 'Joke' then 'Joke'
				WHEN 'Test' then 'Test'
				WHEN 'Program' then 'Program'
				else VirusType.VirusType
			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND dbo.tmpVirusname.VirusType in ('APP','Trojan','Joke','Test'
			 ,'Program' )

/* Replace uncategorized viruses with data in events.virustype field */
UPDATE
	VirusType
	SET
		VirusType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
--		VirusTypeTranslated = 
--			CASE dbo.tmpVirusname.VirusType
--				WHEN 'Known Virus' then 'Virus'
--				WHEN 'Virus' then 'Virus'
--				WHEN '' then 'UnCategorized'
--				WHEN NULL then 'UnCategorized'
--				else dbo.tmpVirusname.VirusType
--			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


UPDATE
	VirusType
	SET
		VirusFileType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusFileType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


-- Translate it everytime
-- Translate VirusType name
--if @szFullLang <> '0409'
--begin
UPDATE
	VirusType
	SET
		VirusTypeTranslated =  
			CASE 
				WHEN ReportTranslations.TranslatedValue > '' then ReportTranslations.TranslatedValue
				else VirusType.VirusType
			END
	FROM	ReportTranslations
	WHERE	ReportTranslations.TextID = VirusType.VirusType
		AND ReportTranslations.Subject = 'Virustype'
		AND ReportTranslations.LanguageID = @szFullLang

Update VirusType
	Set LanguageID = @szFullLang
--end


/*select * from virustype*/


-- Output results if not set to batch mode (otherwise it only updates the virustype table
IF @szOptionalReportParms <> 'BatchModeUpdateTableOnly'
Begin

	
/* Final Selection getting all Event data for report */
-- virus type report works in fast group summary fetch mode only


 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		,cast('' as varchar(16)) as 'Day'
		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,cast('' as varchar(10)) as ProductFamily
		,cast('' as varchar(10)) as ServicePack
		,cast('' as varchar(10)) as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- Agent info fields
--		, LeafNode.AgentVersion
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- Computer Info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows
--    		, (CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, LeafNode.LastUpdate as LastContact
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
		, '' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusType > ''  then VirusType.VirusType
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
--		,'' as VirusType
		, VirusType.VirusTypeTranslated as VirusType
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then 'Informational'
			when 1 then 'Warning'
			when 2 then 'Minor'
			when 3 then 'Major'
			when 4 then 'Critical'
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, ScanTime 
		,'' as ScanTime
		,'' as EventDesc
		
		, '' as RuleName

		-- Product update fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
   	(
	BranchNode Join LeafNode on (LeafNode.ParentID = BranchNode.AutoID) 
	Join ComputerProperties on (ComputerProperties.ParentID = LeafNode.AutoID)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
	) on (Events.NodeID = LeafNode.AutoID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR

  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		Events.VirusName > '' 
    		OR
		Events.VirusType > ''
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
--	AND Events.VirusName = VirusType.VirusName
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' ) 
		or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	)
        AND Events.ProductName != 'ePO Agent' 
        AND Events.ProductName != 'ePO Agent' 
--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
/*   	AND LeafNode.Type =1 */

	-- fast group summary group by clause
	Group By
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		DateName(Year, EventDateTime)
--		,Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month'
--		,Datename(Week, EventDateTime)
--		,Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform


--END	-- FilterID

Set @ret = @@rowcount

END	-- BatchModeUpdateTableOnly


/* cleanup */
	DROP TABLE dbo.tmpVirusname
	DROP TABLE dbo.tmpVirusFiletypeCrossProduct
	DROP TABLE dbo.tmpVirusSubtypeCrossProduct
	DROP TABLE dbo.tmpVirusFiletypePriority
	DROP TABLE dbo.tmpVirusSubtypePriority
	DROP TABLE dbo.tmpVirusFiletype
	DROP TABLE dbo.tmpVirusSubtype


RETURN @ret
END
GO



-----------------------------------------------------------------------------
-- Patch 6 modifies AVISP_FilterVAlertGroupsSubreport stored procedure.
-- BZ159930
-- Patch 8 change: BZ209610: make sure either VS8 or non-VS8 version gets loaded correctly
-----------------------------------------------------------------------------

-----------------------------------------------------------------------------
-- Custom Group Data subreports

-------------------------------
-- load non VS8 version

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreport]
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
 ,@szNameSpaceName  VARCHAR(100)
 ,@szNameSpaceNode  VARCHAR(500)
 ,@szOptionalReportParms  VARCHAR(500) = ''
 ,@szGroup1 varchar(100) = ''
 ,@szGroupValue1 varchar(100) = ''
 ,@szGroup2 varchar(100) = ''
 ,@szGroupValue2 varchar(100) = ''
 ,@szGroup3 varchar(100) = ''
 ,@szGroupValue3 varchar(100) = ''
 ,@szGroup4 varchar(100) = ''
 ,@szGroupValue4 varchar(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @EventType varchar(50) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@EventType) != 'all'
	and lower(@EventType) != 'notinfection'
	and lower(@EventType) != 'infection'
	and lower(@EventType) != 'Infection-Res'
	and lower(@EventType) != 'Infection-Unr'
	and lower(@EventType) != 'Infection-Cle'
	and lower(@EventType) != 'Infection-Del'
	and lower(@EventType) != 'Infection-Mov'
		 Set @Inputlegal = 0

 -- translate webshield groupnames into actual event fieldname
 Declare @Webshield int
 Set @Webshield = 0
 if lower(@EventType) = 'contentfilter'
	or lower(@EventType) = 'contentscanning'
	or lower(@EventType) = 'spam'
	or lower(@EventType) = 'urlblocked'
	or lower(@EventType) = 'virus'
 Begin
	Set @Webshield = 1
	if @szGroup1 = 'RuleName'
		Set @szGroup1 = 'VirusName'
	if @szGroup2 = 'RuleName'
		Set @szGroup2 = 'VirusName'
	if @szGroup3 = 'RuleName'
		Set @szGroup3 = 'VirusName'
	if @szGroup4 = 'RuleName'
		Set @szGroup4 = 'VirusName'
	if @szGroup1 = 'Server'
		Set @szGroup1 = 'HostName'
	if @szGroup2 = 'Server'
		Set @szGroup2 = 'HostName'
	if @szGroup3 = 'Server'
		Set @szGroup3 = 'HostName'
	if @szGroup4 = 'Server'
		Set @szGroup4 = 'HostName'
	if @szGroup1 = 'Spammer'
		Set @szGroup1 = 'UserName'
 End


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node (done in main routine)
 --select distinct AgentGUID
 --into #LostLinksEvents
 --from Events
 --	where AgentGUID not in (select AgentGUID from leafnode)
  

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- strip top10 suffix if present
	if substring(@EventType, 1, 5) = 'T10Vr' 
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	else if substring(@EventType, 1, 5) = 'T10Fl' 
		Set @EventType = Replace( @EventType, 'T10Fl', '')
	else if substring(@EventType, 1, 5) = 'T10Ur' 
		Set @EventType = Replace( @EventType, 'T10Ur', '')
	else if substring(@EventType, 1, 5) = 'T10Cp' 
		Set @EventType = Replace( @EventType, 'T10Cp', '')

   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100) 
   Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100) 
   Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100) 
   Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100) 
   Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100) 
   Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100) 
   Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100) 
   Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  -- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)  	
	Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  
	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  
	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  
	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  
	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  
	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  
	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  
	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  
	Declare @szConnectStatus     VARCHAR(50) 
	Declare @szAgentType	varchar(50) 
	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)
	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 
	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50) 
    	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 
	Declare @szEventDesc varchar(255) 
	Declare	@szVirusSubType varchar(50)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = ''  
	Set @szVirusSubType = ''

   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms,
					@szGroup1, @szGroup2, @szGroup3, @szGroup4 
					     ,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
						,@szGroupYear  OUTPUT
						,@szGroupMonth  OUTPUT
						,@szGroupQuarter  OUTPUT 
						,@szGroupWeek  OUTPUT  
						,@szGroupVirusName  OUTPUT
						,@szGroupActionTaken  OUTPUT
						,@szGroupNodeName  OUTPUT
						,@szGroupProductName  OUTPUT
						,@szGroupProductVersion  OUTPUT
						,@szGroupEngineVersion  OUTPUT
						,@szGroupDATVersion  OUTPUT
						,@szGroupFileName  OUTPUT
						,@szGroupHostName  OUTPUT
						,@szGroupUserName  OUTPUT
						,@szGroupExtraDATNames      OUTPUT		-- coverage data 
						,@szGroupDomainName      OUTPUT		-- coverage data 
						,@szGroupOSVersion       OUTPUT
						,@szGroupServicepack       OUTPUT
						,@szGroupHotfix       OUTPUT
						,@szGroupLicenseStatus       OUTPUT
						,@szGroupExpirationDate       OUTPUT
						,@szGroupAgentVersion       OUTPUT		-- update event data
						,@szGroupType       OUTPUT
						,@szGroupVersion       OUTPUT
						,@szGroupError       OUTPUT
						,@szGroupLanguage       OUTPUT
						,@szGroupSiteName       OUTPUT
						,@szGroupInitiatorID       OUTPUT
						,@szGroupInitiatorType       OUTPUT
						,@szGroupDay       OUTPUT
						,@szGroupHour       OUTPUT
						,@szAgentVersion output
						,@szLicensed output
						,@szConnectStatus output 
						,@szAgentType	output
						,@szOSType output
						,@szOSPlatform output
						,@szVirusType output
						,@szFullProductName output
						,@szEngineDat output
						,@szDatExtraDat output
    						,@szTVDSeverity OUTPUT
    						,@szTVDTaskName OUTPUT
						,@szEventDesc OUTPUT
						,@szVirusSubType OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	



---------------------------------------------------------------
-- Do not use outer joins here
-- if the group is on a field partiipating in an outer join not only will the fields matching value be returned but all outerjoin rows (null values) as well
-- too much data gets sent.

-- avoid outer join on eventdesc table: if no match then row wont be returned - too little data returned
-- keep outer join in actiodesc & virustype ion events are caught
-- note: missing entries in EventFilterDescFast will result in rows not being returned



--select @szGroupActionTaken


-- warning:  dont do outer join on a group field: it breaks in these subreports returning to many rows
 
 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(Events.UserName AS varchar(32)) AS UserName
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  cast(BranchNode.Nodename as varchar(255))
			ELSE @Unlinked
			END 


    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype

    		,cast( TVDEventID as varchar(10)) as TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		ScanTime 
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
		-- epo3.5 post3.0.2. If severity match note found in eventfilterdesc, translate numbers to text
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity

    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
    		,CAST(ProductID as int) As ProductID

		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc

		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(@EventType in ('All', 'NotInfection') 
		and events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND ( TVDEventID not in (1202, 1203, 4650, 4651 ) )
	and ( @YYYYMMDD is null or Events.EventDateTime >=  @YYYYMMDD)
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionUr' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionCp' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or ( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or ( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or ( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or ( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	)

        AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime) = @szGroupYear
	) 
        AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth
		)
	) 
        AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Quarter, EventDateTime)) = @szGroupQuarter
		)
	) 
        AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek
		)
	) 
        AND 		-- day of month
	(	 @szGroupDay = ''
		OR 
		convert(varchar(20), DateName(Day, EventDateTime)) = @szGroupDay
	) 
        AND 		-- hour of day
	(	 @szGroupHour = ''
		OR 
		convert(varchar(20), DateName(Hour, EventDateTime)) = @szGroupHour
	) 
        AND 
	(	 @szGroupVirusName = ''
		OR Events.VirusName = @szGroupVirusName
	) 
        AND 
	(	 @szGroupActionTaken = ''
		OR (@szGroupActionTaken = ReportActionDesc.ActionName )
		OR (@szGroupActionTaken > '' and convert(varchar(25),ActionTaken) = @szGroupActionTaken )
	) 
        AND 
	(	 @szTVDSeverity = ''
		or ( @szTVDSeverity = EventFilterDescFast.Severity )
		OR ( @szTVDSeverity = @Informational and Events.TVDSeverity = 0 )
		OR ( @szTVDSeverity = @Warning and Events.TVDSeverity = 1 )
		OR ( @szTVDSeverity = @Minor and Events.TVDSeverity = 2 )
		OR ( @szTVDSeverity = @Major and Events.TVDSeverity = 3 )
		OR ( @szTVDSeverity = @Critical and Events.TVDSeverity = 4 )
		OR ( @szTVDSeverity = '---' and (Events.TVDSeverity > 4  or Events.TVDSeverity < 0) )
	) 
        AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
		or ( @szGroupNodeName = '---' and (BranchNode.NodeName is NULL) )
	) 
        AND 
	(	 @szGroupProductName = ''
		OR ProductName = @szGroupProductName
	) 
        AND 
	(	 @szGroupProductVersion = ''
		OR ProductVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (ProductVersion is NULL or ProductVersion = '') )
	) 
        AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVersion = @szGroupEngineVersion
	) 
        AND 
	(	 @szGroupDATVersion = ''
		OR DATVersion = @szGroupDATVersion
	) 
        AND 	-- make this a like operator since the filename is cropped
	(	 @szGroupFileName = ''
		-- epo3.x patch6 Sometimes filename can have _[] chars in it which will break the like operator
		OR right(Events.FileName,15) = @szGroupFileName 
		OR Events.FileName = @szGroupFileName
		OR FileName like ('%' + @szGroupFileName)
	) 
        AND 
	(	 @szGroupHostName = ''
		OR Events.HostName = @szGroupHostName
	) 
        AND 
	(	 @szGroupUserName = ''
		OR Events.UserName = @szGroupUserName
	) 
        AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName = '' or Domainname is null) )
		or ( @szGroupDomainName = '---' and (DomainName = '' or Domainname is null) )
	) 
        AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType = '' or OSType is null) )
		or ( @szOSType = '---' and (OSType = '' or OSType is null) )
	) 
        AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform = '' or OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '' or OSPlatform is NULL) )
	) 
        AND 
	(	 @szVirusType = ''
		OR VirusType.VirusTypeTranslated = @szVirusType 
		or Events.VirusType = @szVirusType 
		or (@szVirusType = '---' and (Events.VirusType = '' or Events.VirusType is NULL))
	) 
        AND 
	(	 @szVirusSubtype = ''
		OR VirusType.VirusFileType = @szVirusSubtype 
		or (@szVirusSubtype = '---' and (VirusType.VirusFileType = '' or VirusType.VirusFileType is NULL))
	) 
        AND 
	(	 @szFullProductName = ''
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		or (@szFullProductName = '---' and ((ProductName + ' ' + ProductVersion) = ' ' or (ProductName + ' ' + ProductVersion) is NULL))
	) 
        AND 
	(	 @szEngineDat = ''
		OR (EngineVersion + ' ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion + ' \ ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion)  = @szEngineDat 
		OR (DATVersion)  = @szEngineDat 
		or (@szEngineDat = '---' and ((EngineVersion + ' ' + DATVersion) = ' ' or (EngineVersion + ' ' + DATVersion) is NULL))
	) 
        AND 
	(	 @szTVDTaskName = ''
		OR TVDTaskName = @szTVDTaskName 
	) 
        AND 
	(	 
		@szEventDesc = ''
		or EventFilterDescFast.Name = @szEventDesc
		or cast(Events.TVDEventID as varchar(128)) = @szEventDesc
		or (@szEventDesc = '---' and (Events.TVDEventID = '' or Events.TVDEventID is NULL))
	) 


	set @ret = @@rowcount

--	Drop Table #LostLinksEvents

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO



-----------------------------------------------------------------------------
-----------------------------------------------------------------------------
--
-- NOTE: Load this portion at the end because it will purposely error when
--	loading on non VS8 systems. And dont want anything misses that shouldnt be.
--	Cannot put create procedures within an if statement.
--	Load new changes here not at the end of this script
--	LOADHERE
--
-----------------------------------------------------------------------------
-----------------------------------------------------------------------------


-- load new changes here........



---------------------------------------------
---------------------------------------------
--
-- load VS8 versions of abouve fixes
--	Fixes are loaded into a separate procedue name then renamed later
--	DO NOT LOAD ANY non VS8 changes after this comment
--
---------------------------------------------
---------------------------------------------

---------------------------------------------------------------
-- Fixes for VS8 version virustype report: 207989 
-- Existing epo routine, dont replace if epoversion >= 3.5.0

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVirusTypeVS8]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	and exists (select epoversion from serverinfo where epoversion < '3.5.0')
drop procedure [dbo].[AVISP_FilterVirusTypeVS8]
GO

CREATE PROCEDURE dbo.AVISP_FilterVirusTypeVS8
(
	@iNameSpaceName		VARCHAR(20),
	@iNameSpaceNode		VARCHAR(20),
    	@szEpoUserName          VARCHAR(100),
	@szNameSpaceName		VARCHAR(100),
	@szNameSpaceNode		VARCHAR(500),
 	@szOptionalReportParms  VARCHAR(500) = ''
 -- these inputs are needed in order for the infections by custom daat report to call this procedure
 , @szGroupName1  VARCHAR(100) = 'VirusType'
 , @szGroupName2  VARCHAR(100) = 'VirusSubtype'
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)='Drilldown'	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved

/*	 , @dtStartDate			DateTime */
)
AS
BEGIN
 	/* Copyright + 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	Declare @maxid int
	Declare @ret int

/* Fetch Top Nodeid to filter data on if report filter or users TopNode indicated filtering */
	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int	select @UsersTopNodeID = convert(int, @iNameSpaceName)
	select @FilterNodeID = convert(int, @iNameSpaceNode)

	Declare @FilterID int
	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



----------------
-- Make sure tmp tables are cleaned up
-- postepo3 collation between epo db and tempdb can be different, therefore dont use tempdb anymore, cleanup myself

	IF EXISTS (select * from sysobjects where name = 'tmpVirusname' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusname

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypeCrossProduct' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypeCrossProduct

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileTypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileTypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtypePriority' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtypePriority

	IF EXISTS (select * from sysobjects where name = 'tmpVirusFileType' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusFileType

	IF EXISTS (select * from sysobjects where name = 'tmpVirusSubtype' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpVirusSubtype


/* Fetch all unique VirusNames, with the latest VirusType entry */
SELECT
	VirusName
	, cast(max( DATVersion + 'VT:' + VirusType) as varchar(128)) as 'LatestVirusType'
	, cast('Blank virus type' as varchar(128)) as VirusType

into dbo.tmpVirusname
FROM Events
where virusname > ''
Group by
	VirusName

/* Strip the virustype data out of the latestvirustype field */
update
dbo.tmpVirusname
set VirusType = 
substring( LatestVirusType 
	, charindex('VT:',LatestVirusType)+3 
	, Len(LatestVirusType)-charindex('VT:',LatestVirusType)+3)


--select * from dbo.tmpVirusname order by virusname

/* match virusname with cross product of all matching virus file platform type prefixes */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusFiletypeCrossProduct
FROM
	dbo.tmpVirusname, VirusFilePlatformTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusFilePlatformTypeDesc.VirusPrefix, dbo.tmpVirusname.VirusName), 
		len(VirusFilePlatformTypeDesc.VirusPrefix) ) = VirusFilePlatformTypeDesc.VirusPrefix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from VirusFilePlatformTypeDesc
	INSERT dbo.tmpVirusFiletypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusFiletypePriority
	FROM
		dbo.tmpVirusFiletypeCrossProduct
	GROUP BY
		VirusName


	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusFileType,
	 	VirusPlatformType,
		VirusType
	INTO
		dbo.tmpVirusFiletype
	FROM
		dbo.tmpVirusFiletypePriority, VirusFilePlatformTypeDesc
	WHERE
		dbo.tmpVirusFiletypePriority.Priority = VirusFilePlatformTypeDesc.AutoID

	

/* match virusname with cross product of all matching virus file platform type */
SELECT
	VirusName,
  	AutoID as Priority
INTO
	dbo.tmpVirusSubtypeCrossProduct
FROM
	dbo.tmpVirusname, VirusTypeDesc
WHERE
	SUBSTRING( dbo.tmpVirusname.VirusName, 
		CHARINDEX(VirusTypeDesc.VirusSuffix, dbo.tmpVirusname.VirusName), 
		len(VirusTypeDesc.VirusSuffix) ) = VirusTypeDesc.VirusSuffix


	/* Make sure every VirusName is in the Cross product table at least once */
        select @maxid=max(autoid) from  VirusTypeDesc
	INSERT dbo.tmpVirusSubtypeCrossProduct
		SELECT VirusName, @maxid  From dbo.tmpVirusname

	/* Remove multiple matches by priority */
	SELECT
		VirusName,
	 	min(Priority) as Priority
	INTO
		dbo.tmpVirusSubtypePriority
	FROM
		dbo.tmpVirusSubtypeCrossProduct
	GROUP BY
		VirusName
		

	/* Generate VirusFileType Table */
	SELECT
		VirusName,
		VirusType
	INTO
		dbo.tmpVirusSubtype
	FROM
		dbo.tmpVirusSubtypePriority, VirusTypeDesc
	WHERE
		dbo.tmpVirusSubtypePriority.Priority = VirusTypeDesc.AutoID



/* Generate final VirusType Table from subtables */
DELETE VirusType 

INSERT 
	VirusType
(VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID)
	SELECT
		 dbo.tmpVirusname.VirusName,
  		 VirusFileType,
 		 VirusPlatformType,
 		 VirusType = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
--		 NULL, NULL,
 		 VirusTypeTranslated = 
			CASE dbo.tmpVirusSubtype.VirusType
				WHEN 'UnCategorized' THEN dbo.tmpVirusFiletype.VirusType
				ELSE dbo.tmpVirusSubtype.VirusType
			END, 
		 '0409' as LanguageID
	FROM
		dbo.tmpVirusname, dbo.tmpVirusFiletype, dbo.tmpVirusSubtype
	WHERE
		dbo.tmpVirusname.VirusName = dbo.tmpVirusFiletype.VirusName 
		AND	dbo.tmpVirusFiletype.VirusName = dbo.tmpVirusSubtype.VirusName 

Set @ret = @@rowcount

-- mhilandepo3 postepo3 fix: 1) make sure VirusTypeTranslated is overridden as well 2) dont overwrite if VT < 'a'
-- mhilandepo3 subtitute events.virustype where suffix prefix rules fail
/* Override VirusType derived from VirusName with certain fields from the events.virustype field */
UPDATE
	VirusType
	SET	
		VirusFileType = 
			CASE VirusType.VirusType
				WHEN 'Mass Mailer' then 'Mass Mailer'
				else VirusType.VirusFileType
			END
		,VirusType.VirusType = tmpVirusname.VirusType
		,VirusType.VirusTypeTranslated = tmpVirusname.VirusType
--		,VirusType = 
--			CASE dbo.tmpVirusname.VirusType
--				WHEN 'APP' then 'Application'
--				WHEN 'Trojan' then 'Trojan'
--				WHEN 'Joke' then 'Joke'
--				WHEN 'Test' then 'Test'
--				else VirusType.VirusType
--			END
--		,VirusTypeTranslated = 
--			CASE dbo.tmpVirusname.VirusType
--				WHEN 'APP' then 'Application'
--				WHEN 'Trojan' then 'Trojan'
--				WHEN 'Joke' then 'Joke'
--				WHEN 'Test' then 'Test'
--				WHEN 'Program' then 'Program'
--				else VirusType.VirusType
--			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		-- vs7.5 handle new APP_ virustypes and create a mechanism for creating
		--	and automatically catching new virustypes
		AND (
			dbo.tmpVirusname.VirusType in ('APP','Trojan','Joke','Test','Program')
			or 
			dbo.tmpVirusname.VirusType like 'APP_%'
			or
			dbo.tmpVirusname.VirusType like 'VS_%'	-- default prefix to capture new virus type
		 )

/* Replace uncategorized viruses with data in events.virustype field */
UPDATE
	VirusType
	SET
		VirusType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
--		VirusTypeTranslated = 
--			CASE dbo.tmpVirusname.VirusType
--				WHEN 'Known Virus' then 'Virus'
--				WHEN 'Virus' then 'Virus'
--				WHEN '' then 'UnCategorized'
--				WHEN NULL then 'UnCategorized'
--				else dbo.tmpVirusname.VirusType
--			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


UPDATE
	VirusType
	SET
		VirusFileType = 
			CASE dbo.tmpVirusname.VirusType
				WHEN 'Known Virus' then 'Virus'
				WHEN 'Virus' then 'Virus'
				WHEN '' then 'UnCategorized'
				WHEN NULL then 'UnCategorized'
				else dbo.tmpVirusname.VirusType
			END
	FROM	dbo.tmpVirusname
	WHERE	dbo.tmpVirusname.VirusName = VirusType.VirusName
		AND 
		   VirusType.VirusFileType = 'UnCategorized'
--		and dbo.tmpVirusname.VirusType > 'a'


-- Translate it everytime
-- Translate VirusType name
--if @szFullLang <> '0409'
--begin
UPDATE
	VirusType
	SET
		VirusTypeTranslated =  
			CASE 
				WHEN ReportTranslations.TranslatedValue > '' then ReportTranslations.TranslatedValue
				else VirusType.VirusType
			END
	FROM	ReportTranslations
	WHERE	ReportTranslations.TextID = VirusType.VirusType
		AND ReportTranslations.Subject = 'Virustype'
		AND ReportTranslations.LanguageID = @szFullLang

Update VirusType
	Set LanguageID = @szFullLang
--end


/*select * from virustype*/


-- Output results if not set to batch mode (otherwise it only updates the virustype table
IF @szOptionalReportParms <> 'BatchModeUpdateTableOnly'
Begin

	
/* Final Selection getting all Event data for report */
-- virus type report works in fast group summary fetch mode only


 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		,cast('' as varchar(16)) as 'Day'
		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
		,cast('' as varchar(10)) as ProductFamily
		,cast('' as varchar(10)) as ServicePack
		,cast('' as varchar(10)) as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
		, '' as DatExtraDat

		-- Agent info fields
--		, LeafNode.AgentVersion
		, '' as AgentVersion
		, '' as AgentType
		, '' as ConnectStatus

		-- Computer Info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows
--    		, (CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, LeafNode.LastUpdate as LastContact
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID
--		, NodeID
		, '' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusType > ''  then VirusType.VirusType
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
--		,'' as VirusType
		, VirusType.VirusTypeTranslated as VirusType
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then 'Informational'
			when 1 then 'Warning'
			when 2 then 'Minor'
			when 3 then 'Major'
			when 4 then 'Critical'
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, ScanTime 
		,'' as ScanTime
		,'' as EventDesc
		
		, '' as RuleName

		-- Product update fields
		,'' as Type 
		,'' as Version
		,'' as Error
		,'' as SiteName
		,'' as InitiatorID
		,'' as InitiatorType

 
 	FROM 
   	(
	BranchNode Join LeafNode on (LeafNode.ParentID = BranchNode.AutoID) 
	Join ComputerProperties on (ComputerProperties.ParentID = LeafNode.AutoID)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
	) on (Events.NodeID = LeafNode.AutoID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR

  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		Events.VirusName > '' 
    		OR
		Events.VirusType > ''
  	)
--   	AND LeafNode.ParentID = BranchNode.AutoID 
--	AND Events.VirusName = VirusType.VirusName
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' ) 
		or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	)
        AND Events.ProductName != 'ePO Agent' 
        AND Events.ProductName != 'ePO Agent' 
--  	AND Events.NodeID = LeafNode.AutoID			/* regular join tiring events to nodes */
--   	AND Events.ActionTaken *= ReportActionDesc.ActionIntID
--   	AND ReportActionDesc.LanguageSuffix = @szLang
/*   	AND LeafNode.Type =1 */

	-- fast group summary group by clause
	Group By
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		DateName(Year, EventDateTime)
--		,Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month'
--		,Datename(Week, EventDateTime)
--		,Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform


--END	-- FilterID

Set @ret = @@rowcount

END	-- BatchModeUpdateTableOnly


/* cleanup */
	DROP TABLE dbo.tmpVirusname
	DROP TABLE dbo.tmpVirusFiletypeCrossProduct
	DROP TABLE dbo.tmpVirusSubtypeCrossProduct
	DROP TABLE dbo.tmpVirusFiletypePriority
	DROP TABLE dbo.tmpVirusSubtypePriority
	DROP TABLE dbo.tmpVirusFiletype
	DROP TABLE dbo.tmpVirusSubtype


RETURN @ret
END
GO


-- If VS8 installed: events.source exists, then rename VS8 version else rename non-VS8 version
if exists
	(select * 
		from syscolumns as c, sysobjects as o
		where 
		c.name = 'source'
		and o.name = 'events'
		and c.id = o.id
	)
begin
	if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVirusType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
		drop procedure [dbo].[AVISP_FilterVirusType]
	exec sp_rename 'AVISP_FilterVirusTypeVS8', 'AVISP_FilterVirusType', 'OBJECT'
end
GO


-----------------------------------------------------------------
-- Fixes for VS8 version of AVISP_FilterVAlertGroupsSubreport
-- Existing epo routine, dont replace if epoversion >= 3.5.0
-- Fixes filename special char bug and numeric severity issue

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreportVS8]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	and exists (select epoversion from serverinfo where epoversion < '3.5.0')
drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreportVS8]
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsSubreportVS8
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
, @szNameSpaceName  VARCHAR(100)
 ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
,@szGroup1 varchar(100) = ''
,@szGroupValue1 varchar(100) = ''
,@szGroup2 varchar(100) = ''
,@szGroupValue2 varchar(100) = ''
,@szGroup3 varchar(100) = ''
,@szGroupValue3 varchar(100) = ''
,@szGroup4 varchar(100) = ''
,@szGroupValue4 varchar(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @EventType varchar(50) = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 -- error checking codes: test script checks for these codes
 Declare @ret int
 Declare @Datelegal int
 Declare @Grouplegal int
 Declare @Inputlegal int
 Set @Datelegal = 1
 Set @Grouplegal = 1
 Set @Inputlegal = 1

 if lower(@EventType) != 'all'
	and lower(@EventType) != 'notinfection'
	and lower(@EventType) != 'infection'
	and lower(@EventType) != 'Infection-Res'
	and lower(@EventType) != 'Infection-Unr'
	and lower(@EventType) != 'Infection-Cle'
	and lower(@EventType) != 'Infection-Del'
	and lower(@EventType) != 'Infection-Mov'
		 Set @Inputlegal = 0

 -- translate webshield groupnames into actual event fieldname
 Declare @Webshield int
 Set @Webshield = 0
 if lower(@EventType) = 'contentfilter'
	or lower(@EventType) = 'contentscanning'
	or lower(@EventType) = 'spam'
	or lower(@EventType) = 'urlblocked'
	or lower(@EventType) = 'virus'
 Begin
	Set @Webshield = 1
	if @szGroup1 = 'RuleName'
		Set @szGroup1 = 'VirusName'
	if @szGroup2 = 'RuleName'
		Set @szGroup2 = 'VirusName'
	if @szGroup3 = 'RuleName'
		Set @szGroup3 = 'VirusName'
	if @szGroup4 = 'RuleName'
		Set @szGroup4 = 'VirusName'
	if @szGroup1 = 'Server'
		Set @szGroup1 = 'HostName'
	if @szGroup2 = 'Server'
		Set @szGroup2 = 'HostName'
	if @szGroup3 = 'Server'
		Set @szGroup3 = 'HostName'
	if @szGroup4 = 'Server'
		Set @szGroup4 = 'HostName'
	if @szGroup1 = 'Spammer'
		Set @szGroup1 = 'UserName'
 End


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node (done in main routine)
 --select distinct AgentGUID
 --into #LostLinksEvents
 --from Events
 --	where AgentGUID not in (select AgentGUID from leafnode)
  

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-- Fetch Infect After date variables
	Declare @YYYYMMDD datetime
	execute @Datelegal = dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- strip top10 suffix if present
	if substring(@EventType, 1, 5) = 'T10Vr' 
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	else if substring(@EventType, 1, 5) = 'T10Fl' 
		Set @EventType = Replace( @EventType, 'T10Fl', '')
	else if substring(@EventType, 1, 5) = 'T10Ur' 
		Set @EventType = Replace( @EventType, 'T10Ur', '')
	else if substring(@EventType, 1, 5) = 'T10Cp' 
		Set @EventType = Replace( @EventType, 'T10Cp', '')

   /* Fetch Report groups: 0-4 groups can be entered */

   Declare @szGroupYear varchar(100)	 Declare @szGroupMonth varchar(100) 
   Declare @szGroupQuarter varchar(100)    Declare @szGroupWeek varchar(100) 
   Declare @szGroupVirusName varchar(100)    Declare @szGroupActionTaken varchar(100) 
   Declare @szGroupNodeName varchar(100)    Declare @szGroupProductName varchar(100) 
   Declare @szGroupProductVersion varchar(100)    Declare @szGroupEngineVersion varchar(100) 
   Declare @szGroupDATVersion varchar(100)    Declare @szGroupFileName varchar(100) 
   Declare @szGroupHostName varchar(100)    Declare @szGroupUserName varchar(100) 
	Declare @szGroupExtraDATNames     VARCHAR(100)  -- coverage data 
	Declare @szGroupDomainName     VARCHAR(100)  		Declare @szGroupOSVersion     VARCHAR(100) 
	Declare @szGroupServicepack     VARCHAR(100)  	Declare @szGroupHotfix     VARCHAR(100)  
	Declare @szGroupLicenseStatus     VARCHAR(100)  	Declare @szGroupExpirationDate     VARCHAR(100)  
	Declare @szGroupAgentVersion     VARCHAR(100)  	-- update event data
	Declare @szGroupType     VARCHAR(100)  	Declare @szGroupVersion     VARCHAR(100)  
	Declare @szGroupError     VARCHAR(100)  	Declare @szGroupLanguage     VARCHAR(100) 
	Declare @szGroupSiteName     VARCHAR(100)  	Declare @szGroupInitiatorID     VARCHAR(100)  
	Declare @szGroupInitiatorType     VARCHAR(100)  	Declare @szGroupDay     VARCHAR(100)  
	Declare @szGroupHour     VARCHAR(100)  	Declare @szAgentVersion     VARCHAR(50)  
	Declare @szLicensed     VARCHAR(50)  	Declare @szConnectStatus     VARCHAR(50) 
	Declare @szAgentType	varchar(50) 	Declare @szOSType varchar(50) 
	Declare @szOSPlatform varchar(50)	Declare @szVirusType varchar(50) 
	Declare @szFullProductName varchar(50) 	Declare @szEngineDat varchar(50) 
	Declare @szDatExtraDat varchar(50)     	Declare @szTVDSeverity varchar(50) 
    	Declare @szTVDTaskName varchar(50) 	Declare @szEventDesc varchar(255) 
	Declare	@szVirusSubType varchar(50)	Declare	@szSource varchar(255)

   Set @szGroupYear  = ''    Set @szGroupMonth  = ''  Set @szGroupQuarter  = ''  Set @szGroupWeek  = '' Set @szGroupVirusName  = ''
   Set @szGroupActionTaken  = ''  Set @szGroupNodeName  = ''  Set @szGroupProductName  = ''  Set @szGroupProductVersion  = ''  Set @szGroupEngineVersion  = ''
   Set @szGroupDATVersion  = ''  Set @szGroupFileName  = ''  Set @szGroupHostName  = ''  Set @szGroupUserName  = ''  Set @szGroupExtraDATNames  = ''  Set @szGroupDomainName  = ''
	Set @szGroupOSVersion  = ''  Set @szGroupServicepack  = ''  Set @szGroupHotfix   = ''  Set @szGroupLicenseStatus   = ''  Set @szGroupExpirationDate   = ''
	Set @szGroupAgentVersion   = ''  Set @szGroupType    = ''  Set @szGroupVersion    = ''  Set @szGroupError    = ''  Set @szGroupLanguage   = ''
	Set @szGroupSiteName   = ''  Set @szGroupInitiatorID   = ''  Set @szGroupInitiatorType    = ''  Set @szGroupDay    = ''  Set @szGroupHour    = ''  Set @szAgentVersion = ''  
	Set @szLicensed = ''   Set @szConnectStatus = ''    Set @szAgentType = ''
	Set @szOSType  = ''  Set @szOSPlatform = ''  Set @szVirusType  = ''  Set @szFullProductName = ''  Set @szEngineDat  = ''  
	Set @szDatExtraDat  = ''  Set @szTVDSeverity  = ''  Set @szTVDTaskName  = ''  Set @szEventDesc  = ''  
	Set @szVirusSubType = ''  Set @szSource = ''

   if @szGroup1 > '' OR @szGroup2 > '' OR  @szGroup3 > '' OR  @szGroup4 > ''
   	Execute @Grouplegal = AVISP_GetReportGroups    @szOptionalReportParms, 
				@szGroup1, @szGroup2, @szGroup3, @szGroup4 
				,@szGroupValue1, @szGroupValue2, @szGroupValue3, @szGroupValue4 
				,@szGroupYear  OUTPUT		,@szGroupMonth  OUTPUT
				,@szGroupQuarter  OUTPUT 	,@szGroupWeek  OUTPUT  
				,@szGroupVirusName  OUTPUT	,@szGroupActionTaken  OUTPUT
				,@szGroupNodeName  OUTPUT	,@szGroupProductName  OUTPUT
				,@szGroupProductVersion  OUTPUT	,@szGroupEngineVersion  OUTPUT
				,@szGroupDATVersion  OUTPUT	,@szGroupFileName  OUTPUT
				,@szGroupHostName  OUTPUT	,@szGroupUserName  OUTPUT
				,@szGroupExtraDATNames OUTPUT	,@szGroupDomainName OUTPUT		
				,@szGroupOSVersion OUTPUT	,@szGroupServicepack OUTPUT
				,@szGroupHotfix OUTPUT		,@szGroupLicenseStatus OUTPUT
				,@szGroupExpirationDate OUTPUT	,@szGroupAgentVersion       OUTPUT		
				,@szGroupType       OUTPUT	,@szGroupVersion OUTPUT
				,@szGroupError       OUTPUT	,@szGroupLanguage OUTPUT
				,@szGroupSiteName       OUTPUT	,@szGroupInitiatorID OUTPUT
				,@szGroupInitiatorType OUTPUT	,@szGroupDay       OUTPUT
				,@szGroupHour       OUTPUT	,@szAgentVersion output
				,@szLicensed output		,@szConnectStatus output 
				,@szAgentType	output		,@szOSType output
				,@szOSPlatform output		,@szVirusType output
				,@szFullProductName output	,@szEngineDat output
				,@szDatExtraDat output		,@szTVDSeverity OUTPUT
    				,@szTVDTaskName OUTPUT		,@szEventDesc OUTPUT
				,@szVirusSubType OUTPUT		,@szSource OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
	End
	



---------------------------------------------------------------
-- Do not use outer joins here
-- if the group is on a field partiipating in an outer join not only will the fields matching value be returned but all outerjoin rows (null values) as well
-- too much data gets sent.

-- avoid outer join on eventdesc table: if no match then row wont be returned - too little data returned
-- keep outer join in actiodesc & virustype ion events are caught
-- note: missing entries in EventFilterDescFast will result in rows not being returned



--select @szGroupActionTaken


-- warning:  dont do outer join on a group field: it breaks in these subreports returning to many rows
 
 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
		,DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */

    		,CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(Events.UserName AS varchar(32)) AS UserName
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  cast(BranchNode.Nodename as varchar(255))
			ELSE @Unlinked
			END 


    		,VirusName =
	  		CASE 
	   		WHEN (Events.VirusName > '') THEN Events.VirusName
--	   		WHEN (@EventType='BufrOvfl' and Events.DetectionName > '') THEN Events.DetectionName
	   		ELSE '---' 
	   		END
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype

    		, cast( TVDEventID as varchar(10)) as TVDEventID
--    		, case
--			when ( @eventType='BufrOvfl' and events.processname > '' ) then events.processname
--			when ( @eventType!='BufrOvfl') then CAST(FileName As varchar(255)) 
--			else '---'
--			end as FileName 
		, Filename
    		, ScanTime 
   		, ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			-- fix 149968: For VS8 version, make sure text always displays
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity


    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
    		,CAST(ProductID as int) As ProductID
--  		cast(BranchNode.Nodename as varchar(255))    AS NodeName 
--  		cast(ReportFullPathNode.FullPathName as varchar(255))    AS NodeName 

--		, cast(EventFilterDescFast.Name as varchar(128)) as EventDesc
		-- bufrovfl not used in fast layout type
		, case 
			when (@eventType='All' and EventFilterDescFast.Name > '') then cast(EventFilterDescFast.Name as varchar(128)) 
			when (@eventType='All' and TVDEventID > 0) then cast(TVDEventID as varchar(128)) 
--			when (@eventType='BufrOvfl' and Events.ModuleName > '' and Events.apiName > '' ) 
--					then cast((Events.ModuleName + ' | ' + Events.apiName) as varchar(128)) 
--			when (@eventType='BufrOvfl' and Events.ModuleName > '' and (Events.apiName = '' or Events.apiName is NULL) ) 
--					then cast((Events.ModuleName ) as varchar(128)) 
--			when (@eventType='BufrOvfl' and (Events.ModuleName = '' or Events.ModuleName is NULL) and Events.apiName > '' ) 
--					then cast((Events.apiName) as varchar(128)) 
			when (Events.Source > '')  then cast(Events.Source as varchar(128)) 
--			when TVDEventID > 0 then cast(TVDEventID as varchar(128)) 
			else '---' 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc

		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end as OSPlatform
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(
		-- epo3.5 bugfix: always do this join when group by severity
		(@EventType in ('All', 'NotInfection') or @szTVDSeverity > '')
		and events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND ( TVDEventID not in (1202, 1203, 4650, 4651 ) )
--   	AND LeafNode.Type !=  24      -- show all events including uninstalled
	and ( @YYYYMMDD is null or Events.EventDateTime >=  @YYYYMMDD)
	and
	(
		(@EventType = 'All' )  
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'BufrOvfl' and Events.DetectionName > '' AND Events.ProductName != 'ePO Agent' ) 
		or ( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionUr' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'InfectionCp' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent' AND TVDEventID not in (1506, 4600 )) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 AND TVDEventID not in (1506, 4600 ))
		or ( @EventType = 'ContentFilter' AND TVDEventID=1506 )
		or ( @EventType = 'ContentScanning' AND TVDEventID=1506 and events.VirusType = 'content-scanning' )
		or ( @EventType = 'Spam' AND TVDEventID=1506 and events.VirusType in ('spam', 'deny-spam') )
		or ( @EventType = 'URLBlocked' AND TVDEventID=4600  )
		or ( (@EventType = 'WSVirus' or @EventType = 'WSVirusHour') AND TVDEventID=1503  )
	)

             AND 
	(	 @szGroupYear = ''
		OR DateName(Year, EventDateTime) = @szGroupYear
	) 
             AND 
	(	 @szGroupMonth = ''
		OR 
		( Substring(convert(char,EventDateTime,120),1,7) = @szGroupMonth
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), Cast(DatePart(Month, EventDateTime) as char(5)) ) = @szGroupMonth
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
--
		)
	) 
             AND 
	(	 @szGroupQuarter = ''
		OR 
		( convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Quarter, EventDateTime)) = @szGroupQuarter
--			AND
--		  Datediff(year, EventDateTime, Getdate() ) = 0
		)
	) 
             AND 
	(	 @szGroupWeek = ''
		OR 
		( DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) = @szGroupWeek
--convert(varchar(20), DateName(Year, EventDateTime)) + '-' + convert(varchar(20), DatePart(Week, EventDateTime)) = @szGroupWeek
--			AND
--		  DatePart(Year, EventDateTime) = DatePart(Year, GetDate() )
		)
	) 
             AND 		-- day of month
	(	 @szGroupDay = ''
		OR 
		convert(varchar(20), DateName(Day, EventDateTime)) = @szGroupDay
	) 
             AND 		-- hour of day
	(	 @szGroupHour = ''
		OR 
		convert(varchar(20), DateName(Hour, EventDateTime)) = @szGroupHour
	) 
             AND 
	(	 @szGroupVirusName = ''
		OR ( @EventType != 'BufrOvfl' and Events.VirusName = @szGroupVirusName )
		OR ( @EventType = 'BufrOvfl' and Events.ProcessName = @szGroupVirusName) 
	) 

             AND 
	(	 @szGroupActionTaken = ''
-- localized version OR (ReportActionDesc.ActionName = @szGroupActionTaken and ActionTaken in ('50','65') )
		OR (@szGroupActionTaken = ReportActionDesc.ActionName )
		OR (@szGroupActionTaken > '' and convert(varchar(25),ActionTaken) = @szGroupActionTaken )
	) 
             AND 
	(	 @szTVDSeverity = ''
-- localized version OR ( SeverityDesc.SeverityName = @szTVDSeverity and Events.TVDSeverity = 0 )  do join above to severitydesc or TranslateSeverity
		or ( @szTVDSeverity = EventFilterDescFast.Severity )
		OR ( @szTVDSeverity = @Informational and Events.TVDSeverity = 0 )
		OR ( @szTVDSeverity = @Warning and Events.TVDSeverity = 1 )
		OR ( @szTVDSeverity = @Minor and Events.TVDSeverity = 2 )
		OR ( @szTVDSeverity = @Major and Events.TVDSeverity = 3 )
		OR ( @szTVDSeverity = @Critical and Events.TVDSeverity = 4 )
		OR ( @szTVDSeverity = '---' and (Events.TVDSeverity > 4  or Events.TVDSeverity < 0) )
	) 
             AND 
	(	 @szGroupNodeName = ''
		OR BranchNode.NodeName = @szGroupNodeName
		or ( @szGroupNodeName = @Unlinked and (BranchNode.NodeName is NULL) )
		or ( @szGroupNodeName = '---' and (BranchNode.NodeName is NULL) )
	) 
             AND 
	(	 @szGroupProductName = ''
		OR ProductName = @szGroupProductName
	) 
             AND 
	(	 @szGroupProductVersion = ''
		OR ProductVersion = @szGroupProductVersion
		or ( @szGroupProductVersion = '---' and (ProductVersion is NULL or ProductVersion = '') )
	) 
             AND 
	(	 @szGroupEngineVersion = ''
		OR EngineVersion = @szGroupEngineVersion
	) 
             AND 
	(	 @szGroupDATVersion = ''
		OR DATVersion = @szGroupDATVersion
	) 
             AND 	-- make this a like operator since the filename is cropped
	(	 @szGroupFileName = ''
		OR 
		( 
			@EventType = 'BufrOvfl' 
			and 
			(
				@szGroupFileName = ModuleName+' | '+APIName   -- vs7.5
				or @szGroupFileName = ModuleName  	-- vs7.5
				or @szGroupFileName = APIName   	-- vs7.5				
			)
		)
		-- epo3.x patch6 Sometimes filename can have _[] chars in it which will break the like operator
		OR right(Events.FileName,15) = @szGroupFileName 
		OR Events.FileName = @szGroupFileName
		OR FileName like ('%' + @szGroupFileName)
	) 
             AND 
	(	 @szGroupHostName = ''
		OR Events.HostName = @szGroupHostName
	) 
             AND 
	(	 @szGroupUserName = ''
		OR Events.UserName = @szGroupUserName
	) 
             AND 
	(	 @szGroupDomainName = ''
		OR DomainName = @szGroupDomainName
		or ( @szGroupDomainName = @Unlinked and (DomainName = '' or Domainname is null) )
		or ( @szGroupDomainName = '---' and (DomainName = '' or Domainname is null) )
	) 
             AND 
	(	 @szOSType = ''
		OR OSType = @szOSType 
		or ( @szOSType = @Unlinked and (OSType = '' or OSType is null) )
		or ( @szOSType = '---' and (OSType = '' or OSType is null) )
	) 
             AND 
	(	 @szOSPlatform = ''
		OR OSPlatform = @szOSPlatform 
		or ( @szOSPlatform = @Unlinked and (OSPlatform = '' or OSPlatform is NULL) )
		or ( @szOSPlatform = '---' and (OSPlatform = '' or OSPlatform is NULL) )
	) 
             AND 
	(	 @szVirusType = ''
		OR VirusType.VirusTypeTranslated = @szVirusType 
		or Events.VirusType = @szVirusType 
		OR ( @EventType = 'BufrOvfl' and @szVirusSubtype = DetectionName )  -- vs7.5
		or (@szVirusType = '---' and (Events.VirusType = '' or Events.VirusType is NULL))
	) 
             AND 
	(	 @szVirusSubtype = ''
		OR VirusType.VirusFileType = @szVirusSubtype 
		or (@szVirusSubtype = '---' and (VirusType.VirusFileType = '' or VirusType.VirusFileType is NULL))
	) 
             AND 
	(	 @szFullProductName = ''
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		OR (Events.ProductName + ' ' + Events.ProductVersion) = @szFullProductName 
		or (@szFullProductName = '---' and ((ProductName + ' ' + ProductVersion) = ' ' or (ProductName + ' ' + ProductVersion) is NULL))
	) 
             AND 
	(	 @szEngineDat = ''
		OR (EngineVersion + ' ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion + ' \ ' + DATVersion)  = @szEngineDat 
		OR (EngineVersion)  = @szEngineDat 
		OR (DATVersion)  = @szEngineDat 
		or (@szEngineDat = '---' and ((EngineVersion + ' ' + DATVersion) = ' ' or (EngineVersion + ' ' + DATVersion) is NULL))
	) 
             AND 
	(	 @szTVDTaskName = ''
		OR TVDTaskName = @szTVDTaskName 
	) 
             AND 
	(	 
		@szEventDesc = ''
--		or
--		(	-- vs7.5 changes
--			@EventType = 'BufrOvfl'
--			and
--			(
--				(@szEventDesc = ModuleName ) --and (APIName = '' or APIName is null))
--				or (@szEventDesc = APIName ) --and (ModuleName = '' or ModuleName is null))	
--				or @szEventDesc = (ModuleName + ' | ' + APIName)
--
--			)
--		)
		or
		(
			@EventType = 'ALL'
			and
			(
				EventFilterDescFast.Name = @szEventDesc
				or cast(Events.TVDEventID as varchar(128)) = @szEventDesc
				or (@szEventDesc = '---' and (Events.TVDEventID = '' or Events.TVDEventID is NULL))
			)
		)
		or
		(
			Events.source = @szEventDesc
			or (@szEventDesc = '---' and (Events.source = '' or Events.source is NULL))
		)
	) 
	-- vs7.5 (source no longer a separate sp field (uses event desc)
--             AND 
--	(	 @szSource = ''
--		OR Events.Source = @szSource 
--	) 

	set @ret = @@rowcount

--	Drop Table #LostLinksEvents

-- check for illegal values
if @Datelegal <= 0 
	set @ret = -1
if @Grouplegal <= 0 
	set @ret = -2
if @Inputlegal <=0
	set @ret = -3

RETURN @ret
END
GO


-- If VS8 installed: events.source exists, then rename VS8 version else rename non-VS8 version
if exists
	(select * 
		from syscolumns as c, sysobjects as o
		where 
		c.name = 'source'
		and o.name = 'events'
		and c.id = o.id
	)
begin
	if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
		drop procedure [dbo].[AVISP_FilterVAlertGroupsSubreport]
	exec sp_rename 'AVISP_FilterVAlertGroupsSubreportVS8', 'AVISP_FilterVAlertGroupsSubreport', 'OBJECT'
end
GO



-------------------------------------------------------------
-------------------------------------------------------------
-- Infection custom group report
-- Fixes Product severity issue where severity is numeric 149968

-- Existing epo routine: dont replace if epoversion >= 3.5.0
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroupsVS8]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	and exists (select epoversion from serverinfo where epoversion < '3.5.0')
drop procedure [dbo].[AVISP_FilterVAlertGroupsVS8]
GO

CREATE PROCEDURE dbo.AVISP_FilterVAlertGroupsVS8
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @InfectAfterYYYYMMDD varchar(30) = ''
 , @InfectAfterRule varchar(30) = ''
 , @szDrilldown1 	varchar(20)=''	-- layout, Drilldown, fast, printable
 , @EventType		varchar(50)='Infection'		-- All, Infection, Operational (Non-Infection), Infection-Cle, Moved, Deleted, Unresolved
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)

 Declare @ret int

 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


--------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpTop10s' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10s

	IF EXISTS (select * from sysobjects where name = 'tmpTop10Virus' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpTop10Virus


	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')

	if @InfectAfterRule = 'all' and ( @InfectAfterYYYYMMDD = '' or @InfectAfterYYYYMMDD is null )
	begin
		set @YYYYMMDDdate = null
		set @YYYYMMDD = ''
	end

--select @YYYYMMDDdate
	-- Fetch Infect After date variables
--	Declare @YYYYMMDD datetime
--	execute dbo.AVISP_GetDateConversion @InfectAfterYYYYMMDD, @InfectAfterRule, @YYYYMMDD output


	-- Check if VirusType table needs translating and redo it if language differs
	EXECUTE AVISP_TranslateVirusType @szFullLang


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)		
   	Declare @Uncategorized varchar(50)		
	Declare @Critical varchar(50)
	Declare @Major varchar(50)			Declare @Minor varchar(50)
	Declare @Informational varchar(50)		Declare @Warning varchar(50)
	Declare @Blocked varchar(50)


	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
		Set @Critical = 'Critical'	Set @Major = 'Major'	Set @Minor = 'Minor'
		Set @Warning = 'Warning'	Set @Informational = 'Informational'
		Set @Blocked = 'Blocked'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Uncategorized = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'VirusType' and TextID = 'Uncategorized'
		Select 	@Critical = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Critical'
		Select 	@Major = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Major'
		Select 	@Minor = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Minor'
		Select 	@Warning = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Warning'
		Select 	@Informational = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Severity' and TextID = 'Informational'
		-- vs7.5
		Select 	@Blocked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Blocked'
	End
	

	


--------------------------------------------------------
--------------------------------------------------------
  -- lookup top 10 items if applicable
  -- look for top 10 (T10) suffix in eventtype
  -- Only do this if no data filter has been set

	Declare @Top10 varchar(20)
	Set @Top10 = ''
	Create table dbo.tmpTop10s 
	(
		Value varchar(255)
	)
	Create table dbo.tmpTop10Virus 
	(
		VirusName varchar(255)
	)
--		,Virustype varchar(255)
--		,Virussubtype varchar(255)
--	)

	if substring(@EventType, 1, 5) = 'T10Vr'  
	begin
		Set @Top10 = 'T10Vr'
		Set @EventType = Replace( @EventType, 'T10Vr', '')
	
		if @DataFilter = 'none'		-- Do only if no data filter
		begin
	
		Update VirusType Set Top10 = 0
		
		if @EventType = 'Infection'
		begin
		Insert dbo.tmpTop10Virus (VirusName)
		Select Top 10 VirusName as VirusName --, 'Virus' as Virustype max(Virustype) as Virustype
		  From
			Events 
--			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
--			LeafNode Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--				and ReportActionDesc.LanguageID = @szFullLang)
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
--					@EventType = 'All'  or
--					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  )  
--					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
--					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
--					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
--					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
--					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
--					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
--					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
--					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
				) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
				AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				
		Group by VirusName
		order by count(*) desc
		end
		else
		begin
		Insert dbo.tmpTop10Virus (VirusName)
		Select Top 10 VirusName  as VirusName --, 'Virus' as Virustype --max(Virustype) as Virustype
		  From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
--			LeafNode Right Outer Join Events on(LeafNode.autoID = Events.NodeID)	
--			Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--				and ReportActionDesc.LanguageID = @szFullLang)
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
 					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
 					or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
				) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
				AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by VirusName
		order by count(*) desc		
		end		

		-- insert any missing virus
--		insert virustype
--		( VirusName, VirusFileType, VirusPlatformType, VirusType, VirusTypeTranslated, LanguageID, Top10 )
--		Select
--			dbo.tmpTop10Virus.VirusName, '', '', dbo.tmpTop10Virus.VirusType, dbo.tmpTop10Virus.VirusType, '0409', 1
--		From 
--			dbo.tmpTop10Virus
--		Where
--			 dbo.tmpTop10Virus.VirusName not in (select virusname from virustype )

		-- Mark Virus type, virussubtype
--		Update tmpTop10Virus
--		Set virustype = VirusType.VirusTypeTranslated
--			, virussubtype = VirusType.VirusFileType 
--		from virustype
--		Where virustype.virusname = tmpTop10Virus.VirusName 

		-- mark the top 10 viruses
--		Update VirusType
--		Set Top10 = 1
--		Where VirusName in ( select virusname from dbo.tmpTop10Virus )
	
		end
	end
	else if substring(@EventType, 1, 5) = 'T10Fl'  
	begin
		Set @Top10 = 'T10Fl'
		Set @EventType = Replace( @EventType, 'T10Fl', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 right(FileName, 15)
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
 					or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by right(FileName,15)
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Ur'  
	begin
		Set @Top10 = 'T10Ur'
		Set @EventType = Replace( @EventType, 'T10Ur', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 UserName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
 					or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by UserName
		order by count(*) desc		

		end
	end
	else if substring(@EventType, 1, 5) = 'T10Cp'  
	begin
		Set @Top10 = 'T10Cp'
		Set @EventType = Replace( @EventType, 'T10Cp', '')

		if @DataFilter = 'none'		-- Do only if no data filter
		begin

		Truncate Table ReportTop10Items

		Insert ReportTop10Items (ItemName)
		Select Top 10 HostName
		From
			Events Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
				and ReportActionDesc.LanguageID = @szFullLang			)
--			left outer join LeafNode on(LeafNode.autoID = Events.NodeID)	
	  	WHERE 
	  	(	-- check for directory filter
	   		@FilterID = 0 OR
 	   		Events.NodeID in
			( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
				(
				select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
  		      		from BranchNodeEnum 
    		    		where BranchNodeEnum.StartAutoID = @FilterID
				Union
				select @FilterID
				)
			)
  		)
			  	AND    	
				(
					@EventType = 'All'  or
					( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
					( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
					( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
					( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or	
					( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
					or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
					or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
					or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
					or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
 					or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
					or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
					) 
			   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651 )
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

				and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
				

		Group by HostName
		order by count(*) desc		

		end
	end

-- test
--select * from ReportTop10Items

--------------------------------------------------------------------------------------------------
-- Read Data Filter and Group Selections to see which query option to pick for fastest performance
--	must group on fields that are part of the Group selections or Data filter 

	-- merge group fields into one to simplify processing
	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	-- Check for key fields that affect which query to run
	Declare @Nodename int
	Set @Nodename = CHARINDEX( 'NodeName', @GroupFields)	
	if @Nodename = 0 	Set @Nodename = CHARINDEX( 'NodeName', @DataFilter)	

	Declare @Domainname int
	Set @Domainname = CHARINDEX( 'Domainname', @GroupFields)	
	if @Domainname = 0 	Set @Domainname = CHARINDEX( 'Domainname', @DataFilter)	

	Declare @OSType int
	Set @OSType = CHARINDEX( 'OSType', @GroupFields)	
	if @OSType = 0 	Set @OSType = CHARINDEX( 'OSType', @DataFilter)	

	Declare @OSPlatform int
	Set @OSPlatform = CHARINDEX( 'OSPlatform', @GroupFields)	
	if @OSPlatform = 0 	Set @OSPlatform = CHARINDEX( 'OSPlatform', @DataFilter)	

	Declare @Virustype int
	Set @Virustype = CHARINDEX( 'Virustype', @GroupFields)	
	if @Virustype = 0 	Set @Virustype = CHARINDEX( 'Virustype', @DataFilter)	

	Declare @VirusSubtype int
	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @GroupFields)	
	if @VirusSubtype = 0 	Set @VirusSubtype = CHARINDEX( 'VirusSubtype', @DataFilter)	
        if @VirusSubtype > 0    Set @Virustype=1

	Declare @ActionTaken int
	Set @ActionTaken = CHARINDEX( 'Action', @GroupFields)	
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'ActionTaken', @DataFilter)	
	-- special case code: infection history reports do a chart on action, so make sure a query returning action
	--	is performed
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSVIRUSDETAIL', @szOptionalReportParms)
	if @ActionTaken = 0 	Set @ActionTaken = CHARINDEX( 'WSINFECTHIST', @szOptionalReportParms)


	Declare @TVDEventID int
	Set @TVDEventID = CHARINDEX( 'TVDEventID', @GroupFields)	
	if @TVDEventID = 0 	Set @TVDEventID = CHARINDEX( 'TVDEventID', @DataFilter)	

	Declare @TVDSeverity int
	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @GroupFields)	
	if @TVDSeverity = 0 	Set @TVDSeverity = CHARINDEX( 'TVDSeverity', @DataFilter)	

	Declare @EventDesc int
	Declare @Source int	-- vs7.5
	Set @EventDesc = 0
	Set @Source = 0

	if @EventType = 'All' or @EventType = 'NotInfection'
	Begin
		Set @EventDesc = CHARINDEX( 'EventDesc', @GroupFields)	
		if @EventDesc = 0 	Set @EventDesc = CHARINDEX( 'EventDesc', @DataFilter)	
	End
	Else
	Begin
		Set @Source = CHARINDEX( 'EventDesc', @GroupFields)	
		if @Source = 0 	Set @Source = CHARINDEX( 'EventDesc', @DataFilter)	
	End

--	Set @Source = CHARINDEX( 'Source', @GroupFields)	
--	if @Source = 0 	Set @Source = CHARINDEX( 'Source', @Source)	

	Declare @Year int
	Set @Year = CHARINDEX( 'Year', @GroupFields)	
	if @Year = 0 	Set @Year = CHARINDEX( 'Year', @DataFilter)	

	Declare @Quarter int
	Set @Quarter = CHARINDEX( 'Quarter', @GroupFields)	
	if @Quarter = 0 	Set @Quarter = CHARINDEX( 'Quarter', @DataFilter)	

	Declare @Week int
	Set @Week = CHARINDEX( 'Week', @GroupFields)	
	if @Week = 0 	Set @Week = CHARINDEX( 'Week', @DataFilter)	

	Declare @Month int
	Set @Month = CHARINDEX( 'Month', @GroupFields)	
	if @Month = 0 	Set @Month = CHARINDEX( 'Month', @DataFilter)	

	Declare @DATVer int
	Set @DATVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @DATVer = 0 	Set @DATVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @ENGVer int
	Set @ENGVer = CHARINDEX( 'EngineDAT', @GroupFields)	
	if @ENGVer = 0 	Set @ENGVer = CHARINDEX( 'EngineDAT', @DataFilter)	

	Declare @TaskName int
	Set @TaskName = CHARINDEX( 'TVDTaskName', @GroupFields)	
	if @TaskName = 0 	Set @TaskName = CHARINDEX( 'TVDTaskName', @DataFilter)	


	-- sum these fields into categories
	Declare @Time int
	Set @Time = @Year + @Month + @Quarter + @Week

	Declare @EventInfo int
	Set @EventInfo = @EventDesc + @TVDEventID + @TVDSeverity

	Declare @VirustypeAction int
	Set @VirustypeAction = @Virustype + @ActionTaken + @VirusSubtype + @Source

	Declare @LeafInfo int
	Set @LeafInfo = @Nodename + @Domainname + @OSType + @OSPlatform + @TaskName + @DATVer + @ENGVer

-- test
--select @szDrilldown1 as Drilldown, @EventType as Eventtype
--	, @DataFilter as Datafilter, @GroupFields as Groupfields
--	, @Time as 'Timegroups', @EventInfo as Eventinfo, @VirustypeAction as VTaction, @Leafinfo as Leafinfo
--	, @Top10 as Top10



-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------
-- The actual query to run is selected based off the data filter, grouping fields, layout option and
--	Event type of this report. Trying to do the minimum work possible to improve performance.

   -------------------------------------------------------------------------------
   -- 1. Fast group summary fetch (subreport fetches detailed rows)
   -- No grouping on time fields (good performance boost). Base fields = VN, PN, PV
   -- No joins, no grouping on time fields 

   if lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs')
	and @DataFilter <> 'Inactive'
	and ( @Time = 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
   begin


 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' ExtraDATNames
		,'' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, '' as LastContact

		, '' as HostName
		, '' as UserName
--		,  Events.UserName
		, '' HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '1' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' 
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ReportComputerJoinData.Domainname
--		, ReportComputerJoinData.OSType
--	    	, ReportComputerJoinData.OSPlatform



   end


   -------------------------------------------------------------------------------
   -- 1.2 Fast group summary fetch (subreport fetches detailed rows) (source)
   -- No grouping on time fields (good performance boost). Base + source
   -- No joins 
  else
   if lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs')
	and @DataFilter <> 'Inactive'
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken = 0 and @Virustype = 0 and @source > 0
		 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query
   begin


 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' ExtraDATNames
		,'' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
--		, '' as LastContact

		, '' as HostName
		, '' as UserName
--		,  Events.UserName
		, '' HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 's' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	Events
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
	and source > ''
--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' 
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
		,ProductName
		,ProductVersion
		,Events.Source



   end


   -------------------------------------------------------------------------------
   -- 1.5 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on Base + action 
   -- Joins action tables

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken > 0 and @Virustype = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'a' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
--		and ReportActionDescFast.intLanguageID = @intLangID
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion




   end

   -------------------------------------------------------------------------------
   -- 1.6 Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on Base + source + action
   -- Joins action tables
   -- Doesnt join virustype or leafnode or EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'  -- will try with/without datafilter if DF fields known
	and ( @Time = 0 
		and @Virustype = 0 and @ActionTaken > 0 and @Virustype = 0 and @source > 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT  
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, @szFullLang as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'as' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
 	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
		and source > ''
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,Events.Source



   end

   -------------------------------------------------------------------------------
   -- 2. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on Base + time 
   -- No joins

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs')
	-- postepo3 - these must be executed when data filter not set
	and @DataFilter <> 'Inactive'
	and ( @Time > 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
--		'' as Year
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,'' as Week
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		,'' as Quarter
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' as EngineVersion
    		,'' As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
--		, cast( '2' as varchar(10)) as Language
		,'' as ExtraDATNames
		,'2' as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, cast('' as varchar(50)) as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 't' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16)) 
--	    		END
		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,Events.ActionTaken
--		,ReportComputerJoinData.NodeName
--		, TVDTaskName
--		,EngineVersion
		,ProductName
		,ProductVersion




   end

   -------------------------------------------------------------------------------
   -- 3. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on base + time + action
   -- Joins action tables

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 
		and @Virustype= 0 and @ActionTaken > 0 and @Virustype = 0 and @source = 0
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, cast( '' as varchar(32)) as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'at' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on 
	(Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang
	)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	  	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 	

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion


   end



   -------------------------------------------------------------------------------
   -- 3.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on base + action + virus type + time
   -- Joins virustype and action tables

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and @DataFilter <> 'Inactive'
	and ( @Time >= 0 and @Virustype > 0 and @ActionTaken >= 0 and @source = 0 
		and @Leafinfo = 0 and @EventInfo = 0 )
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
 --   		,CAST(DATVersion as varchar(16)) As DATVersion
    		,CAST('' as varchar(16)) AS EngineVersion
    		,CAST('' as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, CAST('' as varchar(50)) as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		, '' as NodeName
		, '' as Domainname
--		, '' as OSVersion
		, '' as OSType
		, '' as OSPlatform
/*
  		, NodeName = 
			CASE
			WHEN ReportComputerJoinData.NodeName > '' THEN  ReportComputerJoinData.NodeName
			ELSE '(Unlinked)'
			END 
		, case
			when ReportComputerJoinData.Domainname > '' then ReportComputerJoinData.Domainname
			when ReportComputerJoinData.Domainname = '' then '---'
			else '(Unlinked)'
			end as Domainname
		, cast( '' as varchar(10)) as OSVersion
		, case
			when ReportComputerJoinData.OSType > '' then ReportComputerJoinData.OSType
			when ReportComputerJoinData.OSType = '' then '---'
			else '(Unlinked)'
			end as OSType
		, case
			when ReportComputerJoinData.OSPlatform > '' then ReportComputerJoinData.OSPlatform
			when ReportComputerJoinData.OSPlatform = '' then '---'
			else '(Unlinked)'
			end as OSPlatform
*/
		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, ''  as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'avt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast( VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	Events
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)

 	 	AND  
		(
		@EventType = 'All' 
		or ( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
		) 
	   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

		and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--  	           AND Events.ProductName != 'ePO Agent' 

	Group By
		Events.VirusName
--		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType




   end

   -------------------------------------------------------------------------------
   -- 3.6. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + leaf + time
   -- Joins leafnode

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken = 0 and @source = 0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.6' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'tl' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
--  		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then @Informational
--			when 1 then @Warning
--			when 2 then @Minor
--			when 3 then @Major
--			when 4 then @Critical
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
--	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
--	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		
--		,ReportActionDesc.ActionName
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 




   end

   -------------------------------------------------------------------------------
   -- 3.7. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + virustype + action + leaf + time
   -- Joins action tables, leafnode

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Source=0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.9' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'astl' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName




   end

   -------------------------------------------------------------------------------
   -- 3.9. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + action + source + time + leaf
   -- Joins action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @Virustype = 0 and @ActionTaken >= 0 and @Source >= 0
			and @Leafinfo > 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '3.9' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'astl' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, Events.Source




   end



   -------------------------------------------------------------------------------
   -- 4. Fast group summary fetch (subreport fetches detailed rows), data filter ok here
   -- Groups on base + action _ virustype + source + time + leaf
   -- Joins virustype, action tables, leafnode
   -- Doesnt EventFilterDescFast

   else
    if  lower(@szDrilldown1) = 'fast' 
	and (  @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs'
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
	)
	and 
	(
		( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo >= 0 and @EventInfo = 0 )
-- postepo3 - if fast and data filter, then use this unless grouping by eventdesc
		or ( @DataFilter <> 'none' and @EventInfo = 0 ) -- if data filter do this
	)
	and @Top10 = ''		-- not a top 10 query

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
--		, '' as NodeName
--		, '' as Domainname
--		, '' as OSVersion
--		, '' as OSType
--		, '' as OSPlatform

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, 'avstl' as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
-- postepo3 - return eventid & severutt here so this can handle data filtering
  		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case TVDSeverity
			when 0 then @Informational
			when 1 then @Warning
			when 2 then @Minor
			when 3 then @Major
			when 4 then @Critical
			else '---'
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND  
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) 
		or ( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,DATVersion
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform		,ReportActionDesc.ActionName
    		, TVDEventID				-- newest groups fields
    		, TVDSeverity
		,Events.ActionTaken
		,ProductName
		,ProductVersion
		,EngineVersion
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, Events.Source




   end


   -------------------------------------------------------------------------------
   -- 4.5. Fast group summary fetch (subreport fetches detailed rows)
   -- Groups on time, eventinfo
   -- Joins all: eventfilterdesc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	( 
		(  @EventType = 'NotInfection' or @EventType = 'All' 
		or @EventType = 'Infection' or @EventType = 'WSVirus' or @EventType = 'Programs' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction = 0 and @Leafinfo = 0 and @EventInfo > 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '4.5' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
		,'' as NodeName
		,'' as Domainname
		,'' as OSType
		,'' as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'te' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
--   		,ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
--	    		END
		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 

	(
	Events 
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
--	Left Outer Join (
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,ReportActionDesc.ActionName
--		,BranchNode.NodeName
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity



   end

   -------------------------------------------------------------------------------
   -- 5. Fast group catchall (subreport fetches detailed rows)
   -- Groups on all
   -- Joins all: virustype, action, leafnode, eventfilter desc
   -- Eventtype = All, NotInfection	

   else
    if  lower(@szDrilldown1) = 'fast' 
	and
	(
		(  @EventType = 'NotInfection' or @EventType = 'All' or @EventType = 'Programs'
		or @EventType = 'Infection' or @EventType = 'WSVirus' 
		or @EventType = 'Infection-Res' or @EventType = 'Infection-Unr' 
		or @EventType = 'Infection-Cle' or @EventType = 'Infection-Del' or @EventType = 'Infection-Mov' 
		)
		and @Top10 = ''		-- not a top 10 query
	)
	and ( @Time >= 0 and @VirustypeAction >= 0 and @Leafinfo >= 0 and @EventInfo >= 0 )
	
	-- catch all: If fast and not top10 and get to here then do this 

   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '5f' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'all' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				-- epo3.5: if ebentid not found use event.serverity code and translate it
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end			
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,'' as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 

	(
	Events 
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	) 
	Left Outer Join (
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Left Outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) 
		or ( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' )
		or ( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.VirusName
		,Events.ActionTaken
    		, TVDEventID				-- newest groups fields
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,BranchNode.NodeName
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
		, EventFilterDescFast.Name 
		, EventFilterDescFast.Severity
		, Source



   end

   --------------------------------------------------
   -- LAYOUT=DRILLDOWNSECTION
   --------------------------------------------------

   -----------------------------------------------------------------------------------
   -- 5.9.9 slow 1 row per event fetch
   -- Buffer overflow fetch (all layout options)
   -- joins: leaf


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' 
	or lower(@szDrilldown1) = 'fast')
	and @EventType = 'BufrOvfl'
--	and 
--	(
--		( @Time = 0 and @VirusType = 0 and @EventInfo = 0 )
--	)
--	and @DataFilter <> 'Inactive'			do this regardless of other considerations
--	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
--		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
--		,  Events.ProcessName as FileName
		, case
			when ModuleName > '' and APIName > ''
				then ModuleName + ' | ' + APIName
			when ModuleName > ''
				then ModuleName 
 			else APIName
 			end as FileName

		, cast( 'bf' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.ProcessName > '' THEN Events.ProcessName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
	  	, CASE 
	   		WHEN Events.DetectionName > '' THEN Events.DetectionName
	   		ELSE '---' 
	   		END as VirusType
		, Events.ProcessName as VirusSubtype	-- vs7.5
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
--		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		, @Blocked as ActionTaken
--		, ActionTaken =
--	    		CASE 
--	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
--	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 --	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
--    		,  case 
--			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,TVDEventID as EventDesc
		, '' as EventDesc


 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
--	(
	Events 
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang)
--	) 
	on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		( @EventType = 'BufrOvfl' and Events.DetectionName > '' AND Events.ProductName != 'ePO Agent'  ) 

	) 
--   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
--		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end


   -------------------------------------------------------
   -- 6.0.1. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)
   -- joins: action, leaf, virus type


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		( @Time = 0 and @VirusType = 0 and @EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
--		DateName(Year, EventDateTime) as 'Year'
--		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
--		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter'
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRal' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then VirusType.VirusTypeTranslated
--			else case  when Events.VirusType > '' then Events.VirusType else '---' end
--			end as VirusType
		,VirusType as VirusType
		, '' as VirusSubtype
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
--		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
--    		,  case 
--			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,TVDEventID as EventDesc
--		, Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
		LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
		Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
		Events 
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
			and ReportActionDesc.LanguageID = @szFullLang)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' ) or
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   -------------------------------------------------------
   -- 6.0.2. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)
   -- joins: action, leaf


   else	if ( lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable' )
	and 
	(
		(@EventInfo = 0 )
	)
	and @DataFilter <> 'Inactive'
	and @Top10 = ''		-- not a top 10 query

   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRavl' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--		,'' as VirusType
--		, '' as VirusSubtype
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
--    		,  case 
--			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
--			else cast(Events.TVDSeverity as varchar(30))
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
--		,TVDEventID as EventDesc
--		, Events.Source as EventDesc
		, case
			when Events.Source > '' then Events.Source
			else '---'
			end as EventDesc
		
		-- new vs7.5 fields
--		, Events.Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
--	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
--		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' ) or
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end


   --------------------------------------------------
   -- 6. slow 1 row per event fetch
   -- returns all fields. Including: Filename, Computername, IPAddress, Username, EventDateTime (These are not returned
   --	by group summary queries because it would result in too many rows.
   -- does no grouping (grouping is used by fast report to limit the number of rows returned)


   else	if lower(@szDrilldown1) = 'drilldown' or lower(@szDrilldown1) = 'printable'
   --  fetch detailed computer rows: epo2.5 and below behavior (slow)
   begin

 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q

		-- Product Info Fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,'' as ExtraDATNames
		, @szFullLang as Language
--	        ,  case
--		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
--		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
--		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
--		else '---'
--		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
--		, '' as FullProductName
--		, '' as EngineDat
-- postepo3 33394 add Fullproductname, enginedat, virustype to drilldown select statement (fast already has it)
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- Agent info fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- Computer Info fields

  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else @Unlinked
			end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows
    		, (CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
--		, '' as HostIPAddress
		,  HostIPAddress
--		,  '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

--		, '' as FileName
		,  cast( FileName as varchar(255)) as FileName

		, cast( 'DRall' as varchar(32)) as  ProductCode
--		, '' as NodeID
		, NodeID
--		, NodeID as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields


		-- Virus info fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--		,'' as VirusType
--		, '' as VirusSubtype
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
		, VirusType.VirusFileType as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype	-- returned subtype only in drilldown mode
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END

--		,'' as ActionTaken
    		,cast( TVDEventID as varchar(10)) as TVDEventID
--		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
    		,  case 
			when EventFilterDescFast.Severity > '' then cast(EventFilterDescFast.Severity as varchar(30))
			else 
				case
				when Events.TVDSeverity = 0 then @Informational
				when Events.TVDSeverity = 1 then @Warning
				when Events.TVDSeverity = 2 then @Minor
				when Events.TVDSeverity = 3 then @Major
				when Events.TVDSeverity = 4 then @Critical
				else '---'
				end
			end  as TVDSeverity
--		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
		, case 
			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
			end as EventDesc
--		,TVDEventID as EventDesc
		
		-- new vs7.5 fields
--		, Source as Source
--		, '' as FileComponent

 
 	FROM 
	(
	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	)
	Right Outer Join 
	(
	Events 
	Left Outer Join EventFilterDescFast on(events.tvdeventid = EventFilterDescFast.eventid
		and EventFilterDescFast.language = @szFullLang)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'Programs' and Events.VirusName > ''  and Events.VirusType like 'App%' ) or
		( @EventType = 'InfectionFl' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or
-- postepo3 33760: make sure top10 machines allows layout to be set to drilldown or printable
		( @EventType = 'InfectionCP' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) or

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
			or ( @EventType = 'WSVirus' AND TVDEventID=1503  )
	) 
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--	AND Events.ProductName != 'ePO Agent' 


   end

   ------------------------------------------------------------------------
   ------------------------------------------------------------------------
   ------------------------------------------------------------------------
   -- top10section 
   ------------------------------------------------------------------------
   -- 7. Fast (group summary) Fetch, top 10 virus
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'T10Vvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
--	Join tmpTop10Virus on (Events.VirusName = tmpTop10Virus.VirusName )
	Join VirusType on (Events.VirusName = VirusType.VirusName )
	--			and Top10 =1 
	--		)  -- dont do top 10 join
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
		Events.VirusName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- postepo3
   -- 7.5 Fast (group summary) Fetch, top 10 virus with no data filter
   -- joins with a dynamically generated top 10 virus table
   -- does not join eventfilterdesc (no infection obly reports should)

   else if lower(@szDrilldown1) = 'fast' and @Top10 = 'T10Vr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '7.5tv' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
--			= CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, cast( 'T10Vva' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
	Join tmpTop10Virus on (Events.VirusName = tmpTop10Virus.VirusName )
--	Join VirusType on (Events.VirusName = VirusType.VirusName 
--				and Top10 =1 
--			)  -- do top 10 join
--	Join dbo.tmpTop10Virus on (Events.VirusName = dbo.tmpTop10Virus.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	AND Events.ProductName != 'ePO Agent'  
	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)



	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion
--		,EngineVersion
--		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
--   		, VirusType.VirusTypeTranslated
--		, Events.VirusType
--		, VirusType.VirusFileType
--		, TVDTaskName
--		, EventFilterDescFast.Name 
--		, ComputerProperties.Domainname
--		, ComputerProperties.OSType
--	    	, ComputerProperties.OSPlatform



   end

   ------------------------------------------------------------------------
   -- 8. Fast (group summary) Fetch, top 10 files, with data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   else if lower(@szDrilldown1) = 'fast' and @DataFilter <> 'none' and 
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( 'T10Fvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
--	dont do top 10 join cause a data filter exists and it must be run first
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.Filename
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end

   ------------------------------------------------------------------------
   -- 8.5 Fast (group summary) Fetch, top 10 files, with no data filter
   -- joins with a dynamically generated top 10 files table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- groups by filename

   else if lower(@szDrilldown1) = 'fast' and @DataFilter = 'none' and
	( @EventType = 'Infection-Unr'
		or @EventType = 'InfectionFl'
		or @EventType = 'Infection-Res'
		or @EventType = 'Infection-Cle'
		or @EventType = 'Infection-Del'
		or @EventType = 'Infection-Mov'
	)
   begin


 	SELECT   
		''  as 'Year'
		, ''  as 'Month'
		, ''  as 'Week'
		, ''  as 'Quarter' 
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '8.5tf' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

		,  cast( '' as varchar(50)) as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
--		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
		,  right(Events.FileName,15) as Filename

		, cast( 'T10Fa' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Fl' and right(Events.FileName,15) = ReportTop10Items.ItemName )
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Fl' and right(Events.FileName,15) in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionFl' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 

		( @EventType = 'Infection-Res' and Events.VirusName > ''  and ReportActionDesc.ResolutionID > 0 )
		or ( @EventType = 'Infection-Unr' and Events.VirusName > ''    and ReportActionDesc.ResolutionID < 0 )
		or ( @EventType = 'Infection-Cle' and Events.VirusName > ''   and ReportActionDesc.ResolutionID =1 )
		or ( @EventType = 'Infection-Del' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =2 )
		or ( @EventType = 'Infection-Mov' and Events.VirusName > ''  and ReportActionDesc.ResolutionID =3 )
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		,
		Events.Filename
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion


--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9. Fast (group summary) Fetch, top 10  Users, with data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first


   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Uvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	data filter exists, dont joinwith top 10 table because filter must be run first on client
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 9.5 Fast (group summary) Fetch, top 10  Users, with no data filter
   -- joins with a dynamically generated top 10 Users table
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionUr' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( '9.5tu' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		, '' as EngineDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( '' as varchar(50)) as HostName
--		, '' as UserName
		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Ua' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Ur' and Events.Username = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
--	Left Outer Join 
--	(
--	Leafnode 
--	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionUr' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.UserName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.HostName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion


--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10. Fast (group summary) Fetch, top 10 Computers, with data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)
   -- DataFilter exists so dont join with top 10 table, return all data cause data filter must be applied first

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter <> 'none'
   begin


 	SELECT   
		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
--		, ''  as 'Day'
--		, '' as 'Hour'

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
--		,'' as ServicePack
--		,'' as Hotfix
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
    		,CAST(DATVersion as varchar(16)) As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'Atm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
	        ,  case
		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
		else '---'
		end as EngineDat 
--		, '' as DatExtraDat

		-- agent fields
--		, '' as AgentVersion
--		, '' as AgentType
--		, '' as ConnectStatus

		-- computer info fields
  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		, case
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10Cvalt' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
   		, case 					-- use case incase outer join returns null
			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
			end as VirusType
--		,'' as VirusType
--		, '' as VirusSubtype
		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
		, TVDTaskName
--		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
--	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	data filter exists so dont join to top 10 table
	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)
	Left Outer Join 
	(
	Leafnode 
	Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
	Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
	) on(LeafNode.autoID = Events.NodeID)	

  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
		,BranchNode.NodeName
		,ProductName
		,ProductVersion
		,EngineVersion
		,DATVersion
--    		, TVDEventID				-- newest groups fields
--    		, TVDSeverity
   		, VirusType.VirusTypeTranslated
		, Events.VirusType
		, VirusType.VirusFileType
		, TVDTaskName
--		, EventFilterDescFast.Name 
		, ComputerProperties.Domainname
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform

--	Order by
--		'Count' desc

   end


   ------------------------------------------------------------------------
   -- 10.5 Fast (group summary) Fetch, top 10 Computers, with no data filter
   -- joins with a dynamically generated top 10 Computers
   -- does not join eventfilterdesc (no infection obly reports should)

   -- Fast (group summary) Fetch which includes top 10 Computers or Users
   else if lower(@szDrilldown1) = 'fast' and @EventType = 'InfectionCp' and @DataFilter = 'none'
   begin


 	SELECT   
		'' as 'Year'
		,'' as 'Month' --yrmo
		,'' as 'Week' --yrwk
		,'' as 'Quarter' --yrqrtr
--		DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr

		-- product info fields
    		,CAST(ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN  ProductVersion
	   		ELSE '---' 
	   		END
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
    		,'' AS EngineVersion
    		,'' As DATVersion
		,cast('' as varchar(10)) as ExtraDATNames
		, cast( 'A.5tm' as varchar(10)) as Language
	        ,  case
		when Events.ProductName + ' ' + Events.ProductVersion > '' then cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		when Events.ProductName > '' then cast((Events.ProductName) as varchar(50))
		when Events.ProductVersion > '' then cast((Events.ProductVersion) as varchar(50))
		else '---'
		end as FullProductName
--	        ,  case
--		when EngineVersion + ' ' +  DATVersion > '' then cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
--		when EngineVersion > '' then cast((EngineVersion) as varchar(50)) 
--		when DATVersion > '' then cast((DATVersion) as varchar(50)) 
--		else '---'
--		end as EngineDat 
		,'' as EngineDat

		-- computer info fields
  		, '' as NodeName 
		, '' as Domainname
		, ''  as OSType
		, ''  as OSPlatform
--  		, NodeName = 
--			CASE
--			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
--			ELSE @Unlinked
--			END 
--		, case
--			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
--			when ComputerProperties.Domainname = '' then '---'
--			else @Unlinked
--			end as Domainname
--		, case
--			when ComputerProperties.OSType > '' then ComputerProperties.OSType
--			when ComputerProperties.OSType = '' then '---'
--			else @Unlinked
--			end as OSType
--		, case
--			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
--			when ComputerProperties.OSPlatform = '' then '---'
--			else @Unlinked
--			end as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, cast('' as DateTime) as EventDateTime
--		, '' as LastContact

--		,  '' as HostName
		,  cast( HostName as varchar(50)) as HostName
--		, '' as UserName
		,  '' as UserName
		, cast( '' as varchar(32)) as HostIPAddress
--		,  HostIPAddress
--		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

-- Fetch top 10 Files
		, '' as FileName
--		,  cast( TOP 10 FileName as varchar(255)) as FileName
--		,  Events.FileName

		, cast( 'T10ca' as varchar(32)) as  ProductCode
		, 0 as NodeID
--		, NodeID
--		,0 as LNAutoID
--		,0 as LNParentID
--		,0 as PPAutoID
		-- End of Group summary difference fields

		-- Virus Fields
    		,VirusName =
	  		CASE 
	   		WHEN Events.VirusName > '' THEN Events.VirusName
	   		ELSE '---' 
	   		END
--		,'' as VirusName
--   		, case 					-- use case incase outer join returns null
--			when VirusType.VirusTypeTranslated > ''  then cast(VirusType.VirusTypeTranslated as varchar(30))
--			else case  when Events.VirusType > '' then cast(Events.VirusType as varchar(30)) else '---' end
--			end as VirusType
		,'' as VirusType
		, '' as VirusSubtype
--		, VirusType.VirusFileType as VirusSubtype
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN cast(ReportActionDesc.ActionName as varchar(30))
	     		ELSE  CAST(Events.ActionTaken AS varchar(30)) 
 	    		END
--		,'' as ActionTaken
--    		,cast( TVDEventID as varchar(10)) as TVDEventID
		,'' as TVDEventID
--    		,  case TVDSeverity
--			when 0 then 'Informational'
--			when 1 then 'Warning'
--			when 2 then 'Minor'
--			when 3 then 'Major'
--			when 4 then 'Critical'
--			else '---'
--			end  as TVDSeverity
		,'' as TVDSeverity
--		, TVDTaskName
		,'' as TVDTaskName
--    		, '' as ScanTime 
--		,'' as ScanTime
--		, case 
--			when EventFilterDescFast.Name > '' then cast(EventFilterDescFast.Name as varchar(128)) 
--			else case when TVDEventID > 0 then cast(TVDEventID as varchar(128)) else '---' end
--			end as EventDesc
		,'' as EventDesc
		
		-- new vs7.5 fields
--		, '' as Source
--		, '' as FileComponent

 
 	FROM 
	(
	Events
	Join ReportTop10Items on ( @Top10 = 'T10Cp' and Events.Hostname = ReportTop10Items.ItemName )
--	Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName)
	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
		and ReportActionDesc.LanguageID = @szFullLang)
	)

  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and	-- check for top10s
--	(
--		@Top10 = '' 
--		OR ( @Top10 = 'T10Ur' and Events.UserName in ( select ItemName from ReportTop10Items ) )
--		OR ( @Top10 = 'T10Cp' and Events.HostName in ( select ItemName from ReportTop10Items ) )
--	)
  	AND    	
	(
		@EventType = 'All'  or
		( @EventType = 'NotInfection' and (Events.VirusName = '' or Events.VirusName is null)) or 
		( @EventType = 'Infection' and Events.VirusName > '' AND Events.ProductName != 'ePO Agent'  ) or 
		( @EventType = 'InfectionCp' and Events.VirusName > ''  AND Events.ProductName != 'ePO Agent' ) 
	) 
   	AND ( TVDEventID not in ( 1202, 1203, 1506, 4600, 4650, 4651)  )	-- skip webshield events
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )

--   	AND LeafNode.Type !=  24      -- show all events even thoughs tied to deleted nodes 
	and ( @YYYYMMDDdate is null or Events.EventDateTime >=  @YYYYMMDDdate)
--             AND Events.ProductName != 'ePO Agent' 


	Group By
		Events.HostName
--		DateName(Year, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5))  
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) 
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
		,Events.VirusName
		,ReportActionDesc.ActionName
		,Events.ActionTaken
--		,Events.UserName
--		,BranchNode.NodeName
		,ProductName
		,ProductVersion


--	Order by
--		'Count' desc

   end



	set @ret = @@rowcount

	-- cleanup
--	Drop Table #LostLinksEvents		
	Drop Table dbo.tmpTop10s
	Drop Table dbo.tmpTop10Virus


RETURN @ret
END
GO


-- If VS8 installed: events.source exists, then rename VS8 version else rename non-VS8 version
if exists
	(select * 
		from syscolumns as c, sysobjects as o
		where 
		c.name = 'source'
		and o.name = 'events'
		and c.id = o.id
	)
begin
	if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
		drop procedure [dbo].[AVISP_FilterVAlertGroups]
	exec sp_rename 'AVISP_FilterVAlertGroupsVS8', 'AVISP_FilterVAlertGroups', 'OBJECT'
end
GO

---------



-------------------------------------------------------------------------------------
--
-- Do not load any changes here, because they will be ignored if VS8 is not installed
--	Load new changes above after the LOADHERE text.
--
-------------------------------------------------------------------------------------

--- Always end scripts with a comment (Last GO must have a CR after it)