/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.action.concrete;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.epo.EpoHttpClient;
import com.nai.mcafee.common.db.epo.EpoPassword;
import com.nai.mcafee.common.db.epo.EpoUser;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionImplBase;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;

public class PushEPOAgentAction
extends ActionImplBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction = PushEPOAgentAction.class$("com.nai.mcafee.snowcap.action.concrete.PushEPOAgentAction")) : class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction));
    public static final String PASSWORD_DISPLAY_FILLER = "********";
    public static final String TYPE = "pushAgent";
    public static final String[] PARAM_NAMES = new String[]{"AgentVersion", "SuppressGUI", "InstallPath", "UseEPOCredentials", "DomainAndUser", "Password", "EncryptedPassword"};
    private static int m_epoConsolePort = 0;
    private String m_agentVersion = "";
    private String m_username = "";
    private String m_domain = "";
    private String m_encPassword = "";
    private String m_installPath = "<PROGRAM_FILES_DIR>\\Network Associates\\Common Framework";
    private boolean m_hideInstallUI = true;
    private boolean m_useEPOCreds = true;
    private static HashMap m_agentMap = new HashMap();
    private static final String CONSOLE_HTTP_PORT_PARAM = "ConsoleHTTPPort";
    private static final int MAX_EPO_ENCRYPT_SIZE = 40;
    private static final String POST_URI = "Request\\{<GUID>}\\cnslrq.ini";
    private static final String CRLF = System.getProperty("line.separator");
    private static final Random RAND = new Random(System.currentTimeMillis());
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction;

    public PushEPOAgentAction() {
        m_log.debug((Object)"PushEPOAgentAction - ctor()");
    }

    public void setAgentVersion(String string) {
        m_log.debug((Object)("Setting agent version: " + string));
        this.m_agentVersion = string;
    }

    public String getAgentVersion() {
        return this.m_agentVersion;
    }

    public void setSuppressGUI(boolean bl) {
        m_log.debug((Object)("Setting SuppressGUI: " + bl));
        this.m_hideInstallUI = bl;
    }

    public void setSuppressGUI(Boolean bl) {
        m_log.debug((Object)("Setting SuppressGUI: " + bl));
        this.m_hideInstallUI = bl;
    }

    public Boolean getSuppressGUI() {
        return new Boolean(this.m_hideInstallUI);
    }

    public void setUseEPOCredentials(boolean bl) {
        m_log.debug((Object)("Setting useEPOCreds: " + bl));
        this.m_useEPOCreds = bl;
    }

    public void setUseEPOCredentials(Boolean bl) {
        m_log.debug((Object)("Setting useEPOCreds: " + bl));
        this.m_useEPOCreds = bl;
    }

    public Boolean getUseEPOCredentials() {
        return new Boolean(this.m_useEPOCreds);
    }

    public void setInstallPath(String string) {
        m_log.debug((Object)("Setting installPath: " + string));
        this.m_installPath = string;
    }

    public String getInstallPath() {
        return this.m_installPath;
    }

    public void setUserDomain(String string) {
        m_log.debug((Object)("Setting user domain: " + string));
        this.m_domain = string;
    }

    public String getUserDomain() {
        return this.m_domain;
    }

    public void setUserName(String string) {
        m_log.debug((Object)("Setting username: " + string));
        this.m_username = string;
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setPassword(String string) throws Exception {
        String string2 = "";
        if (string != null) {
            if (string.equals(PASSWORD_DISPLAY_FILLER)) {
                m_log.debug((Object)"setPassword - leaving password as is.");
                return;
            }
            if (!this.m_useEPOCreds) {
                char[] cArray = new char[40];
                Arrays.fill(cArray, '\u0000');
                m_log.debug((Object)"Encrypting password...");
                string2 = EpoPassword.encryptPassphrase((String)string);
                this.setEncryptedPassword(string2);
            }
        }
    }

    public String getPassword() {
        if (this.m_useEPOCreds) {
            return "";
        }
        return PASSWORD_DISPLAY_FILLER;
    }

    public void setEncryptedPassword(String string) {
        if (string != null && string.length() > 0) {
            m_log.debug((Object)("Setting encrypted password to: " + string));
            this.m_encPassword = string;
        } else {
            m_log.debug((Object)"Not resetting encrypted password with NULL...");
        }
    }

    public String getEncryptedPassword() {
        if (this.m_useEPOCreds) {
            return "";
        }
        return this.m_encPassword;
    }

    public void setDomainAndUser(String string) {
        String string2;
        String string3 = string;
        int n = string3.indexOf(92);
        if (n != -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        } else {
            string2 = "";
        }
        m_log.debug((Object)("Setting d and u: " + string2 + " and " + string3));
        this.setUserName(string3);
        this.setUserDomain(string2);
    }

    public String getDomainAndUser() {
        String string = this.getUserDomain();
        String string2 = this.getUserName();
        String string3 = "";
        if (string != null && string.length() > 0) {
            string3 = string3 + string + "\\";
        }
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + string2;
        }
        return string3;
    }

    public static synchronized int getEPOPort() throws FileNotFoundException, IOException, MissingResourceException {
        if (m_epoConsolePort == 0) {
            String string = Server.getEPOInstallDir();
            if (string.length() == 0) {
                throw new MissingResourceException("", (class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction = PushEPOAgentAction.class$("com.nai.mcafee.snowcap.action.concrete.PushEPOAgentAction")) : class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction).toString(), "epo.install.dir");
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string2 = string + "/DB/server.ini";
            FileInputStream fileInputStream = new FileInputStream(string2);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string3 = properties.getProperty(CONSOLE_HTTP_PORT_PARAM);
            if (string3 == null) {
                throw new MissingResourceException(string2, (class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction = PushEPOAgentAction.class$("com.nai.mcafee.snowcap.action.concrete.PushEPOAgentAction")) : class$com$nai$mcafee$snowcap$action$concrete$PushEPOAgentAction).toString(), CONSOLE_HTTP_PORT_PARAM);
            }
            string3 = string3.trim();
            m_epoConsolePort = Integer.parseInt(string3);
        }
        return m_epoConsolePort;
    }

    private void sendToEpoServer(int n, String string, String string2, String string3) throws Exception {
        long l = System.currentTimeMillis();
        String string4 = POST_URI;
        String string5 = Long.toString(l) + "-" + Long.toString(RAND.nextLong());
        string4 = string4.replaceFirst("<GUID>", string5);
        m_log.debug((Object)("URI is: " + string4));
        EpoHttpClient.postFile((String)"localhost", (int)n, (String)string, (String)string2, (int)2, (String)string4, (String)string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        Connection connection = null;
        try {
            try {
                connection = ActionEnvironment.instance().getEPODbConnection();
                EpoUser epoUser = EpoUser.getNonReviewer((Connection)connection);
                String string = (String)actionContext.getParamProperty("IpAddress");
                String string2 = (String)actionContext.getParamProperty("NetbiosName");
                if (string2 == null) {
                    string2 = "";
                }
                if ((this.m_domain == null || this.m_domain.length() == 0 || this.m_domain.equals(".")) && !this.m_useEPOCreds) {
                    this.m_domain = string2;
                }
                m_log.debug((Object)("Sending push request for target at: " + string));
                this.sendToEpoServer(PushEPOAgentAction.getEPOPort(), epoUser.getUserName(), epoUser.getPassword(), this.makeCnslrqINI(string));
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                this.setResults(1, stringWriter.toString(), null, actionStatus);
                int n = 1;
                Object var8_11 = null;
                DatabaseUtil.close((Connection)connection);
                return n;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return -1;
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_agent_push";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap getAgentMap(String string) throws Exception {
        HashMap hashMap = m_agentMap;
        synchronized (hashMap) {
            if (m_agentMap.get(string) == null) {
                PushEPOAgentAction.loadAgentMap(string);
            }
        }
        return (HashMap)m_agentMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadAgentMap(String string) throws Exception {
        Connection connection = null;
        try {
            connection = ActionEnvironment.instance().getEPODbConnection();
            HashMap hashMap = EpoDatabase.getAgentList(connection, "EPO", 68, string);
            m_agentMap.put(string == null ? "" : string, hashMap);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return PARAM_NAMES.length;
    }

    public String getPropertyName(int n) {
        return PARAM_NAMES[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeCnslrqINI(String string) throws ActionInvocationException {
        if (this.m_agentVersion.length() == 0 || this.m_installPath.length() == 0) {
            throw new ActionInvocationException(Resource.getString("pushepoagentaction_nullparameters"));
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("[AgentInstall]");
        stringBuffer.append(CRLF);
        stringBuffer.append("PackagePath=");
        HashMap hashMap = m_agentMap;
        synchronized (hashMap) {
            Iterator iterator = m_agentMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                HashMap hashMap2 = (HashMap)entry.getValue();
                String string2 = (String)hashMap2.get(this.m_agentVersion);
                if (string2 == null) continue;
                stringBuffer.append(string2);
                break;
            }
        }
        stringBuffer.append(CRLF);
        stringBuffer.append("HideInstallUI=");
        stringBuffer.append(this.m_hideInstallUI ? "1" : "0");
        stringBuffer.append(CRLF);
        stringBuffer.append("UserName=");
        stringBuffer.append(this.m_username);
        stringBuffer.append(CRLF);
        stringBuffer.append("DomainName=");
        stringBuffer.append(this.m_domain);
        stringBuffer.append(CRLF);
        stringBuffer.append("Password=");
        stringBuffer.append(this.m_encPassword);
        stringBuffer.append(CRLF);
        stringBuffer.append("InstallPath=");
        stringBuffer.append(this.m_installPath);
        stringBuffer.append(CRLF);
        stringBuffer.append("ComputerList0");
        stringBuffer.append("=");
        stringBuffer.append(string);
        stringBuffer.append(CRLF);
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Sending agent INI file: " + CRLF + stringBuffer));
        }
        return stringBuffer.toString();
    }

    public boolean appliesToStatus(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

