/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.db.DatabaseUtil;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CertificateValidator {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$snowcap$db$CertificateValidator == null ? (class$com$nai$mcafee$snowcap$db$CertificateValidator = CertificateValidator.class$("com.nai.mcafee.snowcap.db.CertificateValidator")) : class$com$nai$mcafee$snowcap$db$CertificateValidator));
    public static final String DEFAULT_ROOT_CERT_NAME = "root.pem";
    public static final String DEFAULT_KEY_CERT_NAME = "key.pem";
    public static final String DEFAULT_SENSOR_CERT_NAME = "sensor.pem";
    private static final String DEFAULT_QUERY = "select * from PolicySettings as ps right join Policy as p on ps.ParentID=p.AutoID where ps.SectionName='Security' and ProductCode='SNOWCAP_1000'";
    String m_rootCert;
    String m_keyCert;
    String m_sensorCert;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$CertificateValidator;

    public CertificateValidator(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        this.m_rootCert = stringBuffer.toString();
        this.m_keyCert = stringBuffer2.toString();
        this.m_sensorCert = stringBuffer3.toString();
    }

    public CertificateValidator(String string) throws IOException {
        if (!string.endsWith("\\")) {
            string = string + "\\";
        }
        String string2 = string + DEFAULT_ROOT_CERT_NAME;
        String string3 = string + DEFAULT_KEY_CERT_NAME;
        String string4 = string + DEFAULT_SENSOR_CERT_NAME;
        this.loadFiles(string2, string3, string4);
    }

    public CertificateValidator(String string, String string2, String string3, String string4) throws IOException {
        if (!string.endsWith("\\")) {
            string = string + "\\";
        }
        String string5 = string + string2;
        String string6 = string + string3;
        String string7 = string + string4;
        this.loadFiles(string5, string6, string7);
    }

    public CertificateValidator(String string, String string2, String string3) throws IOException {
        this.loadFiles(string, string2, string3);
    }

    private void loadFiles(String string, String string2, String string3) throws IOException {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Loading certificate files from disk: " + string + ", " + string2 + ", " + string3));
        }
        FileReader fileReader = new FileReader(string);
        FileReader fileReader2 = new FileReader(string2);
        FileReader fileReader3 = new FileReader(string3);
        this.m_rootCert = this.readIn(fileReader);
        this.m_keyCert = this.readIn(fileReader2);
        this.m_sensorCert = this.readIn(fileReader3);
    }

    private String readIn(FileReader fileReader) throws IOException {
        int n = 0;
        int n2 = 512;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while ((n = fileReader.read(cArray, 0, n2)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean validate(Connection connection) throws SQLException {
        boolean bl = false;
        Statement statement = null;
        m_log.debug((Object)"Validating certificates on disk against the database.");
        try {
            statement = connection.createStatement();
            String string = DEFAULT_QUERY;
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString("SettingName");
                String string3 = resultSet.getString("Value");
                if (string2.equalsIgnoreCase("RootCert")) {
                    bl = string3.equals(this.m_rootCert);
                    m_log.debug((Object)("RootCert match: " + bl));
                } else if (string2.equalsIgnoreCase("SensorCert")) {
                    bl = string3.equals(this.m_sensorCert);
                    m_log.debug((Object)("SensorCert match: " + bl));
                } else if (string2.equalsIgnoreCase("PrivateKey")) {
                    bl = string3.equals(this.m_keyCert);
                    m_log.debug((Object)("KeyCert match: " + bl));
                }
                if (bl) continue;
            }
            resultSet.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        String string = "update PolicySettings set Value=?, TheTimestamp=@@DBTS where SettingName=? and ParentID=?";
        m_log.debug((Object)"Updating the certificate values in the DB.");
        int n = -1;
        try {
            preparedStatement = connection.prepareStatement(DEFAULT_QUERY);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt("ParentID");
            }
            resultSet.close();
            if (n != -1) {
                preparedStatement = connection.prepareStatement(string);
                m_log.debug((Object)"Updating the root certificate.");
                preparedStatement.setString(1, this.m_rootCert);
                preparedStatement.setString(2, "RootCert");
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                m_log.debug((Object)"Updating the private key.");
                preparedStatement.setString(1, this.m_keyCert);
                preparedStatement.setString(2, "PrivateKey");
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                m_log.debug((Object)"Updating the sensor certificate.");
                preparedStatement.setString(1, this.m_sensorCert);
                preparedStatement.setString(2, "SensorCert");
                preparedStatement.setInt(3, n);
                preparedStatement.executeUpdate();
                connection.commit();
                statement = connection.createStatement();
                ResultSet resultSet2 = statement.executeQuery("select * from BranchNode where Type='4'");
                if (resultSet2.next()) {
                    int n2 = resultSet2.getInt("AutoId");
                    string = "update Policy set TheTimestamp=@@DBTS where ProductCode='SNOWCAP_1000' AND ParentID='" + Integer.toString(n2) + "'";
                    statement.executeUpdate(string);
                    string = "update BranchNode set PolicyTimestamp=@@DBTS where AutoId='" + Integer.toString(n2) + "'";
                    connection.commit();
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DatabaseUtil.close((Statement)preparedStatement);
            DatabaseUtil.close(statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)preparedStatement);
        DatabaseUtil.close(statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

