/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db.io;

import com.nai.mcafee.snowcap.db.io.Docks;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDock
extends DefaultHandler
implements Docks {
    private String m_type;
    private static final String topElement = "SnowcapData";
    private static final String rowElement = "DBROW";
    public static final String encoding = "UTF-8";
    private StringBuffer m_elementString = new StringBuffer(256);
    private Vector m_curElementRet;
    private HashMap m_parseRet;
    private String m_curElement;

    public XMLDock() {
    }

    public XMLDock(String string) {
        this.m_type = string;
    }

    public void SetExportType(String string) {
        this.m_type = string;
    }

    public void Export(String string, ResultSet resultSet, OutputStream outputStream) throws IOException {
        try {
            outputStream.write("<?xml version=\"1.0\" encoding=\"".getBytes(encoding));
            outputStream.write(encoding.getBytes(encoding));
            outputStream.write("\" ?>\n".getBytes(encoding));
            outputStream.write("<".getBytes(encoding));
            outputStream.write(topElement.getBytes(encoding));
            outputStream.write(" type=\"".getBytes(encoding));
            outputStream.write(this.m_type.getBytes(encoding));
            outputStream.write("\" schemaversion=\"".getBytes(encoding));
            outputStream.write(string.getBytes(encoding));
            outputStream.write("\">\n".getBytes(encoding));
            while (resultSet.next()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                outputStream.write("  <".getBytes(encoding));
                outputStream.write(rowElement.getBytes(encoding));
                outputStream.write(">\n".getBytes(encoding));
                int n = 1;
                while (n <= resultSetMetaData.getColumnCount()) {
                    String string2 = resultSetMetaData.getColumnTypeName(n);
                    outputStream.write("    <".getBytes(encoding));
                    outputStream.write(resultSetMetaData.getColumnName(n).getBytes(encoding));
                    outputStream.write(" type=\"".getBytes(encoding));
                    outputStream.write(string2.getBytes(encoding));
                    outputStream.write("\">".getBytes(encoding));
                    try {
                        String string3 = resultSet.getString(n);
                        if (string3 != null) {
                            if (string2.equals("bit")) {
                                Boolean bl = new Boolean(string3);
                                string3 = bl != false ? "1" : "0";
                            }
                            string3 = string3.replaceAll("&", "&amp;");
                            string3 = string3.replaceAll("<", "&lt;");
                            string3 = string3.replaceAll(">", "&gt;");
                            outputStream.write(string3.getBytes(encoding));
                        } else {
                            outputStream.write("NULL".getBytes(encoding));
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    outputStream.write("</".getBytes(encoding));
                    outputStream.write(resultSetMetaData.getColumnName(n).getBytes(encoding));
                    outputStream.write(">\n".getBytes(encoding));
                    ++n;
                }
                outputStream.write("  </".getBytes(encoding));
                outputStream.write(rowElement.getBytes(encoding));
                outputStream.write(">\n\n".getBytes(encoding));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(new PrintStream(outputStream));
        }
        outputStream.write("</".getBytes(encoding));
        outputStream.write(topElement.getBytes(encoding));
        outputStream.write(">\n".getBytes(encoding));
    }

    public HashMap Import(InputStream inputStream) throws IOException, ParseException {
        this.m_parseRet = new HashMap();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException.getMessage(), 0);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return this.m_parseRet;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!string3.equals(topElement) && !string3.equals(rowElement)) {
            this.m_curElement = string3;
            this.m_curElementRet = (Vector)this.m_parseRet.get(this.m_curElement);
            if (this.m_curElementRet == null) {
                this.m_curElementRet = new Vector();
            }
            this.m_elementString.setLength(0);
        } else if (string3.equals(topElement)) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getQName(n);
                String string5 = attributes.getValue(n);
                if (string4.equals("type")) {
                    if (!this.m_type.equalsIgnoreCase(string5)) {
                        throw new SAXException("Import data is not from " + this.m_type);
                    }
                } else {
                    this.m_parseRet.put(string4, string5);
                }
                ++n;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!string3.equals(topElement) && !string3.equals(rowElement)) {
            String string4 = this.m_elementString.toString();
            if (this.validateValue(string4)) {
                this.m_curElementRet.add(this.m_elementString.toString());
                this.m_parseRet.put(this.m_curElement, this.m_curElementRet);
            } else {
                throw new SAXException("Illegal value '" + string4 + " for key '" + this.m_curElement);
            }
        }
    }

    private boolean validateValue(String string) {
        boolean bl = false;
        if (this.m_curElement.equalsIgnoreCase("mac")) {
            if (string.matches("[\\p{XDigit}]{12}")) {
                bl = true;
            }
        } else if (this.m_curElement.equalsIgnoreCase("exception")) {
            if (string.matches("[10]")) {
                bl = true;
            }
        } else if (this.m_curElement.equalsIgnoreCase("firstdetecttime")) {
            if (string.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{1,3}")) {
                bl = true;
            }
        } else if (this.m_curElement.equalsIgnoreCase("comments")) {
            bl = true;
        }
        return bl;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.m_elementString.append(cArray, n, n2);
    }
}

