/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.server;

import com.nai.mcafee.common.condition.SerializationException;
import com.nai.mcafee.common.condition.SexpSerializer;
import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.Queries;
import com.nai.mcafee.common.db.Tool;
import com.nai.mcafee.common.db.destination.Contact;
import com.nai.mcafee.common.db.epo.EpoUser;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.util.ResourceException;
import com.nai.mcafee.snowcap.action.Action;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionInvoker;
import com.nai.mcafee.snowcap.action.concrete.ExternalToolAction;
import com.nai.mcafee.snowcap.action.concrete.QueryEPOAgentAction;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.CertificateValidator;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.ResponseDatabaseObject;
import com.nai.mcafee.snowcap.db.SchemaVersion;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.action.ActionFactory;
import com.nai.mcafee.snowcap.db.action.ActionFactoryException;
import com.nai.mcafee.snowcap.db.action.ActionPropertyException;
import com.nai.mcafee.snowcap.event.EventDispatcher;
import com.nai.mcafee.snowcap.event.EventFactory;
import com.nai.mcafee.snowcap.event.EventHandler;
import com.nai.mcafee.snowcap.event.Response;
import com.nai.mcafee.snowcap.event.concrete.NewRogueHostEvent;
import com.nai.mcafee.snowcap.rmd.AgentDeployedStatusUpdater;
import com.nai.mcafee.snowcap.rmd.MessageProcessor;
import com.nai.mcafee.snowcap.rmd.NewRogueAction;
import com.nai.mcafee.snowcap.server.ActionEnvironmentImpl;
import com.nai.mcafee.snowcap.server.EpoSubnetImporter;
import com.nai.mcafee.snowcap.server.ServerInitException;
import com.nai.mcafee.snowcap.server.ServerStatistics;
import com.nai.mcafee.snowcap.server.SubnetEventGenerator;
import com.nai.mcafee.snowcap.server.SubnetStatusTable;
import com.nai.mcafee.snowcap.ui.util.ActionUtil;
import com.nai.mcafee.snowcap.util.Resource;
import com.nai.mcafee.snowcap.util.thread.PeriodicTaskThread;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class Server {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$server$Server == null ? (class$com$nai$mcafee$snowcap$server$Server = Server.class$("com.nai.mcafee.snowcap.server.Server")) : class$com$nai$mcafee$snowcap$server$Server).getName());
    public static final String DEFAULT_LOG_FILENAME = "c:/snowcap.log";
    public static final String LOG_CONFIG_FILENAME = "log_config.xml";
    public static final String SERVER_CONFIG_FILENAME = "SnowcapServer.properties";
    public static final String LOCAL_IP = "127.0.0.1";
    private static Database m_db = null;
    private static Database m_epoDb = null;
    private static boolean m_logAllEvents = false;
    private static boolean m_logErrorEvents = false;
    private static boolean m_sInitialized = false;
    private static boolean m_sInitFailed = false;
    private static int m_eventProcessRetries = 3;
    private static int m_numActionThreads = 3;
    private static int m_numEventThreads = 5;
    private static ServerStatistics m_statistics = new ServerStatistics();
    private static boolean m_statisticsEnabled = false;
    private static Configuration m_config = null;
    private static Contact[] m_contacts = null;
    private static Tool[] m_tools = null;
    private static String m_initErrorString = "";
    private static EventDispatcher m_eventDispatcher = new EventDispatcher();
    private static ActionInvoker m_actionInvoker = null;
    private static EpoSubnetImporter m_epoSubnetImporter = new EpoSubnetImporter();
    private static SubnetEventGenerator m_subnetEventGen = new SubnetEventGenerator();
    private static PeriodicTaskThread m_periodicTaskThread = new PeriodicTaskThread();
    private static String m_tomcatPort = "";
    private static String m_localHostName = "";
    private static String m_ePOInstallDir = "";
    private static SubnetStatusTable m_activeSensorTable = new SubnetStatusTable();
    private static ActionFactory m_actionFactory = null;
    private static String m_agentHttpPort = "8080";
    private static String m_defaultLocale = null;
    private static boolean m_shouldSyncCerts = false;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$server$Server;

    public static synchronized void init() throws Exception {
        if (m_sInitialized) {
            return;
        }
        m_sInitFailed = true;
        try {
            Server.initLogging();
            Properties properties = Server.loadProperties();
            Server.setGeneralProperties(properties);
            Server.setEPOProperties(properties);
            Server.initDatabase(properties);
            SchemaVersion.verifyDbSchemaVersion(Server.getDb());
            ActionEnvironment.setInstance(new ActionEnvironmentImpl());
            m_log.debug((Object)("Starting " + m_numActionThreads + " action processing threads."));
            m_actionInvoker = new ActionInvoker(m_numActionThreads);
            Server.reloadConfiguration();
            MessageProcessor.instance().setNewRogueAction(new NewRogueActionImpl());
            MessageProcessor.instance().setAgentDeployedStatusUpdater(new AgentStatusUpdaterImpl());
            m_log.debug((Object)("Starting " + m_numEventThreads + " event processing threads."));
            m_eventDispatcher.start(m_numEventThreads);
            Server.initPeriodicTasks(properties);
            ActionUtil.buildActions(m_defaultLocale);
            if (m_shouldSyncCerts) {
                Server.syncCertificates();
            }
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("server_init_failed"), (Throwable)exception);
            m_initErrorString = exception.getMessage();
            throw exception;
        }
        m_statistics.reset();
        m_sInitFailed = false;
        m_initErrorString = "";
        m_sInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void syncCertificates() {
        Connection connection = null;
        try {
            block4: {
                try {
                    connection = m_epoDb.getConnection();
                    CertificateValidator certificateValidator = new CertificateValidator(m_ePOInstallDir + "\\DB\\Certificates");
                    if (certificateValidator.validate(connection)) break block4;
                    certificateValidator.update(connection);
                }
                catch (Exception exception) {
                    m_log.warn((Object)Resource.getString("server_no_cert_validation"), (Throwable)exception);
                    Object var3_4 = null;
                    DatabaseUtil.close((Connection)connection);
                    return;
                }
            }
            Object var3_3 = null;
            DatabaseUtil.close((Connection)connection);
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
    }

    private static final void initPeriodicTasks(Properties properties) {
        long l = Long.parseLong(Resource.getStringOrDefault(properties, "uncovered.subnet.check.period", "600000"));
        m_periodicTaskThread.addPeriodicTask(m_epoSubnetImporter);
        m_periodicTaskThread.addPeriodicTask(m_subnetEventGen, l);
        m_periodicTaskThread.start();
        m_periodicTaskThread.runAsync(m_epoSubnetImporter);
    }

    public static synchronized void shutdown() {
        if (!m_sInitialized) {
            return;
        }
        m_eventDispatcher.stop(false);
        m_actionInvoker.stop();
        m_periodicTaskThread.stop(false);
        m_sInitialized = false;
    }

    public static Database getDb() {
        return m_db;
    }

    public static Database getEpoDb() {
        return m_epoDb;
    }

    public static String getInitErrorString() {
        return m_initErrorString;
    }

    public static EventDispatcher getEventDispatcher() {
        return m_eventDispatcher;
    }

    public static ActionInvoker getActionInvoker() {
        return m_actionInvoker;
    }

    public static final String getTomcatPort() {
        return m_tomcatPort;
    }

    public static final String getLocalHostName() {
        return m_localHostName;
    }

    public static final String getEPOInstallDir() {
        return m_ePOInstallDir;
    }

    public static final String getAgentHttpPort() {
        return m_agentHttpPort;
    }

    public static EpoSubnetImporter getEpoSubnetImporter() {
        return m_epoSubnetImporter;
    }

    public static SubnetStatusTable getActiveSensorTable() {
        return m_activeSensorTable;
    }

    public static ActionFactory getActionFactory() {
        return m_actionFactory;
    }

    public static final boolean shouldLogAllEvents() {
        return m_logAllEvents;
    }

    public static final boolean shouldLogErrorEvents() {
        return m_logErrorEvents;
    }

    public static final boolean profilingEnabled() {
        return m_statisticsEnabled;
    }

    public static final ServerStatistics getStatistics() {
        return m_statistics;
    }

    public static final int numEventProcRetries() {
        return m_eventProcessRetries;
    }

    public static synchronized void cleanup() {
    }

    public static final synchronized boolean initialized() {
        return m_sInitialized;
    }

    public static final synchronized boolean initFailed() {
        return m_sInitFailed;
    }

    public static final void logError(String string) {
        m_log.error((Object)string);
    }

    private static void initLogging() {
        FileAppender fileAppender;
        Enumeration enumeration;
        URL uRL = (class$com$nai$mcafee$snowcap$server$Server == null ? (class$com$nai$mcafee$snowcap$server$Server = Server.class$("com.nai.mcafee.snowcap.server.Server")) : class$com$nai$mcafee$snowcap$server$Server).getClassLoader().getResource(LOG_CONFIG_FILENAME);
        if (uRL != null) {
            DOMConfigurator.configureAndWatch((String)uRL.getFile());
        }
        Logger logger = Logger.getRootLogger();
        boolean bl = false;
        if (!logger.getAllAppenders().hasMoreElements()) {
            bl = true;
            enumeration = new PatternLayout("%d{ISO8601} %-5p %-15c{2} %x - %m%n");
            fileAppender = new FileAppender();
            ConsoleAppender consoleAppender = new ConsoleAppender();
            fileAppender.setName("ToFile");
            fileAppender.setLayout((Layout)enumeration);
            fileAppender.setBufferedIO(false);
            fileAppender.setFile(DEFAULT_LOG_FILENAME);
            fileAppender.setAppend(true);
            fileAppender.activateOptions();
            consoleAppender.setName("ToStdout");
            consoleAppender.setLayout((Layout)enumeration);
            consoleAppender.setTarget("System.out");
            consoleAppender.activateOptions();
            logger.addAppender((Appender)fileAppender);
            logger.addAppender((Appender)consoleAppender);
            logger.setLevel(Level.INFO);
        }
        if (bl) {
            m_log.warn((Object)Resource.formatString("server_template_init_failed", LOG_CONFIG_FILENAME));
        }
        enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            fileAppender = (Appender)enumeration.nextElement();
            if (!(fileAppender instanceof FileAppender)) continue;
            m_log.info((Object)Resource.formatString("server_template_writing_log_file", fileAppender.getFile()));
        }
    }

    private static final String exhaustActionAsString(byte by) {
        switch (by) {
            case 1: {
                return "block";
            }
            case 2: {
                return "grow";
            }
        }
        return "<INVALID-VALUE>";
    }

    public static final boolean allowedToEdit(HttpServletRequest httpServletRequest) {
        EpoUser epoUser = UserUtil.getEpoUser((HttpServletRequest)httpServletRequest);
        boolean bl = Server.getConfiguration().getAllowSiteAdmins();
        boolean bl2 = epoUser.isReviewer() ? false : !epoUser.isSiteAccount() || bl;
        return bl2;
    }

    public static void initDatabase(Properties properties) throws ServerInitException {
        boolean bl = Resource.getStringOrDefault(properties, "epo.use.server.ini", "false").equals("true");
        try {
            m_db = bl ? Database.createFromServerINI((Properties)properties, (String)"snowcap", (String)Queries.VALIDATE_SNOWCAP_DB) : Database.createFromPropertiesFile((Properties)properties, (String)"snowcap", (String)Queries.VALIDATE_SNOWCAP_DB);
        }
        catch (Exception exception) {
            throw new ServerInitException(Resource.formatString("server_template_error_connecting", new Object[]{"Rogue System Server", exception.getMessage()}), exception);
        }
        m_log.info((Object)Resource.getString("server_snowcap_db_init_success"));
        try {
            m_epoDb = !bl ? Database.createFromPropertiesFile((Properties)properties, (String)"epo", (String)Queries.VALIDATE_EPO_DB) : Database.createFromServerINI((Properties)properties, (String)"epo", (String)Queries.VALIDATE_EPO_DB);
        }
        catch (Exception exception) {
            throw new ServerInitException(Resource.formatString("server_template_error_connecting", new Object[]{"ePO Server", exception.getMessage()}), exception);
        }
        m_log.info((Object)Resource.getString("server_epo_db_init_success"));
    }

    public static final Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        InputStream inputStream = (class$com$nai$mcafee$snowcap$server$Server == null ? (class$com$nai$mcafee$snowcap$server$Server = Server.class$("com.nai.mcafee.snowcap.server.Server")) : class$com$nai$mcafee$snowcap$server$Server).getClassLoader().getResourceAsStream(SERVER_CONFIG_FILENAME);
        if (inputStream == null) {
            throw new ServerInitException(Resource.formatString("server_template_load_config_failed", SERVER_CONFIG_FILENAME));
        }
        properties.load(inputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reloadConfiguration() throws SQLException, ActionPropertyException, ActionFactoryException, SerializationException {
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            m_log.debug((Object)"(re)loading configuration.");
            m_config = Configuration.get(connection);
            m_contacts = Contact.getAll((Connection)connection);
            m_tools = Tool.getAll((Connection)connection, (int)1);
            m_actionFactory = new ActionFactory(connection);
            m_log.debug((Object)"Loading new response set.");
            ResponseDatabaseObject[] responseDatabaseObjectArray = ResponseDatabaseObject.getEnabledInOrder(connection);
            EventHandler[] eventHandlerArray = new EventHandler[responseDatabaseObjectArray.length];
            Response.DefaultErrorHandler defaultErrorHandler = new Response.DefaultErrorHandler();
            int n = 0;
            while (n < responseDatabaseObjectArray.length) {
                Response response = new Response(defaultErrorHandler, Server.getActionInvoker());
                eventHandlerArray[n] = response;
                response.setName(responseDatabaseObjectArray[n].getName());
                response.setEventType(responseDatabaseObjectArray[n].getEventType());
                if (responseDatabaseObjectArray[n].getCondition().length() > 0) {
                    response.setCondition(SexpSerializer.read((String)responseDatabaseObjectArray[n].getCondition()));
                } else {
                    response.setCondition(null);
                }
                m_log.debug((Object)("[*] Adding response:" + response.getName()));
                ActionBase[] actionBaseArray = ActionBase.getByResponseId(connection, responseDatabaseObjectArray[n].getId(), m_actionFactory);
                int n2 = 0;
                while (n2 < actionBaseArray.length) {
                    response.addAction((Action)((Object)actionBaseArray[n2]));
                    m_log.debug((Object)("   -- Adding action:" + actionBaseArray[n2]));
                    ++n2;
                }
                ++n;
            }
            m_eventDispatcher.replaceHandlers(eventHandlerArray);
            m_log.debug((Object)"Current response set replaced with new set.");
            m_epoSubnetImporter.setRunPeriodInMs(m_config.getEpoImportPeriod(), System.currentTimeMillis());
            m_subnetEventGen.setServerInfo(m_config.getSensorWindow(), m_eventDispatcher, Server.getDb());
            Server.logEpoLookupMethod();
            MessageProcessor.instance().setEpoDbLookupMethod(m_config.getEpoDbLookupMethod());
            long l = m_config.getDeadAgentPeriod();
            m_log.debug((Object)("Setting inactive agent period to:" + (l == 0L ? "<disabled>" : l + " milliSec.")));
            MessageProcessor.instance().setDeadAgentPeriodInMs(l);
            m_activeSensorTable.setInactiveSensorPeriod(m_config.getSensorWindow());
            m_activeSensorTable.setMaxSensorsPerSubnet(m_config.getMaxActiveSensors());
            m_activeSensorTable.setSensorRotationPeriod(m_config.getMaxActiveSensorTime());
            m_activeSensorTable.setEnabled(m_config.isLimitSensorsEnabled());
            long l2 = m_config.getGracePeriod();
            if (!m_config.isGracePeriodEnabled()) {
                l2 = 0L;
            }
            m_log.debug((Object)("Setting rogue grace period period to:" + (l2 == 0L ? "<disabled>" : l2 + " milliSec")));
            MessageProcessor.instance().setGracePeriodInMs(l2);
            QueryEPOAgentAction.setPorts(Server.getAgentHttpPort(), m_config.getAddnlAgentPorts().split(":"));
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public static boolean isValidEpoLookupMethod(int n) {
        return n == 1 || n == 3 || n == 7;
    }

    private static void logEpoLookupMethod() {
        String string = "";
        switch (m_config.getEpoDbLookupMethod()) {
            case 7: {
                string = "MAC,Name (with domain)";
                break;
            }
            case 3: {
                string = "MAC,Name";
                break;
            }
            case 1: {
                string = "MAC";
                break;
            }
            default: {
                m_config.setEpoDbLookupMethod(1);
                string = "MAC";
            }
        }
        m_log.info((Object)("Setting ePO host lookup method to:" + string));
    }

    public static final boolean isLocal(HttpServletRequest httpServletRequest) {
        Boolean bl = (Boolean)httpServletRequest.getAttribute("ISLOCAL");
        if (bl == null) {
            bl = new Boolean(false);
        }
        return bl;
    }

    public static final void setLocal(HttpServletRequest httpServletRequest) throws UnknownHostException {
        String string;
        Boolean bl = new Boolean(false);
        String string2 = httpServletRequest.getRemoteAddr();
        if (string2.compareTo(string = InetAddress.getLocalHost().getHostAddress()) == 0 || string2.compareTo(LOCAL_IP) == 0) {
            bl = new Boolean(true);
        }
        httpServletRequest.setAttribute("ISLOCAL", (Object)bl);
    }

    public static Contact[] getContacts() {
        return m_contacts;
    }

    public static Tool[] getTools() {
        return m_tools;
    }

    public static Configuration getConfiguration() {
        return m_config;
    }

    public static String getDefaultLocale() {
        return m_defaultLocale;
    }

    private static final void setGeneralProperties(Properties properties) throws ServerInitException, ResourceException {
        String string = properties.getProperty("log.event.details", "none");
        String string2 = Locale.getDefault().getLanguage();
        if (string2 == null) {
            string2 = "en";
        }
        m_defaultLocale = Resource.getStringOrDefault(properties, "server.default.language", string2);
        Resource.setDefaultLocale(m_defaultLocale);
        com.nai.mcafee.common.util.Resource.setDefaultLocale((String)m_defaultLocale);
        m_log.info((Object)Resource.formatString("server_template_default_lang", com.nai.mcafee.common.util.Resource.getString((String)("language_" + m_defaultLocale)), m_defaultLocale));
        if (string.equals("all")) {
            m_logAllEvents = true;
            m_logErrorEvents = false;
        } else if (string.equals("error")) {
            m_logAllEvents = false;
            m_logErrorEvents = true;
        } else {
            m_logAllEvents = false;
            m_logErrorEvents = false;
        }
        m_eventProcessRetries = Integer.parseInt(properties.getProperty("event.processing.retries", "3"));
        if (m_eventProcessRetries < 0) {
            m_eventProcessRetries = 0;
        }
        String string3 = properties.getProperty("server.performance.profiling", "false");
        m_statisticsEnabled = string3.equals("true");
        m_tomcatPort = Resource.getStringOrThrow(properties, "snowcap.server.port", SERVER_CONFIG_FILENAME);
        m_localHostName = Server.getHostname();
        m_ePOInstallDir = Resource.getStringOrThrow(properties, "epo.install.dir", SERVER_CONFIG_FILENAME);
        m_numActionThreads = Integer.parseInt(properties.getProperty("num.action.threads", "3"));
        m_numEventThreads = Integer.parseInt(properties.getProperty("num.event.threads", "5"));
        ExternalToolAction.setTTL(Integer.parseInt(properties.getProperty("tool.max.runtime", "60000")));
        String string4 = properties.getProperty("server.synchronize.sensor.certs", "true");
        m_shouldSyncCerts = string4.equalsIgnoreCase("true");
    }

    private static final void setEPOProperties(Properties properties) throws Exception {
        try {
            Properties properties2 = new Properties();
            String string = Server.getPathToServerIni(properties);
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream == null) {
                throw new ServerInitException(Resource.formatString("server_template_load_config_failed", string));
            }
            properties2.load(fileInputStream);
            m_agentHttpPort = Resource.getStringOrThrow(properties2, "AgentHttpPort", SERVER_CONFIG_FILENAME);
        }
        catch (Exception exception) {
            m_agentHttpPort = "8080";
            m_log.warn((Object)Resource.formatString("server_warn_get_agent_port", exception.toString()));
        }
    }

    private static final String getHostname() throws ServerInitException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServerInitException(Resource.getString("server_no_localhost_name"));
        }
    }

    private static final String getPathToServerIni(Properties properties) throws ResourceException {
        return Resource.getStringOrThrow(properties, "epo.install.dir", SERVER_CONFIG_FILENAME) + "/Db/server.ini";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class AgentStatusUpdaterImpl
    implements AgentDeployedStatusUpdater {
        public void update(Connection connection, Host host, Timestamp timestamp) throws SQLException {
            ActionStatus.updateAgentDeployedStatus(connection, host.getId(), timestamp);
        }
    }

    public static class NewRogueActionImpl
    implements NewRogueAction {
        public void newRogueDetected(Connection connection, Network network, Sensor sensor, Host host) {
            NewRogueHostEvent newRogueHostEvent = null;
            try {
                newRogueHostEvent = EventFactory.createNewRogueHostEvent(connection, host, network, sensor);
            }
            catch (SQLException sQLException) {
                m_log.warn((Object)"Unable to add new rogue host event to the database..", (Throwable)sQLException);
                newRogueHostEvent = EventFactory.createNewRogueHostEvent(host, network, sensor);
            }
            Server.getEventDispatcher().addEvent(newRogueHostEvent);
        }
    }
}

