/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.tables.HtmlTable;
import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.util.PropDisplayInterface;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.SnowcapPropPage;
import com.nai.mcafee.snowcap.ui.util.NetworkPropDisplay;
import com.nai.mcafee.snowcap.ui.util.PropDisplay;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;

public class DisplaySubnetDetailsBean
extends SnowcapPropPage {
    public static final String ACTION_STRING = "displaysubnetdetails.do";

    protected String getActionName() {
        return ACTION_STRING;
    }

    protected String getClickedIDParam() {
        return "subnetId";
    }

    protected String getIndexParam() {
        return "subnetDetailsIndex";
    }

    protected Class getBeanClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected PropDisplay getPropDisplay(String string) {
        return new NetworkPropDisplay(string);
    }

    protected String getPropertyTableName() {
        return "subnetDetails";
    }

    protected String getPostPropertyTableName() {
        return "subnetDetailsPostProps";
    }

    protected String getNextPage() {
        return "subnetdetails.jsp";
    }

    protected String getBaseStringKey() {
        return "displaysubnetdetailsbean";
    }

    protected void calculateProperties(Connection connection, DatabaseObject databaseObject) throws Exception {
        Network network = (Network)databaseObject;
        network.calculateProperties(System.currentTimeMillis(), Server.getConfiguration().getSensorWindow(), false);
        if (network.getNumSensorsCalculated() == 0) {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select count(*) as NumSensors, max(LastCommunicationTime) as LastCommTime from Sensors where NetworkId='" + network.getId() + "'");
            if (resultSet != null && resultSet.next()) {
                network.setNumSensorsCalculated(resultSet.getInt(1));
                network.setLastComTimeCalculated(resultSet.getTimestamp(2));
            }
            network.calculateProperties(System.currentTimeMillis(), Server.getConfiguration().getSensorWindow(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doPostTableStuff(DatabaseObject databaseObject, PropDisplayInterface propDisplayInterface, HttpServletRequest httpServletRequest) throws Exception {
        HtmlTable htmlTable;
        Sensor[] sensorArray = null;
        Network network = (Network)databaseObject;
        StringBuffer stringBuffer = new StringBuffer();
        Connection connection = null;
        long l = Server.getConfiguration().getSensorWindow();
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        try {
            connection = Server.getDb().getConnection();
            sensorArray = Sensor.getByNetworkID(connection, network.getId());
            htmlTable = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        stringBuffer.append("<h5>").append(Resource.getJspString("jsputil_sensors", string)).append("</h5>");
        htmlTable = new HtmlTable();
        HtmlTableHeader htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.addCell(Resource.getJspString("jsputil_status", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_hostname", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_ip_address", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_mac_address", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_last_sensor_comm", string));
        this.addSensors(sensorArray, htmlTable, l, string);
        stringBuffer.append(htmlTable.getHtml(string));
        httpServletRequest.setAttribute("NetworkAddress", (Object)network.getNetworkAddress());
        httpServletRequest.setAttribute("NetworkMask", (Object)network.getSubnetMask());
        httpServletRequest.setAttribute("subnetId", (Object)Integer.toString(network.getId()));
        httpServletRequest.setAttribute("NetworkAddress", (Object)network.getNetworkAddress());
        return stringBuffer.toString();
    }

    protected int[] getColumns() {
        return new int[]{10, 8, 9, -1, 7, 2};
    }

    protected String getHeaderCellMarkup(int n, String string, DatabaseObject databaseObject, String string2) {
        return string;
    }

    protected String getPropCellMarkup(int n, String string, DatabaseObject databaseObject, String string2) {
        String string3;
        Network network = (Network)databaseObject;
        switch (n) {
            case 2: {
                if (string.indexOf("&nbsp;") != -1) {
                    string = "";
                }
                string3 = "<input type='text' size=16 name='subnetName' id='subnetName' onkeypress='validateString(event);' onkeyup='blankInvalidString(event);' value='" + string + "'></input> " + "<img src='images/px_trans.gif' height=1 width=3 border=0> " + "<input type='button' class='clsBtn' " + "value='" + Resource.getJspString("jsputil_save", string2) + "' " + "onclick='updateSubnetName(" + network.getId() + ")'></input>";
                break;
            }
            default: {
                string3 = string;
            }
        }
        return string3;
    }

    private void addSensors(Sensor[] sensorArray, HtmlTable htmlTable, long l, String string) throws Exception {
        HtmlTableRow htmlTableRow = null;
        if (sensorArray != null) {
            Timestamp timestamp = new Timestamp(System.currentTimeMillis() - l);
            int n = 0;
            while (n < sensorArray.length) {
                boolean bl = Server.getActiveSensorTable().isSensorActive(sensorArray[n].getNetworkID(), sensorArray[n].getId());
                if (sensorArray[n].getLastCommunicationTime().compareTo(timestamp) < 0) {
                    htmlTableRow = htmlTable.addRow(3);
                    htmlTableRow.addCell(Resource.getJspString("jsputil_inactive_sensor", string));
                } else if (bl) {
                    htmlTableRow = htmlTable.addRow(8);
                    htmlTableRow.addCell(Resource.getJspString("jsputil_active_sensor", string));
                } else {
                    htmlTableRow = htmlTable.addRow(4);
                    htmlTableRow.addCell(Resource.getJspString("jsputil_passive_sensor", string));
                }
                htmlTableRow.addCell(StringUtil.safeHtml((String)sensorArray[n].getSensorName()));
                htmlTableRow.addCell(StringUtil.safeHtml((String)sensorArray[n].getIpAddress()));
                htmlTableRow.addCell(StringUtil.safeHtml((String)sensorArray[n].getMAC()));
                htmlTableRow.addCell(StringUtil.formatDateTime((Timestamp)sensorArray[n].getLastCommunicationTime()));
                ++n;
            }
        }
    }

    protected boolean isDismissed(DatabaseObject databaseObject) {
        return false;
    }
}

