/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.snowcap.util.Resource;

public class NagBean {
    private int m_rogueCount = 0;
    private int m_roguePercent = 0;
    private int m_exceptionCount = 0;
    private int m_exceptionPercent = 0;
    private int m_managedCount = 0;
    private int m_managedPercent = 0;
    private int m_inactiveCount = 0;
    private int m_inactivePercent = 0;
    private int m_coveredSubnetCount = 0;
    private int m_coveredSubnetPercent = 0;
    private int m_uncoveredSubnetCount = 0;
    private int m_uncoveredSubnetPercent = 0;
    private String m_languageId = null;

    public void setLanguageId(String string) {
        this.m_languageId = string;
    }

    public String getLanguageId() {
        return this.m_languageId;
    }

    public int getRogueCount() {
        return this.m_rogueCount;
    }

    public void setRogueCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_rouge_count", this.m_languageId));
        }
        this.m_rogueCount = n;
        this.calcMachinePercentages();
    }

    public int getExceptionCount() {
        return this.m_exceptionCount;
    }

    public void setExceptionCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_exception_count", this.m_languageId));
        }
        this.m_exceptionCount = n;
        this.calcMachinePercentages();
    }

    public int getManagedCount() {
        return this.m_managedCount;
    }

    public void setManagedCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_managed_count", this.m_languageId));
        }
        this.m_managedCount = n;
        this.calcMachinePercentages();
    }

    public int getInactiveCount() {
        return this.m_inactiveCount;
    }

    public void setInactiveCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_inactive_count", this.m_languageId));
        }
        this.m_inactiveCount = n;
        this.calcMachinePercentages();
    }

    public int getCoveredSubnetCount() {
        return this.m_coveredSubnetCount;
    }

    public void setCoveredSubnetCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_covered_count", this.m_languageId));
        }
        this.m_coveredSubnetCount = n;
        this.calcSubnetPercentages();
    }

    public int getUncoveredSubnetCount() {
        return this.m_uncoveredSubnetCount;
    }

    public void setUncoveredSubnetCount(int n) throws Exception {
        if (n < 0) {
            throw new Exception(Resource.getString("nagbean_negative_uncovered_count", this.m_languageId));
        }
        this.m_uncoveredSubnetCount = n;
        this.calcSubnetPercentages();
    }

    public int getRoguePercent() {
        return this.m_roguePercent;
    }

    public int getExceptionPercent() {
        return this.m_exceptionPercent;
    }

    public int getManagedPercent() {
        return this.m_managedPercent;
    }

    public int getInactivePercent() {
        return this.m_inactivePercent;
    }

    public int getTotalMachineCount() {
        return this.m_rogueCount + this.m_exceptionCount + this.m_managedCount + this.m_inactiveCount;
    }

    public int getCoveredSubnetPercent() {
        return this.m_coveredSubnetPercent;
    }

    public int getUncoveredSubnetPercent() {
        return this.m_uncoveredSubnetPercent;
    }

    public int getTotalSubnetCount() {
        return this.m_coveredSubnetCount + this.m_uncoveredSubnetCount;
    }

    private void calcMachinePercentages() {
        int n = this.m_rogueCount + this.m_exceptionCount + this.m_managedCount + this.m_inactiveCount;
        this.m_roguePercent = n != 0 ? this.m_rogueCount * 100 / n : 0;
        this.m_exceptionPercent = n != 0 ? this.m_exceptionCount * 100 / n : 0;
        this.m_inactivePercent = n != 0 ? this.m_inactiveCount * 100 / n : 0;
        this.m_managedPercent = n != 0 ? this.m_managedCount * 100 / n : 0;
    }

    private void calcSubnetPercentages() {
        int n = this.m_coveredSubnetCount + this.m_uncoveredSubnetCount;
        this.m_coveredSubnetPercent = n != 0 ? this.m_coveredSubnetCount * 100 / n : 0;
        this.m_uncoveredSubnetPercent = n != 0 ? this.m_uncoveredSubnetCount * 100 / n : 0;
    }
}

