/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.util.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MultipartStream {
    public static final int HEADER_PART_SIZE_MAX = 10240;
    protected static final int DEFAULT_BUFSIZE = 4096;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    private InputStream input;
    private int boundaryLength;
    private int keepRegion;
    private byte[] boundary;
    private int bufSize;
    private byte[] buffer;
    private int head;
    private int tail;
    private String headerEncoding;

    public MultipartStream() {
    }

    public MultipartStream(InputStream inputStream, byte[] byArray, int n) {
        this.input = inputStream;
        this.bufSize = n;
        this.buffer = new byte[n];
        this.boundary = new byte[byArray.length + 4];
        this.boundaryLength = byArray.length + 4;
        this.keepRegion = byArray.length + 3;
        this.boundary[0] = 13;
        this.boundary[1] = 10;
        this.boundary[2] = 45;
        this.boundary[3] = 45;
        System.arraycopy(byArray, 0, this.boundary, 4, byArray.length);
        this.head = 0;
        this.tail = 0;
    }

    public MultipartStream(InputStream inputStream, byte[] byArray) throws IOException {
        this(inputStream, byArray, 4096);
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String string) {
        this.headerEncoding = string;
    }

    public byte readByte() throws IOException {
        if (this.head == this.tail) {
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
        }
        return this.buffer[this.head++];
    }

    public boolean readBoundary() throws MalformedStreamException {
        boolean bl;
        block4: {
            byte[] byArray = new byte[2];
            bl = false;
            this.head += this.boundaryLength;
            try {
                byArray[0] = this.readByte();
                byArray[1] = this.readByte();
                if (MultipartStream.arrayequals(byArray, STREAM_TERMINATOR, 2)) {
                    bl = false;
                    break block4;
                }
                if (MultipartStream.arrayequals(byArray, FIELD_SEPARATOR, 2)) {
                    bl = true;
                    break block4;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
        }
        return bl;
    }

    public void setBoundary(byte[] byArray) throws IllegalBoundaryException {
        if (byArray.length != this.boundaryLength - 4) {
            throw new IllegalBoundaryException("The length of a boundary token can not be changed");
        }
        System.arraycopy(byArray, 0, this.boundary, 4, byArray.length);
    }

    public String readHeaders() throws MalformedStreamException {
        int n = 0;
        byte[] byArray = new byte[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 10240;
        int n3 = 0;
        while (n < 4) {
            try {
                byArray[0] = this.readByte();
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
            n = byArray[0] == HEADER_SEPARATOR[n] ? ++n : 0;
            if (++n3 > n2) continue;
            byteArrayOutputStream.write(byArray[0]);
        }
        String string = null;
        if (this.headerEncoding != null) {
            try {
                string = byteArrayOutputStream.toString(this.headerEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = byteArrayOutputStream.toString();
            }
        } else {
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    public int readBodyData(OutputStream outputStream) throws MalformedStreamException, IOException {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            int n2 = this.findSeparator();
            if (n2 != -1) {
                outputStream.write(this.buffer, this.head, n2 - this.head);
                n += n2 - this.head;
                this.head = n2;
                bl = true;
                continue;
            }
            int n3 = this.tail - this.head > this.keepRegion ? this.keepRegion : this.tail - this.head;
            outputStream.write(this.buffer, this.head, this.tail - this.head - n3);
            n += this.tail - this.head - n3;
            System.arraycopy(this.buffer, this.tail - n3, this.buffer, 0, n3);
            this.head = 0;
            int n4 = this.input.read(this.buffer, n3, this.bufSize - n3);
            if (n4 != -1) {
                this.tail = n3 + n4;
                continue;
            }
            outputStream.write(this.buffer, 0, n3);
            outputStream.flush();
            n += n3;
            throw new MalformedStreamException("Stream ended unexpectedly");
        }
        outputStream.flush();
        return n;
    }

    public int discardBodyData() throws MalformedStreamException, IOException {
        boolean bl = false;
        int n = 0;
        while (!bl) {
            int n2 = this.findSeparator();
            if (n2 != -1) {
                n += n2 - this.head;
                this.head = n2;
                bl = true;
                continue;
            }
            int n3 = this.tail - this.head > this.keepRegion ? this.keepRegion : this.tail - this.head;
            n += this.tail - this.head - n3;
            System.arraycopy(this.buffer, this.tail - n3, this.buffer, 0, n3);
            this.head = 0;
            int n4 = this.input.read(this.buffer, n3, this.bufSize - n3);
            if (n4 != -1) {
                this.tail = n3 + n4;
                continue;
            }
            n += n3;
            throw new MalformedStreamException("Stream ended unexpectedly");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MalformedStreamException malformedStreamException) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
        }
    }

    public static boolean arrayequals(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected int findByte(byte by, int n) {
        int n2 = n;
        while (n2 < this.tail) {
            if (this.buffer[n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected int findSeparator() {
        int n = 0;
        int n2 = this.tail - this.boundaryLength;
        int n3 = this.head;
        while (n3 <= n2 && n != this.boundaryLength) {
            if ((n3 = this.findByte(this.boundary[0], n3)) == -1 || n3 > n2) {
                return -1;
            }
            n = 1;
            while (n < this.boundaryLength) {
                if (this.buffer[n3 + n] != this.boundary[n]) break;
                ++n;
            }
            ++n3;
        }
        if (n == this.boundaryLength) {
            return n3 - 1;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("boundary='");
        stringBuffer.append(String.valueOf(this.boundary));
        stringBuffer.append("'\nbufSize=");
        stringBuffer.append(this.bufSize);
        return stringBuffer.toString();
    }

    public class IllegalBoundaryException
    extends IOException {
        public IllegalBoundaryException() {
        }

        public IllegalBoundaryException(String string) {
            super(string);
        }
    }

    public class MalformedStreamException
    extends IOException {
        public MalformedStreamException() {
        }

        public MalformedStreamException(String string) {
            super(string);
        }
    }
}

