/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.client;

import com.nai.mcafee.snowcap.client.CmdLineUtil;
import com.nai.mcafee.snowcap.client.MessageUtil;
import com.nai.mcafee.snowcap.message.TestData;
import com.nai.mcafee.snowcap.util.Timer;
import com.nai.mcafee.snowcap.util.thread.TestThread;
import com.nai.mcafee.snowcap.util.thread.TestThreadGroup;
import java.net.URL;
import java.util.Random;

public class StressClient {
    private int m_numThreads;
    private URL m_serverURL;
    private int m_numEvents;
    private int m_timeout;
    private int m_hostsPerMessage;
    private int m_sensorsPerNetwork;

    public static void main(String[] stringArray) throws Exception {
        StressClient stressClient = new StressClient();
        stressClient.init(stringArray);
        stressClient.run();
    }

    public void run() throws Exception {
        System.out.println("Creating " + this.m_numEvents * this.m_numThreads + " test messages...");
        TestThread[] testThreadArray = new TestThread[this.m_numThreads];
        int n = 0;
        while (n < testThreadArray.length) {
            testThreadArray[n] = new StressThread();
            ++n;
        }
        System.out.println("Spawning " + this.m_numThreads + " threads...");
        TestThreadGroup testThreadGroup = new TestThreadGroup(testThreadArray, "StressThread");
        testThreadGroup.start();
        this.waitForTimeout();
        testThreadGroup.requestStop();
        testThreadGroup.join();
        System.out.println("Done.");
    }

    private void waitForTimeout() throws Exception {
        if (this.m_timeout == -1) {
            System.out.println("Running indefinitely; ctrl-c to exit test.");
            while (true) {
                Thread.sleep(10000L);
            }
        }
        System.out.println("Running the test for " + this.m_timeout + " seconds.");
        int n = this.m_timeout * 1000;
        Timer timer = new Timer();
        timer.start();
        while (timer.elapsed() < (long)n) {
            Thread.sleep(1000L);
        }
    }

    private static void showUsageAndExit() {
        System.out.println("Usage: StressClient num-threads [server-url] [num-events] [sensors-per-network] [hosts-per-msg] [timeout] [keystore] [password]");
        System.out.println("where:");
        System.out.println("  num-threads   : number of event-sending threads to spawn");
        System.out.println("  server-url    : server URL to post messages to");
        System.out.println("  num-events    : number of unique events for each thread to send to the server");
        System.out.println("  sensors-per-network : each thread simulates a different network; this specifies how many sensors should be in each network.");
        System.out.println("  hosts-per-msg : number of detected hosts in each message");
        System.out.println("  timeout       : length of time to run the test, in seconds; -1 for infinite");
        System.out.println("  keystore      : keystore to use with SSL. If omitted, SSL won't work. No need to specify if not using SSL.");
        System.out.println("  password      : keystore password");
        System.exit(-1);
    }

    public void init(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            StressClient.showUsageAndExit();
        }
        this.m_numThreads = CmdLineUtil.getArg(stringArray, 0, 8);
        this.m_serverURL = new URL(CmdLineUtil.getArg(stringArray, 1, "http://localhost:8080/snowcap/engine"));
        this.m_numEvents = CmdLineUtil.getArg(stringArray, 2, 1000);
        this.m_sensorsPerNetwork = CmdLineUtil.getArg(stringArray, 3, 1);
        this.m_hostsPerMessage = CmdLineUtil.getArg(stringArray, 4, 1);
        this.m_timeout = CmdLineUtil.getArg(stringArray, 5, -1);
        String string = CmdLineUtil.getArg(stringArray, 6, null);
        String string2 = CmdLineUtil.getArg(stringArray, 7, "");
        if (string != null) {
            MessageUtil.initSSL(string, string2);
        }
    }

    public class StressThread
    extends TestThread {
        private String[] m_messages = null;
        private Random m_rand = new Random(System.currentTimeMillis());

        public StressThread() throws Exception {
            this.m_messages = TestData.createTestMessages(StressClient.this.m_numEvents, StressClient.this.m_hostsPerMessage, StressClient.this.m_sensorsPerNetwork, 1, 1);
        }

        public boolean doTask() throws Exception {
            int n = this.m_rand.nextInt(this.m_messages.length);
            MessageUtil.sendEvent(this.m_messages[n], StressClient.this.m_serverURL);
            return true;
        }
    }
}

