/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.HostStatus;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Parameterizer.ParamPropertyException;
import com.nai.mcafee.snowcap.db.Parameterizer.Parameterizer;
import com.nai.mcafee.snowcap.db.RogueTypes;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.server.ActionEnvironmentImpl;
import com.nai.mcafee.snowcap.util.Resource;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class HNSParameterizer
implements Parameterizer {
    public static final String[] PROPERTY_NAMES;
    public static final int[] PROPERTY_TYPES;
    public static final String TABLE_NAME_HOST = "Host";
    public static final String TABLE_NAME_SUBNET = "Subnet";
    public static final String TABLE_NAME_SENSOR = "Sensor";
    public static final int NUM_PROPERTIES;
    public static final int FIRST_NETWORK_PROPS_INDEX = 19;
    public static final int FIRST_SENSOR_PROPS_INDEX;
    private Network m_network = null;
    private Sensor m_sensor = null;
    private Host m_host = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$HNSParameterizer;

    public HNSParameterizer() {
    }

    public HNSParameterizer(Host host, Network network, Sensor sensor) {
        this.setNetwork(network);
        this.setSensor(sensor);
        this.setHost(host);
    }

    public boolean isTableProperty(int n, String string) throws ParamPropertyException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.validateIndex(n);
        if (n < 19 && string.compareTo(TABLE_NAME_HOST) == 0) {
            return true;
        }
        return n >= 19 && n < FIRST_SENSOR_PROPS_INDEX && string.compareTo(TABLE_NAME_SUBNET) == 0;
    }

    public boolean useInConditions(int n) throws ParamPropertyException {
        this.validateIndex(n);
        return !PROPERTY_NAMES[n].equals("AddressAndMask");
    }

    public boolean useInSubstitutions(int n) throws ParamPropertyException {
        this.validateIndex(n);
        return true;
    }

    public int getNumParamProperties() {
        return NUM_PROPERTIES;
    }

    public Object getParamProperty(int n) throws ParamPropertyException {
        this.validateIndex(n);
        try {
            if (n < 19) {
                return this.m_host.getProperty(PROPERTY_NAMES[n]);
            }
            if (n < FIRST_SENSOR_PROPS_INDEX) {
                return this.m_network.getProperty(PROPERTY_NAMES[n]);
            }
            return this.m_sensor.getProperty(PROPERTY_NAMES[n]);
        }
        catch (Exception exception) {
            throw new ParamPropertyException("Error accessing property (" + n + ")", exception);
        }
    }

    public String getParamPropertyDisplayName(int n, String string) throws ParamPropertyException {
        this.validateIndex(n);
        try {
            if (n < 19) {
                return Resource.getString("hostpropdisplay_" + PROPERTY_NAMES[n], string);
            }
            if (n < FIRST_SENSOR_PROPS_INDEX) {
                return Resource.getString("networkpropdisplay_" + PROPERTY_NAMES[n], string);
            }
            return Resource.getString("sensorpropdisplay_" + PROPERTY_NAMES[n], string);
        }
        catch (Exception exception) {
            throw new ParamPropertyException("Error accessing property (" + n + ")", exception);
        }
    }

    public String[] getPossibleEnumValues(int n, String string) throws ParamPropertyException {
        this.validateIndex(n);
        if (PROPERTY_NAMES[n] == "RogueType") {
            return RogueTypes.getDisplayNames(string);
        }
        if (PROPERTY_NAMES[n] == "HostStatus") {
            return HostStatus.getDisplayNames(string);
        }
        if (PROPERTY_NAMES[n] == "MarkedForAction") {
            return new String[]{Resource.getString("marked_for_action_false", string), Resource.getString("marked_for_action_true", string)};
        }
        throw new ParamPropertyException("getPossibleEnumValues called for non-enum value: " + n);
    }

    public int getParamPropertyIndex(String string) throws ParamPropertyException {
        string = string.intern();
        int n = 0;
        while (n < PROPERTY_NAMES.length) {
            if (PROPERTY_NAMES[n] == string) {
                return n;
            }
            ++n;
        }
        throw new ParamPropertyException("Invalid property name: " + string);
    }

    public Object getParamProperty(String string) throws ParamPropertyException {
        Object object = null;
        try {
            object = this.getParamProperty(this.getParamPropertyIndex(string));
        }
        catch (ParamPropertyException paramPropertyException) {
            try {
                Class<?> clazz = this.getClass();
                String string2 = "get" + string;
                Method method = clazz.getMethod(string2, null);
                object = method.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw paramPropertyException;
            }
        }
        return object;
    }

    public String getParamPropertyName(int n) throws ParamPropertyException {
        this.validateIndex(n);
        return PROPERTY_NAMES[n];
    }

    public int getParamPropertyType(int n) throws ParamPropertyException {
        this.validateIndex(n);
        return PROPERTY_TYPES[n];
    }

    public StringUtil.Map getMap() {
        return new StringUtil.Map(){

            public String get(String string) {
                try {
                    int n = HNSParameterizer.this.getParamPropertyIndex(string);
                    Object object = HNSParameterizer.this.getParamProperty(n);
                    string = string.intern();
                    if (string == "HostStatus") {
                        return HostStatus.asString((Integer)object, null);
                    }
                    if (string == "RogueType") {
                        return RogueTypes.asString((Integer)object, null);
                    }
                    if (object instanceof Timestamp) {
                        return StringUtil.formatDateTime((Timestamp)((Timestamp)object));
                    }
                    if (HNSParameterizer.this.getParamPropertyType(n) == 4) {
                        return StringUtil.formatMAC((String)((String)object));
                    }
                    return object.toString();
                }
                catch (Exception exception) {
                    return "";
                }
            }
        };
    }

    public void setNetwork(Network network) {
        this.m_network = network;
    }

    public Network getNetwork() {
        return this.m_network;
    }

    public void setSensor(Sensor sensor) {
        this.m_sensor = sensor;
    }

    public Sensor getSensor() {
        return this.m_sensor;
    }

    private long getMachTimeout() {
        Configuration configuration;
        ActionEnvironment actionEnvironment = ActionEnvironmentImpl.instance();
        long l = actionEnvironment == null ? 0L : ((configuration = actionEnvironment.getConfiguration()) == null ? 0L : configuration.getMachineWindow());
        return l;
    }

    public void setHost(Host host) {
        this.m_host = host;
        if (host != null) {
            this.m_host.calculateProperties(System.currentTimeMillis(), this.getMachTimeout());
        }
    }

    public Host getHost() {
        return this.m_host;
    }

    private final void validateIndex(int n) throws ParamPropertyException {
        if (n < 0 || n >= NUM_PROPERTIES) {
            throw new ParamPropertyException("Invalid property index (" + n + ")");
        }
    }

    public void loadParamMap(Connection connection, Integer n, Integer n2, Integer n3) throws SQLException {
        if (connection != null) {
            if (n != null && n != -1) {
                this.setHost(Host.getByID(connection, n));
            }
            if (n2 != null && n2 != -1) {
                this.setNetwork(Network.getByID(connection, n2));
            }
            if (n3 != null && n3 != -1) {
                this.setSensor(Sensor.getByID(connection, n3));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$db$HNSParameterizer == null ? (class$com$nai$mcafee$snowcap$db$HNSParameterizer = HNSParameterizer.class$("com.nai.mcafee.snowcap.db.HNSParameterizer")) : class$com$nai$mcafee$snowcap$db$HNSParameterizer).desiredAssertionStatus();
        PROPERTY_NAMES = new String[]{"MAC", "IpAddress", "NetbiosName", "DnsName", "LastDetectTime", "Comments", "OSPlatform", "OSFamily", "OSVersion", "NetbiosComment", "FirstDetectTime", "Users", "Domain", "FirstRogueTime", "RogueType", "FriendlyName", "OrgName", "HostStatus", "MarkedForAction", "NetworkName", "NetworkAddress", "AddressAndMask"};
        PROPERTY_TYPES = new int[]{4, 3, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 2, 0, 0, 2, 2, 0, 3, 0};
        FIRST_SENSOR_PROPS_INDEX = NUM_PROPERTIES = PROPERTY_NAMES.length;
    }
}

