/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.condition.SerializationException;
import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpException;
import com.nai.mcafee.common.condition.SexpLong;
import com.nai.mcafee.common.condition.SexpProp;
import com.nai.mcafee.common.condition.SexpSerializer;
import com.nai.mcafee.common.condition.SexpString;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.IPUtil;
import com.nai.mcafee.snowcap.db.Host;
import java.sql.Timestamp;

public class SexpQueryUtil {
    public static final String QUERY_PREFIX = "select * from Hosts  left join OUIs on Hosts.OUI = OUIs.OUI  left join Networks on Hosts.NetworkID=Networks.NetworkID where ";

    public static final String makeWhereSnippet(String string, long l, long l2) throws SexpException {
        if (string == null || string.length() == 0) {
            return "";
        }
        Sexp sexp = null;
        try {
            sexp = SexpSerializer.read((String)string);
        }
        catch (SerializationException serializationException) {
            throw new SexpException("Error parsing expression:" + string);
        }
        return SexpQueryUtil.makeWhereSnippet(sexp, l, l2);
    }

    public static final String makeWhereSnippet(Sexp sexp, long l, long l2) throws SexpException {
        if (sexp == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        SexpQueryUtil.makeWhereSnippet(sexp, stringBuffer, l, l2);
        return stringBuffer.toString();
    }

    private static final void makeWhereSnippet(Sexp sexp, StringBuffer stringBuffer, long l, long l2) throws SexpException {
        String string = sexp.type();
        if ((string == "and" || string == "or") && sexp.numChildren() == 2 && sexp.childAt(1).type() == "bool") {
            SexpQueryUtil.makeWhereSnippet(sexp.childAt(0), stringBuffer, l, l2);
            return;
        }
        stringBuffer.append("( ");
        if (string == "and") {
            SexpQueryUtil.makeMultiTermSql("and", sexp, stringBuffer, l, l2);
        } else if (string == "or") {
            SexpQueryUtil.makeMultiTermSql("or", sexp, stringBuffer, l, l2);
        } else if (string == "startsWith" || string == "endsWith" || string == "contains") {
            SexpQueryUtil.makeTwoTermSql("like", sexp, stringBuffer, l, l2);
        } else if (string == "doesntContain") {
            stringBuffer.append(" not ");
            SexpQueryUtil.makeTwoTermSql("like", sexp, stringBuffer, l, l2);
        } else if (string == "olderThan") {
            SexpQueryUtil.makeTwoTermSql("<", sexp, stringBuffer, l, l2);
        } else if (string == "newerThan") {
            SexpQueryUtil.makeTwoTermSql(">=", sexp, stringBuffer, l, l2);
        } else if (string == "eq") {
            SexpQueryUtil.makeTwoTermSql("=", sexp, stringBuffer, l, l2);
        } else if (string == "ne") {
            SexpQueryUtil.makeTwoTermSql("!=", sexp, stringBuffer, l, l2);
        } else if (string == "ipInRange" || string == "ipNotInRange") {
            SexpQueryUtil.makeThreeTermSql(sexp, stringBuffer);
        } else {
            throw new SexpException("Unable to make SQL for type:" + string);
        }
        stringBuffer.append(" ) ");
    }

    private static final void makeMultiTermSql(String string, Sexp sexp, StringBuffer stringBuffer, long l, long l2) throws SexpException {
        int n = 0;
        while (n < sexp.numChildren()) {
            if (n != 0) {
                stringBuffer.append(" ").append(string).append(" ");
            }
            SexpQueryUtil.makeWhereSnippet(sexp.childAt(n), stringBuffer, l, l2);
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void makeThreeTermSql(Sexp sexp, StringBuffer stringBuffer) throws SexpException {
        if (sexp.numChildren() != 3) {
            throw new SexpException("Invalid expression: Operation: " + sexp.type() + " didn't have two children!");
        }
        if (sexp.childAt(0).type() != "prop") {
            throw new SexpException("Invalid expression: lhs of " + sexp.type() + " not of type PROP.");
        }
        if (sexp.childAt(1).type() != "string" || sexp.childAt(2).type() != "string") {
            throw new SexpException("Invalid expression: rhs of " + sexp.type() + " not of type String.");
        }
        if (sexp.type() != "ipInRange" && sexp.type() != "ipNotInRange") throw new SexpException("Unknown three-term expresion: " + sexp.type());
        boolean bl = sexp.type() == "ipNotInRange";
        try {
            String string = ((SexpProp)sexp.childAt(0)).getPropName() + "Num";
            int n = IPUtil.convert((String)((SexpString)sexp.childAt(1)).getValue());
            int n2 = IPUtil.convert((String)((SexpString)sexp.childAt(2)).getValue());
            if (bl) {
                stringBuffer.append(" not ( ");
            }
            stringBuffer.append("( ").append(string).append(" >= ").append(n).append(" ) and ( ").append(string).append(" <= ").append(n2).append(" ) ");
            if (!bl) return;
            stringBuffer.append(" ) ");
            return;
        }
        catch (IPFormatException iPFormatException) {
            throw new SexpException("Invalid IP address format", (Throwable)iPFormatException);
        }
    }

    private static final void makeTwoTermSql(String string, Sexp sexp, StringBuffer stringBuffer, long l, long l2) throws SexpException {
        if (sexp.numChildren() != 2) {
            throw new SexpException("Invalid expression: Operation: " + sexp.type() + " didn't have two children!");
        }
        if (sexp.childAt(0).type() != "prop") {
            throw new SexpException("Invalid expression: lhs of " + sexp.type() + " not of type PROP.");
        }
        String string2 = ((SexpProp)sexp.childAt(0)).getPropName();
        if (string2.equals(Host.PROPERTY_NAMES[29])) {
            if (sexp.childAt(1).type() != "long") {
                throw new SexpException("Host status can only be compared to an integer, not type:" + sexp.childAt(1).type());
            }
            SexpQueryUtil.makeHostStatusSql(sexp.type(), ((SexpLong)sexp.childAt(1)).getValue(), stringBuffer, l, l2);
        } else {
            stringBuffer.append(string2);
            Sexp sexp2 = sexp.childAt(1);
            if (string2.equals(Host.PROPERTY_NAMES[28]) && sexp2.type() == "string" && ((SexpString)sexp2).getValue().length() == 0) {
                stringBuffer.append(" is null ");
            } else {
                stringBuffer.append(" ").append(string).append(" ").append(SexpQueryUtil.rhsToSql(sexp.type(), sexp2, l));
            }
        }
    }

    private static void makeHostStatusSql(String string, long l, StringBuffer stringBuffer, long l2, long l3) throws SexpException {
        if (string == "ne") {
            stringBuffer.append(" not (");
        }
        Timestamp timestamp = new Timestamp(l2 - l3);
        switch ((int)l) {
            case 3: {
                stringBuffer.append(" Exception = 0 and RogueType = 0 and LastDetectTime > { ts '").append(timestamp).append("'} ");
                break;
            }
            case 2: {
                stringBuffer.append(" Exception = 0 and RogueType != 0 and LastDetectTime > { ts '").append(timestamp).append("'} ");
                break;
            }
            case 1: {
                stringBuffer.append(" Exception = 0 and (LastDetectTime is null or LastDetectTime < { ts '").append(timestamp).append("'}) ");
                break;
            }
            case 0: {
                stringBuffer.append(" Exception = 1 ");
                break;
            }
            default: {
                throw new SexpException("Invalid status type:" + l);
            }
        }
        if (string == "ne") {
            stringBuffer.append(") ");
        }
    }

    private static final String rhsToSql(String string, Sexp sexp, long l) throws SexpException {
        if (string == "olderThan" || string == "newerThan") {
            if (sexp.type() != "long") {
                throw new SexpException("Expected LONG type; got:" + sexp.type());
            }
            Timestamp timestamp = new Timestamp(l - ((SexpLong)sexp).getValue());
            return "'" + timestamp.toString() + "'";
        }
        String string2 = sexp.type();
        if (string2 == "string") {
            String string3 = ((SexpString)sexp).getValue();
            string3 = string3.replaceAll("'", "''");
            if (string == "startsWith") {
                return "'" + SexpQueryUtil.escapeWildcards(string3) + "%'";
            }
            if (string == "endsWith") {
                return "'%" + SexpQueryUtil.escapeWildcards(string3) + "'";
            }
            if (string == "contains" || string == "doesntContain") {
                return "'%" + SexpQueryUtil.escapeWildcards(string3) + "%'";
            }
            return "'" + string3 + "'";
        }
        if (string2 == "long") {
            return "" + ((SexpLong)sexp).getValue();
        }
        throw new SexpException("Invalid rhs type for creating SQL:" + string2);
    }

    private static String escapeWildcards(String string) {
        string = string.replaceAll("([\\[%])", "[$1]");
        return string;
    }
}

