/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.event.concrete;

import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Sensor;

public class HostMap
implements StringUtil.Map {
    public static final String KEY_MAC = "mac";
    public static final String KEY_IP = "ip";
    public static final String KEY_DNS_NAME = "name.dns";
    public static final String KEY_NB_NAME = "name.netbios";
    public static final String KEY_TIME = "detect.time";
    public static final String KEY_OS = "os";
    public static final String KEY_SUBNET_NAME = "subnet.name";
    public static final String KEY_SUBNET_ADDR = "subnet.addr";
    public static final String KEY_SENSOR_NAME = "sensor.name";
    public static final String KEY_SENSOR_ADDR = "sensor.ip";
    private Host m_host;
    private Sensor m_sensor;
    private Network m_network;

    public HostMap(Network network, Sensor sensor, Host host) {
        this.m_host = host;
        this.m_sensor = sensor;
        this.m_network = network;
    }

    public String get(String string) {
        if ((string = string.intern()) == KEY_MAC) {
            return this.m_host.getMAC();
        }
        if (string == KEY_IP) {
            return this.m_host.getNetworkAddr();
        }
        if (string == KEY_DNS_NAME) {
            return this.m_host.getDnsName();
        }
        if (string == KEY_NB_NAME) {
            return this.m_host.getNetbiosName();
        }
        if (string == KEY_TIME) {
            return this.m_host.getLastDetectTime().toString();
        }
        if (string == KEY_OS) {
            return this.m_host.getOSPlatform() + " " + this.m_host.getOSFamily() + " " + this.m_host.getOSVersion();
        }
        if (string == KEY_SUBNET_NAME) {
            return this.m_network.getNetworkName();
        }
        if (string == KEY_SUBNET_ADDR) {
            return this.m_network.getNetworkAddress() + " / " + this.m_network.getSubnetMask();
        }
        if (string == KEY_SENSOR_NAME) {
            return this.m_sensor.getSensorName();
        }
        if (string == KEY_SENSOR_ADDR) {
            return this.m_sensor.getIpAddress();
        }
        return "{" + string + "}";
    }
}

