/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.message;

import com.nai.mcafee.common.util.DateParser;
import com.nai.mcafee.common.util.DateParserException;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.message.MessageParserException;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HostDetectedMessage
extends DefaultHandler {
    Network m_sensorNetworkInfo = new Network();
    Sensor m_sensor = new Sensor();
    private String m_eventType = "";
    private ArrayList m_hosts = new ArrayList();
    private Host m_currentHost = null;
    private StringBuffer m_elementString = new StringBuffer(256);
    private DateParser m_dateParser = new DateParser();
    private static final int ELEMENT_ANALYZER = 0;
    private static final int ELEMENT_SENSOR = 1;
    private static final int ELEMENT_USER = 2;
    private static final int ELEMENT_NODE = 3;
    private static final int ELEMENT_EVENT = 4;
    private static final int ELEMENT_SOURCE = 5;
    private static final int ELEMENT_OS = 6;
    private static final int NUM_ELEMENTS = 7;
    private static final String[] m_elementNames = new String[]{"Analyzer", "Sensor", "User", "Node", "Event", "Source", "OSType"};
    private boolean[] m_inElement = new boolean[]{false, false, false, false, false, false, false};
    public static final String EVENT_CATEGORY_OLD = "AntiVirus.RogueMachine.Detection";
    public static final String EVENT_CATEGORY_HOST_DETECT = "host.detected.broadcast";
    public static final String EVENT_CATEGORY_SENSOR_START = "sensor.startup";
    public static final String EVENT_CATEGORY_SENSOR_STOP = "sensor.shutdown";
    private Pattern m_macPattern = Pattern.compile("[0-9a-f]+");
    private Pattern m_ipPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");

    public Sensor getSensor() {
        return this.m_sensor;
    }

    public Network getNetwork() {
        return this.m_sensorNetworkInfo;
    }

    public void setSensor(Sensor sensor) {
        this.m_sensor = sensor;
    }

    public void setNetwork(Network network) {
        this.m_sensorNetworkInfo = network;
    }

    public int getNumHosts() {
        return this.m_hosts.size();
    }

    public Host getHost(int n) {
        return (Host)((Object)this.m_hosts.get(n));
    }

    public void addHost(Host host) {
        this.m_hosts.add(host);
    }

    public void removeHost(int n) {
        this.m_hosts.remove(n);
    }

    public void removeAllHosts() {
        this.m_hosts.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.getElementName(string2, string3);
        int n = 0;
        while (n < 7) {
            if (string4 == m_elementNames[n]) {
                this.m_inElement[n] = true;
                break;
            }
            ++n;
        }
        this.handleBeginElement(string4);
        this.m_elementString.setLength(0);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.getElementName(string2, string3);
        try {
            this.handleEndElement(string4);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        int n = 0;
        while (n < 7) {
            if (string4 == m_elementNames[n]) {
                this.m_inElement[n] = false;
                break;
            }
            ++n;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.m_elementString.append(cArray, n, n2);
    }

    private String getElementName(String string, String string2) {
        String string3 = string.intern();
        if (string3 == "") {
            string3 = string2.intern();
        }
        return string3;
    }

    private void handleBeginElement(String string) {
        if (string == "Event") {
            this.m_currentHost = new Host();
        }
    }

    private void handleEndElement(String string) throws MessageParserException, DateParserException {
        if (this.m_inElement[0]) {
            if (this.m_inElement[3]) {
                if (this.m_inElement[6]) {
                    if (string == "Platform") {
                        this.m_sensor.setOSPlatform(this.elementData());
                    } else if (string == "Family") {
                        this.m_sensor.setOSFamily(this.elementData());
                    } else if (string == "Version") {
                        this.m_sensor.setOSVersion(this.elementData());
                    }
                } else if (string == "Name") {
                    String string2 = this.elementData();
                    this.m_sensor.setSensorName(string2);
                    this.m_sensorNetworkInfo.setNetworkName(string2);
                } else if (string == "Address") {
                    this.m_sensor.setIpAddress(this.getIpAddr());
                } else if (string == "SubnetMask") {
                    this.m_sensorNetworkInfo.setSubnetMask(this.getIpAddr());
                } else if (string == "MACAddress") {
                    this.m_sensor.setMAC(this.getMac());
                } else if (string == "NetworkAddress") {
                    this.m_sensorNetworkInfo.setNetworkAddress(this.getIpAddr());
                } else if (string == "GroupName") {
                    this.m_sensor.setDomain(this.elementData());
                } else if (string == "UniqueID") {
                    this.m_sensor.setSid(this.getSid());
                } else if (string == "AgentGUID") {
                    this.m_sensor.setAgentGUID(this.getAgentGUID());
                }
            }
        } else if (this.m_inElement[4]) {
            if (this.m_inElement[5]) {
                if (this.m_inElement[3]) {
                    if (this.m_inElement[6]) {
                        if (string == "Platform") {
                            this.m_currentHost.setOSPlatform(this.elementData());
                        } else if (string == "Family") {
                            this.m_currentHost.setOSFamily(this.elementData());
                        } else if (string == "Version") {
                            this.m_currentHost.setOSVersion(this.elementData());
                        }
                    } else if (string == "Name") {
                        this.m_currentHost.setDnsName(this.elementData());
                    } else if (string == "Address") {
                        this.m_currentHost.setNetworkAddr(this.getIpAddr());
                    } else if (string == "NetBIOSName") {
                        this.m_currentHost.setNetbiosName(this.elementData());
                    } else if (string == "MACAddress") {
                        this.m_currentHost.setMAC(this.getMac());
                    } else if (string == "Comment") {
                        this.m_currentHost.setNetbiosComment(this.elementData());
                    } else if (string == "GroupName") {
                        this.m_currentHost.setDomain(this.elementData());
                    } else if (string == "UniqueID") {
                        this.m_currentHost.setSid(this.getSid());
                    }
                } else if (this.m_inElement[2] && string == "Name") {
                    this.m_currentHost.addUser(this.elementData());
                }
            } else if (string == "DetectTime") {
                Timestamp timestamp = this.getTimestamp();
                this.m_currentHost.setFirstDetectTime(timestamp);
                this.m_currentHost.setLastDetectTime(timestamp);
            } else if (string == "EventClassification") {
                this.m_eventType = this.elementData().intern();
                if (this.m_eventType != EVENT_CATEGORY_HOST_DETECT && this.m_eventType != EVENT_CATEGORY_OLD && this.m_eventType != EVENT_CATEGORY_SENSOR_START && this.m_eventType != EVENT_CATEGORY_SENSOR_STOP) {
                    throw new MessageParserException(Resource.formatString("hostdetectedmessage_template_unexpected_event_type", this.m_eventType));
                }
            }
        } else if (string == "CreateTime") {
            this.m_sensor.setLastCommunicationTime(this.getTimestamp());
        }
        if (string == "Event") {
            if (this.m_eventType != EVENT_CATEGORY_SENSOR_START && this.m_eventType != EVENT_CATEGORY_SENSOR_STOP) {
                this.validateCurrentHost();
                this.m_hosts.add(this.m_currentHost);
            }
            this.m_currentHost = null;
        }
    }

    private void validateCurrentHost() throws MessageParserException {
        if (this.m_currentHost.isMacDefault() || this.m_currentHost.getLastDetectTime() == null) {
            throw new MessageParserException(Resource.getString("hostdetectedmessage_missing_field"));
        }
    }

    private final Timestamp getTimestamp() throws DateParserException {
        return new Timestamp(this.m_dateParser.convert(this.elementData()).getTime());
    }

    private final String getMac() throws MessageParserException {
        String string = HostDetectedMessage.stripColons(this.elementData());
        if (string.length() != 12 || !this.m_macPattern.matcher(string).matches()) {
            throw new MessageParserException(Resource.formatString("hostdetectedmessage_template_invalid_mac", string));
        }
        return string;
    }

    private final String getSid() throws MessageParserException {
        String string = this.elementData();
        String string2 = HostDetectedMessage.stripDashes(string);
        if (!this.m_macPattern.matcher(string2).matches()) {
            throw new MessageParserException(Resource.formatString("hostdetectedmessage_template_invalid_sid", string));
        }
        return string2;
    }

    private final String getAgentGUID() throws MessageParserException {
        String string = this.elementData();
        String string2 = HostDetectedMessage.stripCurleyBraces(string);
        if (!EpoDatabase.isValidAgentGUID(string2)) {
            throw new MessageParserException(Resource.formatString("hostdetectedmessage_template_invalid_agent_guid", string2));
        }
        return string2;
    }

    private final String getIpAddr() throws MessageParserException {
        String string = this.elementData();
        if (!this.m_ipPattern.matcher(string).matches()) {
            throw new MessageParserException(Resource.formatString("hostdetectedmessage_template_invalid_ip_address", string));
        }
        return string;
    }

    public static final String stripColons(String string) {
        return string.replaceAll(":", "");
    }

    public static final String stripDashes(String string) {
        return string.replaceAll("-", "");
    }

    public static final String stripCurleyBraces(String string) {
        return string.replaceAll("[{}]", "");
    }

    private final String elementData() {
        return this.m_elementString.toString().trim();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        String string2 = "-----------------------------------------------";
        stringBuffer.append(string).append(string2).append(string);
        stringBuffer.append(Resource.getString("hostdetectedmessage_sensor_info")).append(string);
        stringBuffer.append((Object)this.m_sensor);
        stringBuffer.append((Object)this.m_sensorNetworkInfo);
        stringBuffer.append(string2).append(string);
        stringBuffer.append(Resource.getString("hostdetectedmessage_detected_hosts")).append(string);
        Iterator iterator = this.m_hosts.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string).append(string2).append(string);
            Host host = (Host)((Object)iterator.next());
            stringBuffer.append((Object)host);
        }
        stringBuffer.append(string2).append(string);
        return stringBuffer.toString();
    }
}

