/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.tables.HtmlTable;
import com.nai.mcafee.common.ui.tables.HtmlTableCell;
import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.util.PaginationState;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.QueryUtil;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.EpoHostList;
import com.nai.mcafee.snowcap.ui.util.NetworkPropDisplay;
import com.nai.mcafee.snowcap.ui.util.SessionState;
import com.nai.mcafee.snowcap.ui.util.SubnetInfo;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisplaySensorDeployBean
extends ActionBeanBase {
    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = httpServletRequest.getParameter("sensorDeploySubnetIndex");
        if (string2 != null && string2.length() > 0 && !SessionUtil.isIntegerGT((String)string2, (int)0)) {
            String string3 = Resource.getString("displaydeploysensorsbean_no_subnets_selected", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)string3, (String)"displaysensordeploy.do");
            return "actiontaken.jsp";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        EpoHostList epoHostList = SessionState.getEpoHostList(httpServletRequest);
        epoHostList.addToStore(httpServletRequest);
        NetworkPropDisplay networkPropDisplay = new NetworkPropDisplay(string);
        String string2 = httpServletRequest.getParameter("sensorDeploySubnetIndex");
        int n = epoHostList.getIndex();
        if (string2 != null && string2.length() > 0) {
            n = Integer.parseInt(string2);
            epoHostList.setIndex(n);
        }
        Connection connection = null;
        Configuration configuration = Server.getConfiguration();
        long l = configuration.getSensorWindow();
        long l2 = System.currentTimeMillis();
        String string3 = "disabled";
        HtmlTable htmlTable = null;
        HtmlTableHeader htmlTableHeader = null;
        htmlTable = new HtmlTable();
        htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.addCell(networkPropDisplay.getFullHeader(10));
        htmlTableHeader.addCell(networkPropDisplay.getFullHeader(2));
        htmlTableHeader.addCell(networkPropDisplay.getFullHeader(7));
        htmlTableHeader.addCell(Resource.getString("displaysensordeploy_selected_machines", string));
        try {
            connection = Server.getDb().getConnection();
            object = new PaginationState(1, 1, configuration.getPageCount(), null);
            object.getPagMgr().setIndex(n);
            htmlTable.setPaginationMgr(object.getPagMgr());
            EpoHostList epoHostList2 = SessionState.getEpoHostList(httpServletRequest);
            object.getPagMgr().setListCount(epoHostList2.size());
            int n2 = n + configuration.getPageCount() - 1;
            if (n2 > epoHostList2.size()) {
                n2 = epoHostList2.size();
            }
            int n3 = n - 1;
            while (n3 < n2) {
                this.addRow(htmlTable, connection, epoHostList2.getAt(n3), n3, l2, l, networkPropDisplay);
                if (epoHostList2.getAt(n3).size() > 0) {
                    string3 = "";
                }
                ++n3;
            }
            object.getPagMgr().computePagination();
            Object var22_19 = null;
        }
        catch (Throwable throwable) {
            Object var22_20 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        object = configuration.getPerformWakeup() == 1 ? "checked" : "";
        httpServletRequest.setAttribute("performAgentWakeup", object);
        httpServletRequest.setAttribute("sensorInstallDir", (Object)configuration.getSensorInstallDir());
        httpServletRequest.setAttribute("pushRandomization", (Object)Integer.toString(configuration.getPushRandomization()));
        httpServletRequest.setAttribute("sensorDeployInfo", (Object)htmlTable.getHtml(string));
        httpServletRequest.setAttribute("deployEnabled", (Object)string3);
        httpServletRequest.setAttribute("sensorDeploySubnetIndex", (Object)Integer.toString(n));
        return "sensordeploy.jsp";
    }

    private void addRow(HtmlTable htmlTable, Connection connection, SubnetInfo subnetInfo, int n, long l, long l2, NetworkPropDisplay networkPropDisplay) throws Exception {
        if (subnetInfo == null) {
            throw new InvalidParameterException("DisplaySensorDeployBean.addRow() - got null SubnetInfo");
        }
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        htmlTableRow = subnetInfo.size() > 0 ? htmlTable.addRow(4) : htmlTable.addRow(3);
        Network[] networkArray = Network.getByQuery(connection, QueryUtil.makeSubnetQuery("where  NetworkAddress = '" + subnetInfo.m_networkAddress + "' and SubnetMask = '" + subnetInfo.m_subnetMask + "'", 1, 1));
        if (networkArray.length != 1) {
            throw new SQLException("Internal error: getNetworkBySubnetAndMask() didn't return one row!");
        }
        Network network = networkArray[0];
        network.calculateProperties(l, l2, false);
        networkPropDisplay.setDbo(network);
        String string = "showSubnetDetails(\"" + n + "\")";
        htmlTableCell = htmlTableRow.addCell(networkPropDisplay.getTruncatedProperty(10));
        htmlTableCell.setOnClick(string);
        htmlTableCell = htmlTableRow.addCell(networkPropDisplay.getTruncatedProperty(2));
        htmlTableCell.setOnClick(string);
        htmlTableCell = htmlTableRow.addCell(networkPropDisplay.getTruncatedProperty(7));
        htmlTableCell.setOnClick(string);
        htmlTableCell = htmlTableRow.addCell(StringUtil.safeHtml((String)subnetInfo.getHostnames()));
        htmlTableCell.setOnClick(string);
    }
}

