/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.tables.HtmlTable;
import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.util.PaginationState;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.db.epo.EpoHost;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.EpoHostList;
import com.nai.mcafee.snowcap.ui.util.SessionState;
import com.nai.mcafee.snowcap.ui.util.SubnetInfo;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisplaySensorDeployDetailsBean
extends ActionBeanBase {
    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("sensorDeploySubnetDetailsIndex");
        if (string != null && string.length() > 0 && !SessionUtil.isIntegerGT((String)string, (int)-1)) {
            throw new InvalidParameterException("Error: DisplaySensorDeployDetailsBean - Misisng or invalid subnet index.");
        }
        String string2 = httpServletRequest.getParameter("sensorDeployHostIndex");
        if (string2 != null && string2.length() > 0 && !SessionUtil.isIntegerGT((String)string2, (int)0)) {
            throw new InvalidParameterException("Error: DisplaySensorDeployDetailsBean - Missing or invalid host index.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        int n = Integer.parseInt(httpServletRequest.getParameter("sensorDeploySubnetDetailsIndex"));
        String string2 = httpServletRequest.getParameter("sensorDeployHostIndex");
        int n2 = 1;
        if (string2 != null && string2.length() > 0) {
            n2 = Integer.parseInt(string2);
        }
        EpoHostList epoHostList = SessionState.getEpoHostList(httpServletRequest);
        SubnetInfo subnetInfo = epoHostList.getAt(n);
        Configuration configuration = Server.getConfiguration();
        epoHostList.updateIndex(n + 1, configuration.getPageCount());
        PaginationState paginationState = new PaginationState(1, 1, configuration.getPageCount(), null);
        paginationState.getPagMgr().setIndex(n2);
        StringBuffer stringBuffer = new StringBuffer(1024);
        HtmlTable htmlTable = null;
        HtmlTableHeader htmlTableHeader = null;
        HtmlTableRow htmlTableRow = null;
        this.buildPrevNextHeader(stringBuffer, n, epoHostList.size(), string);
        stringBuffer.append("<br>");
        htmlTable = new HtmlTable();
        htmlTable.setHasCheckbox(true);
        htmlTable.setPaginationMgr(paginationState.getPagMgr());
        htmlTableHeader = htmlTable.getHeader();
        htmlTableHeader.setCheckboxId("checkboxToggle");
        htmlTableHeader.addCell(Resource.getJspString("jsputil_status", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_hostname", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_ip_address", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_type", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_os", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_cpu", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_ram", string));
        htmlTableHeader.addCell(Resource.getJspString("jsputil_last_detect", string));
        Connection connection = null;
        try {
            connection = Server.getEpoDb().getConnection();
            EpoHost[] epoHostArray = EpoHost.getBySubnet(connection, subnetInfo.m_networkAddress, subnetInfo.m_subnetMask);
            connection.commit();
            boolean bl = false;
            paginationState.getPagMgr().setListCount(epoHostArray.length);
            int n3 = n2 + configuration.getPageCount() - 1;
            if (n3 > epoHostArray.length) {
                n3 = epoHostArray.length;
            }
            int n4 = n2 - 1;
            while (n4 < n3) {
                if (subnetInfo.containsHost(epoHostArray[n4].getLeafNodeID())) {
                    htmlTableRow = htmlTable.addRow(7);
                    bl = true;
                } else {
                    htmlTableRow = htmlTable.addRow(4);
                    bl = false;
                }
                htmlTableRow.setCheckboxId("machineId" + epoHostArray[n4].getLeafNodeID() + ":" + epoHostArray[n4].getHostname());
                if (bl) {
                    htmlTableRow.addCell(Resource.getJspString("jsputil_deploy_sensor", string));
                } else {
                    htmlTableRow.addCell("&nbsp;");
                }
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getHostname()));
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getIpAddress()));
                if (this.isServerClass(epoHostArray[n4].getOsPlatform())) {
                    htmlTableRow.addCell(Resource.getJspString("jsputil_server", string));
                } else {
                    htmlTableRow.addCell(Resource.getJspString("jsputil_workstation", string));
                }
                htmlTableRow.addCell(StringUtil.safeHtml((String)epoHostArray[n4].getOs()));
                htmlTableRow.addCell(String.valueOf(epoHostArray[n4].getCpuSpeed()));
                htmlTableRow.addCell(String.valueOf(epoHostArray[n4].getMemory()));
                htmlTableRow.addCell(StringUtil.formatDateTime((Timestamp)new Timestamp(EpoDatabase.parseAgentTime(epoHostArray[n4].getLastUpdate()))));
                ++n4;
            }
            paginationState.getPagMgr().computePagination();
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        stringBuffer.append(htmlTable.getHtml(string));
        httpServletRequest.setAttribute("sensorDeployDetails", (Object)stringBuffer.toString());
        httpServletRequest.setAttribute("sensorDeploySubnetDetailsIndex", (Object)Integer.toString(n));
        httpServletRequest.setAttribute("sensorDeployHostIndex", (Object)Integer.toString(n2));
        return "sensordeploydetails.jsp";
    }

    private void buildPrevNextHeader(StringBuffer stringBuffer, int n, int n2, String string) {
        stringBuffer.append("<table cellspacing=3 cellpadding=3 border=0 class='Toolbar' width='100%'>\n").append("<tr valign=center><td>");
        this.addControl(stringBuffer, Resource.getJspString("jsputil_previous_subnet", string), n - 1, true, n > 0);
        stringBuffer.append(" <img src='images/px_trans.gif' height=1 width=9 border=0> \n");
        this.addControl(stringBuffer, Resource.getJspString("jsputil_next_subnet", string), n + 1, false, n < n2 - 1);
        stringBuffer.append("</td></tr></table>\n");
    }

    private void addControl(StringBuffer stringBuffer, String string, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        stringBuffer2.append("images/");
        if (bl) {
            stringBuffer2.append("ViewPrevious");
        } else {
            stringBuffer2.append("ViewNext");
        }
        if (!bl2) {
            stringBuffer2.append("Disabled");
        }
        stringBuffer2.append(".gif");
        if (bl2) {
            stringBuffer.append("<a href='Javascript:displayAnother( ").append(n).append(")'><img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append(string).append("</a>");
        } else {
            stringBuffer.append("<img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append("<span style='color:").append("#AAAAAA").append("'>").append(string).append("</span>");
        }
        stringBuffer.append("\n");
    }

    private boolean isServerClass(String string) {
        Pattern pattern = Pattern.compile("Server");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }
}

