/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.tables.HtmlTable;
import com.nai.mcafee.common.ui.tables.HtmlTableCell;
import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.util.PaginationMgr;
import com.nai.mcafee.common.ui.util.PaginationState;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.common.ui.util.UIPropStack;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.QueryUtil;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.NetworkPropDisplay;
import com.nai.mcafee.snowcap.ui.util.SessionState;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisplaySubnetsBean
extends ActionBeanBase {
    public static final String ACTION_STRING = "displaysubnets.do";
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$Network;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("index");
        if (string != null && string.length() > 0 && !SessionUtil.isIntegerGT((String)string, (int)-1)) {
            throw new InvalidParameterException("Negative value for optional index.");
        }
        String string2 = httpServletRequest.getParameter("statusFlags");
        if (!(string2 == null || string2.length() <= 0 || SessionUtil.isIntegerLE((String)string2, (int)4) && SessionUtil.isIntegerGT((String)string2, (int)0))) {
            throw new InvalidParameterException("Illegal value for optional view status flags.");
        }
        String string3 = httpServletRequest.getParameter("sortOrder");
        if (!(string3 == null || string3.length() <= 0 || SessionUtil.isIntegerLE((String)string3, (int)2) && SessionUtil.isIntegerGT((String)string3, (int)0))) {
            throw new InvalidParameterException("Illegal value for optional sort order.");
        }
        String string4 = httpServletRequest.getParameter("sortColumn");
        if (!(string4 == null || string4.length() <= 0 || SessionUtil.isIntegerLE((String)string4, (int)10) && SessionUtil.isIntegerGT((String)string4, (int)-1))) {
            throw new InvalidParameterException("Error: DisplaySubnetsBean - Illegal value for SessionUtil.PARAM_SORT_COLUMN found.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        Connection connection = null;
        PaginationState paginationState = null;
        String string2 = "";
        HtmlTable htmlTable = null;
        HtmlTableHeader htmlTableHeader = null;
        Configuration configuration = Server.getConfiguration();
        String[] stringArray = configuration.getSubnetListCols().split(":");
        NetworkPropDisplay networkPropDisplay = new NetworkPropDisplay(string);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        connection = Server.getDb().getConnection();
        SessionUtil.setAutoRefreshParams((HttpServletRequest)httpServletRequest, (long)configuration.getAutoRefreshPeriod(), (int)configuration.getAutoRefreshActivated());
        try {
            int n = 0;
            while (n < stringArray.length) {
                Integer.parseInt(stringArray[n]);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setSubnetListCols(configuration.getSLColsDefault());
            configuration.update(connection);
            connection.commit();
            Server.reloadConfiguration();
            String string6 = Resource.getString("common_columns_reset", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)string6, (String)ACTION_STRING);
            String string7 = "actiontaken.jsp";
            Object var24_21 = null;
            DatabaseUtil.close((Connection)connection);
            return string7;
        }
        try {
            long l = Server.getEpoSubnetImporter().getLastRunTime();
            string2 = l == 0L ? "--" : StringUtil.formatDateTime((Timestamp)new Timestamp(l), (int)3, (int)3, (String)this.m_lang);
            paginationState = SessionState.getPaginationState("Subnet", networkPropDisplay.getDefaultSortCol(), configuration.getPageCount(), httpServletRequest);
            long l2 = configuration.getSensorWindow();
            string3 = QueryUtil.makeSubnetQuery(paginationState.getStatusFlags(), paginationState.getSortCol(), paginationState.getSortOrder(), l2, paginationState.getSearchSexpStr());
            Network[] networkArray = Network.getByQuery(connection, string3, paginationState.getPagMgr().getIndex(), paginationState.getPagMgr().getItemsPerPage());
            if ((networkArray == null || networkArray.length < 1) && paginationState.getPagMgr().getIndex() > 1) {
                paginationState.getPagMgr().setIndex(1);
                networkArray = Network.getByQuery(connection, string3, paginationState.getPagMgr().getIndex(), paginationState.getPagMgr().getItemsPerPage());
            }
            string4 = "Networks as N";
            string5 = QueryUtil.makeSubnetWhereClause(paginationState.getStatusFlags(), l2);
            paginationState.getPagMgr().setListCount(DatabaseUtil.countRows((Connection)connection, (String)string4, (String)string5));
            htmlTable = new HtmlTable();
            htmlTable.setHasCheckbox(true);
            htmlTable.setPaginationMgr(paginationState.getPagMgr());
            htmlTableHeader = htmlTable.getHeader();
            htmlTableHeader.setCheckboxId("checkboxToggle");
            StringBuffer stringBuffer = new StringBuffer();
            int n = paginationState.getSortCol();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append("<a href='JavaScript:sortByCol(").append(Integer.parseInt(stringArray[n2])).append(")' class='blackLink'>").append(networkPropDisplay.getTruncatedHeader(Integer.parseInt(stringArray[n2])));
                if (Integer.parseInt(stringArray[n2]) == n) {
                    stringBuffer.append(HtmlTable.getSortMarker((int)paginationState.getSortOrder(), (String)string));
                }
                stringBuffer.append("</a>");
                htmlTableHeader.addCell(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                ++n2;
            }
            this.addSubnets(htmlTable, stringArray, networkPropDisplay, networkArray, paginationState.getPagMgr().getIndex(), configuration.getSensorWindow());
            Object var24_22 = null;
        }
        catch (Throwable throwable) {
            Object var24_23 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        httpServletRequest.setAttribute("Subnet", (Object)htmlTable.getHtml(string));
        httpServletRequest.setAttribute("index", (Object)Integer.toString(paginationState.getPagMgr().getIndex()));
        httpServletRequest.setAttribute("statusFlags", (Object)Integer.toString(paginationState.getStatusFlags()));
        httpServletRequest.setAttribute("lastEpoImport", (Object)string2);
        httpServletRequest.setAttribute("configureTableId", (Object)Integer.toString(2));
        SessionUtil.setCustomFilterDisplayString((HttpServletRequest)httpServletRequest, (String)paginationState.getSearchSexpStr(), (String)string);
        UIPropStack.initPropStack((String)ACTION_STRING, (HttpServletRequest)httpServletRequest, ((Object)((Object)this)).getClass(), (String)string3, (PaginationMgr)paginationState.getPagMgr(), (Class)(class$com$nai$mcafee$snowcap$db$Network == null ? (class$com$nai$mcafee$snowcap$db$Network = DisplaySubnetsBean.class$("com.nai.mcafee.snowcap.db.Network")) : class$com$nai$mcafee$snowcap$db$Network), (String)string4, (String)string5);
        return "subnetlist.jsp";
    }

    private void addSubnets(HtmlTable htmlTable, String[] stringArray, NetworkPropDisplay networkPropDisplay, Network[] networkArray, int n, long l) throws Exception {
        int n2 = 0;
        int n3 = networkArray.length;
        long l2 = System.currentTimeMillis();
        HtmlTableRow htmlTableRow = null;
        HtmlTableCell htmlTableCell = null;
        while (n2 < n3) {
            Network network = networkArray[n2];
            networkPropDisplay.setDbo(network);
            network.calculateProperties(l2, l, false);
            htmlTableRow = htmlTable.addRow(networkPropDisplay.getRowStyle());
            htmlTableRow.setCheckboxId("patternSub" + networkPropDisplay.getFullProperty(4));
            htmlTableRow.setCheckboxValue(networkPropDisplay.getFullProperty(3));
            if (network.getNetworkAddress().equals("255.255.255.255")) {
                htmlTableRow.setCheckboxDisabled(true);
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                htmlTableCell = htmlTableRow.addCell(networkPropDisplay.getFullProperty(Integer.parseInt(stringArray[n4])));
                htmlTableCell.setOnClick("clickNonCheckboxCell(" + network.getId() + "," + (n + n2) + ")");
                ++n4;
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

