/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.action.Action;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.action.ActionInvoker;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.HostStatus;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.event.EventFactory;
import com.nai.mcafee.snowcap.event.concrete.UserRequestEvent;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.ActionUtil;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ManualActionBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$ui$ManualActionBean == null ? (class$com$nai$mcafee$snowcap$ui$ManualActionBean = ManualActionBean.class$("com.nai.mcafee.snowcap.ui.ManualActionBean")) : class$com$nai$mcafee$snowcap$ui$ManualActionBean).getName());
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$ManualActionBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = null;
        String string3 = "";
        m_log.debug((Object)"Validating the manual action.");
        String string4 = httpServletRequest.getParameter("actionType");
        m_log.debug((Object)("Action type is: " + string4));
        ActionUtil.ActionMap actionMap = ActionUtil.getActions();
        m_log.debug((Object)("Action Map is: " + actionMap));
        ActionBase actionBase = (ActionBase)actionMap.get(string4);
        if (actionBase == null) {
            string3 = Resource.getString("manualactionbean_unrecognized_action_request", string);
            string2 = "actiontaken.jsp";
        } else {
            m_log.debug((Object)("Found a " + actionBase.getType() + " action in the request"));
            boolean bl = false;
            int n = 0;
            while (n <= 3) {
                if (actionBase.appliesToStatus(n) && SessionUtil.atLeastOneIntStartsWith((HttpServletRequest)httpServletRequest, (String)HostStatus.asString(n, string))) {
                    bl = true;
                    m_log.debug((Object)("Found some hosts checked, request is good.: " + HostStatus.asString(n, string)));
                }
                ++n;
            }
            if (!bl) {
                m_log.debug((Object)"Didn't find the required checked hosts... request is bad.");
                string3 = Resource.getString("manualactionbean_missing_selection_" + actionBase.getType(), string);
                string2 = "actiontaken.jsp";
            }
            if (string4.equals("pushAgent")) {
                return this.setupForAgentPush(httpServletRequest, string);
            }
        }
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)string3, (String)"displaymachines.do");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Iterator iterator;
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = httpServletRequest.getParameter("actionType");
        ActionUtil.ActionMap actionMap = ActionUtil.getActions();
        Action action = (Action)actionMap.get(string2);
        String string3 = null;
        string3 = httpServletRequest.getParameter("returnaction");
        ActionContext actionContext = null;
        Connection connection = null;
        m_log.debug((Object)("Executing action: " + string2));
        String string4 = ((ActionBase)actionMap.get(string2)).getType();
        m_log.debug((Object)("Type val is: " + string4));
        UserRequestEvent userRequestEvent = null;
        Vector vector = null;
        try {
            connection = Server.getDb().getConnection();
            userRequestEvent = EventFactory.createUserRequestEvent(connection, null, null, null);
            vector = this.gatherSelectedHosts(httpServletRequest, connection, string);
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            DatabaseUtil.close((Connection)connection);
            connection = null;
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        connection = null;
        if (string4.equals("pushAgent")) {
            httpServletRequest.getSession().setAttribute("sessionSelectedMachines", (Object)vector);
            return "agentpush.jsp";
        }
        boolean bl = false;
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (Host)((Object)iterator.next());
            actionContext = userRequestEvent.createActionContext();
            actionContext.setHost((Host)((Object)object));
            try {
                if (action.isAsyncAction()) {
                    m_log.debug((Object)"Executing action async.");
                    ActionInvoker actionInvoker = Server.getActionInvoker();
                    actionInvoker.addToQueue(action, actionContext);
                    continue;
                }
                m_log.debug((Object)"Executing action synchronously.");
                ActionInvoker.invokeAction(action, actionContext);
            }
            catch (ActionInvocationException actionInvocationException) {
                m_log.debug((Object)"Caught an exception", (Throwable)actionInvocationException);
                bl = true;
            }
        }
        if (bl) {
            object = Resource.getString("manualaction_error", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)object, (String)action.getManualTargetPage());
            return "actiontaken.jsp";
        }
        m_log.debug((Object)("Return action:" + string3));
        if (string3 == null || string3.length() == 0) {
            return action.getManualTargetPage();
        }
        return string3;
    }

    private Vector gatherSelectedHosts(HttpServletRequest httpServletRequest, Connection connection, String string) throws SQLException {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string2 = null;
        Vector<Host> vector = new Vector<Host>();
        if (!enumeration.hasMoreElements()) {
            m_log.debug((Object)"Cannot find any valid, checked machines.");
        }
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            m_log.debug((Object)("Checking identifier: " + string2));
            if (!ActionUtil.isHostIdentifier(string2, string)) continue;
            m_log.debug((Object)("Found a host parameter: " + string2));
            string2 = string2.replaceAll("\\D", "");
            Host host = Host.getByID(connection, Integer.parseInt(string2));
            if (host == null) continue;
            vector.add(host);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setupForAgentPush(HttpServletRequest httpServletRequest, String string) throws Exception {
        CharSequence charSequence;
        Connection connection = null;
        Connection connection2 = null;
        HashMap hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string2 = Resource.getJspString("jsputil_machine_inactive", string);
        String string3 = Resource.getJspString("jsputil_machine_rogue", string);
        String string4 = Resource.getJspString("jsputil_machine_managed", string);
        connection2 = Server.getEpoDb().getConnection();
        try {
            hashMap = EpoDatabase.getAgentList(connection2, "EPO", 68, string);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            DatabaseUtil.close((Connection)connection2);
            connection2 = null;
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection2);
        connection2 = null;
        connection = Server.getDb().getConnection();
        try {
            while (enumeration.hasMoreElements()) {
                charSequence = (String)enumeration.nextElement();
                if (((String)charSequence).indexOf(string2) == 0) {
                    charSequence = ((String)charSequence).substring(string2.length(), ((String)charSequence).length());
                    arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddr());
                    continue;
                }
                if (((String)charSequence).indexOf(string3) == 0) {
                    charSequence = ((String)charSequence).substring(string3.length(), ((String)charSequence).length());
                    arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddr());
                    continue;
                }
                if (((String)charSequence).indexOf(string4) != 0) continue;
                charSequence = ((String)charSequence).substring(string4.length(), ((String)charSequence).length());
                arrayList.add(Host.getByID(connection, Integer.parseInt((String)charSequence)).getNetworkAddr());
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        charSequence = new StringBuffer(1024);
        this.buildAgentOptions((StringBuffer)charSequence, hashMap);
        httpServletRequest.getSession().removeAttribute("sessionSelectedMachines");
        httpServletRequest.getSession().setAttribute("sessionSelectedMachines", arrayList);
        httpServletRequest.setAttribute("availableEpoAgents", (Object)((StringBuffer)charSequence).toString());
        return "agentpush.jsp";
    }

    private void buildAgentOptions(StringBuffer stringBuffer, HashMap hashMap) {
        Iterator iterator = hashMap.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            stringBuffer.append("<option ");
            if (bl) {
                bl = false;
                stringBuffer.append("selected ");
            }
            stringBuffer.append("value='").append(string2).append("'>");
            stringBuffer.append(string).append("</option>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

