/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.db.Tool;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.action.concrete.ExternalToolAction;
import com.nai.mcafee.snowcap.db.HNSParameterizer;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Parameterizer.ParamPropertyException;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.action.ActionFactory;
import com.nai.mcafee.snowcap.db.action.ActionFactoryException;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.util.Resource;
import java.text.Collator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ActionUtil {
    private static StringBuffer m_actionList = new StringBuffer();
    private static StringBuffer m_conditionList = new StringBuffer();
    private static final ActionMap m_actions = new ActionMap();

    public static final void buildActions(String string) throws ActionFactoryException, ParamPropertyException {
        ActionUtil.buildActions(null, string);
    }

    public static final void buildActions(String string, String string2) throws ActionFactoryException, ParamPropertyException {
        ActionUtil.clear();
        m_actionList.append("[");
        m_conditionList.append("[");
        ActionUtil.addInternalActions(string2);
        ActionUtil.addExternalTools();
        ActionUtil.addConditions(string, string2);
        ActionUtil.removeLastComma(m_actionList);
        ActionUtil.removeLastComma(m_conditionList);
        m_actionList.append("]");
        m_conditionList.append("]");
    }

    public static final ActionMap getActions() {
        return m_actions;
    }

    private static String getTypeStringForActionMap(ActionBase actionBase) {
        String string = actionBase instanceof ExternalToolAction ? ((ExternalToolAction)actionBase).getToolIdAsString() : actionBase.getType();
        return string;
    }

    public static final String getDisplayName(String string) {
        Iterator iterator = m_actions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = ActionUtil.getTypeStringForActionMap((ActionBase)entry.getValue());
            if (!string2.equals(string)) continue;
            return (String)entry.getKey();
        }
        return "";
    }

    public static final String getClientActionParamList() {
        return m_actionList.toString();
    }

    public static final String getClientConditionParamList() {
        return m_conditionList.toString();
    }

    public static final String getClientConditionOperatorList(String string) {
        return "[\"conditionType\",\"4\",\"2\",\"" + Resource.getString("actionutil_is", string) + "\",\"eq\",\"" + Resource.getString("actionutil_is_not", string) + "\",\"ne\",\"" + "conditionType" + "\",\"" + 3 + "\",\"2\",\"" + Resource.getString("actionutil_is_in_range", string) + "\",\"ipInRange\",\"" + Resource.getString("actionutil_is_not_in_range", string) + "\",\"ipNotInRange\",\"" + "conditionType" + "\",\"" + 1 + "\",\"2\",\"" + Resource.getString("actionutil_is_newer_than", string) + "\",\"newerThan\",\"" + Resource.getString("actionutil_is_older_than", string) + "\",\"olderThan\",\"" + "conditionType" + "\",\"" + 0 + "\",\"6\",\"" + Resource.getString("actionutil_contains", string) + "\",\"contains\",\"" + Resource.getString("actionutil_does_not_contain", string) + "\",\"doesntContain\"," + "\"" + Resource.getString("actionutil_starts_with", string) + "\",\"startsWith\",\"" + Resource.getString("actionutil_ends_with", string) + "\",\"endsWith\",\"" + Resource.getString("actionutil_is", string) + "\",\"eq\",\"" + Resource.getString("actionutil_is_not", string) + "\",\"ne\",\"" + "conditionType" + "\",\"" + 2 + "\",\"2\",\"" + Resource.getString("actionutil_is", string) + "\",\"eq\",\"" + Resource.getString("actionutil_is_not", string) + "\",\"ne\" ]";
    }

    public static final boolean isValidAction(String string) {
        return ActionUtil.isValidInternalAction(string) || ActionUtil.isValidExternalToolAction(string);
    }

    public static final boolean isValidInternalAction(String string) {
        ActionFactory actionFactory = Server.getActionFactory();
        int n = 0;
        while (n < actionFactory.getNumActions()) {
            if (string.compareTo(actionFactory.getTypeName(n)) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isValidExternalToolAction(String string) {
        Tool[] toolArray = Server.getTools();
        int n = Integer.parseInt(string);
        int n2 = 0;
        while (n2 < toolArray.length) {
            if (n == toolArray[n2].getId()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isHostIdentifier(String string, String string2) {
        return string.indexOf(Resource.getJspString("jsputil_machine_rogue", string2)) == 0 || string.indexOf(Resource.getJspString("jsputil_machine_exception", string2)) == 0 || string.indexOf(Resource.getJspString("jsputil_machine_inactive", string2)) == 0 || string.indexOf(Resource.getJspString("jsputil_machine_managed", string2)) == 0;
    }

    public static final String getActionSelectHtml(String string) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<select class='Toolbar' id='actionType:\" + actionCount + ").append("\"' name='actionType:\" + actionCount + \"' ").append("onchange='redrawActionParams( event )' >");
        TreeMap treeMap = new TreeMap(Collator.getInstance(new Locale(string)));
        Iterator iterator = m_actions.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = m_actions.get(object2);
            treeMap.put(object2, object);
        }
        object2 = treeMap.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            String string2 = ActionUtil.getTypeStringForActionMap((ActionBase)m_actions.get(object));
            stringBuffer.append("<option value='").append(string2).append("'>").append(StringUtil.safeHtml((String)object.toString())).append("</option>");
        }
        stringBuffer.append("</select>");
        return stringBuffer.toString();
    }

    public static final String getConditionSelectHtml(String string) throws ParamPropertyException {
        return ActionUtil.getConditionSelectHtml(null, string);
    }

    public static final String getConditionSelectHtml(String string, String string2) throws ParamPropertyException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<select class='Toolbar' id='conditionProp:\" + conditionCount + ").append("\"' name='conditionProp:\" + conditionCount + \"' ").append("onchange='redrawConditionParams( event )' >");
        HNSParameterizer hNSParameterizer = new HNSParameterizer(new Host(), new Network(), new Sensor());
        int n = 0;
        while (n < hNSParameterizer.getNumParamProperties()) {
            if (hNSParameterizer.useInConditions(n) && (string == null || hNSParameterizer.isTableProperty(n, string))) {
                stringBuffer.append("<option value='").append(hNSParameterizer.getParamPropertyName(n)).append("'>").append(hNSParameterizer.getParamPropertyDisplayName(n, string2)).append("</option>");
            }
            ++n;
        }
        stringBuffer.append("</select>");
        return stringBuffer.toString();
    }

    private static final void addInternalActions(String string) throws ActionFactoryException {
        ActionFactory actionFactory = Server.getActionFactory();
        ActionBase[] actionBaseArray = actionFactory.createAll();
        int n = 0;
        while (n < actionBaseArray.length) {
            if (actionBaseArray[n].getType() != "external tool") {
                m_actionList.append("\"").append("action").append("\",\"").append(actionBaseArray[n].getType()).append("\",\"").append(actionBaseArray[n].getNumProperties()).append("\",");
                int n2 = 0;
                while (n2 < actionBaseArray[n].getNumProperties()) {
                    m_actionList.append("\"").append(actionBaseArray[n].getPropertyName(n2)).append("\",");
                    ++n2;
                }
                m_actions.put(Resource.getString("action" + actionBaseArray[n].getType(), string), actionBaseArray[n]);
            }
            ++n;
        }
    }

    private static final void addExternalTools() {
        Tool[] toolArray = Server.getTools();
        int n = 0;
        while (n < toolArray.length) {
            m_actionList.append("\"").append("action").append("\",\"").append(toolArray[n].getId()).append("\",\"0\",");
            ExternalToolAction externalToolAction = new ExternalToolAction();
            externalToolAction.setToolId(toolArray[n].getId());
            m_actions.put(StringUtil.safeJavascriptLiteral((String)toolArray[n].getDisplayName()), externalToolAction);
            ++n;
        }
    }

    private static final void addConditions(String string, String string2) throws ParamPropertyException {
        HNSParameterizer hNSParameterizer = new HNSParameterizer(new Host(), new Network(), new Sensor());
        int n = 0;
        while (n < hNSParameterizer.getNumParamProperties()) {
            if (hNSParameterizer.useInConditions(n) && (string == null || hNSParameterizer.isTableProperty(n, string))) {
                m_conditionList.append("\"").append("condition").append("\",\"").append(hNSParameterizer.getParamPropertyName(n)).append("\",\"").append(hNSParameterizer.getParamPropertyType(n)).append("\",");
                if (hNSParameterizer.getParamPropertyType(n) == 2) {
                    String[] stringArray = hNSParameterizer.getPossibleEnumValues(n, string2);
                    m_conditionList.append("\"").append(stringArray.length).append("\",");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        m_conditionList.append("\"").append(stringArray[n2]).append("\",");
                        ++n2;
                    }
                } else {
                    m_conditionList.append("\"0\",");
                }
            }
            ++n;
        }
    }

    private static final void clear() {
        m_actions.clear();
        m_actionList.delete(0, m_actionList.length());
        m_conditionList.delete(0, m_conditionList.length());
    }

    private static final void removeLastComma(StringBuffer stringBuffer) {
        if (stringBuffer.indexOf(",") > -1) {
            stringBuffer.replace(stringBuffer.lastIndexOf(","), stringBuffer.lastIndexOf(",") + 1, "");
        }
    }

    public static class ActionMap
    extends TreeMap {
        public String toString() {
            return this.makeJSString(m_actions.keySet().iterator());
        }

        public String valsToString() {
            return this.makeJSString(m_actions.values().iterator());
        }

        private String makeJSString(Iterator iterator) {
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append('[');
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(',');
                } else {
                    bl = false;
                }
                stringBuffer.append('\"').append(iterator.next()).append('\"');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

