-------------------------------------------------------------------
-------------------------------------------------------------------
-- split here for dbmerge files aviprocedures1 and aviprocedures 2
-------------------------------------------------------------------



------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductSettingIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductSettingIssues]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVISP_FilterProductSettingIssues
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @ReturnGroupSummaryOnly	int=0

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	
	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


	-----------------------------------------------------------------------------------------------------------
	-- Reset work table
	TRUNCATE TABLE ReportPropertySettingsWork

	INSERT 
		ReportPropertySettingsWork 
	SELECT 
		 ReportPropertySettings.product
		, ReportPropertySettings.productcode
		, ReportPropertySettings.ParmName
		, ReportInputParameters.Prompt
		, ReportInputParameters.PDesc
		, ReportInputParameters.ParmValue
		, ReportPropertySettings.sectionname
		, ReportPropertySettings.settingname
	FROM 
		ReportPropertySettings, ReportInputParameters
	WHERE 
		ReportPropertySettings.ParmName = ReportInputParameters.ParmName
		AND ReportInputParameters.ParmValue > ''


	if @ReturnGroupSummaryOnly > 0
	begin

		SELECT
			 ReportPropertySettingsWork.product
			,  cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			,  cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, count(*) as 'Count'
			, '' as  FullNodePath
			, '' as  ProductCode
		   	, '' as ProductVersion 
		   	, '' as EngineVer 
 		 	 , '' as DATVer 
 		  	, '' as ExtraDATNames 
			, '' as ProductFamily 
			,  '' as  OSVersion
			, '' as DomainName
			, '' as ComputerName
			, '' as IPAddress		
			, '' as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
		GROUP BY
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
			, ReportPropertySettingsWork.PDesc
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname	
			, ReportPropertySettingsWork.ParmValue	
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName
	end
	else
	begin

		SELECT
			 ReportPropertySettingsWork.product
			, cast( ReportPropertySettingsWork.Prompt as varchar(255) )  as RuleName
			, cast( ReportPropertySettingsWork.ParmValue as varchar(255) )  as ParmValue
			, ReportPropertySettingsWork.ParmName
			, cast( ReportPropertySettingsWork.PDesc as varchar(255) )  as RuleDescription
			, ReportPropertySettingsWork.sectionname
			, ReportPropertySettingsWork.settingname
			, 1 as 'Count'
--			, LeafNode.NodeName as NodeNameLeaf
--			, BranchNode.NodeName as NodeNameBranch
			, cast( ReportFullPathNode.FullPathName as varchar(255) ) as FullNodePath
			, AVIView_Software.SoftwareName as ProductCode
		   	, ProductVersion =
    				CASE 
		     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     				ELSE '---' 
		    		END
		   	, EngineVer =
		    		CASE 
		     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
		     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		 	 , DATVer =
 		   		CASE 
 		    		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
  		   		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
 		    		ELSE '---' 
 		    		END
 		  	, ExtraDATNames =
  		  		CASE ProductProperties.ExtraDATNames 
 		    		WHEN 'N/A' THEN '' 
		     		ELSE ProductProperties.ExtraDATNames 
		     		END
			, ProductFamily = 
 			   	CASE 
 			    	WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
  			   	WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
  		 	  	ELSE  AVIView_Software.ProductFamily 
   		 	 	END
			,    cast((ComputerProperties.OSType 
			+ ' ' + ComputerProperties.OSServicePackVer 
			+ ' ' + ComputerProperties.OSPlatform) 
       			as varchar(50)) as OSVersion
			, DomainName
--	epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
			, LeafNode.NodeName as ComputerName
			, IPAddress
   			, CONVERT(datetime,
   				(SUBSTRING( LeafNode.LastUpdate,  1 , 4)+'-'+
 				  SUBSTRING( LeafNode.LastUpdate,  5 , 2)+'-'+                              
				   SUBSTRING( LeafNode.LastUpdate,  7 , 2)+' '+                              
				   SUBSTRING( LeafNode.LastUpdate,  9 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  11 , 2)+':'+                              
				   SUBSTRING( LeafNode.LastUpdate,  13 , 2)                                    
				   ), 120 )   as LastAsci
		FROM
			ReportPropertySettingsWork, ProductSettings
			, ProductProperties, AVIView_Software
			, LeafNode, ComputerProperties
			, ReportFullPathNode
		WHERE
			ReportPropertySettingsWork.sectionname =  ProductSettings.sectionname
			AND ReportPropertySettingsWork.settingname =  ProductSettings.settingname
			AND ReportPropertySettingsWork.ParmValue = ProductSettings.Value
			AND ProductSettings.ParentID = ProductProperties.AutoID
			AND ProductProperties.ProductCode = AVIView_Software.ProductCode
			AND ProductProperties.ParentID = LeafNode.AutoID
			AND LeafNode.ParentID = ReportFullPathNode.LowestNodeID
			AND LeafNode.AutoID = ComputerProperties.ParentID
		ORDER BY 
			 ReportPropertySettingsWork.product
			, ReportPropertySettingsWork.Prompt
			, ReportPropertySettingsWork.ParmName

	end



RETURN @@rowcount
END
GO



--------------------------------------------------------------------------
-- subreport procedures




---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterVAlertsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterVAlertsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterVAlertsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 ,@iNameSpaceNode  VARCHAR(20)
 ,@szEpoUserName  VARCHAR(100)
--, @szNameSpaceName  VARCHAR(100)
-- ,@szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
--,@szGroup1 varchar(100) = ''
--,@szGroup2 varchar(100) = ''
--,@szGroup3 varchar(100) = ''
--,@szGroup4 varchar(100) = ''
,@NodeID int = ''
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



if @szReportID != 'BFDAT'
begin

 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN ProductVersion
	   		ELSE '---'
	   		END,
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---'
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END,
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
  		BranchNode.NodeName AS NodeName 
 
 	FROM 
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   		AND ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
   		VirusName > '' 
--    		OR
--   		( (VirusName IS NULL OR VirusName = '') 
--    		AND (VirusType > '') )
  	)
	and (ReportActionDesc.ResolutionID >0 or ReportActionDesc.ResolutionID <0)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
		AND ( TVDEventID < 8500 or TVDEventID > 8999 )
   	AND LeafNode.Type !=  24      /* Uninstalled */ 
        AND 
	(	 @NodeID = ''
		OR NodeID = @NodeID
	)
 
end
else	-- return only buffer overflow events
begin

 	SELECT   
    			(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN ProductVersion > '' THEN ProductVersion
	   		ELSE '---'
	   		END,
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---'
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END,
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
  		BranchNode.NodeName AS NodeName 
 
 	FROM 
		LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
		Join Events on (Events.NodeID = LeafNode.AutoID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
  		AND ReportActionDesc.LanguageID = @szFullLang)
  	WHERE 
  	(
   		@FilterID = 0 OR
    		LeafNode.ParentID = @FilterID OR
  		LeafNode.ParentID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
   	AND TVDEventID in (1093, 1099 ) -- Show only buffer overflow events
   	AND LeafNode.Type !=  24      /* Uninstalled */ 
        AND 
	(	 @NodeID = ''
		OR NodeID = @NodeID
	)

end

RETURN @@rowcount
END
GO





---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeErrorEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeErrorEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeErrorEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
--   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	
	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	-- for now error events only exist in events table
--	select *
--	from ReportUpdateEvents
--	where NodeID = @NodeID	


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(ProductEvents.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.ProductVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version
	   		ELSE ReportComputerSummary.EngineVer
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ReportComputerSummary.DATVer
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
		,''  As ProductID
   		,cast(ReportComputerSummary.FullNodePath as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,Type as Type
		,Version as Version
		,Sitename as Sitename
		,InitiatorID as InitiatorID
		,InitiatorType as InitiatorType
		,Error as ErrorID
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as nvarchar(128)) 
			else cast(ProductEvents.Error as nvarchar(128)) 
			end
	FROM 
		ProductEvents Join ReportComputerSummary on (ProductEvents.NodeID = ReportComputerSummary.NodeID
			and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 ) )		
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
	--and events.tvdeventid = EventFilterDescFast.eventid
	--and EventFilterDescFast.language = @szLang
--  	and ProductEvents.NodeID = ReportComputerSummary.NodeID			/* regular join tieing events to nodes */
--	and ( ProductEvents.Error > 1 or ProductEvents.Error < 0 )


	UNION



 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime,
    		CAST(Events.ProductName As varchar(64)) AS ProductName,
    		ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END,
		/*    CAST(ProductVersion As varchar(16)) As ProductVersion, */
    		CAST(HostName As varchar(255)) As HostName, 
    		CAST(HostIPAddress As varchar(15)) As HostIPAddress,
    		CAST(UserName AS varchar(32)) AS UserName,
		/*    CAST(VirusName As varchar(128)) AS VirusName, */
    		VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END,
    		TVDEventID, 
    		CAST(FileName As varchar(255)) As FileName, 
    		CAST(EngineVersion As varchar(16)) AS EngineVersion, 
    		CAST(DATVersion as varchar(16)) As DATVersion, 
    		ScanTime, 
   		ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END,
    		TVDSeverity, 
   		VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType 
	   		ELSE '---'
	   		END,
		/*    CAST(VirusType AS varchar(128)) AS VirusType, */
    		CAST(TVDTaskName AS varchar(128))As TVDTaskName,
    		CAST(ProductID as int) As ProductID,
   		cast( ReportComputerSummary.FullNodePath  AS varchar(256)) AS NodeName,
   		'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		cast( EventFilterDescFast.name AS varchar(128)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szFullLang) 
  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterUpgradeEventsSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterUpgradeEventsSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterUpgradeEventsSubreport
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime
   , @NodeID int

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */

 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




	-- initiator types
	Declare @InitiatorType1 varchar(50)	
	Declare @InitiatorType2 varchar(50)	
	Declare @InitiatorType3 varchar(50)	
	Declare @InitiatorType4 varchar(50)	
	Declare @InitiatorType5 varchar(50)	

		Set @InitiatorType1 ='Automatic'	
		Set @InitiatorType2 ='Task'	
		Set @InitiatorType3 ='Remediation'	
		Set @InitiatorType4 ='On Demand'	
		Set @InitiatorType5 ='Rollback'	

	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		-- initiator type
		Select 	@InitiatorType1 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type1'
		Select 	@InitiatorType2 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type2'
		Select 	@InitiatorType3 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type3'
		Select 	@InitiatorType4 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type4'
		Select 	@InitiatorType5 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type5'
	End


	---------------------------------------------------
	-- Fix NodeIDs: need to do this in dal
--	update ProductEvents
--		set NodeID = leafnode.autoid
--		from LeafNode
--		where ProductEvents.AgentGUID = LeafNode.AgentGUID
--		and ProductEvents.NodeID is NULL


	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	SELECT
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
    		,CAST(AVIView_Software.SoftwareName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE lower(ProductEvents.Type)
	   		WHEN 'install' THEN ProductEvents.Version 
	   		ELSE AVIView_Software.SoftwareVersion
	   		END
    		,CAST(ProductEvents.HostName As varchar(255)) As HostName
    		,CAST(ProductEvents.HostIPAddress As varchar(15)) As HostIPAddress
    		,'' as UserName
    		,'' as VirusName
    		,'' as TVDEventID
    		,'' as FileName
    		,EngineVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'engine' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
    		,DATVersion = 
  			CASE lower(ProductEvents.Type)
	   		WHEN 'dat' THEN ProductEvents.Version 
	   		ELSE ''
	   		END
--    		,CAST(EngineVer As varchar(16)) AS EngineVersion
--    		,CAST(DATVer as varchar(16)) As DATVersion
    		,'' as ScanTime
   		,ProductEvents.Error as ActionTaken
    		,'' as TVDSeverity
   		,'' as VirusType 
    		,'' as TVDTaskName
   		,cast(ReportFullPathNodeID.FullPathShortName as varchar(256)) AS NodeName
		,cast('' as nvarchar(128)) as 'Event Description'
		,ProductEvents.Type as Type
		,Version as Version
		,ProductEvents.Sitename as Sitename
		,InitiatorID as InitiatorID
--		,InitiatorType as InitiatorType
		,case 
			when InitiatorType= 'Automatic' then @InitiatorType1
			when InitiatorType= 'Task' then @InitiatorType2
			when InitiatorType= 'Remediation' then @InitiatorType3
			when InitiatorType= 'OnDemand' then @InitiatorType4
			when InitiatorType= 'OnDemandRollback' then @InitiatorType5
			when InitiatorType= 'DeploymentTask' then @InitiatorType2
			when InitiatorType= 'UpdateTask' then @InitiatorType2
			when InitiatorType= 'RemediationRollback' then @InitiatorType5
			else InitiatorType
		end as InitiatorType
		,Error as ErrorID

-- postepo3 33379 - join to ReportUpdateEventDesc and return error desc if its available 
--		,cast(Error as nvarchar(128)) as ErrorDesc
		, ErrorDesc = case
			when ReportUpdateEventDesc.Description > '' then ReportUpdateEventDesc.Description 
			when cast(ProductEvents.Error as nvarchar(128)) > '' then cast(ProductEvents.Error as nvarchar(128))
			else '---'
			end

	FROM
		ProductEvents 
		Join leafnode on (ProductEvents.NodeID = leafnode.autoID			/* regular join tieing events to nodes */
			and ProductEvents.NodeID = @NodeID	)
		Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID)
		Join aviview_software on (ProductEvents.productcode = aviview_software.productcode)
		Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
			and ReportUpdateEventDesc.LanguageID = @szFullLang )
--	FROM ProductEvents, ReportComputerSummary, ReportUpdateEventDesc
	WHERE 
  	(
   		@FilterID = 0 OR
    		leafnode.parentid = @FilterID OR
  		leafnode.parentid in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	and ProductEvents.Type > ''



	UNION


 	SELECT   
    		(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
			as EventDateTime
    		,CAST(Events.ProductName As varchar(64)) AS ProductName
    		,ProductVersion =
  			CASE 
	   		WHEN Events.ProductVersion > '' THEN Events.ProductVersion
	   		ELSE '---' 
	   		END
    		,CAST(HostName As varchar(255)) As HostName 
    		,CAST(HostIPAddress As varchar(15)) As HostIPAddress
    		,CAST(UserName AS varchar(32)) AS UserName
    		,VirusName =
	  		CASE 
	   		WHEN VirusName > '' THEN VirusName
	   		ELSE '---' 
	   		END
    		,TVDEventID
    		,CAST(FileName As varchar(255)) As FileName 
    		,CAST(EngineVersion As varchar(16)) AS EngineVersion 
    		,CAST(DATVersion as varchar(16)) As DATVersion 
    		,ScanTime
   		,ActionTaken =
	    		CASE 
	     		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
 	    		END
    		,TVDSeverity
   		,VirusType =
  			CASE 
	   		WHEN VirusType > '' THEN VirusType
	   		ELSE '---' 
	   		END
    		,CAST(TVDTaskName AS varchar(128))As TVDTaskName
   		,cast('' as varchar(256)) AS NodeName
   		,'Event Description' =
	    		CASE 
	     		WHEN  EventFilterDescFast.name > '' THEN cast( EventFilterDescFast.name AS varchar(128))
	     		WHEN  EventFilterDescFast.name = '' THEN cast( events.tvdeventid AS varchar(128))
	     		ELSE  cast( events.tvdeventid AS varchar(128))
 	    		END
--		,cast(EventFilterDescFast.name as nvarchar(256)) as 'Event Description'
		,'' as Type
		,'' as Version
		,'' as Sitename
		,'' as InitiatorID
		,'' as InitiatorType
		,'' as ErrorID
		,'' as ErrorDesc
 
 	FROM 
		Events Join ReportComputerSummary on (Events.NodeID = ReportComputerSummary.NodeID)
		Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
   			AND ReportActionDesc.LanguageID = @szFullLang)
		Left Outer Join EventFilterDescFast on (events.tvdeventid = EventFilterDescFast.eventid	
			and EventFilterDescFast.language = @szLang) 

  	WHERE 
  	(
   		@FilterID = 0 OR
    		ReportComputerSummary.BranchNodeID = @FilterID OR
  		ReportComputerSummary.BranchNodeID in 
			(
			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        				from BranchNodeEnum 
        				where BranchNodeEnum.StartAutoID = @FilterID
			)
  	)
  	AND 
  	(
		(VirusName IS NULL OR VirusName = '' or VirusName = 'N/A') 
  	)
   	AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
   	AND (  TVDEventID < 8500 or TVDEventID > 8999  )
	and tvdeventid in (1119, 1123, 2201, 2202, 2204, 2208, 2216, 2232, 2264, 2328)
	and Events.NodeID = @NodeID	



RETURN @@rowcount
END

GO



---------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceComparisonSubreport]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceComparisonSubreport]
GO


CREATE PROCEDURE dbo.AVISP_FilterComplianceComparisonSubreport
--(
-- @iNameSpaceName  VARCHAR(20)
-- , @iNameSpaceNode  VARCHAR(20)
-- , @szEpoUserName  VARCHAR(100)
-- , @szNameSpaceName  VARCHAR(100)
-- , @szNameSpaceNode  VARCHAR(500)
-- , @szOptionalReportParms  VARCHAR(500) = ''
-- , @dtInfectionCheckPoint DateTime
-- , @AsciCheckPoint 	DateTime

--)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
/*
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  

  	-- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   	Declare @szLang VARCHAR(3)
   	Declare @szTime VARCHAR(10)
   	Declare @szFilter VARCHAR(50)
   	Set @szLang = '09'
   	Set @szTime = 'GMT'
	Declare @cnt int

   	if @szOptionalReportParms > ''
   		Execute AVISP_GetReportParms @szOptionalReportParms, @szLang OUTPUT, @szTime OUTPUT, @szFilter OUTPUT
*/



	-----------------------------------------------------------------------------------
	-- Collect and output all the variables

	select
	   NewComputers
	 ,   RemovedComputers
	 ,   UnchangedComputers
	 ,   NewInstalls
	 ,   RemovedInstalls
	 ,   NoScanner
	 ,   ExtraDAT
	 ,   NoAgent
	 ,   UnchangedAsci
	 ,   NewAgentVersion
	 ,   NewScannerVersion
	 ,   NewEngineVersion
	 ,   NewDATVersion
	 ,   NewExtradatVersion
	 ,   VirusCount
	 ,   UnresolvedVirusCount
	 ,   MaxVirus
	 ,   MaxUnresolvedVirus
	 ,   MaxVirusCount
	 ,   MaxUnresolvedVirusCount
	 ,   MaxEventid
	 ,  DateTimeEnd
	,   DateTimeStart

	 , NonComplianceAgentVersion 
	 , NonComplianceDAT 
	 , NonComplianceEngine 
	 , NonComplianceProduct
	 , NonComplianceComputer

	,    CountDATMostRecent
	,    CountDAT2ndMostRecent
	,    CountDAT3rdMostRecent
	,    CountDAT4thMostRecent
	,    CountDAT5thMostRecent
	,    CountDATOutOfDate
	,    CountEngineMostRecent
	,    CountEngine2ndMostRecent
	,    CountEngine3rdMostRecent
	,    CountEngineOutOfDate
	,    CountBothUpToDate 
	,    CountDATOutOfDateEngineOK 
	,    CountEngineOutOfDateDATOK 
	,    CountBothOutOfDate 

 	 , MinVersionDAT 
	 , MinVersionEngine 
	 , 	   MinVersionProductMcAfee
	 , 	 	  MinAgentVersion
	 , 	   MinVersionProductSymantec

	,     MinVersionDATMostRecent
	,     MinVersionDAT2ndMostRecent
	,     MinVersionDAT3rdMostRecent
	,     MinVersionDAT4thMostRecent
	,     MinVersionDAT5thMostRecent
	,     MinVersionEngineMostRecent
	,     MinVersionEngine2ndMostRecent
	,     MinVersionEngine3rdMostRecent
	,     ComputersWithVirus



	from
	ReportComplianceComparison

RETURN @@rowcount
END
GO



---------------------------------------------------------
----- Security Summary Report
-- 	vs7.5: changes to security summary procedure to support new 7.5 data (source field)

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterSecuritySummary]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterSecuritySummary]
GO

CREATE PROCEDURE dbo.AVISP_FilterSecuritySummary
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @dtInfectionCheckPoint varchar(64) = ''

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

	Declare @ret int  



  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


---------------
-- fetch start date

     -- set default value
     if len(@dtInfectionCheckPoint) < 6
	Set @dtInfectionCheckPoint = NULL

     declare @YYYYMMDDAnsi char(30)
     set @YYYYMMDDAnsi = NULL

	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @dtInfectionCheckPoint, '', @InfectYYYYMMDD output

	set @YYYYMMDDAnsi = convert(char(30), @InfectYYYYMMDD, 102)


------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpSecurity' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpSecurity

	-- Check if Firewall and Threatscan are installed
	Declare @Firewall int
	Declare @ThreatScan int
	Set @Firewall = 0
	Set @ThreatScan = 0

-----------------------------------
-- epo3.5 avoid getting a blank chartvalue in top 10 chart by filling in a default value with count=0

Declare @DefaultVirus char(30)
select top 1 @DefaultVirus=virusname from events where virusname > ''

Declare @DefaultUser char(30)
select top 1 @DefaultUser=username from EventDayResolution where username > ''

Declare @DefaultSource char(30)
select top 1 @DefaultSource=source from events where source > ''
if @DefaultSource = '' or @DefaultSource is null
	set @DefaultSource = '---'

Declare @DefaultProcessName char(30)
select top 1 @DefaultProcessName=ProcessName from events where TVDEventID = 1093
if @DefaultProcessName = '' or @DefaultProcessName is null
	set @DefaultProcessName = '---'


------------------------------------------------------------
	-- Scan for Virus data
/*  fetch event data groupings */

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , ProductName as ProductCode
   , cast(ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , VirusName
  , cast(@DefaultUser as varchar(32)) as UserName
  , Cast(null as varchar(128)) as FileName
  , NULL as VirusType
  , CAST(NULL AS varchar(16)) as ActionTaken
--     ,  case
--		when ProcessName > '' then NULL
--		else count(*)
--		end as VirusCount
    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
  -- vs7.5 put source data here
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate
  -- vs7.5
  , cast(@DefaultSource as varchar(255)) as Source
  , cast(@DefaultProcessName as varchar(128)) as ProcessName
  , 0 as VirusScan75Count
  , 0 as SourceCount
  , 0 as UserCount
--  , case
--	when Source > '' then left(source, 20) 
--	else NULL
--	end as Source
--  , case
--	when ProcessName > '' then cast(ProcessName as varchar(128))
--	else NULL
--	end as ProcessName
--    ,  case
--		when ProcessName > '' then count(*)
--		else null
--		end as VirusScan75Count
--     , case
--	when Source > '' then count(*)
--	else NULL
--	end as SourceCount


 INTO dbo.tmpSecurity
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
--	(
--	LeafNode Join BranchNode on(LeafNode.ParentID = BranchNode.AutoID)
--	)
--	Right Outer Join 
--	(
	EventDayResolution 
--	Left Outer Join ReportActionDesc on (Events.ActionTaken = ReportActionDesc.ActionIntID
--		and ReportActionDesc.LanguageID = @szFullLang
--		)
--	) on(LeafNode.autoID = Events.NodeID)	
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	and ( @YYYYMMDDAnsi = '' or @YYYYMMDDAnsi is null or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
--	AND ( @InfectYYYYMMDD = '' or @InfectYYYYMMDD is null or Events.EventDateTime > @InfectYYYYMMDD )
  		AND ( VirusName > '' and ActionTaken > '') --or ProcessName > '' ) 
--   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
--   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--       		AND Events.ProductName != 'ePO Agent' 

Group by
   ActionTaken
   ,VirusName
   ,ProductName 
   ,ProductVersion 
--   , UserName
--   , Source
--   , ProcessName


-- fetch users
insert 
into dbo.tmpSecurity

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , ProductName as ProductCode
   , cast(ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , @DefaultVirus as VirusName
  , UserName
  , Cast(null as varchar(128)) as FileName
  , NULL as VirusType
  , CAST(NULL AS varchar(16)) as ActionTaken
     ,  0 as VirusCount
--    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
  -- vs7.5 put source data here
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate
  -- vs7.5
  , @DefaultSource as Source
  , @DefaultProcessName as ProcessName
  , 0 as VirusScan75Count
  , 0 as SourceCount
  , count(*) as UserCount
--  , case
--	when Source > '' then left(source, 20) 
--	else NULL
--	end as Source
--  , case
--	when ProcessName > '' then cast(ProcessName as varchar(128))
--	else NULL
--	end as ProcessName
--    ,  case
--		when ProcessName > '' then count(*)
--		else null
--		end as VirusScan75Count
--     , case
--	when Source > '' then count(*)
--	else NULL
--	end as SourceCount
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
	EventDayResolution 
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		EventDayResolution.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
	and ( @YYYYMMDDAnsi = '' or @YYYYMMDDAnsi is null or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
--	AND ( @InfectYYYYMMDD = '' or @InfectYYYYMMDD is null or Events.EventDateTime > @InfectYYYYMMDD )
  		AND ( VirusName > ''  ) 
--   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
--   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--       		AND Events.ProductName != 'ePO Agent' 

Group by

   UserName
   ,Virusname
   ,productname
   ,productversion
--   , Source
--   , ProcessName


-- fetch sources
insert 
into dbo.tmpSecurity

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , ProductName as ProductCode
   , cast(ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , Cast(null as varchar(128)) as FileName
  , NULL as VirusType
  , CAST(NULL AS varchar(16)) as ActionTaken
     ,  0 as VirusCount
--    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
  -- vs7.5 put source data here
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate
  -- vs7.5
--  , NULL as Source
--  , NULL as SourceCount
  , case
	when Source > '' then left(source, 20) 
	else NULL
	end as Source
  , @DefaultProcessName as ProcessName
  , 0 as VirusScan75Count
--  , case
--	when ProcessName > '' then cast(ProcessName as varchar(128))
--	else NULL
--	end as ProcessName
--    ,  case
--		when ProcessName > '' then count(*)
--		else null
--		end as VirusScan75Count
     , case
	when Source > '' then count(*)
	else NULL
	end as SourceCount
  , 0 as UserCount
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
	Events 
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)
--	and ( @YYYYMMDDAnsi = '' or @YYYYMMDDAnsi is null or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	AND ( @InfectYYYYMMDD = '' or @InfectYYYYMMDD is null or Events.EventDateTime > @InfectYYYYMMDD )

  		AND ( VirusName > '' and ActionTaken > '' and source > '') 
--   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
--   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--       		AND Events.ProductName != 'ePO Agent' 

Group by
   Source
   ,productname
   ,productversion



-- fetch buffer overflows
insert 
into dbo.tmpSecurity

SELECT
   NULL as NodeName
   , NULL as AgentVersion
   , ProductName as ProductCode
   , cast(ProductVersion as nvarchar(32)) as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'

/* This portion is filled in by unions of event data */
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , null as FileName
  , NULL as VirusType
  , NULL as ActionTaken
     ,  NULL as VirusCount
--    , count(*) as VirusCount
--  , 1 as VirusCount
--  , NULL as Compliant
  , NULL as HostName
--,Events.HostName
  , NULL as HostIPAddress
  , cast('VirusScan' as nvarchar(50)) as ProductType
  , cast(NULL as nvarchar(255))  as AttackType
  , cast(NULL as nchar(50))  as AttackerIPAddress
  , cast(NULL as nvarchar(255))  as AttackDescription
  , cast(NULL as nvarchar(64)) as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , cast( NULL as DateTime) EventDateTime   
  -- vs7.5 put source data here
  , cast(NULL as nvarchar(255)) as Vulnerability
  , cast(NULL as nvarchar(255))  as VulnerabilityDesc
  , cast(NULL as nvarchar(64)) as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate
  -- vs7.5
  , @DefaultSource as Source
--  , case
--	when Source > '' then left(source, 20) 
--	else NULL
--	end as Source
  , case
	when ProcessName > '' then cast(ProcessName as varchar(128))
	else NULL
	end as ProcessName
    ,  case
		when ProcessName > '' then count(*)
		else null
		end as VirusScan75Count
--     , case
--	when Source > '' then count(*)
--	else NULL
--	end as SourceCount
  , 0 as SourceCount
  , 0 as UserCount
 
-- Postepo3: 33351 - make this report report on unlinked events
	FROM 
	Events 
  	WHERE 
  	(	-- check for directory filter
   		@FilterID = 0 OR
    		Events.NodeID in
		( Select LeafNode.autoid from Leafnode where LeafNode.ParentID in 
			(

			select BranchNodeEnum.EndAutoID		/* enum table used to determine list of legal nodes */ 
        		from BranchNodeEnum 
        		where BranchNodeEnum.StartAutoID = @FilterID
			Union
			select @FilterID
			)
		)
  	)

--	and ( @YYYYMMDDAnsi = '' or @YYYYMMDDAnsi is null or EventDayResolution.YearMonthDay >=  @YYYYMMDDAnsi)
	AND ( @InfectYYYYMMDD = '' or @InfectYYYYMMDD is null or Events.EventDateTime > @InfectYYYYMMDD )

  		AND ( ProcessName > '' ) 
		and TVDEventID = 1093
--   		AND TVDEventID not in (1202, 1203, 1506, 4600, 4650, 4651)  -- webshield\spam killer events, scan on/off
--   		AND (  TVDEventID < 8500 or TVDEventID > 8999  )
--       		AND Events.ProductName != 'ePO Agent' 

Group by
   ProcessName
   ,productname
   ,productversion


--------------------------------------------------------
-- firewall data lookup

	if exists (select * from sysobjects where id = object_id(N'[dbo].[FireIDsEvents]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @Firewall = 1
		
insert 
into dbo.tmpSecurity

SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'Firewall' as ProductCode
   , ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
--  , FireIDsEvents.HostIPAddress
  , 'Firewall' as ProductType
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
--  , FireIDsEvents.AttackDescription
  , FireIDsEvents.HostName as AttackeeHostname
  , count(*) as AttackCount
  , NULL as NewComputers
  , NULL as EventDateTime
--  , EventTime as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(NULL as DateTime) as ScanDate
  -- vs7.5
  , @DefaultSource as Source
  , @DefaultProcessName as ProcessName
  , 0 VirusScan75Count
  , 0 SourceCount
  , 0 as UserCount

 FROM FireIDsEvents
 WHERE
	EventTime > @InfectYYYYMMDD

Group by
   ProductVersion
--  , FireIDsEvents.HostIPAddress
  , FireIDsEvents.AttackType
--  , FireIDsEvents.AttackerIPAddress
  , FireIDsEvents.HostName 


	END



	if exists (select * from sysobjects where id = object_id(N'[dbo].[CCSAudit]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	BEGIN
		Set @ThreatScan = 1

insert 
into dbo.tmpSecurity
	SELECT
   '' as NodeName
   , NULL as AgentVersion
   , 'ThreatScan' as ProductCode
   , NULL as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'AutoDiscovery' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  ,count(*) as NewComputers
 , cast(max(EventDateTime) as DateTime) as EventDateTime
  , NULL as Vulnerability
  , NULL as VulnerabilityDesc
  , NULL as VulnerableHost
  , NULL as VulnerabilityCount
  , cast(max(EventDateTime) as DateTime) as ScanDate
  -- vs7.5
  , @DefaultSource as Source
  , @DefaultProcessName as ProcessName
  , 0 VirusScan75Count
  , 0 SourceCount
  , 0 as UserCount
  
	 FROM CCSAutoDiscovery

	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

	Declare @ScanDate DateTime
	select @ScanDate= cast(max(EventDateTime) as DateTime)
	 FROM CCSAutoDiscovery
	 WHERE
		TVDTaskName = 'Resource Discovery'
		and ScanIDStr = (select max(scanidstr) from ccsautodiscovery)

			
insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSAudit.ProductName as ProductCode
   , CCSAudit.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'Audit' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSAudit.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate
  -- vs7.5
  , @DefaultSource as Source
  , @DefaultProcessName as ProcessName
  , 0 VirusScan75Count
  , 0 SourceCount
  , 0 as UserCount
 
 FROM CCSAudit, VulnData

 WHERE
	CCSAudit.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from ccsaudit)
--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSAudit.ProductName
    , CCSAudit.ProductVersion
    , CCSAudit.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 



insert 
into dbo.tmpSecurity
SELECT
   '' as NodeName
   , NULL as AgentVersion
   , CCSVirusScan.ProductName as ProductCode
   , CCSVirusScan.ProductVersion as ProductVersion 
   , NULL as EngineVer 
   , NULL as DATVer 
   , NULL as ExtraDATNames 
   , NULL as DomainName
   , NULL as ProductFamily 
   , NULL as 'ComputerCnt'
  , @DefaultVirus as VirusName
  , @DefaultUser as UserName
  , NULL as FileName
  , NULL as VirusType
  , NULL as ActionTaken
  , 0 as VirusCount
  , NULL as HostName
  , NULL as HostIPAddress
  , 'ThreatScan' as ProductType
  , 'VirusScan' as AttackType
  , NULL as AttackerIPAddress
  , NULL as AttackDescription
  , NULL as AttackeeHostname
  , NULL as AttackCount
  , NULL as NewComputers
  , @ScanDate as EventDateTime
  , cast(VulnData.VulDesS as nvarchar(255)) as Vulnerability
  , cast(VulnData.VulDesV as nvarchar(255)) as VulnerabilityDesc
  , CCSVirusScan.HostName as VulnerableHost
--  , 1 as VulnerabilityCount
  , count(*) as VulnerabilityCount
  , @ScanDate as ScanDate
  -- vs7.5
  , @DefaultSource as Source
  , @DefaultProcessName as ProcessName
  , 0 VirusScan75Count
  , 0 SourceCount
  , 0 as UserCount
 
 FROM CCSVirusScan, VulnData

 WHERE
	CCSVirusScan.VulnID =  VulnData.ID
	and ScanID = (select max(scanid) from CCSVirusScan)

--Group By
--  cast(VulnData.VulDesS as nvarchar(255)) 
--  , cast(VulnData.VulDesV as nvarchar(255)) 

Group by
    CCSVirusScan.ProductName
    , CCSVirusScan.ProductVersion
    , CCSVirusScan.HostName
    , cast(VulnData.VulDesS as nvarchar(255)) 
    , cast(VulnData.VulDesV as nvarchar(255)) 


	END


	-- Returned combined data
	SELECT * from dbo.tmpSecurity

	set @ret = @@rowcount

	-- Cleanup
	DROP TABLE dbo.tmpSecurity


RETURN @ret
END
GO



--------------------------------------------------------------
-- actionable item routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeadAgentRemoval]
GO


CREATE PROCEDURE dbo.EPOSP_DeadAgentRemoval
(
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	SET ParentID=@DestID WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateComputerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateComputerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateComputerRemoval
(
@StrNumDays	NVARCHAR(50),	
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpDupComputers' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpDupComputers


	/* Find Duplicate Computers */

	SELECT 
		a.AutoID as AutoID
	INTO
		dbo.tmpDupComputers
	FROM
		LeafNode a, LeafNode b
	WHERE
		a.NodeName = b.NodeName
		and a.AutoID != b.AutoID
		and a.LastUpdate < b.LastUpdate
		and a.LastUpdate is not NULL
		and a.modifiedpropsdate<@TheDate


IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	
		SET ParentID=@DestID 
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END

	Drop Table dbo.tmpDupComputers

SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateScannerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateScannerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateScannerRemoval
(
@Action 	NVARCHAR(50)	-- Values: Delete, Move
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

/*
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)
*/

DECLARE @DestID INT
DECLARE @DirID INT


IF ('Delete'=@Action)
BEGIN
	-- Delete Duplicate Scanners
	delete from productproperties
	where autoid in
		(
		select min(productproperties.AutoID)
		from leafnode, productproperties,  aviview_software
		where leafnode.autoid = productproperties.parentid
		and productproperties.productcode = aviview_software.productcode
		and productfamily in ('tvd', 'tvd_nc')
		and DATVer != '5000'
		and productproperties.productcode != ''
		and aviview_software.productcode not like 'NMDASCAN%'
		and aviview_software.productcode not like 'GroupShield%'
		and aviview_software.productcode not like 'WebShield%'
		group by leafnode.nodename
		having count(*) > 1
		)

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_RemoveDeadInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_RemoveDeadInfo]
GO

CREATE PROCEDURE dbo.EPOSP_RemoveDeadInfo
(
@RuleName 	NVARCHAR(50),	-- Item to remove
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Inactive Agents'=@RuleName)
BEGIN
	EXECUTE EPOSP_DeadAgentRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Computers'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateComputerRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Scanners'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateScannerRemoval
		@Action 	
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END




SET NOCOUNT OFF
END
GO

---- vs7.5 bug workaround for epo3.0 since policysettings.sectionname cannot exceed 50 chars
-- Call this within login CompareReportVersions procedure
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FixVS75ReportPolicy]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FixVS75ReportPolicy]
GO

CREATE PROCEDURE dbo.AVISP_FixVS75ReportPolicy
AS
BEGIN
---- bug workaround for epo3.0 since policysettings.sectionname cannot exceed 50 chars

-- english 0409
Declare @cnt int
select @cnt=count(*) from policysettings where sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Detec'

if @cnt > 0
begin
 
update
policysettings
set sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Top Tens'
where sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Top T'

update
policysettings
set sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Action Summaries'
where sectionname = '1.0.0\AVI\0409\Reports\Anti-Virus\Infection\Actio'


-- german 0407

update
policysettings
set sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Abfragen'
where sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Abfra'

update
policysettings
set sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Top 10'
where sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Top 1'

update
policysettings
set sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Aktionen'
where sectionname = '1.0.0\AVI\0407\Reports\Anti-Virus\Infektion\Aktio'


-- spanish 040a

update
policysettings
set sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Detecciones'
where sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Det'

update
policysettings
set sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Diez Superiores'
where sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Die'

update
policysettings
set sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Acciones'
where sectionname = '1.0.0\AVI\040a\Reports\Anti-Virus\Infecciones\Acc'


-- french 040c

update
policysettings
set sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Dix Superieurs'
where sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Dix S'

update
policysettings
set sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Actions'
where sectionname = '1.0.0\AVI\040c\Reports\Anti-Virus\Infection\Actio'


-- korean 0412

update
policysettings
set sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Top Tens'
where sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Top T'

update
policysettings
set sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Action Summaries'
where sectionname = '1.0.0\AVI\0412\Reports\Anti-Virus\Infection\Actio'


-- chinese 0404

update
policysettings
set sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Top Tens'
where sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Top T'

update
policysettings
set sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Action Summaries'
where sectionname = '1.0.0\AVI\0404\Reports\Anti-Virus\Infection\Actio'


-- chinese (trad or simplify) 0804

update
policysettings
set sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Top Tens'
where sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Top T'

update
policysettings
set sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Action Summaries'
where sectionname = '1.0.0\AVI\0804\Reports\Anti-Virus\Infection\Actio'


-- japanese 0411

update
policysettings
set sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Detections'
where sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Detec'

update
policysettings
set sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Top Tens'
where sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Top T'

update
policysettings
set sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Action Summaries'
where sectionname = '1.0.0\AVI\0411\Reports\Anti-Virus\Infection\Actio'

end

END
GO


----------------------------------------------------------------------
----------------------------------------------------------------------
-- Extended nap: Report version compare between server and client
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_CompareReportVersions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_CompareReportVersions]
GO


CREATE PROCEDURE [dbo].[AVISP_CompareReportVersions] 
(
@ProductFamily nvarchar(20)
)
AS
Begin

Declare @ret int

-- Call workaround fix for vs7.5 extended nap. Nap code only writes the first 50 chars
--  to policyseetings.sectioname. This code writes the full nameout for all infection/* directories
execute AVISP_FixVS75ReportPolicy

Truncate Table ReportVersions



Declare @cnt int, @maxfiles int
Set @cnt = 1

-- ServerPolicy version
--Select @maxFiles = max( convert(int, Value) ) 
--	from ServerPolicy, AVIView_Software
--	where ServerPolicy.ProductCode = AVIView_Software.ProductCode
--		and ProductFamily = @ProductFamily
--		and SettingName = 'NumFiles' 

-- Policy, PolicySettings version
Select @maxFiles = max( convert(int, Value) ) 
	from Policy, PolicySettings, AVIView_Software
	where Policy.ProductCode = AVIView_Software.ProductCode
		and Policy.AutoID = PolicySettings.ParentID
		and ProductFamily = @ProductFamily
		and SettingName = 'NumFiles' 


if @maxFiles is null or @maxFiles < 1
	Set @maxfiles = 50 


--select @maxfiles, @cnt

While @cnt <= @MaxFiles
Begin


-- ServerPolicy version
--insert ReportVersions
--select
--a.ProductCode as ProductCode
--, a.Sectionname as Path
--, a.value as 'Filename'
--, b.value as 'ServerVersion'
--, '' as ClientVersion
--, 0 as DownloadFile
--from ServerPolicy as a, ServerPolicy as b, AVIView_Software
--where 
--a.ProductCode = AVIView_Software.ProductCode
--and ProductFamily = @ProductFamily
--and a.sectionname = b.sectionname
--and a.productcode = b.productcode
--and a.autoid != b.autoid
--and a.settingname = 'Filename' + convert( char(2), @cnt) 
--and b.settingname = 'Version' + convert( char(2), @cnt) 


-- Policy, PolicySettings version
-- epo3.5 fix 50 char DAL limit in SectioName
-- 	The statement handles both the old format (Path in sectioname) and new format (settingname=Path, path in value )
--  An outer join is done one settingname=path, case statement reads path from sectionname or value depending on result

insert ReportVersions
select
Policy.ProductCode as ProductCode
, case 
	when c.value > '' then c.value
	else a.Sectionname 
	end as Path
, a.value as 'Filename'
, b.value as 'ServerVersion'
, '' as ClientVersion
, 0 as DownloadFile
from Policy, PolicySettings as a, PolicySettings as b, PolicySettings as c, AVIView_Software
where 
Policy.ProductCode = AVIView_Software.ProductCode
and ProductFamily = @ProductFamily
and Policy.AutoID = a.ParentID			-- 1st inner join settingname=filename		
and a.settingname = 'Filename' + convert( char(2), @cnt) 	
and Policy.AutoID = b.ParentID			-- 2nd inner join settingname=version
and b.settingname = 'Version' + convert( char(2), @cnt) 
and Policy.AutoID *= c.ParentID			-- 3rd inner join settingname=path
and c.settingname = 'Path' 
and a.sectionname = b.sectionname	-- 3 way inner join on PolicySettings
and b.sectionname *= c.sectionname	-- outer join assures that 2 or 3 way inner join works

Set @cnt = @cnt + 1

End

--select * from reportversions

-- merge server and client versions

update reportversions
set Clientversion = 
(
-- post sp2 fix: make sure only one row can be returned here
select max(clientversion) from ReportVersionsClient
where
ReportVersions.ProductCode = ReportVersionsClient.ProductCode
and ReportVersions.Path = ReportVersionsClient.Path
and ReportVersions.Filename = ReportVersionsClient.Filename
)

/*
select * from reportversions
where serverversion != clientversion
or clientversion is null
*/

select 
ReportVersions.ProductCode,
Path,
Filename,
ServerVersion,
ClientVersion,
(
'insert ReportVersionsClient'
+ ' values( ''' + ReportVersions.ProductCode + ''''
+ ', ''' + Path + ''''
+ ', ''' + Filename + ''''
+ ', ''' + ServerVersion + ''')'

) as Script
from ReportVersions, AVIView_Software
where 
ReportVersions.ProductCode = AVIView_Software.ProductCode
and ProductFamily = 'EPO_REPORTS'
--productcode = 'reportsavi3000'
and path > '' and filename > ''
order by ReportVersions.ProductCode, path, filename

set @ret = @@rowcount

-- Must always truncate the client versions table after using it in this routine
Truncate Table ReportVersionsClient

return @ret
End
GO



--------------------------------------------------------------------
--------------------------------------------------------------------
-- 

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldGetSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldGetSavedSettings]
GO


CREATE PROCEDURE dbo.AVISP_FieldGetSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szFilter		VARCHAR(64) = '',
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szOptionFlag	nvarchar(64) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 Declare @ret int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextPromptStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextPromptStrings where LanguageID = @szFullLang




	-- Fetch translated text strings for localized parameter value prompt

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)

 

 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- First column must be called: Value
 -- second column must be called: Prompt

--select @szOptionFlag as value, @szOptionFlag as prompt
 Set @ret = 0

 IF @szOptionFlag = 'FetchAllSettings'	-- fetch all setting values for a given name
 BEGIN
	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt= ReportInputParametersSaved.ParmValuePrompt
--		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFilter
		and ReportInputParametersSaved.ReportID  = @szReportID 

--select * from ReportInputParameters where ReportInputParameters.ReportID  = @szReportID 

	-- Fetch translated text strings for localized parameter value prompt
	-- problem: need to get translation into reportinputparameter table

 	UPDATE
		ReportInputParameterValues
	SET
		Prompt= TextValue
	FROM	
		ReportTextPromptStrings
	WHERE
		LanguageID = @szLanguageID
		AND	 ReportTextPromptStrings.TextID like ReportInputParameterValues.ParmValue	-- uses like operator
		AND	
			(
				ReportTextPromptStrings.ReportID = @szReportID
				OR
				ReportTextPromptStrings.RptGroupID = @szRptGroup
			)


	-- fetch all parm values that get saved back to the DB and have settingname = @szFilter	
	Select  ParmValue as Value
		, Prompt as Prompt
		, ParmName as Name
		, ParmValuePrompt as ValuePrompt
	From ReportInputParameters 
	Where ReportID = @szReportID 
--		and ReportSavedSettingsName = @szFilter	
		and iSaveUserEntry = 1		

 	Set @ret = @@rowcount	
 END	
 ELSE
 BEGIN
	Declare @cnt int
	select @cnt=count(*) From ReportInputParametersSaved 
		Where ReportID = @szReportID 

	IF @@rowcount > 0
	BEGIN
		Select distinct(ReportSavedSettingsName) as Value
			, PDesc as Prompt
		From ReportInputParametersSaved 
		Where ReportID = @szReportID 
 		Set @ret = @@rowcount
	END
	ELSE
		SELECT '---' as Value , '---' as Prompt

END


 RETURN @ret 


END

GO



-----------------------------------------------------
-----------------------------------------------------
--

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FieldPutSavedSettings]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FieldPutSavedSettings]
GO



CREATE PROCEDURE dbo.AVISP_FieldPutSavedSettings
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @szOptionalReportParms 	 VARCHAR(500) = '',
    @szFieldName		VARCHAR(64) = '',
    @szFieldValue		VARCHAR(256) = '',
    @szFieldValuePrompt		VARCHAR(256) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   -- Output message
   Declare @szResult   VARCHAR(64)
   Set @szResult = ''
   Declare @cnt int

   Declare @ret int
   set @ret=0

   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextPromptStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextPromptStrings where LanguageID = @szFullLang



 ----------------------------------------------------------------
 -- Lookup Parameter values 
 -- second column must to be called: Prompt

 IF @szFieldName = 'SaveSettingsVar' or @szFieldName = 'SaveSettingsAs'
 BEGIN 

 	Select @cnt = count(*)
	FROM	ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	-- save current settings into saved name

	IF @cnt > 0
	BEGIN	
	 	UPDATE
			ReportInputParametersSaved
		SET
			ReportInputParametersSaved.ParmValue = ReportInputParameters.ParmValue
			, ReportInputParametersSaved.ParmValuePrompt = ReportInputParameters.ParmValuePrompt
			, ReportInputParametersSaved.Prompt= ReportInputParameters.Prompt
		FROM	
			ReportInputParameters
		WHERE
			ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
			and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
			and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameterssaved.iSaveUserEntry = 1
			and ReportInputParametersSaved.ReportID  = @szReportID 
        END
	ELSE     -- do insert if not there
	BEGIN
		Update ReportInputParameters
		Set ReportInputParameters.ReportSavedSettingsName = @szFieldValue
		Where
			ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Insert  ReportInputParametersSaved
		( ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, PDesc)
		Select ReportID, RptGroupID, ParmValue, Prompt, ParmName, iSaveUserEntry, ReportSavedSettingsName, ParmValuePrompt, ReportSavedSettingsName
			from ReportInputParameters
			WHERE
			ReportInputParameters.ReportSavedSettingsName  = @szFieldValue
			and ReportInputParameters.ReportID  = @szReportID 
			and ReportInputParameters.iSaveUserEntry = 1

		Update ReportInputParameters
		Set ReportSavedSettingsName = ''
		Where
			ReportID  = @szReportID 
			and iSaveUserEntry = 1

		-- postepo3 change SaveSettings to SaveSettingsVar
		delete ReportInputParametersSaved
		where ParmName in ('SaveSettingsVar','SaveSettingsAs','RestoreSettings','DeleteSettings')


	END

	set @ret = @@rowcount	


 END
 ELSE IF @szFieldName = 'RestoreSettings'
 BEGIN

	-- Fetch saved setting into current settings
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= ReportInputParametersSaved.ParmValue
		, ReportInputParameters.ParmValuePrompt = ReportInputParametersSaved.ParmValuePrompt
--		, ReportInputParameters.Prompt= ReportInputParametersSaved.Prompt
	FROM	
		ReportInputParametersSaved
	WHERE
		ReportInputParameters.ReportID = ReportInputParametersSaved.ReportID
		and ReportInputParameters.ParmName = ReportInputParametersSaved.ParmName
		and ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.iSaveUserEntry = 1
		and ReportInputParametersSaved.ReportID  = @szReportID 

	-- postepo3: fix save settings not saving issue
	-- Set name of open settings in open and save fields
 	UPDATE
		ReportInputParameters
	SET
		ReportInputParameters.ParmValue= @szFieldValue
	WHERE	
		ReportInputParameters.ReportID  = @szReportID 
		and ReportInputParameters.ParmName in ('RestoreSettings', 'SaveSettingsVar')

	set @ret = @@rowcount	

 END
 ELSE IF @szFieldName = 'DeleteSettings'
 BEGIN

 	DELETE
		ReportInputParametersSaved
	WHERE
		ReportInputParametersSaved.ReportSavedSettingsName  = @szFieldValue
		and ReportInputParametersSaved.ReportID  = @szReportID 
		and ReportInputParametersSaved.iSaveUserEntry = 1

	set @ret = @@rowcount	
 END


 -- Return Result String
 SELECT @szResult as szResult


 RETURN @ret

END
GO



-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-------------------------------------------------------------
-- mhilandepo3 - Customization lookup routines - one per cust screen not one per field
-- vs7.5 Changed to handle data filter lookups for customized events 

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Events]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Events
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'

   Declare @EventType varchar(50)

   -- vs7.5 Fetch EventType as well
   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms3 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT, @EventType OUTPUT

--select @EventType

   -- For Infection custom group report EventType is dynaimcally stored in the metadata
   -- vs7.5 fetch EventType: some fields vary with it for buffer overflow
	If @szReportID = 'INFECTGROUP'
		select @EventType = ParmValue
			from ReportInputParameters
			where ReportID = 'INFECTGROUP'
				and ParmName = '@EventType'


	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			

	-- epo3.5 action string translation
	Declare @Cleaned varchar(50)			Declare	@Deleted varchar(50)
	Declare @Moved varchar(50)			Declare	@Excluded varchar(50)
	Declare @ContinueScan varchar(50)		Declare	@TestVirus varchar(50)
	Declare @CleanError varchar(50)			Declare	@DeleteError varchar(50)
	Declare @MoveError varchar(50)			Declare	@ExcludeError varchar(50)
	Declare @HeuristicError varchar(50)		Declare	@AccessDenied varchar(50)
	Declare @ScanTimedOut varchar(50)		Declare	@NotScanned varchar(50)
	Declare @NoCleaner varchar(50)			Declare	@CleanMoveError varchar(50)
	Declare @CleanDeleteError varchar(50)		Declare	@MoveDeleteError varchar(50)
	Declare @DeleteMoveError varchar(50)			
   	Declare @Resolved varchar(30)	
   	Declare @Unresolved varchar(30)	
   	Declare @Server varchar(50)			Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	





	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	
		-- epo3.5 action string translation
		Set @Cleaned ='Cleaned'				Set @Deleted ='Deleted'
		Set @Moved ='Moved'				Set @Excluded ='Excluded'
		Set @ContinueScan ='ContinuedScan'		Set @TestVirus ='Test Virus'
		Set @CleanError ='Clean Error'			Set @DeleteError ='Delete Error'
		Set @MoveError ='Move Error'			Set @ExcludeError ='Exclude Error'
		Set @HeuristicError ='Heuristic Error'		Set @AccessDenied ='Access Denied'
		Set @ScanTimedOut ='Scan Timed Out'		Set @NotScanned ='Not Scanned'
		Set @NoCleaner ='No Cleaner'			Set @CleanMoveError ='Clean-Move Error'
		Set @CleanDeleteError ='Clean-Delete Error'	Set @MoveDeleteError ='Move-Delete Error'
		Set @DeleteMoveError ='Delete-Move Error'			
	   	Set @Resolved ='Resolved'	
   		Set @Unresolved ='Unresolved'		
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'	
		Set @Professional = 'Professional'

	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		-- epo3.5 action translations
		-- resolved
		Select 	@Cleaned = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 1
		Select 	@Deleted = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 2
		Select 	@Moved = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 3
		Select 	@Excluded = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 4
		Select 	@ContinueScan = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 5
		Select 	@TestVirus = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = 6
		-- unresolved
		Select 	@CleanError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -1
		Select 	@DeleteError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -2
		Select 	@MoveError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -3
		Select 	@ExcludeError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -4
		Select 	@HeuristicError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -5
		Select 	@AccessDenied = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -6
		Select 	@ScanTimedOut = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -7
		Select 	@NotScanned = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -8
		Select 	@NoCleaner = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -9
		Select 	@CleanMoveError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -10
		Select 	@CleanDeleteError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -11
		Select 	@MoveDeleteError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -12
		Select 	@DeleteMoveError = ActionName from ReportActionDesc 
			Where LanguageID = @szFullLang and ResolutionID = -13
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'

	End
	
   
--select @EventType
   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
		where EventDateTime > ''
		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
		where EventDateTime > ''
		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
		where EventDateTime > ''
		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
		where EventDateTime > ''
		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else if ( @EventType = 'BufrOvfl' )
	begin
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			AND ReportActionDesc.LanguageID = @szFullLang 
			and tvdeventid in (1093)
	end
	else
	begin
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			AND ReportActionDesc.LanguageID = @szFullLang 
		order by value
	end

   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
            and DomainName > ''
		Order by Value 		

   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
		Order by Value 	

   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
		Order by Value 		


   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
		Order by Value 	

   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct 
		case OSPlatform
			when 'Server' then @Server
			when 'Workstation' then @Workstation
			when 'Professional' then @Professional
			else OSPlatform
		end 
		as Value
	 from ComputerProperties
	 where osplatform > ''
		Order by Value 		

   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostIPAddress' OR @szFilter = 'HostAddr'
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND Events.NodeID = LeafNode.AutoID
	 and hostipaddress > ''
		Order by Value 	

   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
	 SELECT DISTINCT DATVersion as Value 
	 FROM Events
	 WHERE Events.DATVersion > ''
	 ORDER BY DATVersion desc
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
	 SELECT DISTINCT EngineVersion as Value 
	 FROM Events
	 WHERE Events.EngineVersion > ''
	 ORDER BY EngineVersion desc
   end

   else if @szFilter = 'EventID' or @szFilter = 'TVDEventID'
   begin
	 SELECT DISTINCT cast(TVDEventID as varchar(10)) as Value 
	 FROM Events
	 where tvdeventid > ''
		Order by Value 	

   end

   else if @szFilter = 'TVDTaskName'
   begin
	 SELECT DISTINCT TVDTaskName as Value 
	 FROM Events
	 WHERE Events.TVDTaskName > ''
	 ORDER BY TVDTaskName desc
   end


   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and hostname > ''
		Order by Value 		

   end

   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT ProductName as Value 
	 FROM Events
	 WHERE ProductName NOT LIKE '%Agent%'
	 and productname > ''
		Order by Value 		

   end

   else if @szFilter = 'ProductVersion'
   begin
	 	SELECT DISTINCT ProductVersion as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and productversion > ''
		Order by Value Desc		

   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((Events.ProductName + ' ' + Events.ProductVersion) as varchar(50))
		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (Events.ProductName + ' ' + Events.ProductVersion) > ''
		Order by Value 	

   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVersion + ' ' +  DATVersion) as varchar(50)) 
 		  as Value 
	 	FROM Events
	       	WHERE Events.ProductName != 'ePO Agent' 
		and (EngineVersion + ' ' +  DATVersion) > ''
		Order by Value Desc		

   end


   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT lower(UserName) as Value 
	 FROM Events, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and Events.NodeID = LeafNode.AutoID
	 and username > ''
		Order by Value 	

   end


   else if @szFilter = 'TVDSeverity'
   begin
	 SELECT DISTINCT EventFilterDescFast.Severity as Value 
	 FROM EventFilterDescFast
	 WHERE Language = @szFullLang
	 and name > ''
	 Order By EventFilterDescFast.Severity
		 	

   end

   -- not used: this is not a separate output field in the stored procedure
--   else if @szFilter = 'FileComponent'
--   begin
--	SELECT DISTINCT 
--		case
--			when ModuleName > '' and APIName > ''
--				then ModuleName + ' | ' + APIName
--			when ModuleName > ''
--				then ModuleName 
--			else APIName
--			end as Value
--	 FROM Events
--	 WHERE Events.ModuleName > '' or Events.APIName > ''
--   end


   else if @szFilter = 'VirusSubtype'
   begin

		 SELECT DISTINCT 
			VirusType.VirusFileType as Value
		 FROM 
			VirusType
	--		Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
	--				and VirusType.VirusName > '')
		Order by Value 		


   end

   else if @szFilter = 'VirusType'
   begin
	if ( @EventType = 'BufrOvfl' )
	begin
		 SELECT DISTINCT DetectionName as Value 
		 FROM Events
		 WHERE Events.DetectionName > ''
	end
	else
	if ( @EventType = 'Programs' )
	begin
		 SELECT DISTINCT VirusType as Value 
		 FROM Events
		 WHERE Events.VirusType like 'App%'
		Order by Value 	

	end
	else
	Begin
		-- Check if VirusType table needs translating and redo it if language differs
		-- virustype table only stores one language at a time (it dynamically translates to the language you need)
		EXECUTE AVISP_TranslateVirusType @szFullLang
	
		 SELECT DISTINCT 
			case 
			when VirusType.VirusTypeTranslated > '' then VirusType.VirusTypeTranslated
			when Events.VirusType > '' then Events.VirusType
			else Events.VirusType
			end  as Value 
		 FROM 
			Events Left Outer Join VirusType on (Events.VirusName = VirusType.VirusName
					and VirusType.VirusName > '')
		 Where TVDEventid != 1506 and TVDEventid != 4600
		Order by Value 	

	--	 WHERE 
	--		Events.VirusName *= VirusType.VirusName
	--		and VirusType.VirusName > ''
	End
   end


   else if @szFilter = 'VirusName'
   begin
	if ( @EventType = 'BufrOvfl' )
	begin
		 SELECT DISTINCT ProcessName as Value 
		 FROM Events
		 WHERE Events.ProcessName > ''
		Order by Value 	

	end
	else
	if (@EventType = 'Programs' )
	begin
		 SELECT DISTINCT VirusName as Value 
		 FROM Events
		 WHERE Events.VirusName > '' and VirusType like 'App%'
		Order by Value 	

	end
	else
	begin
		 SELECT DISTINCT VirusName as Value 
		 FROM Events
		 WHERE Events.VirusName > ''
			and TVDEventid != 1506 and TVDEventid != 4600  -- exclude webshield events
		Order by Value 	

	end
   end


   else if @szFilter = 'FileName'
   begin
	-- vs7.5
	if ( @EventType = 'BufrOvfl' )
	begin
		SELECT DISTINCT 
		case
			when ModuleName > '' and APIName > ''
				then ModuleName + ' | ' + APIName
			when ModuleName > ''
				then ModuleName 
 			else APIName
 			end as Value
	 	FROM Events
	 	WHERE Events.ModuleName > '' or Events.APIName > '' 
		Order by Value 		

	end
	else
	begin
		-- postepo3 Top 10 files report return the rightmost postion of the filename
		if @szReportID = 'T10FILE' or @szReportID = 'RESOLVED' or @szReportID = 'UNRESOLVED'
		begin
			 SELECT DISTINCT right(Events.FileName,15) as Value 
			 FROM Events, LeafNode
			 WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 and Events.NodeID = LeafNode.AutoID
			 and filename > ''
			Order by Value 	

		end
		else
		begin
			 SELECT DISTINCT FileName as Value 
			 FROM Events, LeafNode
			 WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 and Events.NodeID = LeafNode.AutoID
			 and filename > ''
			Order by Value 	

		end
	end
   end

   -- vs7.5 changes
   else if @szFilter = 'EventDesc'
   begin
	if ( @EventType = 'BufrOvfl' )
	begin
		select '' as Value	-- No value returned for this field
--		SELECT DISTINCT 
--		case
--			when ModuleName > '' and APIName > ''
--				then ModuleName + ' | ' + APIName
--			when ModuleName > ''
--				then ModuleName 
 --			else APIName
 --			end as Value
--	 	FROM Events
--	 	WHERE Events.ModuleName > '' or Events.APIName > ''
	end
	else
	if ( @EventType = 'ALL' ) 
	begin
		 SELECT DISTINCT EventFilterDescFast.Name as Value 
		 FROM EventFilterDescFast
		 WHERE Language = @szFullLang
		 and name > ''
		 Order By EventFilterDescFast.Name
	end
	else
	if ( @EventType = 'Programs' ) 
	begin
		 SELECT DISTINCT Events.Source as Value 
		 FROM Events
		 Where Events.source > '' and VirusType like 'App%'
		 Order By Events.source
	end
	else
	begin
		 SELECT DISTINCT Events.Source as Value 
		 FROM Events
		 Where Events.source > ''
		 Order By Events.source
	end
   end

   -- webshield entries
   else if @szFilter = 'RuleName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusName	

   end

   else if @szFilter = 'RuleType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By VirusType
   end

   else if @szFilter = 'Server'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
	 Order By HostName
   end

   else if @szFilter = 'AffectedArea'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType not in ('spam', 'deny-spam')
	 Order By Filename
   end

   else if @szFilter = 'SpamSource'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/

Return @@rowcount
END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Webshield]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Webshield]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_Webshield
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
		Order by Value Desc		
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
		Order by Value Desc		
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
		Order by Value Desc		
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From Events
	 WHERE TVDEventID in (1506, 4600)
		Order by Value Desc		
   end


   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
   begin
	if @szFilter = ''
    		SELECT DISTINCT ActionTaken as Value FROM Events
	else
		SELECT DISTINCT
		  Value = 
			CASE
			   WHEN ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
     			   ELSE convert(varchar(20),Events.ActionTaken)
			   END
		FROM Events, ReportActionDesc
		WHERE
			Events.ActionTaken = ReportActionDesc.ActionID
			And TVDEventID in (1506, 4600)
			AND
				(ReportActionDesc.LanguageID = @szFullLang 
				or
				ReportActionDesc.LanguageID = @szFullLang )
		Order by Value 		


   end

--   else if @szFilter = 'Action' OR @szFilter = 'ActionTaken'
--   begin
--	 SELECT DISTINCT ActionTaken as Value 
--	 FROM Events
--	 WHERE TVDEventID in (1506, 4600)
--	 Order By ActionTaken
--   end


   -- webshield entries
   -- RuleName
   else if @szFilter = 'VirusName'
   begin
	 SELECT DISTINCT VirusName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusName
   end

   -- rule type
   else if @szFilter = 'VirusType'
   begin
	 SELECT DISTINCT VirusType as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By VirusType
   end

   -- server
   else if @szFilter = 'HostName'
   begin
	 SELECT DISTINCT HostName as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostName
   end

   -- affected area
--   else if @szFilter = 'Filename'
--   begin
--	 SELECT DISTINCT Filename as Value 
--	 FROM Events
--	 WHERE TVDEventID = 1506
--		and VirusType not in ('spam', 'deny-spam')
--	 Order By Filename
--   end

   -- SpamSource
   else if @szFilter = 'Filename'
   begin
	 SELECT DISTINCT Filename as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
		and VirusType in ('spam', 'deny-spam')
	 Order By Filename
   end

   -- email source
   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM Events
	 WHERE TVDEventID = 1506
--		and VirusType in ('spam', 'deny-spam')
	 Order By UserName
   end

   -- IP Address
   else if @szFilter = 'IPAddress' or @szFilter = 'HostIPAddress' 
   begin
	 SELECT DISTINCT HostIPAddress as Value 
	 FROM Events
	 WHERE TVDEventID in (1506, 4600)
	 Order By HostIPAddress
   end

   else 
   begin
	 SELECT '---' AS Value
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @@rowcount
END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_UpdateEvents]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_UpdateEvents]
GO


CREATE PROCEDURE dbo.AVISP_GetCust_UpdateEvents
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


	------------------------------
	-- read in translated terms
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	
	-- initiator types
	Declare @InitiatorType1 varchar(50)	
	Declare @InitiatorType2 varchar(50)	
	Declare @InitiatorType3 varchar(50)	
	Declare @InitiatorType4 varchar(50)	
	Declare @InitiatorType5 varchar(50)		

	If @Server = '' or @Server is null				-- if first is not found assume they all are
	Begin
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'	
		Set @Professional = 'Professional'
		Set @InitiatorType1 ='Automatic'	
		Set @InitiatorType2 ='Task'	
		Set @InitiatorType3 ='Remediation'	
		Set @InitiatorType4 ='On Demand'	
		Set @InitiatorType5 ='Rollback'	
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- jp rpt will use chart labels instead of legends which wont display jp chars
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
		-- initiator type
		Select 	@InitiatorType1 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type1'
		Select 	@InitiatorType2 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type2'
		Select 	@InitiatorType3 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type3'
		Select 	@InitiatorType4 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type4'
		Select 	@InitiatorType5 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type5'
	End


   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   -- year
   if @szFilter = 'Year' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		as Value
		From ProductEvents
		Order by Value Desc		
	Set @ret = @@ROWCOUNT
   end

   -- quarter
   else if @szFilter = 'Quarter' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) as char(1)) 
		as Value
		From ProductEvents
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- month
   else if @szFilter = 'Month' 
   begin
	SELECT DISTINCT
		Substring(convert(char,EventDateTime,120),1,7) 
		as Value
		From ProductEvents
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end

   -- week
   else if @szFilter = 'Week' 
   begin
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		as Value
		From ProductEvents
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   begin
	 SELECT DISTINCT leafnode.nodename as Value 
	 FROM ProductEvents, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ProductEvents.AgentGUID = LeafNode.AgentGUID
	 and hostname > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''
		Order by Value 	


   	Set @ret = @@ROWCOUNT
   end


   else if @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareName as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > '' 
		Order by Value 	
 
   	Set @ret = @@ROWCOUNT
   end

   -- gets if from software view not productproperty table
   else if @szFilter = 'ProductVersion' 
   begin
	    	SELECT DISTINCT AVIView_Software.SoftwareVersion as Value 
		       	FROM ProductEvents, AVIView_Software
		       	WHERE 
			    ProductEvents.ProductCode = AVIView_Software.ProductCode
				   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) 
				and softwarename > ''  
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct 
		case OSPlatform
			when 'Server' then @Server
			when 'Workstation' then @Workstation
			when 'Professional' then @Professional
			else OSPlatform
		end 
		as Value
	 from ComputerProperties
	 where osplatform > ''
		Order by Value 	

   end

   else if @szFilter = 'FullProductName'
   begin
	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		  as Value 
	       FROM AVIView_Software
	       WHERE 
		 (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		and (AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
		Order by Value Desc		

    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Version'
   begin
	    	SELECT DISTINCT ProductEvents.Version as Value 
		       	FROM ProductEvents
			where version > ''
		Order by Value Desc		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Type'
   begin
	    	SELECT DISTINCT ProductEvents.Type as Value 
		       	FROM ProductEvents
			where type > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorDesc'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Description) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error
		Order by Value 	


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ErrorType'
   begin
	    	SELECT DISTINCT convert(varchar(128), ReportUpdateEventDesc.Name) as Value 
		       	FROM ReportUpdateEventDesc, ProductEvents
			where ReportUpdateEventDesc.ErrorID = ProductEvents.Error
		Order by Value 	


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Error'
   begin
	    	SELECT DISTINCT convert(varchar(50), ProductEvents.Error) as Value 
		       	FROM ProductEvents
			where ProductEvents.Error > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
	    	SELECT DISTINCT ProductEvents.Locale as Value 
		       	FROM ProductEvents
			where locale > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'SiteName'
   begin
	    	SELECT DISTINCT ProductEvents.SiteName as Value 
		       	FROM ProductEvents
			where sitename > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorID'
   begin
	    	SELECT DISTINCT ProductEvents.InitiatorID as Value 
		       	FROM ProductEvents
			where initiatorid > ''
		Order by Value 	


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'InitiatorType'
   begin
	    	SELECT 	distinct 
			case 
				when InitiatorType= 'Automatic' then @InitiatorType1
				when InitiatorType= 'Task' then @InitiatorType2
				when InitiatorType= 'Remediation' then @InitiatorType3
				when InitiatorType= 'OnDemand' then @InitiatorType4
				when InitiatorType= 'OnDemandRollback' then @InitiatorType5
				when InitiatorType= 'DeploymentTask' then @InitiatorType2
				when InitiatorType= 'UpdateTask' then @InitiatorType2
				when InitiatorType= 'RemediationRollback' then @InitiatorType5
				else InitiatorType
			end 
			as Value
		       	FROM ProductEvents
			where initiatortype > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   	Set @ret = @@ROWCOUNT
   end

/*
   else if @szFilter = ''
   begin

   end
*/


Return @ret
END
GO


---------------
-- vs7.5 handle lookup of buffer overflow signature version

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Properties]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Properties]
GO

CREATE PROCEDURE dbo.AVISP_GetCust_Properties
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	------------------------------
	-- read in translated terms
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	
		

	If @Server = '' or @Server is null				-- if first is not found assume they all are
	Begin
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'
		Set @Professional = 'Professional'	
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- jp rpt will use chart labels instead of legends which wont display jp chars
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
	End



   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   if @szFilter = 'Day' 
   begin
	-- postepo3 - for prop day cust append -000000 to the end
	SELECT DISTINCT
		substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) + '-000000'
		as Value
		From LeafNode
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end


   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
		and ProductProperties.ProductVersion != '5000'
		Order by Value Desc		

    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
	-- vs7.5 Handle lookup of buffer overflow signature value
	if @szReportID != 'BFDAT'
	Begin
	 	SELECT DISTINCT ProductProperties.DATVer as Value 
	    	FROM ProductProperties, AVIView_Software
	    	WHERE 
	 		ProductProperties.ProductCode = AVIView_Software.ProductCode
	 		and ProductProperties.DATVer > ''
	 		and ProductProperties.DATVer != '5000'
		Order by Value Desc		

	   	Set @ret = @@ROWCOUNT
	End
	Else
	Begin
	 	SELECT DISTINCT ProductSettings.Value as Value 
			from ProductProperties, AVIView_Software, ProductSettings
			where 
			ProductProperties.ProductCode =  AVIView_Software.ProductCode
			and ProductFamily = 'TVD'
			and ProductSettings.ParentID = ProductProperties.AutoID
			and SectionName = 'General'
			and SettingName in ('szBufferOverflowDAT')
			group by Value, SettingName
			order by Value Desc
	   	Set @ret = @@ROWCOUNT
	End
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
    	SELECT DISTINCT ProductProperties.EngineVer as Value 
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
          	and ProductProperties.EngineVer > ''
          	and ProductProperties.EngineVer != '5000'
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'ComputerName' OR @szFilter = 'HostName'
   begin
--	epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
	 SELECT DISTINCT LeafNode.NodeName as Value 
	  FROM LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and nodename > '' and Type != 24
		Order by Value 		


--	 SELECT DISTINCT ComputerProperties.ComputerName as Value 
--	  FROM ComputerProperties, ProductProperties, LeafNode
--	  WHERE 
--	  (
--	   @FilterID = 0 OR
--	   LeafNode.ParentID = @FilterID OR
--	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
--	       from BranchNodeEnum 
--	       where BranchNodeEnum.StartAutoID = @FilterID)
--	  )
--	  and ProductProperties.ParentID = LeafNode.AutoID 
--	  AND LeafNode.AutoID = ComputerProperties.ParentID
--	  and computername > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
 	SELECT DISTINCT 
	   Value = 
		CASE
		   WHEN LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
		   ELSE ProductProperties.Language
		   END
	   FROM 
		ProductProperties Left Outer Join LanguageDesc on (
			RIGHT( ProductProperties.Language, 2 )  =  LanguageDesc.ClientLanguageSuffix)
--			AND LanguageDesc.epoServerLanguageSuffix = @szLang 
--			and productproperties.language > '')
   	   WHERE 
-- 		RIGHT( ProductProperties.Language, 2 )  *=  LanguageDesc.ClientLanguageSuffix
--		AND 
		LanguageDesc.epoServerLanguageID = @szFullLang 
		and productproperties.language > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''
		Order by Value 	


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'SoftwareName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT AVIView_Software.SoftwareName as Value 
	    FROM ProductProperties, AVIView_Software
	    WHERE 
		ProductProperties.ProductCode = AVIView_Software.ProductCode 
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and softwarename > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductVersion'
   begin
	    SELECT DISTINCT ProductProperties.ProductVersion as Value 
		INTO #TmpProdVer	
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and productversion > ''
			and productversion != '5000'
		Order by Value Desc		



	-- special case processing, remove virusscan wrk and svr suffix from product version)
	-- special case processing, remove virusscan wrk and svr suffix from product version)
	-- epo3.5 operation by just showing what is present, users can do in to see both .srv & .wrk
--	Insert #TmpProdVer select Value = Replace(Value, '.wrk', '') from #TmpProdVer
--	Insert #TmpProdVer Select Value = Replace(Value, '.srv', '') from #TmpProdVer

	Select distinct Value from #TmpProdVer
	ORDER BY Value desc	

	Drop Table #TmpProdVer

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ServicePack'
   begin
	    SELECT DISTINCT ProductProperties.ServicePack as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and servicepack > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Hotfix'
   begin
	    SELECT DISTINCT ProductProperties.Hotfix as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and hotfix > ''
		Order by Value Desc		


   	Set @ret = @@ROWCOUNT
   end

--   else if @szFilter = 'LicenseStatus'
--   begin
--	    SELECT DISTINCT ProductProperties.LicenseStatus as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

--   else if @szFilter = 'ExpirationDate'
--   begin
--	    SELECT DISTINCT SubString(ProductProperties.ExpirationDate,1,6) as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

   else if @szFilter = 'LastContact' or @szFilter = 'LastAsci'
   begin
	    SELECT DISTINCT SubString(LeafNode.LastUpdate,1,8) + '000000' as Value 
	       FROM Leafnode
		where SubString(LeafNode.LastUpdate,1,8) > ''
		order by Value desc
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ExtraDATNames'
   begin
	    SELECT DISTINCT ProductProperties.ExtraDATNames as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		    and ProductProperties.ExtraDATNames != 'N/A'
			and extradatnames > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentType'
   begin
	IF Exists (select * from ReportTranslations where LanguageID = @szFullLang and Subject = 'AgentType')
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = @szFullLang
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End
	else
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = '0409'
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End


--	 SELECT  'Agent' as Value
--	 UNION SELECT 'Super Agent Broadcast' as Value
--	 UNION SELECT 'Super Agent Repository' as Value
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct 
		case OSPlatform
			when 'Server' then @Server
			when 'Workstation' then @Workstation
			when 'Professional' then @Professional
			else OSPlatform
		end 
		as Value
	 from ComputerProperties
	 where osplatform > ''
		Order by Value 		

   end

   else if @szFilter = 'FullProductName'
   begin

	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software, leafnode
	       WHERE 
	       (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	       ) and
		    leafnode.autoid = productproperties.parentid
		    and ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) > ''	
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DatExtraDat'
   begin
	    SELECT DISTINCT cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50))		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   end


Return @ret
END
GO

-----------------
-- epo3.5 AVISP_GetCust_Properties2: same as abobe except ProductVersion = productVersion + ServicePack + Patch

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetCust_Properties2]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetCust_Properties2]
GO

CREATE PROCEDURE dbo.AVISP_GetCust_Properties2
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
    , @szFilter		VARCHAR(20) = ''
    , @szOptionalReportParms  VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) if users top node = root node and no filter selected 
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'
   Declare @ret int
   Set @ret =0 


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	------------------------------
	-- read in translated terms
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)			

	If @Server = '' or @Server is null				-- if first is not found assume they all are
	Begin
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'
		Set @Professional = 'Professional'	
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- jp rpt will use chart labels instead of legends which wont display jp chars
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
	End



   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter

   if @szFilter = 'Day' 
   begin
	-- postepo3 - for prop day cust append -000000 to the end
	SELECT DISTINCT
		substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) + '-000000'
		as Value
		From LeafNode
		Order by Value Desc		
   	Set @ret = @@ROWCOUNT
   end


   else if @szFilter = 'AgentVersion'
   begin
	SELECT DISTINCT 
   		Value =
--    			AVIView_Software.SoftwareName + '/ ' +
    			(CASE 
     			WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     			ELSE '---' 
     			END)
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
        	AND AVIView_Software.ProductCode LIKE 'ePOAgent%'
		and ProductProperties.ProductVersion != '5000'
		Order by Value Desc		

    	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DATVersion' OR @szFilter = 'DATVer'
   begin
	-- vs7.5 Handle lookup of buffer overflow signature value
	if @szReportID != 'BFDAT'
	Begin
	 	SELECT DISTINCT ProductProperties.DATVer as Value 
	    	FROM ProductProperties, AVIView_Software
	    	WHERE 
	 		ProductProperties.ProductCode = AVIView_Software.ProductCode
	 		and ProductProperties.DATVer > ''
	 		and ProductProperties.DATVer != '5000'
		Order by Value Desc		

	   	Set @ret = @@ROWCOUNT
	End
	Else
	Begin
	 	SELECT DISTINCT ProductSettings.Value as Value 
			from ProductProperties, AVIView_Software, ProductSettings
			where 
			ProductProperties.ProductCode =  AVIView_Software.ProductCode
			and ProductFamily = 'TVD'
			and ProductSettings.ParentID = ProductProperties.AutoID
			and SectionName = 'General'
			and SettingName in ('szBufferOverflowDAT')
			group by Value, SettingName
			order by Value Desc
	   	Set @ret = @@ROWCOUNT
	End
   end

   else if @szFilter = 'EngineVersion' OR @szFilter = 'EngineVer'
   begin
    	SELECT DISTINCT ProductProperties.EngineVer as Value 
       	FROM ProductProperties, AVIView_Software
       	WHERE 
	    	ProductProperties.ProductCode = AVIView_Software.ProductCode
          	and ProductProperties.EngineVer > ''
          	and ProductProperties.EngineVer != '5000'
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end



   else if @szFilter = 'ComputerName' OR @szFilter = 'HostName'
   begin
--	epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
	 SELECT DISTINCT LeafNode.NodeName as Value 
	  FROM LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and nodename > '' and Type != 24
		Order by Value 	


--	 SELECT DISTINCT ComputerProperties.ComputerName as Value 
--	  FROM ComputerProperties, ProductProperties, LeafNode
--	  WHERE 
--	  (
--	   @FilterID = 0 OR
--	   LeafNode.ParentID = @FilterID OR
--	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
--	       from BranchNodeEnum 
--	       where BranchNodeEnum.StartAutoID = @FilterID)
--	  )
--	  and ProductProperties.ParentID = LeafNode.AutoID 
--	  AND LeafNode.AutoID = ComputerProperties.ParentID
--	  and computername > ''
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Language'
   begin
 	SELECT DISTINCT 
	   Value = 
		CASE
		   WHEN LanguageDesc.LanguageName > '' THEN LanguageDesc.LanguageName
		   ELSE ProductProperties.Language
		   END
	   FROM 
		ProductProperties Left Outer Join LanguageDesc on (
			RIGHT( ProductProperties.Language, 2 )  =  LanguageDesc.ClientLanguageSuffix)
--			AND LanguageDesc.epoServerLanguageSuffix = @szLang 
--			and productproperties.language > '')
   	   WHERE 
-- 		RIGHT( ProductProperties.Language, 2 )  *=  LanguageDesc.ClientLanguageSuffix
--		AND 
		LanguageDesc.epoServerLanguageID = @szFullLang 
		and productproperties.language > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'NodeName' or @szFilter = 'GroupName'
   begin
	 SELECT DISTINCT NodeName as Value 
	 FROM BranchNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  BranchNode.AutoID = @FilterID OR
	  BranchNode.AutoID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 AND NodeName not in ('Directory','GlobalRoot')
	 and nodename > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSVersion'
   begin
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        as varchar(50)) as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
			       from BranchNodeEnum 
			       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and (ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) > ''
		Order by Value 		


   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductName' OR @szFilter = 'SoftwareName' OR @szFilter = 'ProductCode'
   begin
	 SELECT DISTINCT AVIView_Software.SoftwareName as Value 
	    FROM ProductProperties, AVIView_Software
	    WHERE 
		ProductProperties.ProductCode = AVIView_Software.ProductCode 
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and softwarename > ''
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ProductVersion'
   begin
	    -- epo3.5 PV = PV + SP + HF
	    SELECT DISTINCT 
			(rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
			as Value 
		INTO #TmpProdVer	
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and productversion > ''
			and productversion != '5000'
		

	-- special case processing, remove virusscan wrk and svr suffix from product version)
	-- special case processing, remove virusscan wrk and svr suffix from product version)
--	Insert #TmpProdVer select Value = Replace(Value, '.wrk', '') from #TmpProdVer
--	Insert #TmpProdVer Select Value = Replace(Value, '.srv', '') from #TmpProdVer

	Select distinct Value from #TmpProdVer
	ORDER BY Value desc	

	Drop Table #TmpProdVer

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'UserName'
   begin
	 SELECT DISTINCT UserName as Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
	 (
	  @FilterID = 0 OR
	  LeafNode.ParentID = @FilterID OR
	  LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       from BranchNodeEnum 
	       where BranchNodeEnum.StartAutoID = @FilterID)
	 )
	 and ComputerProperties.ParentID = LeafNode.AutoID 
	 and username > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'IPAddress' OR @szFilter = 'HostAddr' OR @szFilter = 'HostIPAddress'
   begin
	 SELECT DISTINCT ComputerProperties.IPAddress as Value 
	  FROM ComputerProperties, ProductProperties, LeafNode
	  WHERE 
	  (
	   @FilterID = 0 OR
	   LeafNode.ParentID = @FilterID OR
	   LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
				       from BranchNodeEnum 
				       where BranchNodeEnum.StartAutoID = @FilterID)
	  )
	  and ProductProperties.ParentID = LeafNode.AutoID 
	  AND LeafNode.AutoID = ComputerProperties.ParentID
	  and ipaddress > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ServicePack'
   begin
	    SELECT DISTINCT ProductProperties.ServicePack as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and servicepack > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'Hotfix'
   begin
	    SELECT DISTINCT ProductProperties.Hotfix as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and hotfix > ''
		Order by Value Desc		


   	Set @ret = @@ROWCOUNT
   end

--   else if @szFilter = 'LicenseStatus'
--   begin
--	    SELECT DISTINCT ProductProperties.LicenseStatus as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

--   else if @szFilter = 'ExpirationDate'
--   begin
--	    SELECT DISTINCT SubString(ProductProperties.ExpirationDate,1,6) as Value 
--	       FROM ProductProperties, AVIView_Software
--	       WHERE 
--		    ProductProperties.ProductCode = AVIView_Software.ProductCode
--			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
--				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
--
--   end

   else if @szFilter = 'LastContact' or @szFilter = 'LastAsci'
   begin
	    SELECT DISTINCT SubString(LeafNode.LastUpdate,1,8) + '000000' as Value 
	       FROM Leafnode
		where SubString(LeafNode.LastUpdate,1,8) > ''
		order by Value desc
	
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'ExtraDATNames'
   begin
	    SELECT DISTINCT ProductProperties.ExtraDATNames as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
			   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		    and ProductProperties.ExtraDATNames != 'N/A'
			and extradatnames > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'AgentType'
   begin
	IF Exists (select * from ReportTranslations where LanguageID = @szFullLang and Subject = 'AgentType')
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = @szFullLang
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End
	else
	Begin
		SELECT DISTINCT ReportTranslations.TranslatedValue as Value 
		FROM ReportTranslations
	 	WHERE LanguageID = '0409'
	 	and Subject = 'AgentType'	 
	 	Order By ReportTranslations.TranslatedValue
	End


--	 SELECT  'Agent' as Value
--	 UNION SELECT 'Super Agent Broadcast' as Value
--	 UNION SELECT 'Super Agent Repository' as Value
   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DomainName'
   begin
	SELECT DISTINCT ComputerProperties.DomainName as Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
	    (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	    )
            and ProductProperties.ParentID = LeafNode.AutoID 
  		AND LeafNode.AutoID = ComputerProperties.ParentID
		and domainname > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSType'
   begin
	 SELECT  distinct OSType as Value
	 from ComputerProperties
	 where ostype > ''
		Order by Value 	

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'OSPlatform'
   begin
	 SELECT  distinct 
		case OSPlatform
			when 'Server' then @Server
			when 'Workstation' then @Workstation
			when 'Professional' then @Professional
			else OSPlatform
		end 
		as Value
	 from ComputerProperties
	 where osplatform > ''
		Order by Value 	

   end

   else if @szFilter = 'FullProductName'
   begin

	    SELECT DISTINCT cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software, leafnode
	       WHERE 
	       (
	   	@FilterID = 0 OR
 	  	LeafNode.ParentID = @FilterID OR
	   	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
	       				from BranchNodeEnum 
	       				where BranchNodeEnum.StartAutoID = @FilterID)
	       ) and
		    leafnode.autoid = productproperties.parentid
		    and ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
			and (AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) > ''	
		Order by Value 		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'DatExtraDat'
   begin
	    SELECT DISTINCT cast((DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50))
		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end

   else if @szFilter = 'EngineDat'
   begin
	    SELECT DISTINCT cast((EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50))		  as Value 
	       FROM ProductProperties, AVIView_Software
	       WHERE 
		    ProductProperties.ProductCode = AVIView_Software.ProductCode
		   and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
			or AVIView_Software.ProductFamily like 'TVD_NC_%' )
		   and (EngineVer + ' ' +  DATVer + ' ' + Replace( ExtraDATNames, 'N/A', '')) > ''
		Order by Value Desc		

   	Set @ret = @@ROWCOUNT
   end


   else 
   begin
	 SELECT '---' AS Value
   end


Return @ret
END
GO


---------------------------------------------------------------------------
-- Report group procedures - allows users to select there own report groupings
--	Fetches group summaries initially, gets details within separate subreport procedure
--	3 reports:
--	InfectionsByUserGroups
--	ProductsByUserGroups
--	UpdateEventsByUserGroups



--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
------------------
-- Custom data group procedures: Product ProductEvent Infection


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductGroups]
GO






CREATE PROCEDURE dbo.AVISP_FilterProductGroups
(
 @iNameSpaceName  VARCHAR(20),
 @iNameSpaceNode  VARCHAR(20),
 @szEpoUserName  VARCHAR(100),
 @szNameSpaceName  VARCHAR(100),
 @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @ConnectAfterYYYYMMDD varchar(30) = ''
 , @ConnectAfterRule varchar(30) = ''
 , @ConnectType  varchar(20)='Current'		-- All, Current, Late
 , @ProductType  varchar(20)='AntiVirus'	-- AntiVirus, Security, Agent, All
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

  
  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


/* Stored procedure to recreate table of nodepaths and node ids */
/* This table persists and is recreated each time the report runs */
-- epo3.5 no longer need to call this because the ReportFullPathNodeID table is maintained real time
--	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'



	-- Fetch Infect After date variables
	Declare @YYYYMMDD char(30)	
	Declare @YYYY_MM_DD char(30)	
	Declare @YYYYMMDDdate datetime
	execute dbo.AVISP_GetDateConversion @ConnectAfterYYYYMMDD, @ConnectAfterRule, @YYYYMMDDdate output

	set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @YYYYMMDDdate,120), '-', ''), ':', ''), ' ', '')
	set @YYYY_MM_DD = convert(char(30), @YYYYMMDDdate,120)
	if @YYYYMMDD is null
		set @YYYYMMDD = ''
	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)			
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	
		
	Declare 	@English varchar(30)		Declare 	@German varchar(30)
	Declare 	@Spanish varchar(30)		Declare 	@French varchar(30)
	Declare 	@Japanese varchar(30)		Declare 	@Chinese varchar(30)
	Declare 	@Korean varchar(30)		Declare 	@Italian varchar(30)
	Declare 	@Swedish varchar(30)		Declare 	@Portuguese varchar(30)
	Declare 	@Dutch varchar(30)		Declare 	@Polish varchar(30)


	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'
		Set @Professional = 'Professional'	
		Set 	@English = 'English'		Set 	@German = 'German'
		Set 	@Spanish = 'Spanish'		Set 	@French = 'French'
		Set 	@Japanese = 'Japanese'		Set 	@Chinese = 'Chinese'
		Set 	@Korean = 'Korean'		Set 	@Italian = 'Italian'
		Set 	@Swedish = 'Swedish'		Set 	@Portuguese = 'Portuguese'
		Set 	@Dutch = 'Dutch'		Set 	@Polish = 'Polish'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'Agent'
--		Set @Agent = 'Agent'		-- last minute localization bug, too late to retranslate
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
		Select 	@English = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='09'
		Select 	@German = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='07'
		Select 	@Spanish = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='0a'
		Select 	@French = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='0c'
		Select 	@Japanese = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='11'
		Select 	@Chinese = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='04'
		Select 	@Korean = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='12'
		Select 	@Italian = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='10'
		Select 	@Swedish = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='1d'
		Select 	@Portuguese = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='16'
		Select 	@Dutch = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='13'
		Select 	@Polish = LanguageName from LanguageDesc 
			Where epoServerLanguageID = @szFullLang and ClientLanguageSuffix='15'
	End
	
	-- asian chars dont display in x-axis of bar chart, fetch these translations only if non-asian (except japanese)
	if @szFullLang <> '0409' 
		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
	End
	
--------------------------------------------------------------------------------------------------
-- Read Data Filter and Group Selections to see which query option to pick for fastest performance
--	must group on fields that are part of the Group selections or Data filter 

	-- merge group fields into one to simplify processing
	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	-- epo3.5: if ungrouped field selected for data filter then make sure drilldown set to drilldown not fast
	-- This will allow all data filter options for each layout type
	Declare @HostName int
	Set @HostName = CHARINDEX( 'HostName', @GroupFields)	
	if @HostName = 0 	Set @HostName = CHARINDEX( 'HostName', @DataFilter)	
	if @HostName > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @HostIPAddress int
	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @GroupFields)	
	if @HostIPAddress = 0 	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @DataFilter)	
	if @HostIPAddress > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @UserName int
	Set @UserName = CHARINDEX( 'UserName', @GroupFields)	
	if @UserName = 0 	Set @UserName = CHARINDEX( 'UserName', @DataFilter)	
	if @UserName > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @LastContact int
	Set @LastContact = CHARINDEX( 'LastContact', @GroupFields)	
	if @LastContact = 0 	Set @LastContact = CHARINDEX( 'LastContact', @DataFilter)	
	if @LastContact > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

-- test
--select @szDrilldown1 as Drilldown, @EventType as Eventtype
--	, @DataFilter as Datafilter, @GroupFields as Groupfields
--	, @Time as 'Timegroups', @EventInfo as Eventinfo, @VirustypeAction as VTaction, @Leafinfo as Leafinfo
--	, @Top10 as Top10


   

   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
	and @DataFilter <> 'Inactive'
	and lower(@szGroupName1) <> 'connectstatus' 
	and lower(@szGroupName2) <> 'connectstatus' 
	and lower(@szGroupName3) <> 'connectstatus' 
	and lower(@szGroupName4) <> 'connectstatus' 
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month' -- yyyy-mm
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
		-- epo3.5 set PV = PV + SP + HF
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END

		, case right(ProductProperties.Language,2)
			when '09' then @English 
			when '07' then @German 
			when '0a' then @Spanish 
			when '0c' then @French 
			when '11' then @Japanese
			when '04' then @Chinese 
			when '12' then @Korean 
			when '10' then @Italian 
			when '1d' then @Swedish 
			when '16' then @Portuguese 
			when '13' then @Dutch 
			when '15' then @Polish 
			else ProductProperties.Language
			end as Language
    		,FullProductName =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(AVIView_Software.SoftwareName) + ' ' +
						rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
	   		END
--	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
--		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
--		 as FullProductName
	      ,  cast((rtrim(EngineVer) + ' ' +  rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,cast(@ConnectType as varchar(30)) as ConnectStatus

  		, NodeName = 
			CASE
			WHEN ReportFullPathNodeID.NodeName > '' THEN  ReportFullPathNodeID.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID


 	FROM 	
	LeafNode Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID	)
	left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--	Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID))
   	left outer Join
   	(
	ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode	
	and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	)
	)
	)
	on( leafnode.autoid = productproperties.parentid )


 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
   	AND LeafNode.Type !=24      /* Uninstalled */ 

	and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
	)
--	and  LeafNode.LastUpdate > @YYYYMMDD


	Group By
		ReportFullPathNodeID.NodeName
		,DATVer
		, substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
--		,LanguageDesc.LanguageName
 
   end

   -- This is used when you are doing a fast with grouping on connectstatus (late or current)
   else
   if lower(@szDrilldown) = 'fast' 
	and @DataFilter <> 'Inactive'
	and ( lower(@szGroupName1) = 'connectstatus' 
		or lower(@szGroupName2) = 'connectstatus' 
		or lower(@szGroupName3) = 'connectstatus' 
		or lower(@szGroupName4) = 'connectstatus' )
   begin

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
		-- epo3.5  PV = PV + SP + HF
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
		, case right(ProductProperties.Language,2)
			when '09' then @English 
			when '07' then @German 
			when '0a' then @Spanish 
			when '0c' then @French 
			when '11' then @Japanese
			when '04' then @Chinese 
			when '12' then @Korean 
			when '10' then @Italian 
			when '1d' then @Swedish 
			when '16' then @Portuguese 
			when '13' then @Dutch 
			when '15' then @Polish 
			else ProductProperties.Language
			end as Language
    		,FullProductName =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(AVIView_Software.SoftwareName) + ' ' +
						rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
	   		END
--	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
--		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
--		 as FullProductName
	      ,  cast((rtrim(EngineVer) + ' ' +  rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Current
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN ReportFullPathNodeID.NodeName > '' THEN  ReportFullPathNodeID.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID


 	FROM 		
	(LeafNode Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID) -- fetch only current computers
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode	
	and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
	    )   
	)
	)
	on( leafnode.autoid = productproperties.parentid 	)
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

	and  LeafNode.LastUpdate  >=  @YYYYMMDD  
	   	AND LeafNode.Type !=24      /* Uninstalled */ 
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )


--	and  LeafNode.LastUpdate > ''


	Group By
		ReportFullPathNodeID.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2)  
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
--		,LanguageDesc.LanguageName

   Union All

 	SELECT   

		substring(Leafnode.LastUpdate, 1, 4) as 'Year'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) as 'Month'	-- yrmo
		,cast( '' as varchar(10)) as 'Week'
		,cast( '' as varchar(10)) as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,DateName(Year, EventDateTime) as 'Year'
--		,DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) as char(5)) as 'Month' --yrmo
--		,DateName(Year, EventDateTime) + '-' + Datename(Week, EventDateTime) as 'Week' --yrwk
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' --yrqrtr
--		,cast('' as varchar(16)) as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
		-- epo3.5  PV = PV + SP + HF
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
		, case right(ProductProperties.Language,2)
			when '09' then @English 
			when '07' then @German 
			when '0a' then @Spanish 
			when '0c' then @French 
			when '11' then @Japanese
			when '04' then @Chinese 
			when '12' then @Korean 
			when '10' then @Italian 
			when '1d' then @Swedish 
			when '16' then @Portuguese 
			when '13' then @Dutch 
			when '15' then @Polish 
			else ProductProperties.Language
			end as Language
    		,FullProductName =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(AVIView_Software.SoftwareName) + ' ' +
						rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
	   		END
--	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
--		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
--		 as FullProductName
	      ,  cast((rtrim(EngineVer) + ' ' +  rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 

--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		,ConnectStatus =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN @Late
     			ELSE @NoAgent
     			END

  		, NodeName = 
			CASE
			WHEN ReportFullPathNodeID.NodeName > '' THEN  ReportFullPathNodeID.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end 
			as OSPlatform

		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, '' as  ProductCode
		, '' as NodeID


 	FROM 		
	(LeafNode Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID		)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
	and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    ) 
	)
	)
	on( leafnode.autoid = productproperties.parentid )
 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

	AND LeafNode.Type !=24      /* Uninstalled */ 
		and  (LeafNode.LastUpdate  <  @YYYYMMDD  -- fetch only late computers
			or LeafNode.LastUpdate = '' or LeafNode.LastUpdate is null )  -- fecthes no agents
		and ( 
			( @YYYYMMDD is null  or @ConnectType = 'All')  
			or
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '')
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '')	
		    )



	Group By
		ReportFullPathNodeID.NodeName
		,DATVer
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2) 
		,substring(Leafnode.LastUpdate, 1, 4) 
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 5, 2) 
--		,substring(Leafnode.LastUpdate, 1, 4) + '-' +
--			cast(((( convert(int,substring(Leafnode.LastUpdate, 5, 2)) - 1) / 3) + 1) as varchar(50))
--		,substring(ProductProperties.ExpirationDate, 1, 4) + '-' + substring(ProductProperties.ExpirationDate, 5, 2)
--		, substring(Leafnode.LastUpdate, 9, 2) 
		,EngineVer
		,ProductProperties.ProductVersion
   		,AVIView_Software.SoftwareName
   		, ExtraDATNames
  		,ComputerProperties.DomainName
      		,ComputerProperties.OSType
		,ComputerProperties.OSServicePackVer
		,ComputerProperties.OSPlatform
		, ProductProperties.Servicepack 
   		, ProductProperties.Hotfix 
		, ProductProperties.Language
		, LeafNode.AgentVersion
		, convert(int, superagent) + (convert(int, superagentrepo) * 10) 
--		,LanguageDesc.LanguageName
 

   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin

 	SELECT   

		'' as 'Year'
		,'' as 'Month'	-- yrmo
		,'' as 'Week'
		,'' as 'Quarter'
		,substring(Leafnode.LastUpdate, 1, 4) + '-' + substring(Leafnode.LastUpdate, 5, 2) + '-' + substring(Leafnode.LastUpdate, 7, 2)  as 'Day'
--		,''  as 'Day'
--		, '' as 'Hour'

   		,ProductName = 
			Case
			When AVIView_Software.SoftwareName > '' Then AVIView_Software.SoftwareName 
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
			End --as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
		-- epo3.5 PV = PV + SP + HF
    		,ProductVersion =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
	   		ELSE '---' 
	   		END
--		,'' as ProductFamily
		,ProductProperties.Servicepack as ServicePack
		,ProductProperties.Hotfix as Hotfix
--    		,CAST(EngineVersion As varchar(16)) AS EngineVersion
--    		,CAST(DATVersion as varchar(16)) As DATVersion
--		,cast('' as varchar(10)) as ExtraDATNames
   		,EngineVersion =
    			CASE 
     			WHEN ProductProperties.EngineVer  > '' THEN ProductProperties.EngineVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		,DATVersion =
    			CASE 
     			WHEN ProductProperties.DATVer  > '' THEN ProductProperties.DATVer 
     			WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     			ELSE '---' 
     			END
   		, ExtraDATNames =
    			CASE ProductProperties.ExtraDATNames 
     			WHEN 'N/A' THEN '' 
     			ELSE ProductProperties.ExtraDATNames 
     			END
		, case right(ProductProperties.Language,2)
			when '09' then @English 
			when '07' then @German 
			when '0a' then @Spanish 
			when '0c' then @French 
			when '11' then @Japanese
			when '04' then @Chinese 
			when '12' then @Korean 
			when '10' then @Italian 
			when '1d' then @Swedish 
			when '16' then @Portuguese 
			when '13' then @Dutch 
			when '15' then @Polish 
			else ProductProperties.Language
			end as Language
    		,FullProductName =
  			CASE 
	   		WHEN ProductProperties.ProductVersion > '' 
				THEN  	(rtrim(AVIView_Software.SoftwareName) + ' ' +
						rtrim(ProductProperties.ProductVersion) +
					(case
						when ServicePack > '' and (Hotfix = '' or Hotfix is null) then '.'+ServicePack 
						when Hotfix > '' and (ServicePack = '' or ServicePack is null) then '..'+Hotfix 
						when Hotfix > '' and ServicePack > '' then '.'+rtrim(ServicePack)+'.'+Hotfix 
						else '' 				
						end
					))
			Else
				Case
				When LeafNode.AgentVersion > '' Then @Unprotected 
				Else @NoAgent
				End
	   		END
--	      ,  cast((AVIView_Software.SoftwareName + ' ' + ProductProperties.ProductVersion +
--		 ' ' + ProductProperties.ServicePack + ' ' + ProductProperties.Hotfix) as varchar(50))
--		 as FullProductName
	      ,  cast((rtrim(EngineVer) + ' ' +  rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) 
			as varchar(50)) as EngineDat 
	      ,  cast((rtrim(DATVer) + ' ' + Replace( ExtraDATNames, 'N/A', '')) as varchar(50)) as DatExtraDat 


--		, '' as AgentVersion
   		,AgentVersion =
    			CASE 
     			WHEN LeafNode.AgentVersion > '' THEN LeafNode.AgentVersion
     			ELSE @NoAgent
     			END
		, AgentType = 
		  Case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			else 
			case (convert(int, SuperAgent) + (convert(int, leafnode.SuperAgentRepo) * 10) )
			when 0 then @Agent
			when 1 then @SuperAgentBroadcast
			when 10 then @SuperAgentRepository
			when 11 then @SuperAgentRepository
			else @Agent
			end	
			end
		-- do below to avoid having to group by lastupdate (returns to many rows)
		, case
			WHEN LeafNode.AgentVersion = '' THEN @NoAgent
			When LeafNode.AgentVersion is null then @NoAgent
			when LeafNode.LastUpdate  >=  @YYYYMMDD then @Current
			when LeafNode.LastUpdate  <  @YYYYMMDD  and LeafNode.LastUpdate  > '1/1/1980'  then @Late
			else @NoAgent
			end 	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN ReportFullPathNodeID.NodeName > '' THEN  ReportFullPathNodeID.NodeName
			ELSE '---'
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			else '---'
			end as Domainname
--		, cast( '' as varchar(10)) as OSVersion
      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			else '---'
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then ComputerProperties.OSPlatform
			else '---'
			end 
			as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

--		postepo3 - make sure leafnode.nodename used for computername if computerprop entry not existong (NoAgent)
--		epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
		, Leafnode.NodeName as HostName
--	   	, Case
--		When ComputerProperties.ComputerName > '' then ComputerProperties.ComputerName
--		else	LeafNode.NodeName
--		End as HostName
--		, ComputerProperties.Computername as HostName

		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
--		, cast( '' as varchar(10)) as FullNodeName
   		,cast(ReportFullPathNodeID.FullPathShortName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

		, Productproperties.ProductCode as  ProductCode
		, LeafNode.autoid as NodeID


 	FROM
	(LeafNode Join ReportFullPathNodeID on(LeafNode.ParentID = ReportFullPathNodeID.LowestNodeID)
		left outer Join ComputerProperties on(leafnode.autoid = ComputerProperties.parentid)
--		Join ReportFullPathNode on (BranchNode.AutoID = ReportFullPathNode.LowestNodeID)
	)
   	left outer Join
   	(ProductProperties Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
	and ( 
			( @ProductType = 'AntiVirus' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
			or
			( @ProductType = 'Security' and AVIView_Software.ProductFamily = 'Secure' )
			or
			( @ProductType = 'Agent' and AVIView_Software.ProductFamily = 'EPO' and AVIView_Software.ProductCode like 'EPOAGENT%')
			or
			( @ProductType = 'All' and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC', 'Secure')  
				or AVIView_Software.ProductFamily like 'TVD_NC_%' ) )
		    )   
	)
	)
	on( leafnode.autoid = productproperties.parentid )

 	WHERE  
   	(
    	@FilterID = 0 OR
     	LeafNode.ParentID = @FilterID OR
    	LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
        	where  BranchNodeEnum.StartAutoID = @FilterID)
   	)

   	AND LeafNode.Type !=24      /* Uninstalled */ 
	and ( @YYYYMMDD is null  or @ConnectType = 'All' 
		or
		( 
			(@ConnectType = 'Current' and LeafNode.LastUpdate  >=  @YYYYMMDD and LeafNode.AgentVersion > '' )
			or
			(@ConnectType = 'Late' and LeafNode.LastUpdate  <  @YYYYMMDD and LeafNode.AgentVersion > '' )
		)	
       )




   end
	
RETURN @@rowcount
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterProductEventGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterProductEventGroups]
GO


CREATE PROCEDURE dbo.AVISP_FilterProductEventGroups
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @szGroupName1  VARCHAR(100) = ''
 , @szGroupName2  VARCHAR(100) = ''
 , @szGroupName3  VARCHAR(100) = ''
 , @szGroupName4  VARCHAR(100) = ''
 , @szDrilldown	varchar(20)=''
-- , @szFastFetch varchar(20)=''
 , @AfterYYYYMMDD varchar(30) = ''
 , @AfterRule varchar(30) = ''
 , @DataFilter		varchar(255)='none'	-- inactive - means data filter > 255 chars
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      /* Get ID to filter on: Users top node, user selected filter node (< top node), */
 /*    or no filtering (0) if users top node = root node and no filter selected */
 Declare @UsersTopNodeID int
 Declare @FilterNodeID int
 Declare @ret int
 select @UsersTopNodeID = convert(int, @iNameSpaceName)
 select @FilterNodeID = convert(int, @iNameSpaceNode)


 -- determine what node tree filter this user has: either tied to their account or by the user setting a report filter
 Declare @FilterID int
 EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

 -- Build a list of ProductEvent Guids that are not tied to a leaf node
-- Truncate Table ReportLostProductEventLinks
-- Insert ReportLostProductEventLinks (NodeID)
-- select distinct NodeID
-- from ProductEvents
--	where NodeID not in (select AutoID from leafnode)
  

  /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szOPFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


	/* Stored procedure to recreate table of nodepaths and node ids */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_CalculateAllSubNodes 0, 0, '', 'GenerateOutputTable'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT

   -- Fetch Infect After date variables
   Declare @YYYYMMDD datetime
   execute dbo.AVISP_GetDateConversion @AfterYYYYMMDD, @AfterRule, @YYYYMMDD output

	------------------------------
	-- read in translated terms
   	Declare @Current varchar(30)			
   	Declare @Late varchar(30)			
   	Declare @Agent varchar(30)			
   	Declare @SuperAgentBroadcast varchar(100)	
   	Declare @SuperAgentRepository varchar(100)	
   	Declare @Unprotected varchar(30)		
   	Declare @Unlinked varchar(30)			
   	Declare @NoAgent varchar(30)	
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)	
	Declare @Professional varchar(50)	
	-- initiator types
	Declare @InitiatorType1 varchar(50)	
	Declare @InitiatorType2 varchar(50)	
	Declare @InitiatorType3 varchar(50)	
	Declare @InitiatorType4 varchar(50)	
	Declare @InitiatorType5 varchar(50)	
		

	If @Current = '' or @Current is null				-- if first is not found assume they all are
	Begin
   		Set @Current = 'Current'	Set @Late = 'Late'	Set @Agent = 'Agent'
   		Set @SuperAgentBroadcast = 'Super Agent Broadcast'	Set @SuperAgentRepository = 'Super Agent Repository'
		Set @Unprotected = 'Unprotected'	Set @Unlinked = 'Unlinked'	Set @NoAgent = 'No Agent'
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'
		Set @Professional = 'Professional'	
		Set @InitiatorType1 ='Automatic'	
		Set @InitiatorType2 ='Task'	
		Set @InitiatorType3 ='Remediation'	
		Set @InitiatorType4 ='On Demand'	
		Set @InitiatorType5 ='Rollback'	
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Current = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Current'
		Select 	@Late = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Late'
		Select 	@Agent =  'Agent'
		Select 	@SuperAgentBroadcast = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentBroadcast'
		Select 	@SuperAgentRepository = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'AgentType' and TextID = 'SuperAgentRepository'
		Select 	@Unlinked = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unlinked'
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
		-- initiator type
		Select 	@InitiatorType1 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type1'
		Select 	@InitiatorType2 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type2'
		Select 	@InitiatorType3 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type3'
		Select 	@InitiatorType4 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type4'
		Select 	@InitiatorType5 = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'InitiatorType' and TextID = 'Type5'
		Select 	@Unprotected = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'Unprotected'
		Select 	@NoAgent = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'Rulename' and TextID = 'NoAgent'
	End



	-- epo3.5 look for not FAST fields, if filtering on them set Drilldown=Drilldown (not Fast)
	-- merge group fields into one to simplify processing

	Declare @GroupFields VARCHAR(255)
	Set @GroupFields = @szGroupName1 + ' | ' + @szGroupName2 + ' | ' + @szGroupName3 + ' | ' + @szGroupName4

	Declare @FileName int
	Set @FileName = CHARINDEX( 'FileName', @DataFilter)	
	if @Filename > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @HostName int
	Set @HostName = CHARINDEX( 'HostName', @DataFilter)	
	if @HostName > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @HostIPAddress int
	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @GroupFields)	
	if @HostIPAddress = 0 	Set @HostIPAddress = CHARINDEX( 'HostIPAddress', @DataFilter)	
	if @HostIPAddress > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @UserName int
	Set @UserName = CHARINDEX( 'UserName', @DataFilter)	
	if @UserName > 0 and @szDrilldown = 'FAST'	Set @szDrilldown = 'Drilldown'

	Declare @EventDateTime int
	Set @EventDateTime = CHARINDEX( 'EventDateTime', @GroupFields)	
	if @EventDateTime = 0 	Set @EventDateTime = CHARINDEX( 'EventDateTime', @DataFilter)	
	if @EventDateTime > 0 and @szDrilldown = 'FAST' 
		Set @szDrilldown = 'Drilldown'

	


   -- If Drilldown is set, then fetch group summaries (subreport fetches detailed rows)
   if lower(@szDrilldown) = 'fast' 
   begin

 	SELECT   

		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
			-- epo3.5 Norton software table version always 7.5.0 (nap doesnt increase it)
     			WHEN ProductEvents.ProductCode = 'NORTONAV7500' THEN '7.5.0+'
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
	        ,  cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
		   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
--      		,cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
--			+ ' ' + ComputerProperties.OSPlatform)  as varchar(50)) 
--			as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then cast(ComputerProperties.OSPlatform as varchar(64))
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
		end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
		, count(*) as 'count'		-- fetch group summaries
--		, 1 as 'count'			-- fetch individual rows

--    		,(CASE @szTime
--			WHEN 'GMT' THEN EventDateTime
--			ELSE 		EventLocalDateTime
--			END) 
--		as EventDateTime
		, '' as EventDateTime
		, '' as LastContact

		,  '' as HostName
--		,  cast( HostName as varchar(50)) as HostName
		, '' as UserName
--		,  Events.UserName
		, '' as HostIPAddress
--		,  HostIPAddress
		, '' as FullNodeName
--   		,cast(ReportFullPathNode.FullPathName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, '' as NodeID
--		, NodeID
		,'' as LNAutoID
		,'' as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
		,case 
			when InitiatorType = 'Automatic' then @InitiatorType1
			when InitiatorType = 'Task' then @InitiatorType2
			when InitiatorType= 'Remediation' then @InitiatorType3
			when InitiatorType= 'OnDemand' then @InitiatorType4
			when InitiatorType= 'OnDemandRollback' then @InitiatorType5
			when InitiatorType= 'DeploymentTask' then @InitiatorType2
			when InitiatorType= 'UpdateTask' then @InitiatorType2
			when InitiatorType= 'RemediationRollback' then @InitiatorType5
			else InitiatorType
		end as InitiatorType
-- 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		, case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as varchar(128))
			when cast(ProductEvents.Error as varchar(128)) > '' then cast(ProductEvents.Error as varchar(128))
			else '---'
			end as ErrorDesc

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)
--   		ProductEvents, AVIView_Software
--		,LeafNode, BranchNode, ComputerProperties 	--ProductProperties, LanguageDesc, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')	-- remove this, want to see all eents from all products 
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--   	AND LeafNode.Type !=24      -- remove this, want to see all events 
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)

	Group By
		-- postepo3 - optimize group by ordering
		DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7) 
		,DateName(Year, EventDateTime) 
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) 
--		, substring(Leafnode.LastUpdate, 1, 4) 
--		, substring(Leafnode.LastUpdate, 5, 2) 
		, AVIView_Software.SoftwareVersion
   		, AVIView_Software.SoftwareName
--   		, AVIView_Software.SoftwareVersion 
  		,BranchNode.NodeName 
  		,ComputerProperties.DomainName
--		, ProductProperties.EngineVer
--		, ProductProperties.DATVer
 		, ProductEvents.AgentVersion  
 		, ProductName 
  		, ProductEvents.ProductCode  
 		, ProductEvents.Type  
 		, ProductEvents.Version  
 		, ProductEvents.Error
 		, ProductEvents.Locale  
 		, ProductEvents.SiteName 
 		, ProductEvents.InitiatorID  
 		, ProductEvents.InitiatorType  
		, ReportUpdateEventDesc.Description
		, ComputerProperties.OSType
	    	, ComputerProperties.OSPlatform




   end
   else		-- @szDrilldown <> 'fast'		fetch detailed computer rows
   begin


 	SELECT   


		DateName(Year, EventDateTime) as 'Year'
		,Substring(convert(char,EventDateTime,120),1,7) as 'Month' -- yyyy-mm
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2) as 'Week' -- yyyy-ww
		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime) as 'Quarter' -- yyyy-q
		, '' as 'Day'
		, '' as 'Hour'

		-- Product info
   		,AVIView_Software.SoftwareName as ProductName
--    		,CAST(ProductName As varchar(64)) AS ProductName
   		,ProductVersion =
    			CASE 
			-- epo3.5 Norton software table version always 7.5.0 (nap doesnt increase it)
     			WHEN ProductEvents.ProductCode = 'NORTONAV7500' THEN '7.5.0+'
     			WHEN AVIView_Software.SoftwareVersion > '' THEN AVIView_Software.SoftwareVersion
     			ELSE '---' 
     			END 
		,'' as ProductFamily
		,'' as ServicePack
		,'' as Hotfix
    		,'' AS EngineVersion
    		,'' As DATVersion
		,'' as ExtraDATNames
 		, cast( Locale as nvarchar(50)) as Language
    		,	CASE 
			-- epo3.5 Norton software table version always 7.5.0 (nap doesnt increase it)
     			WHEN ProductEvents.ProductCode = 'NORTONAV7500' 
				THEN cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion + '+') as varchar(50))
			else cast((AVIView_Software.SoftwareName + ' ' + AVIView_Software.SoftwareVersion) as varchar(50))
			end   as FullProductName
	      ,  '' as EngineDat 
	      ,  '' as DatExtraDat 


 		, cast( ProductEvents.AgentVersion as nvarchar(50)) as AgentVersion
		, ''	as AgentType
		, ''	as ConnectStatus


  		, NodeName = 
			CASE
			WHEN BranchNode.NodeName > '' THEN  BranchNode.NodeName
			ELSE @Unlinked
			END 
		, case
			when ComputerProperties.Domainname > '' then ComputerProperties.Domainname
			when ComputerProperties.Domainname = '' then '---'
			else @Unlinked
			end as Domainname
		, '' as OSVersion
		, case
			when ComputerProperties.OSType > '' then ComputerProperties.OSType
			when ComputerProperties.OSType = '' then '---'
			else @Unlinked
			end as OSType
		,case 
			when ComputerProperties.OSPlatform = 'Server' then @Server
			when ComputerProperties.OSPlatform = 'Workstation' then @Workstation
			when ComputerProperties.OSPlatform = 'Professional' then @Professional
			when ComputerProperties.OSPlatform > '' then cast(ComputerProperties.OSPlatform as varchar(64))
			when ComputerProperties.OSPlatform = '' then '---'
			else @Unlinked
		end as OSPlatform


		-- These fields are returned differently based on whether the report 
		-- returns group summaries or straight rows
--		, count(*) as 'count'		-- fetch group summaries
		, 1 as 'count'			-- fetch individual rows

    		,(CASE @szTime
			WHEN 'GMT' THEN EventDateTime
			ELSE 		EventLocalDateTime
			END) 
		as EventDateTime
--		, '' as EventDateTime
		, LeafNode.LastUpdate as LastContact

--		epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
		, case
--			when ComputerProperties.Computername > '' then ComputerProperties.Computername
			when LeafNode.NodeName > '' then LeafNode.NodeName
			else @Unlinked
			end as HostName
		, ComputerProperties.Username as UserName
		, ComputerProperties.IPAddress as HostIPAddress
   		, cast(ReportFullPathNodeID.FullPathShortName as varchar(255))   AS FullNodeName 

		, '' as FileName
--		,  cast( FileName as varchar(255)) as FileName

 		, cast( ProductEvents.ProductCode as nvarchar(50)) as ProductCode
		, LeafNode.autoid as NodeID
--		, NodeID
		,LeafNode.autoid as LNAutoID
		,LeafNode.parentid as LNParentID
		,'' as PPAutoID
		-- End of Group summary difference fields


		, '' as VirusName
		, '' as VirusType
		, '' as VirusSubtype
		, '' as ActionTaken
		, '' as TVDEventID
		, '' as TVDSeverity
		, '' as TVDTaskName
    		, '' as ScanTime 
		, '' as EventDesc
		
		, '' as RuleName

 		, cast( ProductEvents.Type as nvarchar(50)) as Type
 		, cast( Version as nvarchar(50)) as Version
 		, cast( Error as nvarchar(50)) as Error
 		, cast( ProductEvents.SiteName as nvarchar(100)) as SiteName
 		, cast( InitiatorID as nvarchar(50)) as InitiatorID
-- 		, cast( InitiatorType as nvarchar(50)) as InitiatorType
		,case 
			when InitiatorType = 'Automatic' then @InitiatorType1
			when InitiatorType = 'Task' then @InitiatorType2
			when InitiatorType= 'Remediation' then @InitiatorType3
			when InitiatorType= 'OnDemand' then @InitiatorType4
			when InitiatorType= 'OnDemandRollback' then @InitiatorType5
			when InitiatorType= 'DeploymentTask' then @InitiatorType2
			when InitiatorType= 'UpdateTask' then @InitiatorType2
			when InitiatorType= 'RemediationRollback' then @InitiatorType5
			else InitiatorType
		end as InitiatorType
		, case
			when ReportUpdateEventDesc.Description > '' then cast(ReportUpdateEventDesc.Description as varchar(128))
			when cast(ProductEvents.Error as varchar(128)) > '' then cast(ProductEvents.Error as varchar(128))
			else '---'
			end as ErrorDesc

	FROM 		
	(
	LeafNode Join BranchNode on (LeafNode.ParentID = BranchNode.AutoID)
	Join ReportFullPathNodeID on (BranchNode.AutoID = ReportFullPathNodeID.LowestNodeID)
   	Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Right Outer Join 
	(
	ProductEvents 
	Left Outer Join AVIView_Software on (ProductEvents.ProductCode = AVIView_Software.ProductCode)
	Left Outer Join ReportUpdateEventDesc on (ProductEvents.Error = ReportUpdateEventDesc.ErrorID
		and ReportUpdateEventDesc.LanguageID = @szFullLang )
	) on (ProductEvents.NodeID = Leafnode.AutoID)

--   		ProductEvents, AVIView_Software
--             		,LeafNode, BranchNode, ComputerProperties, ReportFullPathNode  -- LanguageDesc, ProductProperties, 
 	WHERE  
   	(
    		@FilterID = 0 OR
     		LeafNode.ParentID = @FilterID OR
    		LeafNode.ParentID in (select BranchNodeEnum.EndAutoID 
         		from BranchNodeEnum 
         		where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
--	and ProductEvents.NodeID = Leafnode.AutoID
--   	AND LeafNode.AutoID = ComputerProperties.ParentID
--   	and ProductEvents.ProductCode = AVIView_Software.ProductCode
--   	and (AVIView_Software.ProductFamily in ('TVD', 'TVD_NC')  -- want to see all events
--		or AVIView_Software.ProductFamily like 'TVD_NC_%' )  
--   	AND LeafNode.ParentID = BranchNode.AutoID
--	AND BranchNode.AutoID = ReportFullPathNode.LowestNodeID
--   	AND LeafNode.Type !=24      -- want to see all events
	and ( @YYYYMMDD is null or ProductEvents.EventDateTime >= @YYYYMMDD)




   end
	set @ret = @@rowcount
--	Drop Table #LostLinks	
RETURN @ret
END
GO

--------------

