/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.RuleEngine.Rules.Actions;

import com.nai.Mead.RuleEngine.MessageAdaptorInterface;
import com.nai.Mead.RuleEngine.Rules.MessageAdaptorMap;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetBase;
import com.nai.Mead.db.NotificationLog;
import com.nai.Mead.db.TokenList;
import com.nai.Mead.db.destination.SnmpServer;
import com.nai.Mead.util.Resource;
import com.nai.Utility.SNMPTrapClient;
import com.nai.mcafee.common.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class SNMPAction
extends NotificationTargetBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$RuleEngine$Rules$Actions$SNMPAction == null ? (class$com$nai$Mead$RuleEngine$Rules$Actions$SNMPAction = SNMPAction.class$("com.nai.Mead.RuleEngine.Rules.Actions.SNMPAction")) : class$com$nai$Mead$RuleEngine$Rules$Actions$SNMPAction));
    public static final String TYPE = "snmp";
    public static final String SERVER_TAG = "SNMPServer";
    public static final String ALERTING_BASE_OID = "1.3.6.1.4.1.3401.12.2.1.1";
    public static final String NOT_LOG_BASE_OID = "1.3.6.1.4.1.3401.12.2.1.1.4.1.1";
    public static final String TRAP_BASE_OID = "1.3.6.1.4.1.3401.12.2.1.1.4.1.1";
    public static final int TRAP_NUMBER = 1;
    public static final String[] SETTING_NAMES = new String[]{"SNMPServer", "UseNotificationRuleName", "UseSiteNodeName", "UseBranchNodePath", "UseConfiguredProductFamilies", "UseConfiguredEventCategories", "UseConfiguredThreatName", "UseFirstEventTime", "UseEventIDs", "UseEventDescriptions", "UseReceivedNumComputers", "UseReceivedNumEvents", "UseReceivedProductFamilies", "UseReceivedEventCategories", "UseReceivedThreatNames", "UseSourceComputers", "UseAffectedComputerIPs", "UseAffectedComputerNames", "UseAffectedObjects", "UseAdditionalInformation", "UseTimeNotificationSent"};
    private static final int FIRST_BOOL_SETTING = 1;
    private static final int LAST_BOOL_SETTING = 20;
    private static final HashMap m_oidMap = new HashMap();
    private SnmpServer m_server = null;
    static /* synthetic */ Class class$com$nai$Mead$RuleEngine$Rules$Actions$SNMPAction;

    public SNMPAction() {
        super(TYPE);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumSettings() {
        return SETTING_NAMES.length;
    }

    public String[] getSettingNames() {
        return SETTING_NAMES;
    }

    public String getSettingName(int n) {
        return SETTING_NAMES[n];
    }

    public void calculateProperties(Connection connection) throws SQLException {
        String string = this.getSNMPServer();
        m_log.debug((Object)("The SNMP server setting is: " + string));
        long l = Long.parseLong(string);
        this.m_server = SnmpServer.getById(connection, l);
    }

    public void validate() {
        this.m_validateError = null;
        if (this.getSNMPServer() == null) {
            this.m_validateError = "snmpaction_missing_snmp_server";
        }
        if (!(this.getUseNotificationRuleName().booleanValue() || this.getUseSiteNodeName().booleanValue() || this.getUseBranchNodePath().booleanValue() || this.getUseConfiguredProductFamilies().booleanValue() || this.getUseConfiguredEventCategories().booleanValue() || this.getUseConfiguredThreatName().booleanValue() || this.getUseFirstEventTime().booleanValue() || this.getUseEventIDs().booleanValue() || this.getUseEventDescriptions().booleanValue() || this.getUseReceivedNumComputers().booleanValue() || this.getUseReceivedNumEvents().booleanValue() || this.getUseReceivedProductFamilies().booleanValue() || this.getUseReceivedEventCategories().booleanValue() || this.getUseReceivedThreatNames().booleanValue() || this.getUseSourceComputers().booleanValue() || this.getUseAffectedComputerIPs().booleanValue() || this.getUseAffectedComputerNames().booleanValue() || this.getUseAffectedObjects().booleanValue() || this.getUseAdditionalInformation().booleanValue() || this.getUseTimeNotificationSent().booleanValue())) {
            this.m_validateError = "snmpaction_no_data_selected";
        }
    }

    public int invoke(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable, NotificationLog notificationLog, StringBuffer stringBuffer) {
        int n = 1;
        int n2 = 1;
        int n3 = 3;
        String string = "1.3.6.1.4.1.3401.12.2.1.1.4.1.1." + notificationLog.getId();
        String string2 = this.getServerAddress();
        MessageAdaptorMap messageAdaptorMap = new MessageAdaptorMap(messageAdaptorInterface, hashtable);
        try {
            String string3 = Resource.getString("propdisplay_not_available", this.getLanguage());
            String string4 = Resource.getString("common_na", this.getLanguage());
            this.sendFormattedStep(this.getListenersForThread(), n2, n3, 0, "snmpaction_connecting", new Object[]{string2}, true);
            m_log.debug((Object)(Resource.formatString("snmpaction_connecting", string2) + " with OID: " + string));
            SNMPTrapClient sNMPTrapClient = new SNMPTrapClient(string2, string, 1);
            this.sendSimpleStep(this.getListenersForThread(), n2, n3, 0, "common_success", false);
            this.sendSimpleStep(this.getListenersForThread(), ++n2, n3, 0, "snmpaction_building_pdu", true);
            int n4 = 1;
            while (n4 <= 20) {
                m_log.debug((Object)("Getting the value for setting: " + SETTING_NAMES[n4]));
                Boolean bl = (Boolean)this.getSetting(SETTING_NAMES[n4]);
                String string5 = SETTING_NAMES[n4].substring(3);
                String string6 = "{" + string5 + "}";
                String string7 = bl != false ? StringUtil.substitute((String)string6, (StringUtil.Map)messageAdaptorMap, (String)string3) : string4;
                String string8 = (String)m_oidMap.get(string5) + "." + notificationLog.getId();
                m_log.debug((Object)("OID for value: " + string5 + "=" + string8));
                m_log.debug((Object)("Adding a varBinding for OID: " + string8 + " value: " + string7));
                sNMPTrapClient.addVarBinding(string8, string7);
                ++n4;
            }
            this.sendSimpleStep(this.getListenersForThread(), n2, n3, 0, "common_success", false);
            m_log.debug((Object)"Sending the trap.");
            this.sendSimpleStep(this.getListenersForThread(), ++n2, n3, 0, "snmpaction_sending_trap", true);
            sNMPTrapClient.send();
            this.sendSimpleStep(this.getListenersForThread(), n2, n3, 0, "common_success", false);
            n = 0;
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("snmpaction_failed"), (Throwable)exception);
            this.sendFormattedStep(this.getListenersForThread(), n2, n3, 1, "common_failed", new Object[]{exception.getMessage()}, false);
            stringBuffer.append(Resource.getString("snmpaction_failed", this.getLanguage())).append(":").append(exception.getMessage());
            n = 1;
        }
        return n;
    }

    public Object getSetting(String string) {
        if (string.equals(SERVER_TAG)) {
            return super.getSetting(string);
        }
        return this.getBoolSetting(string);
    }

    private Boolean getBoolSetting(String string) {
        String string2 = (String)super.getSetting(string);
        Boolean bl = string2 == null ? new Boolean(true) : new Boolean(string2);
        return bl;
    }

    public String getSNMPServer() {
        return (String)this.getSetting(SERVER_TAG);
    }

    public void setSNMPServer(String string) {
        this.setSetting(SERVER_TAG, string);
    }

    public String getServerName() {
        String string = null;
        if (this.m_server != null) {
            string = this.m_server.getName();
        }
        return string;
    }

    public String getServerAddress() {
        String string = null;
        if (this.m_server != null) {
            string = this.m_server.getAddress();
        }
        return string;
    }

    public Boolean getUseNotificationRuleName() {
        return this.getBoolSetting(SETTING_NAMES[1]);
    }

    public void setUseNotificationRuleName(Boolean bl) {
        this.setSetting(SETTING_NAMES[1], bl.toString());
    }

    public Boolean getUseSiteNodeName() {
        return this.getBoolSetting(SETTING_NAMES[2]);
    }

    public void setUseSiteNodeName(Boolean bl) {
        this.setSetting(SETTING_NAMES[2], bl.toString());
    }

    public Boolean getUseBranchNodePath() {
        return this.getBoolSetting(SETTING_NAMES[3]);
    }

    public void setUseBranchNodePath(Boolean bl) {
        this.setSetting(SETTING_NAMES[3], bl.toString());
    }

    public Boolean getUseConfiguredProductFamilies() {
        return this.getBoolSetting(SETTING_NAMES[4]);
    }

    public void setUseConfiguredProductFamilies(Boolean bl) {
        this.setSetting(SETTING_NAMES[4], bl.toString());
    }

    public Boolean getUseConfiguredEventCategories() {
        return this.getBoolSetting(SETTING_NAMES[5]);
    }

    public void setUseConfiguredEventCategories(Boolean bl) {
        this.setSetting(SETTING_NAMES[5], bl.toString());
    }

    public Boolean getUseConfiguredThreatName() {
        return this.getBoolSetting(SETTING_NAMES[6]);
    }

    public void setUseConfiguredThreatName(Boolean bl) {
        this.setSetting(SETTING_NAMES[6], bl.toString());
    }

    public Boolean getUseFirstEventTime() {
        return this.getBoolSetting(SETTING_NAMES[7]);
    }

    public void setUseFirstEventTime(Boolean bl) {
        this.setSetting(SETTING_NAMES[7], bl.toString());
    }

    public Boolean getUseEventIDs() {
        return this.getBoolSetting(SETTING_NAMES[8]);
    }

    public void setUseEventIDs(Boolean bl) {
        this.setSetting(SETTING_NAMES[8], bl.toString());
    }

    public Boolean getUseEventDescriptions() {
        return this.getBoolSetting(SETTING_NAMES[9]);
    }

    public void setUseEventDescriptions(Boolean bl) {
        this.setSetting(SETTING_NAMES[9], bl.toString());
    }

    public Boolean getUseReceivedNumComputers() {
        return this.getBoolSetting(SETTING_NAMES[10]);
    }

    public void setUseReceivedNumComputers(Boolean bl) {
        this.setSetting(SETTING_NAMES[10], bl.toString());
    }

    public Boolean getUseReceivedNumEvents() {
        return this.getBoolSetting(SETTING_NAMES[11]);
    }

    public void setUseReceivedNumEvents(Boolean bl) {
        this.setSetting(SETTING_NAMES[11], bl.toString());
    }

    public Boolean getUseReceivedProductFamilies() {
        return this.getBoolSetting(SETTING_NAMES[12]);
    }

    public void setUseReceivedProductFamilies(Boolean bl) {
        this.setSetting(SETTING_NAMES[12], bl.toString());
    }

    public Boolean getUseReceivedEventCategories() {
        return this.getBoolSetting(SETTING_NAMES[13]);
    }

    public void setUseReceivedEventCategories(Boolean bl) {
        this.setSetting(SETTING_NAMES[13], bl.toString());
    }

    public Boolean getUseReceivedThreatNames() {
        return this.getBoolSetting(SETTING_NAMES[14]);
    }

    public void setUseReceivedThreatNames(Boolean bl) {
        this.setSetting(SETTING_NAMES[14], bl.toString());
    }

    public Boolean getUseSourceComputers() {
        return this.getBoolSetting(SETTING_NAMES[15]);
    }

    public void setUseSourceComputers(Boolean bl) {
        this.setSetting(SETTING_NAMES[15], bl.toString());
    }

    public Boolean getUseAffectedComputerIPs() {
        return this.getBoolSetting(SETTING_NAMES[16]);
    }

    public void setUseAffectedComputerIPs(Boolean bl) {
        this.setSetting(SETTING_NAMES[16], bl.toString());
    }

    public Boolean getUseAffectedComputerNames() {
        return this.getBoolSetting(SETTING_NAMES[17]);
    }

    public void setUseAffectedComputerNames(Boolean bl) {
        this.setSetting(SETTING_NAMES[17], bl.toString());
    }

    public Boolean getUseAffectedObjects() {
        return this.getBoolSetting(SETTING_NAMES[18]);
    }

    public void setUseAffectedObjects(Boolean bl) {
        this.setSetting(SETTING_NAMES[18], bl.toString());
    }

    public Boolean getUseAdditionalInformation() {
        return this.getBoolSetting(SETTING_NAMES[19]);
    }

    public void setUseAdditionalInformation(Boolean bl) {
        this.setSetting(SETTING_NAMES[19], bl.toString());
    }

    public Boolean getUseTimeNotificationSent() {
        return this.getBoolSetting(SETTING_NAMES[20]);
    }

    public void setUseTimeNotificationSent(Boolean bl) {
        this.setSetting(SETTING_NAMES[20], bl.toString());
    }

    public String getTypeForDisplay(String string) {
        return Resource.getString("snmpaction_type", string);
    }

    public String getUnLocalizedDetail() {
        return "snmpaction_detail";
    }

    public String getRecipients() {
        return this.getServerName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = TokenList.getTokenList(null);
        m_log.debug((Object)"Initializing the OID map...");
        int n = 0;
        while (n < stringArray.length) {
            int n2 = TokenList.getColumnForToken(stringArray[n]);
            if (n2 == -1) {
                n2 = 99;
            }
            String string = "1.3.6.1.4.1.3401.12.2.1.1.4.1.1." + n2;
            m_log.debug((Object)("Putting: " + stringArray[n] + " as: " + string));
            m_oidMap.put(stringArray[n], string);
            ++n;
        }
    }
}

