/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.RuleEngine.Rules;

import com.nai.Mead.RuleEngine.MessageAdaptorInterface;
import com.nai.Mead.RuleEngine.Messages.GenericMessageAdaptor;
import com.nai.Mead.RuleEngine.RuleInterface;
import com.nai.Mead.RuleEngine.RuleListenerInterface;
import com.nai.Mead.RuleEngine.Rules.IsWellFormedMessage;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetFactoryException;
import com.nai.Mead.RuleEngine.Rules.RuleBase;
import com.nai.Mead.RuleEngine.Rules.RuleLogicInterface;
import com.nai.Mead.RuleEngine.Rules.UserNotificationRule;
import com.nai.Mead.util.Resource;
import com.nai.Utility.BeanUtil;
import com.nai.Utility.Hashtable.FormattedHashtable;
import com.nai.Utility.Hashtable.FormattedTimeHashtable;
import com.nai.Utility.LocalContext;
import java.beans.ExceptionListener;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RuleLogic
implements RuleLogicInterface {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$RuleEngine$Rules$RuleLogic == null ? (class$com$nai$Mead$RuleEngine$Rules$RuleLogic = RuleLogic.class$("com.nai.Mead.RuleEngine.Rules.RuleLogic")) : class$com$nai$Mead$RuleEngine$Rules$RuleLogic));
    public static String COMPUTER_NAME_TAG = "ComputerName";
    public static String AGENT_GUID_TAG = "AgentGuid";
    public static String RULE_ID_TAG = "RuleId";
    transient boolean started;
    List falseRules;
    List trueRules;
    String ruleText;
    RuleLogicInterface containingRule = null;
    String ruleID = "" + this;
    static final long ONE_MINUTE = 60000L;
    static final String COMPUTER_ID_TAG = AGENT_GUID_TAG;
    public static String[][] aggregationTagList = new String[][]{{"EventID", "EventID"}, {"EventIDs", "EventIDs"}, {"ReceivedProductFamilies", "ReceivedProductFamilies"}, {"ReceivedEventCategories", "ReceivedEventCategories"}, {"ReceivedThreatNames", "ReceivedThreatNames"}, {"SourceComputers", "SourceComputers"}, {"AffectedComputerIPs", "AffectedComputerIPs"}, {"AffectedComputerNames", "AffectedComputerNames"}, {"AffectedObjects", "AffectedObjects"}, {"AdditionalInformation", "AdditionalInformation"}, {AGENT_GUID_TAG, AGENT_GUID_TAG}};
    long timePeriod = 60000L;
    boolean everyEvent = true;
    boolean aggregateByComputer = false;
    long computersExceed = 0L;
    boolean aggregateByEvent = false;
    long eventsExceed = 0L;
    boolean throttleNotifications = false;
    long throttlePeriod = 0L;
    long eventCount = 0L;
    long periodEnds = 0L;
    long lastSentAt = 0L;
    Timestamp firstEventTime = null;
    int state = 0;
    Hashtable aggregatedValues = new Hashtable();
    static /* synthetic */ Class class$com$nai$Mead$RuleEngine$Rules$RuleLogic;

    public RuleLogic(RuleLogicInterface ruleLogicInterface) {
        this.reset();
        this.falseRules = new LinkedList();
        this.trueRules = new LinkedList();
        this.containingRule = ruleLogicInterface;
    }

    public void start() {
        RuleListenerInterface ruleListenerInterface;
        Iterator iterator = this.falseRules.iterator();
        while (iterator.hasNext()) {
            ruleListenerInterface = (RuleListenerInterface)iterator.next();
            if (!(ruleListenerInterface instanceof RuleInterface)) continue;
            ((RuleInterface)ruleListenerInterface).start();
        }
        iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            ruleListenerInterface = (RuleListenerInterface)iterator.next();
            if (!(ruleListenerInterface instanceof RuleInterface)) continue;
            ((RuleInterface)ruleListenerInterface).start();
        }
        this.started = true;
    }

    public void stop() {
        RuleListenerInterface ruleListenerInterface;
        Iterator iterator = this.falseRules.iterator();
        while (iterator.hasNext()) {
            ruleListenerInterface = (RuleListenerInterface)iterator.next();
            if (!(ruleListenerInterface instanceof RuleInterface)) continue;
            ((RuleInterface)ruleListenerInterface).start();
        }
        iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            ruleListenerInterface = (RuleListenerInterface)iterator.next();
            if (!(ruleListenerInterface instanceof RuleInterface)) continue;
            ((RuleInterface)ruleListenerInterface).start();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean evaluateRule(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        m_log.debug((Object)"In RuleLogic evaulateRule");
        return this.containingRule.evaluate(messageAdaptorInterface, hashtable);
    }

    public boolean onMessage(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        m_log.debug((Object)"In RuleLogic onMessage.");
        return this.evaluateRule(messageAdaptorInterface, hashtable);
    }

    public boolean doFalseRules(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        Iterator iterator = this.falseRules.iterator();
        while (iterator.hasNext()) {
            ((RuleListenerInterface)iterator.next()).onMessage(messageAdaptorInterface, hashtable);
        }
        return false;
    }

    public boolean doTrueRules(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        m_log.debug((Object)"Calling true rules from RuleLogic.");
        Iterator iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            ((RuleListenerInterface)iterator.next()).onMessage(messageAdaptorInterface, hashtable);
        }
        return true;
    }

    public void updateContainingRule(RuleInterface ruleInterface) {
        this.containingRule.updateRule(ruleInterface);
    }

    public void updateMessage(RuleInterface ruleInterface) {
        m_log.debug((Object)("In update message for " + this.getClass().getName() + " rule: " + this.containingRule.getRuleID()));
        try {
            m_log.debug((Object)("Compare rules " + ruleInterface.getRuleID() + " and " + this.containingRule.getRuleID()));
            if (ruleInterface.getRuleID().equals(this.containingRule.getRuleID())) {
                m_log.debug((Object)("Updating rule " + this.containingRule.getRuleID()));
                this.updateContainingRule(ruleInterface);
            }
            Iterator iterator = this.trueRules.iterator();
            while (iterator.hasNext()) {
                ((RuleInterface)iterator.next()).updateMessage(ruleInterface);
            }
            iterator = this.falseRules.iterator();
            while (iterator.hasNext()) {
                ((RuleInterface)iterator.next()).updateMessage(ruleInterface);
            }
        }
        catch (Exception exception) {
            m_log.debug((Object)("Exception in " + this.getClass().getName() + " " + exception));
        }
        m_log.debug((Object)("Leaving update message for " + this.getClass().getName() + " rule: " + this.containingRule.getRuleID()));
    }

    public void doUpdate(RuleInterface ruleInterface) {
        ruleInterface.updateMessage(this.containingRule);
        Iterator iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            m_log.debug((Object)"Updating rule in RuleLogic.");
            ((RuleInterface)iterator.next()).doUpdate(ruleInterface);
        }
        iterator = this.falseRules.iterator();
        while (iterator.hasNext()) {
            ((RuleInterface)iterator.next()).doUpdate(ruleInterface);
        }
    }

    public void addFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.removeFalseRule(ruleListenerInterface);
        this.falseRules.add(ruleListenerInterface);
    }

    public void removeFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.falseRules.remove(ruleListenerInterface);
    }

    public void addTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.removeTrueRule(ruleListenerInterface);
        m_log.debug((Object)"Adding a true rule.");
        this.trueRules.add(ruleListenerInterface);
    }

    public void removeTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.trueRules.remove(ruleListenerInterface);
    }

    public int size() {
        int n = 1;
        Iterator iterator = this.falseRules.iterator();
        while (iterator.hasNext()) {
            n += ((RuleInterface)iterator.next()).size();
        }
        iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            n += ((RuleInterface)iterator.next()).size();
        }
        return n;
    }

    public List getTrueRules() {
        return this.trueRules;
    }

    public void setTrueRules(List list) {
        this.trueRules = list;
    }

    public List getFalseRules() {
        return this.falseRules;
    }

    public void setFalseRules(List list) {
        this.falseRules = list;
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public Object getRuleIDAsObject() {
        return this.ruleID;
    }

    public void setRuleID(String string) {
        this.ruleID = string;
    }

    public static RuleInterface loadRules(Connection connection, Connection connection2) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        RuleBase ruleBase = new RuleBase();
        UserNotificationRule[] userNotificationRuleArray = UserNotificationRule.getAllEnabledUserNotificationRules(connection, connection2);
        ruleBase.addTrueRule(new IsWellFormedMessage());
        m_log.debug((Object)("Adding " + userNotificationRuleArray.length + " rules to the list."));
        int n = 0;
        while (n < userNotificationRuleArray.length) {
            m_log.debug((Object)("Add rule " + n + ": " + userNotificationRuleArray[n].getRuleName()));
            ruleBase.addTrueRule(userNotificationRuleArray[n]);
            ++n;
        }
        m_log.debug((Object)"Done adding rules.");
        return ruleBase;
    }

    public static RuleInterface loadRules(InputStream inputStream, ExceptionListener exceptionListener) {
        RuleInterface ruleInterface = (RuleInterface)BeanUtil.readObject(inputStream, exceptionListener);
        return ruleInterface;
    }

    public static RuleInterface updateRules(RuleInterface ruleInterface, RuleInterface ruleInterface2) {
        ruleInterface2.doUpdate(ruleInterface);
        return ruleInterface;
    }

    public static RuleInterface loadRules(String string, ExceptionListener exceptionListener) {
        try {
            RuleInterface ruleInterface = (RuleInterface)BeanUtil.readObject(string, exceptionListener);
            return ruleInterface;
        }
        catch (FileNotFoundException fileNotFoundException) {
            m_log.error((Object)"", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            m_log.error((Object)"", (Throwable)iOException);
        }
        return null;
    }

    public static void saveRules(OutputStream outputStream, RuleInterface ruleInterface) {
        XMLEncoder xMLEncoder = new XMLEncoder(outputStream);
        xMLEncoder.writeObject(ruleInterface);
        xMLEncoder.close();
    }

    public static void saveRules(String string, RuleInterface ruleInterface) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            RuleLogic.saveRules(bufferedOutputStream, ruleInterface);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            m_log.error((Object)Resource.getString("rulelogic_save_failed"), (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            m_log.error((Object)Resource.getString("rulelogic_save_failed"), (Throwable)iOException);
        }
    }

    public String getRuleText() {
        return this.ruleText;
    }

    public void setRuleText(String string) {
        this.ruleText = string;
    }

    public void onTime(double d, Hashtable hashtable) {
        this.checkThrottle(d, hashtable);
        Iterator iterator = this.trueRules.iterator();
        while (iterator.hasNext()) {
            ((RuleListenerInterface)iterator.next()).onTime(d, hashtable);
        }
        Iterator iterator2 = this.falseRules.iterator();
        while (iterator2.hasNext()) {
            ((RuleListenerInterface)iterator2.next()).onTime(d, hashtable);
        }
    }

    public void setContainingRule(RuleLogicInterface ruleLogicInterface) {
        this.containingRule = ruleLogicInterface;
        this.setRuleID(ruleLogicInterface.toString());
    }

    public synchronized void reset() {
        this.periodEnds = 0L;
        this.lastSentAt = 0L;
        this.firstEventTime = null;
        this.eventCount = 0L;
        this.resetAggregation();
        this.state = 0;
    }

    private void checkThrottle(double d, Hashtable hashtable) {
        if (this.periodEnds > 0L && this.periodEnds <= System.currentTimeMillis()) {
            this.aggregateTrueEvent(null, hashtable);
        }
    }

    private void getMessageValue(MessageAdaptorInterface messageAdaptorInterface, String string, Hashtable hashtable) {
        if (messageAdaptorInterface == null || string == null || hashtable == null) {
            return;
        }
        Object object = messageAdaptorInterface.getValue(string);
        if (object != null) {
            hashtable.put(object, string);
        }
    }

    private void resetAggregation() {
        this.aggregatedValues = new Hashtable();
        this.aggregatedValues.put("FirstEventTime", new FormattedTimeHashtable());
        this.aggregatedValues.put("TimeNotificationSent", new FormattedTimeHashtable());
        this.aggregatedValues.put("ReceivedProductFamilies", new FormattedHashtable());
        this.aggregatedValues.put("ReceivedEventCategories", new FormattedHashtable());
        this.eventCount = 0L;
        this.firstEventTime = null;
    }

    private Hashtable getAggregatedValue(String string) {
        return (Hashtable)this.aggregatedValues.get(string);
    }

    private void addFieldToAggregation(String string, Object object) {
        Hashtable hashtable = this.getAggregatedValue(string);
        if (hashtable == null) {
            hashtable = new FormattedHashtable();
            this.aggregatedValues.put(string, hashtable);
        }
        hashtable.put(object, object);
    }

    private void addFieldToAggregation(MessageAdaptorInterface messageAdaptorInterface, String string, Hashtable hashtable, String string2, String string3) {
        Hashtable hashtable2;
        Object object;
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("************************\nAdding " + string + " to aggregation."));
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)"Looking in the message.");
        }
        if ((object = messageAdaptorInterface.getValue(string)) == null) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)"Not found... looking in the context map.");
            }
            object = hashtable.get(string);
        }
        if (object == null) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)"No data found... returning.");
            }
            return;
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Found the data.  Getting the current agregation map for tag: " + string2 + " and adding the new value."));
        }
        if ((hashtable2 = this.getAggregatedValue(string2)) == null) {
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)"The current aggregation map doesn't exist, creating a new map, and saving it for later.");
            }
            hashtable2 = new FormattedHashtable();
            this.aggregatedValues.put(string2, hashtable2);
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Putting the new value: " + object + " associated with the guid: " + string3));
        }
        hashtable2.put(object, string3);
    }

    private Hashtable getAffectedComputers() {
        Hashtable hashtable = (Hashtable)this.aggregatedValues.get(AGENT_GUID_TAG);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.aggregatedValues.put(AGENT_GUID_TAG, hashtable);
        }
        return hashtable;
    }

    private boolean doEventFilter(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        boolean bl = false;
        if (messageAdaptorInterface == null) {
            return false;
        }
        bl = true;
        return bl;
    }

    private boolean doEventThreshold() {
        boolean bl = false;
        bl = this.everyEvent && this.eventCount > 0L || this.aggregateByEvent && this.eventCount >= this.eventsExceed || this.aggregateByComputer && (long)this.getAffectedComputers().size() >= this.computersExceed;
        return bl;
    }

    private void doAggregateEvent(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        ++this.eventCount;
        this.setFirstEventTime();
        String string = (String)messageAdaptorInterface.getValue(AGENT_GUID_TAG);
        if (string == null) {
            string = "NO GUID AVAILABLE";
        }
        if (messageAdaptorInterface == null || string == null) {
            return;
        }
        int n = 0;
        while (n < aggregationTagList.length) {
            this.addFieldToAggregation(messageAdaptorInterface, aggregationTagList[n][0], hashtable, aggregationTagList[n][1], string);
            ++n;
        }
    }

    private void fillInAggregatedValues(Hashtable hashtable) {
        m_log.debug((Object)"Fill in aggregated values");
        m_log.debug((Object)"Fill in non-aggregated values");
        this.addFieldToAggregation("ReceivedNumComputers", new Long(this.getAffectedComputers().size()));
        this.addFieldToAggregation("ReceivedNumEvents", new Long(this.eventCount));
        this.setFirstEventTime();
        if (this.getContainingRule() instanceof UserNotificationRule) {
            Iterator iterator;
            Vector vector;
            hashtable.put(this.getContainingRule().getClass().toString(), this.getContainingRule().toString());
            UserNotificationRule userNotificationRule = (UserNotificationRule)this.getContainingRule();
            this.addFieldToAggregation("BranchNodePath", userNotificationRule.getBranchNodePath());
            this.addFieldToAggregation("SiteNodeName", userNotificationRule.getSiteNodeName());
            if (userNotificationRule.getAnyAlertFamily().booleanValue()) {
                this.addFieldToAggregation("ConfiguredProductFamilies", "common_any_productfamily");
            } else {
                vector = userNotificationRule.getAlertFamilyNames();
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    this.addFieldToAggregation("ConfiguredProductFamilies", iterator.next());
                }
            }
            if (userNotificationRule.getAnyCategory().booleanValue()) {
                this.addFieldToAggregation("ConfiguredEventCategories", "common_any_eventcategory");
            } else {
                vector = userNotificationRule.getEventCategoryNames();
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    this.addFieldToAggregation("ConfiguredEventCategories", iterator.next());
                }
            }
            this.addFieldToAggregation("ConfiguredThreatName", userNotificationRule.getConfiguredThreatName());
            this.addFieldToAggregation("NotificationRuleName", userNotificationRule.getRuleName());
            hashtable.put(UserNotificationRule.RULE_OBJECT_TAG, this.getContainingRule());
        }
        hashtable.putAll(this.aggregatedValues);
        m_log.debug((Object)"Fill in done");
    }

    private Hashtable createNewAggContext(Hashtable hashtable) {
        LocalContext localContext = new LocalContext(hashtable);
        this.fillInAggregatedValues(localContext);
        this.resetAggregation();
        return localContext;
    }

    private void doDeliverAggregatedEvent(Hashtable hashtable) {
        GenericMessageAdaptor genericMessageAdaptor = new GenericMessageAdaptor();
        m_log.debug((Object)"Send Notification");
        this.doTrueRules(genericMessageAdaptor, hashtable);
    }

    private void setFirstEventTime() {
        if (this.firstEventTime == null) {
            this.firstEventTime = new Timestamp(System.currentTimeMillis());
            this.addFieldToAggregation("FirstEventTime", new Long(this.firstEventTime.getTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aggregateTrueEvent(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl = false;
        Hashtable hashtable2 = null;
        RuleLogic ruleLogic = this;
        synchronized (ruleLogic) {
            switch (this.state) {
                case 0: {
                    m_log.debug((Object)"IDLE");
                    if (messageAdaptorInterface == null) {
                        this.periodEnds = 0L;
                        break;
                    }
                    m_log.debug((Object)"Rule state is: (IDLE)");
                    if (this.doEventFilter(messageAdaptorInterface, hashtable)) {
                        m_log.debug((Object)"Rule state is: (IDLE)");
                        n = 1;
                        m_log.debug((Object)"Next state is AGGREGATE");
                        this.periodEnds = l + this.timePeriod;
                        this.setFirstEventTime();
                    } else {
                        this.periodEnds = 0L;
                        break;
                    }
                }
                case 1: {
                    n = 1;
                    m_log.debug((Object)"AGGREGATE");
                    if (messageAdaptorInterface == null) {
                        if (this.periodEnds <= 0L || this.periodEnds > l) break;
                        this.resetAggregation();
                        this.periodEnds = 0L;
                        n = 0;
                        m_log.debug((Object)"Next state is IDLE");
                        break;
                    }
                    m_log.debug((Object)"Rule state is: (AGGREGATE)");
                    if (this.doEventFilter(messageAdaptorInterface, hashtable)) {
                        this.doAggregateEvent(messageAdaptorInterface, hashtable);
                    }
                    if (!this.doEventThreshold()) break;
                    m_log.debug((Object)"Deliver possibly aggregated (AGGREGATE) event");
                    hashtable2 = this.createNewAggContext(hashtable);
                    bl = true;
                    if (this.throttleNotifications) {
                        n = 2;
                        m_log.debug((Object)"Next state is THROTTLE");
                        this.periodEnds = l + this.throttlePeriod;
                        break;
                    }
                    n = 1;
                    m_log.debug((Object)"Next state is AGGREGATE");
                    this.periodEnds = l + this.timePeriod;
                    break;
                }
                case 2: {
                    n = 2;
                    m_log.debug((Object)"THROTTLE");
                    if (messageAdaptorInterface == null) {
                        if (this.periodEnds <= 0L || this.periodEnds > l) break;
                        if (this.doEventThreshold()) {
                            m_log.debug((Object)"Deliver aggregated (Throttled) event");
                            hashtable2 = this.createNewAggContext(hashtable);
                            bl = true;
                            this.periodEnds = l + this.throttlePeriod;
                            break;
                        }
                        m_log.debug((Object)"Reset Aggregation");
                        this.resetAggregation();
                        this.periodEnds = 0L;
                        n = 0;
                        m_log.debug((Object)"Next state is IDLE");
                        break;
                    }
                    m_log.debug((Object)"Rule state is: (THROTTLE)");
                    if (!this.doEventFilter(messageAdaptorInterface, hashtable)) break;
                    if (this.periodEnds == 0L) {
                        this.periodEnds = l + this.throttlePeriod;
                    }
                    this.doAggregateEvent(messageAdaptorInterface, hashtable);
                }
            }
            this.state = n;
        }
        if (hashtable2 != null) {
            this.doDeliverAggregatedEvent(hashtable2);
        }
        return bl;
    }

    public long getComputersExceed() {
        return this.computersExceed;
    }

    public RuleLogicInterface getContainingRule() {
        return this.containingRule;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public long getEventsExceed() {
        return this.eventsExceed;
    }

    public boolean isEveryEvent() {
        return this.everyEvent;
    }

    public long getPeriodEnds() {
        return this.periodEnds;
    }

    public long getTimePeriod() {
        return this.timePeriod;
    }

    public void setComputersExceed(long l) {
        if (this.computersExceed != l) {
            this.computersExceed = l;
            this.reset();
        }
    }

    public void setEventsExceed(long l) {
        if (this.eventsExceed != l) {
            this.eventsExceed = l;
            this.reset();
        }
    }

    public void setEveryEvent(boolean bl) {
        if (this.everyEvent != bl) {
            this.everyEvent = bl;
            this.reset();
        }
    }

    public void setTimePeriod(long l) {
        if (this.timePeriod != l) {
            this.timePeriod = l;
            this.reset();
        }
    }

    public boolean hasAccumulatedData() {
        return this.eventCount > 0L || this.getAffectedComputers().size() > 0;
    }

    public void setThrottle(boolean bl) {
        if (this.throttleNotifications != bl) {
            this.throttleNotifications = bl;
            this.reset();
        }
    }

    public void setThrottleTimePeriod(long l) {
        if (this.throttlePeriod != l) {
            this.throttlePeriod = l;
            this.reset();
        }
    }

    public boolean evaluate(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        return false;
    }

    public void setAggregateByComputers(boolean bl) {
        if (this.aggregateByComputer != bl) {
            this.aggregateByComputer = bl;
            this.reset();
        }
    }

    public void setAggregateByEvents(boolean bl) {
        if (this.aggregateByEvent != bl) {
            this.aggregateByEvent = bl;
            this.reset();
        }
    }

    public void updateRule(RuleInterface ruleInterface) {
        this.updateRuleLogic((RuleLogic)ruleInterface);
    }

    public void updateRuleLogic(RuleLogic ruleLogic) {
        m_log.debug((Object)("Updating this rule. " + ruleLogic.containingRule.getRuleID()));
        ruleLogic.started = this.started;
        ruleLogic.ruleText = this.ruleText;
        ruleLogic.ruleID = this.ruleID;
        ruleLogic.timePeriod = this.timePeriod;
        ruleLogic.everyEvent = this.everyEvent;
        ruleLogic.aggregateByComputer = this.aggregateByComputer;
        ruleLogic.computersExceed = this.computersExceed;
        ruleLogic.aggregateByEvent = this.aggregateByEvent;
        ruleLogic.eventsExceed = this.eventsExceed;
        ruleLogic.throttleNotifications = this.throttleNotifications;
        ruleLogic.throttlePeriod = this.throttlePeriod;
        ruleLogic.eventCount = this.eventCount;
        ruleLogic.firstEventTime = this.firstEventTime;
        ruleLogic.aggregatedValues = this.aggregatedValues;
        ruleLogic.periodEnds = this.periodEnds;
        ruleLogic.lastSentAt = this.lastSentAt;
        ruleLogic.state = this.state;
        m_log.debug((Object)"Updated rules. ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class State {
        static final int IDLE = 0;
        static final int AGGREGATE = 1;
        static final int THROTTLE = 2;
    }
}

