/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Utility;

import com.nai.Mead.util.Progress;
import com.nai.Mead.util.ProgressListener;
import com.nai.Mead.util.Resource;
import com.nai.Utility.MailClientException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class MailClient
implements Progress {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Utility$MailClient == null ? (class$com$nai$Utility$MailClient = MailClient.class$("com.nai.Utility.MailClient")) : class$com$nai$Utility$MailClient));
    private String m_mailServer;
    private int m_port = 25;
    private List m_recipients;
    private String m_sender;
    private String m_subject = "";
    private String m_body = "";
    private String m_priority = "";
    private ArrayList m_progListeners = new ArrayList();
    private static final int NUM_STEPS = 7;
    private int m_errNo = -1;
    static /* synthetic */ Class class$com$nai$Utility$MailClient;

    public MailClient() {
    }

    public MailClient(String string, List list, String string2, String string3, String string4) {
        this.m_mailServer = string;
        this.m_recipients = list;
        this.m_sender = string2;
        this.m_subject = string3;
        this.m_body = string4;
    }

    public void send() throws MailClientException, IOException {
        m_log.debug((Object)"Sending email");
        int n = 1;
        Socket socket = new Socket();
        try {
            try {
                String[] stringArray;
                CharSequence charSequence;
                Object object;
                this.dispatchSimpleProgress(n, "mailclient_validating", true, true);
                m_log.debug((Object)"Validating data");
                this.validateData();
                this.dispatchSimpleProgress(n, "common_success", false, true);
                this.dispatchFormattedProgress(++n, "mailclient_connecting", new Object[]{this.m_mailServer, new Integer(this.m_port)}, true, true);
                m_log.debug((Object)"Connecting to the server.");
                socket.connect(new InetSocketAddress(this.m_mailServer, this.m_port));
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.readAndVerifyResponse(bufferedReader, 220);
                this.dispatchSimpleProgress(n, "common_success", false, true);
                this.dispatchSimpleProgress(++n, "mailclient_helo", true, true);
                String string = "HELO " + socket.getLocalAddress().getHostName() + "\r\n";
                m_log.debug((Object)("Sending HELO: " + string));
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
                this.readAndVerifyResponse(bufferedReader, 250);
                this.dispatchSimpleProgress(n, "common_success", false, true);
                this.dispatchSimpleProgress(++n, "mailclient_from", true, true);
                String string2 = "MAIL FROM: <" + this.m_sender + ">\r\n";
                m_log.debug((Object)("Sending MAIL FROM: " + string2));
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
                this.readAndVerifyResponse(bufferedReader, 250);
                this.dispatchSimpleProgress(n, "common_success", false, true);
                ListIterator listIterator = this.m_recipients.listIterator();
                this.dispatchSimpleProgress(++n, "mailclient_rcpt", true, true);
                while (listIterator.hasNext()) {
                    object = listIterator.next();
                    if (object == null) continue;
                    charSequence = object.toString();
                    m_log.debug((Object)("Setting mail RCPT TO: <" + charSequence + ">"));
                    if (charSequence.length() <= 0) continue;
                    stringArray = "RCPT TO: <" + charSequence + ">";
                    m_log.debug((Object)("Sending RCPT: " + (String)stringArray));
                    outputStreamWriter.write((String)stringArray);
                    outputStreamWriter.write("\r\n");
                    outputStreamWriter.flush();
                    this.readAndVerifyResponse(bufferedReader, 250);
                }
                this.dispatchSimpleProgress(n, "common_success", false, true);
                this.dispatchSimpleProgress(++n, "mailclient_sending", true, true);
                m_log.debug((Object)"Sending message.");
                outputStreamWriter.write("DATA\r\n");
                outputStreamWriter.flush();
                this.readAndVerifyResponse(bufferedReader, 354);
                outputStreamWriter.write("Content-type: text/plain; charset=UTF-8\r\n");
                outputStreamWriter.write("Content-Transfer-Encoding: 8bit\r\n");
                if ("0".equals(this.m_priority)) {
                    outputStreamWriter.write("X-Priority: 5 (Lowest)\r\n");
                    outputStreamWriter.write("X-MSMail-Priority: Low\r\n");
                    outputStreamWriter.write("Importance: Low\r\n");
                } else if ("2".equals(this.m_priority)) {
                    outputStreamWriter.write("X-Priority: 1 (Highest)\r\n");
                    outputStreamWriter.write("X-MSMail-Priority: High\r\n");
                    outputStreamWriter.write("Importance: High\r\n");
                }
                outputStreamWriter.write("From: \"" + this.m_sender + "\" <" + this.m_sender + ">\r\n");
                object = new StringBuffer();
                listIterator = this.m_recipients.listIterator();
                while (listIterator.hasNext()) {
                    charSequence = listIterator.next();
                    if (charSequence == null || (stringArray = charSequence.toString()).length() <= 0) continue;
                    if (((StringBuffer)object).length() != 0) {
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append("\"" + (String)stringArray + "\"<").append((String)stringArray).append(">");
                }
                outputStreamWriter.write("To: " + ((StringBuffer)object).toString() + "\r\n");
                if (this.m_subject != null && this.m_subject.length() > 0) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("Subject: =?UTF-8?B?");
                    stringArray = new BASE64Encoder().encodeBuffer(this.m_subject.getBytes("UTF-8")).split("\n");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        ((StringBuffer)charSequence).append(stringArray[n2].trim());
                        ++n2;
                    }
                    ((StringBuffer)charSequence).append("?=\r\n");
                    m_log.debug((Object)((StringBuffer)charSequence).toString());
                    outputStreamWriter.write(((StringBuffer)charSequence).toString());
                } else {
                    outputStreamWriter.write("Subject: \r\n");
                }
                outputStreamWriter.write("\r\n" + this.m_body);
                outputStreamWriter.write("\r\n.\r\n");
                outputStreamWriter.flush();
                this.readAndVerifyResponse(bufferedReader, 250);
                this.dispatchSimpleProgress(n, "common_success", false, true);
                this.dispatchSimpleProgress(++n, "mailclient_disconnecting", true, true);
                outputStreamWriter.write("QUIT\r\n");
                outputStreamWriter.flush();
                this.readAndVerifyResponse(bufferedReader, 221);
                m_log.debug((Object)"Done.");
                this.dispatchSimpleProgress(n, "common_success", false, true);
                ++n;
            }
            catch (UnknownHostException unknownHostException) {
                this.dispatchFormattedProgress(n, "mailclient_unabletoresolve", new Object[]{unknownHostException.getMessage()}, false, false);
                throw unknownHostException;
            }
            catch (IOException iOException) {
                this.dispatchFormattedProgress(n, "common_failed", new Object[]{iOException.getMessage()}, false, false);
                throw iOException;
            }
            catch (MailClientException mailClientException) {
                this.dispatchFormattedProgress(n, "common_failed", new Object[]{mailClientException.getMessage()}, false, false);
                throw mailClientException;
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            socket.close();
            throw throwable;
        }
        socket.close();
    }

    private void validateData() throws MailClientException {
        if (this.m_mailServer == null || this.m_recipients == null || this.m_sender == null || this.m_body == null) {
            throw new MailClientException("Internal Error: MailClient not configured properly before send()");
        }
        if (this.m_recipients.size() == 0) {
            throw new MailClientException(Resource.getString("mailclient_failed_no_recipients"));
        }
    }

    private void readAndVerifyResponse(BufferedReader bufferedReader, int n) throws MailClientException, IOException {
        String string = bufferedReader.readLine();
        this.m_errNo = this.getResult(string);
        if (this.m_errNo != n) {
            throw new MailClientException(Resource.formatString("mailclient_bad_response", string));
        }
    }

    private int getResult(String string) {
        return Integer.parseInt(string.substring(0, string.indexOf(" ")));
    }

    public String getMailServer() {
        return this.m_mailServer;
    }

    public void setMailServer(String string) {
        this.m_mailServer = string;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public List getRecipients() {
        return this.m_recipients;
    }

    public void setRecipients(List list) {
        this.m_recipients = list;
    }

    public String getSender() {
        return this.m_sender;
    }

    public void setSender(String string) {
        this.m_sender = string;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String string) {
        this.m_subject = string;
    }

    public String getBody() {
        return this.m_body;
    }

    public void setBody(String string) {
        this.m_body = string;
    }

    public String getPriority() {
        return this.m_priority;
    }

    public void setPriority(String string) {
        this.m_priority = string;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.m_progListeners.add(progressListener);
        m_log.debug((Object)("Adding progress listener: " + progressListener + " size is now: " + this.m_progListeners.size()));
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.m_progListeners.remove(progressListener);
        m_log.debug((Object)("Removing progress listener: " + progressListener + " size is now: " + this.m_progListeners.size()));
    }

    private void dispatchFormattedProgress(int n, String string, Object[] objectArray, boolean bl, boolean bl2) {
        Iterator iterator = this.m_progListeners.iterator();
        while (iterator.hasNext()) {
            ProgressListener progressListener = (ProgressListener)iterator.next();
            String string2 = Resource.formatString(string, objectArray, progressListener.getLanguage());
            this.dispatchProgress(progressListener, n, string2, bl, bl2);
        }
    }

    private void dispatchSimpleProgress(int n, String string, boolean bl, boolean bl2) {
        Iterator iterator = this.m_progListeners.iterator();
        while (iterator.hasNext()) {
            ProgressListener progressListener = (ProgressListener)iterator.next();
            String string2 = Resource.getString(string, progressListener.getLanguage());
            this.dispatchProgress(progressListener, n, string2, bl, bl2);
        }
    }

    private void dispatchProgress(ProgressListener progressListener, int n, String string, boolean bl, boolean bl2) {
        m_log.debug((Object)("Dispatching progress to pl: " + progressListener));
        if (bl) {
            progressListener.startStep(n, 7, string);
        } else {
            progressListener.endStep(n, bl2 ? 0 : 1, string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

