/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.action.concrete;

import com.nai.mcafee.common.db.destination.Contact;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionImplBase;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.notification.MailClient;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;

public class EmailAction
extends ActionImplBase {
    public static final String TYPE = "smtp";
    public static final String[] PARAM_NAMES = new String[]{"ContactID", "Subject", "Body"};
    private int m_contactID = -1;
    private String m_subject = "";
    private String m_body = "";

    public static final int countActionsWithContact(Connection connection, long l) {
        return Contact.countContactUses((Connection)connection, (long)l);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return PARAM_NAMES.length;
    }

    public String getPropertyName(int n) {
        return PARAM_NAMES[n];
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        MailClient mailClient = new MailClient();
        Contact contact = this.getContact(ActionEnvironment.instance().getContacts(), this.m_contactID);
        actionStatus.setActionDetail(contact.getName());
        if (contact == null) {
            throw new ActionInvocationException(Resource.formatString("emailaction_template_invalid_id", this.m_contactID));
        }
        Configuration configuration = ActionEnvironment.instance().getConfiguration();
        mailClient.setRecipient(contact.getEmailAddress(), contact.getName());
        mailClient.setMailServer(configuration.getEmailServer());
        mailClient.setSender(configuration.getEmailAddress(), configuration.getEmailName());
        StringUtil.Map map = actionContext.getMap();
        String string = StringUtil.substitute((String)this.m_subject, (StringUtil.Map)map);
        String string2 = StringUtil.substitute((String)this.m_body, (StringUtil.Map)map);
        mailClient.setSubject(string);
        mailClient.setBody(string2);
        try {
            mailClient.send();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            throw new ActionInvocationException(Resource.formatString("emailaction_template_notification_failed", stringWriter.toString()));
        }
        return 0;
    }

    private Contact getContact(Contact[] contactArray, int n) {
        int n2 = 0;
        while (n2 < contactArray.length) {
            if (contactArray[n2].getId() == (long)n) {
                return contactArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_email";
    }

    public String toString() {
        ActionEnvironment actionEnvironment = ActionEnvironment.instance();
        Contact contact = null;
        if (actionEnvironment != null) {
            contact = this.getContact(actionEnvironment.getContacts(), this.m_contactID);
        }
        if (contact != null) {
            return Resource.formatString("emailaction_template_send_email", contact.getEmailAddress());
        }
        return "<Send email>";
    }

    public String getBody() {
        return this.m_body;
    }

    public void setBody(String string) {
        this.m_body = string;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String string) {
        this.m_subject = string;
    }

    public int getContactID() {
        return this.m_contactID;
    }

    public void setContactID(int n) {
        this.m_contactID = n;
    }

    public void setContactID(Integer n) {
        this.m_contactID = n;
    }
}

