/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.db.HNSParameterizer;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.server.Server;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;

public class EventLog
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_CREATE_TIME = 2;
    public static final int COL_TYPE = 3;
    public static final int COL_SRCHOST_ID = 4;
    public static final int COL_SRCNET_ID = 5;
    public static final int COL_SRCSEN_ID = 6;
    public static final int COL_ARCHIVE = 7;
    public static final int COL_ACTION_COUNT = 8;
    public static final int NUM_COLUMNS = 8;
    public static final int COL_H_FRIENDLY_NAME = 9;
    public static final int COL_N_NETWORK_ADDRESS = 10;
    public static final int COL_N_SUBNET_MASK = 11;
    public static final int COL_S_SENSOR_NAME = 12;
    public static final int PROP_FORMATTED_CREATE_TIME = 13;
    public static final int PROP_TYPE_STRING = 14;
    public static final int PROP_NETWORK_AND_MASK = 15;
    public static final int INVALID_ID = -1;
    public static final String[] PROPERTY_NAMES = new String[]{"", "EventLogId", "CreateTime", "Type", "SourceHostId", "SourceNetworkId", "SourceSensorId", "Archive", "ActionCount", "SourceHostName", "SourceSubnetAddress", "SourceSubnetMask", "SourceSensorName", "FormattedCreateTime", "TypeString", "NetworkAndMask"};
    private int m_id = -1;
    private Timestamp m_createTime = new Timestamp(System.currentTimeMillis());
    private int m_type = 0;
    private Integer m_hid = null;
    private Integer m_nid = null;
    private Integer m_sid = null;
    private boolean m_archive = false;
    private String m_srcHostName = null;
    private String m_srcNetAddr = null;
    private String m_srcNetMask = null;
    private String m_srcSensorName = null;
    private int m_actionCount = 0;
    private HNSParameterizer m_paramMap = new HNSParameterizer();
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$EventLog;

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public int getNumProperties() {
        return PROPERTY_NAMES.length;
    }

    public static final void removeHostReference(Connection connection, int n) throws SQLException {
        DatabaseUtil.executeUpdate((Connection)connection, (String)("update EventLog set SourceHostId=null where SourceHostId=" + n));
    }

    public static EventLog getById(Connection connection, int n) throws SQLException {
        EventLog[] eventLogArray = EventLog.getByQuery(connection, "select * from EventLog where EventLogId = '" + n + "'");
        if (eventLogArray.length == 0) {
            return null;
        }
        if (eventLogArray.length > 1) {
            throw new SQLException("EventLog.getByID() returned more than one EventLog! More than one object in the database has the same ID.  Please contact McAfee Customer Support for assistance resolving this situation.");
        }
        return eventLogArray[0];
    }

    public static final void deleteByID(Connection connection, int n) throws SQLException {
        EventLog.deleteByID(connection, Integer.toString(n));
    }

    public static final void deleteByID(Connection connection, String string) throws SQLException {
        DatabaseUtil.executeUpdate((Connection)connection, (String)("update EventLog set Archive='1' where EventLogId=" + string));
    }

    public static final EventLog[] getByQuery(Connection connection, String string) throws SQLException {
        return EventLog.getByQuery(connection, string, 1, -1);
    }

    public static final EventLog[] getByQuery(Connection connection, String string, int n, int n2) throws SQLException {
        Object object;
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$mcafee$snowcap$db$EventLog == null ? (class$com$nai$mcafee$snowcap$db$EventLog = EventLog.class$("com.nai.mcafee.snowcap.db.EventLog")) : class$com$nai$mcafee$snowcap$db$EventLog), (int)n, (int)n2);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (EventLog)((Object)iterator.next());
            ((EventLog)((Object)object)).calculateProperties(connection);
        }
        object = new EventLog[]{};
        object = vector.toArray((T[])object);
        return object;
    }

    public EventLog() {
    }

    public EventLog(int n) {
        this.m_type = n;
        this.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    public EventLog(int n, int n2, int n3, int n4) {
        this.m_type = n;
        this.m_hid = new Integer(n2);
        this.m_nid = new Integer(n3);
        this.m_sid = new Integer(n4);
        this.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    public EventLog(int n, Integer n2, Integer n3, Integer n4) {
        this.m_type = n;
        this.m_hid = n2;
        this.m_nid = n3;
        this.m_sid = n4;
        this.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    public String getInsertSql() {
        return "insert into EventLog VALUES(?,?,?,?,?,?,?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (Timestamp)this.m_createTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (int)this.m_type);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (Integer)this.m_hid);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (Integer)this.m_nid);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (Integer)this.m_sid);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (boolean)this.m_archive);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (int)this.m_actionCount);
    }

    public String getUpdateSql() {
        return "update EventLog set CreateTime=?, Type=?, SourceHostId=?, SourceNetworkId=?, SourceSensorId=?, Archive=?, ActionCount=? where EventLogId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (int)this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.m_createTime = resultSet.getTimestamp(2);
        this.m_type = resultSet.getInt(3);
        this.m_hid = this.getInt(resultSet, 4);
        this.m_nid = this.getInt(resultSet, 5);
        this.m_sid = this.getInt(resultSet, 6);
        this.m_archive = resultSet.getBoolean(7);
        this.m_actionCount = resultSet.getInt(8);
        if (resultSet.getMetaData().getColumnCount() > 8) {
            this.m_srcHostName = resultSet.getString(9);
            this.m_srcNetAddr = resultSet.getString(10);
            this.m_srcNetMask = resultSet.getString(11);
            this.m_srcSensorName = resultSet.getString(12);
        }
    }

    public void add(Connection connection) throws SQLException {
        this.add(connection, true);
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        this.countActions(connection);
        super.add(connection, bl);
    }

    public void calculateProperties(Connection connection) throws SQLException {
        this.countActions(connection);
        this.loadParamMap(connection);
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public Timestamp getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Timestamp timestamp) {
        this.m_createTime = timestamp;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public Integer getHostId() {
        return this.m_hid;
    }

    public void setHostId(Integer n) {
        if (n != -1) {
            this.m_hid = n;
        }
        this.m_hid = n;
    }

    public void setHostId(int n) {
        this.m_hid = n != -1 ? new Integer(n) : null;
    }

    public Integer getNetworkId() {
        return this.m_nid;
    }

    public void setNetworkId(Integer n) {
        if (n != -1) {
            this.m_nid = n;
        }
        this.m_nid = n;
    }

    public void setNetworkId(int n) {
        this.m_nid = n != -1 ? new Integer(n) : null;
    }

    public Integer getSensorId() {
        return this.m_sid;
    }

    public void setSensorId(Integer n) {
        if (n != -1) {
            this.m_sid = n;
        }
        this.m_sid = n;
    }

    public void setSensorId(int n) {
        this.m_sid = n != -1 ? new Integer(n) : null;
    }

    public boolean getArchive() {
        return this.m_archive;
    }

    public void setArchive(boolean bl) {
        this.m_archive = bl;
    }

    public void setSourceHostName(String string) {
        this.m_srcHostName = string;
    }

    public String getSourceHostName() {
        if (this.m_srcHostName != null) {
            return this.m_srcHostName;
        }
        Host host = this.m_paramMap.getHost();
        if (host != null) {
            return host.getFriendlyName();
        }
        return null;
    }

    public void setSourceSubnetAddress(String string) {
        this.m_srcNetAddr = string;
    }

    public String getSourceSubnetAddress() {
        return this.m_srcNetAddr;
    }

    public void setSourceSubnetMask(String string) {
        this.m_srcNetMask = string;
    }

    public String getSourceSubnetMask() {
        return this.m_srcNetMask;
    }

    public String getNetworkAndMask() {
        if (this.m_srcNetAddr != null) {
            return this.m_srcNetAddr + StringUtil.getShortNetmask((String)this.m_srcNetMask);
        }
        Network network = this.m_paramMap.getNetwork();
        if (network != null) {
            return network.getAddressAndMask();
        }
        return null;
    }

    public void setSourceSensorName(String string) {
        this.m_srcSensorName = string;
    }

    public String getSourceSensorName() {
        if (this.m_srcSensorName != null) {
            return this.m_srcSensorName;
        }
        Sensor sensor = this.m_paramMap.getSensor();
        if (sensor != null) {
            return sensor.getSensorName();
        }
        return null;
    }

    public int getActionCount() {
        return this.m_actionCount;
    }

    public static final String formatTimestamp(Timestamp timestamp) {
        return StringUtil.formatDateTime((Timestamp)timestamp, (int)2, (int)1, (String)Server.getDefaultLocale());
    }

    public String getFormattedCreateTime() {
        return EventLog.formatTimestamp(this.m_createTime);
    }

    public void countActions(Connection connection) throws SQLException {
        String string;
        int n;
        if (this.m_id != -1 && (n = DatabaseUtil.countRows((Connection)connection, (String)"ActionStatus", (String)(string = "where " + PROPERTY_NAMES[1] + "=" + this.m_id + " and Archive!=1"))) != this.m_actionCount) {
            this.m_actionCount = n;
            this.update(connection);
        }
    }

    public void loadParamMap(Connection connection) throws SQLException {
        Integer n = this.m_hid != null ? this.m_hid : new Integer(-1);
        Integer n2 = this.m_nid != null ? this.m_nid : new Integer(-1);
        Integer n3 = this.m_sid != null ? this.m_sid : new Integer(-1);
        this.m_paramMap.loadParamMap(connection, n, n2, n3);
    }

    public HNSParameterizer getParameterizer() {
        return this.m_paramMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

