/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.notification;

import com.nai.mcafee.snowcap.notification.MailClientException;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import sun.misc.BASE64Encoder;

public class MailClient {
    private String m_mailServer = "";
    private int m_port = 25;
    private String m_recipient = "";
    private String m_recipientDisplayName = "";
    private String m_sender = "";
    private String m_senderDisplayName = "";
    private String m_subject = "";
    private String m_body = "";

    public MailClient() {
    }

    public MailClient(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.m_mailServer = string;
        this.m_recipient = string2;
        this.m_recipientDisplayName = string3;
        this.m_sender = string4;
        this.m_senderDisplayName = string5;
        this.m_subject = string6;
        this.m_body = string7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws MailClientException, IOException {
        Socket socket = new Socket(this.m_mailServer, this.m_port);
        this.validateData();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.readAndVerifyResponse(bufferedReader, 220);
            outputStreamWriter.write("HELO " + socket.getLocalAddress().getHostName() + "\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 250);
            outputStreamWriter.write("MAIL FROM: <" + this.m_sender + ">\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 250);
            outputStreamWriter.write("RCPT TO: <" + this.m_recipient + ">\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 250);
            outputStreamWriter.write("DATA\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 354);
            outputStreamWriter.write("Content-type: text/plain; charset=UTF-8\r\n");
            outputStreamWriter.write("Content-Transfer-Encoding: 8bit\r\n");
            outputStreamWriter.write("From: \"" + this.m_senderDisplayName + "\" <" + this.m_sender + ">\r\n");
            outputStreamWriter.write("To: \"" + this.m_recipientDisplayName + "\" <" + this.m_recipient + ">\r\n");
            if (this.m_subject != null && this.m_subject.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Subject: =?UTF-8?B?");
                String[] stringArray = new BASE64Encoder().encodeBuffer(this.m_subject.getBytes("UTF-8")).split("\n");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n].trim());
                    ++n;
                }
                stringBuffer.append("?=\r\n");
                outputStreamWriter.write(stringBuffer.toString());
            } else {
                outputStreamWriter.write("Subject: \r\n");
            }
            outputStreamWriter.write("\r\n" + this.m_body);
            outputStreamWriter.write("\r\n.\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 250);
            outputStreamWriter.write("QUIT\r\n");
            outputStreamWriter.flush();
            this.readAndVerifyResponse(bufferedReader, 221);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            socket.close();
            throw throwable;
        }
        socket.close();
    }

    private void validateData() throws MailClientException {
        if (this.m_mailServer == null || this.m_recipient == null || this.m_sender == null || this.m_subject == null || this.m_body == null) {
            throw new MailClientException(Resource.getString("mailclient_not_configured"));
        }
        if (this.m_recipientDisplayName == null || this.m_recipientDisplayName.equals("")) {
            this.m_recipientDisplayName = this.m_recipient;
        }
        if (this.m_senderDisplayName == null || this.m_senderDisplayName.equals("")) {
            this.m_senderDisplayName = this.m_sender;
        }
    }

    private void readAndVerifyResponse(BufferedReader bufferedReader, int n) throws MailClientException, IOException {
        String string = bufferedReader.readLine();
        if (this.getResult(string) != n) {
            throw new MailClientException(Resource.formatString("mailclient_template_unexpected_response", string));
        }
    }

    private int getResult(String string) {
        return Integer.parseInt(string.substring(0, string.indexOf(" ")));
    }

    public String getMailServer() {
        return this.m_mailServer;
    }

    public void setMailServer(String string) {
        this.m_mailServer = string;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) {
        this.m_port = n;
    }

    public String getRecipient() {
        return this.m_recipient;
    }

    public String getRecipientDisplayName() {
        return this.m_recipientDisplayName;
    }

    public void setRecipient(String string, String string2) {
        this.m_recipient = string;
        this.m_recipientDisplayName = string2;
    }

    public String getSender() {
        return this.m_sender;
    }

    public String getSenderDisplayName() {
        return this.m_senderDisplayName;
    }

    public void setSender(String string, String string2) {
        this.m_sender = string;
        this.m_senderDisplayName = string2;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String string) {
        this.m_subject = string;
    }

    public String getBody() {
        return this.m_body;
    }

    public void setBody(String string) {
        this.m_body = string;
    }
}

