/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class DbConnectionPool {
    public static final int DB_DRIVER_MIN = 1;
    public static final int DB_DRIVER_MS = 1;
    public static final int DB_DRIVER_JTDS = 2;
    public static final int DB_DRIVER_ODBC = 3;
    public static final int DB_DRIVER_MAX = 3;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    private static boolean m_initialized = false;
    private String m_connectString = null;
    private String m_validationQuery = null;
    private String m_name = "";
    private int m_numBorrowed = 0;
    private int m_numReturned = 0;

    public static final String jdbcDriverAsString(int n) {
        if (n == 1) {
            return "ms";
        }
        if (n == 2) {
            return "jtds";
        }
        if (n == 3) {
            return "odbc";
        }
        return "<invalid>";
    }

    public static final int stringTojdbcDriver(String string) {
        if (string == null || string.equals("jtds")) {
            return 2;
        }
        if (string.equals("ms")) {
            return 1;
        }
        if (string.equals("odbc")) {
            return 3;
        }
        return 2;
    }

    public DbConnectionPool(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, int n2, byte by, int n3) throws Exception {
        if (n < 1 || n > 3) {
            throw new SQLException("InternalError: invalid jdbc driver type passed to db connection pool:" + n);
        }
        this.m_validationQuery = string8;
        DbConnectionPool.initDriver(n);
        this.initConnectionPool(string, string4, string2, string3, string5, string6, string7, string9, n, n2, by, n3);
    }

    public DbConnectionPool(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n) throws Exception {
        this(string, string2, string3, string4, string5, string6, string7, string8, string9, n, 8, 1, 8);
    }

    public String getValidationQuery() {
        return this.m_validationQuery;
    }

    public String getConnectString() {
        return this.m_connectString;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.getConnectString());
    }

    public int getNumBorrowed() {
        return this.m_numBorrowed;
    }

    public int getNumReturned() {
        return this.m_numReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        if (this.m_validationQuery == null || this.m_validationQuery.equals("")) {
            // empty if block
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.m_validationQuery);
            if (!resultSet.next()) {
                throw new SQLException("Validation failed for database: " + this.getConnectString() + " with validation query: " + this.getValidationQuery());
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void initConnectionPool(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, int n2, byte by, int n3) throws Exception {
        CountingGenericObjectPool countingGenericObjectPool = new CountingGenericObjectPool(n2, by, -1L, n3, true, false);
        String string9 = this.makeURI(n, string, string3, string4, string2, string6);
        DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(string9, string5, string7);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)countingGenericObjectPool, null, "select @@identity", false, false);
        new PoolingDriver().registerPool(string8, (ObjectPool)countingGenericObjectPool);
        this.m_connectString = "jdbc:apache:commons:dbcp:" + string8;
        this.m_name = string8;
    }

    private String makeURI(int n, String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        if (string3.length() == 0) {
            string3 = "1433";
        }
        if (n == 2) {
            string6 = "jdbc:jtds:sqlserver://" + string + ":" + string3;
            if (string4 != null && string4.length() > 0) {
                string6 = string6 + "/" + string4;
            }
            if (string2 != null && string2.length() > 0) {
                string6 = string6 + ";INSTANCE=" + string2;
            }
            if (string5 != null && string5.length() > 0) {
                string6 = string6 + ";DOMAIN=" + string5;
            }
        } else if (n == 3) {
            string6 = "jdbc:odbc:" + string + "-" + string4;
        } else {
            string6 = "jdbc:microsoft:sqlserver://" + string + ":" + string3;
            if (string4 != null) {
                string6 = string6 + ";DatabaseName=" + string4;
            }
            String string7 = ";SelectMethod=cursor";
            string6 = string6 + string7;
            return string6;
        }
        return string6;
    }

    private static synchronized void initDriver(int n) throws ClassNotFoundException {
        if (!m_initialized) {
            if (n == 2) {
                Class.forName("net.sourceforge.jtds.jdbc.Driver");
            } else if (n == 1) {
                Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            } else if (n == 3) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            m_initialized = true;
        }
    }

    private class CountingGenericObjectPool
    extends GenericObjectPool {
        private ThreadConnectionInfo m_threadConnInfo;

        public CountingGenericObjectPool() {
            super(null);
            this.m_threadConnInfo = new ThreadConnectionInfo();
        }

        public CountingGenericObjectPool(int n) {
            super(null, n);
            this.m_threadConnInfo = new ThreadConnectionInfo();
        }

        public CountingGenericObjectPool(int n, byte by, long l, int n2, boolean bl, boolean bl2) {
            super(null, n, by, l, n2, bl, bl2);
            this.m_threadConnInfo = new ThreadConnectionInfo();
        }

        public synchronized Object borrowObject() throws Exception {
            Object object = super.borrowObject();
            this.m_threadConnInfo.onBorrow(object);
            DbConnectionPool.this.m_numBorrowed++;
            return object;
        }

        public synchronized void returnObject(Object object) throws Exception {
            DbConnectionPool.this.m_numReturned++;
            this.m_threadConnInfo.onReturn(object);
            super.returnObject(object);
        }
    }

    private class ThreadConnectionInfo
    extends ThreadLocal {
        private ThreadConnectionInfo() {
        }

        protected Object initialValue() {
            return null;
        }

        public void onBorrow(Object object) throws SQLException {
            if (this.get() != null) {
                throw new SQLException("Connection pool: Attempt to borrow twice without returning.");
            }
            this.set(object);
        }

        public void onReturn(Object object) throws SQLException {
            if (this.get() != object) {
                throw new SQLException("Connection pool: Attempt to return what wasn't borrowed.");
            }
            this.set(null);
        }
    }
}

