/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.DuplicateEntryException;
import com.nai.mcafee.common.db.Tool;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ToolInstance {
    private static final Logger m_log;
    private static final String REGTOOLS_PROPS = "RegisteredTools.properties";
    private static final String FILE_HEADER = "Registered EXEs for use in Snowcap.";
    private static final String SLASH;
    private static final Properties m_toolDefs;
    public static final int MAX_EXE_NAME_LEN = 255;
    private Tool m_tool = null;
    static /* synthetic */ Class class$com$nai$mcafee$common$db$ToolInstance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void init(Connection connection, int n) throws SQLException {
        this.m_tool = n != -1 ? Tool.getByID(connection, n) : new Tool();
    }

    public ToolInstance(Connection connection, int n) throws SQLException {
        this.init(connection, n);
    }

    public ToolInstance() {
        try {
            this.init(null, -1);
        }
        catch (SQLException sQLException) {}
    }

    public ToolInstance(Connection connection, String string, String string2, String string3) throws SQLException, DuplicateEntryException {
        this.init(connection, -1);
        this.m_tool.setExeName(string);
        this.m_tool.setCmdLine(string2);
        int n = this.m_tool.lookupIdForTool(connection);
        if (n != -1) {
            throw new DuplicateEntryException(n);
        }
        this.m_tool.setDisplayName(string3);
    }

    public void setExeName(String string) {
        this.m_tool.setExeName(string);
    }

    public void setDisplayName(String string) {
        this.m_tool.setDisplayName(string);
    }

    public void setCmdArgs(String string) {
        this.m_tool.setCmdLine(string);
    }

    public String getExeName() {
        return this.m_tool.getExeName();
    }

    public String getCmdLine() {
        return this.m_tool.getCmdLine();
    }

    public String getDisName() {
        return this.m_tool.getDisplayName();
    }

    public int getToolId() {
        return this.m_tool.getId();
    }

    public int commitToolInstance(Connection connection) throws SQLException {
        if (this.m_tool.getId() != -1) {
            this.m_tool.update(connection);
        } else {
            this.m_tool.add(connection, true);
        }
        connection.commit();
        return this.m_tool.getId();
    }

    public void removeFromDb(Connection connection) throws SQLException {
        Tool.deleteFromDatabase(connection, this.m_tool.getId());
        connection.commit();
    }

    public static void updateToolInstanceNames(Connection connection, String string, String string2) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string3 = "update Tools set ExeName=? where ExeName=? ";
        preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        int n = preparedStatement.executeUpdate();
        preparedStatement.close();
        m_log.debug((Object)("Updated " + n + " rows in Tools table with new registered executable name."));
    }

    public static boolean isCmdNameSaved(Connection connection, String string) throws SQLException {
        String string2 = "select count(*) from Tools where DisplayName = '" + string + "' and AppAssociation='" + 1 + "'";
        return DatabaseUtil.executeIntQuery(connection, string2.toString()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRegisteredTools() throws FileNotFoundException, IOException {
        InputStream inputStream = (class$com$nai$mcafee$common$db$ToolInstance == null ? (class$com$nai$mcafee$common$db$ToolInstance = ToolInstance.class$("com.nai.mcafee.common.db.ToolInstance")) : class$com$nai$mcafee$common$db$ToolInstance).getClassLoader().getResourceAsStream(REGTOOLS_PROPS);
        if (inputStream == null) {
            throw new FileNotFoundException(REGTOOLS_PROPS);
        }
        Properties properties = m_toolDefs;
        synchronized (properties) {
            m_toolDefs.load(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRegisteredTools(ServletContext servletContext) throws IOException {
        Object object;
        Object object2;
        String string = null;
        URL uRL = (class$com$nai$mcafee$common$db$ToolInstance == null ? (class$com$nai$mcafee$common$db$ToolInstance = ToolInstance.class$("com.nai.mcafee.common.db.ToolInstance")) : class$com$nai$mcafee$common$db$ToolInstance).getClassLoader().getResource(REGTOOLS_PROPS);
        if (uRL == null) {
            object2 = (String)servletContext.getAttribute("org.apache.catalina.jsp_classpath");
            object = ((String)object2).split(";");
            int n = 0;
            while (n < ((String[])object).length) {
                m_log.debug((Object)("Found classpath element: " + object[n]));
                if (object[n].indexOf("WEB-INF") != -1 && object[n].indexOf("classes") != -1) {
                    m_log.debug((Object)("Using classpath element: " + object[n]));
                    string = object[0] + SLASH + REGTOOLS_PROPS;
                    break;
                }
                ++n;
            }
        } else {
            string = uRL.getFile();
        }
        m_log.info((Object)("Creating properties file: " + string));
        object2 = new FileOutputStream(string);
        object = m_toolDefs;
        synchronized (object) {
            m_toolDefs.store((OutputStream)object2, FILE_HEADER);
        }
        ((FileOutputStream)object2).close();
    }

    public static boolean isExeUsedByCmdLine(Connection connection, String string, int n) throws SQLException {
        Tool[] toolArray = Tool.getAll(connection, n);
        if (toolArray != null) {
            int n2 = 0;
            while (n2 < toolArray.length) {
                if (toolArray[n2].getExeName().compareTo(string) == 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isCmdLineUsedByResponse(Connection connection, int n) {
        CharSequence charSequence;
        int n2 = 0;
        try {
            charSequence = new StringBuffer();
            charSequence.append("").append("'");
            n2 = DatabaseUtil.executeIntQuery(connection, "select count(*) from ActionSettings where Name='ToolId' and Value='" + n + "'");
        }
        catch (SQLException sQLException) {
            m_log.debug((Object)"Failed to count CMDline uses.", (Throwable)sQLException);
        }
        try {
            charSequence = "select count(*) from NotificationTarget as n left join NotificationTargetSettings as s on n.NotificationTargetId=s.NotificationTargetId where n.RuleClassName='exttool' and s.Name='toolSel' and s.Value='" + n + "'";
            n2 += DatabaseUtil.executeIntQuery(connection, (String)charSequence);
        }
        catch (SQLException sQLException) {
            m_log.debug((Object)"Failed to count CMDline uses.", (Throwable)sQLException);
        }
        return n2 > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegisteredTools() throws IOException {
        String string = null;
        URL uRL = (class$com$nai$mcafee$common$db$ToolInstance == null ? (class$com$nai$mcafee$common$db$ToolInstance = ToolInstance.class$("com.nai.mcafee.common.db.ToolInstance")) : class$com$nai$mcafee$common$db$ToolInstance).getClassLoader().getResource(REGTOOLS_PROPS);
        if (uRL == null) {
            throw new FileNotFoundException(REGTOOLS_PROPS);
        }
        string = uRL.getFile();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Properties properties = m_toolDefs;
        synchronized (properties) {
            m_toolDefs.store(fileOutputStream, FILE_HEADER);
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRegisteredTool(String string, String string2) throws IOException {
        Properties properties = m_toolDefs;
        synchronized (properties) {
            m_toolDefs.setProperty(string, string2);
            ToolInstance.writeRegisteredTools();
        }
    }

    public static final Map getToolMap() {
        return m_toolDefs;
    }

    public static Iterator getToolNames() {
        Set<Object> set = m_toolDefs.keySet();
        TreeSet<Object> treeSet = new TreeSet<Object>(set);
        return treeSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExeCommand(String string) {
        String string2 = null;
        Properties properties = m_toolDefs;
        synchronized (properties) {
            string2 = m_toolDefs.getProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getExeCount() {
        int n;
        Properties properties = m_toolDefs;
        synchronized (properties) {
            n = m_toolDefs.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExeNameSaved(String string) {
        boolean bl = false;
        if (!($assertionsDisabled || string != null && string.length() > 0)) {
            throw new AssertionError();
        }
        Properties properties = m_toolDefs;
        synchronized (properties) {
            Enumeration<?> enumeration = m_toolDefs.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExe(String string) throws IOException {
        if (!($assertionsDisabled || string != null && string.length() > 0)) {
            throw new AssertionError();
        }
        Properties properties = m_toolDefs;
        synchronized (properties) {
            m_toolDefs.remove(string);
            ToolInstance.writeRegisteredTools();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing load and unload of the properties file...");
        try {
            ToolInstance.loadRegisteredTools();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            ToolInstance.setRegisteredTool("\\\\\\\\", "ping.exe");
            ToolInstance.setRegisteredTool("nslookup", "C:\\winnt\\system32\\nslookup.exe");
            ToolInstance.writeRegisteredTools();
            if (ToolInstance.isExeNameSaved("\\\\\\\\")) {
                ToolInstance.removeExe("\\\\\\\\");
            } else {
                System.out.println("Tool name isn't saved!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Properties properties = System.getProperties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$common$db$ToolInstance == null ? (class$com$nai$mcafee$common$db$ToolInstance = ToolInstance.class$("com.nai.mcafee.common.db.ToolInstance")) : class$com$nai$mcafee$common$db$ToolInstance).desiredAssertionStatus();
        m_log = Logger.getLogger((String)(class$com$nai$mcafee$common$db$ToolInstance == null ? (class$com$nai$mcafee$common$db$ToolInstance = ToolInstance.class$("com.nai.mcafee.common.db.ToolInstance")) : class$com$nai$mcafee$common$db$ToolInstance).getName());
        SLASH = System.getProperty("file.separator");
        m_toolDefs = new Properties();
    }
}

