/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.ui;

import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.tables.HtmlTable;
import com.nai.mcafee.common.ui.tables.HtmlTableCell;
import com.nai.mcafee.common.ui.tables.HtmlTableHeader;
import com.nai.mcafee.common.ui.tables.HtmlTableRow;
import com.nai.mcafee.common.ui.util.PaginationMgr;
import com.nai.mcafee.common.ui.util.PropDisplayInterface;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.common.ui.util.UIPropStack;
import com.nai.mcafee.common.util.Resource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class PropertyPageBean
extends ActionBeanBase {
    private Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$common$ui$PropertyPageBean == null ? (class$com$nai$mcafee$common$ui$PropertyPageBean = PropertyPageBean.class$("com.nai.mcafee.common.ui.PropertyPageBean")) : class$com$nai$mcafee$common$ui$PropertyPageBean));
    public static final int INVALID_PROP = -1;
    protected String m_lang = null;
    static /* synthetic */ Class class$com$nai$mcafee$common$ui$PropertyPageBean;

    public String getLanguageId() {
        return this.m_lang;
    }

    public void setLanguageId(String string) {
        this.m_lang = string;
    }

    protected abstract String getClickedIDParam();

    protected abstract String getIndexParam();

    protected abstract String doPostTableStuff(DatabaseObject var1, PropDisplayInterface var2, HttpServletRequest var3) throws Exception;

    protected abstract int[] getColumns();

    protected abstract PropDisplayInterface getPropDisplayInterface(String var1);

    protected abstract String getHeaderCellMarkup(int var1, String var2, DatabaseObject var3, String var4);

    protected abstract String getPropCellMarkup(int var1, String var2, DatabaseObject var3, String var4);

    protected abstract String getPropertyTableName();

    protected abstract String getPostPropertyTableName();

    protected abstract String getNextPage();

    protected abstract String getTableHeaderText(String var1);

    protected abstract String getNextEntryText(String var1);

    protected abstract String getPrevEntryText(String var1);

    protected abstract Class getBeanClass();

    protected abstract String getActionName();

    protected abstract void calculateProperties(Connection var1, DatabaseObject var2) throws Exception;

    protected abstract boolean isDismissed(DatabaseObject var1);

    protected abstract Database getMainDb();

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter(this.getClickedIDParam());
        if (string != null && string.length() > 0 && SessionUtil.isIntegerGT(string, 0)) {
            return null;
        }
        String string2 = httpServletRequest.getParameter(this.getIndexParam());
        if (string2 != null && string2.length() > 0 && SessionUtil.isIntegerGT(string2, -1)) {
            return null;
        }
        if (!UIPropStack.reqestAtTopOfStack(httpServletRequest, this.getBeanClass())) {
            throw new InvalidParameterException(this.getBeanClass().getName() + " missing or invalid index and ID.");
        }
        return null;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.m_log.debug((Object)"Re-Aligning the property stack...");
        UIPropStack.alignStack(httpServletRequest);
        this.m_log.debug((Object)"-----------------------------------");
        this.m_log.debug((Object)("Executing " + this.getBeanClass().getName()));
        RequestHandler requestHandler = new RequestHandler(httpServletRequest);
        requestHandler.handle(httpServletRequest);
        httpServletRequest.setAttribute(this.getPropertyTableName(), (Object)requestHandler.getResults());
        httpServletRequest.setAttribute(this.getPostPropertyTableName(), (Object)requestHandler.getPostTableResults());
        this.m_log.debug((Object)("Pushing " + this.getBeanClass().getName() + " properties onto the stack..."));
        if (!requestHandler.isStaticOperation()) {
            UIPropStack.pushPropStack(this.getActionName(), httpServletRequest, this.getBeanClass(), null, null, null, null, null);
        }
        this.m_log.debug((Object)("Returing results for " + this.getBeanClass().getName()));
        this.m_log.debug((Object)"-----------------------------------");
        return this.getNextPage();
    }

    private DatabaseObject getById(Connection connection, int n, PropDisplayInterface propDisplayInterface) throws SQLException, InstantiationException, IllegalAccessException {
        Class clazz = propDisplayInterface.getDBClass();
        DatabaseObject databaseObject = (DatabaseObject)clazz.newInstance();
        Statement statement = connection.createStatement();
        String string = "select " + propDisplayInterface.getSelectColumns() + " from " + propDisplayInterface.getTableName() + " where " + propDisplayInterface.getIdColumnName() + "='" + n + "'";
        this.m_log.debug((Object)("Getting by ID with SQL: " + string));
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet != null && resultSet.next()) {
            databaseObject.setValues(resultSet);
        }
        return databaseObject;
    }

    private int getRowCount(Connection connection, String string, PropDisplayInterface propDisplayInterface) throws SQLException {
        int n = 0;
        int n2 = string.indexOf("from");
        int n3 = string.lastIndexOf("order by");
        int n4 = string.lastIndexOf("group by");
        if (n4 == -1) {
            n4 = string.length();
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        int n5 = n4 > n3 ? n3 : (n3 > n4 ? n4 : n3);
        String string2 = "select count(DISTINCT " + propDisplayInterface.getIdColumnName() + ") " + string.substring(n2, n5);
        this.m_log.debug((Object)("Trying to do DB row count with new SQL: " + string2));
        Statement statement = connection.createStatement();
        statement.executeQuery(string2);
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null && resultSet.next()) {
            n = resultSet.getInt(1);
        }
        return n;
    }

    private Vector runDBQuery(Connection connection, String string, Class clazz, int n, int n2) throws SQLException {
        this.m_log.debug((Object)("Running query: " + string));
        if (string == null) {
            throw new SQLException("The parent table SQL was null.");
        }
        return DatabaseObject.getByQuery(connection, string, clazz, n, n2);
    }

    private void buildPrevNextHeader(StringBuffer stringBuffer, int n, int n2, String string) {
        this.m_log.debug((Object)("Building the next/prev header... index is: " + n + " size is: " + n2));
        stringBuffer.append("<table cellspacing=3 cellpadding=3 border=0 class='Toolbar' width='100%'>").append("<tr valign=center><td>");
        this.addControl(stringBuffer, this.getPrevEntryText(string), n - 1, true, n > 1);
        stringBuffer.append(" <img src='images/px_trans.gif' height=1 width=9 border=0> ");
        this.addControl(stringBuffer, this.getNextEntryText(string), n + 1, false, n < n2);
        stringBuffer.append("</td></tr></table>");
    }

    private void addControl(StringBuffer stringBuffer, String string, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        stringBuffer2.append("images/");
        if (bl) {
            stringBuffer2.append("ViewPrevious");
        } else {
            stringBuffer2.append("ViewNext");
        }
        if (!bl2) {
            stringBuffer2.append("Disabled");
        }
        stringBuffer2.append(".gif");
        if (bl2) {
            stringBuffer.append("<a href='Javascript:displayAnother( ").append(n).append(")'><img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append(string).append("</a>");
        } else {
            stringBuffer.append("<img src='").append(stringBuffer2.toString()).append("' align=absMiddle border=0> ").append("<span style='color:").append("#AAAAAA").append("'>").append(string).append("</span>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RequestHandler {
        int m_index;
        int m_id;
        int m_totalRows;
        boolean m_displayNextPrev = true;
        boolean m_staticOperation = false;
        StringBuffer m_results = new StringBuffer(1024);
        StringBuffer m_postTableResults = new StringBuffer(1024);
        Map m_parentParams = null;
        PaginationMgr m_pag = null;
        String m_lang = null;

        private String findBestString(HttpServletRequest httpServletRequest, String string) {
            String string2 = null;
            if (!this.m_staticOperation) {
                PropertyPageBean.this.m_log.debug((Object)("This is not a static operation.  Getting " + string + " value from request."));
                string2 = httpServletRequest.getParameter(string);
            }
            if (string2 == null) {
                PropertyPageBean.this.m_log.debug((Object)"Either the value was not in the request, or this is a static operation.  Trying the parameter map.");
                this.getParamFromPropStack(httpServletRequest, string);
            }
            PropertyPageBean.this.m_log.debug((Object)("Using " + string2 + " for parameter " + string));
            return string2;
        }

        private String getParamFromPropStack(HttpServletRequest httpServletRequest, String string) {
            String string2 = null;
            Class<?> clazz = this.getClass();
            PropertyPageBean.this.m_log.debug((Object)("Class is: " + clazz.getName()));
            PropertyPageBean.this.m_log.debug((Object)("Bean says class is: " + PropertyPageBean.this.getBeanClass()));
            if (UIPropStack.reqestAtTopOfStack(httpServletRequest, PropertyPageBean.this.getBeanClass())) {
                Map map = UIPropStack.peekPropStack(httpServletRequest.getSession());
                PropertyPageBean.this.m_log.debug((Object)"Request is at the top of the stack.  Using the value in the prop stack.");
                Object v = map.get(string);
                if (v != null) {
                    PropertyPageBean.this.m_log.debug((Object)"The value was found in the property map.");
                    string2 = v instanceof String[] ? ((String[])v)[0] : (String)v;
                }
            }
            PropertyPageBean.this.m_log.debug((Object)("Using " + string2 + " for parameter " + string));
            return string2;
        }

        public RequestHandler(HttpServletRequest httpServletRequest) {
            String string;
            String string2 = null;
            this.m_lang = UserUtil.getLanguageForUser(httpServletRequest);
            boolean bl = this.m_staticOperation = httpServletRequest.getAttribute("staticOperation") != null;
            if (this.m_staticOperation) {
                PropertyPageBean.this.m_log.debug((Object)"This is a static operation, using values only from property stack.");
                string = this.getParamFromPropStack(httpServletRequest, PropertyPageBean.this.getClickedIDParam());
                string2 = this.getParamFromPropStack(httpServletRequest, PropertyPageBean.this.getIndexParam());
            } else {
                PropertyPageBean.this.m_log.debug((Object)"This does not appear to be a static operation.  Trying to get the index and ID.");
                string = httpServletRequest.getParameter(PropertyPageBean.this.getClickedIDParam());
                string2 = httpServletRequest.getParameter(PropertyPageBean.this.getIndexParam());
                if (string == null && string2 == null) {
                    PropertyPageBean.this.m_log.debug((Object)"Both index and id were null in the request, looking for in the param map.");
                    string = this.getParamFromPropStack(httpServletRequest, PropertyPageBean.this.getClickedIDParam());
                    string2 = this.getParamFromPropStack(httpServletRequest, PropertyPageBean.this.getIndexParam());
                }
            }
            this.m_index = string2 != null && string2.length() > 0 ? Integer.parseInt(string2) : 0;
            this.m_id = string != null && string.length() > 0 ? Integer.parseInt(string) : 0;
            PropertyPageBean.this.m_log.debug((Object)("Index is: " + this.m_index + " ID is: " + this.m_id));
            this.m_parentParams = UIPropStack.peekParentMap(httpServletRequest.getSession(), PropertyPageBean.this.getBeanClass());
            if (this.m_parentParams != null) {
                this.m_pag = (PaginationMgr)this.m_parentParams.get("paginationMgr");
            }
            PropertyPageBean.this.m_log.debug((Object)("Parent Map is: " + this.m_parentParams));
            PropertyPageBean.this.m_log.debug((Object)("Top of the stack map is: " + UIPropStack.peekPropStack(httpServletRequest.getSession())));
            PropertyPageBean.this.m_log.debug((Object)("Request map is: " + httpServletRequest.getParameterMap()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatabaseObject doDBStuff(HttpServletRequest httpServletRequest, PropDisplayInterface propDisplayInterface) throws Exception {
            Object object;
            Connection connection = null;
            DatabaseObject databaseObject = null;
            String string = (String)this.m_parentParams.get("tableSQLQuery");
            Class clazz = (Class)this.m_parentParams.get("tableSQLClass");
            PropertyPageBean.this.m_log.debug((Object)("Parent tableGenSQL is: " + string));
            if (string == null) {
                this.m_displayNextPrev = false;
            } else {
                object = null;
                object = this.m_staticOperation ? this.getParamFromPropStack(httpServletRequest, "disableNextPrev") : this.findBestString(httpServletRequest, "disableNextPrev");
                if (object != null && ((String)object).equals("1")) {
                    this.m_displayNextPrev = false;
                }
            }
            try {
                connection = PropertyPageBean.this.getMainDb().getConnection();
                if (this.m_id != 0) {
                    PropertyPageBean.this.m_log.debug((Object)"Getting by ID");
                    databaseObject = PropertyPageBean.this.getById(connection, this.m_id, propDisplayInterface);
                } else {
                    PropertyPageBean.this.m_log.debug((Object)"Getting by index");
                    object = PropertyPageBean.this.runDBQuery(connection, string, clazz, this.m_index, 1);
                    databaseObject = (DatabaseObject)((Vector)object).firstElement();
                }
                PropertyPageBean.this.calculateProperties(connection, databaseObject);
                propDisplayInterface.setDbo(databaseObject);
                if (this.m_displayNextPrev) {
                    if (this.m_pag != null) {
                        PropertyPageBean.this.m_log.debug((Object)("Updating the parent index appropriately... current index is: " + this.m_index));
                        this.m_pag.updateIndex(this.m_index);
                        PropertyPageBean.this.m_log.debug((Object)("Parent page's new index is: " + this.m_pag.getIndex()));
                    }
                    object = (String)this.m_parentParams.get("countSQLTable");
                    String string2 = (String)this.m_parentParams.get("countSQLWhereClause");
                    if (object == null && string2 == null) {
                        PropertyPageBean.this.m_log.debug((Object)"Getting row count by table and where clause.");
                        this.m_totalRows = PropertyPageBean.this.getRowCount(connection, string, propDisplayInterface);
                    } else {
                        PropertyPageBean.this.m_log.debug((Object)("Getting row count with DBUtil, table=" + (String)object + ", whereClause: " + string2));
                        this.m_totalRows = DatabaseUtil.countRows(connection, (String)object, string2);
                    }
                    PropertyPageBean.this.buildPrevNextHeader(this.m_results, this.m_index, this.m_totalRows, this.m_lang);
                } else {
                    PropertyPageBean.this.buildPrevNextHeader(this.m_results, 1, 1, this.m_lang);
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                DatabaseUtil.close(connection);
                throw throwable;
            }
            DatabaseUtil.close(connection);
            return databaseObject;
        }

        private void drawTable(DatabaseObject databaseObject, PropDisplayInterface propDisplayInterface) throws Exception {
            PropertyPageBean.this.m_log.debug((Object)"Drawing the table.");
            HtmlTable htmlTable = new HtmlTable();
            HtmlTableHeader htmlTableHeader = null;
            HtmlTableRow htmlTableRow = null;
            HtmlTableCell htmlTableCell = null;
            htmlTable.set2col(true);
            htmlTableHeader = htmlTable.getHeader();
            String string = PropertyPageBean.this.getTableHeaderText(this.m_lang);
            if (PropertyPageBean.this.isDismissed(databaseObject)) {
                string = string + " - <span class=redText>" + Resource.getString("propertypagebean_dismissed", this.m_lang) + "</span>";
            }
            htmlTableCell = htmlTableHeader.addCell(string);
            htmlTableCell.setColspan(5);
            htmlTableCell.setStyle("cursor: default");
            int n = 0;
            int[] nArray = PropertyPageBean.this.getColumns();
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                if (n == 0) {
                    htmlTableRow = htmlTable.addRow(4);
                    htmlTableRow.setValign("top");
                }
                if (n3 != -1) {
                    htmlTableCell = htmlTableRow.addCell(PropertyPageBean.this.getHeaderCellMarkup(n3, propDisplayInterface.getFullHeader(n3) + Resource.getString("common_colon", this.m_lang), databaseObject, this.m_lang));
                    htmlTableCell.setStyle("cursor: default");
                    htmlTableCell = htmlTableRow.addCell(PropertyPageBean.this.getPropCellMarkup(n3, propDisplayInterface.getFullProperty(n3), databaseObject, this.m_lang));
                    htmlTableCell.setStyle("font-weight: normal; cursor: default");
                } else {
                    htmlTableRow.addCell(null);
                    htmlTableRow.addCell(null);
                }
                if (++n == 2) {
                    n = 0;
                }
                ++n2;
            }
            if (n2 % 2 == 1) {
                htmlTableRow.addCell("&nbsp;");
                htmlTableRow.addCell("&nbsp;");
            }
            this.m_results.append("<br>");
            this.m_results.append(htmlTable.getHtml(this.m_lang));
        }

        public void handle(HttpServletRequest httpServletRequest) throws Exception {
            PropertyPageBean.this.m_log.debug((Object)"Handling a request.");
            PropDisplayInterface propDisplayInterface = PropertyPageBean.this.getPropDisplayInterface(this.m_lang);
            DatabaseObject databaseObject = this.doDBStuff(httpServletRequest, propDisplayInterface);
            this.drawTable(databaseObject, propDisplayInterface);
            this.m_postTableResults.append(PropertyPageBean.this.doPostTableStuff(databaseObject, propDisplayInterface, httpServletRequest));
            httpServletRequest.setAttribute(PropertyPageBean.this.getIndexParam(), (Object)Integer.toString(this.m_index));
            String string = (String)UIPropStack.peekParentMap(httpServletRequest.getSession(), PropertyPageBean.this.getBeanClass()).get("pageUrl");
            httpServletRequest.setAttribute("closeTarget", (Object)string);
        }

        public String getResults() {
            return this.m_results.toString();
        }

        public String getPostTableResults() {
            return this.m_postTableResults.toString();
        }

        public boolean isStaticOperation() {
            return this.m_staticOperation;
        }
    }
}

