/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.condition;

import com.nai.mcafee.common.condition.SerializationException;
import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpAnd;
import com.nai.mcafee.common.condition.SexpBool;
import com.nai.mcafee.common.condition.SexpContains;
import com.nai.mcafee.common.condition.SexpEndsWith;
import com.nai.mcafee.common.condition.SexpEquals;
import com.nai.mcafee.common.condition.SexpIpInRange;
import com.nai.mcafee.common.condition.SexpIpNotInRange;
import com.nai.mcafee.common.condition.SexpIsNull;
import com.nai.mcafee.common.condition.SexpList;
import com.nai.mcafee.common.condition.SexpLong;
import com.nai.mcafee.common.condition.SexpNewerThan;
import com.nai.mcafee.common.condition.SexpNotContains;
import com.nai.mcafee.common.condition.SexpNotEquals;
import com.nai.mcafee.common.condition.SexpOlderThan;
import com.nai.mcafee.common.condition.SexpOr;
import com.nai.mcafee.common.condition.SexpProp;
import com.nai.mcafee.common.condition.SexpStartsWith;
import com.nai.mcafee.common.condition.SexpString;
import com.nai.mcafee.common.condition.Tokenizer;

public class SexpSerializer {
    public static final String write(Sexp sexp) {
        StringBuffer stringBuffer = new StringBuffer();
        sexp.write(stringBuffer);
        return stringBuffer.toString();
    }

    public static final Sexp read(String string) throws SerializationException {
        Tokenizer tokenizer = new Tokenizer(string);
        tokenizer.next();
        return SexpSerializer.readImpl(tokenizer);
    }

    private static final Sexp readImpl(Tokenizer tokenizer) throws SerializationException {
        int n = tokenizer.lastTokenType();
        switch (n) {
            case 3: {
                return SexpSerializer.readLiteral(tokenizer);
            }
            case 1: {
                return SexpSerializer.readList(tokenizer);
            }
            case 4: {
                return new SexpString(tokenizer.lastToken());
            }
            case 0: {
                throw new SerializationException("Unexpected end of stream");
            }
            case 2: {
                throw new SerializationException("Unexpected close-parenthesis");
            }
        }
        return null;
    }

    private static final Sexp readList(Tokenizer tokenizer) throws SerializationException {
        int n = tokenizer.next();
        if (n != 3) {
            throw new SerializationException("String must always follow open-parenthesis");
        }
        SexpList sexpList = SexpSerializer.createSexp(tokenizer.lastToken().intern());
        n = tokenizer.next();
        while (n != 2) {
            if (n == 0) {
                throw new SerializationException("Unexpected end of stream");
            }
            sexpList.addChild(SexpSerializer.readImpl(tokenizer));
            n = tokenizer.next();
        }
        return sexpList;
    }

    private static final Sexp readLiteral(Tokenizer tokenizer) throws SerializationException {
        String string = tokenizer.lastToken().intern();
        if (string == "t") {
            return SexpBool.TRUE;
        }
        if (string == "f") {
            return SexpBool.FALSE;
        }
        if (string.length() > 0 && (Character.isDigit(string.charAt(0)) || string.charAt(0) == '-')) {
            try {
                return new SexpLong(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SerializationException("Invalid number format:" + string);
            }
        }
        return new SexpProp(string);
    }

    private static final SexpList createSexp(String string) throws SerializationException {
        if (string == "and") {
            return new SexpAnd();
        }
        if (string == "or") {
            return new SexpOr();
        }
        if (string == "eq") {
            return new SexpEquals();
        }
        if (string == "ne") {
            return new SexpNotEquals();
        }
        if (string == "isNull") {
            return new SexpIsNull();
        }
        if (string == "contains") {
            return new SexpContains();
        }
        if (string == "doesntContain") {
            return new SexpNotContains();
        }
        if (string == "startsWith") {
            return new SexpStartsWith();
        }
        if (string == "endsWith") {
            return new SexpEndsWith();
        }
        if (string == "olderThan") {
            return new SexpOlderThan();
        }
        if (string == "newerThan") {
            return new SexpNewerThan();
        }
        if (string == "ipInRange") {
            return new SexpIpInRange();
        }
        if (string == "ipNotInRange") {
            return new SexpIpNotInRange();
        }
        throw new SerializationException("Unknown operation:" + string);
    }
}

