--ePO 3.0 to 3.5 Schema Updates script

USE [SERVERNAME_ePO]
GO

-- AutoClose property of ePO databases should always be cleared.
/* Use sp_dboption because AUTO_CLOSE is not compatible with SQL 7.  dboption on an unknown option is fine.
   Once support for SQL 7 is dropped, uncommment the "alter database" and remove the sp_dboption because the
   sp_dboption is deprecated.

ALTER DATABASE [SERVERNAME_ePO]
	SET AUTO_CLOSE OFF;
*/

exec sp_dboption N'SERVERNAME_ePO', N'autoclose', N'false'
GO




ALTER TABLE [dbo].[ServerInfo]
ADD
	RmdHttpPort INT NULL,
	RmdSecureHttpPort INT NULL,
	EnableRmdSecureHttp INT NULL,
	EnableMACNaming INT NULL,
	SelectiveGUpdateList nvarchar(1500) NULL,
	SensorSecureHttpPort INT NULL
GO

ALTER TABLE [dbo].[ServerInfo]
ADD
	CONSTRAINT [DF_ServerInfo_RmdHttpPort] DEFAULT (8080) FOR [RmdHttpPort],
	CONSTRAINT [DF_ServerInfo_RmdSecureHttpPort] DEFAULT (8443) FOR [RmdSecureHttpPort],
	CONSTRAINT [DF_ServerInfo_EnableRmdSecureHttp] DEFAULT (1) FOR [EnableRmdSecureHttp],
	CONSTRAINT [DF_ServerInfo_EnableMACNaming] DEFAULT (0) FOR [EnableMACNaming],
	CONSTRAINT [DF_ServerInfo_SensorSecureHttpPort] DEFAULT (8444) FOR [SensorSecureHttpPort]
GO

-- Index to increase performance of Snowcap and of Active Directory Discovery
CREATE  INDEX [IX_CompProp_ComputerName] ON [dbo].[ComputerProperties]([ComputerName]) ON [PRIMARY]

GO

-- Index to increase performance of Snowcap
CREATE  INDEX [IX_CompProp_NetAddress] ON [dbo].[ComputerProperties]([NetAddress]) ON [PRIMARY]

GO


-- ReportComputerSummary changes
-- fix big software name bug
ALTER TABLE [dbo].[ReportComputerSummary]
	ALTER COLUMN ProductName nvarchar (128) 
GO


ALTER TABLE [dbo].[ReportComputerSummaryPrevious]
	ALTER COLUMN ProductName nvarchar (128) 
GO

ALTER TABLE [dbo].[ReportComputerSummary]
	add AgentName nvarchar (128) 
GO


ALTER TABLE [dbo].[ReportComputerSummaryPrevious]
	add AgentName nvarchar (128) 
GO



Update ServerInfo SET ePOVersion='3.5.0', RmdHttpPort=8080, RmdSecureHttpPort=8443, EnableRmdSecureHttp=1, EnableMACNaming=0, SelectiveGUpdateList='VSCANDAT1000;VSCANENG1000;', SensorSecureHttpPort=8444 
GO


ALTER TABLE [dbo].[LeafNode]
ADD
	Flags INT NULL

GO


ALTER TABLE [dbo].[LeafNode]
ADD
	CONSTRAINT [DF_LeafNode_Flags] DEFAULT (0) FOR [Flags]

GO

update leafnode set flags=0

GO



ALTER TABLE [dbo].[servertasktype]
ADD
	Flags INT NULL

GO


ALTER TABLE [dbo].[servertasktype]
ADD
	CONSTRAINT [DF_servertasktype_Flags] DEFAULT (1) FOR [Flags]

GO

update servertasktype set flags=1

GO

--Flag the tasks that do not report their own status.
update servertasktype set flags=0 where TaskTypeCode IN ('DOMSYNCH300','COMPLIAN350')

GO

--update the commandtype on the repository tasks to the new value for scheduler-only invoked tasks
UPDATE ServerTaskType SET CommandType=0x10 WHERE TaskTypeCode IN ('Replication','Mirror')

GO


insert into servertasktype 
(TaskTypeCode, ServerTaskTypeName, Description, Command, CommandType, ConfigPageName, Flags, TheTimestamp)
values 
('ADINTEGR350',112,113,'ADI.exe -d <STID>',2,'task_ADIntegration.htm',1,@@DBTS)


GO


IF EXISTS (SELECT * FROM sysobjects WHERE ID = object_id(N'[dbo].[SP_CompareVer]'))
DROP PROCEDURE [dbo].[SP_CompareVer]

GO

-- Compare 2 version numbers
-- Returns: 	N'='  : same
--		N'<'  : Left less than Right
--		N'>'  : Left greater than Right
CREATE PROCEDURE [dbo].[SP_CompareVer]  
(
 @szLeft NVARCHAR(100), 
 @szRight NVARCHAR(100),
 @out NCHAR OUTPUT
)
AS
BEGIN
-- Compare 2 version numbers
-- Returns: 	N'='  : same
--		N'<'  : Left less than Right
--		N'>'  : Left greater than Right
	DECLARE @cResult NCHAR
	DECLARE	@szLeftSeg NVARCHAR(100)
	DECLARE	@szRightSeg NVARCHAR(100)
	DECLARE	@iL INT
	DECLARE	@iR INT
	DECLARE	@nLeft INT
	DECLARE	@nRight INT

	SET @cResult = N'='	
	SET @szLeftSeg = @szLeft
	SET @szRightSeg = @szRight

	SET @iL = CHARINDEX(N'.',@szLeftSeg)-1
	SET @iR = CHARINDEX(N'.',@szRightSeg)-1	

	IF (@iL<=0) 
		SET @iL = LEN(@szLeftSeg)	
	IF (@iR<=0) 
		SET @iR = LEN(@szRightSeg)	


	-- If both values have no more dots, we are done, return the comparison
	WHILE ((@iL>0) OR (@iR>0))
	BEGIN
	
		-- First check the first number before the .
		SET @iL = CHARINDEX(N'.',@szLeftSeg)-1
		SET @iR = CHARINDEX(N'.',@szRightSeg)-1	

		-- If there are no more dots, use the rest of the string for the segment
		IF (@iL<=0) 
			SET @iL = LEN(@szLeftSeg)	
		IF (@iR<=0) 
			SET @iR = LEN(@szRightSeg)	

		-- Find the value in this segment
		IF (@iL>=1)
			SET @nLeft = CAST(LEFT(@szLeftSeg, @iL) AS INT)
		ELSE
			SET @nLeft = 0

		IF (@iR>=1)		
			SET @nRight = CAST(LEFT(@szRightSeg, @iR) AS INT)
		ELSE
			SET @nRight = 0
		
		-- if left or right is bigger, we are done, return the result
		IF (@nLeft>@nRight)
		BEGIN
			SET @out=N'>'
			RETURN
		END
		ELSE IF (@nLeft<@nRight)
		BEGIN
			SET @out=N'<'
			RETURN
		END	

		-- set the sub left & right to the right-side of the ver strings
		IF ((LEN(@szLeftSeg)-@iL-1)>0)
			SET @szLeftSeg = RIGHT(@szLeftSeg,LEN(@szLeftSeg)-@iL-1)
		ELSE
			SET @szLeftSeg = ''
		IF ((LEN(@szRightSeg)-@iR-1)>0)
			SET @szRightSeg = RIGHT(@szRightSeg,LEN(@szRightSeg)-@iR-1)
		ELSE
			SET @szRightSeg = ''
	END
	
	SET @out=N'='
	RETURN 

END


GO


/* Use the version of the Compliance Check below when support for SQL 7 is dropped.
   It is more efficient, but it is not compatible with SQL 7, so a different implementation is used

IF EXISTS (SELECT * FROM sysobjects WHERE ID = object_id(N'[dbo].[fn_CompareVer]'))
DROP FUNCTION [dbo].[fn_CompareVer]

-- Compare 2 version numbers
-- Returns: 	N'='  : same
--		N'<'  : Left less than Right
--		N'>'  : Left greater than Right
CREATE FUNCTION [dbo].[fn_CompareVer]  (@szLeft NVARCHAR(100), @szRight NVARCHAR(100))
RETURNS NCHAR
AS
BEGIN
-- Compare 2 version numbers
-- Returns: 	N'='  : same
--		N'<'  : Left less than Right
--		N'>'  : Left greater than Right
	DECLARE @cResult NCHAR
	DECLARE	@szLeftSeg NVARCHAR(100)
	DECLARE	@szRightSeg NVARCHAR(100)
	DECLARE	@iL INT
	DECLARE	@iR INT
	DECLARE	@nLeft INT
	DECLARE	@nRight INT

	SET @cResult = N'='	
	SET @szLeftSeg = @szLeft
	SET @szRightSeg = @szRight

	SET @iL = CHARINDEX(N'.',@szLeftSeg)-1
	SET @iR = CHARINDEX(N'.',@szRightSeg)-1	

	IF (@iL<=0) 
		SET @iL = LEN(@szLeftSeg)	
	IF (@iR<=0) 
		SET @iR = LEN(@szRightSeg)	


	-- If both values have no more dots, we are done, return the comparison
	WHILE ((@iL>0) OR (@iR>0))
	BEGIN
	
		-- First check the first number before the .
		SET @iL = CHARINDEX(N'.',@szLeftSeg)-1
		SET @iR = CHARINDEX(N'.',@szRightSeg)-1	

		-- If there are no more dots, use the rest of the string for the segment
		IF (@iL<=0) 
			SET @iL = LEN(@szLeftSeg)	
		IF (@iR<=0) 
			SET @iR = LEN(@szRightSeg)	

		-- Find the value in this segment
		IF (@iL>=1)
			SET @nLeft = CAST(LEFT(@szLeftSeg, @iL) AS INT)
		ELSE
			SET @nLeft = 0

		IF (@iR>=1)		
			SET @nRight = CAST(LEFT(@szRightSeg, @iR) AS INT)
		ELSE
			SET @nRight = 0
		
		-- if left or right is bigger, we are done, return the result
		IF (@nLeft>@nRight)
		BEGIN
			RETURN N'>'
		END
		ELSE IF (@nLeft<@nRight)
		BEGIN
			RETURN N'<'
		END	

		-- set the sub left & right to the right-side of the ver strings
		IF ((LEN(@szLeftSeg)-@iL-1)>0)
			SET @szLeftSeg = RIGHT(@szLeftSeg,LEN(@szLeftSeg)-@iL-1)
		ELSE
			SET @szLeftSeg = ''
		IF ((LEN(@szRightSeg)-@iR-1)>0)
			SET @szRightSeg = RIGHT(@szRightSeg,LEN(@szRightSeg)-@iR-1)
		ELSE
			SET @szRightSeg = ''
	END
	
	RETURN N'='

END
*/


GO



if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Mapping_Points]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Mapping_Points]


GO

CREATE TABLE [dbo].[Mapping_Points] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[Enabled] [bit] NOT NULL ,
	[ePONodeID] [int] NOT NULL ,
	[LastRunDate] [nvarchar] (40) NULL ,
	[DN] [nvarchar] (2048) NOT NULL ,
	[LDAPServer] [nvarchar] (255) NULL ,
	[LDAPUsername] [nvarchar] (500) NULL ,
	[LDAPPassword] [nvarchar] (255) NULL ,
	[TheTimestamp] [binary] (8) NULL ,
	[TheHiddenTimestamp] [timestamp] NULL 
) ON [PRIMARY]


GO

ALTER TABLE [dbo].[Mapping_Points] WITH NOCHECK ADD 
	CONSTRAINT [PK_Mapping_Points] PRIMARY KEY  CLUSTERED 
	(
		[AutoID]
	)  ON [PRIMARY] 

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Mapping_Exclusions]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Mapping_Exclusions]


GO


CREATE TABLE [dbo].[Mapping_Exclusions] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[ParentID] [int] NOT NULL ,
	[DN] [nvarchar] (2048) NOT NULL, 
	[TheTimestamp] [binary] (8) NULL ,
	[TheHiddenTimestamp] [timestamp] NULL 
) ON [PRIMARY]

GO

-- ReportVersions: used to compare extended nap reports with reports installed in console
--	used by AVISP_CompareReportVersions
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportVersions')
	drop table ReportVersions
GO

CREATE TABLE [dbo].[ReportVersions] (
 [ProductCode] [nvarchar] (50) NOT NULL ,
 [Path] [nvarchar] (255) NULL ,
 [FileName] [nvarchar] (255) NOT NULL ,
 [ServerVersion] [nvarchar] (100) NULL ,
 [ClientVersion] [nvarchar] (100) NULL ,
 [DownloadFile] int default(0)
) ON [PRIMARY]
GO

-- ReportEventTables: Stores name of all event tables.
-- Allows remove operation to treat all these as one table, via AVISP_Util_RemoveFromAllEventTables
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReportEventTables]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ReportEventTables]
GO

CREATE TABLE [dbo].[ReportEventTables] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[EventTableName] [nvarchar] (255) NULL ,
	[DateTimeFieldName] [nvarchar] (255) NULL ,
	[Active] [int] default 1 ,
) ON [PRIMARY]
GO


-- new event fields for VS7.5:  VirusSource, Numeric type, Buffer Overflow data
--	add columns only if not present
Begin
SELECT  name	FROM         syscolumns
	WHERE	name = 'lVirusType' OR name = 'detectionname' OR
                name = 'modulename' OR name = 'processname' OR
                name = 'apiname' OR name = 'source'

if @@rowcount < 6
ALTER TABLE [dbo].[Events]
ADD
	lVirusType int NULL
	,Source [nvarchar] (255) NULL
	,DetectionName [nvarchar] (128) NULL
	,ProcessName [nvarchar] (128) NULL
	,ModuleName [nvarchar] (128) NULL
	,APIName [nvarchar] (128) NULL
end
GO


ALTER TABLE [dbo].[Mapping_Exclusions] WITH NOCHECK ADD 
	CONSTRAINT [PK_Mapping_Exclusions] PRIMARY KEY  CLUSTERED 
	(
		[AutoID]
	)  ON [PRIMARY] 

GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_Delete_Mapping_Points]'))
drop procedure [dbo].[SP_Delete_Mapping_Points]

GO


CREATE PROCEDURE dbo.SP_Delete_Mapping_Points
( 
@AutoID INT
) 
AS 
BEGIN
SET NOCOUNT ON

delete Mapping_Points where AutoID=@AutoID

SET NOCOUNT OFF
END

GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DeleteFrom_Mapping_Points]'))
drop trigger [dbo].[TR_EPO_DeleteFrom_Mapping_Points]

GO

CREATE trigger TR_EPO_DeleteFrom_Mapping_Points on Mapping_Points
for delete
as
--Delete the Exclusions
DELETE Mapping_Exclusions WHERE ParentID IN (Select AutoID from deleted)

GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DeleteFrom_BranchNode]'))
drop trigger [dbo].[TR_EPO_DeleteFrom_BranchNode]
GO

CREATE trigger TR_EPO_DeleteFrom_BranchNode on BranchNode
for delete
as
--Delete the Policies, Tasks, IPSubnetMasks
DELETE Policy WHERE (ParentType>2) AND (ParentID IN (Select AutoID from deleted))
DELETE Task WHERE (ParentType>2)  AND (ParentID IN (Select AutoID from deleted))
DELETE IPSubnetMask WHERE ParentID IN (Select AutoID from deleted)
DELETE Mapping_Points WHERE EPONodeID IN (Select AutoID from deleted)

GO

-- changed to maintain fullpath table when nodename changes
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_Move_BranchNode]'))
drop trigger [dbo].[TR_EPO_Move_BranchNode]
GO

CREATE TRIGGER TR_EPO_Move_BranchNode on BranchNode
for UPDATE
as
Begin
	IF UPDATE(ParentID)
		BEGIN
		 declare @TheID int
		 select @TheID=AutoID from inserted
		 EXECUTE AVIDALSP_MOVEWITHIN_BranchNode_Enum @TheID
		END
	IF UPDATE(NodeName)
		BEGIN
		 EXECUTE AVIDALSP_CalculateAllNodeIDPaths '','','','NoResultSet'
		END
End
Go


/* sometimes productproperty data added before software table (no nap) */
/* productproperty insert trigger will fail */
/* This trigger assures that avinsert is set correctly in that case */ 
-- changed to maintain fullpath table when nodename changes
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_INSSOFTWARE]'))
drop trigger [dbo].[TR_EPO_INSSOFTWARE]
GO

CREATE TRIGGER TR_EPO_INSSOFTWARE ON [Software] 
for insert
as
begin

UPDATE LeafNode Set AgentVersion = inserted.productversion
  from inserted, ProductProperties
	where
	leafnode.autoid = ProductProperties.parentid
	and inserted.productcode = ProductProperties.productcode
	and inserted.productfamily = 'EPO'
	and inserted.productcode like 'epoagent%'


declare @cnt int
select @cnt=count(*) from software, inserted where software.productcode = inserted.productcode

if @cnt <= 1
UPDATE LeafNode Set AVInstalls = AVInstalls + 1
   WHERE 
	LeafNode.AVinstalls <= 1
	AND LeafNode.AutoID in  
                      (
                           Select ParentID 
                              from inserted, ProductProperties 
                              where inserted.ProductCode = ProductProperties.ProductCode
                              AND ( inserted.ProductFamily in ( 'TVD','TVD_NC' )
									or inserted.ProductFamily like 'TVD_NC%' ) 
                      )     

-- epo3.5 assure than any blank language entries get update to 0000
-- the epo server needs this for some reason
update software set language = '0000' where language = '' or language is null


end
Go

------------------------------------
-- Fix trigger to property delete leafnode.agentversion

IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'TR_EPO_DELPRODSETTINGS' AND type = 'TR')
drop trigger TR_EPO_DELPRODSETTINGS
go

CREATE TRIGGER TR_EPO_DELPRODSETTINGS ON dbo.ProductProperties 
for delete
as
BEGIN
delete ProductSettings where ParentID IN (select AutoID from deleted)

UPDATE LeafNode Set AVInstalls = AVInstalls - 1
   WHERE LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC' ) 
			or aviview_Software.ProductFamily like 'TVD_NC%' ) 
	)     
   AND LeafNode.AVInstalls > 0 


UPDATE LeafNode Set AgentVersion = ''
   WHERE LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND aviview_Software.ProductFamily in ( 'EPO' )
      and deleted.ProductCode like 'ePOAgent%'  )     

   
END
GO


---------------------------
-- Changes from smb: Use dynamic maintained fullpath node table

-- new nodeid path table for EnumProcedures
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportFullPathNodeID')
DROP TABLE dbo.ReportFullPathNodeID 
GO 

CREATE TABLE [dbo].[ReportFullPathNodeID] (
     [PathLength] [int] NULL
     , [FullPathName] [nvarchar] (450) default ''
     , [FullPathShortName] [nvarchar] (450) default ''
     , [FullPathNodeID] [nvarchar] (450) default ''
     , [LowestNodeID] [int] NULL
     , [site] [int] default ''
     , [ParentID] [int] default 0
     , [Type] [int] default 0
     , [NodeName] [nvarchar] (128) default ''
     , [SiteName] [nvarchar] (128) default ''
     , [Subdirectories] [int] default 0
     , [Computers] [int] default 0     
) ON [PRIMARY]
GO

CREATE  CLUSTERED  INDEX [IX_ReportFullPathNodeID] ON [dbo].[ReportFullPathNodeID]([FullPathName]) ON [PRIMARY]
GO

CREATE  UNIQUE  INDEX [IX_ReportFullPathNodeID_1] ON [dbo].[ReportFullPathNodeID]([LowestNodeID]) ON [PRIMARY]
GO

CREATE  INDEX [IX_ReportFullPathNodeID_2] ON [dbo].[ReportFullPathNodeID]([SiteName]) ON [PRIMARY]
GO


-- fix for sql7 sp4: no longer allows create statement within trigger

IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempUserNodeAccessList')
DROP TABLE ReportTempUserNodeAccessList 
GO 

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempUserNodeAccessList')
BEGIN
CREATE TABLE [dbo].[ReportTempUserNodeAccessList] (
 AutoID Integer, NodeName nvarchar(255)
) ON [PRIMARY]
END
GO

-- fix for sql7 sp4: no longer allows create statement within trigger
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempUserEnum')
DROP TABLE ReportTempUserEnum 
GO 

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempUserEnum')
BEGIN
CREATE TABLE [dbo].[ReportTempUserEnum] (
 ParentID int, ChildID int, PathLength int
) ON [PRIMARY]
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempFullPath')
DROP TABLE ReportTempFullPath 
GO 

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportTempFullPath')
BEGIN
 CREATE TABLE [dbo].[ReportTempFullPath]
(CID int, PID int,
     GPID int, GPID1 int,  
     PathLength int,
     FullPathName varchar(500),
     FullPathNodeID varchar(500),
     LowestNodeID int 
	) ON [PRIMARY]
END
GO

-- end smb changes
----------------------------

-------------------------------------------------------------------------------------
-- reporting indexes: place before stored procedure run to get included in query plan

-- create indexes on lookup tables to speed reporting performance 

-- lookup join tables 

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportActionDesc')
CREATE  CLUSTERED  INDEX IX_ReportActionDesc ON ReportActionDesc (ActionIntID) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_LanguageDesc')
CREATE  CLUSTERED  INDEX IX_LanguageDesc ON LanguageDesc (ClientLanguageSuffix) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventFilterDescFast')
CREATE  CLUSTERED  INDEX IX_EventFilterDescFast ON EventFilterDescFast (EventID ) 
GO

--drop index EventFilterDesc.IX_LanguageEvent
IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventFilterDesc')
CREATE  CLUSTERED  INDEX IX_EventFilterDesc ON EventFilterDesc (EventID ) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportUpdateEventDesc')
CREATE  CLUSTERED  INDEX IX_ReportUpdateEventDesc ON ReportUpdateEventDesc (ErrorID) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportTranslations')
CREATE  CLUSTERED  INDEX IX_ReportTranslations ON ReportTranslations (TextID) 
GO

---------------------------------------------------------------------------
-- Set indexes for non localized metadata tables
-- metadata tables 


IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportUICustPages')
CREATE  CLUSTERED  INDEX IX_ReportUICustPages ON dbo.ReportUICustPages (ReportID) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportInputParameters')
CREATE  CLUSTERED  INDEX IX_ReportInputParameters ON dbo.ReportInputParameters (ReportID) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportInputParameterValues')
CREATE  CLUSTERED  INDEX IX_ReportInputParameterValues ON dbo.ReportInputParameterValues (ParmName) 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportInputParametersSaved')
CREATE  CLUSTERED  INDEX IX_ReportInputParametersSaved ON ReportInputParametersSaved (ParmName) 
GO
--RptGroupID?? 


IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportTextPromptStrings')
CREATE  CLUSTERED  INDEX [IX_ReportTextPromptStrings] ON [dbo].[ReportTextPromptStrings]([TextID]) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportTextPromptStrings1')
CREATE  INDEX [IX_ReportTextPromptStrings1] ON [dbo].[ReportTextPromptStrings]([RptGroupID]) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ReportTextPromptStringsUnq')
CREATE  UNIQUE  INDEX [IX_ReportTextPromptStringsUnq] ON [dbo].[ReportTextPromptStrings]([ReportID], [RptGroupID], [LanguageID], [TextID]) ON [PRIMARY]
GO



------------------------------------------------------------------------------------------------
-- epo3.5Perf: Create new lookup table for limiting event table joins and formatting time fields


IF EXISTS (SELECT * FROM sysobjects WHERE name = 'EventDayResolution')
DROP TABLE EventDayResolution 
GO 

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = 'EventDayResolution')
BEGIN
CREATE TABLE [dbo].[EventDayResolution] (
	[AutoID] [int]  ,
	[NodeID] [int]  ,
	[ActionTaken] [int] default 0,
	[TVDEventID] [int] default 0,
	[YearMonthDay] [nvarchar] (20) NULL ,
	[YearWeek] [nvarchar] (20) NULL ,
--	[YearQuarter] [nvarchar] (20) NULL ,
	[YearMonth] [nvarchar] (20) NULL ,
--	[Year] [nvarchar] (20) NULL ,
	[VirusName] [nvarchar] (64) null,
	[ProductName] [nvarchar] (64) null,
	[ProductVersion] [nvarchar] (16) null,
	[HostName] [nvarchar] (64) null,
	[UserName] [nvarchar] (32) null,
) ON [PRIMARY]
END
GO


-- populate the table: faster version of Events for most reports
Begin
Declare @cnt int
select @cnt = count(*) from EventDayResolution

if @cnt = 0
Begin


	insert EventDayResolution 
		(autoid, nodeid, actionTaken, tvdeventid, yearmonthday, 
		YearWeek, --YearQuarter, 
		YearMonth, --Year,
		virusname, productname, productversion, HostName, Username)
	select autoid, nodeid, actiontaken, tvdeventid 
		,convert(char,EventDateTime,102)  
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
--		,DateName(Year, EventDateTime) + '-' + Datename(Quarter, EventDateTime)
		,Substring(convert(char,EventDateTime,120),1,7)
--		,DateName(Year, EventDateTime)
		,virusname, productname, productversion, HostName, Username
	from events
	where virusname > '' and ActionTaken > 0
		and TVDEventid != 1506 and TVDEventid != 4600

End
End
GO

-- create indexes for EventDayResolution in another script


--IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_VirusType')
--CREATE  INDEX [IX_Events_VirusType] ON [dbo].[Events]([VirusType]) ON [PRIMARY]
--GO

-- computer props index
IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_CompProp_DomainOS')
	CREATE  INDEX [IX_CompProp_DomainOS] ON [dbo].[ComputerProperties]([ParentID],[DomainName],[OSType],[OSPlatform]) ON [PRIMARY]
GO



-- epo3.5: reindex leafnode table

IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_LeafNode')
drop INDEX [dbo].[LeafNode].[IX_LeafNode] 
GO


-- put clustered index on autoid so joins to CP, PP, PE and Events just zip together
IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_LeafNode')
CREATE CLUSTERED INDEX [IX_LeafNode] ON [dbo].[LeafNode]([AutoID]) ON [PRIMARY]
GO 

-- put clustered index on autoid so joins to CP, PP, PE and Events just zip together
IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_LeafNodeParent')
CREATE INDEX [IX_LeafNodeParent] ON [dbo].[LeafNode]([ParentID]) ON [PRIMARY]
GO 

-- end epo3.5Perf
------------------------

---------------------------------
-- New field in eventfilter allowing event to not be displayed

ALTER TABLE [dbo].[EventFilter]
ADD
	HideInFilterTab INT default(0)
GO

--
--------------------------------



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_Dupe_Exists]'))
drop procedure [dbo].[EPOSP_Dupe_Exists]

GO


CREATE PROCEDURE dbo.EPOSP_Dupe_Exists 
 @NodeName	nvarchar(255)
AS
BEGIN
	IF (
		(EXISTS 		
			(SELECT TOP 1 ParentID FROM ComputerProperties WHERE ComputerName = @NodeName)
		)
		OR
		(EXISTS 		
			(SELECT TOP 1 NodeName FROM LeafNode WHERE NodeName=@NodeName AND NOT EXISTS 
				(SELECT ComputerName FROM ComputerProperties WHERE ParentID = LeafNode.AutoID)
			)
		)
	)
	BEGIN
		SELECT nResult = 1	-- true
	END
	ELSE
	BEGIN
		SELECT nResult = 0	-- false
	END

END


GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_Computer_Exists]'))
drop procedure [dbo].[EPOSP_Computer_Exists]

GO


CREATE PROCEDURE dbo.EPOSP_Computer_Exists
 @NodeName	nvarchar(255)
AS
BEGIN
	DECLARE @nID INT
	SET @nID=0

	SELECT TOP 1 @nID=ParentID FROM ComputerProperties WHERE ComputerName = @NodeName
	IF (@nID IS NULL)
	BEGIN
		SELECT TOP 1 @nID=AutoID FROM LeafNode WHERE NodeName=@NodeName AND NOT EXISTS 
			(SELECT ComputerName FROM ComputerProperties WHERE ParentID = LeafNode.AutoID)
	END

	IF (@nID IS NULL)
	BEGIN
		SELECT nResult = 0	-- false
	END
	ELSE
	BEGIN
		SELECT nResult = @nID	-- true
	END

END


GO



ALTER TABLE [dbo].[ComputerProperties]
ADD
	Description nvarchar(255) NULL


GO


INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'EPOSERVR3500','ePO Server',
'','','',0x0,'3.5.0','ePO','0409',
'WNTS WNTW','','Products','Windows',16,0) 
GO

-- Insert RepositoryType=Updates
DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'VSCANDAT1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'VSCANDAT1000','DAT',
'','','',0x0,'','UPD_TVD','0000',
'','','Updates','',16,0) 
GO

DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'VSCANENG1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'VSCANENG1000','Engine',
'','','',0x0,'','UPD_TVD','0000',
'','','Updates','',16,0) 
GO

DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'EXTRADAT1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'EXTRADAT1000','Extra.DAT',
'','','',0x0,'','UPD_TVD','0000',
'','','Updates','',16,0) 
GO

DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'SUPERDAT1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'SUPERDAT1000','SuperDAT',
'','','',0x0,'','UPD_TVD','0000',
'','','Updates','',16,0) 
GO

DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'FIRESIGS1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'FIRESIGS1000','IDS Signatures',
'','','',0x0,'','UPD_SECURE','0000',
'','','Updates','',16,0)
GO


DELETE FROM Software
	where RepositoryType = 'Updates' and ProductCode = 'PATCHTMP1000' 
GO

INSERT INTO Software 
(TheTimestamp,ProductCode,SoftwareName,
PackageName,PackDir,ProductCfgPath,InstallGUID,ProductVersion,ProductFamily,Language,
PlatformsSupported,PluginVer,RepositoryType,OSType,RepoFlag,SoftwareType) 
VALUES 
(@@DBTS,'PATCHTMP1000','System Compliance Profiler Rules',
'','','',0x0,'','UPD_SECURE','0000',
'','','Updates','',16,0) 
GO


-----------------------------------------------------------------------------
-- Patch 6 modifies software table to remove bogus PATCH___1000 version that was never released.
-- BZ202698
-- This script was written by the SCP team (Damon Gallaty)
-----------------------------------------------------------------------------
IF EXISTS (SELECT * FROM Software WHERE ProductCode = 'PATCH___1000' AND (SoftwareName = '' OR SoftwareName IS NULL))
BEGIN
DELETE Software WHERE ProductCode = 'PATCH___1000'
END
GO


-- End of Insert RepositoryType=Updates


insert into servertasktype 
(TaskTypeCode, ServerTaskTypeName, Description, Command, CommandType, ConfigPageName, Flags, TheTimestamp)
values 
('COMPLIAN350',114,115,'compliancecheck.exe <STID>',2,'compliancecheck.htm',0,@@DBTS)
GO






----------------------- Server Event changes ----------------------------------

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ServerEvents]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ServerEvents]
GO

CREATE TABLE [dbo].[ServerEvents] (
	[AutoId] [int] IDENTITY (1, 1) NOT NULL ,
	[ProductName] [nvarchar] (64) NULL ,
	[ProductVersion] [nvarchar] (16) NULL ,
	[ProductFamily] [nvarchar] (8) NULL ,
	[ProductID] [nvarchar] (20) NULL ,
	[MachineName] [nvarchar] (512) NULL ,
	[AgentGUID] [nvarchar] (100) NULL ,
	[IPAddress] [nvarchar] (16) NULL ,
	[OSVersion] [nvarchar] (50) NULL ,
	[Username] [nvarchar] (128) NULL ,
	[EventID] [int] NULL ,
	[Severity] [int] NULL ,
	[TimeZoneBias] [int] NULL ,
	[GMTTime] [datetime] NULL ,
	[SourceComputers] [nvarchar] (1024) NULL ,
	[AffectedComputerNames] [ntext] NULL ,
	[AdditionalInformation] [ntext] NULL ,
	[AffectedObjects] [nvarchar] (1024) NULL ,
	[AffectedComputerIPs] [nvarchar] (1024) NULL ,
	[ThreatName] [nvarchar] (1024) NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO


----------------------- End of Server event changes ---------------------------



----------------- Compliance Check Server Task backend --------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ComplianceRule]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[ComplianceRule]

GO

CREATE TABLE [dbo].[ComplianceRule] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[RuleName] [nvarchar] (255) NULL ,
	[ServerTaskID] [int] NULL ,
	[ThresholdValue] [int] NULL ,
	[ThresholdType] [int] NULL ,
	[CheckCondition] [int] NULL ,
	[LastUpdateLapse] [int] NULL ,
	[EngineVerLapse] [int] NULL ,
	[DATVerLapse] [int] NULL ,
	[AgentVer] [nvarchar] (255) NULL ,
	[VscanVer] [nvarchar] (255) NULL ,
	[OS] [int] NULL ,
	[TheTimestamp] [binary] (8) NULL ,
	[TheHiddenTimestamp] [timestamp] NULL 
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[ComplianceRule] WITH NOCHECK ADD 
	CONSTRAINT [PK_ComplianceRule] PRIMARY KEY  CLUSTERED 
	(
		[AutoID]
	)  ON [PRIMARY] 
GO


ALTER TABLE [dbo].[ComplianceRule] WITH NOCHECK ADD 
	CONSTRAINT [DF_ComplianceRule_CheckOS] DEFAULT (0) FOR [CheckCondition],
	CONSTRAINT [DF_ComplianceRule_LastUpdateLapse] DEFAULT (0) FOR [LastUpdateLapse],
	CONSTRAINT [DF_ComplianceRule_EngineVerLapse] DEFAULT (0) FOR [EngineVerLapse],
	CONSTRAINT [DF_ComplianceRule_DATVerLapse] DEFAULT (0) FOR [DATVerLapse],
	CONSTRAINT [DF_ComplianceRule_OS] DEFAULT (0) FOR [OS],
	CONSTRAINT [DF_ComplianceRule_ServerTaskID] DEFAULT (0) FOR [ServerTaskID]
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EPOConst]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[EPOConst]

GO

CREATE TABLE [dbo].[EPOConst] (
	[VarName] [nvarchar] (255) NOT NULL ,
	[VarID] [int] NOT NULL ,
	[VarValue1] [nvarchar] (255) NULL , 
	[VarValue2] [nvarchar] (255) NULL , 
	[VarValue3] [nvarchar] (255) NULL 
) ON [PRIMARY]

GO


CREATE  CLUSTERED  INDEX [IX_EPOConst] ON [dbo].[EPOConst]([VarName]) ON [PRIMARY]

GO

-- List of Operating systems
-- Used by compliance Check.  Compliance Check UI currently hard codes this list, so if this is updated, 
-- then the compliance check UI must be updated as well.
-- TODO: localize this list and then have the compliance check ui use it directly
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',0,'other','other',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',1,'Windows NT Workstation','Windows NT','Workstation')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',2,'Windows NT Server','Windows NT','Server')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',3,'Windows 2000 Professional','Windows 2000','Workstation')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',4,'Windows 2000 Server','Windows 2000','Server')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',5,'Windows Millennium','Windows Millennium',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',6,'Windows XP Home','Windows XP','Personal')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',7,'Windows XP Professional','Windows XP','Professional')
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',8,'Windows 2003','Windows 2003',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',9,'Windows 98','Windows 98',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',10,'Windows 95','Windows 95',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',11,'Linux','Linux',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',12,'Mac','Mac',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',13,'Netware','Netware',NULL)
INSERT INTO EPOConst (VarName,VarID,VarValue1,VarValue2,VarValue3) VALUES ('OS',14,'WebShield','WebShield',NULL)



GO



IF EXISTS (SELECT * FROM sysobjects WHERE ID = object_id(N'[dbo].[EPOSP_ComplianceCheck]'))
DROP PROCEDURE [dbo].[EPOSP_ComplianceCheck]

GO

-- Return list of computers that are non-compliant
CREATE PROCEDURE dbo.EPOSP_ComplianceCheck 
 @RuleID INT
AS
BEGIN
	SET NOCOUNT ON

	-- Locals
	DECLARE @R_LastUpdateLapse INT
	DECLARE @R_CheckOS INT
	DECLARE @R_CheckDAT INT
	DECLARE @R_CheckEngine INT
	DECLARE @R_CheckAgentVer_This INT
	DECLARE @R_CheckAgentVer_Latest INT
	DECLARE @R_CheckSoftware INT
	DECLARE @R_DATVerLapse INT
	DECLARE @R_EngineVerLapse INT
	DECLARE @R_AgentVer_This NVARCHAR(100)
	DECLARE @AgentVer_Latest NVARCHAR(100)
	DECLARE @DATVer INT
	DECLARE @EngineVer INT
	DECLARE @R_VscanVer NVARCHAR(100)
	DECLARE @szTemp NVARCHAR(255)
	DECLARE @R_OS INT
	
	SELECT TOP 1 
		@R_LastUpdateLapse=LastUpdateLapse, 
		@R_CheckOS=CheckCondition & 0x1, 
		@R_CheckDAT=CheckCondition & 0x2, 
		@R_CheckEngine=CheckCondition & 0x4, 
		@R_CheckAgentVer_This=CheckCondition & 0x8, 
		@R_CheckAgentVer_Latest=CheckCondition & 0x10, 
		@R_CheckSoftware=CheckCondition & 0x20, 
		@R_DATVerLapse=DATVerLapse,
		@R_EngineVerLapse=EngineVerLapse,
		@R_AgentVer_This=AgentVer,
		@R_VscanVer=VscanVer,
		@R_OS=OS
	FROM ComplianceRule 
	WHERE AutoID = @RuleID
	
	DECLARE @LastUpdateThreshold NVARCHAR(16)
	SET @LastUpdateThreshold = convert(varchar(8),DATEADD ( Day, 0-@R_LastUpdateLapse, GETDATE()),112) + '000000'
	
	-- Get Repository version values --
	IF (@R_CheckDAT <> 0)
	BEGIN
		SELECT TOP 1 @DATVer=CAST(REPLACE(ProductVersion,'.','') AS INT) FROM Software WHERE ProductCode='VSCANDAT1000'
		IF (@DATVer IS NULL)
		BEGIN
			-- log the error
			SET @R_CheckDAT = 0
		END
	END
	
	IF (@R_CheckEngine <> 0)
	BEGIN
		SELECT TOP 1 @EngineVer=CAST(REPLACE(ProductVersion,'.','') AS INT) FROM Software WHERE ProductCode='VSCANENG1000'
		IF (@EngineVer IS NULL)
		BEGIN
			-- todo: log the error
			SET @R_CheckEngine = 0
		END
	END
	
	IF (@R_CheckAgentVer_Latest <> 0)
	BEGIN
		SELECT @AgentVer_Latest=max(ProductVersion) FROM Software WHERE ProductCode LIKE 'EPOAGENT%' 
		IF (@AgentVer_Latest IS NULL)
		BEGIN
			-- todo: log the error
			SET @R_CheckAgentVer_Latest = 0
		END
	END
	

	-- Create Temp table for list of computers
	CREATE TABLE #TempComputers 
	(
		[ComputerName] [nvarchar] (255) NULL 	--TODO: see if adding an index here makes this faster or slows it down.
	)


	-- Run through a cursor to check each computer for compliance
	DECLARE @tempc NCHAR
	DECLARE @L_NodeName NVARCHAR(255)
	DECLARE @L_AutoID INT
	DECLARE @P_DatVer  NVARCHAR(50)
	DECLARE @P_EngineVer NVARCHAR(100)
	DECLARE @L_AgentVersion NVARCHAR(50)
	DECLARE @P_ProductVersion NVARCHAR(50)
	DECLARE @P_ProductCode NVARCHAR(50)
	DECLARE @Add_Computer INT

	SET @Add_Computer = 0

	DECLARE Cursor_Compliance CURSOR FOR
		SELECT L.NodeName,L.AutoID,P.DatVer,P.EngineVer,L.AgentVersion,P.ProductVersion,P.ProductCode
		FROM 	LeafNode AS L 
			INNER JOIN ComputerProperties AS C on (L.AutoID = C.ParentID)
			LEFT OUTER JOIN ProductProperties AS P on (L.AutoID = P.ParentID)
		WHERE 	
		-- Criteria: This conditions must be true for the computers to be included in the non-compliant set --
		(
			-- Operating System	
			(
				(@R_CheckOS=0) 
				OR 
				((
					(
						POWER
						(	
							2,
							(SELECT VarID FROM EPOConst WHERE VarName='OS' AND VarValue2=C.OSType AND (VarValue3 IS NULL OR VarValue3=C.OSPlatform))
						)
					)
					& 
					@R_OS
				) <>0 )
			)
		
			-- Time since last communication
			AND ((@R_LastUpdateLapse <= 0) OR (L.LastUpdate>@LastUpdateThreshold))
		)

	OPEN Cursor_Compliance

	FETCH NEXT FROM Cursor_Compliance
	INTO @L_NodeName,@L_AutoID,@P_DatVer,@P_EngineVer,@L_AgentVersion,@P_ProductVersion,@P_ProductCode

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @Add_Computer = 0

		-- Compliance Definition: 	If any of these conditions fail, the computers are to be included in the non-compliant set.  --
	
		-- Check VScan present 
		IF  
		(
			(
				(@R_CheckDAT<>0)
				OR
				(@R_CheckEngine<>0)
				OR
				(@R_CheckSoftware<>0)
			)
			
			AND
			(
				NOT EXISTS (SELECT P3.ParentID FROM ProductProperties AS P3 WHERE P3.ParentID = @L_AutoID AND P3.ProductCode LIKE 'VIRUSCAN%')
			)
	
		)
		SET @Add_Computer = 1

		-- DAT Version
		IF (
			-- Compliance check only fails if checkflag on   and   the dats are old.
			(@R_CheckDAT<>0)
			AND
			(
				(@P_ProductCode LIKE 'VIRUSCAN%') 
				AND
				NOT 
				( (@DATVer - (CAST(REPLACE(@P_DatVer,'.','') AS INT))) <= @R_DATVerLapse)
			)
		)
		SET @Add_Computer = 1		

		-- Engine Version
		IF (
			-- Compliance check only fails if checkflag on   and   the dats are old.
			(@R_CheckEngine<>0)
			AND
			(
				(@P_ProductCode LIKE 'VIRUSCAN%') 
				AND 
				NOT
				( (@EngineVer - (CAST(REPLACE(@P_EngineVer,'.','') AS INT))) <= @R_EngineVerLapse)
			)
		)
		SET @Add_Computer = 1

		-- Agent Version (this)
		IF (@R_CheckAgentVer_This<>0)
		BEGIN

			EXEC SP_CompareVer @L_AgentVersion,@R_AgentVer_This,@out=@tempc output
		
			IF (@tempc ='<')
				SET @Add_Computer = 1			
		END

		-- Agent Version (latest)
		IF (@R_CheckAgentVer_Latest<>0)
		BEGIN
			EXEC SP_CompareVer @L_AgentVersion,@AgentVer_Latest,@out=@tempc output
		
			IF (@tempc ='<')
				SET @Add_Computer = 1				
		END
			
		-- Software: Check that VirusScan is a new enough version
		IF ((@R_CheckSoftware<>0) AND (@P_ProductCode LIKE 'VIRUSCAN%'))
		BEGIN
			EXEC SP_CompareVer @P_ProductVersion,@R_VscanVer,@out=@tempc output

			IF (@tempc='<')
				SET @Add_Computer = 1				
		END
		-- end compliance definitions

		IF ((@Add_Computer=1) AND (NOT EXISTS (SELECT ComputerName FROM #TempComputers AS t WHERE @L_NodeName=t.ComputerName)))
		BEGIN
	
			INSERT INTO #TempComputers (ComputerName) VALUES (@L_NodeName)
		END

		FETCH NEXT FROM Cursor_Compliance
		INTO @L_NodeName,@L_AutoID,@P_DatVer,@P_EngineVer,@L_AgentVersion,@P_ProductVersion,@P_ProductCode
	END	
	CLOSE Cursor_Compliance
	DEALLOCATE Cursor_Compliance		

	SELECT ComputerName FROM #TempComputers ORDER BY ComputerName ASC
END


GO


/* Use the version of the Compliance Check below when support for SQL 7 is dropped.
   It is more efficient, but it is not compatible with SQL 7, so a different implementation is used

-- Return list of computers that are non-compliant
CREATE PROCEDURE dbo.EPOSP_ComplianceCheck 
 @RuleID INT
AS
BEGIN

	-- Locals
	DECLARE @R_LastUpdateLapse INT
	DECLARE @R_CheckOS INT
	DECLARE @R_CheckDAT INT
	DECLARE @R_CheckEngine INT
	DECLARE @R_CheckAgentVer_This INT
	DECLARE @R_CheckAgentVer_Latest INT
	DECLARE @R_CheckSoftware INT
	DECLARE @R_DATVerLapse INT
	DECLARE @R_EngineVerLapse INT
	DECLARE @R_AgentVer_This NVARCHAR(100)
	DECLARE @AgentVer_Latest NVARCHAR(100)
	DECLARE @DATVer INT
	DECLARE @EngineVer INT
	DECLARE @R_VscanVer NVARCHAR(100)
	DECLARE @szTemp NVARCHAR(255)
	DECLARE @R_OS INT
	
	SELECT TOP 1 
		@R_LastUpdateLapse=LastUpdateLapse, 
		@R_CheckOS=CheckCondition & 0x1, 
		@R_CheckDAT=CheckCondition & 0x2, 
		@R_CheckEngine=CheckCondition & 0x4, 
		@R_CheckAgentVer_This=CheckCondition & 0x8, 
		@R_CheckAgentVer_Latest=CheckCondition & 0x10, 
		@R_CheckSoftware=CheckCondition & 0x20, 
		@R_DATVerLapse=DATVerLapse,
		@R_EngineVerLapse=EngineVerLapse,
		@R_AgentVer_This=AgentVer,
		@R_VscanVer=VscanVer,
		@R_OS=OS
	FROM ComplianceRule 
	WHERE AutoID = @RuleID
	
	DECLARE @LastUpdateThreshold NVARCHAR(16)
	SET @LastUpdateThreshold = convert(varchar(8),DATEADD ( Day, 0-@R_LastUpdateLapse, GETDATE()),112) + '000000'
	
	-- Get Repository version values --
	IF (@R_CheckDAT <> 0)
	BEGIN
		SELECT TOP 1 @DATVer=CAST(REPLACE(ProductVersion,'.','') AS INT) FROM Software WHERE ProductCode='VSCANDAT1000'
		IF (@DATVer IS NULL)
		BEGIN
			-- log the error
			SET @R_CheckDAT = 0
		END
	END
	
	IF (@R_CheckEngine <> 0)
	BEGIN
		SELECT TOP 1 @EngineVer=CAST(REPLACE(ProductVersion,'.','') AS INT) FROM Software WHERE ProductCode='VSCANENG1000'
		IF (@EngineVer IS NULL)
		BEGIN
			-- todo: log the error
			SET @R_CheckEngine = 0
		END
	END
	
	IF (@R_CheckAgentVer_Latest <> 0)
	BEGIN
		SELECT @AgentVer_Latest=max(ProductVersion) FROM Software WHERE ProductCode LIKE 'EPOAGENT%' 
		IF (@AgentVer_Latest IS NULL)
		BEGIN
			-- todo: log the error
			SET @R_CheckAgentVer_Latest = 0
		END
	END
	
	
	SELECT DISTINCT ComputerName=L.NodeName
	
	FROM 	LeafNode AS L 
		INNER JOIN ComputerProperties AS C on (L.AutoID = C.ParentID)
		LEFT OUTER JOIN ProductProperties AS P on (L.AutoID = P.ParentID)
	
	WHERE 	
	-- Criteria: This conditions must be true for the computers to be included in the non-compliant set --
	(
		-- Operating System	
		(
			(@R_CheckOS=0) 
			OR 
			((
				(
					POWER
					(	
						2,
						(SELECT VarID FROM EPOConst WHERE VarName='OS' AND VarValue2=C.OSType AND (VarValue3 IS NULL OR VarValue3=C.OSPlatform))
					)
				)
				& 
				@R_OS
			) <>0 )
		)
	
		-- Time since last communication
		AND ((@R_LastUpdateLapse <= 0) OR (L.LastUpdate>@LastUpdateThreshold))
	)
	
	AND
	
	-- Compliance Definition: 	If any of these conditions fail, the computers are to be included in the non-compliant set.  --
	(
		-- Check VScan present 
		(
			(
				(@R_CheckDAT<>0)
				OR
				(@R_CheckEngine<>0)
				OR
				(@R_CheckSoftware<>0)
			)
			
			AND
			(
				NOT EXISTS (SELECT P3.ParentID FROM ProductProperties AS P3 WHERE P3.ParentID = L.AutoID AND P3.ProductCode LIKE 'VIRUSCAN%')
			)
	
		)
	
		OR
	
		-- DAT Version
		(
			-- Compliance check only fails if checkflag on   and   the dats are old.
			(@R_CheckDAT<>0)
			AND
			(
				(P.ProductCode LIKE 'VIRUSCAN%') 
				AND
				NOT 
				( (@DATVer - (CAST(REPLACE(P.DatVer,'.','') AS INT))) <= @R_DATVerLapse)
			)
		)
	
		-- Engine Version
		OR
		(
			-- Compliance check only fails if checkflag on   and   the dats are old.
			(@R_CheckEngine<>0)
			AND
			(
				(P.ProductCode LIKE 'VIRUSCAN%') 
				AND 
				NOT
				( (@EngineVer - (CAST(REPLACE(P.EngineVer,'.','') AS INT))) <= @R_EngineVerLapse)
			)
		)
	
	
		-- Agent Version (this)
		OR 
		(
			(@R_CheckAgentVer_This<>0)
			AND
			(dbo.fn_CompareVer(L.AgentVersion,@R_AgentVer_This)='<')
		)
	
		-- Agent Version (latest)
		OR 
		(
			(@R_CheckAgentVer_Latest<>0)
			AND
			(dbo.fn_CompareVer(L.AgentVersion,@AgentVer_Latest)='<')
		)
	
		-- Software: Check that VirusScan is a new enough version
		OR
		(
			(@R_CheckSoftware<>0)
			AND
			( (P.ProductCode LIKE 'VIRUSCAN%') and (dbo.fn_CompareVer(P.ProductVersion,@R_VscanVer)='<')) 
		)	
	)
		
	ORDER BY NODENAME ASC

END

*/


--------------- end of Compliance Check Server Task backend -------------------


--------------------------- Remove unsupported legacy products

-- Set retired products for reporting only
-- never delete a retired product from the software table that may still need to be reported on
UPDATE software SET RepoFlag=1 WHERE ProductCode IN ('GSDOMINO5000')
GO

-- remove tasks & policies for all legacy products
-- dont delete agent tasks, this is done in the agent upgrade script
delete TaskSettings 
from Task
Where 
TaskSettings.ParentID = Task.AutoID
and ProductCode in ('GSDOMINO5000')
GO

delete Task
Where 
ProductCode in ('GSDOMINO5000')
GO

delete PolicySettings 
from Policy
Where 
PolicySettings.ParentID = Policy.AutoID
and ProductCode in ('GSDOMINO5000')
GO

delete Policy
Where 
ProductCode in ('GSDOMINO5000')

GO

--------------------- end of removing unsupported products


---------- Validate an Address (i.e. IP Address).  Returns 1=valid, 0=invalid.
if exists (select * from sysobjects where id = object_id(N'[dbo].[sp_IsValidAddress]'))
drop procedure [dbo].[sp_IsValidAddress]

GO

CREATE PROCEDURE dbo.sp_IsValidAddress 
(
 @Address NVARCHAR(255),
 @out INT OUTPUT
)
AS
BEGIN

IF (@Address IS NULL)
BEGIN
	SET @out=0
	RETURN 
END

IF (LEN(@Address)<7)
BEGIN
	SET @out=0
	RETURN 
END


IF (@Address='0.0.0.0')
BEGIN
	SET @out=0
	RETURN 
END


-- validate addr
DECLARE @iter INT
DECLARE @i INT
DECLARE @j INT

SET @iter=0
SET @i=1
WHILE (@iter<3)
BEGIN
	SET @j=CHARINDEX('.',@Address,@i)
	if (@j=0)
	BEGIN
		SET @out=0
		RETURN 
	END

	SET @i=@j+1
	SET @iter = @iter+1
END -- end while

SET @out=1
RETURN 

END -- end fn



GO



------- Copy data from Computerprops to Networks for Snowcap
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_CompProp2Net]'))
drop procedure [dbo].[EPOSP_CompProp2Net]

GO

CREATE PROCEDURE dbo.EPOSP_CompProp2Net 
(
 @CompPropID INT
)
AS
BEGIN
SET NOCOUNT ON

DECLARE @SubnetMask NVARCHAR(26)
DECLARE @NetAddress NVARCHAR(26)
DECLARE @NetAddressNum INT
DECLARE @NetName NVARCHAR(256)
DECLARE @nTemp NUMERIC(19,0)
DECLARE @szTemp NVARCHAR(10)
DECLARE @i INT
DECLARE @j INT
DECLARE @iteration INT
DECLARE @Validate INT

SELECT @SubnetMask=SubnetMask, @NetAddress=SubnetAddress, @NetName=IPHostName 
FROM ComputerProperties
WHERE ParentID = @CompPropID

-- Validate NetAddress & SubnetMask
EXEC sp_IsValidAddress @NetAddress,@out=@Validate output
IF (@Validate = 0)
	RETURN
EXEC sp_IsValidAddress @SubnetMask,@out=@Validate output
IF (@Validate = 0)
	RETURN

-- Calculate Net Address Num
SET @NetAddressNum = 1
SET @nTemp=0
SET @j = 0
SET @iteration = 0
WHILE (@iteration<4)
BEGIN
	IF (@iteration<3)
	BEGIN
		SET @i = @j+1
		SET @j = CHARINDEX('.', @NetAddress, @j+1)
		SET @szTemp = SUBSTRING(@NetAddress, @i, @j-@i)
	END
	ELSE
	BEGIN
		SET @szTemp = SUBSTRING(@NetAddress, @j+1, LEN(@NetAddress)-1)
	END

	SET @nTemp = @nTemp + (CAST(@szTemp AS NUMERIC(19,0)) * (POWER( 2, ((3-@iteration)*8) )))
	SET @iteration = @iteration + 1
END
SET @nTemp = ((@nTemp - 2147483647)-1)
SET @NetAddressNum = CAST (@nTemp AS INT)

-- Insert data to Networks table
IF (NOT EXISTS (SELECT * FROM Networks WHERE SubnetMask=@SubnetMask and NetworkAddress=@NetAddress))
BEGIN
	INSERT INTO Networks 
	(NetworkName, SubnetMask, NetworkAddress, Covered, NetworkAddressNum)
	VALUES
	(@NetName, @SubnetMask, @NetAddress, 0, @NetAddressNum)
END -- end if

END -- end proc


GO



IF EXISTS (SELECT * FROM sysobjects WHERE ID = object_id(N'[dbo].[EPOSP_FindByMAC]'))
DROP PROCEDURE [dbo].[EPOSP_FindByMAC]

GO

CREATE PROCEDURE EPOSP_FindByMAC
( @szMac NVARCHAR (100))
AS
BEGIN

DECLARE @nResult INT

IF @szMac IS NULL
BEGIN
	SELECT nResult=0
	RETURN
END

IF @szMac = ''
BEGIN
	SELECT nResult=0
	RETURN
END

SELECT top 1 @nResult = c.parentid 
	FROM computerproperties as c
	WHERE (c.NetAddress=@szMac)
IF (@nResult IS NULL)
BEGIN
	SET @nResult = 0
END

SELECT @nResult AS nResult
END

GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_MoveLeafNode]'))
drop procedure [dbo].[SP_MoveLeafNode]

GO

CREATE PROCEDURE SP_MoveLeafNode
(
@AutoID INT,
@NewParentID INT,
@UserRootID INT,
@NodeName nvarchar(255)
)
AS
BEGIN
SET NOCOUNT ON

-- Update the ParentID
UPDATE LeafNode SET ParentID=@NewParentID WHERE AutoID=@AutoID 

-- Delete Tasks that have a GlobalTaskID that equals the ID of a task that belongs to the context node DELETE Task WHERE
DELETE Task 
WHERE 
(JustPlaceHolder=1)
AND
(ParentID=@AutoID)
AND
(ParentType<3)
AND
(GlobalTaskID IN (SELECT AutoID FROM Task WHERE ParentID=@AutoID))

SELECT 0 AS nResult

END

GO


-- New ver insertupdateevents has a bug fixed
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_InsertUpdateEvent]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_InsertUpdateEvent]
GO

CREATE PROCEDURE dbo.EPOSP_InsertUpdateEvent
(
   @AgentGUID 		uniqueidentifier,
   @HostName		NVARCHAR(512),
   @HostIPAddress 	NVARCHAR(16),
   @UserName   		NVARCHAR(32),
   @TimeZoneBias 	INT,
   @TVDEventID		INT,
   @TVDSeverity         INT,        
   @EventDateTime       DATETIME,                       
   @Type   		NVARCHAR(50),
   @Version   		NVARCHAR(50),
   @Error   		INT,
   @Locale   		NVARCHAR(50),
   @ProductCode		NVARCHAR(50),
   @SiteName		NVARCHAR(100),
   @InitiatorID 	NVARCHAR (50),
   @InitiatorType	NVARCHAR  (50)
)
AS
BEGIN         
SET XACT_ABORT ON
SET NOCOUNT ON

DECLARE @NodeID INT
DECLARE @EventLocalDateTime  DATETIME


IF (@EventDateTime IS NOT NULL)
BEGIN
	SET @EventLocalDateTime = DATEADD(minute, -@TimeZoneBias, @EventDateTime)
END


SELECT @NodeID = (SELECT TOP 1 AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID)
IF @NodeID IS NULL
BEGIN	
	SET @NodeID = 0
END

INSERT INTO ProductEvents 
	(HostName, AgentGUID, NodeID, UserName, HostIPAddress,
	TVDEventID,TVDSeverity,EventDateTime,EventLocalDateTime,
	Type,Version,Error,Locale,ProductCode,SiteName,InitiatorID,InitiatorType) 

 VALUES (@HostName, @AgentGUID, @NodeID, @UserName, @HostIPAddress,
	@TVDEventID,@TVDSeverity,@EventDateTime,@EventLocalDateTime,
	@Type,@Version,@Error,@Locale,@ProductCode,@SiteName,@InitiatorID,@InitiatorType) 

END

GO

-- fix upgrade senario where two agent2000lynx products exist in software table
Delete software 
where productcode = 'ePOAgent2000LYNX' and installguid = '{00000000-0000-0000-0000-000000000000}'
GO




IF EXISTS (SELECT * FROM sysobjects WHERE name = 'TR_EPO_DELSERVERTASKSETTINGS')
DROP TRIGGER TR_EPO_DELSERVERTASKSETTINGS
GO 

CREATE TRIGGER TR_EPO_DELSERVERTASKSETTINGS ON [ServerTask] 
FOR DELETE
as
BEGIN
DELETE ServerTaskSetting WHERE ParentID IN (SELECT AutoID FROM DELETED)
DELETE ComplianceRule WHERE ServerTaskID IN (SELECT AutoID FROM DELETED)
END

GO


-- end with comment to make sure last GO has a CR
