--------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------
/* Compliance Issues Report */
-- ePO3.5 SP2: This version removes the Unresolved Viruses rule from this report as
--	a performance enhancement.
--	To add this rule back simply re-run the aviprocedures.sql procedure

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_FilterComplianceIssues]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_FilterComplianceIssues]
GO



CREATE PROCEDURE dbo.AVISP_FilterComplianceIssues
(
 @iNameSpaceName  VARCHAR(20)
 , @iNameSpaceNode  VARCHAR(20)
 , @szEpoUserName  VARCHAR(100)
 , @szNameSpaceName  VARCHAR(100)
 , @szNameSpaceNode  VARCHAR(500)
 , @szOptionalReportParms  VARCHAR(500) = ''
 , @InfectionCheckPoint 		varchar(64)
 , @AsciCheckPoint 		varchar(64)
  , @AsciRule 			varchar(64) 
  , @InfectAfterRule 		varchar(64)

-- , @iMinMachineCount		int =5		-- outbreak def'n
-- , @iMinFilenameCount		int =5		-- outbreak def'n
-- , @iHourRange			int =24		-- outbreak def'n
-- , @RuleCutoff		int=7

)
AS
BEGIN
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

      	/* Get ID to filter on: Users top node, user selected filter node (< top node), */
	/*    or no filtering (0) if users top node = root node and no filter selected */
 	Declare @UsersTopNodeID int
 	Declare @FilterNodeID int
	Declare @ret int
 	select @UsersTopNodeID = convert(int, @iNameSpaceName)
 	select @FilterNodeID = convert(int, @iNameSpaceNode)


 	Declare @FilterID int
 	EXECUTE AVIDALSP_GetNodeIDFilter @UsersTopNodeID, @FilterNodeID, @FilterID OUTPUT

    /* Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc */
   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(64)
   Declare @szReportID VARCHAR(64)
   Declare @szRptGroup VARCHAR(64)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT



	-- Fetch Infect After date variables
	Declare @ConnectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @AsciCheckPoint, @AsciRule, @ConnectYYYYMMDD output

	-- Fetch Infect After date variables
	Declare @InfectYYYYMMDD datetime
	execute dbo.AVISP_GetDateConversion @InfectionCheckPoint, @InfectAfterRule, @InfectYYYYMMDD output

	-- 'all now returns blank value which must be altered for this report
	if @InfectYYYYMMDD = '' or @InfectYYYYMMDD is null
		set @InfectYYYYMMDD = '19900101'
	if @ConnectYYYYMMDD = '' or @ConnectYYYYMMDD is null
		set @ConnectYYYYMMDD = '19900101'

	/* Stored procedure to create a table of nodeids, computers, agent versions, and summary event count data */
	/* This table persists and is recreated each time the report runs */

	Execute AVISP_SetComputerSummary @InfectYYYYMMDD, @ConnectYYYYMMDD, NULL


	------------------------------
	-- read in translated terms
   	Declare @Server varchar(50)			
   	Declare @WorkStation varchar(50)			
	Declare @Professional varchar(50)	
		

	If @Server = '' or @Server is null				-- if first is not found assume they all are
	Begin
   		Set @Server = 'Server'	Set @WorkStation = 'Workstation'	
		Set @Professional = 'Professional'
	End

	-- if not english, read in translations
	if @szFullLang <> '0409' 
--		and @szFullLang <> '0411'  -- jp rpt will use chart labels instead of legends which wont display jp chars
--		and @szFullLang <> '0412'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0404'  -- apac chars dont display in charts, keep this english
--		and @szFullLang <> '0804'  -- apac chars dont display in charts, keep this english
	Begin
		Select 	@Server = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Server'
		Select 	@WorkStation = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'WorkStation'
		Select 	@Professional = TranslatedValue from ReportTranslations 
			Where LanguageID = @szFullLang and Subject = 'General' and TextID = 'Professional'
	End


	------------------------------------------------------------------------------------------
	-- If no data exists in ReportComplianceComparison table then run routine to fill it
	-- Do this so that there is data in the compliance subreports
	Declare @dtInfectionCheckPoint DateTime
	Set @dtInfectionCheckPoint = DateAdd( day, -1, GetDate())
	if not exists ( select * from ReportComplianceComparison )
		Execute dbo.AVISP_SetComplianceComparison
			 @iNameSpaceName  
			 , @iNameSpaceNode  
			 , @szEpoUserName  
--			 , @szNameSpaceName 
--			 , @szNameSpaceNode  
			 , @szOptionalReportParms  
			 , @dtInfectionCheckPoint 


/*************************************************************************/
-- Fetch compliance rules - Rule Value if given a Rule description (Most Recent, ...)

--	Close ProdFams
--	Deallocate ProdFams

	Declare @MinAgentVersion nvarchar(50)

	select @MinAgentVersion=ParmValue from ReportInputParameters 
		where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES' 
			and ReportInputParameters.Parmname = 'ePO Agent' 


	-- postepo3 Change table name here and in dateng report so it doesnt match the table name
	--	used within the getrule routine (make columns bigger)
	IF EXISTS (select * from sysobjects where name = 'tmpPFVer' 
   		and xtype = 'U')
 	DROP TABLE dbo.tmpPFVer

	CREATE TABLE [dbo].[tmpPFVer] (
	ProductFamily nvarchar(50)
	 ,[AutoID] [int] NULL 
	 ,[Version] [nvarchar] (100) NULL
	 ,[Rulename] [nvarchar] (100) NULL
	,ParmName nvarchar(100)
	) 

	Insert dbo.tmpPFVer
	Execute dbo.AVISP_GetRuleComplianceIssues
	 @iNameSpaceName  = ''	
	 , @iNameSpaceNode  = ''	
	 , @szEpoUserName  = ''	
	 , @szNameSpaceName  = ''	
	 , @szNameSpaceNode  = ''	
	 , @szOptionalReportParms  = ''	
	 , @Rulename = ''		-- will fetch a particular saved rule name TODO




/**************************************************************************/
/* Implement each compliance rule with a union clause */
/* todo - localize rule name and description (get it from text strings table) */

-- Rules listed by priority - RuleCutoff value wont run any lower rules
-- Rule 1 - No Agents: fetch machines with NO Agent 
-- Rule 2 - No AV Protection: fetch machines with NO AV machines and an Agent 
-- Rule 3 - Unresolved Viruses: fetch machines with unresolved virus after InfectionCheckpoint date
-- Rule 4 - Old DAT/Engine: fetch machines with old dat/engines and recent Asci 
-- Rule 5 - Old Products: fetch machines with old Prod versions and recent Asci 
-- Rule 6 - Old Agent: fetch machines with old Agent versions and recent Asci 
-- Rule 7 - Late Asci: fetch machines with LastAsci < AsciCheckpoint date (recent Asci)



-- Rule 1 - fetch machines with NO Agent 
       SELECT
   	'No Agents' as RuleName
	, 'Machines without an ePO agent' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion 
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE  
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, NodeNameLeaf as ComputerName  -- Use leafnode nodename for noagent since they usually dont have computer props
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
--  	, '' as FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 1 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , '' as Servicepack
	, '' as Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)

  	 )
	AND ReportComputerSummary.NoAgent = 1
--	AND @RuleCutoff > 1

-- Rule 2 - fetch machines with NO AV machines and an Agent 
UNION

       SELECT
   	'No AV Protection' as RuleName
	, 'Machines without anti-virus protection' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 2 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , '' as Servicepack
	, '' as Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.NoAgent = 0
	AND ReportComputerSummary.NoAV = 1
--	AND @RuleCutoff > 2




-- Rule 4 - Old DAT/Engine: fetch machines with old dat/engines and recent Asci 
UNION

       SELECT
   	'Old DAT/Engine' as RuleName
	, 'Machines with outdated DATs or Engines' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	,  ComputerName  
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 4 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        	, Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ReportInputParameters, dbo.tmpPFVer 

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND 
	(
		(ReportInputParameters.ParmName = ReportComputerSummary.ProductFamily + '_DATs'
		and ReportInputParameters.ParmName = dbo.tmpPFVer.ParmName
		and  DATVer < dbo.tmpPFVer.Version	
		)		
		OR
		(ReportInputParameters.ParmName = ReportComputerSummary.ProductFamily + '_Engines'
		and ReportInputParameters.ParmName = dbo.tmpPFVer.ParmName
		and  EngineVer < dbo.tmpPFVer.Version
		)		
	)
--	AND @RuleCutoff > 4

-- Rule 5 - Old Products: fetch machines with old Prod versions and recent Asci 
UNION

       SELECT
   	'Old Products' as RuleName
	, 'Machines with outdated anti-virus scanning products' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 5 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ReportInputParameters

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND  ReportComputerSummary.ProductName = ReportInputParameters.ParmName
	and ReportComputerSummary.ProductVersion < ReportInputParameters.ParmValue

--	AND @RuleCutoff > 5


-- Rule 6 - Old Agent: fetch machines with old Agent versions and recent Asci 
UNION

       SELECT
   	'Old Agent' as RuleName
	, 'Machines with an outdated ePO agent' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 

     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount

	, 6 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ReportInputParameters

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 1
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	AND  ReportComputerSummary.AgentName = ReportInputParameters.ParmName
	and ReportComputerSummary.AgentVersion < ReportInputParameters.ParmValue

--	AND ReportComputerSummary.AsciSinceCheckPoint = 1
--	AND AgentVersion < @MinAgentVersion



-- Rule 7 - Late Asci: fetch machines with LastAsci < AsciCheckpoint date (recent Asci)
UNION

       SELECT
   	'Inactive Agents' as RuleName
	, 'Machines That have not checked-in since ASCI checkpoint cuttoff' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 7 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.AsciSinceCheckPoint = 0
--	AND @RuleCutoff > 7


-- Rule 8 - Duplicate Computers - Machines having duplicate entries in ePO (shows the outdated entry)
UNION

       SELECT
   	'Orphaned Computers' as RuleName
	, 'Machines having duplicate entries in ePO (shows the outdated entry)' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, ProductName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ReportComputerSummary.ProductVersion > '' THEN ReportComputerSummary.ProductVersion
     		ELSE '---' 
     		END
   	, EngineVer =
    		CASE  
     		WHEN ReportComputerSummary.EngineVer > '' THEN ReportComputerSummary.EngineVer 
     		WHEN ReportComputerSummary.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'  
     		END
  	 , DATVer =
    		CASE 
     		WHEN ReportComputerSummary.DATVer > '' THEN ReportComputerSummary.DATVer 
     		WHEN ReportComputerSummary.DATVer = 'N/A' THEN '---' 
     		ELSE '---' 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  ReportComputerSummary.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 8 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , Servicepack
	, Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.DuplicateComputer > 0
--	AND @RuleCutoff > 7


-- Rule 9 - Duplicate Scanners - Machines having duplicate Scanning Products in ePO (shows the outdated entry)
UNION

       SELECT
   	'Orphaned Scanners' as RuleName
	, 'Machines having duplicate Scanning Products in ePO (shows the outdated entry)' as RuleDescription
   	, NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, AgentVersion as AgentVersion
   	, AVIView_Software.SoftwareName as ProductName
   	, ProductVersion =
    		CASE 
     		WHEN ProductProperties.ProductVersion > '' THEN ProductProperties.ProductVersion
     		ELSE '---'
     		END
   	, EngineVer =
    		CASE  
     		WHEN ProductProperties.EngineVer > '' THEN ProductProperties.EngineVer 
     		WHEN ProductProperties.EngineVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
  	 , DATVer =
    		CASE 
     		WHEN ProductProperties.DATVer > '' THEN ProductProperties.DATVer 
     		WHEN ProductProperties.DATVer = 'N/A' THEN '---' 
     		ELSE '---'
     		END
   	, ExtraDATNames =
    		CASE ProductProperties.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ProductProperties.ExtraDATNames 
     		END
	, ProductFamily = 
    	CASE 
     	WHEN  AVIView_Software.ProductFamily = 'TVD' THEN 'McAfee'
     	WHEN  AVIView_Software.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
     	ELSE  AVIView_Software.ProductFamily 
     	END
	, DomainName
	, ComputerName
	, IPAddress
--	   , count(*) as 'ComputerCnt'

	/* This portion is filled in by unions of event data */
  	, '' as VirusName
  	, '' as UserName
    	, CAST('' As varchar(255)) As FileName
  	, '' as VirusType
  	, '' as ActionTaken
  	, '' as EventDateTime 
--  	, 0 as VirusCount
	, 9 as RuleNumber
--	, LastAsci
   	, CONVERT(char(50),
  	 (SUBSTRING( ReportComputerSummary.LastAsci,  1 , 4)+'-'+
   	SUBSTRING( ReportComputerSummary.LastAsci,  5 , 2)+'-'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  7 , 2)+' '+                              

   	SUBSTRING( ReportComputerSummary.LastAsci,  9 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  11 , 2)+':'+                              
   	SUBSTRING( ReportComputerSummary.LastAsci,  13 , 2)                                    
  	 ), 120 )   as LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , ProductProperties.Servicepack
	, ProductProperties.Hotfix
	, ReportComputerSummary.ProductCode as ProductCode
	, ReportComputerSummary.ScannerLanguage as Language
		,case 
			when ReportComputerSummary.OSPlatform = 'Server' then @Server
			when ReportComputerSummary.OSPlatform = 'Workstation' then @Workstation
			when ReportComputerSummary.OSPlatform = 'Professional' then @Professional
			else ReportComputerSummary.OSPlatform
			end 
			as OSPlatform
	, ReportComputerSummary.OSType

 	FROM ReportComputerSummary, ProductProperties, AVIView_Software

	 WHERE  
   	(
   	@FilterID = 0 OR
     	ReportComputerSummary.BranchNodeID = @FilterID OR
    	ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
         	from BranchNodeEnum 
         	where  BranchNodeEnum.StartAutoID = @FilterID)
  	 )
	AND ReportComputerSummary.MultipleScanner > 1
	and ReportComputerSummary.DuplicateScannerID = ProductProperties.AutoID
	and ProductProperties.ProductCode =  AVIView_Software.ProductCode
--	AND @RuleCutoff > 7


/*
-- Rule 10 - Outbreak Infections: Machines affected by an Outbreak
UNION

       SELECT
   	'Outbreak Infections' as RuleName
	, 'Machines affected by an Outbreak' as RuleDescription
   	, ReportComputerSummary.NodeNameBranch as NodeName
	, cast( FullNodePath as varchar(255) ) as FullNodePath
   	, '' as AgentVersion
   	, ReportComputerSummary.ProductName as ProductName
   	, ProductVersion =
    		CASE ReportComputerSummary.ProductVersion
     		WHEN '' THEN '---' 
     		ELSE ReportComputerSummary.ProductVersion
     		END
   	, EngineVer =
    		CASE ReportComputerSummary.EngineVer 
     		WHEN '' THEN '---' 
     		WHEN 'N/A' THEN '---' 
     		ELSE ReportComputerSummary.EngineVer 
     		END
  	 , DATVer =
    		CASE ReportComputerSummary.DATVer 
     		WHEN '' THEN '---' 
     		WHEN 'N/A' THEN '---' 
     		ELSE ReportComputerSummary.DATVer 
     		END
   	, ExtraDATNames =
    		CASE ReportComputerSummary.ExtraDATNames 
     		WHEN 'N/A' THEN '' 
     		ELSE ReportComputerSummary.ExtraDATNames 
     		END
	, ProductFamily = 
 	   	CASE 
 	    	WHEN  ReportComputerSummary.ProductFamily = 'TVD' THEN 'McAfee'
  	   	WHEN  ReportComputerSummary.ProductFamily = 'TVD_NC' THEN 'NonMcAfee'
   	  	ELSE  ReportComputerSummary.ProductFamily 
    	 	END
	, DomainName
	, ComputerName
	, IPAddress

--	   , count(*) as 'ComputerCnt'

	-- This portion is filled in by unions of event data 
  	, VirusName
  	, UserName
    	, CAST(FileName As varchar(255)) As FileName
  	, VirusType
  	, ActionTaken = ReportOutbreakEvents.ActionTaken
--	    	CASE 
-- 	    		WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--	     		WHEN  ReportActionDesc.ActionName = '' THEN '---'
--	     		ELSE  CAST(Events.ActionTaken AS varchar(16))
--	     	END
  	, EventDateTime  
--		= (CASE @szTime
--			WHEN 'GMT' THEN MAX(EventDateTime)
--			ELSE 		MAX(EventLocalDateTime)
--		END) 

 -- 	, count(*) as VirusCount
	, 10 as RuleNumber
	, LastAsci
	, OSVersion
	, ReportComputerSummary.NodeID
        , ReportComputerSummary.Servicepack
	, ReportComputerSummary.Hotfix
	, ReportComputerSummary.ProductCode as ProductCode


 	FROM ReportComputerSummary, ReportOutbreakEvents

	 WHERE  
   	(
   	 @FilterID = 0 OR
	     ReportComputerSummary.BranchNodeID = @FilterID OR
	    ReportComputerSummary.BranchNodeID in (select BranchNodeEnum.EndAutoID 
  	       from BranchNodeEnum 
  	       where  BranchNodeEnum.StartAutoID = @FilterID)
   	)
  	AND ReportOutbreakEvents.NodeID = ReportComputerSummary.NodeID	
	AND VirusName > '' 
	AND ReportOutbreakEvents.EventDateTime > @InfectionCheckPoint
--	AND ActionTaken in ('51','53','55','58','62','64','66')
--	AND @RuleCutoff > 3
	Group by
--   		RuleName
--		, RuleDescription
--   		, 
		ReportComputerSummary.NodeNameBranch
		, FullNodePath
		   , AgentVersion
		   , ReportComputerSummary.ProductName
		   , ReportComputerSummary.ProductVersion
		   , EngineVer
		   , DATVer
		   , ExtraDATNames

		   , DomainName
		   , ProductFamily
		, DomainName
		, ComputerName
		, IPAddress
		, OSVersion
		, LastAsci
		  , VirusName
		  , UserName
		  , FileName
		  , VirusType
		  ,   ActionTaken
--			CASE 
--			WHEN  ReportActionDesc.ActionName > '' THEN ReportActionDesc.ActionName
--			WHEN  ReportActionDesc.ActionName = '' THEN '---'
--			ELSE  CAST(Events.ActionTaken AS varchar(16))
--		     	END
		, EventDateTime
		, LastAsci
		, ReportComputerSummary.NodeID
        , ReportComputerSummary.Servicepack
	, ReportComputerSummary.Hotfix
	, ReportComputerSummary.ProductCode 

*/



	set @ret = @@rowcount

	Drop Table dbo.tmpPFVer

RETURN @ret
END
GO

-- end
