

-- epo3.5 patch1
-- fix 208182: Adjust column sizes on daily snapshot worktables so that they always fit data size.

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
   [NodeNameLeaf] nvarchar (255)
 
ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [NodeNameBranch] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [FullNodePath] nvarchar (500) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ProductName] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [EngineVer] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ComputerLanguage] nvarchar (50) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [DomainName] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSVersion] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [ComputerName] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [IPAddress] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  VirusnameMax nvarchar(128) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  UnresolvedVirusnameMax nvarchar(128) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSPlatform] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummaryPrevious] 
  ALTER COLUMN 
  [OSType] nvarchar (100) 





ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
   [NodeNameLeaf] nvarchar (255)
 
ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [NodeNameBranch] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [FullNodePath] nvarchar (500) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ProductName] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [EngineVer] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ComputerLanguage] nvarchar (50) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [DomainName] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSVersion] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [ComputerName] nvarchar (255) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [IPAddress] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  VirusnameMax nvarchar(128) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  UnresolvedVirusnameMax nvarchar(128) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSPlatform] nvarchar (100) 

ALTER TABLE [dbo].[ReportComputerSummary] 
  ALTER COLUMN 
  [OSType] nvarchar (100) 

-- epo3.5 patch2: fix 212254 - set event category to Normal_Operation because this is not
--	a true virus detecting event. Its just an info event stating that a scan found infections.
--	Notification thus must not display this as a virus event (no virusname)
Update EventFilter 
	set EventCategory = 19
	where EventID = 1038 

-- end

GO


-- epo3.5 patch2: fix 208253 - Remove any orphaned software table entries
delete software 
where
( InstallGuid is null )
and ( productfamily = '' or productfamily is null )
and ( PlatformsSupported = '' or PlatformsSupported is null )
and productcode in (
	select productcode from software
	where 
		( InstallGuid is not null )
		and ( productfamily > '' )
		and ( PlatformsSupported > '' )
)
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_UpdateProdPropFromEvents]
GO

CREATE PROCEDURE dbo.EPOSP_UpdateProdPropFromEvents
 @AgentGUID  uniqueidentifier,			-- matches leafnode.agentGUID
 @MACAddress NVARCHAR(50) = NULL,
 @ProductCode nvarchar(50),	-- matches productproperties.productcode
 @Type nvarchar(50),
 @Version nvarchar(50)

AS
BEGIN
	SET XACT_ABORT ON
	SET NOCOUNT ON

	DECLARE @LeafNodeID INT
	DECLARE @ProdPropID INT
	DECLARE @c CHAR

	SELECT TOP 1 @LeafNodeID = AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID

	if ((@LeafNodeID IS NULL) AND (@MACAddress IS NOT NULL)  AND (@MACAddress<>''))
	BEGIN
		SET @c=LEFT(@MACAddress,1)
		if ( ((@c>='0') AND (@c<='9')) OR ((@c>='A') AND (@c<='F')) OR ((@c>='a') AND (@c<='f')) )
		BEGIN
			SELECT TOP 1 @LeafNodeID = l.Autoid from leafnode as l inner join computerproperties as c on l.autoid=c.parentid where c.netaddress=@MACAddress
		END
	END

	IF (@LeafNodeID IS NOT NULL)
	BEGIN
		SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode

		IF (@ProdPropID IS NULL)
		BEGIN
			--Create prodprop entry
			INSERT INTO ProductProperties 
				(ParentID,ProductCode)
			VALUES
				(@LeafNodeID, @ProductCode)

			SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode
		END

		IF (@ProdPropID IS NOT NULL)
		BEGIN
			if upper(@type) = 'INSTALL'
			begin
				UPDATE ProductProperties 
					SET ProductVersion=@Version 
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szProductVer',
					'General',
					@Version
			end
			if upper(@type) = 'HOTFIX'
			begin
				UPDATE ProductProperties 
					set Hotfix=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szHotfixVersion',
					'General',
					@Version
			end
			if upper(@type) = 'SERVICEPACK'
			begin
				UPDATE ProductProperties 
					set Servicepack=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szServicePackVersion',
					'General',
					@Version
			end
			if upper(@type) = 'DAT'
			begin
				UPDATE ProductProperties 
					set DATVer=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szDATVersion',
					'General',
					@Version
			end
			if upper(@type) = 'ENGINE'
			begin
				UPDATE ProductProperties 
					set EngineVer=@Version
					WHERE AutoID = @ProdPropID
	
				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szEngineVersion',
					'General',
					@Version
			end
			if upper(@type) = 'EXTRADAT'
			begin
				UPDATE ProductProperties 
					set ExtraDatNames=@Version
					WHERE AutoID = @ProdPropID

				EXEC EPOSP_InsertProdSetting
					@ProdPropID,
					'szExtraDATNames',
					'General',
					@Version
			end
		END
	END
END
 
GO


--  *** Block Events Data Filter Lookup ***
-- fix 213014: Rulename data filter lookup missing from VS8 access protection report
IF EXISTS(SELECT NAME 
	  FROM SYSOBJECTS 
	  WHERE NAME = 'AVISP_GetCust_EventsBehaviourBlock' AND TYPE = 'P')
BEGIN
	DROP PROCEDURE dbo.AVISP_GetCust_EventsBehaviourBlock
END
GO

CREATE  PROCEDURE dbo.AVISP_GetCust_EventsBehaviourBlock 
(
    @iNameSpaceName  		INT,
    @iNameSpaceNode         	INT,
    @szEpoUserName           	VARCHAR(100),
    @szFilter			VARCHAR(20) = '',
    @szOptionalReportParms  	VARCHAR(500) = ''
)
AS
BEGIN

 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 -- Get ID to filter on: Users top node, user selected filter node (< top node), 
 --    or no filtering (0) IF users top node = root node AND no filter selected 
 DECLARE @FilterID INT
 EXECUTE AVIDALSP_GetNodeIDFilter @iNameSpaceName, @iNameSpaceNode, @FilterID OUTPUT


  -- Fetch Report Parms: LANG, TIME, FILTER: not all of these are used in every proc 
   DECLARE @szLang VARCHAR(3)
   DECLARE @szFullLang VARCHAR(5)
   DECLARE @szDefaultLang VARCHAR(5)
   DECLARE @szLanguageID VARCHAR(5)
   DECLARE @szTime VARCHAR(10)
   DECLARE @szOPFilter VARCHAR(64)
   DECLARE @szReportID VARCHAR(64)
   DECLARE @szRptGroup VARCHAR(64)
   SET @szLanguageID = '0409'   
   SET @szLang = '09'
   SET @szFullLang = '0'
   SET @szTime = 'GMT'
   SET @szReportID = 'ASCI'


   IF @szOptionalReportParms > ''
   	EXECUTE AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szOPFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT




   ----------------------------------------------------------------
   -- Fetch data depending on input field szFilter


   -- year
   IF @szFilter = 'Year' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- quarter
   ELSE IF @szFilter = 'Quarter' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Quarter, EventDateTime) AS char(1)) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- month
   ELSE IF @szFilter = 'Month' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + Cast(DatePart(Month, EventDateTime) AS char(5)) 
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END

   -- week
   ELSE IF @szFilter = 'Week' 
   BEGIN
	SELECT DISTINCT
		DateName(Year, EventDateTime) + '-' + CAST( DatePart(Week, EventDateTime) AS char(2))
		AS Value
		FROM Events_VSEBehaviourBlock
		WHERE EventDateTime > ''
--		Order by Value Desc		
   END


   ELSE IF @szFilter = 'DomainName'
   BEGIN
	SELECT DISTINCT ComputerProperties.DomainName AS Value 
	    FROM ComputerProperties, 
              ProductProperties, 
              LeafNode
	    WHERE 
		    (
			@FilterID = 0 OR
			LeafNode.ParentID = @FilterID OR
			LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
						FROM BranchNodeEnum 
						WHERE BranchNodeEnum.StartAutoID = @FilterID)
		    )
		    AND ProductProperties.ParentID = LeafNode.AutoID 
			AND LeafNode.AutoID = ComputerProperties.ParentID
		    AND DomainName > ''
   END

   ELSE IF @szFilter = 'RuleName'
   BEGIN
	 SELECT DISTINCT RuleName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE tvdeventid > ''
   END


   ELSE IF @szFilter = 'NodeName' or @szFilter = 'GroupName'
   BEGIN
	 SELECT DISTINCT NodeName AS Value 
	 FROM BranchNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  BranchNode.AutoID = @FilterID OR
		  BranchNode.AutoID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 	 AND NodeName not in ('Directory','GlobalRoot')
   END

   ELSE IF @szFilter = 'OSVersion'
   BEGIN
	 SELECT DISTINCT 
	      cast((ComputerProperties.OSType  + ' ' + ComputerProperties.OSServicePackVer
		+ ' ' + ComputerProperties.OSPlatform) 
	        AS VARCHAR(50)) AS Value 
	 FROM ComputerProperties, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 AND ComputerProperties.ParentID = LeafNode.AutoID 

   END

   ELSE IF @szFilter = 'OSType'
   BEGIN
	 SELECT  DISTINCT OSType AS Value
	 FROM ComputerProperties
	 WHERE ostype > ''
   END

   ELSE IF @szFilter = 'OSPlatform'
   BEGIN
	 SELECT  DISTINCT OSPlatform AS Value
	 FROM ComputerProperties
	 WHERE osplatform > ''
   END

   ELSE IF @szFilter = 'IPAddress' OR @szFilter = 'HostIPAddress' OR @szFilter = 'HostAddr'
   BEGIN
	 SELECT DISTINCT HostIPAddress AS Value 
	 FROM Events, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
		       FROM BranchNodeEnum 
		       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
	 AND Events.NodeID = LeafNode.AutoID
	 AND hostipaddress > ''
   END

   ELSE IF @szFilter = 'EventID' or @szFilter = 'TVDEventID'
   BEGIN
	 SELECT DISTINCT cast(TVDEventID AS VARCHAR(10)) AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE tvdeventid > ''
   END

   ELSE IF @szFilter = 'TVDTaskName'
   BEGIN
	 SELECT DISTINCT TVDTaskName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE Events_VSEBehaviourBlock.TVDTaskName > ''
	 ORDER BY TVDTaskName desc
   END


   ELSE IF @szFilter = 'FileName'
   BEGIN
	-- postepo3 Top 10 files report return the rightmost postion of the filename
	IF @szReportID = 'T10FILE' or @szReportID = 'RESOLVED' or @szReportID = 'UNRESOLVED'
	BEGIN
		 SELECT DISTINCT right(Events_VSEBehaviourBlock.FileName,15) AS Value 
		 FROM Events_VSEBehaviourBlock, LeafNode
		 WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
			       FROM BranchNodeEnum 
			       WHERE BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
			 AND filename > ''
	END
	ELSE
	BEGIN
		SELECT DISTINCT FileName AS Value 
		FROM Events_VSEBehaviourBlock, LeafNode
		WHERE 
			 (
			  @FilterID = 0 OR
			  LeafNode.ParentID = @FilterID OR
			  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
			       FROM BranchNodeEnum 
			       WHERE BranchNodeEnum.StartAutoID = @FilterID)
			 )
			 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
			 AND filename > ''
	END
   END

   ELSE IF @szFilter = 'HostName' OR @szFilter = 'ComputerName'
   BEGIN
	 SELECT DISTINCT HostName AS Value 
	 FROM Events_VSEBehaviourBlock, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
		       FROM BranchNodeEnum 
		       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
		 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
		 AND hostname > ''
   END

   ELSE IF @szFilter = 'ProductName' OR @szFilter = 'ProductCode'
   BEGIN
	 SELECT DISTINCT ProductName AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE ProductName NOT LIKE '%Agent%'
	 AND productname > ''
   END

   ELSE IF @szFilter = 'ProductVersion'
   BEGIN
	 	SELECT DISTINCT ProductVersion AS Value 
	 	FROM Events_VSEBehaviourBlock
	       	WHERE Events_VSEBehaviourBlock.ProductName != 'ePO Agent' 
		AND productversion > ''
   END

   ELSE IF @szFilter = 'FullProductName'
   BEGIN
	 SELECT DISTINCT cast((Events_VSEBehaviourBlock.ProductName + ' ' + Events_VSEBehaviourBlock.ProductVersion) AS VARCHAR(50)) AS Value 
	 FROM Events_VSEBehaviourBlock
	 WHERE Events_VSEBehaviourBlock.ProductName != 'ePO Agent' 
	 AND (Events_VSEBehaviourBlock.ProductName + ' ' + Events_VSEBehaviourBlock.ProductVersion) > ''
   END

   ELSE IF @szFilter = 'UserName'
   BEGIN
	 SELECT DISTINCT UserName AS Value 
	 FROM Events_VSEBehaviourBlock, LeafNode
	 WHERE 
		 (
		  @FilterID = 0 OR
		  LeafNode.ParentID = @FilterID OR
		  LeafNode.ParentID in (SELECT BranchNodeEnum.EndAutoID 
				       FROM BranchNodeEnum 
				       WHERE BranchNodeEnum.StartAutoID = @FilterID)
		 )
		 AND Events_VSEBehaviourBlock.AgentGUID = LeafNode.AgentGUID
		 AND username > ''
   END

   ELSE 
   BEGIN
	 SELECT '---' AS Value
   END

RETURN @@rowcount
END
GO


-- epo3.5 patch2 213085 : Remove any ghost product entries when a new product nap is installed.
--	This prevents the policy compiler from getting confused between the ghost entries (added from
--	installed products before the nap is installed) and the real entries from the nap install.

/* sometimes productproperty data added before software table (no nap) */
/* productproperty insert trigger will fail */
/* This trigger assures that avinsert is set correctly in that case */ 
-- changed to maintain fullpath table when nodename changes
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_INSSOFTWARE]'))
drop trigger [dbo].[TR_EPO_INSSOFTWARE]
GO

CREATE TRIGGER TR_EPO_INSSOFTWARE ON [Software] 
for insert
as
begin

UPDATE LeafNode Set AgentVersion = inserted.productversion
  from inserted, ProductProperties
	where
	leafnode.autoid = ProductProperties.parentid
	and inserted.productcode = ProductProperties.productcode
	and inserted.productfamily = 'EPO'
	and inserted.productcode like 'epoagent%'


declare @cnt int
select @cnt=count(*) from software, inserted where software.productcode = inserted.productcode

if @cnt <= 1
UPDATE LeafNode Set AVInstalls = AVInstalls + 1
   WHERE 
	LeafNode.AVinstalls <= 1
	AND LeafNode.AutoID in  
                      (
                           Select ParentID 
                              from inserted, ProductProperties 
                              where inserted.ProductCode = ProductProperties.ProductCode
                              AND ( inserted.ProductFamily in ( 'TVD','TVD_NC' )
									or inserted.ProductFamily like 'TVD_NC%' ) 
                      )     

-- epo3.5 assure than any blank language entries get update to 0000
-- the epo server needs this for some reason
update software set language = '0000' where language = '' or language is null

-- epo3.5 patch2 213085 : Remove any ghost product entries when a new product nap is installed.
-- remove orphaned entry
delete software 
where
( InstallGuid is null )
and ( productfamily = '' or productfamily is null )
and ( PlatformsSupported = '' or PlatformsSupported is null )
and productcode in (
	select productcode from inserted
	where 
		( InstallGuid is not null )
		and ( productfamily > '' )
		and ( PlatformsSupported > '' )
	)

end
Go


-- Bug fix 212770
-- If the MAC passed in is empty, we should return that it is not found.
IF EXISTS (SELECT * FROM sysobjects WHERE ID = object_id(N'[dbo].[EPOSP_FindByMAC]'))
DROP PROCEDURE [dbo].[EPOSP_FindByMAC]

GO

CREATE PROCEDURE EPOSP_FindByMAC
( @szMac NVARCHAR (100))
AS
BEGIN

DECLARE @nResult INT

IF @szMac IS NULL
BEGIN
	SELECT nResult=0
	RETURN
END

IF @szMac = ''
BEGIN
	SELECT nResult=0
	RETURN
END

SELECT top 1 @nResult = c.parentid 
	FROM computerproperties as c
	WHERE (c.NetAddress=@szMac)
IF (@nResult IS NULL)
BEGIN
	SET @nResult = 0
END

SELECT @nResult AS nResult
END

GO


-- end


