/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.condition;

import com.nai.mcafee.common.condition.EvalContext;
import com.nai.mcafee.common.condition.EvaluationException;
import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpBool;
import com.nai.mcafee.common.condition.SexpList;

public class SexpAnd
extends SexpList {
    public static final String TYPE = "and";

    public String type() {
        return TYPE;
    }

    public Sexp eval(EvalContext evalContext) throws EvaluationException {
        if (this.m_children.size() < 2) {
            throw new EvaluationException("'and' needs at least two parameters!");
        }
        int n = 0;
        while (n < this.m_children.size()) {
            Sexp sexp = this.evalChild(n, evalContext);
            if (!(sexp instanceof SexpBool)) {
                throw new EvaluationException("'and' got non-boolean parameter:" + sexp);
            }
            if (sexp == SexpBool.FALSE) {
                return SexpBool.FALSE;
            }
            ++n;
        }
        return SexpBool.TRUE;
    }
}

