/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db.io;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.SchemaVersionException;
import com.nai.mcafee.snowcap.db.io.DockMonkey;
import com.nai.mcafee.snowcap.db.io.Docks;
import com.nai.mcafee.snowcap.db.io.Shipping;
import com.nai.mcafee.snowcap.db.io.XMLDock;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;

public class ExceptionsShip
implements Shipping {
    private HashMap m_defHostsVals = new HashMap();
    private String m_nidCheck = "select NetworkID from Networks where NetworkName like '" + Resource.getJspString("jsputil_unknown_network") + "'";
    private DockMonkey m_dbDocker;
    public static final String EXPORT_TYPE_NAME = "Exceptions";
    private static final String EXPORT_SQL_STRING = "select MAC, FirstDetectTime, Exception, Comments from hosts where Exception=1 and Deleted=0";

    public String getExportType() {
        return EXPORT_TYPE_NAME;
    }

    public void Export(OutputStream outputStream, Docks docks) throws IOException, SQLException {
        this.m_dbDocker = new DockMonkey(docks);
        this.m_dbDocker.unload(EXPORT_SQL_STRING, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Import(InputStream inputStream, Docks docks) throws IOException, SQLException, ParseException, SchemaVersionException {
        int n = -1;
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.m_nidCheck);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            } else {
                Network network = new Network();
                network.setNetworkName(Resource.getJspString("jsputil_unknown_network"));
                network.setNetworkAddress("0.0.0.0");
                network.setSubnetAddress("255.255.255.255");
                network.setCovered(false);
                network.add(connection, true);
                n = network.getId();
                connection.commit();
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        this.m_defHostsVals.put(new String("NetworkID"), Integer.toString(n));
        this.m_defHostsVals.put(new String("NetworkProtocolID"), Integer.toString(1));
        this.m_defHostsVals.put(new String("LastDetectTime"), "NULL");
        this.m_dbDocker = new DockMonkey(docks);
        this.m_dbDocker.load(inputStream, "Hosts", "MAC", this.m_defHostsVals);
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = Server.loadProperties();
            Server.initDatabase(properties);
            XMLDock xMLDock = new XMLDock(EXPORT_TYPE_NAME);
            ExceptionsShip exceptionsShip = new ExceptionsShip();
            FileOutputStream fileOutputStream = new FileOutputStream(new File("testexport.xml"));
            exceptionsShip.Export(System.out, xMLDock);
            exceptionsShip.Export(fileOutputStream, xMLDock);
            fileOutputStream.close();
            FileInputStream fileInputStream = new FileInputStream(new File("testimport.xml"));
            exceptionsShip.Import(fileInputStream, xMLDock);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

