/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.epo.EpoHost;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.EpoHostList;
import com.nai.mcafee.snowcap.ui.util.SessionState;
import com.nai.mcafee.snowcap.ui.util.SubnetInfo;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SelectSensorDeployBean
extends ActionBeanBase {
    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("numberSensorsPerSubnet");
        if (!SessionUtil.isIntegerGT((String)string, (int)0)) {
            return this.showError(httpServletRequest, "selectsensordeploybean_sensorcount_too_small");
        }
        String string2 = httpServletRequest.getParameter("deploymentAutoManual");
        if (string2.compareTo("auto") != 0 && string2.compareTo("manual") != 0) {
            return this.showError(httpServletRequest, "selectsensordeploybean_invalid_deploy_method");
        }
        if (string2.compareTo("auto") == 0) {
            String string3;
            String string4 = httpServletRequest.getParameter("deploymentCriteria");
            if (!SessionUtil.isNonEmptyString((String)string4)) {
                return this.showError(httpServletRequest, "selectsensordeploybean_invalid_deploy_criteria");
            }
            boolean bl = false;
            int n = 0;
            while (n < string4.length()) {
                int n2 = Integer.parseInt(String.valueOf(string4.charAt(n)));
                if (n2 < 0 || n2 > 4) {
                    return this.showError(httpServletRequest, "selectsensordeploybean_invalid_deploy_criteria");
                }
                if (n2 == 2) {
                    bl = true;
                }
                ++n;
            }
            String string5 = httpServletRequest.getParameter("hostnameOperation");
            if (!SessionUtil.isIntegerLE((String)string5, (int)5) || !SessionUtil.isIntegerGT((String)string5, (int)-1)) {
                return this.showError(httpServletRequest, "selectsensordeploybean_invalid_hostname_operation");
            }
            if (bl && !SessionUtil.isNonEmptyString((String)(string3 = httpServletRequest.getParameter("hostnameValue")))) {
                return this.showError(httpServletRequest, "selectsensordeploybean_hostname_value_missing");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("deploymentAutoManual");
        int n = Integer.parseInt(httpServletRequest.getParameter("numberSensorsPerSubnet"));
        String string2 = httpServletRequest.getParameter("deploymentCriteria");
        String string3 = httpServletRequest.getParameter("hostnameOperation");
        String string4 = httpServletRequest.getParameter("hostnameValue");
        Configuration configuration = Server.getConfiguration();
        configuration.setSensorDeployAuto(string);
        configuration.setNumSensorsPerSubnet(n);
        configuration.setSensorDeployPref(string2.toString());
        configuration.setSensorDeployHostOp(string3);
        configuration.setSensorDeployHostValue(string4);
        EpoHostList epoHostList = SessionState.getEpoHostList(httpServletRequest);
        epoHostList.clearHosts();
        if (string.compareTo("auto") == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            Connection connection = null;
            Connection connection2 = null;
            try {
                connection2 = Server.getDb().getConnection();
                configuration.update(connection2);
                connection2.commit();
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                DatabaseUtil.close((Connection)connection2);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection2);
            Server.reloadConfiguration();
            try {
                connection = Server.getEpoDb().getConnection();
                int n2 = epoHostList.size();
                int n3 = n;
                int n4 = 0;
                while (n4 < n2) {
                    StringBuffer stringBuffer3 = new StringBuffer(string2);
                    String string5 = epoHostList.getAt((int)n4).m_networkAddress;
                    String string6 = epoHostList.getAt((int)n4).m_subnetMask;
                    SubnetInfo subnetInfo = null;
                    boolean bl = true;
                    while (bl) {
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer2.delete(0, stringBuffer2.length());
                        this.buildQuery(stringBuffer, stringBuffer2, stringBuffer3, Integer.parseInt(string3), string4);
                        subnetInfo = EpoHost.getHostIdsBySubnetWithPref(connection, string5, string6, n, stringBuffer.toString(), stringBuffer2.toString());
                        if (subnetInfo.size() >= n3 || !this.removeNextWhereCondition(stringBuffer3)) {
                            bl = false;
                            continue;
                        }
                        subnetInfo.clear();
                    }
                    SubnetInfo subnetInfo2 = epoHostList.addSubnet(subnetInfo.m_networkAddress, subnetInfo.m_subnetMask);
                    int n5 = 0;
                    while (n5 < subnetInfo.size()) {
                        subnetInfo2.addHost(subnetInfo.getLeafNodeIdAt(n5), subnetInfo.getHostnameAt(n5));
                        ++n5;
                    }
                    ++n4;
                }
                Object var25_27 = null;
            }
            catch (Throwable throwable) {
                Object var25_28 = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            return "displaysensordeploy.do";
        }
        return "displaysensordeploydetails.do";
    }

    private String showError(HttpServletRequest httpServletRequest, String string) {
        String string2 = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string2), (String)Resource.getString(string, string2), (String)"displaysensordeploypref.do");
        return "actiontaken.jsp";
    }

    private void buildQuery(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, int n, String string) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringBuffer3.length()) {
            switch (Integer.parseInt(String.valueOf(stringBuffer3.charAt(n2)))) {
                case 1: {
                    if (bl) {
                        stringBuffer2.append(",");
                    } else {
                        stringBuffer2.append(" order by ");
                        bl = true;
                    }
                    stringBuffer2.append(" cp.TotalPhysicalMemory desc ");
                    break;
                }
                case 4: {
                    if (bl) {
                        stringBuffer2.append(",");
                    } else {
                        stringBuffer2.append(" order by ");
                        bl = true;
                    }
                    stringBuffer2.append(" cp.CPUSpeed desc ");
                    break;
                }
                case 3: {
                    if (bl) {
                        stringBuffer2.append(",");
                    } else {
                        stringBuffer2.append(" order by ");
                        bl = true;
                    }
                    stringBuffer2.append(" ln.LastUpdate desc");
                    break;
                }
                case 0: {
                    stringBuffer.append(" and ( ln.AgentPlatform like 'WNTS%' OR ln.AgentPlatform like 'WXPS%' ) ");
                    break;
                }
                case 2: {
                    switch (n) {
                        case 2: {
                            stringBuffer.append(" and cp.ComputerName like '").append(string).append("' ");
                            break;
                        }
                        case 3: {
                            stringBuffer.append(" and cp.ComputerName NOT like '").append(string).append("' ");
                            break;
                        }
                        case 0: {
                            stringBuffer.append(" and cp.ComputerName like '%").append(string).append("%' ");
                            break;
                        }
                        case 1: {
                            stringBuffer.append(" and cp.ComputerName NOT like '%").append(string).append("%' ");
                            break;
                        }
                        case 4: {
                            stringBuffer.append(" and cp.ComputerName like '").append(string).append("%' ");
                            break;
                        }
                        case 5: {
                            stringBuffer.append(" and cp.ComputerName like '").append(string).append("' ");
                        }
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    private boolean removeNextWhereCondition(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = stringBuffer.toString();
        int n = 0;
        while (n < string.length()) {
            switch (Integer.parseInt(String.valueOf(string.charAt(n)))) {
                case 0: 
                case 2: {
                    bl = true;
                    stringBuffer.delete(n, n + 1);
                    n = string.length();
                    break;
                }
            }
            ++n;
        }
        return bl;
    }
}

