-- EnumProcedures.sql: All non reporting epo stored procedures and triggers should go here

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

-- Update epo server version
-- This needs to be done here so that even for incremental sp installs the version change will be recorded
UPDATE ServerInfo SET ePOVersion='3.5.0'
GO

------
-- IMPORTANT NOTE: All stored procedures need to be explicitly created with dbo ownership
-- This prevents an install using a user account from creating duplicate objects

-- new event indexes
IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_Source')
CREATE  INDEX [IX_Events_Source] ON [dbo].[Events]([Source]) ON [PRIMARY]
GO

IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_2')
drop INDEX [dbo].[Events].[IX_Events_2] 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_VirusAction')
CREATE  INDEX [IX_Events_VirusAction] ON [dbo].[Events]([Virusname],[ActionTaken]) ON [PRIMARY]
GO

--IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_Hostname')
--CREATE  INDEX [IX_Events_Hostname] ON [dbo].[Events]([hostname]) ON [PRIMARY]
--GO

--IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_Events_Username')
--CREATE  INDEX [IX_Events_Username] ON [dbo].[Events]([username]) ON [PRIMARY]
--GO

-- ProductProperties index
IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ProductProperties')
drop INDEX [dbo].[ProductProperties].[IX_ProductProperties] 
GO

IF EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ProductProperties_1')
drop INDEX [dbo].[ProductProperties].[IX_ProductProperties_1] 
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_ProductProperties')
	CREATE  Clustered INDEX [IX_ProductProperties] ON [dbo].[ProductProperties]([ParentID],[ProductCode]) ON [PRIMARY]
GO


-- some EventDayResolution indexes

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventDayResolution_NodeID')
CREATE clustered INDEX [IX_EventDayResolution_NodeID] ON [dbo].[EventDayResolution]([NodeID]) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventDayResolution_User')
CREATE  INDEX [IX_EventDayResolution_User] ON [dbo].[EventDayResolution]([username],[virusname],[productname],[productversion]) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventDayResolution_Host')
CREATE  INDEX [IX_EventDayResolution_Host] ON [dbo].[EventDayResolution]([hostname],[virusname]) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sysindexes WHERE name = 'IX_EventDayResolution_DateDetectAction')
CREATE  INDEX [IX_EventDayResolution_DateDetectAction] ON [dbo].[EventDayResolution]([ActionTaken],[virusname],[YearWeek],[YearMonth]) ON [PRIMARY]
GO


-------------------------------------
-- Index section - spread index changes over a few scripts so that none time out

-- Event Table indexes


-----------------------------------------------------------------------------
-- epo3.5 New version based on smb 
-- Calculate FullPathName and FullPathNode and stores in ReportFullPathNodeID
-- This routine is called enum routines to dynamically maintain this table
-- No more calling at run time with reports
-- Can fetch Branchnode name and full path from 1 table instead of joining two

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_CalculateAllNodeIDPaths]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_CalculateAllNodeIDPaths]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_CalculateAllNodeIDPaths
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100),
    @GenerateOutputTable varchar(50) = ''  -- NoResultSet means just generate the table
)
AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
      	Declare @iFilterNode int
	Declare @szFilterName nvarchar(255)
 	Declare @cnt int
      	Declare @szFilterNode varchar(255)
      	Declare @iFilterNode1 int




 /* mhiland 1/13/2k2  - add default case of NameSpaceName = 0 */
 if @iNameSpaceName = 0
 BEGIN
            select @szFilterName = NodeName,  @iFilterNode = AutoID
		from BranchNode where NodeName in ( 'directory', 'MergedDB' )	-- mhilandepo3: add MergedDB for dbmerge
			and type in (7,4)	-- epo3.5 patch3 216120 - make sure its a root node
	    SET @iNameSpaceName = @iFilterNode
 END
 ELSE
 BEGIN
	select @szFilterName = NodeName from BranchNode where AutoID = @iNameSpaceName
  	SET @iFilterNode = @iNameSpaceName
 END


     -- mhiland 2/26/2k4 smb
     -- fix for sql7 sp4: no longer allows create statement within trigger
     -- Code from AVIDALSP_GetUserNodeAccessList, remove call to it to avoid possible contention issues
     IF @iNameSpaceNode > 0
           select @iFilterNode1 = @iNameSpaceNode
      ELSE
           select @iFilterNode1 = @iNameSpaceName
    
     select @szFilterNode = NodeName from BranchNode where AutoID = @iFilterNode1

     Delete from ReportTempUserNodeAccessList 

	INSERT ReportTempUserNodeAccessList 
	  SELECT EndAutoID as AutoID,  NodeName 
	                   FROM BranchNodeEnum, BranchNode 
	    WHERE 
	     StartAutoID =  @iFilterNode1
	     AND EndAutoID = BranchNode.AutoID
	  UNION 
	    SELECT @iFilterNode1, @szFilterNode   /* and the node it's self */


 /* step 0 */
      /* create UserNodeAccessList table with node names */
/*
 CREATE TABLE #UserNodeList(NodeID int, NodeName varchar(255))
      INSERT #UserNodeList
  SELECT BranchNode.AutoID, NodeName
  FROM ##UserNodeAccessList, BranchNode 
  WHERE ##UserNodeAccessList.AutoID = BranchNode.AutoID
*/

 /* step 1 */
      /* create subset of enum table the user has access to with branch node names in it */
-- sql serve 7 no longer allow create table within a triiger: change routine to use a permanemt table
-- CREATE TABLE #UserEnum(ParentID int, ChildID int, PathLength int)
 delete from ReportTempUserEnum

 INSERT ReportTempUserEnum 
    SELECT StartAutoID, EndAutoID, PathLength     /*, NULL, NULL*/
           FROM BranchNodeEnum
            WHERE StartAutoID in (SELECT AutoID FROM ReportTempUserNodeAccessList)
--            WHERE StartAutoID in (SELECT AutoID FROM ##UserNodeAccessList)


 /* step 2 */
 /* create full name path work table: will first expand out the nodeids until we have the full path */

-- sql serve 7 no longer allow create table within a triiger: change routine to use a permanemt table
-- CREATE TABLE #FullPath(CID int, PID int,
--     GPID int, GPID1 int,  
--     PathLength int,
--     FullPathName varchar(500),
--     FullPathNodeID varchar(500),
--     LowestNodeID int )
 delete from ReportTempFullPath

 /* create the initial parent child hierarchy */
      /* Load all enum entries with pathlength=1 so they can be traversed backwards */
 /* Each of these entries represents a node that must be traversed back to fill the pathname */
 /* Also add the LowestNodeID at this step - this is the FilterNodeID sent to the reports */
 INSERT ReportTempFullPath 
    SELECT ChildID, ParentID, 0,0,0,NULL, NULL,ChildID
           FROM ReportTempUserEnum
            WHERE PathLength = 1
  
 /* top node */
       INSERT ReportTempFullPath
  VALUES ( @iFilterNode, 0, 0,0,0,NULL, NULL,@iFilterNode )
 

 /* add pathlength from filternode to childnode */
 UPDATE ReportTempFullPath
  SET PathLength = 
   (SELECT PathLength
    FROM ReportTempUserEnum
    WHERE 
     ParentID = @iFilterNode
     and ChildID = CID)

     
 /* add new path levels until complete */
 /* add lowest child level */
-- UPDATE ReportTempFullPath  SET FullPathName = (SELECT NodeName from ##UserNodeAccessList where AutoID = CID) 
-- UPDATE ReportTempFullPath  SET FullPathNodeID = (SELECT autoid from ##UserNodeAccessList where AutoID = CID) 
 UPDATE ReportTempFullPath  SET FullPathName = (SELECT NodeName from ReportTempUserNodeAccessList where AutoID = CID) 
 UPDATE ReportTempFullPath  SET FullPathNodeID = (SELECT autoid from ReportTempUserNodeAccessList where AutoID = CID) 

 /* add parent, bumping child to the right on the pathlist */
 UPDATE ReportTempFullPath  
  SET 
	FullPathName = rtrim((SELECT NodeName from ReportTempUserNodeAccessList where AutoID = PID))
    		+ '\' +FullPathName
	, FullPathNodeID = convert(varchar(20),(SELECT autoid from ReportTempUserNodeAccessList where AutoID = PID))
    		+ '\' +FullPathNodeID
  WHERE PID != 0
 UPDATE ReportTempFullPath  SET GPID = PID, GPID1 = NULL

 SET @cnt = 2

 /* loop through looking for lower nodes */
 WHILE EXISTS (SELECT PathLength from ReportTempFullPath WHERE PathLength = @cnt)
 BEGIN
  /* look for another round of parents */
  UPDATE ReportTempFullPath SET GPID1 = (SELECT ParentID FROM ReportTempUserEnum 
       WHERE ChildID = GPID and PathLength = 1) 
  /* if another level exists add it to the path, bumping the existing path to the right */
  UPDATE ReportTempFullPath  
   SET 
	FullPathName = rtrim((SELECT NodeName from ReportTempUserNodeAccessList where AutoID = GPID1))
    		+ '\' +FullPathName
	, FullPathNodeID = convert(varchar(20),(SELECT autoid from ReportTempUserNodeAccessList where AutoID = GPID1))
    		+ '\' +FullPathNodeID
   WHERE GPID1 is not NULL 
  UPDATE ReportTempFullPath  SET GPID = GPID1, GPID1 = NULL
  SET @cnt = @cnt + 1
 END


-- add global root node
 Declare @GlobalRoot int
 select @GlobalRoot=autoid from BranchNode where type =7
 Declare @RootNode int
 select @RootNode=autoid from BranchNode where type =4

 Declare @RootPrefix varchar(20)
 set @RootPrefix= convert(varchar(20), @GlobalRoot) + '\' + convert(varchar(20), @RootNode) + '\'
 Declare @RootPrefixLen int
 Set @RootPrefixLen = len(@RootPrefix)

 UPDATE ReportTempFullPath  
  SET 
	FullPathNodeID = convert(varchar(20),@GlobalRoot)
    		+ '\' +FullPathNodeID




 /* mhilandepo3 1/13/2k2 - Generate fullpatnnode table for use in reports */

	-- populate older epo3.0 table which is still used by directory search location lookup
	delete from ReportFullPathNode
        INSERT ReportFullPathNode
 	SELECT 
		PathLength
		, FullPathName
		, LowestNodeID  
	FROM ReportTempFullPath
	 where FullPathName is not NULL
  	ORDER by FullPathName 	


	-- populate new epo3.5 table which contains additional info to help speed reports
	delete from ReportFullPathNodeID
        INSERT ReportFullPathNodeID
	(PathLength, FullPathName, FullPathNodeID, LowestNodeID)
 	SELECT 
		PathLength
		, rtrim(FullPathName)
		, FullPathNodeID
		, LowestNodeID 
	FROM ReportTempFullPath
	 where FullPathName is not NULL
  	ORDER by FullPathName 	

	-- add additional fields

	-- Lowest Node Info
	update ReportFullPathNodeID
		set ParentID = BranchNode.ParentID, NodeName = BranchNode.NodeName,
			Type = BranchNode.Type
		from BranchNode 
		where BranchNode.autoid = ReportFullPathNodeID.LowestNodeID

	-- site info
	update ReportFullPathNodeID
		set site = BranchNode.AutoID, SiteName = BranchNode.NodeName
		from BranchNode, BranchNodeEnum
		where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.EndAutoID
			and BranchNodeEnum.StartAutoID = BranchNode.AutoID
			and BranchNode.Type = 6

--select * from ReportFullPathNodeID

	update ReportFullPathNodeID
		set FullPathShortName = Replace(FullPathName,'Directory\','')

--select * from ReportFullPathNodeID

	update ReportFullPathNodeID
		set site = LowestNodeID, SiteName = NodeName where Type = 6
	
	-- Generate directory stats if asked for
 	if @GenerateOutputTable = 'GenerateStats'
	Begin

		-- note: ok to use temp tables here because join is done on ints not chars
		-- no possible code page problems

		-- count subdirectories
		select LowestNodeID, count(*) as cnt   INTO #tempsubdir 
			from BranchNodeEnum, ReportFullPathNodeID
			where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.StartAutoID
			group by LowestNodeID

		update ReportFullPathNodeID
		set subdirectories = cnt
			from #tempsubdir
			where 
			ReportFullPathNodeID.LowestNodeID = #tempsubdir.LowestNodeID

		-- count computers at subnodes
		select LowestNodeID, count(*) as cnt   INTO #tempcomputers 
		from BranchNodeEnum, LeafNode, ReportFullPathNodeID
		where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.StartAutoID
			and LeafNode.ParentID = BranchNodeEnum.EndAutoID
			and LeafNode.Type != 24
		group by LowestNodeID

		-- count computers at mainnode
		select LowestNodeID, count(*) as cnt   INTO #tempcomputers1 
		from  LeafNode, ReportFullPathNodeID
		where 
			ReportFullPathNodeID.LowestNodeID = LeafNode.ParentID
			and LeafNode.Type != 24
		group by LowestNodeID

		update ReportFullPathNodeID
		set computers = computers + #tempcomputers.cnt 
			from #tempcomputers
			where ReportFullPathNodeID.LowestNodeID = #tempcomputers.LowestNodeID

		update ReportFullPathNodeID
		set computers = computers + #tempcomputers1.cnt 
			from #tempcomputers1
			where ReportFullPathNodeID.LowestNodeID = #tempcomputers1.LowestNodeID
	End




 /* Display values if asked for: default behavior */
 if @GenerateOutputTable = '' or @GenerateOutputTable is null
 BEGIN
 	/* present the results */
 	SELECT FullPathName, FullPathNodeID, LowestNodeID, NodeName, SiteName
	FROM ReportFullPathNodeID
	 where FullPathName is not NULL
  	ORDER by FullPathName 
 END


  /* cleauup */
--	DROP TABLE #UserEnum
--	DROP TABLE #FullPath
	delete from  ReportTempUserEnum
	delete from ReportTempFullPath
	delete from ReportTempUserNodeAccessList
END
go



-----------------------------------------------------------------------------
-- Calculate FullPathName and FullPathNode and stores in ReportFullPathNodeID for 1 node only
-- epo3.5 patch3 bugfix 216435 - performance improvement for users with > 1000 group (dont recalculate whole tree each time)

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_CalculateANodeIDPath]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_CalculateANodeIDPath]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_CalculateANodeIDPath
(
    @iNameSpaceName  int,
    @GenerateOutputTable varchar(50) = ''  -- NoResultSet means just generate the table
)
AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
      	Declare @iFilterNode int
	Declare @szFilterName nvarchar(255)
 	Declare @cnt int
      	Declare @szFilterNode varchar(255)
      	Declare @iFilterNode1 int




 /* mhiland 1/13/2k2  - add default case of NameSpaceName = 0 */
            select @szFilterName = NodeName,  @iFilterNode = AutoID
		from BranchNode where NodeName in ( 'directory', 'MergedDB' )	-- mhilandepo3: add MergedDB for dbmerge
			and type in (7,4)	-- epo3.5 patch3 216120 - make sure its a root node




     -- mhiland 2/26/2k4 smb
     -- fix for sql7 sp4: no longer allows create statement within trigger

	
     select @szFilterNode = NodeName from BranchNode where AutoID = @iFilterNode

     Delete from ReportTempUserNodeAccessList 

	-- load up all entries where start=root
	INSERT ReportTempUserNodeAccessList 
	  SELECT EndAutoID as AutoID,  NodeName 
	                   FROM BranchNodeEnum, BranchNode 
	    WHERE 
	     StartAutoID =  @iFilterNode
	     AND EndAutoID = BranchNode.AutoID
	  UNION 
	    SELECT @iFilterNode1, @szFilterNode   /* and the node it's self */

	UPDATE ReportTempUserNodeAccessList
		set AutoID = (select autoid from branchnode where type = 4)
		where (autoid is null or autoid = '') and Nodename = 'Directory'

--select @iFilterNode
--select * from ReportTempUserNodeAccessList


 delete from ReportTempUserEnum

 -- step 1
 -- load up all entries where end = @iNameSpaceName (group input)
 INSERT ReportTempUserEnum 
    SELECT StartAutoID, EndAutoID, PathLength     /*, NULL, NULL*/
           FROM BranchNodeEnum
            WHERE EndAutoID = @iNameSpaceName
--            WHERE StartAutoID in (SELECT AutoID FROM ReportTempUserNodeAccessList)


--select * from ReportTempUserEnum
 /* step 2 */
 /* create full name path work table: will first expand out the nodeids until we have the full path */


 delete from ReportTempFullPath

 /* create the initial parent child hierarchy */
      /* Load all enum entries with pathlength=1 so they can be traversed backwards */
 /* Each of these entries represents a node that must be traversed back to fill the pathname */
 /* Also add the LowestNodeID at this step - this is the FilterNodeID sent to the reports */
 INSERT ReportTempFullPath 
    SELECT ChildID, ParentID, 0,0,2,NULL, NULL,ChildID
           FROM ReportTempUserEnum
            WHERE PathLength = 1
  
 /* top node */
--       INSERT ReportTempFullPath
--  VALUES ( @iFilterNode, 0, 0,0,0,NULL, NULL,@iFilterNode )
 

 /* add pathlength from filternode to childnode */
 UPDATE ReportTempFullPath
  SET PathLength = 
   (SELECT PathLength
    FROM ReportTempUserEnum
    WHERE 
     ParentID = @iFilterNode
     and ChildID = CID)

     
 /* add new path levels until complete */
 /* add lowest child level */
-- UPDATE ReportTempFullPath  SET FullPathName = (SELECT NodeName from ##UserNodeAccessList where AutoID = CID) 
-- UPDATE ReportTempFullPath  SET FullPathNodeID = (SELECT autoid from ##UserNodeAccessList where AutoID = CID) 
 UPDATE ReportTempFullPath  SET FullPathName = (SELECT NodeName from ReportTempUserNodeAccessList where AutoID = CID) 
 UPDATE ReportTempFullPath  SET FullPathNodeID = (SELECT autoid from ReportTempUserNodeAccessList where AutoID = CID) 

 /* add parent, bumping child to the right on the pathlist */
 UPDATE ReportTempFullPath  
  SET 
	FullPathName = rtrim((SELECT NodeName from ReportTempUserNodeAccessList where AutoID = PID))
    		+ '\' +FullPathName
	, FullPathNodeID = convert(varchar(20),(SELECT autoid from ReportTempUserNodeAccessList where AutoID = PID))
    		+ '\' +FullPathNodeID
  WHERE PID != 0
 UPDATE ReportTempFullPath  SET GPID = PID, GPID1 = NULL

--test
--select * from ReportTempFullPath

 SET @cnt = 2

 /* loop through looking for lower nodes */
 WHILE EXISTS (SELECT PathLength from ReportTempUserEnum WHERE PathLength = @cnt) 
 BEGIN
  /* look for another round of parents */
  UPDATE ReportTempFullPath SET GPID1 = (SELECT ParentID FROM ReportTempUserEnum 
       WHERE ChildID = @iNameSpaceName and PathLength = @cnt) 

-- test
--select 'InLoop',* from ReportTempFullPath

--  UPDATE ReportTempFullPath SET GPID1 = (SELECT ParentID FROM ReportTempUserEnum 
--       WHERE ChildID = GPID and PathLength = 1) 
--  UPDATE ReportTempFullPath SET GPID1 = (SELECT StartAutoID FROM BranchNodeEnum 
--       WHERE EndAutoID = GPID and PathLength = 1) 
  /* if another level exists add it to the path, bumping the existing path to the right */

 if exists (SELECT NodeName from ReportTempUserNodeAccessList,ReportTempFullPath 
		where AutoID = ReportTempFullPath.GPID1) 
  UPDATE ReportTempFullPath  
   SET 
	FullPathName = rtrim((SELECT NodeName from ReportTempUserNodeAccessList where AutoID = GPID1))
    		+ '\' +FullPathName
	, FullPathNodeID = convert(varchar(20),(SELECT autoid from ReportTempUserNodeAccessList where AutoID = GPID1))
    		+ '\' +FullPathNodeID
   WHERE GPID1 is not NULL 
  UPDATE ReportTempFullPath  SET GPID = GPID1, GPID1 = NULL
  SET @cnt = @cnt + 1

--test
--select @cnt, * from ReportTempFullPath

 END

--test
--select * from ReportTempFullPath

-- add global root node
 Declare @GlobalRoot int
 select @GlobalRoot=autoid from BranchNode where type =7
 Declare @RootNode int
 select @RootNode=autoid from BranchNode where type =4

 Declare @RootPrefix varchar(20)
 set @RootPrefix= convert(varchar(20), @GlobalRoot) + '\' + convert(varchar(20), @RootNode) + '\'
 Declare @RootPrefixLen int
 Set @RootPrefixLen = len(@RootPrefix)

 UPDATE ReportTempFullPath  
  SET 
	FullPathNodeID = convert(varchar(20),@GlobalRoot)
    		+ '\' +FullPathNodeID


--test
--select * from ReportTempFullPath

 /* mhilandepo3 1/13/2k2 - Generate fullpatnnode table for use in reports */

	-- populate older epo3.0 table which is still used by directory search location lookup
	delete from ReportFullPathNode
		where @iNameSpaceName=LowestNodeID
        INSERT ReportFullPathNode
 	SELECT 
		PathLength
		, FullPathName
		, LowestNodeID  
	FROM ReportTempFullPath
	 where FullPathName is not NULL
 	ORDER by FullPathName 	


	-- populate new epo3.5 table which contains additional info to help speed reports
	delete from ReportFullPathNodeID 
		where @iNameSpaceName=LowestNodeID

        INSERT ReportFullPathNodeID
	(PathLength, FullPathName, FullPathNodeID, LowestNodeID)
 	SELECT 
		PathLength
		, rtrim(FullPathName)
		, FullPathNodeID
		, LowestNodeID 
	FROM ReportTempFullPath
	 where FullPathName is not NULL
  	ORDER by FullPathName 	

	-- add additional fields

	-- Lowest Node Info
	update ReportFullPathNodeID
		set ParentID = BranchNode.ParentID, NodeName = BranchNode.NodeName,
			Type = BranchNode.Type
		from BranchNode 
		where BranchNode.autoid = ReportFullPathNodeID.LowestNodeID
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

	-- site info
	update ReportFullPathNodeID
		set site = BranchNode.AutoID, SiteName = BranchNode.NodeName
		from BranchNode, BranchNodeEnum
		where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.EndAutoID
			and BranchNodeEnum.StartAutoID = BranchNode.AutoID
			and BranchNode.Type = 6
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

--select * from ReportFullPathNodeID

	update ReportFullPathNodeID
		set FullPathShortName = Replace(FullPathName,'Directory\','')
		where ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

--select * from ReportFullPathNodeID

	-- update site field for groups that are sites
	update ReportFullPathNodeID
		set site = LowestNodeID, SiteName = NodeName where Type = 6
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

	
	-- Generate directory stats if asked for
 	if @GenerateOutputTable = 'GenerateStats'
	Begin

		-- note: ok to use temp tables here because join is done on ints not chars
		-- no possible code page problems

		-- count subdirectories
		select LowestNodeID, count(*) as cnt   INTO #tempsubdir 
			from BranchNodeEnum, ReportFullPathNodeID
			where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.StartAutoID
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName
			group by LowestNodeID

		update ReportFullPathNodeID
		set subdirectories = cnt
			from #tempsubdir
			where 
			ReportFullPathNodeID.LowestNodeID = #tempsubdir.LowestNodeID
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

		-- count computers at subnodes
		select LowestNodeID, count(*) as cnt   INTO #tempcomputers 
		from BranchNodeEnum, LeafNode, ReportFullPathNodeID
		where 
			ReportFullPathNodeID.LowestNodeID = BranchNodeEnum.StartAutoID
			and LeafNode.ParentID = BranchNodeEnum.EndAutoID
			and LeafNode.Type != 24
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName
		group by LowestNodeID

		-- count computers at mainnode
		select LowestNodeID, count(*) as cnt   INTO #tempcomputers1 
		from  LeafNode, ReportFullPathNodeID
		where 
			ReportFullPathNodeID.LowestNodeID = LeafNode.ParentID
			and LeafNode.Type != 24
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName
		group by LowestNodeID

		update ReportFullPathNodeID
		set computers = computers + #tempcomputers.cnt 
			from #tempcomputers
			where ReportFullPathNodeID.LowestNodeID = #tempcomputers.LowestNodeID
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName

		update ReportFullPathNodeID
		set computers = computers + #tempcomputers1.cnt 
			from #tempcomputers1
			where ReportFullPathNodeID.LowestNodeID = #tempcomputers1.LowestNodeID
			and ReportFullPathNodeID.LowestNodeID = @iNameSpaceName
	End




 /* Display values if asked for: default behavior */
 if @GenerateOutputTable = '' or @GenerateOutputTable is null
 BEGIN
 	/* present the results */
-- 	SELECT FullPathName, FullPathNodeID, LowestNodeID, NodeName, SiteName
 	SELECT *
	FROM ReportFullPathNodeID
	 where FullPathName is not NULL
		and @iNameSpaceName=LowestNodeID
  	ORDER by FullPathName 
 END


  /* cleauup */
--	DROP TABLE #UserEnum
--	DROP TABLE #FullPath
	delete from  ReportTempUserEnum
	delete from ReportTempFullPath
	delete from ReportTempUserNodeAccessList
END
go


-----------------------------------------------------------------------------
-- Calculate FullPathName and FullPathNode and stores in ReportFullPathNodeID for 1 node only
-- epo3.5 patch3 bugfix 216435 - performance improvement for users with > 1000 group (dont recalculate whole tree each time)

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_CalculateANodeIDPathRemove]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_CalculateANodeIDPathRemove]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_CalculateANodeIDPathRemove
(
    @iNameSpaceName  int,
    @GenerateOutputTable varchar(50) = ''  -- NoResultSet means just generate the table
)
AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/
      	Declare @iFilterNode int
	Declare @szFilterName nvarchar(255)
 	Declare @cnt int
      	Declare @szFilterNode varchar(255)
      	Declare @iFilterNode1 int




 /* mhiland 1/13/2k2  - add default case of NameSpaceName = 0 */
            select @szFilterName = NodeName,  @iFilterNode = AutoID
		from BranchNode where NodeName in ( 'directory', 'MergedDB' )	-- mhilandepo3: add MergedDB for dbmerge
			and type in (7,4)	-- epo3.5 patch3 216120 - make sure its a root node




     -- mhiland 2/26/2k4 smb
     -- fix for sql7 sp4: no longer allows create statement within trigger

	
     select @szFilterNode = NodeName from BranchNode where AutoID = @iFilterNode

     Delete from ReportTempUserNodeAccessList 


 delete from ReportTempUserEnum

 -- step 1
 -- load up all entries where end = @iNameSpaceName (group input)
 INSERT ReportTempUserEnum 
    SELECT StartAutoID, EndAutoID, PathLength     /*, NULL, NULL*/
           FROM BranchNodeEnum
            WHERE StartAutoID = @iNameSpaceName
--            WHERE StartAutoID in (SELECT AutoID FROM ReportTempUserNodeAccessList)


--select * from ReportTempUserEnum

	-- populate older epo3.0 table which is still used by directory search location lookup
	delete from ReportFullPathNode
		where LowestNodeID in (select ChildID from ReportTempUserEnum) 

	delete from ReportFullPathNode
		where LowestNodeID = @iNameSpaceName


	-- populate new epo3.5 table which contains additional info to help speed reports
	delete from ReportFullPathNodeID
		where LowestNodeID in (select ChildID from ReportTempUserEnum) 

	delete from ReportFullPathNodeID 
		where LowestNodeID = @iNameSpaceName



 /* Display values if asked for: default behavior */
 if @GenerateOutputTable = '' or @GenerateOutputTable is null
 BEGIN
 	/* present the results */
-- 	SELECT FullPathName, FullPathNodeID, LowestNodeID, NodeName, SiteName
 	SELECT *
	FROM ReportFullPathNodeID
	 where FullPathName is not NULL
		and @iNameSpaceName=LowestNodeID
  	ORDER by FullPathName 
 END


  /* cleauup */
	delete from  ReportTempUserEnum
	delete from ReportTempFullPath
	delete from ReportTempUserNodeAccessList
END
go



-----------------------------------------------------------------------------
-- BranchNodeEnum routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_Generate_BranchNode_Enum]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_Generate_BranchNode_Enum]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_Generate_BranchNode_Enum
AS 
BEGIN
 /* Copyright   1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/

    DELETE FROM BranchNodeEnum SELECT * FROM BranchNodeEnum

/* Generate all the pair paths (with iPathLength =1) */
/* we only need to do this once.    */
/* First pass taken from branchnode table not BranchNodeEnum */

    INSERT INTO BranchNodeEnum
         (StartAutoID, EndAutoID, PathLength, dtEndCreated)
      SELECT Enum1.AutoID, Enum2.AutoID, 1, Enum2.TheTimestamp
      FROM BranchNode AS Enum1, 
         BranchNode AS Enum2
      WHERE Enum2.ParentID = Enum1.AutoID AND 
        NOT
        EXISTS
           (SELECT *
             FROM BranchNodeEnum
             WHERE StartAutoID = Enum1.AutoID
               AND 
               EndAutoID = Enum2.AutoID)
              
    /* Generate all N length paths  */
    /* we need to iterate until we have no more updates. */
    /* These iterations are taken from BranchNodeEnum table */

    BEGIN
 DECLARE @iEntryCount INT
 
 SET @iEntryCount = 0

 WHILE(@iEntryCount!= (SELECT COUNT(StartAutoID) FROM BranchNodeEnum))
      BEGIN
      
  SET @iEntryCount= (SELECT COUNT(StartAutoID) FROM BranchNodeEnum)

            INSERT INTO BranchNodeEnum
          (StartAutoID, EndAutoID, PathLength, dtEndCreated)
          SELECT DISTINCT 
              Enum1.StartAutoID, Enum2.EndAutoID, (Enum1.PathLength + 1), 
                   Enum2.dtEndCreated
             FROM BranchNodeEnum AS Enum1, BranchNodeEnum AS Enum2
             WHERE 
                     Enum1.EndAutoID = Enum2.StartAutoID AND Enum2.PathLength=1
                AND Enum1.PathLength = 
                     (SELECT MAX(PathLength)FROM BranchNodeEnum)
       
      END  
    END
    DELETE FROM BranchNodeEnum WHERE StartAutoID = 0

    ------------------ eposmb
    -- Regenerate NodePath and NodePathID: ReportFullPathNodeID table
    execute AVIDALSP_CalculateAllNodeIDPaths '', '', '', 'NoResultSet'

END
/*[END_SQL_STATEMENT(Create_AVIDALSP_Generate_BranchNode_Enum)]*/


GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_AddTo_BranchNode_Enum]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_AddTo_BranchNode_Enum]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_AddTo_BranchNode_Enum
 @NewNodeID  INT
AS 
BEGIN
 /* Copyright   1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/
      /* Add a new node to the enum table */

 DECLARE @NewNodeParentID INT
--      DECLARE @NewNodeCreated DATETIME
      DECLARE @NewNodeCreated binary(8)

      /* get parent of new node needing inserting into enum table */
      /* nodes isnt in enum table so get it from branchnode table */
 SELECT 
           @NewNodeParentID = ParentID,
           @NewNodeCreated = TheTimestamp
        FROM BranchNode 
        WHERE
           AutoID = @NewNodeID


      -- Insert links starting from the new node entire lineage

      INSERT INTO BranchNodeEnum
           (StartAutoID, EndAutoID, PathLength, dtEndCreated)
         SELECT 
               Enum.StartAutoID, @NewNodeID, Enum.PathLength+1, @NewNodeCreated
            FROM BranchNodeEnum AS Enum 
            WHERE 
               Enum.EndAutoID = @NewNodeParentID

       -- Insert link starting from the parent
              
       INSERT INTO BranchNodeEnum
            VALUES( @NewNodeParentID, @NewNodeID, 1, @NewNodeCreated)

    DELETE FROM BranchNodeEnum WHERE StartAutoID = 0

    ------------------ eposmb
    -- Regenerate NodePath and NodePathID: ReportFullPathNodeID table
    -- epo3.5 patch3: Call new routine which adds just the new group instead of recalculating whole thing
    execute AVIDALSP_CalculateANodeIDPath @NewNodeID, 'NoResultSet'
    --execute AVIDALSP_CalculateAllNodeIDPaths '', '', '', 'NoResultSet'

END


GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_DeleteFrom_BranchNode_Enum]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_DeleteFrom_BranchNode_Enum]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVIDALSP_DeleteFrom_BranchNode_Enum
 @DeletedNodeID  INT
AS 
BEGIN
 /* Copyright   1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/
      /* Delete a node from the enum table */

     /* Delete all links that start with or end with deleted nodes descendents */
     DELETE FROM BranchNodeEnum 
          WHERE 
             StartAutoID in 
                 (SELECT EndAutoID 
                      FROM BranchNodeEnum
                      WHERE  StartAutoID = @DeletedNodeID )
            OR
              EndAutoID in 
                 (SELECT EndAutoID 
                      FROM BranchNodeEnum
                      WHERE  StartAutoID = @DeletedNodeID )
    

     /* Delete all links that start or end with the deleted node */
     DELETE FROM BranchNodeEnum 
          WHERE 
             StartAutoID = @DeletedNodeID
            OR 
             EndAutoID = @DeletedNodeID 

    DELETE FROM BranchNodeEnum WHERE StartAutoID = 0

    ------------------ eposmb
    -- Regenerate NodePath and NodePathID: ReportFullPathNodeID table
    -- epo3.5 patch3: Call new routine which deletes just the old group instead of recalculating whole thing
    execute AVIDALSP_CalculateANodeIDPathRemove @DeletedNodeID, 'NoResultSet'
    --execute AVIDALSP_CalculateAllNodeIDPaths '', '', '', 'NoResultSet'
     
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_MoveWithin_BranchNode_Enum]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_MoveWithin_BranchNode_Enum]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_MoveWithin_BranchNode_Enum
 @MovedNodeID  INT
AS 
BEGIN
 /* Copyright   1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/
      /* Move a node and any decendent branch nodes with the enum table */


     -- Create temp table storing nodes below and above those being deleted 
--     DELETE #OldLineageNodes    -- Old Nodes above the moved top node (links starting from these will be deleted)
--     DELETE #NewLineageNodes    -- New Nodes above the moved top node (links starting from here will be added)
--     DELETE #DecendentNodes     -- Nodes below the moved top node including the top node
 
     
      /* Fill temp tables */

      -- Get new parent from BranchNode table (not yet in BranchNodeEnum table)       
      DECLARE @MovedNodeNewParentID INT
--      DECLARE @MovedNodeCreated DATETIME
      DECLARE @MovedNodeCreated binary(8)

      /* get the new parent of the moved node */
      /* nodes isnt in enum table so get it from branchnode table */
 SELECT 
          @MovedNodeNewParentID = ParentID,
          @MovedNodeCreated = TheTimestamp
        FROM BranchNode 
        WHERE
          AutoID = @MovedNodeID

      -- Got new parent, now Fill New Lineage Table  
--      INSERT INTO #NewLineageNodes

         SELECT StartAutoID, PathLength=(PathLength+1) 
          INTO #NewLineageNodes
            FROM BranchNodeEnum
            WHERE EndAutoID = @MovedNodeNewParentID

      -- Add new Parent
     INSERT #NewLineageNodes
           VALUES( @MovedNodeNewParentID, 1) 

      -- Fill Old Lineage Table  
 --     INSERT INTO #OldLineageNodes
         SELECT StartAutoID, PathLength 
         INTO #OldLineageNodes
            FROM BranchNodeEnum
            WHERE EndAutoID = @MovedNodeID

      -- Fill descendent table   
--      INSERT INTO #DecendentNodes
         SELECT EndAutoID, PathLength, dtEndCreated 
          INTO #DecendentNodes
            FROM BranchNodeEnum
            WHERE StartAutoID = @MovedNodeID
      -- Add moved top node
      INSERT #DecendentNodes
            VALUES( @MovedNodeID, 0, @MovedNodeCreated) 


     /* Delete all links that start from old lineage nodes and ending with descendent nodes */
     DELETE FROM BranchNodeEnum 
          WHERE 
             StartAutoID in 
                 (SELECT StartAutoID 
                      FROM #OldLineageNodes )
            AND
             EndAutoID in 
                 (SELECT EndAutoID 
                      FROM #DecendentNodes )
     

     /* Insert links based on a cross product starting from the new lineage nodes to the decendent nodes */
     /* all tops and links with all bottoms */
     INSERT INTO BranchNodeEnum
           (StartAutoID, EndAutoID, PathLength, dtEndCreated)
         SELECT 
               #NewLineageNodes.StartAutoID
               , #DecendentNodes.EndAutoID
               , (#NewLineageNodes.PathLength) + (#DecendentNodes.PathLength) 
               , #DecendentNodes.dtEndCreated
            FROM #NewLineageNodes,
                       #DecendentNodes
            WHERE 
               #NewLineageNodes.StartAutoID != #DecendentNodes.EndAutoID                     -- creates a cross product
      

    DELETE FROM BranchNodeEnum WHERE StartAutoID = 0

    ------------------ eposmb
    -- Regenerate NodePath and NodePathID: ReportFullPathNodeID table
    execute AVIDALSP_CalculateAllNodeIDPaths '', '', '', 'NoResultSet'


END
/*[END_SQL_STATEMENT(Create_AVIDALSP_MoveWithin_BranchNode_Enum)]*/
/*[END_SQL_STATEMENT(Create_AVIDALSP_MoveWithin_BranchNode_Enum)]*/
GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetTreeHierarchyFromTopNode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetTreeHierarchyFromTopNode]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetTreeHierarchyFromTopNode
 @TopNodeID  INT
AS 
BEGIN

   SELECT StartAutoID, EndAutoID
          FROM BranchNodeEnum
          WHERE 
                 StartAutoID = @TopNodeID 
               AND PathLength = 1
   UNION
      SELECT StartAutoID, EndAutoID
            FROM BranchNodeEnum
            WHERE StartAutoID IN
                   (SELECT EndAutoID
                          FROM BranchNodeEnum
                          WHERE 
                                   startAutoID = @TopNodeID) 
                  AND PathLength = 1
   ORDER BY StartAutoID

END
GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

-- old epo3.0 routine
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodePathepo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodePathepo]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetNodePathepo
 @NodeID  INT
AS 
BEGIN

SET NOCOUNT ON

 DECLARE @PathID varchar(500)
 DECLARE  @FullPathName varchar(1024) 
 DECLARE @PathLen int


IF EXISTS (Select * from BranchNode where AutoID = @Nodeid)
BEGIN
 /* Fetch decendents from enum table */   
 SELECT StartAutoID as NodeId, NodeName, PathLength
  INTO #base
             FROM BranchNodeEnum, BranchNode
                          WHERE 
                                   EndAutoID = @NodeID
   AND BranchNodeEnum.StartAutoID = BranchNode.AutoID
     ORDER BY PathLength desc

 /* Add input node */   
 INSERT #base
  SELECT AutoID as NodeId, NodeName, 0 as PathLength
   FROM BranchNode
   WHERE AutoID = @NodeID  

  
 SELECT @PathLen = MAX(PathLength) from #base

 /* Traverse path - add first entry */   
 SELECT @PathID = convert(varchar(10),NodeId),
   @FullPathName = NodeName
   FROM #base
   WHERE #base.PathLength = @PathLen
 SET @PathLen = @PathLen - 1

 /* Add subsequent entries*/   
 WHILE @PathLen >= 0
 BEGIN
 
  SELECT @PathID = @PathID + '\' + convert(varchar(10),NodeId),
   @FullPathName = @FullPathName + '\' + NodeName
   FROM #base
   WHERE #base.PathLength = @PathLen 

  SET @PathLen = @PathLen - 1

 END

 SELECT @PathID as PathID, @FullPathName as PathName
END
ELSE
  SELECT '' as PathID, '' as PathName /* invalid node passed in */


END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


-- epo3.5 performance improvement: lookup from dynamic table instead of runtime recalculate
-- New routine which does lookup from existing table: ReportFullPathNodeID

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodePath]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodePath]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetNodePath
 @NodeID  INT
AS 
BEGIN

SET NOCOUNT ON

 Declare @FullPathNodeID nvarchar(128)
 Declare @FullPathName nvarchar(450)
 Declare @GlobalRoot nvarchar(50)
 Set @GlobalRoot = ''
 Declare @GlobalRootID nvarchar(5)
 Set @GlobalRootID = ''

	Select @GlobalRootID=convert(nchar(5), autoid), @GlobalRoot=NodeName 
		from BranchNode where type = 7

	Select @FullPathNodeID=FullPathNodeID, @FullPathName=rtrim(@GlobalRoot)+'\'+FullPathName 
 		from ReportFullPathNodeID
		where LowestNodeID = @NodeID

 -- DAL requires an empty string if nodeid = 0
 if @NodeID = 0 or @FullPathNodeID = '' or @FullPathNodeID is null
 begin
	Declare @Global nchar(10)
	Select @Global=autoid from BranchNode where autoid = @NodeID and Type = 7
	if @Global = '' or @Global is null
		Select '' as PathID, '' as PathName
	else	Select @GlobalRootID as PathID, rtrim(@GlobalRoot) as PathName
 end
 else
	Select @FullPathNodeID as PathID, @FullPathName as PathName
-- 		from ReportFullPathNodeID
--		where LowestNodeID = @NodeID

END
GO


------------------

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodePathIDepo3]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodePathIDepo3]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetNodePathIDepo3
 @NodeID  INT
AS 
BEGIN

SET NOCOUNT ON

 DECLARE @PathID varchar(500)
 DECLARE @PathLen int


IF EXISTS (Select * from BranchNode where AutoID = @Nodeid)
BEGIN
 /* Fetch decendents from enum table */   
 SELECT StartAutoID as NodeId, PathLength
  INTO #base
             FROM BranchNodeEnum
                          WHERE 
                                   EndAutoID = @NodeID
     ORDER BY PathLength desc

 /* Add input node */   
 INSERT #base
  Values( @NodeID , 0 )

  
 SELECT @PathLen = MAX(PathLength) from #base

 /* Traverse path - add first entry */   
 SELECT @PathID = convert(varchar(10),NodeId)
   FROM #base
   WHERE #base.PathLength = @PathLen
 SET @PathLen = @PathLen - 1

 /* Add subsequent entries*/   
 WHILE @PathLen >= 0
 BEGIN
 
  SELECT @PathID = @PathID + '\' + convert(varchar(10),NodeId)
   FROM #base
   WHERE #base.PathLength = @PathLen 

  SET @PathLen = @PathLen - 1

 END

 SELECT @PathID as PathID
END
ELSE
 SELECT '' as PathID /* invalid node passed in */


END
GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


------------------------------------------------------
-- epo3.5: smb change
-- performance improvement: lookup from dynamic table instead of runtime recalculate
-- New routine which does lookup from existing table: ReportFullPathNodeID

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_GetNodePathID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_GetNodePathID]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_GetNodePathID
 @NodeID  INT
AS 
BEGIN

SET NOCOUNT ON

 Declare @FullPathNodeID nvarchar(128)

	Select @FullPathNodeID=FullPathNodeID 
 		from ReportFullPathNodeID
		where LowestNodeID = @NodeID

 -- DAL requires an empty string if nodeid = 0
 if @NodeID = 0 or @FullPathNodeID = '' or @FullPathNodeID is null
 begin
	Declare @GlobalRoot nvarchar(5)
	Set @GlobalRoot = ''
	Select @GlobalRoot=convert(nchar(5), autoid) 
		from BranchNode where autoid = @NodeID and Type = 7
	if @GlobalRoot = ''
		Select '' as PathID
	else	Select @GlobalRoot as PathID
 end
 else
	Select @FullPathNodeID as PathID
-- 		from ReportFullPathNodeID
--		where LowestNodeID = @NodeID

END
GO


-------------------------------------------------------
-- mhilandepo3 
-- conversion of 2.5 common updater policy and task settings to 3.0 agent settings
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_ConvertCMU2CMA]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_ConvertCMU2CMA]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVIDALSP_ConvertCMU2CMA
as
Begin



-- test code
--drop table testcmupolicies
--drop table testagent3policies

--select parenttype, sectionname, settingname, value, productcode
--into testcmupolicies
--from
--policy, policysettings
--where
--policy.autoid = policysettings.parentid
--and productcode = 'CMNUPD__3000'
--order by parenttype, sectionname, settingname

--select * from testagent3policies
--select * from testcmupolicies

-----------------------------------------
-- make sure this rotuine is only run once

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = 'ReportCMUUpgrade')
begin
select 1 as CMUUpgradeRun into ReportCMUUpgrade


---------------------------------------------------------
-- Do this hear to assure that all leafnode.agentversion data is up to date
-- populate new field: leafnode.agentversion

update leafnode
set agentversion = productproperties.productversion
from productproperties, leafnode, aviview_software
where 
productproperties.parentid = leafnode.autoid
and productproperties.productcode = aviview_software.productcode
and aviview_software.productfamily = 'EPO'
and aviview_software.productcode like 'ePOAgent%'




-----------------------------------------------------
-- First step is to just copy over the cnu task and policies to agent3.0 rask policies
-- There is a separate epo agent 2 - 3 policy upgrade script associated with the 3.0 agent nap
-- copy over 2.0 policies to 3.0 policies only if non glogal 3.0 polies dont exist

-- rename cmu sites so that they dont match default epo3 sites
Update
policysettings
Set Value = Value + '2X'
From policy
Where
policy.autoid = policysettings.parentid
and productcode = 'CMNUPD__3000'
and policy.parenttype != 7
and sectionname = 'SiteList'
and ( settingname like 'szID%'
	or settingname like 'szName%'
    )
and ( value in ('NAIFtp','NAIHttp')
	or value like 'ePO_%'
    )

------------------------
-- Copy all non global policy table 2.0 policies to 3.0 policies
--if not exists (select * from Policy where ProductCode = 'EPOAGENT3000' and parentType != 7)
insert Policy
(ParentID, ParentType, ProductCode)
select ParentID, ParentType, 'EPOAGENT3000'
from Policy
where
Policy.ProductCode = 'CMNUPD__3000'
and Policy.ParentType in (6, 5, 4, 3, 1)
group by parentid, Parenttype	-- assure just one entry


-- Get table to computers with 2.0 and 3.0 policies
-- get policy.autoids of all 2.0 and 3.0 agent policies
select a.AutoID as AutoID2, b.AutoID as AutoID3
into #AgentPolicyIDs
from Policy a, Policy b
where
a.ProductCode = 'CMNUPD__3000'
and b.ProductCode = 'EPOAGENT3000'
and a.ParentType = b.ParentType
and a.ParentID = b.ParentID
and a.ParentType in (6, 5, 4, 3, 1)


-- Copy all non global PolicySetting from 2.0 policy settings to 3.0 policy settings
--if not exists (select * from PolicySettings, Policy 
--		where PolicySettings.ParentID = Policy.AutoID 
--			and ProductCode = 'EPOAGENT3000' and parentType != 7)
insert PolicySettings
(ParentID, SectionName, SettingName, Value)
select #AgentPolicyIDs.AutoID3, SectionName, SettingName, Value
from PolicySettings, #AgentPolicyIDs
where
PolicySettings.ParentID = #AgentPolicyIDs.AutoID2
group by #AgentPolicyIDs.AutoID3, SectionName, SettingName, Value


drop table #AgentPolicyIDs

-----------------
-- test code
--select ParentID, autoid, ParentType, ProductCode  --, JustPlaceHolder
--from Policy
--where
--Policy.ProductCode = 'CMNUPD__3000' and ParentType in (6,5,4,3,1)


--select policy.ParentID, policy.autoid, ParentType, ProductCode, policysettings.*  --, JustPlaceHolder
--from Policy, policysettings
--where policy.autoid *= policysettings.parentid and Policy.ProductCode = 'EPOAGENT3000'
--and  ParentType in (6,5,4,3,1)
--order by policy.autoid

-- show cmu to epoagnt3 link table
--select a.AutoID as AutoID2, b.AutoID as AutoID3
--from Policy a, Policy b
--where
--a.ProductCode = 'CMNUPD__3000'
--and b.ProductCode = 'EPOAGENT3000'
--and a.ParentType = b.ParentType
--and a.ParentID = b.ParentID
--and a.ParentType in (6, 5, 4, 3, 1)

-- look for dups
--select policysettings.parentid, sectionname, settingname, value, count(*)
--from policy, policysettings
--where policy.autoid = policysettings.parentid
--group by 
--policysettings.parentid, sectionname, settingname, value
--having count(*) > 1


---------------------------------------------------------------------------
-- Special conversion of netshield tasks

Update Task
Set PlatformsSupported = 'WNTS|WXPS|WXPHE|W2KS'
Where ProductCode = 'NETSHLD_4500'
and 
(
ParentType in (7,6,5,4,3,1)
--or
--(ParentType = 7 and GlobalTaskID > 0 )
)


----------------------------------------------------------------------------
-- Convert cmu tasks
-- copy over all task data and relink globaltaskid field
-- There are no agent 2.0 tasks, so only need to copy over cmu tasks


-- Must copy over task and policies not just move them
-- Copy all non global Task table 2.0 policies to 3.0 policies
-- Copy over global root tasks, but only those with GlobalTaskID > 0
--if not exists (select * from Task where ProductCode = 'EPOAGENT3000' and (parentType != 7 or GlobalTaskID > 0))
--insert Task
--(ParentID, ParentType, ProductCode, TaskStatus, TaskType, TaskName, PlatformsSupported, Priority, GlobalTaskID) --, JustPlaceHolder)

-- Temp table for copying cma task and linking them with epoagent3 tasks 
CREATE TABLE [dbo].[#TmpTask] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[ParentType] [tinyint] NOT NULL ,
	[ParentID] [int] NOT NULL ,
	[GlobalTaskID] [int] NOT NULL ,
	[TaskStatus] [tinyint] NULL ,
	[TheTimestamp] [binary] (8) NULL ,
	[ProductCode] [nvarchar] (50) NULL ,
	[DeleteTimestamp] [binary] (8) NULL ,
	[TaskType] [nvarchar] (50) NULL ,
	[TaskName] [nvarchar] (150) NULL ,
	[PlatformsSupported] [nvarchar] (250) NULL ,
	[JustPlaceHolder] [bit] NULL ,
	[Priority] [int] NULL,
	[Agent3AutoID] [int],		-- must link epoagent3 autoid
	[CMAAutoID] [int]    		-- with cma autoid
) 

-- copy all cmu tasks

insert #TmpTask
(ParentType, ParentID, GlobalTaskID, TaskStatus, TheTimestamp, ProductCode, DeleteTimestamp,
	TaskType, TaskName, PlatformsSupported, JustPlaceHolder, Priority, Agent3AutoID, CMAAutoID)
select 
ParentType, ParentID, GlobalTaskID, TaskStatus, TheTimestamp, 'EPOAGENT3000' as ProductCode, DeleteTimestamp,
	TaskType, TaskName, PlatformsSupported, JustPlaceHolder, Priority, 0 as Agent3AutoID, autoid as CMAAutoID
from Task
where
Task.ProductCode = 'CMNUPD__3000'
and 
(
ParentType in (6,5,4,3,1)
or
(ParentType = 7 and GlobalTaskID > 0 )
)
order by autoid

-- Find next task autoid value
Declare @NextTaskid int
Select @NextTaskid = max(autoid) from Task

-- populate Agent3AutoID field in #TmpTask
Update #TmpTask
set Agent3AutoID = @NextTaskid + autoid

-- create agent3 tasks
insert Task
(ParentType, ParentID, GlobalTaskID, TaskStatus, TheTimestamp, ProductCode, DeleteTimestamp,
	TaskType, TaskName, PlatformsSupported, JustPlaceHolder, Priority)
select 
ParentType, ParentID, GlobalTaskID, TaskStatus, TheTimestamp, 'EPOAGENT3000' as ProductCode, DeleteTimestamp,
	TaskType, TaskName, PlatformsSupported, JustPlaceHolder, Priority
from #TmpTask
order by autoid

-- update GlobalTaskID field, link it to agent3 task instead of cma task
update Task
Set GlobalTaskID = Agent3AutoID
From #TmpTask
where
Task.GlobalTaskID = #TmpTask.CMAAutoID
and Task.ProductCode = 'EPOAGENT3000'
and 
(
Task.ParentType in (6,5,4,3,1)
or
(Task.ParentType = 7 and Task.GlobalTaskID > 0 )
)

-- test: compare results
--select * from task
--where
--Task.ProductCode = 'EPOAGENT3000'
--and 
--(ParentType in (6,5,4,3,1) or (ParentType = 7 and GlobalTaskID > 0 ) )
--order by parentid, parenttype, autoid

--select * from task
--where
--Task.ProductCode = 'CMNUPD__3000'
--and 
--(ParentType in (6,5,4,3,1) or (ParentType = 7 and GlobalTaskID > 0 ) )
--order by parentid, parenttype, autoid



-- copy cma tasksettings to agent3 task settings
-- Copy all non global TaskSetting from 2.0 Task settings to 3.0 Task settings
-- copy only settings where GlobalTaskID > 0
-- Change parentid to point to the agent3 task
insert TaskSettings
(ParentID, SectionName, SettingName, Value, TheTimestamp)
select Agent3AutoID, SectionName, SettingName, Value, TaskSettings.TheTimestamp
from TaskSettings, #TmpTask
where
TaskSettings.ParentID = #TmpTask.CMAAutoID
--order by parentid, parenttype, autoid

-- test: look for duplicate task settings
--select task.taskname, tasksettings.parentid, sectionname, settingname, value, count(*)
--from task, tasksettings
--where task.autoid = tasksettings.parentid
--group by 
--task.taskname, tasksettings.parentid, sectionname, settingname, value
--having count(*) > 1

-- test: make sure agent3 and cma tasks have the same number of settings
--select task.parentid, task.parenttype, task.GlobalTaskID, task.Taskname, task.Tasktype, count(*)
--from task, tasksettings
--where task.autoid = tasksettings.parentid
--and task.ProductCode = 'CMNUPD__3000'
--and (Task.ParentType in (6,5,4,3,1) or (Task.ParentType = 7 and GlobalTaskID > 0 ) )
--Group by task.parentid, task.parenttype, task.GlobalTaskID, task.Taskname, task.Tasktype
--order by Task.parentid, Task.parenttype

-- test: make sure agent3 and cma tasks have the same number of settings
--select task.parentid, task.parenttype, task.GlobalTaskID, task.Taskname, task.Tasktype, count(*)
--from task, tasksettings
--where task.autoid = tasksettings.parentid
--and task.ProductCode = 'EPOAGENT3000'
--and (Task.ParentType in (6,5,4,3,1) or (Task.ParentType = 7 and GlobalTaskID > 0 ) )
--Group by task.parentid, task.parenttype, task.GlobalTaskID, task.Taskname, task.Tasktype
--order by Task.parentid, Task.parenttype

drop table #TmpTask




------------------------------------------------------
-- Funny policy conversion code starts here
-- cmu doesnt have a InetManager section
-- cma changed the design and included one to make my life hard (poor me)

-- Resulting changes
--[InetManager]
--DisabledSitesNum=2
--DisabledSites_0=NAIFtp
--DisabledSites_1=NAIHttp
--
--SitelistOrderNum=2
--SitelistOrder_0=NAIFtp
--SitelistOrder_1=NAIHttp
--
--For the disabled sites policies:
--
-- DisabledSitesNum is the total number of sites from CMU where bEnabled_# is 0 (purple)
-- For each site where bEnabled_# is 0, add a policy named "DisabledSites_#" and use the value from "szName" (red) for the coresponding site from CMU
--
--For the SitelistOrder policies
--
-- SitelistOrderNum should have the same value as "uiNumberOfSites" (green)
-- For each site in CMU, a "SitelistOrder_#" value is needed where the # is equal to the "uiOrder" value minus 1 (to make it zero based, see the blue numbers above.), and "szName" (red) is used for the value.



-- set number of disabled sites
insert PolicySettings (ParentID, SectionName, SettingName, Value)
select 
PolicySettings.ParentID, 'InetManager', 'DisabledSitesNum', 
	case value
		when 0 then sum(1)
		else sum(0)
	end as value
from PolicySettings, Policy
Where
	PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
	and SectionName = 'SiteList' 
	and SettingName like 'bEnabled_%'
Group By PolicySettings.ParentID, value	
having value = 0


-- set number of sites
insert PolicySettings (ParentID, SectionName, SettingName, Value)
select 
PolicySettings.ParentID, 'InetManager', 'SitelistOrderNum', max(Value)
from PolicySettings, Policy
Where
	PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
	and SectionName = 'SiteList' 
	and SettingName = 'uiNumberOfSites'
Group By PolicySettings.ParentID		-- make sure there is only one of these


-- Loop through data to create sitelist and disabled sitelist 
Declare @cnt int
Declare @MaxSites int
Set @cnt=0

create table #SitelistType 
(
	ParentID 	int
	,cnt 		int
	,ListNum 	int
	,szName 	varchar(255)
	,bEnabled 	int
	,DisableNum	int
)

create table #DiabledSiteCnt 
(
	ParentID 	int
	,DisableCnt 	int
)

-- initialize disable site count table, update this table as you parse through to keep track of what
--	disabled site number you are on 
insert #DiabledSiteCnt 
select distinct ParentID, 0
from PolicySettings

-- find maxsite count
select @MaxSites= max(value) 
	from PolicySettings, Policy
	Where
	PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
	and SectionName = 'SiteList' 
	and SettingName = 'uiNumberOfSites'
--Group By PolicySettings.ParentID	


While( @cnt < @MaxSites )
begin

	-- add to temp table all site entries at cnt @cnt
	insert  #SitelistType
	Select PolicySettings.ParentID, @cnt as cnt, value as ListNum, '' as szName, 0 as bEnabled, 0 as DisableNum
	from PolicySettings, Policy
	Where
		PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
		and SectionName = 'SiteList' 
		and SettingName = ('uiOrder_' + convert(varchar(10),@cnt))
	

	-- update sitetype
	Update #SitelistType
	Set szName = value
	from PolicySettings, Policy
	Where
		PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
		and #SitelistType.ParentID = PolicySettings.ParentID
		and SectionName = 'SiteList' 
		and SettingName = ('szName_' + convert(varchar(10),@cnt))

	-- update enable flag
	Update #SitelistType
	Set bEnabled = value
	from PolicySettings, Policy
	Where
		PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
		and #SitelistType.ParentID = PolicySettings.ParentID
		and SectionName = 'SiteList' 
		and SettingName = ('bEnabled_' + convert(varchar(10),@cnt))

	-- update disable counter
	Update #DiabledSiteCnt
	Set DisableCnt = DisableCnt + 1
	from PolicySettings, Policy
	Where
		PolicySettings.ParentID = Policy.AutoID and ProductCode = 'EPOAGENT3000'
		and #DiabledSiteCnt.ParentID = PolicySettings.ParentID
		and SectionName = 'SiteList' 
		and SettingName = ('bEnabled_' + convert(varchar(10),@cnt))
		and Value = 0

	-- insert site list type
	insert PolicySettings (ParentID, SectionName, SettingName, Value)
	select 
	ParentID, 'InetManager', 'SitelistOrder_'+convert(varchar(10),(ListNum-1)), szName
	from #SitelistType

	-- insert disabled site list type (use disable counter and sitename)
	insert PolicySettings (ParentID, SectionName, SettingName, Value)
	select 
	#SitelistType.ParentID, 'InetManager', 'DisabledSites_'+convert(varchar(10),(#DiabledSiteCnt.DisableCnt-1)), #SitelistType.szName
	from #SitelistType, #DiabledSiteCnt
	where 
		#SitelistType.parentid = #DiabledSiteCnt.parentid
		and #SitelistType.cnt=@cnt
		and #SitelistType.bEnabled=0

	Set @cnt = @cnt + 1
	Truncate table #SitelistType
End


------------------------------------
-- test it

--select policy.ParentID, policy.autoid, ParentType, ProductCode, policysettings.*  --, JustPlaceHolder
--from Policy, policysettings
--where policy.autoid *= policysettings.parentid and Policy.ProductCode = 'EPOAGENT3000'
--and  ParentType in (6,5,4,3,1)
--order by policy.autoid

-- look for dups
--select policysettings.parentid, sectionname, settingname, value, count(*)
--from policy, policysettings
--where policy.autoid = policysettings.parentid
--group by 
--policysettings.parentid, sectionname, settingname, value
--having count(*) > 1

--drop table testcmupolicies
--drop table testagent3policies

--select parenttype, sectionname, settingname, value, productcode
--into testagent3policies
--from
--policy, policysettings
--where
--policy.autoid = policysettings.parentid
--and productcode = 'epoagent3000'
--order by parenttype, sectionname, settingname


--select * from testagent3policies
--select * from testcmupolicies

-- more fun special processing
-- Its possible that the 2X created site names that match the default 3.0 site names. Change the 2.x site names
--	by adding a suffix so this cannot happen

-- This is now done at the top before the copy
--Update
--policysettings
--Set Value = Value + '2X'
--From policy
--Where
--policy.autoid = policysettings.parentid
--and productcode = 'EPOAGENT3000'
--and policy.parenttype != 7
--and sectionname = 'InetManager'
--and ( settingname like 'SitelistOrder%'
--	or settingname like 'DisabledSites%'
--    )
--and ( value in ('NAIFtp','NAIHttp')
--    )


drop table #SitelistType

drop table #DiabledSiteCnt

end

end
GO



-------------------------------------------------------
-- mhilandepo3 
-- This routine will remove 2.x tasks and agents once the 3.0 agent upgrade is complete
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_Remove2XAgentPolicyTask]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_Remove2XAgentPolicyTask]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVIDALSP_Remove2XAgentPolicyTask
as
Begin


-- remove tasks & policies for all legacy products
-- dont delete agent tasks, this is done in the agent upgrade script
delete TaskSettings 
from Task
Where 
TaskSettings.ParentID = Task.AutoID
and ProductCode in ( 'EPOAGENT2000','EPOAGENT1000','CMNUPD__3000' )


delete Task
Where 
ProductCode in ( 'EPOAGENT2000','EPOAGENT1000','CMNUPD__3000' )


delete PolicySettings 
from Policy
Where 
PolicySettings.ParentID = Policy.AutoID
and ProductCode in ( 'EPOAGENT2000','EPOAGENT1000','CMNUPD__3000' )


delete Policy
Where 
ProductCode in ( 'EPOAGENT2000','EPOAGENT1000','CMNUPD__3000' )

End
GO



-------------------------------------------------------
-- mhilandepo3 
-- This routine will remove orphaned table entires for:
-- ProductSettings
-- ProductProperties
-- ComputerProperties
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_RemoveOrphans]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_RemoveOrphans]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVIDALSP_RemoveOrphans
as
BEGIN

	Delete ProductProperties 
	Where ParentID not in (select autoid from Leafnode) 

	Delete ComputerProperties 
	Where ParentID not in (select autoid from Leafnode) 

	Delete ProductSettings 
	Where ParentID not in (select autoid from ProductProperties) 

END
GO



-------------------------------------------------------
-- mhilandepo3 
-- Add agent 3.0 deployment task for 3.0 upgrade
-- mhilandepo3.5 Add Sensor Deployment Task
-- This routine is called by a script within the agent nap file

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVIDALSP_UpgradeAddDeploymentTask]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVIDALSP_UpgradeAddDeploymentTask]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


CREATE PROCEDURE dbo.AVIDALSP_UpgradeAddDeploymentTask
as
Begin


-- Script to insert a centralized deployment task at the directory level rather than
--	the global root level


-----------------------------------------
-- make sure this rotuine is only run once

IF NOT EXISTS (SELECT * FROM task WHERE ProductCode = 'EPOAGENT3000' and ParentType =4 and TaskName = 'Deployment')
begin



-- create global root task pointing to the base global root task
-- task
-- globalTaskID = 1234 is fake and gets overwritten below
insert Task
(ParentID, ParentType, GlobalTaskID, TaskType, TaskName, ProductCode)
select branchnode.autoid, 7, 1234, 'Deployment', 'Deployment', 'EPOAGENT3000'
from branchnode
where branchnode.Type = 7



-- Update Platforms Supported field
Update task
Set PlatformsSupported = (select PlatformsSupported from task where ParentType = 7
						and GlobalTaskID = 0
						and TaskType = 'Deployment'
						and ProductCode = 'EPOAGENT3000')
Where
ParentType = 7
and GlobalTaskID = 1234
and TaskType = 'Deployment'
and ProductCode = 'EPOAGENT3000'



-- Update second global root task to point to the base global root task
Update task
Set GlobalTaskID = (select AutoID from task where ParentType = 7
						and GlobalTaskID = 0
						and TaskType = 'Deployment'
						and ProductCode = 'EPOAGENT3000')
Where
ParentType = 7
and GlobalTaskID = 1234
and TaskType = 'Deployment'
and ProductCode = 'EPOAGENT3000'


-- create directory level task without settings (uses global root settings)
-- task
insert Task
(ParentID, ParentType, GlobalTaskID, TaskType, TaskName, ProductCode)
select branchnode.autoid, 4, 0, 'Deployment', 'Deployment', 'EPOAGENT3000'
from branchnode
where branchnode.Type = 4


-- Update Platforms Supported field
Update task
Set PlatformsSupported = (select PlatformsSupported from task where ParentType = 7
						and GlobalTaskID = 0
						and TaskType = 'Deployment'
						and ProductCode = 'EPOAGENT3000')
Where
ParentType = 4
and GlobalTaskID = 0
and TaskType = 'Deployment'
and ProductCode = 'EPOAGENT3000'



-- Update directory level task to point to the global root task
Update task
Set GlobalTaskID = (select AutoID from task where ParentType = 7
						and GlobalTaskID > 0
						and TaskType = 'Deployment'
						and ProductCode = 'EPOAGENT3000')
Where
ParentType = 4
and GlobalTaskID = 0
and TaskType = 'Deployment'
and ProductCode = 'EPOAGENT3000'




-- tasksettings for 2nd global root task record
insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Settings', 'Enabled', '0'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'GMTTime', '0'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'MaskDaysOfWeek', '2'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'IdleMinutes', '10'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'RepeatWeeks', '1'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'RepeatDays', '1'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'UntilTime', (substring(convert(char,getdate(),112),1,8)+'000000')
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'StartDateTime', (substring(convert(char,getdate(),112),1,8)+'000000')
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'RunIfMissed', '0'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'Schedule', 'Type', '0'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


insert TaskSettings
(ParentID, SectionName, SettingName, Value)
select Task.AutoID, 'General', 'TaskType', 'Deployment'
from Task
where
Task.ParentType = 7 
and GlobalTaskID > 0
and Task.ProductCode = 'EPOAGENT3000' 
and Task.TaskType = 'Deployment'


-- test: make sure agent3 and cma tasks have the same number of settings
--select task.parentid, task.parenttype, task.GlobalTaskID, task.Taskname, task.Tasktype, tasksettings.*
--from task, tasksettings
--where task.autoid = tasksettings.parentid
--and task.tasktype = 'Deployment'
--and task.ProductCode = 'EPOAGENT3000'
--and (Task.ParentType in (6,5,4,3,1) or (Task.ParentType = 7 and GlobalTaskID > 0 ) )
--order by Task.parentid, Task.parenttype

END




END
GO
-- end


---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-- routines from epo2.5-to-3.0.sql  copied again to assure the owner is dbo
-- Try to remove the procedures twice (non explicit ownership) incase they where installed under a new account
--	and have multiple copies with different ownership.
--	create the routine with explicit dbo ownership


--------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_Update_ServerTask_Status]'))
drop procedure [dbo].[EPOSP_Update_ServerTask_Status]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_Update_ServerTask_Status]'))
drop procedure [EPOSP_Update_ServerTask_Status]
GO


CREATE PROCEDURE dbo.EPOSP_Update_ServerTask_Status 
 @ServerTaskID  int,
 @NewStatus 	int,
 @TheDate	nvarchar(20)
AS

BEGIN
	--Update the status flag in the server task entry
	UPDATE ServerTask SET Status=@NewStatus WHERE AutoID=@ServerTaskID

	--Insert another entry to the Server Task log for this change

	--Get the Task Type name so we can fill it into the log
	DECLARE @TaskName NVARCHAR (200)
	DECLARE @TypeName INT
	DECLARE @TypeCode NVARCHAR (100)
	
	SELECT TOP 1 @TypeCode=TaskTypeCode,@TaskName=ServerTaskName FROM ServerTask 
		WHERE AutoID = @ServerTaskID

	SELECT TOP 1 @TypeName=ServerTaskTypeName FROM ServerTaskType 
		WHERE TaskTypeCode = @TypeCode

	INSERT ServerTaskLog 
		(ServerTaskID, ServerTaskName, ServerTaskTypeName, Status, TheDate)
	VALUES
		(@ServerTaskID, @TaskName, @TypeName, @NewStatus, @TheDate)
END


GO


-----------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_Update_ServerTask_Status_By_GUID]'))
drop procedure dbo.EPOSP_Update_ServerTask_Status_By_GUID
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_Update_ServerTask_Status_By_GUID]'))
drop procedure EPOSP_Update_ServerTask_Status_By_GUID
GO



CREATE PROCEDURE dbo.EPOSP_Update_ServerTask_Status_By_GUID
 @ServerTaskGUID  NVARCHAR(200),
 @NewStatus 	  int,
 @TheDate	  nvarchar(20)
AS

BEGIN
	SET NOCOUNT ON
	DECLARE @ServerTaskID INT
	SELECT TOP 1 @ServerTaskID=AutoID FROM ServerTask WHERE SchedulerTaskID=@ServerTaskGUID

	EXEC EPOSP_Update_ServerTask_Status @ServerTaskID, @NewStatus, @TheDate
END

GO



----------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_Delete_ServerTask]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SP_Delete_ServerTask]
GO

if exists (select * from sysobjects where id = object_id(N'[SP_Delete_ServerTask]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SP_Delete_ServerTask]
GO


CREATE PROCEDURE dbo.SP_Delete_ServerTask 
( 
@AutoID INT
) 
AS 
BEGIN
SET NOCOUNT ON

delete ServerTask where AutoID=@AutoID

SET NOCOUNT OFF
END
GO


------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_Delete_ServerTaskType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SP_Delete_ServerTaskType]
GO

if exists (select * from sysobjects where id = object_id(N'[SP_Delete_ServerTaskType]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SP_Delete_ServerTaskType]
GO


CREATE PROCEDURE dbo.SP_Delete_ServerTaskType 
( 
@AutoID INT
) 
AS 
BEGIN
SET NOCOUNT ON

delete ServerTaskType where AutoID=@AutoID

SET NOCOUNT OFF
END
GO

-----------
if exists (select * from sysobjects where id = object_id(N'[dbo].[SP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SP_DeadAgentRemoval]
GO

if exists (select * from sysobjects where id = object_id(N'[SP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SP_DeadAgentRemoval]
GO

CREATE PROCEDURE dbo.SP_DeadAgentRemoval
(
@nTaskID	INT,		-- ServerTask ID
@STTime		NVARCHAR(20),  	-- Time this servertask is run (for the server task log
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Mark ServerTask as executing
EXEC EPOSP_Update_ServerTask_Status @nTaskID,1,@STTime

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode WHERE lastupdate<@TheDate and lastupdate <> ''
END

IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	SET ParentID=@DestID WHERE lastupdate<@TheDate and lastupdate <> ''
END

DECLARE @DateAfter smalldatetime
declare @i1 int
declare @nHour int
declare @nMin int
declare @nSec int
declare @szTime NVARCHAR(20)
declare @nTime numeric(20,0)


SET @DateAfter = GETDATE()
set @nHour = DATEDIFF(Hour, @CurrentDate, @DateAfter)
set @nMin  = DATEDIFF(Minute, @CurrentDate, @DateAfter)
set @nSec  = DATEDIFF(Second, @CurrentDate, @DateAfter)

set @nTime = @STTime
set @nTime = @nTime + @nSec + (100 * @nMin) + (10000 * @nHour)
set @szTime = @nTime


--Mark ServerTask as completed
EXEC EPOSP_Update_ServerTask_Status @nTaskID,2,@szTime

SET NOCOUNT OFF
END

GO




--************************* Event Parser Stuff **************************

if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_InsertUpdateEvent]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_InsertUpdateEvent]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_InsertUpdateEvent]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [EPOSP_InsertUpdateEvent]
GO


CREATE PROCEDURE dbo.EPOSP_InsertUpdateEvent
(
   @AgentGUID 		uniqueidentifier,
   @HostName		NVARCHAR(512),
   @HostIPAddress 	NVARCHAR(16),
   @UserName   		NVARCHAR(32),
   @TimeZoneBias 	INT,
   @TVDEventID		INT,
   @TVDSeverity         INT,        
   @EventDateTime       DATETIME,                       
   @Type   		NVARCHAR(50),
   @Version   		NVARCHAR(50),
   @Error   		INT,
   @Locale   		NVARCHAR(50),
   @ProductCode		NVARCHAR(50),
   @SiteName		NVARCHAR(100),
   @InitiatorID 	NVARCHAR (50),
   @InitiatorType	NVARCHAR  (50)
)
AS
BEGIN         
SET XACT_ABORT ON
SET NOCOUNT ON

DECLARE @NodeID INT
DECLARE @EventLocalDateTime  DATETIME


IF (@EventDateTime IS NOT NULL)
BEGIN
	SET @EventLocalDateTime = DATEADD(minute, -@TimeZoneBias, @EventDateTime)
END


SELECT @NodeID = (SELECT AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID)
IF @NodeID IS NULL
BEGIN	
	SET @NodeID = 0
END

INSERT INTO ProductEvents 
	(HostName, AgentGUID, NodeID, UserName, HostIPAddress,
	TVDEventID,TVDSeverity,EventDateTime,EventLocalDateTime,
	Type,Version,Error,Locale,ProductCode,SiteName,InitiatorID,InitiatorType) 

 VALUES (@HostName, @AgentGUID, @NodeID, @UserName, @HostIPAddress,
	@TVDEventID,@TVDSeverity,@EventDateTime,@EventLocalDateTime,
	@Type,@Version,@Error,@Locale,@ProductCode,@SiteName,@InitiatorID,@InitiatorType) 

END
GO





-------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeleteProps]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeleteProps]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_DeleteProps]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [EPOSP_DeleteProps]
GO


CREATE PROCEDURE dbo.EPOSP_DeleteProps
 @ParentID  int
AS
BEGIN
SET XACT_ABORT ON
SET NOCOUNT ON

Delete ProductProperties where ParentID = @ParentID

END


GO



-------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeleteProdProps]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeleteProdProps]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_DeleteProdProps]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [EPOSP_DeleteProdProps]
GO


CREATE PROCEDURE dbo.EPOSP_DeleteProdProps
 @ParentID  int,
 @ProductCode nvarchar(50)
AS
BEGIN
SET XACT_ABORT ON
SET NOCOUNT ON

Delete ProductProperties where ParentID = @ParentID and ProductCode=@ProductCode

END

GO


---------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_InsertProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_InsertProdProp]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_InsertProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [EPOSP_InsertProdProp]
GO


CREATE PROCEDURE dbo.EPOSP_InsertProdProp
 @ParentID  int,
 @ProductCode nvarchar(50)
AS
BEGIN
SET XACT_ABORT ON
SET NOCOUNT ON

DECLARE @AutoID INT

Set @AutoID = (Select TOP 1 AutoID from ProductProperties where ParentID=@ParentID and ProductCode=@ProductCode)
if @AutoID is NULL
BEGIN
	INSERT INTO ProductProperties (ParentID, ProductCode) 
	VALUES (@ParentID, @ProductCode)

	Set @AutoID = (SELECT TOP 1 AutoID from ProductProperties where ParentID=@ParentID and ProductCode=@ProductCode)
END

Select @AutoID as AutoID

END



GO


----------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_InsertProdSetting]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_InsertProdSetting]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_InsertProdSetting]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [EPOSP_InsertProdSetting]
GO


CREATE PROCEDURE dbo.EPOSP_InsertProdSetting
( @ParentID INT,
  @SettingName	NVARCHAR(100),
  @SectionName NVARCHAR(100),
  @Value NVARCHAR(3000)
)
AS
BEGIN         
SET XACT_ABORT ON
SET NOCOUNT ON

UPDATE ProductSettings SET Value=@Value 
WHERE ParentID=@ParentID
AND SettingName=@SettingName
AND SectionName=@SectionName

IF (@@ROWCOUNT<1)
BEGIN
	INSERT INTO ProductSettings (ParentID, SettingName, SectionName, Value) 
	VALUES (@ParentID, @SettingName, @SectionName, @Value)
END

END

GO


-------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_UpdateProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_UpdateProdProp]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_UpdateProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [EPOSP_UpdateProdProp]
GO


CREATE PROCEDURE dbo.EPOSP_UpdateProdProp
 @AutoID  int,
 @ProductVersion nvarchar(25),
 @DATVer nvarchar(25),
 @DATDate nvarchar(50),
 @EngineVer nvarchar(25),
 @ExtraDATNames nvarchar(100),
 @ProductSerialNum nvarchar(100),
 @InstalledPath nvarchar(255),
 @Language nvarchar(50),
 @LicenseStatus nvarchar(50),
 @ExpirationDate nvarchar(16),
 @Hotfix nvarchar(100),
 @Servicepack nvarchar(100),

 @ProductFamily nvarchar(255),
 @ProductName nvarchar(255),
 @ProductCode nvarchar(50),
 @PlatformsSupported nvarchar(255)

AS
BEGIN
SET XACT_ABORT ON
SET NOCOUNT ON

declare @ParentID int

-----------------------------
-- check if full props

if @ProductVersion > '' and @DATVer > '' and @EngineVer > '' 

Update ProductProperties set ProductVersion=@ProductVersion, DATVer=@DATVer, DATDate=@DATDate, EngineVer=@EngineVer, 
ExtraDATNames=@ExtraDATNames, ProductSerialNum=@ProductSerialNum, InstalledPath=@InstalledPath, Language=@Language,
LicenseStatus=@LicenseStatus,ExpirationDate=@ExpirationDate,Hotfix=@Hotfix,Servicepack=@Servicepack
where AutoID = @AutoID

else
begin
-- Incremental props can update only one field at a time, Check for individual updates

if @ProductVersion > ''
Update ProductProperties set ProductVersion=@ProductVersion
where AutoID = @AutoID

if @DATVer > ''
Update ProductProperties 
set DATVer=@DATVer, DATDate=@DATDate
where AutoID = @AutoID

if @EngineVer > ''
Update ProductProperties 
set EngineVer=@EngineVer
where AutoID = @AutoID

if @ExtraDATNames > ''
Update ProductProperties 
set ExtraDATNames=@ExtraDATNames
where AutoID = @AutoID

if @Hotfix > ''
Update ProductProperties 
set Hotfix=@Hotfix
where AutoID = @AutoID

if @Servicepack > ''
Update ProductProperties 
set Servicepack=@Servicepack
where AutoID = @AutoID

if @ProductSerialNum > ''
Update ProductProperties 
set ProductSerialNum=@ProductSerialNum
where AutoID = @AutoID

if @InstalledPath > ''
Update ProductProperties 
set InstalledPath=@InstalledPath
where AutoID = @AutoID

if @Language > ''
Update ProductProperties 
set Language=@Language
where AutoID = @AutoID

end


-- If the software table doesn't have an entry or this software, add one
IF NOT EXISTS (SELECT AutoID FROM Software WHERE ProductCode=@ProductCode)
BEGIN

	INSERT SOFTWARE 
		(ProductCode, SoftwareName, PackageName, PackDir,
		ProductCfgPath, ProductVersion, ProductFamily,
		Language, PlatformsSupported, PluginVer, TheTimestamp,
		RepositoryType, RepoFlag, SoftwareType)
	VALUES (@ProductCode, @ProductName, '' , '',
		'', @ProductVersion, @ProductFamily, 
		@Language, @PlatformsSupported, '', @@DBTS,
		'Products', 17, 0)

END




END

GO


------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [dbo].[EPOSP_UpdateProdPropFromEvents]
GO

if exists (select * from sysobjects where id = object_id(N'[EPOSP_UpdateProdPropFromEvents]') 
	and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure [EPOSP_UpdateProdPropFromEvents]
GO

-- Patch3 Update
CREATE PROCEDURE dbo.EPOSP_UpdateProdPropFromEvents
 @AgentGUID  uniqueidentifier,			-- matches leafnode.agentGUID
 @MACAddress NVARCHAR(50) = NULL,
 @ProductCode nvarchar(50),	-- matches productproperties.productcode
 @Type nvarchar(50),
 @Version nvarchar(50)

AS
BEGIN
SET XACT_ABORT ON
SET NOCOUNT ON

DECLARE @LeafNodeID INT
DECLARE @ProdPropID INT

SELECT TOP 1 @LeafNodeID = AutoID FROM LeafNode WHERE AgentGUID=@AgentGUID
IF (@LeafNodeID IS NOT NULL)
BEGIN
SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode

IF (@ProdPropID IS NULL)
BEGIN
	--Create prodprop entry
	INSERT INTO ProductProperties 
		(ParentID,ProductCode)
	VALUES
		(@LeafNodeID, @ProductCode)
	SELECT TOP 1 @ProdPropID = AutoID FROM ProductProperties WHERE ParentID = @LeafNodeID AND ProductCode=@ProductCode
END

IF (@ProdPropID IS NOT NULL)
BEGIN

if upper(@type) = 'INSTALL'
begin
	UPDATE ProductProperties 
		SET ProductVersion=@Version 
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szProductVer',
		'General',
		@Version
end
if upper(@type) = 'HOTFIX'
begin
	UPDATE ProductProperties 
		set Hotfix=@Version
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szHotfixVersion',
		'General',
		@Version
end
if upper(@type) = 'SERVICEPACK'
begin
	UPDATE ProductProperties 
		set Servicepack=@Version
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szServicePackVersion',
		'General',
		@Version
end
if upper(@type) = 'DAT'
begin
	UPDATE ProductProperties 
		set DATVer=@Version
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szDATVersion',
		'General',
		@Version
end
if upper(@type) = 'ENGINE'
begin
	UPDATE ProductProperties 
		set EngineVer=@Version
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szEngineVersion',
		'General',
		@Version
end
if upper(@type) = 'EXTRADAT'
begin
	UPDATE ProductProperties 
		set ExtraDatNames=@Version
		WHERE AutoID = @ProdPropID

	EXEC EPOSP_InsertProdSetting
		@ProdPropID,
		'szExtraDATNames',
		'General',
		@Version
end

END
END
END
GO


---------------------------------------------------------------------------------------
-- epo3.5 patch3: These routines are moved from aviprocedures so aviprocedures handles reporting only
--	Simplifies prp upgrading

/* Used by epo to get users topnode, pswd, & rootnode */
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetUserAccessData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetUserAccessData]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetUserAccessData
(
 @szEpoUserName  VARCHAR(100)
)
AS
BEGIN
 Declare @szRootNodeName VARCHAR(255)
 Declare @szUserTopNodeName VARCHAR(255)
 Declare @szUserPswd VARCHAR(255)
 Declare @iUserTopNodeID int
       Declare @iUserAccessMask int


 /* default settings for sql server login,  user root = root node. */
 SELECT @szRootNodeName = NodeName, @iUserTopNodeID = AutoID, @iUserAccessMask = 1, @szUserPswd = 0
  FROM BranchNode 
  WHERE Type=4;

 SELECT @iUserTopNodeID = RootNodeID, @iUserAccessMask = WriteAccess, @szUserPswd = Password
  FROM UserTable
  WHERE UserName = @szEpoUserName

 SELECT @szUserTopNodeName = NodeName
  FROM BranchNode 
  WHERE AutoID = @iUserTopNodeID;

 SELECT @szUserTopNodeName, @iUserTopNodeID, @iUserAccessMask, @szUserPswd, @szRootNodeName

END

GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetAllSubNodeIDs]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetAllSubNodeIDs]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetAllSubNodeIDs
(
    @iNameSpaceName  int,
    @iNameSpaceNode         int,
    @szEpoUserName           VARCHAR(100)
)

 AS
BEGIN
  /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 /* check the user has enough rights to see this data */
 DECLARE @iRightsCheckResult   INTEGER
 DECLARE @iFilterNode int
      
 /* @szNameSpaceName  is the top node of the users account*/
 /* @szNameSpaceNode  is a node within the users account that they may filter on */

 IF @iNameSpaceNode > 0
             select @iFilterNode = @iNameSpaceNode
       ELSE
            select @iFilterNode = @iNameSpaceName


/* EXECUTE @iRightsCheckResult=AVISP_VerifyNameSpaceRights @iNameSpaceName, @iNameSpaceNode, @szEpoUserName

 IF(@iRightsCheckResult=1)
*/
 BEGIN
  /* All sub nodes */
  SELECT EndAutoID as AutoID 
                   FROM BranchNodeEnum 
    WHERE StartAutoID =  @iFilterNode
  UNION 
  /* and the node it's self */
       SELECT @iFilterNode
 END
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetSQLServerTime]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetSQLServerTime]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_GetSQLServerTime
(
  @time DATETIME  OUTPUT
)
AS
BEGIN
 set @time = CURRENT_TIMESTAMP
 return 
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

--------------------------------------------------------------
-- actionable item routines

if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DeadAgentRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DeadAgentRemoval]
GO


CREATE PROCEDURE dbo.EPOSP_DeadAgentRemoval
(
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	SET ParentID=@DestID WHERE modifiedpropsdate<@TheDate

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateComputerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateComputerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateComputerRemoval
(
@StrNumDays	NVARCHAR(50),	
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

------------
-- postepo3 - cleanup temp tables

	IF EXISTS (select * from sysobjects where name = 'tmpDupComputers' 
   		and xtype = 'U')
  		DROP TABLE dbo.tmpDupComputers


	/* Find Duplicate Computers */

	SELECT 
		a.AutoID as AutoID
	INTO
		dbo.tmpDupComputers
	FROM
		LeafNode a, LeafNode b
	WHERE
		a.NodeName = b.NodeName
		and a.AutoID != b.AutoID
		and a.LastUpdate < b.LastUpdate
		and a.LastUpdate is not NULL
		and a.modifiedpropsdate<@TheDate


IF ('Delete'=@Action)
BEGIN
	-- Delete Computers that have not communicated since the date given
	DELETE leafnode
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
IF ('Move'=@Action)
BEGIN
	IF (EXISTS
		(SELECT TOP 1 AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)
		)
	   )	
	BEGIN
		-- The Dest BranchNode does exists, so get the ID	
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID IN 
			(SELECT TOP 1 AutoID FROM BranchNode WHERE Type=4)	
	END
	ELSE
	BEGIN
		-- The Dest BranchNode does not exists, so create it and get the ID
		SELECT TOP 1 @DirID=AutoID FROM BranchNode WHERE Type=4
		INSERT BranchNode (NodeName,Type,ParentID,PolicyTimestamp,TheTimestamp,TaskTimestamp)
			VALUES (@DestFolder,3,@DirID,@@DBTS,@@DBTS,@@DBTS)
		SELECT TOP 1 @DestID=AutoID FROM BranchNode WHERE NodeName=@DestFolder AND ParentID=@DirID		
	END

	-- Move the Computer Node
	UPDATE LeafNode	
		SET ParentID=@DestID 
		FROM  dbo.tmpDupComputers
		WHERE leafnode.AutoID = dbo.tmpDupComputers.AutoID

	Select @Action as Action, @@rowcount as 'Count'

END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END

	Drop Table dbo.tmpDupComputers

SET NOCOUNT OFF
END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_DuplicateScannerRemoval]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_DuplicateScannerRemoval]
GO

CREATE PROCEDURE dbo.EPOSP_DuplicateScannerRemoval
(
@Action 	NVARCHAR(50)	-- Values: Delete, Move
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format

/*
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)
*/

DECLARE @DestID INT
DECLARE @DirID INT


IF ('Delete'=@Action)
BEGIN
	-- Delete Duplicate Scanners
	delete from productproperties
	where autoid in
		(
		select min(productproperties.AutoID)
		from leafnode, productproperties,  aviview_software
		where leafnode.autoid = productproperties.parentid
		and productproperties.productcode = aviview_software.productcode
		and productfamily in ('tvd', 'tvd_nc')
		and DATVer != '5000'
		and productproperties.productcode != ''
		and aviview_software.productcode not like 'NMDASCAN%'
		and aviview_software.productcode not like 'GroupShield%'
		and aviview_software.productcode not like 'WebShield%'
		group by leafnode.nodename
		having count(*) > 1
		)

	Select @Action as Action, @@rowcount as 'Count'
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END

SET NOCOUNT OFF
END
GO




if exists (select * from sysobjects where id = object_id(N'[dbo].[EPOSP_RemoveDeadInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EPOSP_RemoveDeadInfo]
GO

CREATE PROCEDURE dbo.EPOSP_RemoveDeadInfo
(
@RuleName 	NVARCHAR(50),	-- Item to remove
@StrNumDays  	NVARCHAR(50),	-- Computers that have not communication for this interval wil be acted on
@Action 	NVARCHAR(50),	-- Values: Delete, Move
@DestFolder  	NVARCHAR(50) 	-- Place to move it to
)
AS
BEGIN
SET NOCOUNT ON

--Convert the Number of Days into the ePO date format
declare @CurrentDate smalldatetime
declare @OldDate smalldatetime
declare @TheDate NVARCHAR(20)
declare @NumDays INT

SET @NumDays=CONVERT(INT,@StrNumDays)
SET @CurrentDate=GETDATE()
SET @OldDate=DATEADD(day,-@NumDays,@CurrentDate)
SET @TheDate=CONVERT (NVARCHAR(20),@OldDate,112)


DECLARE @DestID INT
DECLARE @DirID INT

IF ('Inactive Agents'=@RuleName)
BEGIN
	EXECUTE EPOSP_DeadAgentRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Computers'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateComputerRemoval
		@StrNumDays  	
		, @Action 	
		, @DestFolder  	
END
ELSE
IF ('Duplicate Scanners'=@RuleName)
BEGIN
	EXECUTE EPOSP_DuplicateScannerRemoval
		@Action 	
END
ELSE
BEGIN
	Select 'No Action' as Action, 0 as 'Count'
END


SET NOCOUNT OFF
END
GO

--------------------------------------------------------------------
-- special test procedure: finds saved settings and returns value
-- used in testreporting stored procedure script
if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Count_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Count_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_Count_Orphaned_Events
AS
BEGIN

DECLARE @cnt int
Set @cnt = 0
DECLARE @cnt1 int
Set @cnt1 = 0

SELECT @cnt = count(Events.AutoID)
FROM dbo.Events
WHERE (dbo.Events.AgentGUID IS NULL) 
OR (dbo.Events.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

Update ProductEvents
Set NodeID = NULL
From Leafnode
WHERE 
 (dbo.ProductEvents.AgentGUID NOT IN 
(SELECT dbo.LeafNode.AgentGUID FROM dbo.LeafNode))

SELECT @cnt1 = count(*)
FROM dbo.ProductEvents
WHERE (dbo.ProductEvents.NodeID IS NULL) 

select @cnt + @cnt1 

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_FixUp_Orphaned_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_FixUp_Orphaned_Events]
GO

CREATE PROCEDURE dbo.AVISP_Util_FixUp_Orphaned_Events
--(
--	@blockstart int,
--	@blockend int
--)
AS
BEGIN

-- process the productevents table on the first time through
--if exists (select * from Events where %1 <= 1 or %1 = ( select min(autoid) from events ) )
UPDATE ProductEvents
SET ProductEvents.AgentGUID = LeafNode.AgentGUID,
	ProductEvents.NodeID = LeafNode.AutoID
FROM LeafNode, ComputerProperties
WHERE 
--	epo3.5 - Due to Netware multiple computername issue, always use LN.nodename for computername
	LeafNode.AutoID = ComputerProperties.ParentID
	AND ( ProductEvents.HostName = ComputerProperties.ComputerName or ProductEvents.HostName = LeafNode.NodeName )
     AND (ProductEvents.AgentGUID NOT IN 
		(SELECT AgentGUID FROM LeafNode) OR ProductEvents.AgentGUID IS NULL) 
--	 AND (ProductEvents.AutoID >= %1) AND (ProductEvents.AutoID <= %2)

END
go


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_Util_Remove_Events]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_Util_Remove_Events]
GO


CREATE PROCEDURE dbo.AVISP_Util_Remove_Events
(
	@Startdate DateTime,
	@Enddate DateTime
)
AS
BEGIN

-- process the productevents table on the first time through
DELETE FROM ProductEvents WHERE  (EventDateTime >= @Startdate) AND (EventDateTime <= @Enddate)

END
go

----------------------------
-- end of files moved from aviprocedures to make aviprocedures reporting only



---------------------------
-- epo3.5 fix scripts

-- remove tmp tables before load procedures - make sure tmp table problem is gone
begin 
Declare @tmptblowner varchar(100) 
Declare @tmptblname varchar(100) 
Declare @drop varchar(250) 
DECLARE TmpTblName_cursor CURSOR FOR 
select sysusers.name, sysobjects.name 
        from sysobjects, sysusers 
        where sysobjects.name like 'tmp%' 
        and xtype = 'U' 
        and sysobjects.uid = sysusers.uid 

OPEN TmpTblName_cursor 

FETCH NEXT FROM TmpTblName_cursor 
into @tmptblowner, @tmptblname 
WHILE @@FETCH_STATUS = 0 
BEGIN 
        Set @drop = 'Drop table ' + @tmptblowner + '.' + @tmptblname 
        execute (@drop) 
        FETCH NEXT FROM TmpTblName_cursor 
        into @tmptblowner, @tmptblname 

end 
CLOSE TmpTblName_cursor 
DEALLOCATE TmpTblName_cursor 
end 
go 



-------------------

------ end



 