/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db;

import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DbConnectionPool;
import com.nai.mcafee.common.db.Queries;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class DatabaseTestSetup {
    private static DatabaseTestSetup m_instance;
    private boolean m_setup = false;
    private boolean m_dbTestsEnabled = false;
    private Database m_db;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$common$db$DatabaseTestSetup;

    public String getValidationQuery() {
        return Queries.VALIDATE_EPO_DB;
    }

    public String getConfigFilename() {
        return "DbTestConfig.properties";
    }

    public String name() {
        return "EPO";
    }

    protected void additionalSetup(Properties properties) throws Exception {
    }

    protected void additionalCleanup() {
    }

    public boolean testSchemaVersion(Test test, TestResult testResult) {
        return true;
    }

    public static final synchronized DatabaseTestSetup instance() {
        if (m_instance == null) {
            m_instance = new DatabaseTestSetup();
        }
        return m_instance;
    }

    public static final synchronized void setInstance(DatabaseTestSetup databaseTestSetup) {
        m_instance = databaseTestSetup;
    }

    public void setup() throws Exception {
        Properties properties = this.loadProperties();
        this.m_dbTestsEnabled = this.getString(properties, "db.enabled").equals("true");
        this.m_db = Database.createFromPropertiesFile(properties, this.name(), this.getValidationQuery());
        int n = DbConnectionPool.stringTojdbcDriver(this.getString(properties, "db.jdbc.driver"));
        System.out.println("Using database driver:" + DbConnectionPool.jdbcDriverAsString(n));
        this.additionalSetup(properties);
        this.m_setup = true;
    }

    public void cleanup() {
        this.additionalCleanup();
        if (this.m_db != null) {
            this.m_db.close();
            this.m_db = null;
        }
        this.m_setup = false;
    }

    public void ensureAllConnectionsClosed(Test test, TestResult testResult) {
        this.ensureAllConnectionsClosed(this.name(), this.getDatabase(), test, testResult);
    }

    protected void ensureAllConnectionsClosed(String string, Database database, Test test, TestResult testResult) {
        if (database.getPool().getNumBorrowed() != database.getPool().getNumReturned()) {
            testResult.addFailure(test, new AssertionFailedError(string + " db had " + database.getPool().getNumBorrowed() + " borrows and " + database.getPool().getNumReturned() + " returns"));
        }
    }

    public Connection getConnection() throws SQLException {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_db.getConnection();
    }

    public Database getDatabase() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_db;
    }

    public boolean areDbTestsEnabled() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_dbTestsEnabled;
    }

    protected String getString(Properties properties, String string) throws Exception {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            throw new Exception("Config file " + this.getConfigFilename() + " missing required key:" + string);
        }
        return string2.trim();
    }

    private static final String getString(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(this.getClass().getClassLoader().getResourceAsStream(this.getConfigFilename()));
        return properties;
    }

    public boolean isSetup() {
        return this.m_setup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$common$db$DatabaseTestSetup == null ? (class$com$nai$mcafee$common$db$DatabaseTestSetup = DatabaseTestSetup.class$("com.nai.mcafee.common.db.DatabaseTestSetup")) : class$com$nai$mcafee$common$db$DatabaseTestSetup).desiredAssertionStatus();
        m_instance = null;
    }
}

