/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db.epo;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.epo.EpoPassword;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public class EpoUser
extends DatabaseObject
implements HttpSessionBindingListener {
    private static Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$common$db$epo$EpoUser == null ? (class$com$nai$mcafee$common$db$epo$EpoUser = EpoUser.class$("com.nai.mcafee.common.db.epo.EpoUser")) : class$com$nai$mcafee$common$db$epo$EpoUser));
    public static final String TABLE_NAME = "UserTable";
    public static final int COL_ID = 1;
    public static final int COL_USERNAME = 2;
    public static final int COL_PASSWORD = 3;
    public static final int COL_TIMESTAMP = 4;
    public static final int COL_HIDDENTIMESTAMP = 5;
    public static final int COL_ROOT_NODE_ID = 6;
    public static final int COL_WRITE_ACCESS = 7;
    public static final int NUM_COLS = 7;
    public static final int NUM_PROPERTIES = 8;
    public static final String[] PROPERTY_NAMES = new String[]{"AutoId", "UserName", "Password", "TheTimestamp", "TheHiddenTimestamp", "RootNodeId", "WriteAccess", "LanguageId"};
    protected static final String UNIQUE_SQL = "select * from UserTable where AutoId=?";
    protected static final String SQL_SELECT_BY_NAME = "select * from UserTable where UserName=?";
    protected static final String SQL_SELECT_WRITER = "select top 1 * from UserTable where WriteAccess=1";
    private boolean m_embedded = false;
    private boolean m_valid = false;
    private long m_id = -1L;
    private String m_username = "";
    private String m_password = "";
    private byte[] m_timestamp = null;
    private byte[] m_htimestamp = null;
    private Long m_rootNode = null;
    private Boolean m_writeAccess = null;
    private long m_lastComm = 0L;
    private String m_langId = null;
    private static HashMap m_sessionBindings = new HashMap();
    static /* synthetic */ Class class$com$nai$mcafee$common$db$epo$EpoUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EpoUser getByName(Connection connection, String string) throws SQLException {
        Vector vector;
        PreparedStatement preparedStatement;
        EpoUser epoUser;
        block7: {
            block6: {
                EpoUser epoUser2;
                if (string == null) {
                    return null;
                }
                epoUser = null;
                preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(SQL_SELECT_BY_NAME);
                    preparedStatement.setString(1, string);
                    vector = DatabaseObject.getByQuery(connection, preparedStatement, class$com$nai$mcafee$common$db$epo$EpoUser == null ? (class$com$nai$mcafee$common$db$epo$EpoUser = EpoUser.class$("com.nai.mcafee.common.db.epo.EpoUser")) : class$com$nai$mcafee$common$db$epo$EpoUser, 1, -1);
                    if (vector != null) break block6;
                    epoUser2 = null;
                    Object var8_6 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    DatabaseUtil.close(preparedStatement);
                    throw throwable;
                }
                DatabaseUtil.close(preparedStatement);
                return epoUser2;
            }
            if (vector.size() != 0) break block7;
            EpoUser epoUser3 = null;
            Object var8_7 = null;
            DatabaseUtil.close(preparedStatement);
            return epoUser3;
        }
        if (vector.size() > 1) {
            throw new SQLException("User query returned more than one result.");
        }
        epoUser = (EpoUser)vector.firstElement();
        Object var8_8 = null;
        DatabaseUtil.close(preparedStatement);
        return epoUser;
    }

    public static final EpoUser getNonReviewer(Connection connection) throws SQLException {
        Vector vector = DatabaseObject.getByQuery(connection, SQL_SELECT_WRITER, class$com$nai$mcafee$common$db$epo$EpoUser == null ? (class$com$nai$mcafee$common$db$epo$EpoUser = EpoUser.class$("com.nai.mcafee.common.db.epo.EpoUser")) : class$com$nai$mcafee$common$db$epo$EpoUser);
        if (vector.size() < 1) {
            throw new SQLException("Internal error: EpoUser.getNonReviewer returned zero rows");
        }
        return (EpoUser)vector.get(0);
    }

    public int getNumColumns() {
        return 7;
    }

    public int getNumProperties() {
        return 8;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public String getUniqueQuerySql() {
        return UNIQUE_SQL;
    }

    public String getInsertSql() {
        return "insert into UserTable(UserName, Password, TheTimestamp, RootNodeId, WriteAccess) values(?,?,@@DBTS,?,?)";
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.m_username);
        preparedStatement.setString(2, this.m_password);
        if (this.m_rootNode != null) {
            preparedStatement.setLong(3, this.m_rootNode);
        } else {
            preparedStatement.setNull(3, -5);
        }
        if (this.m_writeAccess != null) {
            preparedStatement.setBoolean(4, this.m_writeAccess);
        } else {
            preparedStatement.setNull(4, -7);
        }
    }

    public String getUpdateSql() {
        return "update UserTable set UserName=?, Password=?, TheTimestamp=@@DBTS, RootNodeId=?, WriteAccess=? where AutoId=?";
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        preparedStatement.setLong(5, this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setAutoId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_username = resultSet.getString(2);
        this.m_password = resultSet.getString(3);
        this.m_timestamp = resultSet.getBytes(4);
        this.m_htimestamp = resultSet.getBytes(5);
        this.m_rootNode = this.getLong(resultSet, 6);
        this.m_writeAccess = this.getBoolean(resultSet, 7);
    }

    public EpoUser() {
    }

    public EpoUser(String string, String string2) {
        this.m_username = string;
        this.m_password = string2;
    }

    public final boolean validateLogin(String string) throws Exception {
        String string2 = EpoPassword.hashAndBase64Passphrase(this.m_username, string);
        if (!string2.equals(this.m_password)) {
            return false;
        }
        this.m_valid = true;
        return true;
    }

    public final boolean isSiteAccount() {
        if (this.m_rootNode == null) {
            return false;
        }
        return this.m_rootNode != 0L;
    }

    public final boolean isReviewer() {
        if (this.m_writeAccess == null) {
            return false;
        }
        return this.m_writeAccess == false;
    }

    public final boolean isGlobalAdmin() {
        return !this.isSiteAccount() && !this.isReviewer();
    }

    public boolean isAuthenticated() {
        return this.m_valid;
    }

    public boolean isAdminForThisSite(long l) {
        if (this.isSiteAccount()) {
            return l == this.getRootNodeId();
        }
        return true;
    }

    public void logout() {
        this.m_valid = false;
        this.m_embedded = false;
        this.m_password = "";
    }

    public long getAutoId() {
        return this.m_id;
    }

    public void setAutoId(long l) {
        this.m_id = l;
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setUserName(String string) {
        this.m_username = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public byte[] getTheTimestamp() {
        return this.m_timestamp;
    }

    public void setTheTimestamp(byte[] byArray) {
        this.m_timestamp = byArray;
    }

    public byte[] getTheHiddenTimestamp() {
        return this.m_htimestamp;
    }

    public void setTheHiddenTimestamp(byte[] byArray) {
        this.m_htimestamp = byArray;
    }

    public Long getRootNodeId() {
        return this.m_rootNode;
    }

    public void setRootNodeId(Long l) {
        this.m_rootNode = l;
    }

    public Boolean getWriteAccess() {
        return this.m_writeAccess;
    }

    public void setWriteAccess(Boolean bl) {
        this.m_writeAccess = bl;
    }

    public void setEmbedded(boolean bl) {
        this.m_embedded = bl;
    }

    public boolean getEmbedded() {
        return this.m_embedded;
    }

    public long getLastComm() {
        return this.m_lastComm;
    }

    public void setLastComm(long l) {
        this.m_lastComm = l;
    }

    public String getLanguageId() {
        return this.m_langId;
    }

    public void setLanguageId(String string) {
        this.m_langId = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        HttpSession httpSession = httpSessionBindingEvent.getSession();
        String string = httpSession.getId();
        m_log.debug((Object)("Binding login to session: " + string));
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            m_sessionBindings.put(string, httpSessionBindingEvent.getValue());
        }
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EpoUser getFromInternalSessionMap(String string) {
        m_log.debug((Object)"Getting the EpoUser from internal session mappings.");
        EpoUser epoUser = null;
        HashMap hashMap = m_sessionBindings;
        synchronized (hashMap) {
            epoUser = (EpoUser)m_sessionBindings.get(string);
            if (epoUser != null) {
                m_log.debug((Object)("Found login information for user " + epoUser.getUserName() + " in session " + string));
            } else {
                m_log.debug((Object)("Couldn't find login information for session " + string));
            }
        }
        return epoUser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

