/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.sql.SQLException;

public class MSSqlServerInfo {
    private int m_numRetries = 3;
    private int m_timeout = 2000;
    private String[] m_serverInfoStrings = null;

    public void getInfo(String string) throws SQLException {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            DatagramSocket datagramSocket = new DatagramSocket();
            byte[] byArray = new byte[]{2};
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 1434);
            datagramSocket.send(datagramPacket);
            byte[] byArray2 = new byte[2048];
            datagramPacket = new DatagramPacket(byArray2, byArray2.length);
            datagramSocket.setSoTimeout(this.m_timeout);
            int n = 0;
            while (n < this.m_numRetries) {
                try {
                    datagramSocket.receive(datagramPacket);
                    String string2 = MSSqlServerInfo.extractString(byArray2, datagramPacket.getLength());
                    this.m_serverInfoStrings = string2.split(";");
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException("Unable to get info from SQL Server:" + string);
            sQLException.initCause(exception);
            throw sQLException;
        }
        throw new SQLException("Unable to get info from SQL Server:" + string);
    }

    public int getPortForInstance(String string) {
        if (this.m_serverInfoStrings == null) {
            return -1;
        }
        if (string == null || string.length() == 0) {
            string = "MSSQLSERVER";
        }
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < this.m_serverInfoStrings.length) {
            if (this.m_serverInfoStrings[n].length() == 0) {
                string2 = null;
                string3 = null;
            } else {
                String string4 = this.m_serverInfoStrings[n];
                String string5 = "";
                if (++n < this.m_serverInfoStrings.length) {
                    string5 = this.m_serverInfoStrings[n];
                }
                if (string4.equals("InstanceName")) {
                    string2 = string5;
                }
                if (string4.equals("tcp")) {
                    string3 = string5;
                }
                if (string2 != null && string3 != null && string2.equalsIgnoreCase(string)) {
                    return Integer.parseInt(string3);
                }
            }
            ++n;
        }
        return -1;
    }

    private static final String extractString(byte[] byArray, int n) throws IOException {
        return new String(byArray, 3, n - 3);
    }
}

