/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.db;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.ToolInstance;
import com.nai.mcafee.common.util.StringUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Tool
extends DatabaseObject
implements Serializable {
    public static final int COL_ID = 1;
    public static final int COL_EXE_NAME = 2;
    public static final int COL_DISP_NAME = 3;
    public static final int COL_CMD_LINE = 4;
    public static final int COL_APP_ASSOCIATION = 5;
    public static final int NUM_COLUMNS = 5;
    public static final int APP_SNOWCAP = 1;
    public static final int APP_ALERTING = 2;
    public static final int MAX_LEN_EXE_NAME = 255;
    public static final int MAX_LEN_DISP_NAME = 255;
    public static final int MAX_LEN_CMD_LINE = 255;
    public static final int INVALID_ID = -1;
    private static final String[] PROPERTY_NAMES = new String[]{"ToolId", "ExeName", "DisplayName", "CmdLine", "AppAssociation"};
    public static final String TABLE_NAME = "Tools";
    private int m_id = -1;
    private String m_exeName = "";
    private String m_displayName = "";
    private String m_cmdLine = "";
    private int m_appAssoc = 1;
    static /* synthetic */ Class class$com$nai$mcafee$common$db$Tool;

    public String getInsertSql() {
        return "insert into Tools values (?,?,?,?)";
    }

    public String getUpdateSql() {
        return "update Tools set ExeName=?, DisplayName=?, CmdLine=?, AppAssociation=?  where ToolID=? ";
    }

    public int lookupIdForTool(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select ToolID from Tools where ExeName=? AND CmdLine=? AND AppAssociation=?";
        preparedStatement = connection.prepareStatement(string);
        preparedStatement.setString(1, this.m_exeName);
        preparedStatement.setString(2, this.m_cmdLine);
        preparedStatement.setInt(3, this.m_appAssoc);
        resultSet = preparedStatement.executeQuery();
        if (resultSet != null && resultSet.next()) {
            return resultSet.getInt(1);
        }
        return -1;
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam(preparedStatement, 1, StringUtil.escapeSql(this.m_exeName), 255);
        DatabaseObject.setParam(preparedStatement, 2, StringUtil.escapeSql(this.m_displayName), 255);
        DatabaseObject.setParam(preparedStatement, 3, StringUtil.escapeSql(this.m_cmdLine), 255);
        DatabaseObject.setParam(preparedStatement, 4, this.m_appAssoc);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam(preparedStatement, 5, this.m_id);
    }

    public static final Tool[] getAll(Connection connection, int n) throws SQLException {
        Vector vector = DatabaseObject.getByQuery(connection, "select * from Tools where AppAssociation=" + n, class$com$nai$mcafee$common$db$Tool == null ? (class$com$nai$mcafee$common$db$Tool = Tool.class$("com.nai.mcafee.common.db.Tool")) : class$com$nai$mcafee$common$db$Tool);
        Tool[] toolArray = new Tool[]{};
        toolArray = vector.toArray(toolArray);
        return toolArray;
    }

    public static final Tool getByID(Connection connection, int n) throws SQLException {
        Vector vector = DatabaseObject.getByQuery(connection, "select * from Tools where ToolID = '" + n + "'", class$com$nai$mcafee$common$db$Tool == null ? (class$com$nai$mcafee$common$db$Tool = Tool.class$("com.nai.mcafee.common.db.Tool")) : class$com$nai$mcafee$common$db$Tool);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() > 1) {
            throw new SQLException("Tool.getByID() returned >1 row!");
        }
        return (Tool)vector.get(0);
    }

    public static final void deleteFromDatabase(Connection connection, int n) throws SQLException {
        DatabaseUtil.executeUpdate(connection, "delete from Tools where ToolID='" + n + "'");
    }

    public String toString() {
        return ToolInstance.getExeCommand(this.m_exeName) + " " + this.m_cmdLine;
    }

    public String getUniqueQuerySql() {
        return "select * from Tools where ToolID = ?";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setInt(1, this.getId());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.m_exeName = StringUtil.unescapeSql(resultSet.getString(2));
        this.m_displayName = StringUtil.unescapeSql(resultSet.getString(3));
        this.m_cmdLine = StringUtil.unescapeSql(resultSet.getString(4));
    }

    public int getNumPoperties() {
        return PROPERTY_NAMES.length;
    }

    public int getNumColumns() {
        return 5;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public String getExeName() {
        return this.m_exeName;
    }

    public void setExeName(String string) {
        this.m_exeName = string;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String string) {
        this.m_displayName = string;
    }

    public String getCmdLine() {
        return this.m_cmdLine;
    }

    public void setCmdLine(String string) {
        this.m_cmdLine = string;
    }

    public int getAppAssociation() {
        return this.m_appAssoc;
    }

    public void setAppAssociation(int n) {
        this.m_appAssoc = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

